# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCommunicationsGatewayResult',
    'AwaitableGetCommunicationsGatewayResult',
    'get_communications_gateway',
    'get_communications_gateway_output',
]

@pulumi.output_type
class GetCommunicationsGatewayResult:
    """
    A CommunicationsGateway resource
    """
    def __init__(__self__, api_bridge=None, codecs=None, connectivity=None, e911_type=None, id=None, location=None, name=None, platforms=None, provisioning_state=None, service_locations=None, status=None, system_data=None, tags=None, type=None):
        if api_bridge and not isinstance(api_bridge, dict):
            raise TypeError("Expected argument 'api_bridge' to be a dict")
        pulumi.set(__self__, "api_bridge", api_bridge)
        if codecs and not isinstance(codecs, list):
            raise TypeError("Expected argument 'codecs' to be a list")
        pulumi.set(__self__, "codecs", codecs)
        if connectivity and not isinstance(connectivity, str):
            raise TypeError("Expected argument 'connectivity' to be a str")
        pulumi.set(__self__, "connectivity", connectivity)
        if e911_type and not isinstance(e911_type, str):
            raise TypeError("Expected argument 'e911_type' to be a str")
        pulumi.set(__self__, "e911_type", e911_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if platforms and not isinstance(platforms, list):
            raise TypeError("Expected argument 'platforms' to be a list")
        pulumi.set(__self__, "platforms", platforms)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if service_locations and not isinstance(service_locations, list):
            raise TypeError("Expected argument 'service_locations' to be a list")
        pulumi.set(__self__, "service_locations", service_locations)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="apiBridge")
    def api_bridge(self) -> Optional[Any]:
        """
        Details of API bridge functionality, if required
        """
        return pulumi.get(self, "api_bridge")

    @property
    @pulumi.getter
    def codecs(self) -> Sequence[str]:
        """
        Voice codecs to support
        """
        return pulumi.get(self, "codecs")

    @property
    @pulumi.getter
    def connectivity(self) -> str:
        """
        How to connect back to the operator network, e.g. MAPS
        """
        return pulumi.get(self, "connectivity")

    @property
    @pulumi.getter(name="e911Type")
    def e911_type(self) -> str:
        """
        How to handle 911 calls
        """
        return pulumi.get(self, "e911_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def platforms(self) -> Sequence[str]:
        """
        What platforms to support
        """
        return pulumi.get(self, "platforms")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Resource provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="serviceLocations")
    def service_locations(self) -> Sequence['outputs.ServiceRegionPropertiesResponse']:
        """
        The regions in which to deploy the resources needed for Teams Calling
        """
        return pulumi.get(self, "service_locations")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the deployment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetCommunicationsGatewayResult(GetCommunicationsGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCommunicationsGatewayResult(
            api_bridge=self.api_bridge,
            codecs=self.codecs,
            connectivity=self.connectivity,
            e911_type=self.e911_type,
            id=self.id,
            location=self.location,
            name=self.name,
            platforms=self.platforms,
            provisioning_state=self.provisioning_state,
            service_locations=self.service_locations,
            status=self.status,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_communications_gateway(communications_gateway_name: Optional[str] = None,
                               resource_group_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCommunicationsGatewayResult:
    """
    A CommunicationsGateway resource


    :param str communications_gateway_name: Unique identifier for this deployment
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['communicationsGatewayName'] = communications_gateway_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:voiceservices/v20221201preview:getCommunicationsGateway', __args__, opts=opts, typ=GetCommunicationsGatewayResult).value

    return AwaitableGetCommunicationsGatewayResult(
        api_bridge=__ret__.api_bridge,
        codecs=__ret__.codecs,
        connectivity=__ret__.connectivity,
        e911_type=__ret__.e911_type,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        platforms=__ret__.platforms,
        provisioning_state=__ret__.provisioning_state,
        service_locations=__ret__.service_locations,
        status=__ret__.status,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_communications_gateway)
def get_communications_gateway_output(communications_gateway_name: Optional[pulumi.Input[str]] = None,
                                      resource_group_name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCommunicationsGatewayResult]:
    """
    A CommunicationsGateway resource


    :param str communications_gateway_name: Unique identifier for this deployment
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
