# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AggregateFunctionPropertiesArgs',
    'AvroSerializationArgs',
    'AzureDataLakeStoreOutputDataSourceArgs',
    'AzureFunctionOutputDataSourceArgs',
    'AzureMachineLearningServiceFunctionBindingArgs',
    'AzureMachineLearningServiceInputColumnArgs',
    'AzureMachineLearningServiceOutputColumnArgs',
    'AzureMachineLearningStudioFunctionBindingArgs',
    'AzureMachineLearningStudioInputColumnArgs',
    'AzureMachineLearningStudioInputsArgs',
    'AzureMachineLearningStudioOutputColumnArgs',
    'AzureSqlDatabaseOutputDataSourceArgs',
    'AzureSqlReferenceInputDataSourcePropertiesArgs',
    'AzureSqlReferenceInputDataSourceArgs',
    'AzureSynapseOutputDataSourceArgs',
    'AzureTableOutputDataSourceArgs',
    'BlobOutputDataSourceArgs',
    'BlobReferenceInputDataSourceArgs',
    'BlobStreamInputDataSourceArgs',
    'CSharpFunctionBindingArgs',
    'ClusterInfoArgs',
    'CompressionArgs',
    'CsvSerializationArgs',
    'CustomClrSerializationArgs',
    'DocumentDbOutputDataSourceArgs',
    'EventHubOutputDataSourceArgs',
    'EventHubStreamInputDataSourceArgs',
    'EventHubV2OutputDataSourceArgs',
    'EventHubV2StreamInputDataSourceArgs',
    'ExternalArgs',
    'FunctionInputArgs',
    'FunctionOutputArgs',
    'FunctionArgs',
    'IdentityArgs',
    'InputArgs',
    'IoTHubStreamInputDataSourceArgs',
    'JavaScriptFunctionBindingArgs',
    'JobStorageAccountArgs',
    'JsonSerializationArgs',
    'OutputArgs',
    'ParquetSerializationArgs',
    'PowerBIOutputDataSourceArgs',
    'RawOutputDatasourceArgs',
    'RawReferenceInputDataSourceArgs',
    'RawStreamInputDataSourceArgs',
    'ReferenceInputPropertiesArgs',
    'ScalarFunctionPropertiesArgs',
    'ServiceBusQueueOutputDataSourceArgs',
    'ServiceBusTopicOutputDataSourceArgs',
    'StorageAccountArgs',
    'StreamInputPropertiesArgs',
    'StreamingJobSkuArgs',
    'TransformationArgs',
]

@pulumi.input_type
class AggregateFunctionPropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 binding: Optional[pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionInputArgs']]]] = None,
                 output: Optional[pulumi.Input['FunctionOutputArgs']] = None):
        """
        The properties that are associated with an aggregate function.
        :param pulumi.Input[str] type: Indicates the type of function.
               Expected value is 'Aggregate'.
        :param pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']] binding: The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        :param pulumi.Input['FunctionOutputArgs'] output: Describes the output of a function.
        """
        pulumi.set(__self__, "type", 'Aggregate')
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if output is not None:
            pulumi.set(__self__, "output", output)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of function.
        Expected value is 'Aggregate'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def binding(self) -> Optional[pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']]]:
        """
        The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        """
        return pulumi.get(self, "binding")

    @binding.setter
    def binding(self, value: Optional[pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']]]):
        pulumi.set(self, "binding", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionInputArgs']]]]:
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionInputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['FunctionOutputArgs']]:
        """
        Describes the output of a function.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['FunctionOutputArgs']]):
        pulumi.set(self, "output", value)


@pulumi.input_type
class AvroSerializationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in Avro format.
        :param pulumi.Input[str] type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Avro'.
        """
        pulumi.set(__self__, "type", 'Avro')

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Avro'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class AzureDataLakeStoreOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 account_name: Optional[pulumi.Input[str]] = None,
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 file_path_prefix: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 token_user_display_name: Optional[pulumi.Input[str]] = None,
                 token_user_principal_name: Optional[pulumi.Input[str]] = None):
        """
        Describes an Azure Data Lake Store output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.DataLake/Accounts'.
        :param pulumi.Input[str] account_name: The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[str] date_format: The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
        :param pulumi.Input[str] file_path_prefix: The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] refresh_token: A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] time_format: The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
        :param pulumi.Input[str] token_user_display_name: The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        :param pulumi.Input[str] token_user_principal_name: The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        pulumi.set(__self__, "type", 'Microsoft.DataLake/Accounts')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if file_path_prefix is not None:
            pulumi.set(__self__, "file_path_prefix", file_path_prefix)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if token_user_display_name is not None:
            pulumi.set(__self__, "token_user_display_name", token_user_display_name)
        if token_user_principal_name is not None:
            pulumi.set(__self__, "token_user_principal_name", token_user_principal_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.DataLake/Accounts'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter(name="filePathPrefix")
    def file_path_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "file_path_prefix")

    @file_path_prefix.setter
    def file_path_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path_prefix", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="tokenUserDisplayName")
    def token_user_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_display_name")

    @token_user_display_name.setter
    def token_user_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_user_display_name", value)

    @property
    @pulumi.getter(name="tokenUserPrincipalName")
    def token_user_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_principal_name")

    @token_user_principal_name.setter
    def token_user_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_user_principal_name", value)


@pulumi.input_type
class AzureFunctionOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 api_key: Optional[pulumi.Input[str]] = None,
                 function_app_name: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 max_batch_count: Optional[pulumi.Input[float]] = None,
                 max_batch_size: Optional[pulumi.Input[float]] = None):
        """
        Defines the metadata of AzureFunctionOutputDataSource
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.AzureFunction'.
        :param pulumi.Input[str] api_key: If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
        :param pulumi.Input[str] function_app_name: The name of your Azure Functions app.
        :param pulumi.Input[str] function_name: The name of the function in your Azure Functions app.
        :param pulumi.Input[float] max_batch_count: A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default value is 100.
        :param pulumi.Input[float] max_batch_size: A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit is in bytes. By default, this value is 262,144 bytes (256 KB).
        """
        pulumi.set(__self__, "type", 'Microsoft.AzureFunction')
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if function_app_name is not None:
            pulumi.set(__self__, "function_app_name", function_app_name)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if max_batch_count is not None:
            pulumi.set(__self__, "max_batch_count", max_batch_count)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.AzureFunction'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="functionAppName")
    def function_app_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of your Azure Functions app.
        """
        return pulumi.get(self, "function_app_name")

    @function_app_name.setter
    def function_app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_app_name", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the function in your Azure Functions app.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="maxBatchCount")
    def max_batch_count(self) -> Optional[pulumi.Input[float]]:
        """
        A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default value is 100.
        """
        return pulumi.get(self, "max_batch_count")

    @max_batch_count.setter
    def max_batch_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_batch_count", value)

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[pulumi.Input[float]]:
        """
        A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit is in bytes. By default, this value is 262,144 bytes (256 KB).
        """
        return pulumi.get(self, "max_batch_size")

    @max_batch_size.setter
    def max_batch_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_batch_size", value)


@pulumi.input_type
class AzureMachineLearningServiceFunctionBindingArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 api_key: Optional[pulumi.Input[str]] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceInputColumnArgs']]]] = None,
                 number_of_parallel_requests: Optional[pulumi.Input[int]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceOutputColumnArgs']]]] = None):
        """
        The binding to an Azure Machine Learning web service.
        :param pulumi.Input[str] type: Indicates the function binding type.
               Expected value is 'Microsoft.MachineLearningServices'.
        :param pulumi.Input[str] api_key: The API key used to authenticate with Request-Response endpoint.
        :param pulumi.Input[int] batch_size: Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
        :param pulumi.Input[str] endpoint: The Request-Response execute endpoint of the Azure Machine Learning web service.
        :param pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceInputColumnArgs']]] inputs: The inputs for the Azure Machine Learning web service endpoint.
        :param pulumi.Input[int] number_of_parallel_requests: The number of parallel requests that will be sent per partition of your job to the machine learning service. Default is 1.
        :param pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceOutputColumnArgs']]] outputs: A list of outputs from the Azure Machine Learning web service endpoint execution.
        """
        pulumi.set(__self__, "type", 'Microsoft.MachineLearningServices')
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if number_of_parallel_requests is not None:
            pulumi.set(__self__, "number_of_parallel_requests", number_of_parallel_requests)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the function binding type.
        Expected value is 'Microsoft.MachineLearningServices'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        The API key used to authenticate with Request-Response endpoint.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The Request-Response execute endpoint of the Azure Machine Learning web service.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceInputColumnArgs']]]]:
        """
        The inputs for the Azure Machine Learning web service endpoint.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceInputColumnArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter(name="numberOfParallelRequests")
    def number_of_parallel_requests(self) -> Optional[pulumi.Input[int]]:
        """
        The number of parallel requests that will be sent per partition of your job to the machine learning service. Default is 1.
        """
        return pulumi.get(self, "number_of_parallel_requests")

    @number_of_parallel_requests.setter
    def number_of_parallel_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_parallel_requests", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceOutputColumnArgs']]]]:
        """
        A list of outputs from the Azure Machine Learning web service endpoint execution.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningServiceOutputColumnArgs']]]]):
        pulumi.set(self, "outputs", value)


@pulumi.input_type
class AzureMachineLearningServiceInputColumnArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 map_to: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Describes an input column for the Azure Machine Learning web service endpoint.
        :param pulumi.Input[str] data_type: The (Azure Machine Learning supported) data type of the input column.
        :param pulumi.Input[int] map_to: The zero based index of the function parameter this input maps to.
        :param pulumi.Input[str] name: The name of the input column.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if map_to is not None:
            pulumi.set(__self__, "map_to", map_to)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The (Azure Machine Learning supported) data type of the input column.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="mapTo")
    def map_to(self) -> Optional[pulumi.Input[int]]:
        """
        The zero based index of the function parameter this input maps to.
        """
        return pulumi.get(self, "map_to")

    @map_to.setter
    def map_to(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "map_to", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the input column.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureMachineLearningServiceOutputColumnArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 map_to: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Describes an output column for the Azure Machine Learning web service endpoint.
        :param pulumi.Input[str] data_type: The (Azure Machine Learning supported) data type of the output column.
        :param pulumi.Input[int] map_to: The zero based index of the function parameter this input maps to.
        :param pulumi.Input[str] name: The name of the output column.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if map_to is not None:
            pulumi.set(__self__, "map_to", map_to)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The (Azure Machine Learning supported) data type of the output column.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="mapTo")
    def map_to(self) -> Optional[pulumi.Input[int]]:
        """
        The zero based index of the function parameter this input maps to.
        """
        return pulumi.get(self, "map_to")

    @map_to.setter
    def map_to(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "map_to", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the output column.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureMachineLearningStudioFunctionBindingArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 api_key: Optional[pulumi.Input[str]] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 inputs: Optional[pulumi.Input['AzureMachineLearningStudioInputsArgs']] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioOutputColumnArgs']]]] = None):
        """
        The binding to an Azure Machine Learning Studio.
        :param pulumi.Input[str] type: Indicates the function binding type.
               Expected value is 'Microsoft.MachineLearning/WebService'.
        :param pulumi.Input[str] api_key: The API key used to authenticate with Request-Response endpoint.
        :param pulumi.Input[int] batch_size: Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
        :param pulumi.Input[str] endpoint: The Request-Response execute endpoint of the Azure Machine Learning Studio. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
        :param pulumi.Input['AzureMachineLearningStudioInputsArgs'] inputs: The inputs for the Azure Machine Learning Studio endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioOutputColumnArgs']]] outputs: A list of outputs from the Azure Machine Learning Studio endpoint execution.
        """
        pulumi.set(__self__, "type", 'Microsoft.MachineLearning/WebService')
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the function binding type.
        Expected value is 'Microsoft.MachineLearning/WebService'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        The API key used to authenticate with Request-Response endpoint.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The Request-Response execute endpoint of the Azure Machine Learning Studio. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input['AzureMachineLearningStudioInputsArgs']]:
        """
        The inputs for the Azure Machine Learning Studio endpoint.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input['AzureMachineLearningStudioInputsArgs']]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioOutputColumnArgs']]]]:
        """
        A list of outputs from the Azure Machine Learning Studio endpoint execution.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioOutputColumnArgs']]]]):
        pulumi.set(self, "outputs", value)


@pulumi.input_type
class AzureMachineLearningStudioInputColumnArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 map_to: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Describes an input column for the Azure Machine Learning Studio endpoint.
        :param pulumi.Input[str] data_type: The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        :param pulumi.Input[int] map_to: The zero based index of the function parameter this input maps to.
        :param pulumi.Input[str] name: The name of the input column.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if map_to is not None:
            pulumi.set(__self__, "map_to", map_to)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="mapTo")
    def map_to(self) -> Optional[pulumi.Input[int]]:
        """
        The zero based index of the function parameter this input maps to.
        """
        return pulumi.get(self, "map_to")

    @map_to.setter
    def map_to(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "map_to", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the input column.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureMachineLearningStudioInputsArgs:
    def __init__(__self__, *,
                 column_names: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioInputColumnArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The inputs for the Azure Machine Learning Studio endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioInputColumnArgs']]] column_names: A list of input columns for the Azure Machine Learning Studio endpoint.
        :param pulumi.Input[str] name: The name of the input. This is the name provided while authoring the endpoint.
        """
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioInputColumnArgs']]]]:
        """
        A list of input columns for the Azure Machine Learning Studio endpoint.
        """
        return pulumi.get(self, "column_names")

    @column_names.setter
    def column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureMachineLearningStudioInputColumnArgs']]]]):
        pulumi.set(self, "column_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the input. This is the name provided while authoring the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureMachineLearningStudioOutputColumnArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Describes an output column for the Azure Machine Learning Studio endpoint.
        :param pulumi.Input[str] data_type: The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        :param pulumi.Input[str] name: The name of the output column.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the output column.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureSqlDatabaseOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 max_batch_count: Optional[pulumi.Input[float]] = None,
                 max_writer_count: Optional[pulumi.Input[float]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Describes an Azure SQL database output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Sql/Server/Database'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[str] database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[float] max_batch_count: Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
        :param pulumi.Input[float] max_writer_count: Max Write r count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
        :param pulumi.Input[str] password: The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] server: The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] user: The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.Sql/Server/Database')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if max_batch_count is not None:
            pulumi.set(__self__, "max_batch_count", max_batch_count)
        if max_writer_count is not None:
            pulumi.set(__self__, "max_writer_count", max_writer_count)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Sql/Server/Database'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="maxBatchCount")
    def max_batch_count(self) -> Optional[pulumi.Input[float]]:
        """
        Max Batch count for write to Sql database, the default value is 10,000. Optional on PUT requests.
        """
        return pulumi.get(self, "max_batch_count")

    @max_batch_count.setter
    def max_batch_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_batch_count", value)

    @property
    @pulumi.getter(name="maxWriterCount")
    def max_writer_count(self) -> Optional[pulumi.Input[float]]:
        """
        Max Write r count, currently only 1(single writer) and 0(based on query partition) are available. Optional on PUT requests.
        """
        return pulumi.get(self, "max_writer_count")

    @max_writer_count.setter
    def max_writer_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_writer_count", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class AzureSqlReferenceInputDataSourcePropertiesArgs:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[str]] = None,
                 delta_snapshot_query: Optional[pulumi.Input[str]] = None,
                 full_snapshot_query: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 refresh_rate: Optional[pulumi.Input[str]] = None,
                 refresh_type: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Describes Azure SQL database reference input data source properties.
        :param pulumi.Input[str] database: This element is associated with the datasource element. This is the name of the database that output will be written to.
        :param pulumi.Input[str] delta_snapshot_query: This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database. To use this option, we recommend using temporal tables in Azure SQL Database.
        :param pulumi.Input[str] full_snapshot_query: This element is associated with the datasource element. This query is used to fetch data from the sql database.
        :param pulumi.Input[str] password: This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database instance.
        :param pulumi.Input[str] refresh_rate: This element is associated with the datasource element. This indicates how frequently the data will be fetched from the database. It is of DateTime format.
        :param pulumi.Input[str] refresh_type: This element is associated with the datasource element. This element is of enum type. It indicates what kind of data refresh option do we want to use:Static/RefreshPeriodicallyWithFull/RefreshPeriodicallyWithDelta
        :param pulumi.Input[str] server: This element is associated with the datasource element. This is the name of the server that contains the database that will be written to.
        :param pulumi.Input[str] table: This element is associated with the datasource element. The name of the table in the Azure SQL database..
        :param pulumi.Input[str] user: This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database instance.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if delta_snapshot_query is not None:
            pulumi.set(__self__, "delta_snapshot_query", delta_snapshot_query)
        if full_snapshot_query is not None:
            pulumi.set(__self__, "full_snapshot_query", full_snapshot_query)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if refresh_rate is not None:
            pulumi.set(__self__, "refresh_rate", refresh_rate)
        if refresh_type is not None:
            pulumi.set(__self__, "refresh_type", refresh_type)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This is the name of the database that output will be written to.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="deltaSnapshotQuery")
    def delta_snapshot_query(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This query is used to fetch incremental changes from the SQL database. To use this option, we recommend using temporal tables in Azure SQL Database.
        """
        return pulumi.get(self, "delta_snapshot_query")

    @delta_snapshot_query.setter
    def delta_snapshot_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delta_snapshot_query", value)

    @property
    @pulumi.getter(name="fullSnapshotQuery")
    def full_snapshot_query(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This query is used to fetch data from the sql database.
        """
        return pulumi.get(self, "full_snapshot_query")

    @full_snapshot_query.setter
    def full_snapshot_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_snapshot_query", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This is the password that will be used to connect to the SQL Database instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="refreshRate")
    def refresh_rate(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This indicates how frequently the data will be fetched from the database. It is of DateTime format.
        """
        return pulumi.get(self, "refresh_rate")

    @refresh_rate.setter
    def refresh_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_rate", value)

    @property
    @pulumi.getter(name="refreshType")
    def refresh_type(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This element is of enum type. It indicates what kind of data refresh option do we want to use:Static/RefreshPeriodicallyWithFull/RefreshPeriodicallyWithDelta
        """
        return pulumi.get(self, "refresh_type")

    @refresh_type.setter
    def refresh_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_type", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This is the name of the server that contains the database that will be written to.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. The name of the table in the Azure SQL database..
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        This element is associated with the datasource element. This is the user name that will be used to connect to the SQL Database instance.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class AzureSqlReferenceInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 properties: Optional[pulumi.Input['AzureSqlReferenceInputDataSourcePropertiesArgs']] = None):
        """
        Describes an Azure SQL database reference input data source.
        :param pulumi.Input[str] type: Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Sql/Server/Database'.
        :param pulumi.Input['AzureSqlReferenceInputDataSourcePropertiesArgs'] properties: Describes Azure SQL database reference input data source properties.
        """
        pulumi.set(__self__, "type", 'Microsoft.Sql/Server/Database')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Sql/Server/Database'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AzureSqlReferenceInputDataSourcePropertiesArgs']]:
        """
        Describes Azure SQL database reference input data source properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AzureSqlReferenceInputDataSourcePropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class AzureSynapseOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 database: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Describes an Azure Synapse output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Sql/Server/DataWarehouse'.
        :param pulumi.Input[str] database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] password: The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] server: The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] user: The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.Sql/Server/DataWarehouse')
        if database is not None:
            pulumi.set(__self__, "database", database)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Sql/Server/DataWarehouse'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class AzureTableOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 columns_to_remove: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 partition_key: Optional[pulumi.Input[str]] = None,
                 row_key: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None):
        """
        Describes an Azure Table output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Table'.
        :param pulumi.Input[str] account_key: The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[int] batch_size: The number of rows to write to the Azure Table at a time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] columns_to_remove: If specified, each item in the array is the name of a column to remove (if present) from output event entities.
        :param pulumi.Input[str] partition_key: This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] row_key: This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] table: The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Table')
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if columns_to_remove is not None:
            pulumi.set(__self__, "columns_to_remove", columns_to_remove)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if row_key is not None:
            pulumi.set(__self__, "row_key", row_key)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Table'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of rows to write to the Azure Table at a time.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="columnsToRemove")
    def columns_to_remove(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If specified, each item in the array is the name of a column to remove (if present) from output event entities.
        """
        return pulumi.get(self, "columns_to_remove")

    @columns_to_remove.setter
    def columns_to_remove(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "columns_to_remove", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> Optional[pulumi.Input[str]]:
        """
        This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "row_key")

    @row_key.setter
    def row_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "row_key", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class BlobOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 container: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 path_pattern: Optional[pulumi.Input[str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]] = None,
                 time_format: Optional[pulumi.Input[str]] = None):
        """
        Describes a blob output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Blob'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode. 
        :param pulumi.Input[str] container: The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] date_format: The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        :param pulumi.Input[str] path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        :param pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]] storage_accounts: A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] time_format: The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Blob')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Blob'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode. 
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_pattern", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]:
        """
        A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)


@pulumi.input_type
class BlobReferenceInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 container: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 path_pattern: Optional[pulumi.Input[str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]] = None,
                 time_format: Optional[pulumi.Input[str]] = None):
        """
        Describes a blob input data source that contains reference data.
        :param pulumi.Input[str] type: Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Blob'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode. 
        :param pulumi.Input[str] container: The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] date_format: The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        :param pulumi.Input[str] path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        :param pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]] storage_accounts: A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] time_format: The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Blob')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Blob'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode. 
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_pattern", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]:
        """
        A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)


@pulumi.input_type
class BlobStreamInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 container: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 path_pattern: Optional[pulumi.Input[str]] = None,
                 source_partition_count: Optional[pulumi.Input[int]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]] = None,
                 time_format: Optional[pulumi.Input[str]] = None):
        """
        Describes a blob input data source that contains stream data.
        :param pulumi.Input[str] type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Blob'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode. 
        :param pulumi.Input[str] container: The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] date_format: The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        :param pulumi.Input[str] path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        :param pulumi.Input[int] source_partition_count: The partition count of the blob input data source. Range 1 - 1024.
        :param pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]] storage_accounts: A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] time_format: The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Blob')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if source_partition_count is not None:
            pulumi.set(__self__, "source_partition_count", source_partition_count)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Blob'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode. 
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_pattern", value)

    @property
    @pulumi.getter(name="sourcePartitionCount")
    def source_partition_count(self) -> Optional[pulumi.Input[int]]:
        """
        The partition count of the blob input data source. Range 1 - 1024.
        """
        return pulumi.get(self, "source_partition_count")

    @source_partition_count.setter
    def source_partition_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_partition_count", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]:
        """
        A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)


@pulumi.input_type
class CSharpFunctionBindingArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 class_: Optional[pulumi.Input[str]] = None,
                 dll_path: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None):
        """
        The binding to a CSharp function.
        :param pulumi.Input[str] type: Indicates the function binding type.
               Expected value is 'Microsoft.StreamAnalytics/CLRUdf'.
        :param pulumi.Input[str] class_: The Csharp code containing a single function definition.
        :param pulumi.Input[str] dll_path: The Csharp code containing a single function definition.
        :param pulumi.Input[str] method: The Csharp code containing a single function definition.
        :param pulumi.Input[str] script: The Csharp code containing a single function definition.
        """
        pulumi.set(__self__, "type", 'Microsoft.StreamAnalytics/CLRUdf')
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)
        if dll_path is not None:
            pulumi.set(__self__, "dll_path", dll_path)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the function binding type.
        Expected value is 'Microsoft.StreamAnalytics/CLRUdf'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="class")
    def class_(self) -> Optional[pulumi.Input[str]]:
        """
        The Csharp code containing a single function definition.
        """
        return pulumi.get(self, "class_")

    @class_.setter
    def class_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "class_", value)

    @property
    @pulumi.getter(name="dllPath")
    def dll_path(self) -> Optional[pulumi.Input[str]]:
        """
        The Csharp code containing a single function definition.
        """
        return pulumi.get(self, "dll_path")

    @dll_path.setter
    def dll_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dll_path", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The Csharp code containing a single function definition.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        The Csharp code containing a single function definition.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)


@pulumi.input_type
class ClusterInfoArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The properties associated with a Stream Analytics cluster.
        :param pulumi.Input[str] id: The resource id of cluster.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of cluster.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class CompressionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        Describes how input data is compressed
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class CsvSerializationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 encoding: Optional[pulumi.Input[Union[str, 'Encoding']]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in CSV format.
        :param pulumi.Input[str] type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Csv'.
        :param pulumi.Input[Union[str, 'Encoding']] encoding: Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] field_delimiter: Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Csv')
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Csv'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[Union[str, 'Encoding']]]:
        """
        Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[Union[str, 'Encoding']]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)


@pulumi.input_type
class CustomClrSerializationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 serialization_class_name: Optional[pulumi.Input[str]] = None,
                 serialization_dll_path: Optional[pulumi.Input[str]] = None):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in custom format.
        :param pulumi.Input[str] type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'CustomClr'.
        :param pulumi.Input[str] serialization_class_name: The serialization class name.
        :param pulumi.Input[str] serialization_dll_path: The serialization library path.
        """
        pulumi.set(__self__, "type", 'CustomClr')
        if serialization_class_name is not None:
            pulumi.set(__self__, "serialization_class_name", serialization_class_name)
        if serialization_dll_path is not None:
            pulumi.set(__self__, "serialization_dll_path", serialization_dll_path)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'CustomClr'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="serializationClassName")
    def serialization_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        The serialization class name.
        """
        return pulumi.get(self, "serialization_class_name")

    @serialization_class_name.setter
    def serialization_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serialization_class_name", value)

    @property
    @pulumi.getter(name="serializationDllPath")
    def serialization_dll_path(self) -> Optional[pulumi.Input[str]]:
        """
        The serialization library path.
        """
        return pulumi.get(self, "serialization_dll_path")

    @serialization_dll_path.setter
    def serialization_dll_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serialization_dll_path", value)


@pulumi.input_type
class DocumentDbOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 account_key: Optional[pulumi.Input[str]] = None,
                 collection_name_pattern: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 document_id: Optional[pulumi.Input[str]] = None,
                 partition_key: Optional[pulumi.Input[str]] = None):
        """
        Describes a DocumentDB output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/DocumentDB'.
        :param pulumi.Input[str] account_id: The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] account_key: The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] collection_name_pattern: The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] database: The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] document_id: The name of the field in output events used to specify the primary key which insert or update operations are based on.
        :param pulumi.Input[str] partition_key: The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/DocumentDB')
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if collection_name_pattern is not None:
            pulumi.set(__self__, "collection_name_pattern", collection_name_pattern)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if document_id is not None:
            pulumi.set(__self__, "document_id", document_id)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/DocumentDB'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="collectionNamePattern")
    def collection_name_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "collection_name_pattern")

    @collection_name_pattern.setter
    def collection_name_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_name_pattern", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field in output events used to specify the primary key which insert or update operations are based on.
        """
        return pulumi.get(self, "document_id")

    @document_id.setter
    def document_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_id", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key", value)


@pulumi.input_type
class EventHubOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 event_hub_name: Optional[pulumi.Input[str]] = None,
                 partition_key: Optional[pulumi.Input[str]] = None,
                 property_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_bus_namespace: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Describes an Event Hub output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/EventHub'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[str] event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] partition_key: The key/column that is used to determine to which partition to send event data.
        :param pulumi.Input[str] service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/EventHub')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if event_hub_name is not None:
            pulumi.set(__self__, "event_hub_name", event_hub_name)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if property_columns is not None:
            pulumi.set(__self__, "property_columns", property_columns)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/EventHub'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "event_hub_name")

    @event_hub_name.setter
    def event_hub_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_name", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key/column that is used to determine to which partition to send event data.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter(name="propertyColumns")
    def property_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "property_columns")

    @property_columns.setter
    def property_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "property_columns", value)

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @service_bus_namespace.setter
    def service_bus_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_namespace", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_name", value)


@pulumi.input_type
class EventHubStreamInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 consumer_group_name: Optional[pulumi.Input[str]] = None,
                 event_hub_name: Optional[pulumi.Input[str]] = None,
                 service_bus_namespace: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Describes an Event Hub input data source that contains stream data.
        :param pulumi.Input[str] type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/EventHub'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[str] consumer_group_name: The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
        :param pulumi.Input[str] event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/EventHub')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if consumer_group_name is not None:
            pulumi.set(__self__, "consumer_group_name", consumer_group_name)
        if event_hub_name is not None:
            pulumi.set(__self__, "event_hub_name", event_hub_name)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/EventHub'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="consumerGroupName")
    def consumer_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
        """
        return pulumi.get(self, "consumer_group_name")

    @consumer_group_name.setter
    def consumer_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_group_name", value)

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "event_hub_name")

    @event_hub_name.setter
    def event_hub_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_name", value)

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @service_bus_namespace.setter
    def service_bus_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_namespace", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_name", value)


@pulumi.input_type
class EventHubV2OutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 event_hub_name: Optional[pulumi.Input[str]] = None,
                 partition_key: Optional[pulumi.Input[str]] = None,
                 property_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_bus_namespace: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Describes an Event Hub output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.EventHub/EventHub'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[str] event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] partition_key: The key/column that is used to determine to which partition to send event data.
        :param pulumi.Input[str] service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.EventHub/EventHub')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if event_hub_name is not None:
            pulumi.set(__self__, "event_hub_name", event_hub_name)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if property_columns is not None:
            pulumi.set(__self__, "property_columns", property_columns)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.EventHub/EventHub'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "event_hub_name")

    @event_hub_name.setter
    def event_hub_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_name", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key/column that is used to determine to which partition to send event data.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter(name="propertyColumns")
    def property_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "property_columns")

    @property_columns.setter
    def property_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "property_columns", value)

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @service_bus_namespace.setter
    def service_bus_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_namespace", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_name", value)


@pulumi.input_type
class EventHubV2StreamInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 consumer_group_name: Optional[pulumi.Input[str]] = None,
                 event_hub_name: Optional[pulumi.Input[str]] = None,
                 service_bus_namespace: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Describes an Event Hub input data source that contains stream data.
        :param pulumi.Input[str] type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.EventHub/EventHub'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[str] consumer_group_name: The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
        :param pulumi.Input[str] event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.EventHub/EventHub')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if consumer_group_name is not None:
            pulumi.set(__self__, "consumer_group_name", consumer_group_name)
        if event_hub_name is not None:
            pulumi.set(__self__, "event_hub_name", event_hub_name)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.EventHub/EventHub'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="consumerGroupName")
    def consumer_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
        """
        return pulumi.get(self, "consumer_group_name")

    @consumer_group_name.setter
    def consumer_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_group_name", value)

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "event_hub_name")

    @event_hub_name.setter
    def event_hub_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_name", value)

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @service_bus_namespace.setter
    def service_bus_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_namespace", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_name", value)


@pulumi.input_type
class ExternalArgs:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 storage_account: Optional[pulumi.Input['StorageAccountArgs']] = None):
        """
        The storage account where the custom code artifacts are located.
        :param pulumi.Input['StorageAccountArgs'] storage_account: The properties that are associated with an Azure Storage account
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[pulumi.Input['StorageAccountArgs']]:
        """
        The properties that are associated with an Azure Storage account
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: Optional[pulumi.Input['StorageAccountArgs']]):
        pulumi.set(self, "storage_account", value)


@pulumi.input_type
class FunctionInputArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 is_configuration_parameter: Optional[pulumi.Input[bool]] = None):
        """
        Describes one input parameter of a function.
        :param pulumi.Input[str] data_type: The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        :param pulumi.Input[bool] is_configuration_parameter: A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if is_configuration_parameter is not None:
            pulumi.set(__self__, "is_configuration_parameter", is_configuration_parameter)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="isConfigurationParameter")
    def is_configuration_parameter(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
        """
        return pulumi.get(self, "is_configuration_parameter")

    @is_configuration_parameter.setter
    def is_configuration_parameter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_configuration_parameter", value)


@pulumi.input_type
class FunctionOutputArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None):
        """
        Describes the output of a function.
        :param pulumi.Input[str] data_type: The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)


@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Union['AggregateFunctionPropertiesArgs', 'ScalarFunctionPropertiesArgs']]] = None):
        """
        A function object, containing all information associated with the named function. All functions are contained under a streaming job.
        :param pulumi.Input[str] name: Resource name
        :param pulumi.Input[Union['AggregateFunctionPropertiesArgs', 'ScalarFunctionPropertiesArgs']] properties: The properties that are associated with a function.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Union['AggregateFunctionPropertiesArgs', 'ScalarFunctionPropertiesArgs']]]:
        """
        The properties that are associated with a function.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Union['AggregateFunctionPropertiesArgs', 'ScalarFunctionPropertiesArgs']]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Describes how identity is verified
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class InputArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Union['ReferenceInputPropertiesArgs', 'StreamInputPropertiesArgs']]] = None):
        """
        An input object, containing all information associated with the named input. All inputs are contained under a streaming job.
        :param pulumi.Input[str] name: Resource name
        :param pulumi.Input[Union['ReferenceInputPropertiesArgs', 'StreamInputPropertiesArgs']] properties: The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Union['ReferenceInputPropertiesArgs', 'StreamInputPropertiesArgs']]]:
        """
        The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Union['ReferenceInputPropertiesArgs', 'StreamInputPropertiesArgs']]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class IoTHubStreamInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 consumer_group_name: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 iot_hub_namespace: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Describes an IoT Hub input data source that contains stream data.
        :param pulumi.Input[str] type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Devices/IotHubs'.
        :param pulumi.Input[str] consumer_group_name: The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
        :param pulumi.Input[str] endpoint: The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
        :param pulumi.Input[str] iot_hub_namespace: The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_name: The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.Devices/IotHubs')
        if consumer_group_name is not None:
            pulumi.set(__self__, "consumer_group_name", consumer_group_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if iot_hub_namespace is not None:
            pulumi.set(__self__, "iot_hub_namespace", iot_hub_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Devices/IotHubs'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="consumerGroupName")
    def consumer_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
        """
        return pulumi.get(self, "consumer_group_name")

    @consumer_group_name.setter
    def consumer_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_group_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="iotHubNamespace")
    def iot_hub_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "iot_hub_namespace")

    @iot_hub_namespace.setter
    def iot_hub_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iot_hub_namespace", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_name", value)


@pulumi.input_type
class JavaScriptFunctionBindingArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 script: Optional[pulumi.Input[str]] = None):
        """
        The binding to a JavaScript function.
        :param pulumi.Input[str] type: Indicates the function binding type.
               Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
        :param pulumi.Input[str] script: The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
        """
        pulumi.set(__self__, "type", 'Microsoft.StreamAnalytics/JavascriptUdf')
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the function binding type.
        Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)


@pulumi.input_type
class JobStorageAccountArgs:
    def __init__(__self__, *,
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None):
        """
        The properties that are associated with an Azure Storage account with MSI
        :param pulumi.Input[str] account_key: The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        """
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)


@pulumi.input_type
class JsonSerializationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 encoding: Optional[pulumi.Input[Union[str, 'Encoding']]] = None,
                 format: Optional[pulumi.Input[Union[str, 'JsonOutputSerializationFormat']]] = None):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in JSON format.
        :param pulumi.Input[str] type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Json'.
        :param pulumi.Input[Union[str, 'Encoding']] encoding: Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[Union[str, 'JsonOutputSerializationFormat']] format: This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
        """
        pulumi.set(__self__, "type", 'Json')
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Json'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[Union[str, 'Encoding']]]:
        """
        Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[Union[str, 'Encoding']]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[Union[str, 'JsonOutputSerializationFormat']]]:
        """
        This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[Union[str, 'JsonOutputSerializationFormat']]]):
        pulumi.set(self, "format", value)


@pulumi.input_type
class OutputArgs:
    def __init__(__self__, *,
                 datasource: Optional[pulumi.Input[Union['AzureDataLakeStoreOutputDataSourceArgs', 'AzureFunctionOutputDataSourceArgs', 'AzureSqlDatabaseOutputDataSourceArgs', 'AzureSynapseOutputDataSourceArgs', 'AzureTableOutputDataSourceArgs', 'BlobOutputDataSourceArgs', 'DocumentDbOutputDataSourceArgs', 'EventHubOutputDataSourceArgs', 'EventHubV2OutputDataSourceArgs', 'PowerBIOutputDataSourceArgs', 'RawOutputDatasourceArgs', 'ServiceBusQueueOutputDataSourceArgs', 'ServiceBusTopicOutputDataSourceArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 serialization: Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]] = None,
                 size_window: Optional[pulumi.Input[int]] = None,
                 time_window: Optional[pulumi.Input[str]] = None):
        """
        An output object, containing all information associated with the named output. All outputs are contained under a streaming job.
        :param pulumi.Input[Union['AzureDataLakeStoreOutputDataSourceArgs', 'AzureFunctionOutputDataSourceArgs', 'AzureSqlDatabaseOutputDataSourceArgs', 'AzureSynapseOutputDataSourceArgs', 'AzureTableOutputDataSourceArgs', 'BlobOutputDataSourceArgs', 'DocumentDbOutputDataSourceArgs', 'EventHubOutputDataSourceArgs', 'EventHubV2OutputDataSourceArgs', 'PowerBIOutputDataSourceArgs', 'RawOutputDatasourceArgs', 'ServiceBusQueueOutputDataSourceArgs', 'ServiceBusTopicOutputDataSourceArgs']] datasource: Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] name: Resource name
        :param pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']] serialization: Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[int] size_window: The size window to constrain a Stream Analytics output to.
        """
        if datasource is not None:
            pulumi.set(__self__, "datasource", datasource)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)
        if size_window is not None:
            pulumi.set(__self__, "size_window", size_window)
        if time_window is not None:
            pulumi.set(__self__, "time_window", time_window)

    @property
    @pulumi.getter
    def datasource(self) -> Optional[pulumi.Input[Union['AzureDataLakeStoreOutputDataSourceArgs', 'AzureFunctionOutputDataSourceArgs', 'AzureSqlDatabaseOutputDataSourceArgs', 'AzureSynapseOutputDataSourceArgs', 'AzureTableOutputDataSourceArgs', 'BlobOutputDataSourceArgs', 'DocumentDbOutputDataSourceArgs', 'EventHubOutputDataSourceArgs', 'EventHubV2OutputDataSourceArgs', 'PowerBIOutputDataSourceArgs', 'RawOutputDatasourceArgs', 'ServiceBusQueueOutputDataSourceArgs', 'ServiceBusTopicOutputDataSourceArgs']]]:
        """
        Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "datasource")

    @datasource.setter
    def datasource(self, value: Optional[pulumi.Input[Union['AzureDataLakeStoreOutputDataSourceArgs', 'AzureFunctionOutputDataSourceArgs', 'AzureSqlDatabaseOutputDataSourceArgs', 'AzureSynapseOutputDataSourceArgs', 'AzureTableOutputDataSourceArgs', 'BlobOutputDataSourceArgs', 'DocumentDbOutputDataSourceArgs', 'EventHubOutputDataSourceArgs', 'EventHubV2OutputDataSourceArgs', 'PowerBIOutputDataSourceArgs', 'RawOutputDatasourceArgs', 'ServiceBusQueueOutputDataSourceArgs', 'ServiceBusTopicOutputDataSourceArgs']]]):
        pulumi.set(self, "datasource", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def serialization(self) -> Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]]:
        """
        Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "serialization")

    @serialization.setter
    def serialization(self, value: Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]]):
        pulumi.set(self, "serialization", value)

    @property
    @pulumi.getter(name="sizeWindow")
    def size_window(self) -> Optional[pulumi.Input[int]]:
        """
        The size window to constrain a Stream Analytics output to.
        """
        return pulumi.get(self, "size_window")

    @size_window.setter
    def size_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_window", value)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_window", value)


@pulumi.input_type
class ParquetSerializationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in Parquet format.
        :param pulumi.Input[str] type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Parquet'.
        """
        pulumi.set(__self__, "type", 'Parquet')

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Parquet'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PowerBIOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None,
                 token_user_display_name: Optional[pulumi.Input[str]] = None,
                 token_user_principal_name: Optional[pulumi.Input[str]] = None):
        """
        Describes a Power BI output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'PowerBI'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[str] dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] group_id: The ID of the Power BI group.
        :param pulumi.Input[str] group_name: The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
        :param pulumi.Input[str] refresh_token: A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] table: The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] token_user_display_name: The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        :param pulumi.Input[str] token_user_principal_name: The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        pulumi.set(__self__, "type", 'PowerBI')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if token_user_display_name is not None:
            pulumi.set(__self__, "token_user_display_name", token_user_display_name)
        if token_user_principal_name is not None:
            pulumi.set(__self__, "token_user_principal_name", token_user_principal_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'PowerBI'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Power BI group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)

    @property
    @pulumi.getter(name="tokenUserDisplayName")
    def token_user_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_display_name")

    @token_user_display_name.setter
    def token_user_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_user_display_name", value)

    @property
    @pulumi.getter(name="tokenUserPrincipalName")
    def token_user_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_principal_name")

    @token_user_principal_name.setter
    def token_user_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_user_principal_name", value)


@pulumi.input_type
class RawOutputDatasourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 payload_uri: Optional[pulumi.Input[str]] = None):
        """
        Describes a raw output data source. This data source type is only applicable/usable when using the query testing API. You cannot create a job with this data source type or add an output of this data source type to an existing job.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Raw'.
        :param pulumi.Input[str] payload_uri: The SAS URL to a blob where the output should be written. If this property is not set, output data will be written into a temporary storage, and a SAS URL to that temporary storage will be included in the result.
        """
        pulumi.set(__self__, "type", 'Raw')
        if payload_uri is not None:
            pulumi.set(__self__, "payload_uri", payload_uri)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Raw'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="payloadUri")
    def payload_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The SAS URL to a blob where the output should be written. If this property is not set, output data will be written into a temporary storage, and a SAS URL to that temporary storage will be included in the result.
        """
        return pulumi.get(self, "payload_uri")

    @payload_uri.setter
    def payload_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_uri", value)


@pulumi.input_type
class RawReferenceInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 payload: Optional[pulumi.Input[str]] = None,
                 payload_uri: Optional[pulumi.Input[str]] = None):
        """
        Describes a raw input data source that contains reference data. This data source type is only applicable/usable when using the query testing API. You cannot create a job with this data source type or add an input of this data source type to an existing job.
        :param pulumi.Input[str] type: Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Raw'.
        :param pulumi.Input[str] payload: The JSON serialized content of the input data. Either payload or payloadUri must be set, but not both. 
        :param pulumi.Input[str] payload_uri: The SAS URL to a blob containing the JSON serialized content of the input data. Either payload or payloadUri must be set, but not both.
        """
        pulumi.set(__self__, "type", 'Raw')
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_uri is not None:
            pulumi.set(__self__, "payload_uri", payload_uri)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Raw'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON serialized content of the input data. Either payload or payloadUri must be set, but not both. 
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadUri")
    def payload_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The SAS URL to a blob containing the JSON serialized content of the input data. Either payload or payloadUri must be set, but not both.
        """
        return pulumi.get(self, "payload_uri")

    @payload_uri.setter
    def payload_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_uri", value)


@pulumi.input_type
class RawStreamInputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 payload: Optional[pulumi.Input[str]] = None,
                 payload_uri: Optional[pulumi.Input[str]] = None):
        """
        Describes a raw input data source that contains stream data. This data source type is only applicable/usable when using the query testing API. You cannot create a job with this data source type or add an input of this data source type to an existing job.
        :param pulumi.Input[str] type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Raw'.
        :param pulumi.Input[str] payload: The JSON serialized content of the input data. Either payload or payloadUri must be set, but not both. 
        :param pulumi.Input[str] payload_uri: The SAS URL to a blob containing the JSON serialized content of the input data. Either payload or payloadUri must be set, but not both.
        """
        pulumi.set(__self__, "type", 'Raw')
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_uri is not None:
            pulumi.set(__self__, "payload_uri", payload_uri)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Raw'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON serialized content of the input data. Either payload or payloadUri must be set, but not both. 
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadUri")
    def payload_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The SAS URL to a blob containing the JSON serialized content of the input data. Either payload or payloadUri must be set, but not both.
        """
        return pulumi.get(self, "payload_uri")

    @payload_uri.setter
    def payload_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_uri", value)


@pulumi.input_type
class ReferenceInputPropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 compression: Optional[pulumi.Input['CompressionArgs']] = None,
                 datasource: Optional[pulumi.Input[Union['AzureSqlReferenceInputDataSourceArgs', 'BlobReferenceInputDataSourceArgs', 'RawReferenceInputDataSourceArgs']]] = None,
                 partition_key: Optional[pulumi.Input[str]] = None,
                 serialization: Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]] = None):
        """
        The properties that are associated with an input containing reference data.
        :param pulumi.Input[str] type: Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Reference'.
        :param pulumi.Input['CompressionArgs'] compression: Describes how input data is compressed
        :param pulumi.Input[Union['AzureSqlReferenceInputDataSourceArgs', 'BlobReferenceInputDataSourceArgs', 'RawReferenceInputDataSourceArgs']] datasource: Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] partition_key: partitionKey Describes a key in the input data which is used for partitioning the input data
        :param pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']] serialization: Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Reference')
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if datasource is not None:
            pulumi.set(__self__, "datasource", datasource)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Reference'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input['CompressionArgs']]:
        """
        Describes how input data is compressed
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input['CompressionArgs']]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def datasource(self) -> Optional[pulumi.Input[Union['AzureSqlReferenceInputDataSourceArgs', 'BlobReferenceInputDataSourceArgs', 'RawReferenceInputDataSourceArgs']]]:
        """
        Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "datasource")

    @datasource.setter
    def datasource(self, value: Optional[pulumi.Input[Union['AzureSqlReferenceInputDataSourceArgs', 'BlobReferenceInputDataSourceArgs', 'RawReferenceInputDataSourceArgs']]]):
        pulumi.set(self, "datasource", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        partitionKey Describes a key in the input data which is used for partitioning the input data
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter
    def serialization(self) -> Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]]:
        """
        Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "serialization")

    @serialization.setter
    def serialization(self, value: Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]]):
        pulumi.set(self, "serialization", value)


@pulumi.input_type
class ScalarFunctionPropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 binding: Optional[pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']]] = None,
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionInputArgs']]]] = None,
                 output: Optional[pulumi.Input['FunctionOutputArgs']] = None):
        """
        The properties that are associated with a scalar function.
        :param pulumi.Input[str] type: Indicates the type of function.
               Expected value is 'Scalar'.
        :param pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']] binding: The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        :param pulumi.Input['FunctionOutputArgs'] output: Describes the output of a function.
        """
        pulumi.set(__self__, "type", 'Scalar')
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if output is not None:
            pulumi.set(__self__, "output", output)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of function.
        Expected value is 'Scalar'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def binding(self) -> Optional[pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']]]:
        """
        The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        """
        return pulumi.get(self, "binding")

    @binding.setter
    def binding(self, value: Optional[pulumi.Input[Union['AzureMachineLearningServiceFunctionBindingArgs', 'AzureMachineLearningStudioFunctionBindingArgs', 'CSharpFunctionBindingArgs', 'JavaScriptFunctionBindingArgs']]]):
        pulumi.set(self, "binding", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionInputArgs']]]]:
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionInputArgs']]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['FunctionOutputArgs']]:
        """
        Describes the output of a function.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['FunctionOutputArgs']]):
        pulumi.set(self, "output", value)


@pulumi.input_type
class ServiceBusQueueOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 property_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 service_bus_namespace: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[str]] = None,
                 system_property_columns: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Describes a Service Bus Queue output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/Queue'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] property_columns: A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        :param pulumi.Input[str] queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/Queue')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if property_columns is not None:
            pulumi.set(__self__, "property_columns", property_columns)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)
        if system_property_columns is not None:
            pulumi.set(__self__, "system_property_columns", system_property_columns)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/Queue'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="propertyColumns")
    def property_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        """
        return pulumi.get(self, "property_columns")

    @property_columns.setter
    def property_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "property_columns", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @service_bus_namespace.setter
    def service_bus_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_namespace", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_name", value)

    @property
    @pulumi.getter(name="systemPropertyColumns")
    def system_property_columns(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "system_property_columns")

    @system_property_columns.setter
    def system_property_columns(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_property_columns", value)


@pulumi.input_type
class ServiceBusTopicOutputDataSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 authentication_mode: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]] = None,
                 property_columns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_bus_namespace: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_key: Optional[pulumi.Input[str]] = None,
                 shared_access_policy_name: Optional[pulumi.Input[str]] = None,
                 system_property_columns: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None):
        """
        Describes a Service Bus Topic output data source.
        :param pulumi.Input[str] type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/Topic'.
        :param pulumi.Input[Union[str, 'AuthenticationMode']] authentication_mode: Authentication Mode.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] property_columns: A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        :param pulumi.Input[str] service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/Topic')
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if property_columns is not None:
            pulumi.set(__self__, "property_columns", property_columns)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)
        if system_property_columns is not None:
            pulumi.set(__self__, "system_property_columns", system_property_columns)
        if topic_name is not None:
            pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/Topic'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]:
        """
        Authentication Mode.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[Union[str, 'AuthenticationMode']]]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="propertyColumns")
    def property_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        """
        return pulumi.get(self, "property_columns")

    @property_columns.setter
    def property_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "property_columns", value)

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @service_bus_namespace.setter
    def service_bus_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_namespace", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @shared_access_policy_key.setter
    def shared_access_policy_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_key", value)

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @shared_access_policy_name.setter
    def shared_access_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_access_policy_name", value)

    @property
    @pulumi.getter(name="systemPropertyColumns")
    def system_property_columns(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "system_property_columns")

    @system_property_columns.setter
    def system_property_columns(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_property_columns", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_name", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None):
        """
        The properties that are associated with an Azure Storage account
        :param pulumi.Input[str] account_key: The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)


@pulumi.input_type
class StreamInputPropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 compression: Optional[pulumi.Input['CompressionArgs']] = None,
                 datasource: Optional[pulumi.Input[Union['BlobStreamInputDataSourceArgs', 'EventHubStreamInputDataSourceArgs', 'EventHubV2StreamInputDataSourceArgs', 'IoTHubStreamInputDataSourceArgs', 'RawStreamInputDataSourceArgs']]] = None,
                 partition_key: Optional[pulumi.Input[str]] = None,
                 serialization: Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]] = None):
        """
        The properties that are associated with an input containing stream data.
        :param pulumi.Input[str] type: Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Stream'.
        :param pulumi.Input['CompressionArgs'] compression: Describes how input data is compressed
        :param pulumi.Input[Union['BlobStreamInputDataSourceArgs', 'EventHubStreamInputDataSourceArgs', 'EventHubV2StreamInputDataSourceArgs', 'IoTHubStreamInputDataSourceArgs', 'RawStreamInputDataSourceArgs']] datasource: Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[str] partition_key: partitionKey Describes a key in the input data which is used for partitioning the input data
        :param pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']] serialization: Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Stream')
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if datasource is not None:
            pulumi.set(__self__, "datasource", datasource)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Stream'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input['CompressionArgs']]:
        """
        Describes how input data is compressed
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input['CompressionArgs']]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def datasource(self) -> Optional[pulumi.Input[Union['BlobStreamInputDataSourceArgs', 'EventHubStreamInputDataSourceArgs', 'EventHubV2StreamInputDataSourceArgs', 'IoTHubStreamInputDataSourceArgs', 'RawStreamInputDataSourceArgs']]]:
        """
        Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "datasource")

    @datasource.setter
    def datasource(self, value: Optional[pulumi.Input[Union['BlobStreamInputDataSourceArgs', 'EventHubStreamInputDataSourceArgs', 'EventHubV2StreamInputDataSourceArgs', 'IoTHubStreamInputDataSourceArgs', 'RawStreamInputDataSourceArgs']]]):
        pulumi.set(self, "datasource", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[str]]:
        """
        partitionKey Describes a key in the input data which is used for partitioning the input data
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter
    def serialization(self) -> Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]]:
        """
        Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "serialization")

    @serialization.setter
    def serialization(self, value: Optional[pulumi.Input[Union['AvroSerializationArgs', 'CsvSerializationArgs', 'CustomClrSerializationArgs', 'JsonSerializationArgs', 'ParquetSerializationArgs']]]):
        pulumi.set(self, "serialization", value)


@pulumi.input_type
class StreamingJobSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'StreamingJobSkuName']]] = None):
        """
        The properties that are associated with a SKU.
        :param pulumi.Input[Union[str, 'StreamingJobSkuName']] name: The name of the SKU. Required on PUT (CreateOrReplace) requests.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'StreamingJobSkuName']]]:
        """
        The name of the SKU. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'StreamingJobSkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class TransformationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 streaming_units: Optional[pulumi.Input[int]] = None):
        """
        A transformation object, containing all information associated with the named transformation. All transformations are contained under a streaming job.
        :param pulumi.Input[str] name: Resource name
        :param pulumi.Input[str] query: Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
        :param pulumi.Input[int] streaming_units: Specifies the number of streaming units that the streaming job uses.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if streaming_units is not None:
            pulumi.set(__self__, "streaming_units", streaming_units)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="streamingUnits")
    def streaming_units(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of streaming units that the streaming job uses.
        """
        return pulumi.get(self, "streaming_units")

    @streaming_units.setter
    def streaming_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "streaming_units", value)


