# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRoleDefinitionResult',
    'AwaitableGetRoleDefinitionResult',
    'get_role_definition',
    'get_role_definition_output',
]

@pulumi.output_type
class GetRoleDefinitionResult:
    """
    Role definition.
    """
    def __init__(__self__, assignable_scopes=None, created_by=None, created_on=None, description=None, id=None, name=None, permissions=None, role_name=None, role_type=None, type=None, updated_by=None, updated_on=None):
        if assignable_scopes and not isinstance(assignable_scopes, list):
            raise TypeError("Expected argument 'assignable_scopes' to be a list")
        pulumi.set(__self__, "assignable_scopes", assignable_scopes)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)
        if role_type and not isinstance(role_type, str):
            raise TypeError("Expected argument 'role_type' to be a str")
        pulumi.set(__self__, "role_type", role_type)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_by and not isinstance(updated_by, str):
            raise TypeError("Expected argument 'updated_by' to be a str")
        pulumi.set(__self__, "updated_by", updated_by)
        if updated_on and not isinstance(updated_on, str):
            raise TypeError("Expected argument 'updated_on' to be a str")
        pulumi.set(__self__, "updated_on", updated_on)

    @property
    @pulumi.getter(name="assignableScopes")
    def assignable_scopes(self) -> Optional[Sequence[str]]:
        """
        Role definition assignable scopes.
        """
        return pulumi.get(self, "assignable_scopes")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        Id of the user who created the assignment
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        Time it was created
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The role definition description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The role definition ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The role definition name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence['outputs.PermissionResponse']]:
        """
        Role definition permissions.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[str]:
        """
        The role name.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[str]:
        """
        The role type.
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The role definition type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> str:
        """
        Id of the user who updated the assignment
        """
        return pulumi.get(self, "updated_by")

    @property
    @pulumi.getter(name="updatedOn")
    def updated_on(self) -> str:
        """
        Time it was updated
        """
        return pulumi.get(self, "updated_on")


class AwaitableGetRoleDefinitionResult(GetRoleDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleDefinitionResult(
            assignable_scopes=self.assignable_scopes,
            created_by=self.created_by,
            created_on=self.created_on,
            description=self.description,
            id=self.id,
            name=self.name,
            permissions=self.permissions,
            role_name=self.role_name,
            role_type=self.role_type,
            type=self.type,
            updated_by=self.updated_by,
            updated_on=self.updated_on)


def get_role_definition(role_definition_id: Optional[str] = None,
                        scope: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleDefinitionResult:
    """
    Role definition.


    :param str role_definition_id: The ID of the role definition.
    :param str scope: The scope of the role definition.
    """
    __args__ = dict()
    __args__['roleDefinitionId'] = role_definition_id
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:authorization/v20220401:getRoleDefinition', __args__, opts=opts, typ=GetRoleDefinitionResult).value

    return AwaitableGetRoleDefinitionResult(
        assignable_scopes=__ret__.assignable_scopes,
        created_by=__ret__.created_by,
        created_on=__ret__.created_on,
        description=__ret__.description,
        id=__ret__.id,
        name=__ret__.name,
        permissions=__ret__.permissions,
        role_name=__ret__.role_name,
        role_type=__ret__.role_type,
        type=__ret__.type,
        updated_by=__ret__.updated_by,
        updated_on=__ret__.updated_on)


@_utilities.lift_output_func(get_role_definition)
def get_role_definition_output(role_definition_id: Optional[pulumi.Input[str]] = None,
                               scope: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRoleDefinitionResult]:
    """
    Role definition.


    :param str role_definition_id: The ID of the role definition.
    :param str scope: The scope of the role definition.
    """
    ...
