# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'ActionType',
    'BackendEnabledState',
    'CustomRuleEnabledState',
    'DynamicCompressionEnabled',
    'EnforceCertificateNameCheckEnabledState',
    'FrontDoorEnabledState',
    'FrontDoorForwardingProtocol',
    'FrontDoorHealthProbeMethod',
    'FrontDoorMatchVariable',
    'FrontDoorProtocol',
    'FrontDoorQuery',
    'FrontDoorRedirectProtocol',
    'FrontDoorRedirectType',
    'HeaderActionType',
    'HealthProbeEnabled',
    'ManagedRuleEnabledState',
    'ManagedRuleExclusionMatchVariable',
    'ManagedRuleExclusionSelectorMatchOperator',
    'ManagedRuleSetActionType',
    'MatchProcessingBehavior',
    'Operator',
    'PolicyEnabledState',
    'PolicyMode',
    'PolicyRequestBodyCheck',
    'RoutingRuleEnabledState',
    'RuleType',
    'RulesEngineMatchVariable',
    'RulesEngineOperator',
    'SessionAffinityEnabledState',
    'SkuName',
    'Transform',
    'TransformType',
]


class ActionType(str, Enum):
    """
    Describes the override action to be applied when rule matches.
    """
    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"


class BackendEnabledState(str, Enum):
    """
    Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class CustomRuleEnabledState(str, Enum):
    """
    Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
    """
    DISABLED = "Disabled"
    ENABLED = "Enabled"


class DynamicCompressionEnabled(str, Enum):
    """
    Whether to use dynamic compression for cached content
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class EnforceCertificateNameCheckEnabledState(str, Enum):
    """
    Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class FrontDoorEnabledState(str, Enum):
    """
    Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class FrontDoorForwardingProtocol(str, Enum):
    """
    Protocol this rule will use when forwarding traffic to backends.
    """
    HTTP_ONLY = "HttpOnly"
    HTTPS_ONLY = "HttpsOnly"
    MATCH_REQUEST = "MatchRequest"


class FrontDoorHealthProbeMethod(str, Enum):
    """
    Configures which HTTP method to use to probe the backends defined under backendPools.
    """
    GET = "GET"
    HEAD = "HEAD"


class FrontDoorMatchVariable(str, Enum):
    """
    Request variable to compare with.
    """
    REMOTE_ADDR = "RemoteAddr"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    COOKIES = "Cookies"
    SOCKET_ADDR = "SocketAddr"


class FrontDoorProtocol(str, Enum):
    """
    Accepted protocol schemes.
    """
    HTTP = "Http"
    HTTPS = "Https"


class FrontDoorQuery(str, Enum):
    """
    Treatment of URL query terms when forming the cache key.
    """
    STRIP_NONE = "StripNone"
    STRIP_ALL = "StripAll"
    STRIP_ONLY = "StripOnly"
    STRIP_ALL_EXCEPT = "StripAllExcept"


class FrontDoorRedirectProtocol(str, Enum):
    """
    The protocol of the destination to where the traffic is redirected
    """
    HTTP_ONLY = "HttpOnly"
    HTTPS_ONLY = "HttpsOnly"
    MATCH_REQUEST = "MatchRequest"


class FrontDoorRedirectType(str, Enum):
    """
    The redirect type the rule will use when redirecting traffic.
    """
    MOVED = "Moved"
    FOUND = "Found"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    PERMANENT_REDIRECT = "PermanentRedirect"


class HeaderActionType(str, Enum):
    """
    Which type of manipulation to apply to the header.
    """
    APPEND = "Append"
    DELETE = "Delete"
    OVERWRITE = "Overwrite"


class HealthProbeEnabled(str, Enum):
    """
    Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ManagedRuleEnabledState(str, Enum):
    """
    Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
    """
    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ManagedRuleExclusionMatchVariable(str, Enum):
    """
    The variable type to be excluded.
    """
    REQUEST_HEADER_NAMES = "RequestHeaderNames"
    REQUEST_COOKIE_NAMES = "RequestCookieNames"
    QUERY_STRING_ARG_NAMES = "QueryStringArgNames"
    REQUEST_BODY_POST_ARG_NAMES = "RequestBodyPostArgNames"
    REQUEST_BODY_JSON_ARG_NAMES = "RequestBodyJsonArgNames"


class ManagedRuleExclusionSelectorMatchOperator(str, Enum):
    """
    Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
    """
    EQUALS = "Equals"
    CONTAINS = "Contains"
    STARTS_WITH = "StartsWith"
    ENDS_WITH = "EndsWith"
    EQUALS_ANY = "EqualsAny"


class ManagedRuleSetActionType(str, Enum):
    """
    Defines the action to take when a managed rule set score threshold is met.
    """
    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"


class MatchProcessingBehavior(str, Enum):
    """
    If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
    """
    CONTINUE_ = "Continue"
    STOP = "Stop"


class Operator(str, Enum):
    """
    Comparison type to use for matching with the variable value.
    """
    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    REG_EX = "RegEx"


class PolicyEnabledState(str, Enum):
    """
    Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
    """
    DISABLED = "Disabled"
    ENABLED = "Enabled"


class PolicyMode(str, Enum):
    """
    Describes if it is in detection mode or prevention mode at policy level.
    """
    PREVENTION = "Prevention"
    DETECTION = "Detection"


class PolicyRequestBodyCheck(str, Enum):
    """
    Describes if policy managed rules will inspect the request body content.
    """
    DISABLED = "Disabled"
    ENABLED = "Enabled"


class RoutingRuleEnabledState(str, Enum):
    """
    Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class RuleType(str, Enum):
    """
    Describes type of rule.
    """
    MATCH_RULE = "MatchRule"
    RATE_LIMIT_RULE = "RateLimitRule"


class RulesEngineMatchVariable(str, Enum):
    """
    Match Variable
    """
    IS_MOBILE = "IsMobile"
    REMOTE_ADDR = "RemoteAddr"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_PATH = "RequestPath"
    REQUEST_FILENAME = "RequestFilename"
    REQUEST_FILENAME_EXTENSION = "RequestFilenameExtension"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    REQUEST_SCHEME = "RequestScheme"


class RulesEngineOperator(str, Enum):
    """
    Describes operator to apply to the match condition.
    """
    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"


class SessionAffinityEnabledState(str, Enum):
    """
    Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
    """
    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SkuName(str, Enum):
    """
    Name of the pricing tier.
    """
    CLASSIC_AZURE_FRONT_DOOR = "Classic_AzureFrontDoor"
    STANDARD_AZURE_FRONT_DOOR = "Standard_AzureFrontDoor"
    PREMIUM_AZURE_FRONT_DOOR = "Premium_AzureFrontDoor"


class Transform(str, Enum):
    """
    Describes what transforms are applied before matching
    """
    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"


class TransformType(str, Enum):
    """
    Describes what transforms applied before matching.
    """
    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"
