# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AnalyticsConnectorArgs', 'AnalyticsConnector']

@pulumi.input_type
class AnalyticsConnectorArgs:
    def __init__(__self__, *,
                 data_destination_configuration: pulumi.Input['AnalyticsConnectorDataLakeDataDestinationArgs'],
                 data_mapping_configuration: pulumi.Input['AnalyticsConnectorFhirToParquetMappingArgs'],
                 data_source_configuration: pulumi.Input['AnalyticsConnectorFhirServiceDataSourceArgs'],
                 resource_group_name: pulumi.Input[str],
                 workspace_name: pulumi.Input[str],
                 analytics_connector_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['ServiceManagedIdentityIdentityArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AnalyticsConnector resource.
        :param pulumi.Input['AnalyticsConnectorDataLakeDataDestinationArgs'] data_destination_configuration: Data destination configuration for Analytics Connector.
        :param pulumi.Input['AnalyticsConnectorFhirToParquetMappingArgs'] data_mapping_configuration: Data mapping configuration for Analytics Connector.
        :param pulumi.Input['AnalyticsConnectorFhirServiceDataSourceArgs'] data_source_configuration: Data source for Analytics Connector.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the service instance.
        :param pulumi.Input[str] workspace_name: The name of workspace resource.
        :param pulumi.Input[str] analytics_connector_name: The name of Analytics Connector resource.
        :param pulumi.Input['ServiceManagedIdentityIdentityArgs'] identity: Setting indicating whether the service has a managed identity associated with it.
        :param pulumi.Input[str] location: The resource location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "data_destination_configuration", data_destination_configuration)
        pulumi.set(__self__, "data_mapping_configuration", data_mapping_configuration)
        pulumi.set(__self__, "data_source_configuration", data_source_configuration)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "workspace_name", workspace_name)
        if analytics_connector_name is not None:
            pulumi.set(__self__, "analytics_connector_name", analytics_connector_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataDestinationConfiguration")
    def data_destination_configuration(self) -> pulumi.Input['AnalyticsConnectorDataLakeDataDestinationArgs']:
        """
        Data destination configuration for Analytics Connector.
        """
        return pulumi.get(self, "data_destination_configuration")

    @data_destination_configuration.setter
    def data_destination_configuration(self, value: pulumi.Input['AnalyticsConnectorDataLakeDataDestinationArgs']):
        pulumi.set(self, "data_destination_configuration", value)

    @property
    @pulumi.getter(name="dataMappingConfiguration")
    def data_mapping_configuration(self) -> pulumi.Input['AnalyticsConnectorFhirToParquetMappingArgs']:
        """
        Data mapping configuration for Analytics Connector.
        """
        return pulumi.get(self, "data_mapping_configuration")

    @data_mapping_configuration.setter
    def data_mapping_configuration(self, value: pulumi.Input['AnalyticsConnectorFhirToParquetMappingArgs']):
        pulumi.set(self, "data_mapping_configuration", value)

    @property
    @pulumi.getter(name="dataSourceConfiguration")
    def data_source_configuration(self) -> pulumi.Input['AnalyticsConnectorFhirServiceDataSourceArgs']:
        """
        Data source for Analytics Connector.
        """
        return pulumi.get(self, "data_source_configuration")

    @data_source_configuration.setter
    def data_source_configuration(self, value: pulumi.Input['AnalyticsConnectorFhirServiceDataSourceArgs']):
        pulumi.set(self, "data_source_configuration", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the service instance.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Input[str]:
        """
        The name of workspace resource.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_name", value)

    @property
    @pulumi.getter(name="analyticsConnectorName")
    def analytics_connector_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Analytics Connector resource.
        """
        return pulumi.get(self, "analytics_connector_name")

    @analytics_connector_name.setter
    def analytics_connector_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_connector_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceManagedIdentityIdentityArgs']]:
        """
        Setting indicating whether the service has a managed identity associated with it.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceManagedIdentityIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The resource location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class AnalyticsConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_connector_name: Optional[pulumi.Input[str]] = None,
                 data_destination_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticsConnectorDataLakeDataDestinationArgs']]] = None,
                 data_mapping_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticsConnectorFhirToParquetMappingArgs']]] = None,
                 data_source_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticsConnectorFhirServiceDataSourceArgs']]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ServiceManagedIdentityIdentityArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Analytics Connector definition.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_connector_name: The name of Analytics Connector resource.
        :param pulumi.Input[pulumi.InputType['AnalyticsConnectorDataLakeDataDestinationArgs']] data_destination_configuration: Data destination configuration for Analytics Connector.
        :param pulumi.Input[pulumi.InputType['AnalyticsConnectorFhirToParquetMappingArgs']] data_mapping_configuration: Data mapping configuration for Analytics Connector.
        :param pulumi.Input[pulumi.InputType['AnalyticsConnectorFhirServiceDataSourceArgs']] data_source_configuration: Data source for Analytics Connector.
        :param pulumi.Input[pulumi.InputType['ServiceManagedIdentityIdentityArgs']] identity: Setting indicating whether the service has a managed identity associated with it.
        :param pulumi.Input[str] location: The resource location.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the service instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] workspace_name: The name of workspace resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyticsConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Analytics Connector definition.

        :param str resource_name: The name of the resource.
        :param AnalyticsConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_connector_name: Optional[pulumi.Input[str]] = None,
                 data_destination_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticsConnectorDataLakeDataDestinationArgs']]] = None,
                 data_mapping_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticsConnectorFhirToParquetMappingArgs']]] = None,
                 data_source_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticsConnectorFhirServiceDataSourceArgs']]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ServiceManagedIdentityIdentityArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsConnectorArgs.__new__(AnalyticsConnectorArgs)

            __props__.__dict__["analytics_connector_name"] = analytics_connector_name
            if data_destination_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'data_destination_configuration'")
            __props__.__dict__["data_destination_configuration"] = data_destination_configuration
            if data_mapping_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'data_mapping_configuration'")
            __props__.__dict__["data_mapping_configuration"] = data_mapping_configuration
            if data_source_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_configuration'")
            __props__.__dict__["data_source_configuration"] = data_source_configuration
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_name'")
            __props__.__dict__["workspace_name"] = workspace_name
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        super(AnalyticsConnector, __self__).__init__(
            'azure-native:healthcareapis/v20221001preview:AnalyticsConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AnalyticsConnector':
        """
        Get an existing AnalyticsConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AnalyticsConnectorArgs.__new__(AnalyticsConnectorArgs)

        __props__.__dict__["data_destination_configuration"] = None
        __props__.__dict__["data_mapping_configuration"] = None
        __props__.__dict__["data_source_configuration"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["identity"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return AnalyticsConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataDestinationConfiguration")
    def data_destination_configuration(self) -> pulumi.Output['outputs.AnalyticsConnectorDataLakeDataDestinationResponse']:
        """
        Data destination configuration for Analytics Connector.
        """
        return pulumi.get(self, "data_destination_configuration")

    @property
    @pulumi.getter(name="dataMappingConfiguration")
    def data_mapping_configuration(self) -> pulumi.Output['outputs.AnalyticsConnectorFhirToParquetMappingResponse']:
        """
        Data mapping configuration for Analytics Connector.
        """
        return pulumi.get(self, "data_mapping_configuration")

    @property
    @pulumi.getter(name="dataSourceConfiguration")
    def data_source_configuration(self) -> pulumi.Output['outputs.AnalyticsConnectorFhirServiceDataSourceResponse']:
        """
        Data source for Analytics Connector.
        """
        return pulumi.get(self, "data_source_configuration")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[Optional[str]]:
        """
        An etag associated with the resource, used for optimistic concurrency when editing it.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ServiceManagedIdentityResponseIdentity']]:
        """
        Setting indicating whether the service has a managed identity associated with it.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

