# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AgentPropertiesResponse',
    'ArgumentResponse',
    'AuthInfoResponse',
    'BaseImageDependencyResponse',
    'BaseImageTriggerResponse',
    'CredentialsResponse',
    'CustomRegistryCredentialsResponse',
    'DockerBuildRequestResponse',
    'DockerBuildStepResponse',
    'EncodedTaskRunRequestResponse',
    'EncodedTaskStepResponse',
    'FileTaskRunRequestResponse',
    'FileTaskStepResponse',
    'IdentityPropertiesResponse',
    'ImageDescriptorResponse',
    'ImageUpdateTriggerResponse',
    'OverrideTaskStepPropertiesResponse',
    'PlatformPropertiesResponse',
    'RunResponse',
    'SecretObjectResponse',
    'SetValueResponse',
    'SourcePropertiesResponse',
    'SourceRegistryCredentialsResponse',
    'SourceTriggerDescriptorResponse',
    'SourceTriggerResponse',
    'SystemDataResponse',
    'TaskRunRequestResponse',
    'TimerTriggerDescriptorResponse',
    'TimerTriggerResponse',
    'TriggerPropertiesResponse',
    'UserIdentityPropertiesResponse',
]

@pulumi.output_type
class AgentPropertiesResponse(dict):
    """
    The properties that determine the run agent configuration.
    """
    def __init__(__self__, *,
                 cpu: Optional[int] = None):
        """
        The properties that determine the run agent configuration.
        :param int cpu: The CPU configuration in terms of number of cores required for the run.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[int]:
        """
        The CPU configuration in terms of number of cores required for the run.
        """
        return pulumi.get(self, "cpu")


@pulumi.output_type
class ArgumentResponse(dict):
    """
    The properties of a run argument.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isSecret":
            suggest = "is_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArgumentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArgumentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArgumentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 is_secret: Optional[bool] = None):
        """
        The properties of a run argument.
        :param str name: The name of the argument.
        :param str value: The value of the argument.
        :param bool is_secret: Flag to indicate whether the argument represents a secret and want to be removed from build logs.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if is_secret is None:
            is_secret = False
        if is_secret is not None:
            pulumi.set(__self__, "is_secret", is_secret)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the argument.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[bool]:
        """
        Flag to indicate whether the argument represents a secret and want to be removed from build logs.
        """
        return pulumi.get(self, "is_secret")


@pulumi.output_type
class AuthInfoResponse(dict):
    """
    The authorization properties for accessing the source code repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenType":
            suggest = "token_type"
        elif key == "expiresIn":
            suggest = "expires_in"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token: str,
                 token_type: str,
                 expires_in: Optional[int] = None,
                 refresh_token: Optional[str] = None,
                 scope: Optional[str] = None):
        """
        The authorization properties for accessing the source code repository.
        :param str token: The access token used to access the source control provider.
        :param str token_type: The type of Auth token.
        :param int expires_in: Time in seconds that the token remains valid
        :param str refresh_token: The refresh token used to refresh the access token.
        :param str scope: The scope of the access token.
        """
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "token_type", token_type)
        if expires_in is not None:
            pulumi.set(__self__, "expires_in", expires_in)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The access token used to access the source control provider.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> str:
        """
        The type of Auth token.
        """
        return pulumi.get(self, "token_type")

    @property
    @pulumi.getter(name="expiresIn")
    def expires_in(self) -> Optional[int]:
        """
        Time in seconds that the token remains valid
        """
        return pulumi.get(self, "expires_in")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        The refresh token used to refresh the access token.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The scope of the access token.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class BaseImageDependencyResponse(dict):
    """
    Properties that describe a base image dependency.
    """
    def __init__(__self__, *,
                 digest: Optional[str] = None,
                 registry: Optional[str] = None,
                 repository: Optional[str] = None,
                 tag: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Properties that describe a base image dependency.
        :param str digest: The sha256-based digest of the image manifest.
        :param str registry: The registry login server.
        :param str repository: The repository name.
        :param str tag: The tag name.
        :param str type: The type of the base image dependency.
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def digest(self) -> Optional[str]:
        """
        The sha256-based digest of the image manifest.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry login server.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The tag name.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the base image dependency.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BaseImageTriggerResponse(dict):
    """
    The trigger based on base image dependency.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseImageTriggerType":
            suggest = "base_image_trigger_type"
        elif key == "updateTriggerEndpoint":
            suggest = "update_trigger_endpoint"
        elif key == "updateTriggerPayloadType":
            suggest = "update_trigger_payload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BaseImageTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BaseImageTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BaseImageTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_image_trigger_type: str,
                 name: str,
                 status: Optional[str] = None,
                 update_trigger_endpoint: Optional[str] = None,
                 update_trigger_payload_type: Optional[str] = None):
        """
        The trigger based on base image dependency.
        :param str base_image_trigger_type: The type of the auto trigger for base image dependency updates.
        :param str name: The name of the trigger.
        :param str status: The current status of trigger.
        :param str update_trigger_endpoint: The endpoint URL for receiving update triggers.
        :param str update_trigger_payload_type: Type of Payload body for Base image update triggers.
        """
        pulumi.set(__self__, "base_image_trigger_type", base_image_trigger_type)
        pulumi.set(__self__, "name", name)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_trigger_endpoint is not None:
            pulumi.set(__self__, "update_trigger_endpoint", update_trigger_endpoint)
        if update_trigger_payload_type is not None:
            pulumi.set(__self__, "update_trigger_payload_type", update_trigger_payload_type)

    @property
    @pulumi.getter(name="baseImageTriggerType")
    def base_image_trigger_type(self) -> str:
        """
        The type of the auto trigger for base image dependency updates.
        """
        return pulumi.get(self, "base_image_trigger_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTriggerEndpoint")
    def update_trigger_endpoint(self) -> Optional[str]:
        """
        The endpoint URL for receiving update triggers.
        """
        return pulumi.get(self, "update_trigger_endpoint")

    @property
    @pulumi.getter(name="updateTriggerPayloadType")
    def update_trigger_payload_type(self) -> Optional[str]:
        """
        Type of Payload body for Base image update triggers.
        """
        return pulumi.get(self, "update_trigger_payload_type")


@pulumi.output_type
class CredentialsResponse(dict):
    """
    The parameters that describes a set of credentials that will be used when a run is invoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRegistries":
            suggest = "custom_registries"
        elif key == "sourceRegistry":
            suggest = "source_registry"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_registries: Optional[Mapping[str, 'outputs.CustomRegistryCredentialsResponse']] = None,
                 source_registry: Optional['outputs.SourceRegistryCredentialsResponse'] = None):
        """
        The parameters that describes a set of credentials that will be used when a run is invoked.
        :param Mapping[str, 'CustomRegistryCredentialsResponse'] custom_registries: Describes the credential parameters for accessing other custom registries. The key
               for the dictionary item will be the registry login server (myregistry.azurecr.io) and
               the value of the item will be the registry credentials for accessing the registry.
        :param 'SourceRegistryCredentialsResponse' source_registry: Describes the credential parameters for accessing the source registry.
        """
        if custom_registries is not None:
            pulumi.set(__self__, "custom_registries", custom_registries)
        if source_registry is not None:
            pulumi.set(__self__, "source_registry", source_registry)

    @property
    @pulumi.getter(name="customRegistries")
    def custom_registries(self) -> Optional[Mapping[str, 'outputs.CustomRegistryCredentialsResponse']]:
        """
        Describes the credential parameters for accessing other custom registries. The key
        for the dictionary item will be the registry login server (myregistry.azurecr.io) and
        the value of the item will be the registry credentials for accessing the registry.
        """
        return pulumi.get(self, "custom_registries")

    @property
    @pulumi.getter(name="sourceRegistry")
    def source_registry(self) -> Optional['outputs.SourceRegistryCredentialsResponse']:
        """
        Describes the credential parameters for accessing the source registry.
        """
        return pulumi.get(self, "source_registry")


@pulumi.output_type
class CustomRegistryCredentialsResponse(dict):
    """
    Describes the credentials that will be used to access a custom registry during a run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomRegistryCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomRegistryCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomRegistryCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity: Optional[str] = None,
                 password: Optional['outputs.SecretObjectResponse'] = None,
                 user_name: Optional['outputs.SecretObjectResponse'] = None):
        """
        Describes the credentials that will be used to access a custom registry during a run.
        :param str identity: Indicates the managed identity assigned to the custom credential. If a user-assigned identity
               this value is the Client ID. If a system-assigned identity, the value will be `system`. In
               the case of a system-assigned identity, the Client ID will be determined by the runner. This
               identity may be used to authenticate to key vault to retrieve credentials or it may be the only 
               source of authentication used for accessing the registry.
        :param 'SecretObjectResponse' password: The password for logging into the custom registry. The password is a secret 
               object that allows multiple ways of providing the value for it.
        :param 'SecretObjectResponse' user_name: The username for logging into the custom registry.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def identity(self) -> Optional[str]:
        """
        Indicates the managed identity assigned to the custom credential. If a user-assigned identity
        this value is the Client ID. If a system-assigned identity, the value will be `system`. In
        the case of a system-assigned identity, the Client ID will be determined by the runner. This
        identity may be used to authenticate to key vault to retrieve credentials or it may be the only 
        source of authentication used for accessing the registry.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def password(self) -> Optional['outputs.SecretObjectResponse']:
        """
        The password for logging into the custom registry. The password is a secret 
        object that allows multiple ways of providing the value for it.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional['outputs.SecretObjectResponse']:
        """
        The username for logging into the custom registry.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class DockerBuildRequestResponse(dict):
    """
    The parameters for a docker quick build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerFilePath":
            suggest = "docker_file_path"
        elif key == "agentConfiguration":
            suggest = "agent_configuration"
        elif key == "agentPoolName":
            suggest = "agent_pool_name"
        elif key == "imageNames":
            suggest = "image_names"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "isPushEnabled":
            suggest = "is_push_enabled"
        elif key == "logTemplate":
            suggest = "log_template"
        elif key == "noCache":
            suggest = "no_cache"
        elif key == "sourceLocation":
            suggest = "source_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerBuildRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerBuildRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerBuildRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_file_path: str,
                 platform: 'outputs.PlatformPropertiesResponse',
                 type: str,
                 agent_configuration: Optional['outputs.AgentPropertiesResponse'] = None,
                 agent_pool_name: Optional[str] = None,
                 arguments: Optional[Sequence['outputs.ArgumentResponse']] = None,
                 credentials: Optional['outputs.CredentialsResponse'] = None,
                 image_names: Optional[Sequence[str]] = None,
                 is_archive_enabled: Optional[bool] = None,
                 is_push_enabled: Optional[bool] = None,
                 log_template: Optional[str] = None,
                 no_cache: Optional[bool] = None,
                 source_location: Optional[str] = None,
                 target: Optional[str] = None,
                 timeout: Optional[int] = None):
        """
        The parameters for a docker quick build.
        :param str docker_file_path: The Docker file path relative to the source location.
        :param 'PlatformPropertiesResponse' platform: The platform properties against which the run has to happen.
        :param str type: The type of the run request.
               Expected value is 'DockerBuildRequest'.
        :param 'AgentPropertiesResponse' agent_configuration: The machine configuration of the run agent.
        :param str agent_pool_name: The dedicated agent pool for the run.
        :param Sequence['ArgumentResponse'] arguments: The collection of override arguments to be used when executing the run.
        :param 'CredentialsResponse' credentials: The properties that describes a set of credentials that will be used when this run is invoked.
        :param Sequence[str] image_names: The fully qualified image names including the repository and tag.
        :param bool is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param bool is_push_enabled: The value of this property indicates whether the image built should be pushed to the registry or not.
        :param str log_template: The template that describes the repository and tag information for run log artifact.
        :param bool no_cache: The value of this property indicates whether the image cache is enabled or not.
        :param str source_location: The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
               If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        :param str target: The name of the target build stage for the docker build.
        :param int timeout: Run timeout in seconds.
        """
        pulumi.set(__self__, "docker_file_path", docker_file_path)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "type", 'DockerBuildRequest')
        if agent_configuration is not None:
            pulumi.set(__self__, "agent_configuration", agent_configuration)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if image_names is not None:
            pulumi.set(__self__, "image_names", image_names)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_push_enabled is None:
            is_push_enabled = True
        if is_push_enabled is not None:
            pulumi.set(__self__, "is_push_enabled", is_push_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if no_cache is None:
            no_cache = False
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout is None:
            timeout = 3600
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="dockerFilePath")
    def docker_file_path(self) -> str:
        """
        The Docker file path relative to the source location.
        """
        return pulumi.get(self, "docker_file_path")

    @property
    @pulumi.getter
    def platform(self) -> 'outputs.PlatformPropertiesResponse':
        """
        The platform properties against which the run has to happen.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the run request.
        Expected value is 'DockerBuildRequest'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> Optional['outputs.AgentPropertiesResponse']:
        """
        The machine configuration of the run agent.
        """
        return pulumi.get(self, "agent_configuration")

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[str]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence['outputs.ArgumentResponse']]:
        """
        The collection of override arguments to be used when executing the run.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.CredentialsResponse']:
        """
        The properties that describes a set of credentials that will be used when this run is invoked.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="imageNames")
    def image_names(self) -> Optional[Sequence[str]]:
        """
        The fully qualified image names including the repository and tag.
        """
        return pulumi.get(self, "image_names")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="isPushEnabled")
    def is_push_enabled(self) -> Optional[bool]:
        """
        The value of this property indicates whether the image built should be pushed to the registry or not.
        """
        return pulumi.get(self, "is_push_enabled")

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[str]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[bool]:
        """
        The value of this property indicates whether the image cache is enabled or not.
        """
        return pulumi.get(self, "no_cache")

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[str]:
        """
        The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
        If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        """
        return pulumi.get(self, "source_location")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The name of the target build stage for the docker build.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Run timeout in seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class DockerBuildStepResponse(dict):
    """
    The Docker build step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseImageDependencies":
            suggest = "base_image_dependencies"
        elif key == "dockerFilePath":
            suggest = "docker_file_path"
        elif key == "contextAccessToken":
            suggest = "context_access_token"
        elif key == "contextPath":
            suggest = "context_path"
        elif key == "imageNames":
            suggest = "image_names"
        elif key == "isPushEnabled":
            suggest = "is_push_enabled"
        elif key == "noCache":
            suggest = "no_cache"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerBuildStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerBuildStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerBuildStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_image_dependencies: Sequence['outputs.BaseImageDependencyResponse'],
                 docker_file_path: str,
                 type: str,
                 arguments: Optional[Sequence['outputs.ArgumentResponse']] = None,
                 context_access_token: Optional[str] = None,
                 context_path: Optional[str] = None,
                 image_names: Optional[Sequence[str]] = None,
                 is_push_enabled: Optional[bool] = None,
                 no_cache: Optional[bool] = None,
                 target: Optional[str] = None):
        """
        The Docker build step.
        :param Sequence['BaseImageDependencyResponse'] base_image_dependencies: List of base image dependencies for a step.
        :param str docker_file_path: The Docker file path relative to the source context.
        :param str type: The type of the step.
               Expected value is 'Docker'.
        :param Sequence['ArgumentResponse'] arguments: The collection of override arguments to be used when executing this build step.
        :param str context_access_token: The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        :param str context_path: The URL(absolute or relative) of the source context for the task step.
        :param Sequence[str] image_names: The fully qualified image names including the repository and tag.
        :param bool is_push_enabled: The value of this property indicates whether the image built should be pushed to the registry or not.
        :param bool no_cache: The value of this property indicates whether the image cache is enabled or not.
        :param str target: The name of the target build stage for the docker build.
        """
        pulumi.set(__self__, "base_image_dependencies", base_image_dependencies)
        pulumi.set(__self__, "docker_file_path", docker_file_path)
        pulumi.set(__self__, "type", 'Docker')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if context_access_token is not None:
            pulumi.set(__self__, "context_access_token", context_access_token)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if image_names is not None:
            pulumi.set(__self__, "image_names", image_names)
        if is_push_enabled is None:
            is_push_enabled = True
        if is_push_enabled is not None:
            pulumi.set(__self__, "is_push_enabled", is_push_enabled)
        if no_cache is None:
            no_cache = False
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="baseImageDependencies")
    def base_image_dependencies(self) -> Sequence['outputs.BaseImageDependencyResponse']:
        """
        List of base image dependencies for a step.
        """
        return pulumi.get(self, "base_image_dependencies")

    @property
    @pulumi.getter(name="dockerFilePath")
    def docker_file_path(self) -> str:
        """
        The Docker file path relative to the source context.
        """
        return pulumi.get(self, "docker_file_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the step.
        Expected value is 'Docker'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence['outputs.ArgumentResponse']]:
        """
        The collection of override arguments to be used when executing this build step.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="contextAccessToken")
    def context_access_token(self) -> Optional[str]:
        """
        The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        """
        return pulumi.get(self, "context_access_token")

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[str]:
        """
        The URL(absolute or relative) of the source context for the task step.
        """
        return pulumi.get(self, "context_path")

    @property
    @pulumi.getter(name="imageNames")
    def image_names(self) -> Optional[Sequence[str]]:
        """
        The fully qualified image names including the repository and tag.
        """
        return pulumi.get(self, "image_names")

    @property
    @pulumi.getter(name="isPushEnabled")
    def is_push_enabled(self) -> Optional[bool]:
        """
        The value of this property indicates whether the image built should be pushed to the registry or not.
        """
        return pulumi.get(self, "is_push_enabled")

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[bool]:
        """
        The value of this property indicates whether the image cache is enabled or not.
        """
        return pulumi.get(self, "no_cache")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The name of the target build stage for the docker build.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class EncodedTaskRunRequestResponse(dict):
    """
    The parameters for a quick task run request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodedTaskContent":
            suggest = "encoded_task_content"
        elif key == "agentConfiguration":
            suggest = "agent_configuration"
        elif key == "agentPoolName":
            suggest = "agent_pool_name"
        elif key == "encodedValuesContent":
            suggest = "encoded_values_content"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "logTemplate":
            suggest = "log_template"
        elif key == "sourceLocation":
            suggest = "source_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncodedTaskRunRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncodedTaskRunRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncodedTaskRunRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoded_task_content: str,
                 platform: 'outputs.PlatformPropertiesResponse',
                 type: str,
                 agent_configuration: Optional['outputs.AgentPropertiesResponse'] = None,
                 agent_pool_name: Optional[str] = None,
                 credentials: Optional['outputs.CredentialsResponse'] = None,
                 encoded_values_content: Optional[str] = None,
                 is_archive_enabled: Optional[bool] = None,
                 log_template: Optional[str] = None,
                 source_location: Optional[str] = None,
                 timeout: Optional[int] = None,
                 values: Optional[Sequence['outputs.SetValueResponse']] = None):
        """
        The parameters for a quick task run request.
        :param str encoded_task_content: Base64 encoded value of the template/definition file content.
        :param 'PlatformPropertiesResponse' platform: The platform properties against which the run has to happen.
        :param str type: The type of the run request.
               Expected value is 'EncodedTaskRunRequest'.
        :param 'AgentPropertiesResponse' agent_configuration: The machine configuration of the run agent.
        :param str agent_pool_name: The dedicated agent pool for the run.
        :param 'CredentialsResponse' credentials: The properties that describes a set of credentials that will be used when this run is invoked.
        :param str encoded_values_content: Base64 encoded value of the parameters/values file content.
        :param bool is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param str log_template: The template that describes the repository and tag information for run log artifact.
        :param str source_location: The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
               If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        :param int timeout: Run timeout in seconds.
        :param Sequence['SetValueResponse'] values: The collection of overridable values that can be passed when running a task.
        """
        pulumi.set(__self__, "encoded_task_content", encoded_task_content)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "type", 'EncodedTaskRunRequest')
        if agent_configuration is not None:
            pulumi.set(__self__, "agent_configuration", agent_configuration)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if encoded_values_content is not None:
            pulumi.set(__self__, "encoded_values_content", encoded_values_content)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if timeout is None:
            timeout = 3600
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="encodedTaskContent")
    def encoded_task_content(self) -> str:
        """
        Base64 encoded value of the template/definition file content.
        """
        return pulumi.get(self, "encoded_task_content")

    @property
    @pulumi.getter
    def platform(self) -> 'outputs.PlatformPropertiesResponse':
        """
        The platform properties against which the run has to happen.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the run request.
        Expected value is 'EncodedTaskRunRequest'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> Optional['outputs.AgentPropertiesResponse']:
        """
        The machine configuration of the run agent.
        """
        return pulumi.get(self, "agent_configuration")

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[str]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.CredentialsResponse']:
        """
        The properties that describes a set of credentials that will be used when this run is invoked.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="encodedValuesContent")
    def encoded_values_content(self) -> Optional[str]:
        """
        Base64 encoded value of the parameters/values file content.
        """
        return pulumi.get(self, "encoded_values_content")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[str]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[str]:
        """
        The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
        If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        """
        return pulumi.get(self, "source_location")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Run timeout in seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.SetValueResponse']]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EncodedTaskStepResponse(dict):
    """
    The properties of a encoded task step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseImageDependencies":
            suggest = "base_image_dependencies"
        elif key == "encodedTaskContent":
            suggest = "encoded_task_content"
        elif key == "contextAccessToken":
            suggest = "context_access_token"
        elif key == "contextPath":
            suggest = "context_path"
        elif key == "encodedValuesContent":
            suggest = "encoded_values_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncodedTaskStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncodedTaskStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncodedTaskStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_image_dependencies: Sequence['outputs.BaseImageDependencyResponse'],
                 encoded_task_content: str,
                 type: str,
                 context_access_token: Optional[str] = None,
                 context_path: Optional[str] = None,
                 encoded_values_content: Optional[str] = None,
                 values: Optional[Sequence['outputs.SetValueResponse']] = None):
        """
        The properties of a encoded task step.
        :param Sequence['BaseImageDependencyResponse'] base_image_dependencies: List of base image dependencies for a step.
        :param str encoded_task_content: Base64 encoded value of the template/definition file content.
        :param str type: The type of the step.
               Expected value is 'EncodedTask'.
        :param str context_access_token: The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        :param str context_path: The URL(absolute or relative) of the source context for the task step.
        :param str encoded_values_content: Base64 encoded value of the parameters/values file content.
        :param Sequence['SetValueResponse'] values: The collection of overridable values that can be passed when running a task.
        """
        pulumi.set(__self__, "base_image_dependencies", base_image_dependencies)
        pulumi.set(__self__, "encoded_task_content", encoded_task_content)
        pulumi.set(__self__, "type", 'EncodedTask')
        if context_access_token is not None:
            pulumi.set(__self__, "context_access_token", context_access_token)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if encoded_values_content is not None:
            pulumi.set(__self__, "encoded_values_content", encoded_values_content)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="baseImageDependencies")
    def base_image_dependencies(self) -> Sequence['outputs.BaseImageDependencyResponse']:
        """
        List of base image dependencies for a step.
        """
        return pulumi.get(self, "base_image_dependencies")

    @property
    @pulumi.getter(name="encodedTaskContent")
    def encoded_task_content(self) -> str:
        """
        Base64 encoded value of the template/definition file content.
        """
        return pulumi.get(self, "encoded_task_content")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the step.
        Expected value is 'EncodedTask'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="contextAccessToken")
    def context_access_token(self) -> Optional[str]:
        """
        The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        """
        return pulumi.get(self, "context_access_token")

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[str]:
        """
        The URL(absolute or relative) of the source context for the task step.
        """
        return pulumi.get(self, "context_path")

    @property
    @pulumi.getter(name="encodedValuesContent")
    def encoded_values_content(self) -> Optional[str]:
        """
        Base64 encoded value of the parameters/values file content.
        """
        return pulumi.get(self, "encoded_values_content")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.SetValueResponse']]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class FileTaskRunRequestResponse(dict):
    """
    The request parameters for a scheduling run against a task file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskFilePath":
            suggest = "task_file_path"
        elif key == "agentConfiguration":
            suggest = "agent_configuration"
        elif key == "agentPoolName":
            suggest = "agent_pool_name"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "logTemplate":
            suggest = "log_template"
        elif key == "sourceLocation":
            suggest = "source_location"
        elif key == "valuesFilePath":
            suggest = "values_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileTaskRunRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileTaskRunRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileTaskRunRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 platform: 'outputs.PlatformPropertiesResponse',
                 task_file_path: str,
                 type: str,
                 agent_configuration: Optional['outputs.AgentPropertiesResponse'] = None,
                 agent_pool_name: Optional[str] = None,
                 credentials: Optional['outputs.CredentialsResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 log_template: Optional[str] = None,
                 source_location: Optional[str] = None,
                 timeout: Optional[int] = None,
                 values: Optional[Sequence['outputs.SetValueResponse']] = None,
                 values_file_path: Optional[str] = None):
        """
        The request parameters for a scheduling run against a task file.
        :param 'PlatformPropertiesResponse' platform: The platform properties against which the run has to happen.
        :param str task_file_path: The template/definition file path relative to the source.
        :param str type: The type of the run request.
               Expected value is 'FileTaskRunRequest'.
        :param 'AgentPropertiesResponse' agent_configuration: The machine configuration of the run agent.
        :param str agent_pool_name: The dedicated agent pool for the run.
        :param 'CredentialsResponse' credentials: The properties that describes a set of credentials that will be used when this run is invoked.
        :param bool is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param str log_template: The template that describes the repository and tag information for run log artifact.
        :param str source_location: The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
               If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        :param int timeout: Run timeout in seconds.
        :param Sequence['SetValueResponse'] values: The collection of overridable values that can be passed when running a task.
        :param str values_file_path: The values/parameters file path relative to the source.
        """
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "task_file_path", task_file_path)
        pulumi.set(__self__, "type", 'FileTaskRunRequest')
        if agent_configuration is not None:
            pulumi.set(__self__, "agent_configuration", agent_configuration)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if timeout is None:
            timeout = 3600
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if values_file_path is not None:
            pulumi.set(__self__, "values_file_path", values_file_path)

    @property
    @pulumi.getter
    def platform(self) -> 'outputs.PlatformPropertiesResponse':
        """
        The platform properties against which the run has to happen.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="taskFilePath")
    def task_file_path(self) -> str:
        """
        The template/definition file path relative to the source.
        """
        return pulumi.get(self, "task_file_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the run request.
        Expected value is 'FileTaskRunRequest'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> Optional['outputs.AgentPropertiesResponse']:
        """
        The machine configuration of the run agent.
        """
        return pulumi.get(self, "agent_configuration")

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[str]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.CredentialsResponse']:
        """
        The properties that describes a set of credentials that will be used when this run is invoked.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[str]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[str]:
        """
        The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
        If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        """
        return pulumi.get(self, "source_location")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Run timeout in seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.SetValueResponse']]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="valuesFilePath")
    def values_file_path(self) -> Optional[str]:
        """
        The values/parameters file path relative to the source.
        """
        return pulumi.get(self, "values_file_path")


@pulumi.output_type
class FileTaskStepResponse(dict):
    """
    The properties of a task step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseImageDependencies":
            suggest = "base_image_dependencies"
        elif key == "taskFilePath":
            suggest = "task_file_path"
        elif key == "contextAccessToken":
            suggest = "context_access_token"
        elif key == "contextPath":
            suggest = "context_path"
        elif key == "valuesFilePath":
            suggest = "values_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileTaskStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileTaskStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileTaskStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_image_dependencies: Sequence['outputs.BaseImageDependencyResponse'],
                 task_file_path: str,
                 type: str,
                 context_access_token: Optional[str] = None,
                 context_path: Optional[str] = None,
                 values: Optional[Sequence['outputs.SetValueResponse']] = None,
                 values_file_path: Optional[str] = None):
        """
        The properties of a task step.
        :param Sequence['BaseImageDependencyResponse'] base_image_dependencies: List of base image dependencies for a step.
        :param str task_file_path: The task template/definition file path relative to the source context.
        :param str type: The type of the step.
               Expected value is 'FileTask'.
        :param str context_access_token: The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        :param str context_path: The URL(absolute or relative) of the source context for the task step.
        :param Sequence['SetValueResponse'] values: The collection of overridable values that can be passed when running a task.
        :param str values_file_path: The task values/parameters file path relative to the source context.
        """
        pulumi.set(__self__, "base_image_dependencies", base_image_dependencies)
        pulumi.set(__self__, "task_file_path", task_file_path)
        pulumi.set(__self__, "type", 'FileTask')
        if context_access_token is not None:
            pulumi.set(__self__, "context_access_token", context_access_token)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if values_file_path is not None:
            pulumi.set(__self__, "values_file_path", values_file_path)

    @property
    @pulumi.getter(name="baseImageDependencies")
    def base_image_dependencies(self) -> Sequence['outputs.BaseImageDependencyResponse']:
        """
        List of base image dependencies for a step.
        """
        return pulumi.get(self, "base_image_dependencies")

    @property
    @pulumi.getter(name="taskFilePath")
    def task_file_path(self) -> str:
        """
        The task template/definition file path relative to the source context.
        """
        return pulumi.get(self, "task_file_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the step.
        Expected value is 'FileTask'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="contextAccessToken")
    def context_access_token(self) -> Optional[str]:
        """
        The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        """
        return pulumi.get(self, "context_access_token")

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[str]:
        """
        The URL(absolute or relative) of the source context for the task step.
        """
        return pulumi.get(self, "context_path")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.SetValueResponse']]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="valuesFilePath")
    def values_file_path(self) -> Optional[str]:
        """
        The task values/parameters file path relative to the source context.
        """
        return pulumi.get(self, "values_file_path")


@pulumi.output_type
class IdentityPropertiesResponse(dict):
    """
    Managed identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']] = None):
        """
        Managed identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserIdentityPropertiesResponse'] user_assigned_identities: The list of user identities associated with the resource. The user identity 
               dictionary key references will be ARM resource ids in the form: 
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
                   providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']]:
        """
        The list of user identities associated with the resource. The user identity 
        dictionary key references will be ARM resource ids in the form: 
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
            providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ImageDescriptorResponse(dict):
    """
    Properties for a registry image.
    """
    def __init__(__self__, *,
                 digest: Optional[str] = None,
                 registry: Optional[str] = None,
                 repository: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        Properties for a registry image.
        :param str digest: The sha256-based digest of the image manifest.
        :param str registry: The registry login server.
        :param str repository: The repository name.
        :param str tag: The tag name.
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def digest(self) -> Optional[str]:
        """
        The sha256-based digest of the image manifest.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry login server.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The tag name.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class ImageUpdateTriggerResponse(dict):
    """
    The image update trigger that caused a build.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 images: Optional[Sequence['outputs.ImageDescriptorResponse']] = None,
                 timestamp: Optional[str] = None):
        """
        The image update trigger that caused a build.
        :param str id: The unique ID of the trigger.
        :param Sequence['ImageDescriptorResponse'] images: The list of image updates that caused the build.
        :param str timestamp: The timestamp when the image update happened.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique ID of the trigger.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Optional[Sequence['outputs.ImageDescriptorResponse']]:
        """
        The list of image updates that caused the build.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[str]:
        """
        The timestamp when the image update happened.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class OverrideTaskStepPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contextPath":
            suggest = "context_path"
        elif key == "updateTriggerToken":
            suggest = "update_trigger_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OverrideTaskStepPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OverrideTaskStepPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OverrideTaskStepPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Optional[Sequence['outputs.ArgumentResponse']] = None,
                 context_path: Optional[str] = None,
                 file: Optional[str] = None,
                 target: Optional[str] = None,
                 update_trigger_token: Optional[str] = None,
                 values: Optional[Sequence['outputs.SetValueResponse']] = None):
        """
        :param Sequence['ArgumentResponse'] arguments: Gets or sets the collection of override arguments to be used when
               executing a build step.
        :param str context_path: The source context against which run has to be queued.
        :param str file: The file against which run has to be queued.
        :param str target: The name of the target build stage for the docker build.
        :param str update_trigger_token: Base64 encoded update trigger token that will be attached with the base image trigger webhook.
        :param Sequence['SetValueResponse'] values: The collection of overridable values that can be passed when running a Task.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if update_trigger_token is not None:
            pulumi.set(__self__, "update_trigger_token", update_trigger_token)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence['outputs.ArgumentResponse']]:
        """
        Gets or sets the collection of override arguments to be used when
        executing a build step.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[str]:
        """
        The source context against which run has to be queued.
        """
        return pulumi.get(self, "context_path")

    @property
    @pulumi.getter
    def file(self) -> Optional[str]:
        """
        The file against which run has to be queued.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The name of the target build stage for the docker build.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="updateTriggerToken")
    def update_trigger_token(self) -> Optional[str]:
        """
        Base64 encoded update trigger token that will be attached with the base image trigger webhook.
        """
        return pulumi.get(self, "update_trigger_token")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence['outputs.SetValueResponse']]:
        """
        The collection of overridable values that can be passed when running a Task.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PlatformPropertiesResponse(dict):
    """
    The platform properties against which the run has to happen.
    """
    def __init__(__self__, *,
                 os: str,
                 architecture: Optional[str] = None,
                 variant: Optional[str] = None):
        """
        The platform properties against which the run has to happen.
        :param str os: The operating system type required for the run.
        :param str architecture: The OS architecture.
        :param str variant: Variant of the CPU.
        """
        pulumi.set(__self__, "os", os)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if variant is not None:
            pulumi.set(__self__, "variant", variant)

    @property
    @pulumi.getter
    def os(self) -> str:
        """
        The operating system type required for the run.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter
    def architecture(self) -> Optional[str]:
        """
        The OS architecture.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def variant(self) -> Optional[str]:
        """
        Variant of the CPU.
        """
        return pulumi.get(self, "variant")


@pulumi.output_type
class RunResponse(dict):
    """
    Run resource properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logArtifact":
            suggest = "log_artifact"
        elif key == "runErrorMessage":
            suggest = "run_error_message"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "agentConfiguration":
            suggest = "agent_configuration"
        elif key == "agentPoolName":
            suggest = "agent_pool_name"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "customRegistries":
            suggest = "custom_registries"
        elif key == "finishTime":
            suggest = "finish_time"
        elif key == "imageUpdateTrigger":
            suggest = "image_update_trigger"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "outputImages":
            suggest = "output_images"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "runId":
            suggest = "run_id"
        elif key == "runType":
            suggest = "run_type"
        elif key == "sourceRegistryAuth":
            suggest = "source_registry_auth"
        elif key == "sourceTrigger":
            suggest = "source_trigger"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timerTrigger":
            suggest = "timer_trigger"
        elif key == "updateTriggerToken":
            suggest = "update_trigger_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 log_artifact: 'outputs.ImageDescriptorResponse',
                 name: str,
                 run_error_message: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 agent_configuration: Optional['outputs.AgentPropertiesResponse'] = None,
                 agent_pool_name: Optional[str] = None,
                 create_time: Optional[str] = None,
                 custom_registries: Optional[Sequence[str]] = None,
                 finish_time: Optional[str] = None,
                 image_update_trigger: Optional['outputs.ImageUpdateTriggerResponse'] = None,
                 is_archive_enabled: Optional[bool] = None,
                 last_updated_time: Optional[str] = None,
                 output_images: Optional[Sequence['outputs.ImageDescriptorResponse']] = None,
                 platform: Optional['outputs.PlatformPropertiesResponse'] = None,
                 provisioning_state: Optional[str] = None,
                 run_id: Optional[str] = None,
                 run_type: Optional[str] = None,
                 source_registry_auth: Optional[str] = None,
                 source_trigger: Optional['outputs.SourceTriggerDescriptorResponse'] = None,
                 start_time: Optional[str] = None,
                 status: Optional[str] = None,
                 task: Optional[str] = None,
                 timer_trigger: Optional['outputs.TimerTriggerDescriptorResponse'] = None,
                 update_trigger_token: Optional[str] = None):
        """
        Run resource properties
        :param str id: The resource ID.
        :param 'ImageDescriptorResponse' log_artifact: The image description for the log artifact.
        :param str name: The name of the resource.
        :param str run_error_message: The error message received from backend systems after the run is scheduled.
        :param 'SystemDataResponse' system_data: Metadata pertaining to creation and last modification of the resource.
        :param str type: The type of the resource.
        :param 'AgentPropertiesResponse' agent_configuration: The machine configuration of the run agent.
        :param str agent_pool_name: The dedicated agent pool for the run.
        :param str create_time: The time the run was scheduled.
        :param Sequence[str] custom_registries: The list of custom registries that were logged in during this run.
        :param str finish_time: The time the run finished.
        :param 'ImageUpdateTriggerResponse' image_update_trigger: The image update trigger that caused the run. This is applicable if the task has base image trigger configured.
        :param bool is_archive_enabled: The value that indicates whether archiving is enabled or not.
        :param str last_updated_time: The last updated time for the run.
        :param Sequence['ImageDescriptorResponse'] output_images: The list of all images that were generated from the run. This is applicable if the run generates base image dependencies.
        :param 'PlatformPropertiesResponse' platform: The platform properties against which the run will happen.
        :param str provisioning_state: The provisioning state of a run.
        :param str run_id: The unique identifier for the run.
        :param str run_type: The type of run.
        :param str source_registry_auth: The scope of the credentials that were used to login to the source registry during this run.
        :param 'SourceTriggerDescriptorResponse' source_trigger: The source trigger that caused the run.
        :param str start_time: The time the run started.
        :param str status: The current status of the run.
        :param str task: The task against which run was scheduled.
        :param 'TimerTriggerDescriptorResponse' timer_trigger: The timer trigger that caused the run.
        :param str update_trigger_token: The update trigger token passed for the Run.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_artifact", log_artifact)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "run_error_message", run_error_message)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if agent_configuration is not None:
            pulumi.set(__self__, "agent_configuration", agent_configuration)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_registries is not None:
            pulumi.set(__self__, "custom_registries", custom_registries)
        if finish_time is not None:
            pulumi.set(__self__, "finish_time", finish_time)
        if image_update_trigger is not None:
            pulumi.set(__self__, "image_update_trigger", image_update_trigger)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if output_images is not None:
            pulumi.set(__self__, "output_images", output_images)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if run_id is not None:
            pulumi.set(__self__, "run_id", run_id)
        if run_type is not None:
            pulumi.set(__self__, "run_type", run_type)
        if source_registry_auth is not None:
            pulumi.set(__self__, "source_registry_auth", source_registry_auth)
        if source_trigger is not None:
            pulumi.set(__self__, "source_trigger", source_trigger)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if task is not None:
            pulumi.set(__self__, "task", task)
        if timer_trigger is not None:
            pulumi.set(__self__, "timer_trigger", timer_trigger)
        if update_trigger_token is not None:
            pulumi.set(__self__, "update_trigger_token", update_trigger_token)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logArtifact")
    def log_artifact(self) -> 'outputs.ImageDescriptorResponse':
        """
        The image description for the log artifact.
        """
        return pulumi.get(self, "log_artifact")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runErrorMessage")
    def run_error_message(self) -> str:
        """
        The error message received from backend systems after the run is scheduled.
        """
        return pulumi.get(self, "run_error_message")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> Optional['outputs.AgentPropertiesResponse']:
        """
        The machine configuration of the run agent.
        """
        return pulumi.get(self, "agent_configuration")

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[str]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        The time the run was scheduled.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customRegistries")
    def custom_registries(self) -> Optional[Sequence[str]]:
        """
        The list of custom registries that were logged in during this run.
        """
        return pulumi.get(self, "custom_registries")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> Optional[str]:
        """
        The time the run finished.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter(name="imageUpdateTrigger")
    def image_update_trigger(self) -> Optional['outputs.ImageUpdateTriggerResponse']:
        """
        The image update trigger that caused the run. This is applicable if the task has base image trigger configured.
        """
        return pulumi.get(self, "image_update_trigger")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        The value that indicates whether archiving is enabled or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        The last updated time for the run.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="outputImages")
    def output_images(self) -> Optional[Sequence['outputs.ImageDescriptorResponse']]:
        """
        The list of all images that were generated from the run. This is applicable if the run generates base image dependencies.
        """
        return pulumi.get(self, "output_images")

    @property
    @pulumi.getter
    def platform(self) -> Optional['outputs.PlatformPropertiesResponse']:
        """
        The platform properties against which the run will happen.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of a run.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> Optional[str]:
        """
        The unique identifier for the run.
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter(name="runType")
    def run_type(self) -> Optional[str]:
        """
        The type of run.
        """
        return pulumi.get(self, "run_type")

    @property
    @pulumi.getter(name="sourceRegistryAuth")
    def source_registry_auth(self) -> Optional[str]:
        """
        The scope of the credentials that were used to login to the source registry during this run.
        """
        return pulumi.get(self, "source_registry_auth")

    @property
    @pulumi.getter(name="sourceTrigger")
    def source_trigger(self) -> Optional['outputs.SourceTriggerDescriptorResponse']:
        """
        The source trigger that caused the run.
        """
        return pulumi.get(self, "source_trigger")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The time the run started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current status of the run.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def task(self) -> Optional[str]:
        """
        The task against which run was scheduled.
        """
        return pulumi.get(self, "task")

    @property
    @pulumi.getter(name="timerTrigger")
    def timer_trigger(self) -> Optional['outputs.TimerTriggerDescriptorResponse']:
        """
        The timer trigger that caused the run.
        """
        return pulumi.get(self, "timer_trigger")

    @property
    @pulumi.getter(name="updateTriggerToken")
    def update_trigger_token(self) -> Optional[str]:
        """
        The update trigger token passed for the Run.
        """
        return pulumi.get(self, "update_trigger_token")


@pulumi.output_type
class SecretObjectResponse(dict):
    """
    Describes the properties of a secret object value.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Describes the properties of a secret object value.
        :param str type: The type of the secret object which determines how the value of the secret object has to be
               interpreted.
        :param str value: The value of the secret. The format of this value will be determined
               based on the type of the secret object. If the type is Opaque, the value will be
               used as is without any modification.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the secret object which determines how the value of the secret object has to be
        interpreted.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the secret. The format of this value will be determined
        based on the type of the secret object. If the type is Opaque, the value will be
        used as is without any modification.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SetValueResponse(dict):
    """
    The properties of a overridable value that can be passed to a task template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isSecret":
            suggest = "is_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SetValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SetValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SetValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 is_secret: Optional[bool] = None):
        """
        The properties of a overridable value that can be passed to a task template.
        :param str name: The name of the overridable value.
        :param str value: The overridable value.
        :param bool is_secret: Flag to indicate whether the value represents a secret or not.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if is_secret is None:
            is_secret = False
        if is_secret is not None:
            pulumi.set(__self__, "is_secret", is_secret)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the overridable value.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The overridable value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[bool]:
        """
        Flag to indicate whether the value represents a secret or not.
        """
        return pulumi.get(self, "is_secret")


@pulumi.output_type
class SourcePropertiesResponse(dict):
    """
    The properties of the source code repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryUrl":
            suggest = "repository_url"
        elif key == "sourceControlType":
            suggest = "source_control_type"
        elif key == "sourceControlAuthProperties":
            suggest = "source_control_auth_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourcePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourcePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourcePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_url: str,
                 source_control_type: str,
                 branch: Optional[str] = None,
                 source_control_auth_properties: Optional['outputs.AuthInfoResponse'] = None):
        """
        The properties of the source code repository.
        :param str repository_url: The full URL to the source code repository
        :param str source_control_type: The type of source control service.
        :param str branch: The branch name of the source code.
        :param 'AuthInfoResponse' source_control_auth_properties: The authorization properties for accessing the source code repository and to set up
               webhooks for notifications.
        """
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "source_control_type", source_control_type)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if source_control_auth_properties is not None:
            pulumi.set(__self__, "source_control_auth_properties", source_control_auth_properties)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> str:
        """
        The full URL to the source code repository
        """
        return pulumi.get(self, "repository_url")

    @property
    @pulumi.getter(name="sourceControlType")
    def source_control_type(self) -> str:
        """
        The type of source control service.
        """
        return pulumi.get(self, "source_control_type")

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The branch name of the source code.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="sourceControlAuthProperties")
    def source_control_auth_properties(self) -> Optional['outputs.AuthInfoResponse']:
        """
        The authorization properties for accessing the source code repository and to set up
        webhooks for notifications.
        """
        return pulumi.get(self, "source_control_auth_properties")


@pulumi.output_type
class SourceRegistryCredentialsResponse(dict):
    """
    Describes the credential parameters for accessing the source registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginMode":
            suggest = "login_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceRegistryCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceRegistryCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceRegistryCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_mode: Optional[str] = None):
        """
        Describes the credential parameters for accessing the source registry.
        :param str login_mode: The authentication mode which determines the source registry login scope. The credentials for the source registry
               will be generated using the given scope. These credentials will be used to login to
               the source registry during the run.
        """
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[str]:
        """
        The authentication mode which determines the source registry login scope. The credentials for the source registry
        will be generated using the given scope. These credentials will be used to login to
        the source registry during the run.
        """
        return pulumi.get(self, "login_mode")


@pulumi.output_type
class SourceTriggerDescriptorResponse(dict):
    """
    The source trigger that caused a run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitId":
            suggest = "commit_id"
        elif key == "eventType":
            suggest = "event_type"
        elif key == "providerType":
            suggest = "provider_type"
        elif key == "pullRequestId":
            suggest = "pull_request_id"
        elif key == "repositoryUrl":
            suggest = "repository_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceTriggerDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceTriggerDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceTriggerDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: Optional[str] = None,
                 commit_id: Optional[str] = None,
                 event_type: Optional[str] = None,
                 id: Optional[str] = None,
                 provider_type: Optional[str] = None,
                 pull_request_id: Optional[str] = None,
                 repository_url: Optional[str] = None):
        """
        The source trigger that caused a run.
        :param str branch_name: The branch name in the repository.
        :param str commit_id: The unique ID that identifies a commit.
        :param str event_type: The event type of the trigger.
        :param str id: The unique ID of the trigger.
        :param str provider_type: The source control provider type.
        :param str pull_request_id: The unique ID that identifies pull request.
        :param str repository_url: The repository URL.
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_id is not None:
            pulumi.set(__self__, "commit_id", commit_id)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provider_type is not None:
            pulumi.set(__self__, "provider_type", provider_type)
        if pull_request_id is not None:
            pulumi.set(__self__, "pull_request_id", pull_request_id)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[str]:
        """
        The branch name in the repository.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> Optional[str]:
        """
        The unique ID that identifies a commit.
        """
        return pulumi.get(self, "commit_id")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[str]:
        """
        The event type of the trigger.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique ID of the trigger.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> Optional[str]:
        """
        The source control provider type.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="pullRequestId")
    def pull_request_id(self) -> Optional[str]:
        """
        The unique ID that identifies pull request.
        """
        return pulumi.get(self, "pull_request_id")

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[str]:
        """
        The repository URL.
        """
        return pulumi.get(self, "repository_url")


@pulumi.output_type
class SourceTriggerResponse(dict):
    """
    The properties of a source based trigger.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRepository":
            suggest = "source_repository"
        elif key == "sourceTriggerEvents":
            suggest = "source_trigger_events"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 source_repository: 'outputs.SourcePropertiesResponse',
                 source_trigger_events: Sequence[str],
                 status: Optional[str] = None):
        """
        The properties of a source based trigger.
        :param str name: The name of the trigger.
        :param 'SourcePropertiesResponse' source_repository: The properties that describes the source(code) for the task.
        :param Sequence[str] source_trigger_events: The source event corresponding to the trigger.
        :param str status: The current status of trigger.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source_repository", source_repository)
        pulumi.set(__self__, "source_trigger_events", source_trigger_events)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> 'outputs.SourcePropertiesResponse':
        """
        The properties that describes the source(code) for the task.
        """
        return pulumi.get(self, "source_repository")

    @property
    @pulumi.getter(name="sourceTriggerEvents")
    def source_trigger_events(self) -> Sequence[str]:
        """
        The source event corresponding to the trigger.
        """
        return pulumi.get(self, "source_trigger_events")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource modification (UTC).
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TaskRunRequestResponse(dict):
    """
    The parameters for a task run request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskId":
            suggest = "task_id"
        elif key == "agentPoolName":
            suggest = "agent_pool_name"
        elif key == "isArchiveEnabled":
            suggest = "is_archive_enabled"
        elif key == "logTemplate":
            suggest = "log_template"
        elif key == "overrideTaskStepProperties":
            suggest = "override_task_step_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskRunRequestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskRunRequestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskRunRequestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_id: str,
                 type: str,
                 agent_pool_name: Optional[str] = None,
                 is_archive_enabled: Optional[bool] = None,
                 log_template: Optional[str] = None,
                 override_task_step_properties: Optional['outputs.OverrideTaskStepPropertiesResponse'] = None):
        """
        The parameters for a task run request.
        :param str task_id: The resource ID of task against which run has to be queued.
        :param str type: The type of the run request.
               Expected value is 'TaskRunRequest'.
        :param str agent_pool_name: The dedicated agent pool for the run.
        :param bool is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param str log_template: The template that describes the repository and tag information for run log artifact.
        :param 'OverrideTaskStepPropertiesResponse' override_task_step_properties: Set of overridable parameters that can be passed when running a Task.
        """
        pulumi.set(__self__, "task_id", task_id)
        pulumi.set(__self__, "type", 'TaskRunRequest')
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if override_task_step_properties is not None:
            pulumi.set(__self__, "override_task_step_properties", override_task_step_properties)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> str:
        """
        The resource ID of task against which run has to be queued.
        """
        return pulumi.get(self, "task_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the run request.
        Expected value is 'TaskRunRequest'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[str]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[bool]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[str]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @property
    @pulumi.getter(name="overrideTaskStepProperties")
    def override_task_step_properties(self) -> Optional['outputs.OverrideTaskStepPropertiesResponse']:
        """
        Set of overridable parameters that can be passed when running a Task.
        """
        return pulumi.get(self, "override_task_step_properties")


@pulumi.output_type
class TimerTriggerDescriptorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleOccurrence":
            suggest = "schedule_occurrence"
        elif key == "timerTriggerName":
            suggest = "timer_trigger_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimerTriggerDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimerTriggerDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimerTriggerDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_occurrence: Optional[str] = None,
                 timer_trigger_name: Optional[str] = None):
        """
        :param str schedule_occurrence: The occurrence that triggered the run.
        :param str timer_trigger_name: The timer trigger name that caused the run.
        """
        if schedule_occurrence is not None:
            pulumi.set(__self__, "schedule_occurrence", schedule_occurrence)
        if timer_trigger_name is not None:
            pulumi.set(__self__, "timer_trigger_name", timer_trigger_name)

    @property
    @pulumi.getter(name="scheduleOccurrence")
    def schedule_occurrence(self) -> Optional[str]:
        """
        The occurrence that triggered the run.
        """
        return pulumi.get(self, "schedule_occurrence")

    @property
    @pulumi.getter(name="timerTriggerName")
    def timer_trigger_name(self) -> Optional[str]:
        """
        The timer trigger name that caused the run.
        """
        return pulumi.get(self, "timer_trigger_name")


@pulumi.output_type
class TimerTriggerResponse(dict):
    """
    The properties of a timer trigger.
    """
    def __init__(__self__, *,
                 name: str,
                 schedule: str,
                 status: Optional[str] = None):
        """
        The properties of a timer trigger.
        :param str name: The name of the trigger.
        :param str schedule: The CRON expression for the task schedule
        :param str status: The current status of trigger.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schedule", schedule)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        The CRON expression for the task schedule
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class TriggerPropertiesResponse(dict):
    """
    The properties of a trigger.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseImageTrigger":
            suggest = "base_image_trigger"
        elif key == "sourceTriggers":
            suggest = "source_triggers"
        elif key == "timerTriggers":
            suggest = "timer_triggers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_image_trigger: Optional['outputs.BaseImageTriggerResponse'] = None,
                 source_triggers: Optional[Sequence['outputs.SourceTriggerResponse']] = None,
                 timer_triggers: Optional[Sequence['outputs.TimerTriggerResponse']] = None):
        """
        The properties of a trigger.
        :param 'BaseImageTriggerResponse' base_image_trigger: The trigger based on base image dependencies.
        :param Sequence['SourceTriggerResponse'] source_triggers: The collection of triggers based on source code repository.
        :param Sequence['TimerTriggerResponse'] timer_triggers: The collection of timer triggers.
        """
        if base_image_trigger is not None:
            pulumi.set(__self__, "base_image_trigger", base_image_trigger)
        if source_triggers is not None:
            pulumi.set(__self__, "source_triggers", source_triggers)
        if timer_triggers is not None:
            pulumi.set(__self__, "timer_triggers", timer_triggers)

    @property
    @pulumi.getter(name="baseImageTrigger")
    def base_image_trigger(self) -> Optional['outputs.BaseImageTriggerResponse']:
        """
        The trigger based on base image dependencies.
        """
        return pulumi.get(self, "base_image_trigger")

    @property
    @pulumi.getter(name="sourceTriggers")
    def source_triggers(self) -> Optional[Sequence['outputs.SourceTriggerResponse']]:
        """
        The collection of triggers based on source code repository.
        """
        return pulumi.get(self, "source_triggers")

    @property
    @pulumi.getter(name="timerTriggers")
    def timer_triggers(self) -> Optional[Sequence['outputs.TimerTriggerResponse']]:
        """
        The collection of timer triggers.
        """
        return pulumi.get(self, "timer_triggers")


@pulumi.output_type
class UserIdentityPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 principal_id: Optional[str] = None):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


