# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccountPropertiesResponse',
    'ApiPropertiesResponse',
    'CallRateLimitResponse',
    'CommitmentPeriodResponse',
    'CommitmentPlanPropertiesResponse',
    'CommitmentQuotaResponse',
    'DeploymentModelResponse',
    'DeploymentPropertiesResponse',
    'DeploymentScaleSettingsResponse',
    'EncryptionResponse',
    'IdentityResponse',
    'IpRuleResponse',
    'KeyVaultPropertiesResponse',
    'NetworkRuleSetResponse',
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'QuotaLimitResponse',
    'RequestMatchPatternResponse',
    'SkuCapabilityResponse',
    'SkuChangeInfoResponse',
    'SkuResponse',
    'SystemDataResponse',
    'ThrottlingRuleResponse',
    'UserAssignedIdentityResponse',
    'UserOwnedStorageResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class AccountPropertiesResponse(dict):
    """
    Properties of Cognitive Services account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callRateLimit":
            suggest = "call_rate_limit"
        elif key == "dateCreated":
            suggest = "date_created"
        elif key == "internalId":
            suggest = "internal_id"
        elif key == "isMigrated":
            suggest = "is_migrated"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "quotaLimit":
            suggest = "quota_limit"
        elif key == "skuChangeInfo":
            suggest = "sku_change_info"
        elif key == "allowedFqdnList":
            suggest = "allowed_fqdn_list"
        elif key == "apiProperties":
            suggest = "api_properties"
        elif key == "customSubDomainName":
            suggest = "custom_sub_domain_name"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "migrationToken":
            suggest = "migration_token"
        elif key == "networkAcls":
            suggest = "network_acls"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "restrictOutboundNetworkAccess":
            suggest = "restrict_outbound_network_access"
        elif key == "userOwnedStorage":
            suggest = "user_owned_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 call_rate_limit: 'outputs.CallRateLimitResponse',
                 capabilities: Sequence['outputs.SkuCapabilityResponse'],
                 date_created: str,
                 endpoint: str,
                 endpoints: Mapping[str, str],
                 internal_id: str,
                 is_migrated: bool,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionResponse'],
                 provisioning_state: str,
                 quota_limit: 'outputs.QuotaLimitResponse',
                 sku_change_info: 'outputs.SkuChangeInfoResponse',
                 allowed_fqdn_list: Optional[Sequence[str]] = None,
                 api_properties: Optional['outputs.ApiPropertiesResponse'] = None,
                 custom_sub_domain_name: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 encryption: Optional['outputs.EncryptionResponse'] = None,
                 migration_token: Optional[str] = None,
                 network_acls: Optional['outputs.NetworkRuleSetResponse'] = None,
                 public_network_access: Optional[str] = None,
                 restore: Optional[bool] = None,
                 restrict_outbound_network_access: Optional[bool] = None,
                 user_owned_storage: Optional[Sequence['outputs.UserOwnedStorageResponse']] = None):
        """
        Properties of Cognitive Services account.
        :param 'CallRateLimitResponse' call_rate_limit: The call rate limit Cognitive Services account.
        :param Sequence['SkuCapabilityResponse'] capabilities: Gets the capabilities of the cognitive services account. Each item indicates the capability of a specific feature. The values are read-only and for reference only.
        :param str date_created: Gets the date of cognitive services account creation.
        :param str endpoint: Endpoint of the created account.
        :param str internal_id: The internal identifier (deprecated, do not use this property).
        :param bool is_migrated: If the resource is migrated from an existing key.
        :param Sequence['PrivateEndpointConnectionResponse'] private_endpoint_connections: The private endpoint connection associated with the Cognitive Services account.
        :param str provisioning_state: Gets the status of the cognitive services account at the time the operation was called.
        :param 'SkuChangeInfoResponse' sku_change_info: Sku change info of account.
        :param 'ApiPropertiesResponse' api_properties: The api properties for special APIs.
        :param str custom_sub_domain_name: Optional subdomain name used for token-based authentication.
        :param 'EncryptionResponse' encryption: The encryption properties for this resource.
        :param str migration_token: Resource migration token.
        :param 'NetworkRuleSetResponse' network_acls: A collection of rules governing the accessibility from specific network locations.
        :param str public_network_access: Whether or not public endpoint access is allowed for this account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
        :param Sequence['UserOwnedStorageResponse'] user_owned_storage: The storage accounts for this resource.
        """
        pulumi.set(__self__, "call_rate_limit", call_rate_limit)
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "internal_id", internal_id)
        pulumi.set(__self__, "is_migrated", is_migrated)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "quota_limit", quota_limit)
        pulumi.set(__self__, "sku_change_info", sku_change_info)
        if allowed_fqdn_list is not None:
            pulumi.set(__self__, "allowed_fqdn_list", allowed_fqdn_list)
        if api_properties is not None:
            pulumi.set(__self__, "api_properties", api_properties)
        if custom_sub_domain_name is not None:
            pulumi.set(__self__, "custom_sub_domain_name", custom_sub_domain_name)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if migration_token is not None:
            pulumi.set(__self__, "migration_token", migration_token)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if restrict_outbound_network_access is not None:
            pulumi.set(__self__, "restrict_outbound_network_access", restrict_outbound_network_access)
        if user_owned_storage is not None:
            pulumi.set(__self__, "user_owned_storage", user_owned_storage)

    @property
    @pulumi.getter(name="callRateLimit")
    def call_rate_limit(self) -> 'outputs.CallRateLimitResponse':
        """
        The call rate limit Cognitive Services account.
        """
        return pulumi.get(self, "call_rate_limit")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.SkuCapabilityResponse']:
        """
        Gets the capabilities of the cognitive services account. Each item indicates the capability of a specific feature. The values are read-only and for reference only.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> str:
        """
        Gets the date of cognitive services account creation.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint of the created account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def endpoints(self) -> Mapping[str, str]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> str:
        """
        The internal identifier (deprecated, do not use this property).
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="isMigrated")
    def is_migrated(self) -> bool:
        """
        If the resource is migrated from an existing key.
        """
        return pulumi.get(self, "is_migrated")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionResponse']:
        """
        The private endpoint connection associated with the Cognitive Services account.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the status of the cognitive services account at the time the operation was called.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="quotaLimit")
    def quota_limit(self) -> 'outputs.QuotaLimitResponse':
        return pulumi.get(self, "quota_limit")

    @property
    @pulumi.getter(name="skuChangeInfo")
    def sku_change_info(self) -> 'outputs.SkuChangeInfoResponse':
        """
        Sku change info of account.
        """
        return pulumi.get(self, "sku_change_info")

    @property
    @pulumi.getter(name="allowedFqdnList")
    def allowed_fqdn_list(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_fqdn_list")

    @property
    @pulumi.getter(name="apiProperties")
    def api_properties(self) -> Optional['outputs.ApiPropertiesResponse']:
        """
        The api properties for special APIs.
        """
        return pulumi.get(self, "api_properties")

    @property
    @pulumi.getter(name="customSubDomainName")
    def custom_sub_domain_name(self) -> Optional[str]:
        """
        Optional subdomain name used for token-based authentication.
        """
        return pulumi.get(self, "custom_sub_domain_name")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.EncryptionResponse']:
        """
        The encryption properties for this resource.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="migrationToken")
    def migration_token(self) -> Optional[str]:
        """
        Resource migration token.
        """
        return pulumi.get(self, "migration_token")

    @property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional['outputs.NetworkRuleSetResponse']:
        """
        A collection of rules governing the accessibility from specific network locations.
        """
        return pulumi.get(self, "network_acls")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Whether or not public endpoint access is allowed for this account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def restore(self) -> Optional[bool]:
        return pulumi.get(self, "restore")

    @property
    @pulumi.getter(name="restrictOutboundNetworkAccess")
    def restrict_outbound_network_access(self) -> Optional[bool]:
        return pulumi.get(self, "restrict_outbound_network_access")

    @property
    @pulumi.getter(name="userOwnedStorage")
    def user_owned_storage(self) -> Optional[Sequence['outputs.UserOwnedStorageResponse']]:
        """
        The storage accounts for this resource.
        """
        return pulumi.get(self, "user_owned_storage")


@pulumi.output_type
class ApiPropertiesResponse(dict):
    """
    The api properties for special APIs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadClientId":
            suggest = "aad_client_id"
        elif key == "aadTenantId":
            suggest = "aad_tenant_id"
        elif key == "eventHubConnectionString":
            suggest = "event_hub_connection_string"
        elif key == "qnaAzureSearchEndpointId":
            suggest = "qna_azure_search_endpoint_id"
        elif key == "qnaAzureSearchEndpointKey":
            suggest = "qna_azure_search_endpoint_key"
        elif key == "qnaRuntimeEndpoint":
            suggest = "qna_runtime_endpoint"
        elif key == "statisticsEnabled":
            suggest = "statistics_enabled"
        elif key == "storageAccountConnectionString":
            suggest = "storage_account_connection_string"
        elif key == "superUser":
            suggest = "super_user"
        elif key == "websiteName":
            suggest = "website_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_client_id: Optional[str] = None,
                 aad_tenant_id: Optional[str] = None,
                 event_hub_connection_string: Optional[str] = None,
                 qna_azure_search_endpoint_id: Optional[str] = None,
                 qna_azure_search_endpoint_key: Optional[str] = None,
                 qna_runtime_endpoint: Optional[str] = None,
                 statistics_enabled: Optional[bool] = None,
                 storage_account_connection_string: Optional[str] = None,
                 super_user: Optional[str] = None,
                 website_name: Optional[str] = None):
        """
        The api properties for special APIs.
        :param str aad_client_id: (Metrics Advisor Only) The Azure AD Client Id (Application Id).
        :param str aad_tenant_id: (Metrics Advisor Only) The Azure AD Tenant Id.
        :param str event_hub_connection_string: (Personalization Only) The flag to enable statistics of Bing Search.
        :param str qna_azure_search_endpoint_id: (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
        :param str qna_azure_search_endpoint_key: (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
        :param str qna_runtime_endpoint: (QnAMaker Only) The runtime endpoint of QnAMaker.
        :param bool statistics_enabled: (Bing Search Only) The flag to enable statistics of Bing Search.
        :param str storage_account_connection_string: (Personalization Only) The storage account connection string.
        :param str super_user: (Metrics Advisor Only) The super user of Metrics Advisor.
        :param str website_name: (Metrics Advisor Only) The website name of Metrics Advisor.
        """
        if aad_client_id is not None:
            pulumi.set(__self__, "aad_client_id", aad_client_id)
        if aad_tenant_id is not None:
            pulumi.set(__self__, "aad_tenant_id", aad_tenant_id)
        if event_hub_connection_string is not None:
            pulumi.set(__self__, "event_hub_connection_string", event_hub_connection_string)
        if qna_azure_search_endpoint_id is not None:
            pulumi.set(__self__, "qna_azure_search_endpoint_id", qna_azure_search_endpoint_id)
        if qna_azure_search_endpoint_key is not None:
            pulumi.set(__self__, "qna_azure_search_endpoint_key", qna_azure_search_endpoint_key)
        if qna_runtime_endpoint is not None:
            pulumi.set(__self__, "qna_runtime_endpoint", qna_runtime_endpoint)
        if statistics_enabled is not None:
            pulumi.set(__self__, "statistics_enabled", statistics_enabled)
        if storage_account_connection_string is not None:
            pulumi.set(__self__, "storage_account_connection_string", storage_account_connection_string)
        if super_user is not None:
            pulumi.set(__self__, "super_user", super_user)
        if website_name is not None:
            pulumi.set(__self__, "website_name", website_name)

    @property
    @pulumi.getter(name="aadClientId")
    def aad_client_id(self) -> Optional[str]:
        """
        (Metrics Advisor Only) The Azure AD Client Id (Application Id).
        """
        return pulumi.get(self, "aad_client_id")

    @property
    @pulumi.getter(name="aadTenantId")
    def aad_tenant_id(self) -> Optional[str]:
        """
        (Metrics Advisor Only) The Azure AD Tenant Id.
        """
        return pulumi.get(self, "aad_tenant_id")

    @property
    @pulumi.getter(name="eventHubConnectionString")
    def event_hub_connection_string(self) -> Optional[str]:
        """
        (Personalization Only) The flag to enable statistics of Bing Search.
        """
        return pulumi.get(self, "event_hub_connection_string")

    @property
    @pulumi.getter(name="qnaAzureSearchEndpointId")
    def qna_azure_search_endpoint_id(self) -> Optional[str]:
        """
        (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
        """
        return pulumi.get(self, "qna_azure_search_endpoint_id")

    @property
    @pulumi.getter(name="qnaAzureSearchEndpointKey")
    def qna_azure_search_endpoint_key(self) -> Optional[str]:
        """
        (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
        """
        return pulumi.get(self, "qna_azure_search_endpoint_key")

    @property
    @pulumi.getter(name="qnaRuntimeEndpoint")
    def qna_runtime_endpoint(self) -> Optional[str]:
        """
        (QnAMaker Only) The runtime endpoint of QnAMaker.
        """
        return pulumi.get(self, "qna_runtime_endpoint")

    @property
    @pulumi.getter(name="statisticsEnabled")
    def statistics_enabled(self) -> Optional[bool]:
        """
        (Bing Search Only) The flag to enable statistics of Bing Search.
        """
        return pulumi.get(self, "statistics_enabled")

    @property
    @pulumi.getter(name="storageAccountConnectionString")
    def storage_account_connection_string(self) -> Optional[str]:
        """
        (Personalization Only) The storage account connection string.
        """
        return pulumi.get(self, "storage_account_connection_string")

    @property
    @pulumi.getter(name="superUser")
    def super_user(self) -> Optional[str]:
        """
        (Metrics Advisor Only) The super user of Metrics Advisor.
        """
        return pulumi.get(self, "super_user")

    @property
    @pulumi.getter(name="websiteName")
    def website_name(self) -> Optional[str]:
        """
        (Metrics Advisor Only) The website name of Metrics Advisor.
        """
        return pulumi.get(self, "website_name")


@pulumi.output_type
class CallRateLimitResponse(dict):
    """
    The call rate limit Cognitive Services account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "renewalPeriod":
            suggest = "renewal_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CallRateLimitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CallRateLimitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CallRateLimitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[float] = None,
                 renewal_period: Optional[float] = None,
                 rules: Optional[Sequence['outputs.ThrottlingRuleResponse']] = None):
        """
        The call rate limit Cognitive Services account.
        :param float count: The count value of Call Rate Limit.
        :param float renewal_period: The renewal period in seconds of Call Rate Limit.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if renewal_period is not None:
            pulumi.set(__self__, "renewal_period", renewal_period)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def count(self) -> Optional[float]:
        """
        The count value of Call Rate Limit.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="renewalPeriod")
    def renewal_period(self) -> Optional[float]:
        """
        The renewal period in seconds of Call Rate Limit.
        """
        return pulumi.get(self, "renewal_period")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.ThrottlingRuleResponse']]:
        return pulumi.get(self, "rules")


@pulumi.output_type
class CommitmentPeriodResponse(dict):
    """
    Cognitive Services account commitment period.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommitmentPeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommitmentPeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommitmentPeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: str,
                 quota: 'outputs.CommitmentQuotaResponse',
                 start_date: str,
                 count: Optional[int] = None,
                 tier: Optional[str] = None):
        """
        Cognitive Services account commitment period.
        :param str end_date: Commitment period end date.
        :param 'CommitmentQuotaResponse' quota: Cognitive Services account commitment quota.
        :param str start_date: Commitment period start date.
        :param int count: Commitment period commitment count.
        :param str tier: Commitment period commitment tier.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "quota", quota)
        pulumi.set(__self__, "start_date", start_date)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        Commitment period end date.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def quota(self) -> 'outputs.CommitmentQuotaResponse':
        """
        Cognitive Services account commitment quota.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Commitment period start date.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Commitment period commitment count.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Commitment period commitment tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class CommitmentPlanPropertiesResponse(dict):
    """
    Properties of Cognitive Services account commitment plan.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoRenew":
            suggest = "auto_renew"
        elif key == "hostingModel":
            suggest = "hosting_model"
        elif key == "planType":
            suggest = "plan_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommitmentPlanPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommitmentPlanPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommitmentPlanPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last: 'outputs.CommitmentPeriodResponse',
                 auto_renew: Optional[bool] = None,
                 current: Optional['outputs.CommitmentPeriodResponse'] = None,
                 hosting_model: Optional[str] = None,
                 next: Optional['outputs.CommitmentPeriodResponse'] = None,
                 plan_type: Optional[str] = None):
        """
        Properties of Cognitive Services account commitment plan.
        :param 'CommitmentPeriodResponse' last: Cognitive Services account commitment period.
        :param bool auto_renew: AutoRenew commitment plan.
        :param 'CommitmentPeriodResponse' current: Cognitive Services account commitment period.
        :param str hosting_model: Account hosting model.
        :param 'CommitmentPeriodResponse' next: Cognitive Services account commitment period.
        :param str plan_type: Commitment plan type.
        """
        pulumi.set(__self__, "last", last)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if current is not None:
            pulumi.set(__self__, "current", current)
        if hosting_model is not None:
            pulumi.set(__self__, "hosting_model", hosting_model)
        if next is not None:
            pulumi.set(__self__, "next", next)
        if plan_type is not None:
            pulumi.set(__self__, "plan_type", plan_type)

    @property
    @pulumi.getter
    def last(self) -> 'outputs.CommitmentPeriodResponse':
        """
        Cognitive Services account commitment period.
        """
        return pulumi.get(self, "last")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[bool]:
        """
        AutoRenew commitment plan.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def current(self) -> Optional['outputs.CommitmentPeriodResponse']:
        """
        Cognitive Services account commitment period.
        """
        return pulumi.get(self, "current")

    @property
    @pulumi.getter(name="hostingModel")
    def hosting_model(self) -> Optional[str]:
        """
        Account hosting model.
        """
        return pulumi.get(self, "hosting_model")

    @property
    @pulumi.getter
    def next(self) -> Optional['outputs.CommitmentPeriodResponse']:
        """
        Cognitive Services account commitment period.
        """
        return pulumi.get(self, "next")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> Optional[str]:
        """
        Commitment plan type.
        """
        return pulumi.get(self, "plan_type")


@pulumi.output_type
class CommitmentQuotaResponse(dict):
    """
    Cognitive Services account commitment quota.
    """
    def __init__(__self__, *,
                 quantity: Optional[float] = None,
                 unit: Optional[str] = None):
        """
        Cognitive Services account commitment quota.
        :param float quantity: Commitment quota quantity.
        :param str unit: Commitment quota unit.
        """
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[float]:
        """
        Commitment quota quantity.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        Commitment quota unit.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class DeploymentModelResponse(dict):
    """
    Properties of Cognitive Services account deployment model.
    """
    def __init__(__self__, *,
                 format: Optional[str] = None,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Properties of Cognitive Services account deployment model.
        :param str format: Deployment model format.
        :param str name: Deployment model name.
        :param str version: Deployment model version.
        """
        if format is not None:
            pulumi.set(__self__, "format", format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Deployment model format.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Deployment model name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Deployment model version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DeploymentPropertiesResponse(dict):
    """
    Properties of Cognitive Services account deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "scaleSettings":
            suggest = "scale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 model: Optional['outputs.DeploymentModelResponse'] = None,
                 scale_settings: Optional['outputs.DeploymentScaleSettingsResponse'] = None):
        """
        Properties of Cognitive Services account deployment.
        :param str provisioning_state: Gets the status of the resource at the time the operation was called.
        :param 'DeploymentModelResponse' model: Properties of Cognitive Services account deployment model.
        :param 'DeploymentScaleSettingsResponse' scale_settings: Properties of Cognitive Services account deployment model.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets the status of the resource at the time the operation was called.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def model(self) -> Optional['outputs.DeploymentModelResponse']:
        """
        Properties of Cognitive Services account deployment model.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional['outputs.DeploymentScaleSettingsResponse']:
        """
        Properties of Cognitive Services account deployment model.
        """
        return pulumi.get(self, "scale_settings")


@pulumi.output_type
class DeploymentScaleSettingsResponse(dict):
    """
    Properties of Cognitive Services account deployment model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleType":
            suggest = "scale_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 scale_type: Optional[str] = None):
        """
        Properties of Cognitive Services account deployment model.
        :param int capacity: Deployment capacity.
        :param str scale_type: Deployment scale type.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if scale_type is not None:
            pulumi.set(__self__, "scale_type", scale_type)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Deployment capacity.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> Optional[str]:
        """
        Deployment scale type.
        """
        return pulumi.get(self, "scale_type")


@pulumi.output_type
class EncryptionResponse(dict):
    """
    Properties to configure Encryption
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_source: Optional[str] = None,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None):
        """
        Properties to configure Encryption
        :param str key_source: Enumerates the possible value of keySource for Encryption
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Properties of KeyVault
        """
        if key_source is None:
            key_source = 'Microsoft.KeyVault'
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[str]:
        """
        Enumerates the possible value of keySource for Encryption
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        Properties of KeyVault
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class IpRuleResponse(dict):
    """
    A rule governing the accessibility from a specific ip address or ip range.
    """
    def __init__(__self__, *,
                 value: str):
        """
        A rule governing the accessibility from a specific ip address or ip range.
        :param str value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    Properties to configure keyVault Properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityClientId":
            suggest = "identity_client_id"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_client_id: Optional[str] = None,
                 key_name: Optional[str] = None,
                 key_vault_uri: Optional[str] = None,
                 key_version: Optional[str] = None):
        """
        Properties to configure keyVault Properties
        :param str key_name: Name of the Key from KeyVault
        :param str key_vault_uri: Uri of KeyVault
        :param str key_version: Version of the Key from KeyVault
        """
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        return pulumi.get(self, "identity_client_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        Name of the Key from KeyVault
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[str]:
        """
        Uri of KeyVault
        """
        return pulumi.get(self, "key_vault_uri")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        Version of the Key from KeyVault
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class NetworkRuleSetResponse(dict):
    """
    A set of rules governing the network accessibility.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: Optional[str] = None,
                 ip_rules: Optional[Sequence['outputs.IpRuleResponse']] = None,
                 virtual_network_rules: Optional[Sequence['outputs.VirtualNetworkRuleResponse']] = None):
        """
        A set of rules governing the network accessibility.
        :param str default_action: The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
        :param Sequence['IpRuleResponse'] ip_rules: The list of IP address rules.
        :param Sequence['VirtualNetworkRuleResponse'] virtual_network_rules: The list of virtual network rules.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[str]:
        """
        The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.IpRuleResponse']]:
        """
        The list of IP address rules.
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.VirtualNetworkRuleResponse']]:
        """
        The list of virtual network rules.
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    Properties of the PrivateEndpointConnectProperties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "groupIds":
            suggest = "group_ids"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 group_ids: Optional[Sequence[str]] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        Properties of the PrivateEndpointConnectProperties.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param Sequence[str] group_ids: The private link resource group ids.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        The private link resource group ids.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemData":
            suggest = "system_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 name: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 location: Optional[str] = None,
                 properties: Optional['outputs.PrivateEndpointConnectionPropertiesResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str etag: Resource Etag.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'SystemDataResponse' system_data: Metadata pertaining to creation and last modification of the resource.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param str location: The location of the private endpoint connection
        :param 'PrivateEndpointConnectionPropertiesResponse' properties: Resource properties.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Resource Etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the private endpoint connection
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.PrivateEndpointConnectionPropertiesResponse']:
        """
        Resource properties.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class QuotaLimitResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "renewalPeriod":
            suggest = "renewal_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaLimitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaLimitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaLimitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[float] = None,
                 renewal_period: Optional[float] = None,
                 rules: Optional[Sequence['outputs.ThrottlingRuleResponse']] = None):
        if count is not None:
            pulumi.set(__self__, "count", count)
        if renewal_period is not None:
            pulumi.set(__self__, "renewal_period", renewal_period)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def count(self) -> Optional[float]:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="renewalPeriod")
    def renewal_period(self) -> Optional[float]:
        return pulumi.get(self, "renewal_period")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.ThrottlingRuleResponse']]:
        return pulumi.get(self, "rules")


@pulumi.output_type
class RequestMatchPatternResponse(dict):
    def __init__(__self__, *,
                 method: Optional[str] = None,
                 path: Optional[str] = None):
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        return pulumi.get(self, "path")


@pulumi.output_type
class SkuCapabilityResponse(dict):
    """
    SkuCapability indicates the capability of a certain feature.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        SkuCapability indicates the capability of a certain feature.
        :param str name: The name of the SkuCapability.
        :param str value: The value of the SkuCapability.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SkuCapability.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the SkuCapability.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SkuChangeInfoResponse(dict):
    """
    Sku change info of account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countOfDowngrades":
            suggest = "count_of_downgrades"
        elif key == "countOfUpgradesAfterDowngrades":
            suggest = "count_of_upgrades_after_downgrades"
        elif key == "lastChangeDate":
            suggest = "last_change_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkuChangeInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkuChangeInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkuChangeInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count_of_downgrades: Optional[float] = None,
                 count_of_upgrades_after_downgrades: Optional[float] = None,
                 last_change_date: Optional[str] = None):
        """
        Sku change info of account.
        :param float count_of_downgrades: Gets the count of downgrades.
        :param float count_of_upgrades_after_downgrades: Gets the count of upgrades after downgrades.
        :param str last_change_date: Gets the last change date.
        """
        if count_of_downgrades is not None:
            pulumi.set(__self__, "count_of_downgrades", count_of_downgrades)
        if count_of_upgrades_after_downgrades is not None:
            pulumi.set(__self__, "count_of_upgrades_after_downgrades", count_of_upgrades_after_downgrades)
        if last_change_date is not None:
            pulumi.set(__self__, "last_change_date", last_change_date)

    @property
    @pulumi.getter(name="countOfDowngrades")
    def count_of_downgrades(self) -> Optional[float]:
        """
        Gets the count of downgrades.
        """
        return pulumi.get(self, "count_of_downgrades")

    @property
    @pulumi.getter(name="countOfUpgradesAfterDowngrades")
    def count_of_upgrades_after_downgrades(self) -> Optional[float]:
        """
        Gets the count of upgrades after downgrades.
        """
        return pulumi.get(self, "count_of_upgrades_after_downgrades")

    @property
    @pulumi.getter(name="lastChangeDate")
    def last_change_date(self) -> Optional[str]:
        """
        Gets the last change date.
        """
        return pulumi.get(self, "last_change_date")


@pulumi.output_type
class SkuResponse(dict):
    """
    The resource model definition representing SKU
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The resource model definition representing SKU
        :param str name: The name of the SKU. Ex - P3. It is typically a letter+number code
        :param int capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param str tier: This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU. Ex - P3. It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class ThrottlingRuleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamicThrottlingEnabled":
            suggest = "dynamic_throttling_enabled"
        elif key == "matchPatterns":
            suggest = "match_patterns"
        elif key == "minCount":
            suggest = "min_count"
        elif key == "renewalPeriod":
            suggest = "renewal_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThrottlingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThrottlingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThrottlingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[float] = None,
                 dynamic_throttling_enabled: Optional[bool] = None,
                 key: Optional[str] = None,
                 match_patterns: Optional[Sequence['outputs.RequestMatchPatternResponse']] = None,
                 min_count: Optional[float] = None,
                 renewal_period: Optional[float] = None):
        if count is not None:
            pulumi.set(__self__, "count", count)
        if dynamic_throttling_enabled is not None:
            pulumi.set(__self__, "dynamic_throttling_enabled", dynamic_throttling_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if match_patterns is not None:
            pulumi.set(__self__, "match_patterns", match_patterns)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if renewal_period is not None:
            pulumi.set(__self__, "renewal_period", renewal_period)

    @property
    @pulumi.getter
    def count(self) -> Optional[float]:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="dynamicThrottlingEnabled")
    def dynamic_throttling_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "dynamic_throttling_enabled")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="matchPatterns")
    def match_patterns(self) -> Optional[Sequence['outputs.RequestMatchPatternResponse']]:
        return pulumi.get(self, "match_patterns")

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[float]:
        return pulumi.get(self, "min_count")

    @property
    @pulumi.getter(name="renewalPeriod")
    def renewal_period(self) -> Optional[float]:
        return pulumi.get(self, "renewal_period")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User-assigned managed identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User-assigned managed identity.
        :param str client_id: Client App Id associated with this identity.
        :param str principal_id: Azure Active Directory principal ID associated with this Identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Client App Id associated with this identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Azure Active Directory principal ID associated with this Identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class UserOwnedStorageResponse(dict):
    """
    The user owned storage for Cognitive Services account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityClientId":
            suggest = "identity_client_id"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserOwnedStorageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserOwnedStorageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserOwnedStorageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_client_id: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        The user owned storage for Cognitive Services account.
        :param str resource_id: Full resource id of a Microsoft.Storage resource.
        """
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        return pulumi.get(self, "identity_client_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        Full resource id of a Microsoft.Storage resource.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    A rule governing the accessibility from a specific virtual network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMissingVnetServiceEndpoint":
            suggest = "ignore_missing_vnet_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 ignore_missing_vnet_service_endpoint: Optional[bool] = None,
                 state: Optional[str] = None):
        """
        A rule governing the accessibility from a specific virtual network.
        :param str id: Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
        :param bool ignore_missing_vnet_service_endpoint: Ignore missing vnet service endpoint or not.
        :param str state: Gets the state of virtual network rule.
        """
        pulumi.set(__self__, "id", id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[bool]:
        """
        Ignore missing vnet service endpoint or not.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets the state of virtual network rule.
        """
        return pulumi.get(self, "state")


