# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ReportPropertiesArgs',
    'ResourceMetadataArgs',
]

@pulumi.input_type
class ReportPropertiesArgs:
    def __init__(__self__, *,
                 resources: pulumi.Input[Sequence[pulumi.Input['ResourceMetadataArgs']]],
                 time_zone: pulumi.Input[str],
                 trigger_time: pulumi.Input[str],
                 offer_guid: Optional[pulumi.Input[str]] = None):
        """
        Report's properties.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceMetadataArgs']]] resources: List of resource data.
        :param pulumi.Input[str] time_zone: Report collection trigger time's time zone, the available list can be obtained by executing "Get-TimeZone -ListAvailable" in PowerShell.
               An example of valid timezone id is "Pacific Standard Time".
        :param pulumi.Input[str] trigger_time: Report collection trigger time.
        :param pulumi.Input[str] offer_guid: Report offer Guid.
        """
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "trigger_time", trigger_time)
        if offer_guid is not None:
            pulumi.set(__self__, "offer_guid", offer_guid)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input['ResourceMetadataArgs']]]:
        """
        List of resource data.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input['ResourceMetadataArgs']]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        """
        Report collection trigger time's time zone, the available list can be obtained by executing "Get-TimeZone -ListAvailable" in PowerShell.
        An example of valid timezone id is "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="triggerTime")
    def trigger_time(self) -> pulumi.Input[str]:
        """
        Report collection trigger time.
        """
        return pulumi.get(self, "trigger_time")

    @trigger_time.setter
    def trigger_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger_time", value)

    @property
    @pulumi.getter(name="offerGuid")
    def offer_guid(self) -> Optional[pulumi.Input[str]]:
        """
        Report offer Guid.
        """
        return pulumi.get(self, "offer_guid")

    @offer_guid.setter
    def offer_guid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer_guid", value)


@pulumi.input_type
class ResourceMetadataArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 resource_kind: Optional[pulumi.Input[str]] = None,
                 resource_name: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Single resource Id's metadata.
        :param pulumi.Input[str] resource_id: Resource Id - e.g. "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
        :param pulumi.Input[str] resource_kind: Resource kind.
        :param pulumi.Input[str] resource_name: Resource name.
        :param pulumi.Input[str] resource_type: Resource type.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource's tag type.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_kind is not None:
            pulumi.set(__self__, "resource_kind", resource_kind)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        Resource Id - e.g. "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1".
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceKind")
    def resource_kind(self) -> Optional[pulumi.Input[str]]:
        """
        Resource kind.
        """
        return pulumi.get(self, "resource_kind")

    @resource_kind.setter
    def resource_kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_kind", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource's tag type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


