# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['WordpressInstanceArgs', 'WordpressInstance']

@pulumi.input_type
class WordpressInstanceArgs:
    def __init__(__self__, *,
                 php_workload_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 version: pulumi.Input[Union[str, 'WordpressVersions']],
                 database_name: Optional[pulumi.Input[str]] = None,
                 database_user: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WordpressInstance resource.
        :param pulumi.Input[str] php_workload_name: Php workload name
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Union[str, 'WordpressVersions']] version: Application version
        :param pulumi.Input[str] database_name: Database name used by the application
        :param pulumi.Input[str] database_user: User name used by the application to connect to database
        """
        pulumi.set(__self__, "php_workload_name", php_workload_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "version", version)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_user is not None:
            pulumi.set(__self__, "database_user", database_user)

    @property
    @pulumi.getter(name="phpWorkloadName")
    def php_workload_name(self) -> pulumi.Input[str]:
        """
        Php workload name
        """
        return pulumi.get(self, "php_workload_name")

    @php_workload_name.setter
    def php_workload_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "php_workload_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[Union[str, 'WordpressVersions']]:
        """
        Application version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[Union[str, 'WordpressVersions']]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database name used by the application
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="databaseUser")
    def database_user(self) -> Optional[pulumi.Input[str]]:
        """
        User name used by the application to connect to database
        """
        return pulumi.get(self, "database_user")

    @database_user.setter
    def database_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_user", value)


class WordpressInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 database_user: Optional[pulumi.Input[str]] = None,
                 php_workload_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[Union[str, 'WordpressVersions']]] = None,
                 __props__=None):
        """
        WordPress instance resource
        API Version: 2021-12-01-preview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: Database name used by the application
        :param pulumi.Input[str] database_user: User name used by the application to connect to database
        :param pulumi.Input[str] php_workload_name: Php workload name
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Union[str, 'WordpressVersions']] version: Application version
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WordpressInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        WordPress instance resource
        API Version: 2021-12-01-preview.

        :param str resource_name: The name of the resource.
        :param WordpressInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WordpressInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 database_user: Optional[pulumi.Input[str]] = None,
                 php_workload_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[Union[str, 'WordpressVersions']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WordpressInstanceArgs.__new__(WordpressInstanceArgs)

            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["database_user"] = database_user
            if php_workload_name is None and not opts.urn:
                raise TypeError("Missing required property 'php_workload_name'")
            __props__.__dict__["php_workload_name"] = php_workload_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["site_url"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:workloads/v20211201preview:WordpressInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(WordpressInstance, __self__).__init__(
            'azure-native:workloads:WordpressInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WordpressInstance':
        """
        Get an existing WordpressInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WordpressInstanceArgs.__new__(WordpressInstanceArgs)

        __props__.__dict__["database_name"] = None
        __props__.__dict__["database_user"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["site_url"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["version"] = None
        return WordpressInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        Database name used by the application
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="databaseUser")
    def database_user(self) -> pulumi.Output[Optional[str]]:
        """
        User name used by the application to connect to database
        """
        return pulumi.get(self, "database_user")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        WordPress instance provisioning state
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="siteUrl")
    def site_url(self) -> pulumi.Output[str]:
        """
        Site Url to access the WordPress application
        """
        return pulumi.get(self, "site_url")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Application version
        """
        return pulumi.get(self, "version")

