# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetJitRequestResult',
    'AwaitableGetJitRequestResult',
    'get_jit_request',
    'get_jit_request_output',
]

@pulumi.output_type
class GetJitRequestResult:
    """
    Information about JIT request definition.
    """
    def __init__(__self__, application_resource_id=None, created_by=None, id=None, jit_authorization_policies=None, jit_request_state=None, jit_scheduling_policy=None, location=None, name=None, provisioning_state=None, publisher_tenant_id=None, tags=None, type=None, updated_by=None):
        if application_resource_id and not isinstance(application_resource_id, str):
            raise TypeError("Expected argument 'application_resource_id' to be a str")
        pulumi.set(__self__, "application_resource_id", application_resource_id)
        if created_by and not isinstance(created_by, dict):
            raise TypeError("Expected argument 'created_by' to be a dict")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jit_authorization_policies and not isinstance(jit_authorization_policies, list):
            raise TypeError("Expected argument 'jit_authorization_policies' to be a list")
        pulumi.set(__self__, "jit_authorization_policies", jit_authorization_policies)
        if jit_request_state and not isinstance(jit_request_state, str):
            raise TypeError("Expected argument 'jit_request_state' to be a str")
        pulumi.set(__self__, "jit_request_state", jit_request_state)
        if jit_scheduling_policy and not isinstance(jit_scheduling_policy, dict):
            raise TypeError("Expected argument 'jit_scheduling_policy' to be a dict")
        pulumi.set(__self__, "jit_scheduling_policy", jit_scheduling_policy)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if publisher_tenant_id and not isinstance(publisher_tenant_id, str):
            raise TypeError("Expected argument 'publisher_tenant_id' to be a str")
        pulumi.set(__self__, "publisher_tenant_id", publisher_tenant_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_by and not isinstance(updated_by, dict):
            raise TypeError("Expected argument 'updated_by' to be a dict")
        pulumi.set(__self__, "updated_by", updated_by)

    @property
    @pulumi.getter(name="applicationResourceId")
    def application_resource_id(self) -> str:
        """
        The parent application id.
        """
        return pulumi.get(self, "application_resource_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> 'outputs.ApplicationClientDetailsResponse':
        """
        The client entity that created the JIT request.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jitAuthorizationPolicies")
    def jit_authorization_policies(self) -> Sequence['outputs.JitAuthorizationPoliciesResponse']:
        """
        The JIT authorization policies.
        """
        return pulumi.get(self, "jit_authorization_policies")

    @property
    @pulumi.getter(name="jitRequestState")
    def jit_request_state(self) -> str:
        """
        The JIT request state.
        """
        return pulumi.get(self, "jit_request_state")

    @property
    @pulumi.getter(name="jitSchedulingPolicy")
    def jit_scheduling_policy(self) -> 'outputs.JitSchedulingPolicyResponse':
        """
        The JIT request properties.
        """
        return pulumi.get(self, "jit_scheduling_policy")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The JIT request provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publisherTenantId")
    def publisher_tenant_id(self) -> str:
        """
        The publisher tenant id.
        """
        return pulumi.get(self, "publisher_tenant_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> 'outputs.ApplicationClientDetailsResponse':
        """
        The client entity that last updated the JIT request.
        """
        return pulumi.get(self, "updated_by")


class AwaitableGetJitRequestResult(GetJitRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJitRequestResult(
            application_resource_id=self.application_resource_id,
            created_by=self.created_by,
            id=self.id,
            jit_authorization_policies=self.jit_authorization_policies,
            jit_request_state=self.jit_request_state,
            jit_scheduling_policy=self.jit_scheduling_policy,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            publisher_tenant_id=self.publisher_tenant_id,
            tags=self.tags,
            type=self.type,
            updated_by=self.updated_by)


def get_jit_request(jit_request_name: Optional[str] = None,
                    resource_group_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJitRequestResult:
    """
    Information about JIT request definition.


    :param str jit_request_name: The name of the JIT request.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['jitRequestName'] = jit_request_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:solutions/v20200821preview:getJitRequest', __args__, opts=opts, typ=GetJitRequestResult).value

    return AwaitableGetJitRequestResult(
        application_resource_id=__ret__.application_resource_id,
        created_by=__ret__.created_by,
        id=__ret__.id,
        jit_authorization_policies=__ret__.jit_authorization_policies,
        jit_request_state=__ret__.jit_request_state,
        jit_scheduling_policy=__ret__.jit_scheduling_policy,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        publisher_tenant_id=__ret__.publisher_tenant_id,
        tags=__ret__.tags,
        type=__ret__.type,
        updated_by=__ret__.updated_by)


@_utilities.lift_output_func(get_jit_request)
def get_jit_request_output(jit_request_name: Optional[pulumi.Input[str]] = None,
                           resource_group_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJitRequestResult]:
    """
    Information about JIT request definition.


    :param str jit_request_name: The name of the JIT request.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
