# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AWSEnvironmentDataResponse',
    'AwsOrganizationalDataMasterResponse',
    'AwsOrganizationalDataMemberResponse',
    'CspmMonitorAwsOfferingResponse',
    'CspmMonitorAwsOfferingResponseNativeCloudConnection',
    'CspmMonitorGcpOfferingResponse',
    'CspmMonitorGcpOfferingResponseNativeCloudConnection',
    'CspmMonitorGithubOfferingResponse',
    'DefenderForContainersAwsOfferingResponse',
    'DefenderForContainersAwsOfferingResponseCloudWatchToKinesis',
    'DefenderForContainersAwsOfferingResponseKinesisToS3',
    'DefenderForContainersAwsOfferingResponseKubernetesScubaReader',
    'DefenderForContainersAwsOfferingResponseKubernetesService',
    'DefenderForContainersGcpOfferingResponse',
    'DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection',
    'DefenderForContainersGcpOfferingResponseNativeCloudConnection',
    'DefenderForServersAwsOfferingResponse',
    'DefenderForServersAwsOfferingResponseArcAutoProvisioning',
    'DefenderForServersAwsOfferingResponseConfiguration',
    'DefenderForServersAwsOfferingResponseDefenderForServers',
    'DefenderForServersAwsOfferingResponseMdeAutoProvisioning',
    'DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata',
    'DefenderForServersAwsOfferingResponseSubPlan',
    'DefenderForServersAwsOfferingResponseVaAutoProvisioning',
    'DefenderForServersGcpOfferingResponse',
    'DefenderForServersGcpOfferingResponseArcAutoProvisioning',
    'DefenderForServersGcpOfferingResponseConfiguration',
    'DefenderForServersGcpOfferingResponseConfigurationConfiguration',
    'DefenderForServersGcpOfferingResponseDefenderForServers',
    'DefenderForServersGcpOfferingResponseMdeAutoProvisioning',
    'DefenderForServersGcpOfferingResponseSubPlan',
    'DefenderForServersGcpOfferingResponseVaAutoProvisioning',
    'GcpOrganizationalDataMemberResponse',
    'GcpOrganizationalDataOrganizationResponse',
    'GcpProjectDetailsResponse',
    'GcpProjectEnvironmentDataResponse',
    'GithubScopeEnvironmentDataResponse',
    'InformationProtectionAwsOfferingResponse',
    'InformationProtectionAwsOfferingResponseInformationProtection',
    'SystemDataResponse',
]

@pulumi.output_type
class AWSEnvironmentDataResponse(dict):
    """
    The aws connector environment data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentType":
            suggest = "environment_type"
        elif key == "organizationalData":
            suggest = "organizational_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AWSEnvironmentDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AWSEnvironmentDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AWSEnvironmentDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_type: str,
                 organizational_data: Optional[Any] = None):
        """
        The aws connector environment data
        :param str environment_type: The type of the environment data.
               Expected value is 'AwsAccount'.
        :param Union['AwsOrganizationalDataMasterResponse', 'AwsOrganizationalDataMemberResponse'] organizational_data: The AWS account's organizational data
        """
        pulumi.set(__self__, "environment_type", 'AwsAccount')
        if organizational_data is not None:
            pulumi.set(__self__, "organizational_data", organizational_data)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        The type of the environment data.
        Expected value is 'AwsAccount'.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="organizationalData")
    def organizational_data(self) -> Optional[Any]:
        """
        The AWS account's organizational data
        """
        return pulumi.get(self, "organizational_data")


@pulumi.output_type
class AwsOrganizationalDataMasterResponse(dict):
    """
    The awsOrganization data for the master account
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "organizationMembershipType":
            suggest = "organization_membership_type"
        elif key == "excludedAccountIds":
            suggest = "excluded_account_ids"
        elif key == "stacksetName":
            suggest = "stackset_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsOrganizationalDataMasterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsOrganizationalDataMasterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsOrganizationalDataMasterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization_membership_type: str,
                 excluded_account_ids: Optional[Sequence[str]] = None,
                 stackset_name: Optional[str] = None):
        """
        The awsOrganization data for the master account
        :param str organization_membership_type: The multi cloud account's membership type in the organization
               Expected value is 'Organization'.
        :param Sequence[str] excluded_account_ids: If the multi cloud account is of membership type organization, list of accounts excluded from offering
        :param str stackset_name: If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
        """
        pulumi.set(__self__, "organization_membership_type", 'Organization')
        if excluded_account_ids is not None:
            pulumi.set(__self__, "excluded_account_ids", excluded_account_ids)
        if stackset_name is not None:
            pulumi.set(__self__, "stackset_name", stackset_name)

    @property
    @pulumi.getter(name="organizationMembershipType")
    def organization_membership_type(self) -> str:
        """
        The multi cloud account's membership type in the organization
        Expected value is 'Organization'.
        """
        return pulumi.get(self, "organization_membership_type")

    @property
    @pulumi.getter(name="excludedAccountIds")
    def excluded_account_ids(self) -> Optional[Sequence[str]]:
        """
        If the multi cloud account is of membership type organization, list of accounts excluded from offering
        """
        return pulumi.get(self, "excluded_account_ids")

    @property
    @pulumi.getter(name="stacksetName")
    def stackset_name(self) -> Optional[str]:
        """
        If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
        """
        return pulumi.get(self, "stackset_name")


@pulumi.output_type
class AwsOrganizationalDataMemberResponse(dict):
    """
    The awsOrganization data for the member account
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "organizationMembershipType":
            suggest = "organization_membership_type"
        elif key == "parentHierarchyId":
            suggest = "parent_hierarchy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsOrganizationalDataMemberResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsOrganizationalDataMemberResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsOrganizationalDataMemberResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization_membership_type: str,
                 parent_hierarchy_id: Optional[str] = None):
        """
        The awsOrganization data for the member account
        :param str organization_membership_type: The multi cloud account's membership type in the organization
               Expected value is 'Member'.
        :param str parent_hierarchy_id: If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
        """
        pulumi.set(__self__, "organization_membership_type", 'Member')
        if parent_hierarchy_id is not None:
            pulumi.set(__self__, "parent_hierarchy_id", parent_hierarchy_id)

    @property
    @pulumi.getter(name="organizationMembershipType")
    def organization_membership_type(self) -> str:
        """
        The multi cloud account's membership type in the organization
        Expected value is 'Member'.
        """
        return pulumi.get(self, "organization_membership_type")

    @property
    @pulumi.getter(name="parentHierarchyId")
    def parent_hierarchy_id(self) -> Optional[str]:
        """
        If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
        """
        return pulumi.get(self, "parent_hierarchy_id")


@pulumi.output_type
class CspmMonitorAwsOfferingResponse(dict):
    """
    The CSPM monitoring for AWS offering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"
        elif key == "nativeCloudConnection":
            suggest = "native_cloud_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CspmMonitorAwsOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CspmMonitorAwsOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CspmMonitorAwsOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str,
                 native_cloud_connection: Optional['outputs.CspmMonitorAwsOfferingResponseNativeCloudConnection'] = None):
        """
        The CSPM monitoring for AWS offering
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'CspmMonitorAws'.
        :param 'CspmMonitorAwsOfferingResponseNativeCloudConnection' native_cloud_connection: The native cloud connection configuration
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'CspmMonitorAws')
        if native_cloud_connection is not None:
            pulumi.set(__self__, "native_cloud_connection", native_cloud_connection)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'CspmMonitorAws'.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="nativeCloudConnection")
    def native_cloud_connection(self) -> Optional['outputs.CspmMonitorAwsOfferingResponseNativeCloudConnection']:
        """
        The native cloud connection configuration
        """
        return pulumi.get(self, "native_cloud_connection")


@pulumi.output_type
class CspmMonitorAwsOfferingResponseNativeCloudConnection(dict):
    """
    The native cloud connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRoleArn":
            suggest = "cloud_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CspmMonitorAwsOfferingResponseNativeCloudConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CspmMonitorAwsOfferingResponseNativeCloudConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CspmMonitorAwsOfferingResponseNativeCloudConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_role_arn: Optional[str] = None):
        """
        The native cloud connection configuration
        :param str cloud_role_arn: The cloud role ARN in AWS for this feature
        """
        if cloud_role_arn is not None:
            pulumi.set(__self__, "cloud_role_arn", cloud_role_arn)

    @property
    @pulumi.getter(name="cloudRoleArn")
    def cloud_role_arn(self) -> Optional[str]:
        """
        The cloud role ARN in AWS for this feature
        """
        return pulumi.get(self, "cloud_role_arn")


@pulumi.output_type
class CspmMonitorGcpOfferingResponse(dict):
    """
    The CSPM monitoring for GCP offering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"
        elif key == "nativeCloudConnection":
            suggest = "native_cloud_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CspmMonitorGcpOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CspmMonitorGcpOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CspmMonitorGcpOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str,
                 native_cloud_connection: Optional['outputs.CspmMonitorGcpOfferingResponseNativeCloudConnection'] = None):
        """
        The CSPM monitoring for GCP offering
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'CspmMonitorGcp'.
        :param 'CspmMonitorGcpOfferingResponseNativeCloudConnection' native_cloud_connection: The native cloud connection configuration
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'CspmMonitorGcp')
        if native_cloud_connection is not None:
            pulumi.set(__self__, "native_cloud_connection", native_cloud_connection)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'CspmMonitorGcp'.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="nativeCloudConnection")
    def native_cloud_connection(self) -> Optional['outputs.CspmMonitorGcpOfferingResponseNativeCloudConnection']:
        """
        The native cloud connection configuration
        """
        return pulumi.get(self, "native_cloud_connection")


@pulumi.output_type
class CspmMonitorGcpOfferingResponseNativeCloudConnection(dict):
    """
    The native cloud connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmailAddress":
            suggest = "service_account_email_address"
        elif key == "workloadIdentityProviderId":
            suggest = "workload_identity_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CspmMonitorGcpOfferingResponseNativeCloudConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CspmMonitorGcpOfferingResponseNativeCloudConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CspmMonitorGcpOfferingResponseNativeCloudConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_email_address: Optional[str] = None,
                 workload_identity_provider_id: Optional[str] = None):
        """
        The native cloud connection configuration
        :param str service_account_email_address: The service account email address in GCP for this offering
        :param str workload_identity_provider_id: The GCP workload identity provider id for the offering
        """
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if workload_identity_provider_id is not None:
            pulumi.set(__self__, "workload_identity_provider_id", workload_identity_provider_id)

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[str]:
        """
        The service account email address in GCP for this offering
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter(name="workloadIdentityProviderId")
    def workload_identity_provider_id(self) -> Optional[str]:
        """
        The GCP workload identity provider id for the offering
        """
        return pulumi.get(self, "workload_identity_provider_id")


@pulumi.output_type
class CspmMonitorGithubOfferingResponse(dict):
    """
    The CSPM monitoring for github offering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CspmMonitorGithubOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CspmMonitorGithubOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CspmMonitorGithubOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str):
        """
        The CSPM monitoring for github offering
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'CspmMonitorGithub'.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'CspmMonitorGithub')

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'CspmMonitorGithub'.
        """
        return pulumi.get(self, "offering_type")


@pulumi.output_type
class DefenderForContainersAwsOfferingResponse(dict):
    """
    The Defender for Containers AWS offering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"
        elif key == "cloudWatchToKinesis":
            suggest = "cloud_watch_to_kinesis"
        elif key == "kinesisToS3":
            suggest = "kinesis_to_s3"
        elif key == "kubernetesScubaReader":
            suggest = "kubernetes_scuba_reader"
        elif key == "kubernetesService":
            suggest = "kubernetes_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersAwsOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersAwsOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersAwsOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str,
                 cloud_watch_to_kinesis: Optional['outputs.DefenderForContainersAwsOfferingResponseCloudWatchToKinesis'] = None,
                 kinesis_to_s3: Optional['outputs.DefenderForContainersAwsOfferingResponseKinesisToS3'] = None,
                 kubernetes_scuba_reader: Optional['outputs.DefenderForContainersAwsOfferingResponseKubernetesScubaReader'] = None,
                 kubernetes_service: Optional['outputs.DefenderForContainersAwsOfferingResponseKubernetesService'] = None):
        """
        The Defender for Containers AWS offering
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'DefenderForContainersAws'.
        :param 'DefenderForContainersAwsOfferingResponseCloudWatchToKinesis' cloud_watch_to_kinesis: The cloudwatch to kinesis connection configuration
        :param 'DefenderForContainersAwsOfferingResponseKinesisToS3' kinesis_to_s3: The kinesis to s3 connection configuration
        :param 'DefenderForContainersAwsOfferingResponseKubernetesScubaReader' kubernetes_scuba_reader: The kubernetes to scuba connection configuration
        :param 'DefenderForContainersAwsOfferingResponseKubernetesService' kubernetes_service: The kubernetes service connection configuration
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'DefenderForContainersAws')
        if cloud_watch_to_kinesis is not None:
            pulumi.set(__self__, "cloud_watch_to_kinesis", cloud_watch_to_kinesis)
        if kinesis_to_s3 is not None:
            pulumi.set(__self__, "kinesis_to_s3", kinesis_to_s3)
        if kubernetes_scuba_reader is not None:
            pulumi.set(__self__, "kubernetes_scuba_reader", kubernetes_scuba_reader)
        if kubernetes_service is not None:
            pulumi.set(__self__, "kubernetes_service", kubernetes_service)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'DefenderForContainersAws'.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="cloudWatchToKinesis")
    def cloud_watch_to_kinesis(self) -> Optional['outputs.DefenderForContainersAwsOfferingResponseCloudWatchToKinesis']:
        """
        The cloudwatch to kinesis connection configuration
        """
        return pulumi.get(self, "cloud_watch_to_kinesis")

    @property
    @pulumi.getter(name="kinesisToS3")
    def kinesis_to_s3(self) -> Optional['outputs.DefenderForContainersAwsOfferingResponseKinesisToS3']:
        """
        The kinesis to s3 connection configuration
        """
        return pulumi.get(self, "kinesis_to_s3")

    @property
    @pulumi.getter(name="kubernetesScubaReader")
    def kubernetes_scuba_reader(self) -> Optional['outputs.DefenderForContainersAwsOfferingResponseKubernetesScubaReader']:
        """
        The kubernetes to scuba connection configuration
        """
        return pulumi.get(self, "kubernetes_scuba_reader")

    @property
    @pulumi.getter(name="kubernetesService")
    def kubernetes_service(self) -> Optional['outputs.DefenderForContainersAwsOfferingResponseKubernetesService']:
        """
        The kubernetes service connection configuration
        """
        return pulumi.get(self, "kubernetes_service")


@pulumi.output_type
class DefenderForContainersAwsOfferingResponseCloudWatchToKinesis(dict):
    """
    The cloudwatch to kinesis connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRoleArn":
            suggest = "cloud_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersAwsOfferingResponseCloudWatchToKinesis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersAwsOfferingResponseCloudWatchToKinesis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersAwsOfferingResponseCloudWatchToKinesis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_role_arn: Optional[str] = None):
        """
        The cloudwatch to kinesis connection configuration
        :param str cloud_role_arn: The cloud role ARN in AWS for this feature
        """
        if cloud_role_arn is not None:
            pulumi.set(__self__, "cloud_role_arn", cloud_role_arn)

    @property
    @pulumi.getter(name="cloudRoleArn")
    def cloud_role_arn(self) -> Optional[str]:
        """
        The cloud role ARN in AWS for this feature
        """
        return pulumi.get(self, "cloud_role_arn")


@pulumi.output_type
class DefenderForContainersAwsOfferingResponseKinesisToS3(dict):
    """
    The kinesis to s3 connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRoleArn":
            suggest = "cloud_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersAwsOfferingResponseKinesisToS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersAwsOfferingResponseKinesisToS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersAwsOfferingResponseKinesisToS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_role_arn: Optional[str] = None):
        """
        The kinesis to s3 connection configuration
        :param str cloud_role_arn: The cloud role ARN in AWS for this feature
        """
        if cloud_role_arn is not None:
            pulumi.set(__self__, "cloud_role_arn", cloud_role_arn)

    @property
    @pulumi.getter(name="cloudRoleArn")
    def cloud_role_arn(self) -> Optional[str]:
        """
        The cloud role ARN in AWS for this feature
        """
        return pulumi.get(self, "cloud_role_arn")


@pulumi.output_type
class DefenderForContainersAwsOfferingResponseKubernetesScubaReader(dict):
    """
    The kubernetes to scuba connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRoleArn":
            suggest = "cloud_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersAwsOfferingResponseKubernetesScubaReader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersAwsOfferingResponseKubernetesScubaReader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersAwsOfferingResponseKubernetesScubaReader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_role_arn: Optional[str] = None):
        """
        The kubernetes to scuba connection configuration
        :param str cloud_role_arn: The cloud role ARN in AWS for this feature
        """
        if cloud_role_arn is not None:
            pulumi.set(__self__, "cloud_role_arn", cloud_role_arn)

    @property
    @pulumi.getter(name="cloudRoleArn")
    def cloud_role_arn(self) -> Optional[str]:
        """
        The cloud role ARN in AWS for this feature
        """
        return pulumi.get(self, "cloud_role_arn")


@pulumi.output_type
class DefenderForContainersAwsOfferingResponseKubernetesService(dict):
    """
    The kubernetes service connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRoleArn":
            suggest = "cloud_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersAwsOfferingResponseKubernetesService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersAwsOfferingResponseKubernetesService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersAwsOfferingResponseKubernetesService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_role_arn: Optional[str] = None):
        """
        The kubernetes service connection configuration
        :param str cloud_role_arn: The cloud role ARN in AWS for this feature
        """
        if cloud_role_arn is not None:
            pulumi.set(__self__, "cloud_role_arn", cloud_role_arn)

    @property
    @pulumi.getter(name="cloudRoleArn")
    def cloud_role_arn(self) -> Optional[str]:
        """
        The cloud role ARN in AWS for this feature
        """
        return pulumi.get(self, "cloud_role_arn")


@pulumi.output_type
class DefenderForContainersGcpOfferingResponse(dict):
    """
    The containers GCP offering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"
        elif key == "auditLogsAutoProvisioningFlag":
            suggest = "audit_logs_auto_provisioning_flag"
        elif key == "dataPipelineNativeCloudConnection":
            suggest = "data_pipeline_native_cloud_connection"
        elif key == "defenderAgentAutoProvisioningFlag":
            suggest = "defender_agent_auto_provisioning_flag"
        elif key == "nativeCloudConnection":
            suggest = "native_cloud_connection"
        elif key == "policyAgentAutoProvisioningFlag":
            suggest = "policy_agent_auto_provisioning_flag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersGcpOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersGcpOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersGcpOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str,
                 audit_logs_auto_provisioning_flag: Optional[bool] = None,
                 data_pipeline_native_cloud_connection: Optional['outputs.DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection'] = None,
                 defender_agent_auto_provisioning_flag: Optional[bool] = None,
                 native_cloud_connection: Optional['outputs.DefenderForContainersGcpOfferingResponseNativeCloudConnection'] = None,
                 policy_agent_auto_provisioning_flag: Optional[bool] = None):
        """
        The containers GCP offering
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'DefenderForContainersGcp'.
        :param bool audit_logs_auto_provisioning_flag: Is audit logs data collection enabled
        :param 'DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection' data_pipeline_native_cloud_connection: The native cloud connection configuration
        :param bool defender_agent_auto_provisioning_flag: Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
        :param 'DefenderForContainersGcpOfferingResponseNativeCloudConnection' native_cloud_connection: The native cloud connection configuration
        :param bool policy_agent_auto_provisioning_flag: Is Policy Kubernetes agent auto provisioning enabled
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'DefenderForContainersGcp')
        if audit_logs_auto_provisioning_flag is not None:
            pulumi.set(__self__, "audit_logs_auto_provisioning_flag", audit_logs_auto_provisioning_flag)
        if data_pipeline_native_cloud_connection is not None:
            pulumi.set(__self__, "data_pipeline_native_cloud_connection", data_pipeline_native_cloud_connection)
        if defender_agent_auto_provisioning_flag is not None:
            pulumi.set(__self__, "defender_agent_auto_provisioning_flag", defender_agent_auto_provisioning_flag)
        if native_cloud_connection is not None:
            pulumi.set(__self__, "native_cloud_connection", native_cloud_connection)
        if policy_agent_auto_provisioning_flag is not None:
            pulumi.set(__self__, "policy_agent_auto_provisioning_flag", policy_agent_auto_provisioning_flag)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'DefenderForContainersGcp'.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="auditLogsAutoProvisioningFlag")
    def audit_logs_auto_provisioning_flag(self) -> Optional[bool]:
        """
        Is audit logs data collection enabled
        """
        return pulumi.get(self, "audit_logs_auto_provisioning_flag")

    @property
    @pulumi.getter(name="dataPipelineNativeCloudConnection")
    def data_pipeline_native_cloud_connection(self) -> Optional['outputs.DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection']:
        """
        The native cloud connection configuration
        """
        return pulumi.get(self, "data_pipeline_native_cloud_connection")

    @property
    @pulumi.getter(name="defenderAgentAutoProvisioningFlag")
    def defender_agent_auto_provisioning_flag(self) -> Optional[bool]:
        """
        Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
        """
        return pulumi.get(self, "defender_agent_auto_provisioning_flag")

    @property
    @pulumi.getter(name="nativeCloudConnection")
    def native_cloud_connection(self) -> Optional['outputs.DefenderForContainersGcpOfferingResponseNativeCloudConnection']:
        """
        The native cloud connection configuration
        """
        return pulumi.get(self, "native_cloud_connection")

    @property
    @pulumi.getter(name="policyAgentAutoProvisioningFlag")
    def policy_agent_auto_provisioning_flag(self) -> Optional[bool]:
        """
        Is Policy Kubernetes agent auto provisioning enabled
        """
        return pulumi.get(self, "policy_agent_auto_provisioning_flag")


@pulumi.output_type
class DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection(dict):
    """
    The native cloud connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmailAddress":
            suggest = "service_account_email_address"
        elif key == "workloadIdentityProviderId":
            suggest = "workload_identity_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_email_address: Optional[str] = None,
                 workload_identity_provider_id: Optional[str] = None):
        """
        The native cloud connection configuration
        :param str service_account_email_address: The data collection service account email address in GCP for this offering
        :param str workload_identity_provider_id: The data collection GCP workload identity provider id for this offering
        """
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if workload_identity_provider_id is not None:
            pulumi.set(__self__, "workload_identity_provider_id", workload_identity_provider_id)

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[str]:
        """
        The data collection service account email address in GCP for this offering
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter(name="workloadIdentityProviderId")
    def workload_identity_provider_id(self) -> Optional[str]:
        """
        The data collection GCP workload identity provider id for this offering
        """
        return pulumi.get(self, "workload_identity_provider_id")


@pulumi.output_type
class DefenderForContainersGcpOfferingResponseNativeCloudConnection(dict):
    """
    The native cloud connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmailAddress":
            suggest = "service_account_email_address"
        elif key == "workloadIdentityProviderId":
            suggest = "workload_identity_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForContainersGcpOfferingResponseNativeCloudConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForContainersGcpOfferingResponseNativeCloudConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForContainersGcpOfferingResponseNativeCloudConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_email_address: Optional[str] = None,
                 workload_identity_provider_id: Optional[str] = None):
        """
        The native cloud connection configuration
        :param str service_account_email_address: The service account email address in GCP for this offering
        :param str workload_identity_provider_id: The GCP workload identity provider id for this offering
        """
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if workload_identity_provider_id is not None:
            pulumi.set(__self__, "workload_identity_provider_id", workload_identity_provider_id)

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[str]:
        """
        The service account email address in GCP for this offering
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter(name="workloadIdentityProviderId")
    def workload_identity_provider_id(self) -> Optional[str]:
        """
        The GCP workload identity provider id for this offering
        """
        return pulumi.get(self, "workload_identity_provider_id")


@pulumi.output_type
class DefenderForServersAwsOfferingResponse(dict):
    """
    The Defender for Servers AWS offering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"
        elif key == "arcAutoProvisioning":
            suggest = "arc_auto_provisioning"
        elif key == "defenderForServers":
            suggest = "defender_for_servers"
        elif key == "mdeAutoProvisioning":
            suggest = "mde_auto_provisioning"
        elif key == "subPlan":
            suggest = "sub_plan"
        elif key == "vaAutoProvisioning":
            suggest = "va_auto_provisioning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForServersAwsOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForServersAwsOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForServersAwsOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str,
                 arc_auto_provisioning: Optional['outputs.DefenderForServersAwsOfferingResponseArcAutoProvisioning'] = None,
                 defender_for_servers: Optional['outputs.DefenderForServersAwsOfferingResponseDefenderForServers'] = None,
                 mde_auto_provisioning: Optional['outputs.DefenderForServersAwsOfferingResponseMdeAutoProvisioning'] = None,
                 sub_plan: Optional['outputs.DefenderForServersAwsOfferingResponseSubPlan'] = None,
                 va_auto_provisioning: Optional['outputs.DefenderForServersAwsOfferingResponseVaAutoProvisioning'] = None):
        """
        The Defender for Servers AWS offering
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'DefenderForServersAws'.
        :param 'DefenderForServersAwsOfferingResponseArcAutoProvisioning' arc_auto_provisioning: The ARC autoprovisioning configuration
        :param 'DefenderForServersAwsOfferingResponseDefenderForServers' defender_for_servers: The Defender for servers connection configuration
        :param 'DefenderForServersAwsOfferingResponseMdeAutoProvisioning' mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning configuration
        :param 'DefenderForServersAwsOfferingResponseSubPlan' sub_plan: configuration for the servers offering subPlan
        :param 'DefenderForServersAwsOfferingResponseVaAutoProvisioning' va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'DefenderForServersAws')
        if arc_auto_provisioning is not None:
            pulumi.set(__self__, "arc_auto_provisioning", arc_auto_provisioning)
        if defender_for_servers is not None:
            pulumi.set(__self__, "defender_for_servers", defender_for_servers)
        if mde_auto_provisioning is not None:
            pulumi.set(__self__, "mde_auto_provisioning", mde_auto_provisioning)
        if sub_plan is not None:
            pulumi.set(__self__, "sub_plan", sub_plan)
        if va_auto_provisioning is not None:
            pulumi.set(__self__, "va_auto_provisioning", va_auto_provisioning)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'DefenderForServersAws'.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="arcAutoProvisioning")
    def arc_auto_provisioning(self) -> Optional['outputs.DefenderForServersAwsOfferingResponseArcAutoProvisioning']:
        """
        The ARC autoprovisioning configuration
        """
        return pulumi.get(self, "arc_auto_provisioning")

    @property
    @pulumi.getter(name="defenderForServers")
    def defender_for_servers(self) -> Optional['outputs.DefenderForServersAwsOfferingResponseDefenderForServers']:
        """
        The Defender for servers connection configuration
        """
        return pulumi.get(self, "defender_for_servers")

    @property
    @pulumi.getter(name="mdeAutoProvisioning")
    def mde_auto_provisioning(self) -> Optional['outputs.DefenderForServersAwsOfferingResponseMdeAutoProvisioning']:
        """
        The Microsoft Defender for Endpoint autoprovisioning configuration
        """
        return pulumi.get(self, "mde_auto_provisioning")

    @property
    @pulumi.getter(name="subPlan")
    def sub_plan(self) -> Optional['outputs.DefenderForServersAwsOfferingResponseSubPlan']:
        """
        configuration for the servers offering subPlan
        """
        return pulumi.get(self, "sub_plan")

    @property
    @pulumi.getter(name="vaAutoProvisioning")
    def va_auto_provisioning(self) -> Optional['outputs.DefenderForServersAwsOfferingResponseVaAutoProvisioning']:
        """
        The Vulnerability Assessment autoprovisioning configuration
        """
        return pulumi.get(self, "va_auto_provisioning")


@pulumi.output_type
class DefenderForServersAwsOfferingResponseArcAutoProvisioning(dict):
    """
    The ARC autoprovisioning configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "servicePrincipalSecretMetadata":
            suggest = "service_principal_secret_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForServersAwsOfferingResponseArcAutoProvisioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForServersAwsOfferingResponseArcAutoProvisioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForServersAwsOfferingResponseArcAutoProvisioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 service_principal_secret_metadata: Optional['outputs.DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata'] = None):
        """
        The ARC autoprovisioning configuration
        :param bool enabled: Is arc auto provisioning enabled
        :param 'DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata' service_principal_secret_metadata: Metadata of Service Principal secret for autoprovisioning
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if service_principal_secret_metadata is not None:
            pulumi.set(__self__, "service_principal_secret_metadata", service_principal_secret_metadata)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Is arc auto provisioning enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="servicePrincipalSecretMetadata")
    def service_principal_secret_metadata(self) -> Optional['outputs.DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata']:
        """
        Metadata of Service Principal secret for autoprovisioning
        """
        return pulumi.get(self, "service_principal_secret_metadata")


@pulumi.output_type
class DefenderForServersAwsOfferingResponseConfiguration(dict):
    """
    configuration for Vulnerability Assessment autoprovisioning
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        configuration for Vulnerability Assessment autoprovisioning
        :param str type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DefenderForServersAwsOfferingResponseDefenderForServers(dict):
    """
    The Defender for servers connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRoleArn":
            suggest = "cloud_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForServersAwsOfferingResponseDefenderForServers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForServersAwsOfferingResponseDefenderForServers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForServersAwsOfferingResponseDefenderForServers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_role_arn: Optional[str] = None):
        """
        The Defender for servers connection configuration
        :param str cloud_role_arn: The cloud role ARN in AWS for this feature
        """
        if cloud_role_arn is not None:
            pulumi.set(__self__, "cloud_role_arn", cloud_role_arn)

    @property
    @pulumi.getter(name="cloudRoleArn")
    def cloud_role_arn(self) -> Optional[str]:
        """
        The cloud role ARN in AWS for this feature
        """
        return pulumi.get(self, "cloud_role_arn")


@pulumi.output_type
class DefenderForServersAwsOfferingResponseMdeAutoProvisioning(dict):
    """
    The Microsoft Defender for Endpoint autoprovisioning configuration
    """
    def __init__(__self__, *,
                 configuration: Optional[Any] = None,
                 enabled: Optional[bool] = None):
        """
        The Microsoft Defender for Endpoint autoprovisioning configuration
        :param Any configuration: configuration for Microsoft Defender for Endpoint autoprovisioning
        :param bool enabled: Is Microsoft Defender for Endpoint auto provisioning enabled
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        configuration for Microsoft Defender for Endpoint autoprovisioning
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Is Microsoft Defender for Endpoint auto provisioning enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata(dict):
    """
    Metadata of Service Principal secret for autoprovisioning
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiryDate":
            suggest = "expiry_date"
        elif key == "parameterNameInStore":
            suggest = "parameter_name_in_store"
        elif key == "parameterStoreRegion":
            suggest = "parameter_store_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForServersAwsOfferingResponseServicePrincipalSecretMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiry_date: Optional[str] = None,
                 parameter_name_in_store: Optional[str] = None,
                 parameter_store_region: Optional[str] = None):
        """
        Metadata of Service Principal secret for autoprovisioning
        :param str expiry_date: expiration date of service principal secret
        :param str parameter_name_in_store: name of secret resource in parameter store
        :param str parameter_store_region: region of parameter store where secret is kept
        """
        if expiry_date is not None:
            pulumi.set(__self__, "expiry_date", expiry_date)
        if parameter_name_in_store is not None:
            pulumi.set(__self__, "parameter_name_in_store", parameter_name_in_store)
        if parameter_store_region is not None:
            pulumi.set(__self__, "parameter_store_region", parameter_store_region)

    @property
    @pulumi.getter(name="expiryDate")
    def expiry_date(self) -> Optional[str]:
        """
        expiration date of service principal secret
        """
        return pulumi.get(self, "expiry_date")

    @property
    @pulumi.getter(name="parameterNameInStore")
    def parameter_name_in_store(self) -> Optional[str]:
        """
        name of secret resource in parameter store
        """
        return pulumi.get(self, "parameter_name_in_store")

    @property
    @pulumi.getter(name="parameterStoreRegion")
    def parameter_store_region(self) -> Optional[str]:
        """
        region of parameter store where secret is kept
        """
        return pulumi.get(self, "parameter_store_region")


@pulumi.output_type
class DefenderForServersAwsOfferingResponseSubPlan(dict):
    """
    configuration for the servers offering subPlan
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        configuration for the servers offering subPlan
        :param str type: The available sub plans
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The available sub plans
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DefenderForServersAwsOfferingResponseVaAutoProvisioning(dict):
    """
    The Vulnerability Assessment autoprovisioning configuration
    """
    def __init__(__self__, *,
                 configuration: Optional['outputs.DefenderForServersAwsOfferingResponseConfiguration'] = None,
                 enabled: Optional[bool] = None):
        """
        The Vulnerability Assessment autoprovisioning configuration
        :param 'DefenderForServersAwsOfferingResponseConfiguration' configuration: configuration for Vulnerability Assessment autoprovisioning
        :param bool enabled: Is Vulnerability Assessment auto provisioning enabled
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.DefenderForServersAwsOfferingResponseConfiguration']:
        """
        configuration for Vulnerability Assessment autoprovisioning
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Is Vulnerability Assessment auto provisioning enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DefenderForServersGcpOfferingResponse(dict):
    """
    The Defender for Servers GCP offering configurations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"
        elif key == "arcAutoProvisioning":
            suggest = "arc_auto_provisioning"
        elif key == "defenderForServers":
            suggest = "defender_for_servers"
        elif key == "mdeAutoProvisioning":
            suggest = "mde_auto_provisioning"
        elif key == "subPlan":
            suggest = "sub_plan"
        elif key == "vaAutoProvisioning":
            suggest = "va_auto_provisioning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForServersGcpOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForServersGcpOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForServersGcpOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str,
                 arc_auto_provisioning: Optional['outputs.DefenderForServersGcpOfferingResponseArcAutoProvisioning'] = None,
                 defender_for_servers: Optional['outputs.DefenderForServersGcpOfferingResponseDefenderForServers'] = None,
                 mde_auto_provisioning: Optional['outputs.DefenderForServersGcpOfferingResponseMdeAutoProvisioning'] = None,
                 sub_plan: Optional['outputs.DefenderForServersGcpOfferingResponseSubPlan'] = None,
                 va_auto_provisioning: Optional['outputs.DefenderForServersGcpOfferingResponseVaAutoProvisioning'] = None):
        """
        The Defender for Servers GCP offering configurations
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'DefenderForServersGcp'.
        :param 'DefenderForServersGcpOfferingResponseArcAutoProvisioning' arc_auto_provisioning: The ARC autoprovisioning configuration
        :param 'DefenderForServersGcpOfferingResponseDefenderForServers' defender_for_servers: The Defender for servers connection configuration
        :param 'DefenderForServersGcpOfferingResponseMdeAutoProvisioning' mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning configuration
        :param 'DefenderForServersGcpOfferingResponseSubPlan' sub_plan: configuration for the servers offering subPlan
        :param 'DefenderForServersGcpOfferingResponseVaAutoProvisioning' va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'DefenderForServersGcp')
        if arc_auto_provisioning is not None:
            pulumi.set(__self__, "arc_auto_provisioning", arc_auto_provisioning)
        if defender_for_servers is not None:
            pulumi.set(__self__, "defender_for_servers", defender_for_servers)
        if mde_auto_provisioning is not None:
            pulumi.set(__self__, "mde_auto_provisioning", mde_auto_provisioning)
        if sub_plan is not None:
            pulumi.set(__self__, "sub_plan", sub_plan)
        if va_auto_provisioning is not None:
            pulumi.set(__self__, "va_auto_provisioning", va_auto_provisioning)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'DefenderForServersGcp'.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="arcAutoProvisioning")
    def arc_auto_provisioning(self) -> Optional['outputs.DefenderForServersGcpOfferingResponseArcAutoProvisioning']:
        """
        The ARC autoprovisioning configuration
        """
        return pulumi.get(self, "arc_auto_provisioning")

    @property
    @pulumi.getter(name="defenderForServers")
    def defender_for_servers(self) -> Optional['outputs.DefenderForServersGcpOfferingResponseDefenderForServers']:
        """
        The Defender for servers connection configuration
        """
        return pulumi.get(self, "defender_for_servers")

    @property
    @pulumi.getter(name="mdeAutoProvisioning")
    def mde_auto_provisioning(self) -> Optional['outputs.DefenderForServersGcpOfferingResponseMdeAutoProvisioning']:
        """
        The Microsoft Defender for Endpoint autoprovisioning configuration
        """
        return pulumi.get(self, "mde_auto_provisioning")

    @property
    @pulumi.getter(name="subPlan")
    def sub_plan(self) -> Optional['outputs.DefenderForServersGcpOfferingResponseSubPlan']:
        """
        configuration for the servers offering subPlan
        """
        return pulumi.get(self, "sub_plan")

    @property
    @pulumi.getter(name="vaAutoProvisioning")
    def va_auto_provisioning(self) -> Optional['outputs.DefenderForServersGcpOfferingResponseVaAutoProvisioning']:
        """
        The Vulnerability Assessment autoprovisioning configuration
        """
        return pulumi.get(self, "va_auto_provisioning")


@pulumi.output_type
class DefenderForServersGcpOfferingResponseArcAutoProvisioning(dict):
    """
    The ARC autoprovisioning configuration
    """
    def __init__(__self__, *,
                 configuration: Optional['outputs.DefenderForServersGcpOfferingResponseConfiguration'] = None,
                 enabled: Optional[bool] = None):
        """
        The ARC autoprovisioning configuration
        :param 'DefenderForServersGcpOfferingResponseConfiguration' configuration: Configuration for ARC autoprovisioning
        :param bool enabled: Is arc auto provisioning enabled
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.DefenderForServersGcpOfferingResponseConfiguration']:
        """
        Configuration for ARC autoprovisioning
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Is arc auto provisioning enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DefenderForServersGcpOfferingResponseConfiguration(dict):
    """
    Configuration for ARC autoprovisioning
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentOnboardingServiceAccountNumericId":
            suggest = "agent_onboarding_service_account_numeric_id"
        elif key == "clientId":
            suggest = "client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForServersGcpOfferingResponseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForServersGcpOfferingResponseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForServersGcpOfferingResponseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_onboarding_service_account_numeric_id: Optional[str] = None,
                 client_id: Optional[str] = None):
        """
        Configuration for ARC autoprovisioning
        :param str agent_onboarding_service_account_numeric_id: The agent onboarding service account numeric id
        :param str client_id: The Azure service principal client id for agent onboarding
        """
        if agent_onboarding_service_account_numeric_id is not None:
            pulumi.set(__self__, "agent_onboarding_service_account_numeric_id", agent_onboarding_service_account_numeric_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)

    @property
    @pulumi.getter(name="agentOnboardingServiceAccountNumericId")
    def agent_onboarding_service_account_numeric_id(self) -> Optional[str]:
        """
        The agent onboarding service account numeric id
        """
        return pulumi.get(self, "agent_onboarding_service_account_numeric_id")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Azure service principal client id for agent onboarding
        """
        return pulumi.get(self, "client_id")


@pulumi.output_type
class DefenderForServersGcpOfferingResponseConfigurationConfiguration(dict):
    """
    configuration for Vulnerability Assessment autoprovisioning
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        configuration for Vulnerability Assessment autoprovisioning
        :param str type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DefenderForServersGcpOfferingResponseDefenderForServers(dict):
    """
    The Defender for servers connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmailAddress":
            suggest = "service_account_email_address"
        elif key == "workloadIdentityProviderId":
            suggest = "workload_identity_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefenderForServersGcpOfferingResponseDefenderForServers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefenderForServersGcpOfferingResponseDefenderForServers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefenderForServersGcpOfferingResponseDefenderForServers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_email_address: Optional[str] = None,
                 workload_identity_provider_id: Optional[str] = None):
        """
        The Defender for servers connection configuration
        :param str service_account_email_address: The service account email address in GCP for this feature
        :param str workload_identity_provider_id: The workload identity provider id in GCP for this feature
        """
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if workload_identity_provider_id is not None:
            pulumi.set(__self__, "workload_identity_provider_id", workload_identity_provider_id)

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[str]:
        """
        The service account email address in GCP for this feature
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter(name="workloadIdentityProviderId")
    def workload_identity_provider_id(self) -> Optional[str]:
        """
        The workload identity provider id in GCP for this feature
        """
        return pulumi.get(self, "workload_identity_provider_id")


@pulumi.output_type
class DefenderForServersGcpOfferingResponseMdeAutoProvisioning(dict):
    """
    The Microsoft Defender for Endpoint autoprovisioning configuration
    """
    def __init__(__self__, *,
                 configuration: Optional[Any] = None,
                 enabled: Optional[bool] = None):
        """
        The Microsoft Defender for Endpoint autoprovisioning configuration
        :param Any configuration: configuration for Microsoft Defender for Endpoint autoprovisioning
        :param bool enabled: Is Microsoft Defender for Endpoint auto provisioning enabled
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        configuration for Microsoft Defender for Endpoint autoprovisioning
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Is Microsoft Defender for Endpoint auto provisioning enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DefenderForServersGcpOfferingResponseSubPlan(dict):
    """
    configuration for the servers offering subPlan
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        configuration for the servers offering subPlan
        :param str type: The available sub plans
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The available sub plans
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DefenderForServersGcpOfferingResponseVaAutoProvisioning(dict):
    """
    The Vulnerability Assessment autoprovisioning configuration
    """
    def __init__(__self__, *,
                 configuration: Optional['outputs.DefenderForServersGcpOfferingResponseConfigurationConfiguration'] = None,
                 enabled: Optional[bool] = None):
        """
        The Vulnerability Assessment autoprovisioning configuration
        :param 'DefenderForServersGcpOfferingResponseConfigurationConfiguration' configuration: configuration for Vulnerability Assessment autoprovisioning
        :param bool enabled: Is Vulnerability Assessment auto provisioning enabled
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.DefenderForServersGcpOfferingResponseConfigurationConfiguration']:
        """
        configuration for Vulnerability Assessment autoprovisioning
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Is Vulnerability Assessment auto provisioning enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GcpOrganizationalDataMemberResponse(dict):
    """
    The gcpOrganization data for the member account
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "organizationMembershipType":
            suggest = "organization_membership_type"
        elif key == "parentHierarchyId":
            suggest = "parent_hierarchy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpOrganizationalDataMemberResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpOrganizationalDataMemberResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpOrganizationalDataMemberResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization_membership_type: str,
                 parent_hierarchy_id: Optional[str] = None):
        """
        The gcpOrganization data for the member account
        :param str organization_membership_type: The multi cloud account's membership type in the organization
               Expected value is 'Member'.
        :param str parent_hierarchy_id: If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
        """
        pulumi.set(__self__, "organization_membership_type", 'Member')
        if parent_hierarchy_id is not None:
            pulumi.set(__self__, "parent_hierarchy_id", parent_hierarchy_id)

    @property
    @pulumi.getter(name="organizationMembershipType")
    def organization_membership_type(self) -> str:
        """
        The multi cloud account's membership type in the organization
        Expected value is 'Member'.
        """
        return pulumi.get(self, "organization_membership_type")

    @property
    @pulumi.getter(name="parentHierarchyId")
    def parent_hierarchy_id(self) -> Optional[str]:
        """
        If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
        """
        return pulumi.get(self, "parent_hierarchy_id")


@pulumi.output_type
class GcpOrganizationalDataOrganizationResponse(dict):
    """
    The gcpOrganization data for the parent account
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "organizationMembershipType":
            suggest = "organization_membership_type"
        elif key == "excludedProjectNumbers":
            suggest = "excluded_project_numbers"
        elif key == "serviceAccountEmailAddress":
            suggest = "service_account_email_address"
        elif key == "workloadIdentityProviderId":
            suggest = "workload_identity_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpOrganizationalDataOrganizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpOrganizationalDataOrganizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpOrganizationalDataOrganizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization_membership_type: str,
                 excluded_project_numbers: Optional[Sequence[str]] = None,
                 service_account_email_address: Optional[str] = None,
                 workload_identity_provider_id: Optional[str] = None):
        """
        The gcpOrganization data for the parent account
        :param str organization_membership_type: The multi cloud account's membership type in the organization
               Expected value is 'Organization'.
        :param Sequence[str] excluded_project_numbers: If the multi cloud account is of membership type organization, list of accounts excluded from offering
        :param str service_account_email_address: The service account email address which represents the organization level permissions container.
        :param str workload_identity_provider_id: The GCP workload identity provider id which represents the permissions required to auto provision security connectors
        """
        pulumi.set(__self__, "organization_membership_type", 'Organization')
        if excluded_project_numbers is not None:
            pulumi.set(__self__, "excluded_project_numbers", excluded_project_numbers)
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if workload_identity_provider_id is not None:
            pulumi.set(__self__, "workload_identity_provider_id", workload_identity_provider_id)

    @property
    @pulumi.getter(name="organizationMembershipType")
    def organization_membership_type(self) -> str:
        """
        The multi cloud account's membership type in the organization
        Expected value is 'Organization'.
        """
        return pulumi.get(self, "organization_membership_type")

    @property
    @pulumi.getter(name="excludedProjectNumbers")
    def excluded_project_numbers(self) -> Optional[Sequence[str]]:
        """
        If the multi cloud account is of membership type organization, list of accounts excluded from offering
        """
        return pulumi.get(self, "excluded_project_numbers")

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[str]:
        """
        The service account email address which represents the organization level permissions container.
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter(name="workloadIdentityProviderId")
    def workload_identity_provider_id(self) -> Optional[str]:
        """
        The GCP workload identity provider id which represents the permissions required to auto provision security connectors
        """
        return pulumi.get(self, "workload_identity_provider_id")


@pulumi.output_type
class GcpProjectDetailsResponse(dict):
    """
    The details about the project represented by the security connector
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workloadIdentityPoolId":
            suggest = "workload_identity_pool_id"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpProjectDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpProjectDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpProjectDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workload_identity_pool_id: str,
                 project_id: Optional[str] = None,
                 project_number: Optional[str] = None):
        """
        The details about the project represented by the security connector
        :param str workload_identity_pool_id: The GCP workload identity federation pool id
        :param str project_id: The GCP Project id
        :param str project_number: The unique GCP Project number
        """
        pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)

    @property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> str:
        """
        The GCP workload identity federation pool id
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The GCP Project id
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[str]:
        """
        The unique GCP Project number
        """
        return pulumi.get(self, "project_number")


@pulumi.output_type
class GcpProjectEnvironmentDataResponse(dict):
    """
    The GCP project connector environment data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentType":
            suggest = "environment_type"
        elif key == "organizationalData":
            suggest = "organizational_data"
        elif key == "projectDetails":
            suggest = "project_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcpProjectEnvironmentDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcpProjectEnvironmentDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcpProjectEnvironmentDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_type: str,
                 organizational_data: Optional[Any] = None,
                 project_details: Optional['outputs.GcpProjectDetailsResponse'] = None):
        """
        The GCP project connector environment data
        :param str environment_type: The type of the environment data.
               Expected value is 'GcpProject'.
        :param Union['GcpOrganizationalDataMemberResponse', 'GcpOrganizationalDataOrganizationResponse'] organizational_data: The Gcp project's organizational data
        :param 'GcpProjectDetailsResponse' project_details: The Gcp project's details
        """
        pulumi.set(__self__, "environment_type", 'GcpProject')
        if organizational_data is not None:
            pulumi.set(__self__, "organizational_data", organizational_data)
        if project_details is not None:
            pulumi.set(__self__, "project_details", project_details)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        The type of the environment data.
        Expected value is 'GcpProject'.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="organizationalData")
    def organizational_data(self) -> Optional[Any]:
        """
        The Gcp project's organizational data
        """
        return pulumi.get(self, "organizational_data")

    @property
    @pulumi.getter(name="projectDetails")
    def project_details(self) -> Optional['outputs.GcpProjectDetailsResponse']:
        """
        The Gcp project's details
        """
        return pulumi.get(self, "project_details")


@pulumi.output_type
class GithubScopeEnvironmentDataResponse(dict):
    """
    The github scope connector's environment data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentType":
            suggest = "environment_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GithubScopeEnvironmentDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GithubScopeEnvironmentDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GithubScopeEnvironmentDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_type: str):
        """
        The github scope connector's environment data
        :param str environment_type: The type of the environment data.
               Expected value is 'GithubScope'.
        """
        pulumi.set(__self__, "environment_type", 'GithubScope')

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> str:
        """
        The type of the environment data.
        Expected value is 'GithubScope'.
        """
        return pulumi.get(self, "environment_type")


@pulumi.output_type
class InformationProtectionAwsOfferingResponse(dict):
    """
    The information protection for AWS offering
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offeringType":
            suggest = "offering_type"
        elif key == "informationProtection":
            suggest = "information_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InformationProtectionAwsOfferingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InformationProtectionAwsOfferingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InformationProtectionAwsOfferingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 offering_type: str,
                 information_protection: Optional['outputs.InformationProtectionAwsOfferingResponseInformationProtection'] = None):
        """
        The information protection for AWS offering
        :param str description: The offering description.
        :param str offering_type: The type of the security offering.
               Expected value is 'InformationProtectionAws'.
        :param 'InformationProtectionAwsOfferingResponseInformationProtection' information_protection: The native cloud connection configuration
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "offering_type", 'InformationProtectionAws')
        if information_protection is not None:
            pulumi.set(__self__, "information_protection", information_protection)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The offering description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> str:
        """
        The type of the security offering.
        Expected value is 'InformationProtectionAws'.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="informationProtection")
    def information_protection(self) -> Optional['outputs.InformationProtectionAwsOfferingResponseInformationProtection']:
        """
        The native cloud connection configuration
        """
        return pulumi.get(self, "information_protection")


@pulumi.output_type
class InformationProtectionAwsOfferingResponseInformationProtection(dict):
    """
    The native cloud connection configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRoleArn":
            suggest = "cloud_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InformationProtectionAwsOfferingResponseInformationProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InformationProtectionAwsOfferingResponseInformationProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InformationProtectionAwsOfferingResponseInformationProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_role_arn: Optional[str] = None):
        """
        The native cloud connection configuration
        :param str cloud_role_arn: The cloud role ARN in AWS for this feature
        """
        if cloud_role_arn is not None:
            pulumi.set(__self__, "cloud_role_arn", cloud_role_arn)

    @property
    @pulumi.getter(name="cloudRoleArn")
    def cloud_role_arn(self) -> Optional[str]:
        """
        The cloud role ARN in AWS for this feature
        """
        return pulumi.get(self, "cloud_role_arn")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


