# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ActiveDirectoryPropertiesArgs',
    'AzureFilesIdentityBasedAuthenticationArgs',
    'ChangeFeedArgs',
    'CorsRulesArgs',
    'CorsRuleArgs',
    'CustomDomainArgs',
    'DateAfterCreationArgs',
    'DateAfterModificationArgs',
    'DeleteRetentionPolicyArgs',
    'EncryptionServicesArgs',
    'EncryptionServiceArgs',
    'EncryptionArgs',
    'IPRuleArgs',
    'IdentityArgs',
    'KeyVaultPropertiesArgs',
    'ManagementPolicyActionArgs',
    'ManagementPolicyBaseBlobArgs',
    'ManagementPolicyDefinitionArgs',
    'ManagementPolicyFilterArgs',
    'ManagementPolicyRuleArgs',
    'ManagementPolicySchemaArgs',
    'ManagementPolicySnapShotArgs',
    'NetworkRuleSetArgs',
    'RestrictionArgs',
    'SkuArgs',
    'VirtualNetworkRuleArgs',
]

@pulumi.input_type
class ActiveDirectoryPropertiesArgs:
    def __init__(__self__, *,
                 azure_storage_sid: pulumi.Input[str],
                 domain_guid: pulumi.Input[str],
                 domain_name: pulumi.Input[str],
                 domain_sid: pulumi.Input[str],
                 forest_name: pulumi.Input[str],
                 net_bios_domain_name: pulumi.Input[str]):
        """
        Settings properties for Active Directory (AD).
        :param pulumi.Input[str] azure_storage_sid: Specifies the security identifier (SID) for Azure Storage.
        :param pulumi.Input[str] domain_guid: Specifies the domain GUID.
        :param pulumi.Input[str] domain_name: Specifies the primary domain that the AD DNS server is authoritative for.
        :param pulumi.Input[str] domain_sid: Specifies the security identifier (SID).
        :param pulumi.Input[str] forest_name: Specifies the Active Directory forest to get.
        :param pulumi.Input[str] net_bios_domain_name: Specifies the NetBIOS domain name.
        """
        pulumi.set(__self__, "azure_storage_sid", azure_storage_sid)
        pulumi.set(__self__, "domain_guid", domain_guid)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_sid", domain_sid)
        pulumi.set(__self__, "forest_name", forest_name)
        pulumi.set(__self__, "net_bios_domain_name", net_bios_domain_name)

    @property
    @pulumi.getter(name="azureStorageSid")
    def azure_storage_sid(self) -> pulumi.Input[str]:
        """
        Specifies the security identifier (SID) for Azure Storage.
        """
        return pulumi.get(self, "azure_storage_sid")

    @azure_storage_sid.setter
    def azure_storage_sid(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_storage_sid", value)

    @property
    @pulumi.getter(name="domainGuid")
    def domain_guid(self) -> pulumi.Input[str]:
        """
        Specifies the domain GUID.
        """
        return pulumi.get(self, "domain_guid")

    @domain_guid.setter
    def domain_guid(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_guid", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Specifies the primary domain that the AD DNS server is authoritative for.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainSid")
    def domain_sid(self) -> pulumi.Input[str]:
        """
        Specifies the security identifier (SID).
        """
        return pulumi.get(self, "domain_sid")

    @domain_sid.setter
    def domain_sid(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_sid", value)

    @property
    @pulumi.getter(name="forestName")
    def forest_name(self) -> pulumi.Input[str]:
        """
        Specifies the Active Directory forest to get.
        """
        return pulumi.get(self, "forest_name")

    @forest_name.setter
    def forest_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "forest_name", value)

    @property
    @pulumi.getter(name="netBiosDomainName")
    def net_bios_domain_name(self) -> pulumi.Input[str]:
        """
        Specifies the NetBIOS domain name.
        """
        return pulumi.get(self, "net_bios_domain_name")

    @net_bios_domain_name.setter
    def net_bios_domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "net_bios_domain_name", value)


@pulumi.input_type
class AzureFilesIdentityBasedAuthenticationArgs:
    def __init__(__self__, *,
                 directory_service_options: pulumi.Input[Union[str, 'DirectoryServiceOptions']],
                 active_directory_properties: Optional[pulumi.Input['ActiveDirectoryPropertiesArgs']] = None):
        """
        Settings for Azure Files identity based authentication.
        :param pulumi.Input[Union[str, 'DirectoryServiceOptions']] directory_service_options: Indicates the directory service used.
        :param pulumi.Input['ActiveDirectoryPropertiesArgs'] active_directory_properties: Required if choose AD.
        """
        pulumi.set(__self__, "directory_service_options", directory_service_options)
        if active_directory_properties is not None:
            pulumi.set(__self__, "active_directory_properties", active_directory_properties)

    @property
    @pulumi.getter(name="directoryServiceOptions")
    def directory_service_options(self) -> pulumi.Input[Union[str, 'DirectoryServiceOptions']]:
        """
        Indicates the directory service used.
        """
        return pulumi.get(self, "directory_service_options")

    @directory_service_options.setter
    def directory_service_options(self, value: pulumi.Input[Union[str, 'DirectoryServiceOptions']]):
        pulumi.set(self, "directory_service_options", value)

    @property
    @pulumi.getter(name="activeDirectoryProperties")
    def active_directory_properties(self) -> Optional[pulumi.Input['ActiveDirectoryPropertiesArgs']]:
        """
        Required if choose AD.
        """
        return pulumi.get(self, "active_directory_properties")

    @active_directory_properties.setter
    def active_directory_properties(self, value: Optional[pulumi.Input['ActiveDirectoryPropertiesArgs']]):
        pulumi.set(self, "active_directory_properties", value)


@pulumi.input_type
class ChangeFeedArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        The blob service properties for change feed events.
        :param pulumi.Input[bool] enabled: Indicates whether change feed event logging is enabled for the Blob service.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether change feed event logging is enabled for the Blob service.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class CorsRulesArgs:
    def __init__(__self__, *,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]]] = None):
        """
        Sets the CORS rules. You can include up to five CorsRule elements in the request. 
        :param pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]] cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]]]:
        """
        The List of CORS rules. You can include up to five CorsRule elements in the request. 
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)


@pulumi.input_type
class CorsRuleArgs:
    def __init__(__self__, *,
                 allowed_headers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 exposed_headers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 max_age_in_seconds: pulumi.Input[int]):
        """
        Specifies a CORS rule for the Blob service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exposed_headers: Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        :param pulumi.Input[int] max_age_in_seconds: Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required if CorsRule element is present. A list of response headers to expose to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @exposed_headers.setter
    def exposed_headers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "exposed_headers", value)

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> pulumi.Input[int]:
        """
        Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
        """
        return pulumi.get(self, "max_age_in_seconds")

    @max_age_in_seconds.setter
    def max_age_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_age_in_seconds", value)


@pulumi.input_type
class CustomDomainArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 use_sub_domain_name: Optional[pulumi.Input[bool]] = None):
        """
        The custom domain assigned to this storage account. This can be set via Update.
        :param pulumi.Input[str] name: Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        :param pulumi.Input[bool] use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        pulumi.set(__self__, "name", name)
        if use_sub_domain_name is not None:
            pulumi.set(__self__, "use_sub_domain_name", use_sub_domain_name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useSubDomainName")
    def use_sub_domain_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        return pulumi.get(self, "use_sub_domain_name")

    @use_sub_domain_name.setter
    def use_sub_domain_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_sub_domain_name", value)


@pulumi.input_type
class DateAfterCreationArgs:
    def __init__(__self__, *,
                 days_after_creation_greater_than: pulumi.Input[float]):
        """
        Object to define the number of days after creation.
        :param pulumi.Input[float] days_after_creation_greater_than: Value indicating the age in days after creation
        """
        pulumi.set(__self__, "days_after_creation_greater_than", days_after_creation_greater_than)

    @property
    @pulumi.getter(name="daysAfterCreationGreaterThan")
    def days_after_creation_greater_than(self) -> pulumi.Input[float]:
        """
        Value indicating the age in days after creation
        """
        return pulumi.get(self, "days_after_creation_greater_than")

    @days_after_creation_greater_than.setter
    def days_after_creation_greater_than(self, value: pulumi.Input[float]):
        pulumi.set(self, "days_after_creation_greater_than", value)


@pulumi.input_type
class DateAfterModificationArgs:
    def __init__(__self__, *,
                 days_after_modification_greater_than: pulumi.Input[float]):
        """
        Object to define the number of days after last modification.
        :param pulumi.Input[float] days_after_modification_greater_than: Value indicating the age in days after last modification
        """
        pulumi.set(__self__, "days_after_modification_greater_than", days_after_modification_greater_than)

    @property
    @pulumi.getter(name="daysAfterModificationGreaterThan")
    def days_after_modification_greater_than(self) -> pulumi.Input[float]:
        """
        Value indicating the age in days after last modification
        """
        return pulumi.get(self, "days_after_modification_greater_than")

    @days_after_modification_greater_than.setter
    def days_after_modification_greater_than(self, value: pulumi.Input[float]):
        pulumi.set(self, "days_after_modification_greater_than", value)


@pulumi.input_type
class DeleteRetentionPolicyArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        The blob service properties for soft delete.
        :param pulumi.Input[int] days: Indicates the number of days that the deleted blob should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        :param pulumi.Input[bool] enabled: Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the number of days that the deleted blob should be retained. The minimum specified value can be 1 and the maximum value can be 365.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether DeleteRetentionPolicy is enabled for the Blob service.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class EncryptionServicesArgs:
    def __init__(__self__, *,
                 blob: Optional[pulumi.Input['EncryptionServiceArgs']] = None,
                 file: Optional[pulumi.Input['EncryptionServiceArgs']] = None):
        """
        A list of services that support encryption.
        :param pulumi.Input['EncryptionServiceArgs'] blob: The encryption function of the blob storage service.
        :param pulumi.Input['EncryptionServiceArgs'] file: The encryption function of the file storage service.
        """
        if blob is not None:
            pulumi.set(__self__, "blob", blob)
        if file is not None:
            pulumi.set(__self__, "file", file)

    @property
    @pulumi.getter
    def blob(self) -> Optional[pulumi.Input['EncryptionServiceArgs']]:
        """
        The encryption function of the blob storage service.
        """
        return pulumi.get(self, "blob")

    @blob.setter
    def blob(self, value: Optional[pulumi.Input['EncryptionServiceArgs']]):
        pulumi.set(self, "blob", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input['EncryptionServiceArgs']]:
        """
        The encryption function of the file storage service.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input['EncryptionServiceArgs']]):
        pulumi.set(self, "file", value)


@pulumi.input_type
class EncryptionServiceArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        A service that allows server-side encryption to be used.
        :param pulumi.Input[bool] enabled: A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class EncryptionArgs:
    def __init__(__self__, *,
                 key_source: pulumi.Input[Union[str, 'KeySource']],
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None,
                 services: Optional[pulumi.Input['EncryptionServicesArgs']] = None):
        """
        The encryption settings on the storage account.
        :param pulumi.Input[Union[str, 'KeySource']] key_source: The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Properties provided by key vault.
        :param pulumi.Input['EncryptionServicesArgs'] services: List of services which support encryption.
        """
        if key_source is None:
            key_source = 'Microsoft.Storage'
        pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> pulumi.Input[Union[str, 'KeySource']]:
        """
        The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        """
        return pulumi.get(self, "key_source")

    @key_source.setter
    def key_source(self, value: pulumi.Input[Union[str, 'KeySource']]):
        pulumi.set(self, "key_source", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        Properties provided by key vault.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input['EncryptionServicesArgs']]:
        """
        List of services which support encryption.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input['EncryptionServicesArgs']]):
        pulumi.set(self, "services", value)


@pulumi.input_type
class IPRuleArgs:
    def __init__(__self__, *,
                 i_p_address_or_range: pulumi.Input[str],
                 action: Optional[pulumi.Input['Action']] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param pulumi.Input[str] i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param pulumi.Input['Action'] action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> pulumi.Input[str]:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @i_p_address_or_range.setter
    def i_p_address_or_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "i_p_address_or_range", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['Action']]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['Action']]):
        pulumi.set(self, "action", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['IdentityType']):
        """
        Identity for the resource.
        :param pulumi.Input['IdentityType'] type: The identity type.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['IdentityType']:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['IdentityType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_vault_uri: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None):
        """
        Properties of key vault.
        :param pulumi.Input[str] key_name: The name of KeyVault key.
        :param pulumi.Input[str] key_vault_uri: The Uri of KeyVault.
        :param pulumi.Input[str] key_version: The version of KeyVault key.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of KeyVault key.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Uri of KeyVault.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of KeyVault key.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)


@pulumi.input_type
class ManagementPolicyActionArgs:
    def __init__(__self__, *,
                 base_blob: Optional[pulumi.Input['ManagementPolicyBaseBlobArgs']] = None,
                 snapshot: Optional[pulumi.Input['ManagementPolicySnapShotArgs']] = None):
        """
        Actions are applied to the filtered blobs when the execution condition is met.
        :param pulumi.Input['ManagementPolicyBaseBlobArgs'] base_blob: The management policy action for base blob
        :param pulumi.Input['ManagementPolicySnapShotArgs'] snapshot: The management policy action for snapshot
        """
        if base_blob is not None:
            pulumi.set(__self__, "base_blob", base_blob)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)

    @property
    @pulumi.getter(name="baseBlob")
    def base_blob(self) -> Optional[pulumi.Input['ManagementPolicyBaseBlobArgs']]:
        """
        The management policy action for base blob
        """
        return pulumi.get(self, "base_blob")

    @base_blob.setter
    def base_blob(self, value: Optional[pulumi.Input['ManagementPolicyBaseBlobArgs']]):
        pulumi.set(self, "base_blob", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['ManagementPolicySnapShotArgs']]:
        """
        The management policy action for snapshot
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['ManagementPolicySnapShotArgs']]):
        pulumi.set(self, "snapshot", value)


@pulumi.input_type
class ManagementPolicyBaseBlobArgs:
    def __init__(__self__, *,
                 delete: Optional[pulumi.Input['DateAfterModificationArgs']] = None,
                 tier_to_archive: Optional[pulumi.Input['DateAfterModificationArgs']] = None,
                 tier_to_cool: Optional[pulumi.Input['DateAfterModificationArgs']] = None):
        """
        Management policy action for base blob.
        :param pulumi.Input['DateAfterModificationArgs'] delete: The function to delete the blob
        :param pulumi.Input['DateAfterModificationArgs'] tier_to_archive: The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
        :param pulumi.Input['DateAfterModificationArgs'] tier_to_cool: The function to tier blobs to cool storage. Support blobs currently at Hot tier
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if tier_to_archive is not None:
            pulumi.set(__self__, "tier_to_archive", tier_to_archive)
        if tier_to_cool is not None:
            pulumi.set(__self__, "tier_to_cool", tier_to_cool)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input['DateAfterModificationArgs']]:
        """
        The function to delete the blob
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input['DateAfterModificationArgs']]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter(name="tierToArchive")
    def tier_to_archive(self) -> Optional[pulumi.Input['DateAfterModificationArgs']]:
        """
        The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
        """
        return pulumi.get(self, "tier_to_archive")

    @tier_to_archive.setter
    def tier_to_archive(self, value: Optional[pulumi.Input['DateAfterModificationArgs']]):
        pulumi.set(self, "tier_to_archive", value)

    @property
    @pulumi.getter(name="tierToCool")
    def tier_to_cool(self) -> Optional[pulumi.Input['DateAfterModificationArgs']]:
        """
        The function to tier blobs to cool storage. Support blobs currently at Hot tier
        """
        return pulumi.get(self, "tier_to_cool")

    @tier_to_cool.setter
    def tier_to_cool(self, value: Optional[pulumi.Input['DateAfterModificationArgs']]):
        pulumi.set(self, "tier_to_cool", value)


@pulumi.input_type
class ManagementPolicyDefinitionArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input['ManagementPolicyActionArgs'],
                 filters: Optional[pulumi.Input['ManagementPolicyFilterArgs']] = None):
        """
        An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.
        :param pulumi.Input['ManagementPolicyActionArgs'] actions: An object that defines the action set.
        :param pulumi.Input['ManagementPolicyFilterArgs'] filters: An object that defines the filter set.
        """
        pulumi.set(__self__, "actions", actions)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input['ManagementPolicyActionArgs']:
        """
        An object that defines the action set.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input['ManagementPolicyActionArgs']):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['ManagementPolicyFilterArgs']]:
        """
        An object that defines the filter set.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['ManagementPolicyFilterArgs']]):
        pulumi.set(self, "filters", value)


@pulumi.input_type
class ManagementPolicyFilterArgs:
    def __init__(__self__, *,
                 blob_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 prefix_match: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters. 
        :param pulumi.Input[Sequence[pulumi.Input[str]]] blob_types: An array of predefined enum values. Only blockBlob is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prefix_match: An array of strings for prefixes to be match.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)

    @property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        An array of predefined enum values. Only blockBlob is supported.
        """
        return pulumi.get(self, "blob_types")

    @blob_types.setter
    def blob_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "blob_types", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings for prefixes to be match.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prefix_match", value)


@pulumi.input_type
class ManagementPolicyRuleArgs:
    def __init__(__self__, *,
                 definition: pulumi.Input['ManagementPolicyDefinitionArgs'],
                 name: pulumi.Input[str],
                 type: pulumi.Input[Union[str, 'RuleType']],
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
        :param pulumi.Input['ManagementPolicyDefinitionArgs'] definition: An object that defines the Lifecycle rule.
        :param pulumi.Input[str] name: A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        :param pulumi.Input[Union[str, 'RuleType']] type: The valid value is Lifecycle
        :param pulumi.Input[bool] enabled: Rule is enabled if set to true.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input['ManagementPolicyDefinitionArgs']:
        """
        An object that defines the Lifecycle rule.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input['ManagementPolicyDefinitionArgs']):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'RuleType']]:
        """
        The valid value is Lifecycle
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'RuleType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Rule is enabled if set to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagementPolicySchemaArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]):
        """
        The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        :param pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]] rules: The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]:
        """
        The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ManagementPolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ManagementPolicySnapShotArgs:
    def __init__(__self__, *,
                 delete: Optional[pulumi.Input['DateAfterCreationArgs']] = None):
        """
        Management policy action for snapshot.
        :param pulumi.Input['DateAfterCreationArgs'] delete: The function to delete the blob snapshot
        """
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input['DateAfterCreationArgs']]:
        """
        The function to delete the blob snapshot
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input['DateAfterCreationArgs']]):
        pulumi.set(self, "delete", value)


@pulumi.input_type
class NetworkRuleSetArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input['DefaultAction'],
                 bypass: Optional[pulumi.Input[Union[str, 'Bypass']]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]] = None):
        """
        Network rule set
        :param pulumi.Input['DefaultAction'] default_action: Specifies the default action of allow or deny when no other rules match.
        :param pulumi.Input[Union[str, 'Bypass']] bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        :param pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]] ip_rules: Sets the IP ACL rules
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]] virtual_network_rules: Sets the virtual network rules
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if bypass is None:
            bypass = 'AzureServices'
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input['DefaultAction']:
        """
        Specifies the default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input['DefaultAction']):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter
    def bypass(self) -> Optional[pulumi.Input[Union[str, 'Bypass']]]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        """
        return pulumi.get(self, "bypass")

    @bypass.setter
    def bypass(self, value: Optional[pulumi.Input[Union[str, 'Bypass']]]):
        pulumi.set(self, "bypass", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]:
        """
        Sets the IP ACL rules
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]:
        """
        Sets the virtual network rules
        """
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


@pulumi.input_type
class RestrictionArgs:
    def __init__(__self__, *,
                 reason_code: Optional[pulumi.Input[Union[str, 'ReasonCode']]] = None):
        """
        The restriction because of which SKU cannot be used.
        :param pulumi.Input[Union[str, 'ReasonCode']] reason_code: The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
        """
        if reason_code is not None:
            pulumi.set(__self__, "reason_code", reason_code)

    @property
    @pulumi.getter(name="reasonCode")
    def reason_code(self) -> Optional[pulumi.Input[Union[str, 'ReasonCode']]]:
        """
        The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
        """
        return pulumi.get(self, "reason_code")

    @reason_code.setter
    def reason_code(self, value: Optional[pulumi.Input[Union[str, 'ReasonCode']]]):
        pulumi.set(self, "reason_code", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']],
                 restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionArgs']]]] = None):
        """
        The SKU of the storage account.
        :param pulumi.Input[Union[str, 'SkuName']] name: Gets or sets the SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        :param pulumi.Input[Sequence[pulumi.Input['RestrictionArgs']]] restrictions: The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
        """
        pulumi.set(__self__, "name", name)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        Gets or sets the SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionArgs']]]]:
        """
        The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
        """
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RestrictionArgs']]]]):
        pulumi.set(self, "restrictions", value)


@pulumi.input_type
class VirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 virtual_network_resource_id: pulumi.Input[str],
                 action: Optional[pulumi.Input['Action']] = None,
                 state: Optional[pulumi.Input['State']] = None):
        """
        Virtual Network rule.
        :param pulumi.Input[str] virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param pulumi.Input['Action'] action: The action of virtual network rule.
        :param pulumi.Input['State'] state: Gets the state of virtual network rule.
        """
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> pulumi.Input[str]:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @virtual_network_resource_id.setter
    def virtual_network_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_network_resource_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['Action']]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['Action']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['State']]:
        """
        Gets the state of virtual network rule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['State']]):
        pulumi.set(self, "state", value)


