# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DatabaseVulnerabilityAssessmentRuleBaselineItemResponse',
    'JobScheduleResponse',
    'JobStepActionResponse',
    'JobStepExecutionOptionsResponse',
    'JobStepOutputResponse',
    'JobTargetResponse',
    'SkuResponse',
    'VulnerabilityAssessmentRecurringScansPropertiesResponse',
]

@pulumi.output_type
class DatabaseVulnerabilityAssessmentRuleBaselineItemResponse(dict):
    """
    Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
    """
    def __init__(__self__, *,
                 result: Sequence[str]):
        """
        Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.
        :param Sequence[str] result: The rule baseline result
        """
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def result(self) -> Sequence[str]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class JobScheduleResponse(dict):
    """
    Scheduling properties of a job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 end_time: Optional[str] = None,
                 interval: Optional[str] = None,
                 start_time: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Scheduling properties of a job.
        :param bool enabled: Whether or not the schedule is enabled.
        :param str end_time: Schedule end time.
        :param str interval: Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format.
        :param str start_time: Schedule start time.
        :param str type: Schedule interval type
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if end_time is None:
            end_time = '9999-12-31T11:59:59Z'
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if start_time is None:
            start_time = '0001-01-01T00:00:00Z'
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if type is None:
            type = 'Once'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether or not the schedule is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Schedule end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def interval(self) -> Optional[str]:
        """
        Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Schedule start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Schedule interval type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobStepActionResponse(dict):
    """
    The action to be executed by a job step.
    """
    def __init__(__self__, *,
                 value: str,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The action to be executed by a job step.
        :param str value: The action value, for example the text of the T-SQL script to execute.
        :param str source: The source of the action to execute.
        :param str type: Type of action being executed by the job step.
        """
        pulumi.set(__self__, "value", value)
        if source is None:
            source = 'Inline'
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is None:
            type = 'TSql'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The action value, for example the text of the T-SQL script to execute.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        The source of the action to execute.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of action being executed by the job step.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobStepExecutionOptionsResponse(dict):
    """
    The execution options of a job step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialRetryIntervalSeconds":
            suggest = "initial_retry_interval_seconds"
        elif key == "maximumRetryIntervalSeconds":
            suggest = "maximum_retry_interval_seconds"
        elif key == "retryAttempts":
            suggest = "retry_attempts"
        elif key == "retryIntervalBackoffMultiplier":
            suggest = "retry_interval_backoff_multiplier"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStepExecutionOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStepExecutionOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStepExecutionOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_retry_interval_seconds: Optional[int] = None,
                 maximum_retry_interval_seconds: Optional[int] = None,
                 retry_attempts: Optional[int] = None,
                 retry_interval_backoff_multiplier: Optional[float] = None,
                 timeout_seconds: Optional[int] = None):
        """
        The execution options of a job step.
        :param int initial_retry_interval_seconds: Initial delay between retries for job step execution.
        :param int maximum_retry_interval_seconds: The maximum amount of time to wait between retries for job step execution.
        :param int retry_attempts: Maximum number of times the job step will be reattempted if the first attempt fails.
        :param float retry_interval_backoff_multiplier: The backoff multiplier for the time between retries.
        :param int timeout_seconds: Execution timeout for the job step.
        """
        if initial_retry_interval_seconds is None:
            initial_retry_interval_seconds = 1
        if initial_retry_interval_seconds is not None:
            pulumi.set(__self__, "initial_retry_interval_seconds", initial_retry_interval_seconds)
        if maximum_retry_interval_seconds is None:
            maximum_retry_interval_seconds = 120
        if maximum_retry_interval_seconds is not None:
            pulumi.set(__self__, "maximum_retry_interval_seconds", maximum_retry_interval_seconds)
        if retry_attempts is None:
            retry_attempts = 10
        if retry_attempts is not None:
            pulumi.set(__self__, "retry_attempts", retry_attempts)
        if retry_interval_backoff_multiplier is None:
            retry_interval_backoff_multiplier = 2
        if retry_interval_backoff_multiplier is not None:
            pulumi.set(__self__, "retry_interval_backoff_multiplier", retry_interval_backoff_multiplier)
        if timeout_seconds is None:
            timeout_seconds = 43200
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="initialRetryIntervalSeconds")
    def initial_retry_interval_seconds(self) -> Optional[int]:
        """
        Initial delay between retries for job step execution.
        """
        return pulumi.get(self, "initial_retry_interval_seconds")

    @property
    @pulumi.getter(name="maximumRetryIntervalSeconds")
    def maximum_retry_interval_seconds(self) -> Optional[int]:
        """
        The maximum amount of time to wait between retries for job step execution.
        """
        return pulumi.get(self, "maximum_retry_interval_seconds")

    @property
    @pulumi.getter(name="retryAttempts")
    def retry_attempts(self) -> Optional[int]:
        """
        Maximum number of times the job step will be reattempted if the first attempt fails.
        """
        return pulumi.get(self, "retry_attempts")

    @property
    @pulumi.getter(name="retryIntervalBackoffMultiplier")
    def retry_interval_backoff_multiplier(self) -> Optional[float]:
        """
        The backoff multiplier for the time between retries.
        """
        return pulumi.get(self, "retry_interval_backoff_multiplier")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Execution timeout for the job step.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class JobStepOutputResponse(dict):
    """
    The output configuration of a job step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "schemaName":
            suggest = "schema_name"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStepOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStepOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStepOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential: str,
                 database_name: str,
                 server_name: str,
                 table_name: str,
                 resource_group_name: Optional[str] = None,
                 schema_name: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The output configuration of a job step.
        :param str credential: The resource ID of the credential to use to connect to the output destination.
        :param str database_name: The output destination database.
        :param str server_name: The output destination server name.
        :param str table_name: The output destination table.
        :param str resource_group_name: The output destination resource group.
        :param str schema_name: The output destination schema.
        :param str subscription_id: The output destination subscription id.
        :param str type: The output destination type.
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "table_name", table_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if schema_name is None:
            schema_name = 'dbo'
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if type is None:
            type = 'SqlDatabase'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def credential(self) -> str:
        """
        The resource ID of the credential to use to connect to the output destination.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The output destination database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        The output destination server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The output destination table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[str]:
        """
        The output destination resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        The output destination schema.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The output destination subscription id.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The output destination type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobTargetResponse(dict):
    """
    A job target, for example a specific database or a container of databases that is evaluated during job execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "elasticPoolName":
            suggest = "elastic_pool_name"
        elif key == "membershipType":
            suggest = "membership_type"
        elif key == "refreshCredential":
            suggest = "refresh_credential"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "shardMapName":
            suggest = "shard_map_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 database_name: Optional[str] = None,
                 elastic_pool_name: Optional[str] = None,
                 membership_type: Optional[str] = None,
                 refresh_credential: Optional[str] = None,
                 server_name: Optional[str] = None,
                 shard_map_name: Optional[str] = None):
        """
        A job target, for example a specific database or a container of databases that is evaluated during job execution.
        :param str type: The target type.
        :param str database_name: The target database name.
        :param str elastic_pool_name: The target elastic pool name.
        :param str membership_type: Whether the target is included or excluded from the group.
        :param str refresh_credential: The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
        :param str server_name: The target server name.
        :param str shard_map_name: The target shard map.
        """
        pulumi.set(__self__, "type", type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if elastic_pool_name is not None:
            pulumi.set(__self__, "elastic_pool_name", elastic_pool_name)
        if membership_type is None:
            membership_type = 'Include'
        if membership_type is not None:
            pulumi.set(__self__, "membership_type", membership_type)
        if refresh_credential is not None:
            pulumi.set(__self__, "refresh_credential", refresh_credential)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if shard_map_name is not None:
            pulumi.set(__self__, "shard_map_name", shard_map_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The target type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        The target database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="elasticPoolName")
    def elastic_pool_name(self) -> Optional[str]:
        """
        The target elastic pool name.
        """
        return pulumi.get(self, "elastic_pool_name")

    @property
    @pulumi.getter(name="membershipType")
    def membership_type(self) -> Optional[str]:
        """
        Whether the target is included or excluded from the group.
        """
        return pulumi.get(self, "membership_type")

    @property
    @pulumi.getter(name="refreshCredential")
    def refresh_credential(self) -> Optional[str]:
        """
        The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
        """
        return pulumi.get(self, "refresh_credential")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        The target server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="shardMapName")
    def shard_map_name(self) -> Optional[str]:
        """
        The target shard map.
        """
        return pulumi.get(self, "shard_map_name")


@pulumi.output_type
class SkuResponse(dict):
    """
    An ARM Resource SKU.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        An ARM Resource SKU.
        :param str name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param int capacity: Capacity of the particular SKU.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: Size of the particular SKU
        :param str tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity of the particular SKU.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Size of the particular SKU
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class VulnerabilityAssessmentRecurringScansPropertiesResponse(dict):
    """
    Properties of a Vulnerability Assessment recurring scans.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSubscriptionAdmins":
            suggest = "email_subscription_admins"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAssessmentRecurringScansPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAssessmentRecurringScansPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_subscription_admins: Optional[bool] = None,
                 emails: Optional[Sequence[str]] = None,
                 is_enabled: Optional[bool] = None):
        """
        Properties of a Vulnerability Assessment recurring scans.
        :param bool email_subscription_admins: Specifies that the schedule scan notification will be is sent to the subscription administrators.
        :param Sequence[str] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param bool is_enabled: Recurring scans state.
        """
        if email_subscription_admins is None:
            email_subscription_admins = True
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[bool]:
        """
        Specifies that the schedule scan notification will be is sent to the subscription administrators.
        """
        return pulumi.get(self, "email_subscription_admins")

    @property
    @pulumi.getter
    def emails(self) -> Optional[Sequence[str]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Recurring scans state.
        """
        return pulumi.get(self, "is_enabled")


