# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AzureBackupServerContainerResponse',
    'AzureIaaSClassicComputeVMContainerResponse',
    'AzureIaaSComputeVMContainerResponse',
    'AzureSQLAGWorkloadContainerProtectionContainerResponse',
    'AzureSqlContainerResponse',
    'AzureStorageContainerResponse',
    'AzureVMAppContainerProtectionContainerResponse',
    'AzureWorkloadContainerExtendedInfoResponse',
    'AzureWorkloadContainerResponse',
    'ContainerIdentityInfoResponse',
    'DPMContainerExtendedInfoResponse',
    'DistributedNodesInfoResponse',
    'DpmContainerResponse',
    'ErrorDetailResponse',
    'GenericContainerExtendedInfoResponse',
    'GenericContainerResponse',
    'IaaSVMContainerResponse',
    'InquiryInfoResponse',
    'InquiryValidationResponse',
    'MABContainerHealthDetailsResponse',
    'MabContainerExtendedInfoResponse',
    'MabContainerResponse',
    'WorkloadInquiryDetailsResponse',
]

@pulumi.output_type
class AzureBackupServerContainerResponse(dict):
    """
    AzureBackupServer (DPMVenus) workload-specific protection container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "canReRegister":
            suggest = "can_re_register"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "dpmAgentVersion":
            suggest = "dpm_agent_version"
        elif key == "dpmServers":
            suggest = "dpm_servers"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "upgradeAvailable":
            suggest = "upgrade_available"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBackupServerContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBackupServerContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBackupServerContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 can_re_register: Optional[bool] = None,
                 container_id: Optional[str] = None,
                 container_type: Optional[str] = None,
                 dpm_agent_version: Optional[str] = None,
                 dpm_servers: Optional[Sequence[str]] = None,
                 extended_info: Optional['outputs.DPMContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protected_item_count: Optional[float] = None,
                 protection_status: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 upgrade_available: Optional[bool] = None):
        """
        AzureBackupServer (DPMVenus) workload-specific protection container.
        :param str backup_management_type: Type of backup management for the container.
        :param bool can_re_register: Specifies whether the container is re-registrable.
        :param str container_id: ID of container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureBackupServerContainer'.
        :param str dpm_agent_version: Backup engine Agent version
        :param Sequence[str] dpm_servers: List of BackupEngines protecting the container
        :param 'DPMContainerExtendedInfoResponse' extended_info: Extended Info of the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param float protected_item_count: Number of protected items in the BackupEngine
        :param str protection_status: Protection status of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param bool upgrade_available: To check if upgrade available
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'AzureBackupServerContainer')
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[bool]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[str]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureBackupServerContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[str]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[Sequence[str]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.DPMContainerExtendedInfoResponse']:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[bool]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")


@pulumi.output_type
class AzureIaaSClassicComputeVMContainerResponse(dict):
    """
    IaaS VM workload-specific backup item representing a classic virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "virtualMachineVersion":
            suggest = "virtual_machine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSClassicComputeVMContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSClassicComputeVMContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSClassicComputeVMContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 virtual_machine_version: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing a classic virtual machine.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param str virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'Microsoft.ClassicCompute/virtualMachines')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[str]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")


@pulumi.output_type
class AzureIaaSComputeVMContainerResponse(dict):
    """
    IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "virtualMachineVersion":
            suggest = "virtual_machine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureIaaSComputeVMContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureIaaSComputeVMContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureIaaSComputeVMContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 virtual_machine_version: Optional[str] = None):
        """
        IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param str virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'Microsoft.Compute/virtualMachines')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[str]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")


@pulumi.output_type
class AzureSQLAGWorkloadContainerProtectionContainerResponse(dict):
    """
    Container for SQL workloads under SQL Availability Group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "operationType":
            suggest = "operation_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSQLAGWorkloadContainerProtectionContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSQLAGWorkloadContainerProtectionContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSQLAGWorkloadContainerProtectionContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 extended_info: Optional['outputs.AzureWorkloadContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 last_updated_time: Optional[str] = None,
                 operation_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Container for SQL workloads under SQL Availability Group.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'SQLAGWorkLoadContainer'.
        :param 'AzureWorkloadContainerExtendedInfoResponse' extended_info: Additional details of a workload container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str last_updated_time: Time stamp when this container was updated.
        :param str operation_type: Re-Do Operation
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param str workload_type: Workload type for which registration was sent.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'SQLAGWorkLoadContainer')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'SQLAGWorkLoadContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureWorkloadContainerExtendedInfoResponse']:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[str]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureSqlContainerResponse(dict):
    """
    Azure Sql workload-specific container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "registrationStatus":
            suggest = "registration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 registration_status: Optional[str] = None):
        """
        Azure Sql workload-specific container.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureSqlContainer'.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'AzureSqlContainer')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureSqlContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")


@pulumi.output_type
class AzureStorageContainerResponse(dict):
    """
    Azure Storage Account workload-specific container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "storageAccountVersion":
            suggest = "storage_account_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureStorageContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureStorageContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureStorageContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protected_item_count: Optional[float] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 storage_account_version: Optional[str] = None):
        """
        Azure Storage Account workload-specific container.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'StorageContainer'.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param float protected_item_count: Number of items backed up in this container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str source_resource_id: Fully qualified ARM url.
        :param str storage_account_version: Storage account version.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'StorageContainer')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if storage_account_version is not None:
            pulumi.set(__self__, "storage_account_version", storage_account_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'StorageContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        Fully qualified ARM url.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="storageAccountVersion")
    def storage_account_version(self) -> Optional[str]:
        """
        Storage account version.
        """
        return pulumi.get(self, "storage_account_version")


@pulumi.output_type
class AzureVMAppContainerProtectionContainerResponse(dict):
    """
    Container for SQL workloads under Azure Virtual Machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "operationType":
            suggest = "operation_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureVMAppContainerProtectionContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureVMAppContainerProtectionContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureVMAppContainerProtectionContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 extended_info: Optional['outputs.AzureWorkloadContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 last_updated_time: Optional[str] = None,
                 operation_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Container for SQL workloads under Azure Virtual Machines.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'VMAppContainer'.
        :param 'AzureWorkloadContainerExtendedInfoResponse' extended_info: Additional details of a workload container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str last_updated_time: Time stamp when this container was updated.
        :param str operation_type: Re-Do Operation
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param str workload_type: Workload type for which registration was sent.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'VMAppContainer')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'VMAppContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureWorkloadContainerExtendedInfoResponse']:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[str]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class AzureWorkloadContainerExtendedInfoResponse(dict):
    """
    Extended information of the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostServerName":
            suggest = "host_server_name"
        elif key == "inquiryInfo":
            suggest = "inquiry_info"
        elif key == "nodesList":
            suggest = "nodes_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureWorkloadContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureWorkloadContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureWorkloadContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_server_name: Optional[str] = None,
                 inquiry_info: Optional['outputs.InquiryInfoResponse'] = None,
                 nodes_list: Optional[Sequence['outputs.DistributedNodesInfoResponse']] = None):
        """
        Extended information of the container.
        :param str host_server_name: Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        :param 'InquiryInfoResponse' inquiry_info: Inquiry Status for the container.
        :param Sequence['DistributedNodesInfoResponse'] nodes_list: List of the nodes in case of distributed container.
        """
        if host_server_name is not None:
            pulumi.set(__self__, "host_server_name", host_server_name)
        if inquiry_info is not None:
            pulumi.set(__self__, "inquiry_info", inquiry_info)
        if nodes_list is not None:
            pulumi.set(__self__, "nodes_list", nodes_list)

    @property
    @pulumi.getter(name="hostServerName")
    def host_server_name(self) -> Optional[str]:
        """
        Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        """
        return pulumi.get(self, "host_server_name")

    @property
    @pulumi.getter(name="inquiryInfo")
    def inquiry_info(self) -> Optional['outputs.InquiryInfoResponse']:
        """
        Inquiry Status for the container.
        """
        return pulumi.get(self, "inquiry_info")

    @property
    @pulumi.getter(name="nodesList")
    def nodes_list(self) -> Optional[Sequence['outputs.DistributedNodesInfoResponse']]:
        """
        List of the nodes in case of distributed container.
        """
        return pulumi.get(self, "nodes_list")


@pulumi.output_type
class AzureWorkloadContainerResponse(dict):
    """
    Container for the workloads running inside Azure Compute or Classic Compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "lastUpdatedTime":
            suggest = "last_updated_time"
        elif key == "operationType":
            suggest = "operation_type"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureWorkloadContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureWorkloadContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureWorkloadContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 extended_info: Optional['outputs.AzureWorkloadContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 last_updated_time: Optional[str] = None,
                 operation_type: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        Container for the workloads running inside Azure Compute or Classic Compute.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureWorkloadContainer'.
        :param 'AzureWorkloadContainerExtendedInfoResponse' extended_info: Additional details of a workload container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str last_updated_time: Time stamp when this container was updated.
        :param str operation_type: Re-Do Operation
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param str workload_type: Workload type for which registration was sent.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'AzureWorkloadContainer')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureWorkloadContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.AzureWorkloadContainerExtendedInfoResponse']:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[str]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class ContainerIdentityInfoResponse(dict):
    """
    Container identity information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadTenantId":
            suggest = "aad_tenant_id"
        elif key == "servicePrincipalClientId":
            suggest = "service_principal_client_id"
        elif key == "uniqueName":
            suggest = "unique_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerIdentityInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerIdentityInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerIdentityInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_tenant_id: Optional[str] = None,
                 audience: Optional[str] = None,
                 service_principal_client_id: Optional[str] = None,
                 unique_name: Optional[str] = None):
        """
        Container identity information
        :param str aad_tenant_id: Protection container identity - AAD Tenant
        :param str audience: Protection container identity - Audience
        :param str service_principal_client_id: Protection container identity - AAD Service Principal
        :param str unique_name: Unique name of the container
        """
        if aad_tenant_id is not None:
            pulumi.set(__self__, "aad_tenant_id", aad_tenant_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if service_principal_client_id is not None:
            pulumi.set(__self__, "service_principal_client_id", service_principal_client_id)
        if unique_name is not None:
            pulumi.set(__self__, "unique_name", unique_name)

    @property
    @pulumi.getter(name="aadTenantId")
    def aad_tenant_id(self) -> Optional[str]:
        """
        Protection container identity - AAD Tenant
        """
        return pulumi.get(self, "aad_tenant_id")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        Protection container identity - Audience
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="servicePrincipalClientId")
    def service_principal_client_id(self) -> Optional[str]:
        """
        Protection container identity - AAD Service Principal
        """
        return pulumi.get(self, "service_principal_client_id")

    @property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> Optional[str]:
        """
        Unique name of the container
        """
        return pulumi.get(self, "unique_name")


@pulumi.output_type
class DPMContainerExtendedInfoResponse(dict):
    """
    Additional information of the DPMContainer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRefreshedAt":
            suggest = "last_refreshed_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DPMContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DPMContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DPMContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_refreshed_at: Optional[str] = None):
        """
        Additional information of the DPMContainer.
        :param str last_refreshed_at: Last refresh time of the DPMContainer.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Last refresh time of the DPMContainer.
        """
        return pulumi.get(self, "last_refreshed_at")


@pulumi.output_type
class DistributedNodesInfoResponse(dict):
    """
    This is used to represent the various nodes of the distributed container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDetail":
            suggest = "error_detail"
        elif key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributedNodesInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributedNodesInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributedNodesInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 node_name: Optional[str] = None,
                 status: Optional[str] = None):
        """
        This is used to represent the various nodes of the distributed container.
        :param 'ErrorDetailResponse' error_detail: Error Details if the Status is non-success.
        :param str node_name: Name of the node under a distributed container.
        :param str status: Status of this Node.
               Failed | Succeeded
        """
        if error_detail is not None:
            pulumi.set(__self__, "error_detail", error_detail)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="errorDetail")
    def error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error Details if the Status is non-success.
        """
        return pulumi.get(self, "error_detail")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        Name of the node under a distributed container.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of this Node.
        Failed | Succeeded
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DpmContainerResponse(dict):
    """
    DPM workload-specific protection container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "canReRegister":
            suggest = "can_re_register"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "dpmAgentVersion":
            suggest = "dpm_agent_version"
        elif key == "dpmServers":
            suggest = "dpm_servers"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "upgradeAvailable":
            suggest = "upgrade_available"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DpmContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DpmContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DpmContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 can_re_register: Optional[bool] = None,
                 container_id: Optional[str] = None,
                 container_type: Optional[str] = None,
                 dpm_agent_version: Optional[str] = None,
                 dpm_servers: Optional[Sequence[str]] = None,
                 extended_info: Optional['outputs.DPMContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 protected_item_count: Optional[float] = None,
                 protection_status: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 upgrade_available: Optional[bool] = None):
        """
        DPM workload-specific protection container.
        :param str backup_management_type: Type of backup management for the container.
        :param bool can_re_register: Specifies whether the container is re-registrable.
        :param str container_id: ID of container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'DPMContainer'.
        :param str dpm_agent_version: Backup engine Agent version
        :param Sequence[str] dpm_servers: List of BackupEngines protecting the container
        :param 'DPMContainerExtendedInfoResponse' extended_info: Extended Info of the container.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param float protected_item_count: Number of protected items in the BackupEngine
        :param str protection_status: Protection status of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param bool upgrade_available: To check if upgrade available
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'DPMContainer')
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[bool]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[str]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'DPMContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[str]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[Sequence[str]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.DPMContainerExtendedInfoResponse']:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[str]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[bool]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    Error Detail class which encapsulates Code, Message and Recommendations.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 recommendations: Sequence[str]):
        """
        Error Detail class which encapsulates Code, Message and Recommendations.
        :param str code: Error code.
        :param str message: Error Message related to the Code.
        :param Sequence[str] recommendations: List of recommendation strings.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendations", recommendations)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error Message related to the Code.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Sequence[str]:
        """
        List of recommendation strings.
        """
        return pulumi.get(self, "recommendations")


@pulumi.output_type
class GenericContainerExtendedInfoResponse(dict):
    """
    Container extended information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerIdentityInfo":
            suggest = "container_identity_info"
        elif key == "rawCertData":
            suggest = "raw_cert_data"
        elif key == "serviceEndpoints":
            suggest = "service_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_identity_info: Optional['outputs.ContainerIdentityInfoResponse'] = None,
                 raw_cert_data: Optional[str] = None,
                 service_endpoints: Optional[Mapping[str, str]] = None):
        """
        Container extended information
        :param 'ContainerIdentityInfoResponse' container_identity_info: Container identity information
        :param str raw_cert_data: Public key of container cert
        :param Mapping[str, str] service_endpoints: Azure Backup Service Endpoints for the container
        """
        if container_identity_info is not None:
            pulumi.set(__self__, "container_identity_info", container_identity_info)
        if raw_cert_data is not None:
            pulumi.set(__self__, "raw_cert_data", raw_cert_data)
        if service_endpoints is not None:
            pulumi.set(__self__, "service_endpoints", service_endpoints)

    @property
    @pulumi.getter(name="containerIdentityInfo")
    def container_identity_info(self) -> Optional['outputs.ContainerIdentityInfoResponse']:
        """
        Container identity information
        """
        return pulumi.get(self, "container_identity_info")

    @property
    @pulumi.getter(name="rawCertData")
    def raw_cert_data(self) -> Optional[str]:
        """
        Public key of container cert
        """
        return pulumi.get(self, "raw_cert_data")

    @property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Optional[Mapping[str, str]]:
        """
        Azure Backup Service Endpoints for the container
        """
        return pulumi.get(self, "service_endpoints")


@pulumi.output_type
class GenericContainerResponse(dict):
    """
    Base class for generic container of backup items
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "extendedInformation":
            suggest = "extended_information"
        elif key == "fabricName":
            suggest = "fabric_name"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "registrationStatus":
            suggest = "registration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GenericContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GenericContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GenericContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 extended_information: Optional['outputs.GenericContainerExtendedInfoResponse'] = None,
                 fabric_name: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 registration_status: Optional[str] = None):
        """
        Base class for generic container of backup items
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'GenericContainer'.
        :param 'GenericContainerExtendedInfoResponse' extended_information: Extended information (not returned in List container API calls)
        :param str fabric_name: Name of the container's fabric
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'GenericContainer')
        if extended_information is not None:
            pulumi.set(__self__, "extended_information", extended_information)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'GenericContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="extendedInformation")
    def extended_information(self) -> Optional['outputs.GenericContainerExtendedInfoResponse']:
        """
        Extended information (not returned in List container API calls)
        """
        return pulumi.get(self, "extended_information")

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[str]:
        """
        Name of the container's fabric
        """
        return pulumi.get(self, "fabric_name")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")


@pulumi.output_type
class IaaSVMContainerResponse(dict):
    """
    IaaS VM workload-specific container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "registrationStatus":
            suggest = "registration_status"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"
        elif key == "virtualMachineVersion":
            suggest = "virtual_machine_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IaaSVMContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IaaSVMContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IaaSVMContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_management_type: Optional[str] = None,
                 container_type: Optional[str] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 registration_status: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 virtual_machine_id: Optional[str] = None,
                 virtual_machine_version: Optional[str] = None):
        """
        IaaS VM workload-specific container.
        :param str backup_management_type: Type of backup management for the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'IaaSVMContainer'.
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        :param str resource_group: Resource group name of Recovery Services Vault.
        :param str virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param str virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'IaaSVMContainer')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'IaaSVMContainer'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[str]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[str]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")


@pulumi.output_type
class InquiryInfoResponse(dict):
    """
    Details about inquired protectable items under a given container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDetail":
            suggest = "error_detail"
        elif key == "inquiryDetails":
            suggest = "inquiry_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InquiryInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InquiryInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InquiryInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 inquiry_details: Optional[Sequence['outputs.WorkloadInquiryDetailsResponse']] = None,
                 status: Optional[str] = None):
        """
        Details about inquired protectable items under a given container.
        :param 'ErrorDetailResponse' error_detail: Error Details if the Status is non-success.
        :param Sequence['WorkloadInquiryDetailsResponse'] inquiry_details: Inquiry Details which will have workload specific details.
               For e.g. - For SQL and oracle this will contain different details.
        :param str status: Inquiry Status for this container such as
               InProgress | Failed | Succeeded
        """
        if error_detail is not None:
            pulumi.set(__self__, "error_detail", error_detail)
        if inquiry_details is not None:
            pulumi.set(__self__, "inquiry_details", inquiry_details)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="errorDetail")
    def error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error Details if the Status is non-success.
        """
        return pulumi.get(self, "error_detail")

    @property
    @pulumi.getter(name="inquiryDetails")
    def inquiry_details(self) -> Optional[Sequence['outputs.WorkloadInquiryDetailsResponse']]:
        """
        Inquiry Details which will have workload specific details.
        For e.g. - For SQL and oracle this will contain different details.
        """
        return pulumi.get(self, "inquiry_details")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Inquiry Status for this container such as
        InProgress | Failed | Succeeded
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InquiryValidationResponse(dict):
    """
    Validation for inquired protectable items under a given container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalDetail":
            suggest = "additional_detail"
        elif key == "errorDetail":
            suggest = "error_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InquiryValidationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InquiryValidationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InquiryValidationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_detail: str,
                 error_detail: Optional['outputs.ErrorDetailResponse'] = None,
                 status: Optional[str] = None):
        """
        Validation for inquired protectable items under a given container.
        :param str additional_detail: Error Additional Detail in case the status is non-success.
        :param 'ErrorDetailResponse' error_detail: Error Detail in case the status is non-success.
        :param str status: Status for the Inquiry Validation.
        """
        pulumi.set(__self__, "additional_detail", additional_detail)
        if error_detail is not None:
            pulumi.set(__self__, "error_detail", error_detail)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="additionalDetail")
    def additional_detail(self) -> str:
        """
        Error Additional Detail in case the status is non-success.
        """
        return pulumi.get(self, "additional_detail")

    @property
    @pulumi.getter(name="errorDetail")
    def error_detail(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        Error Detail in case the status is non-success.
        """
        return pulumi.get(self, "error_detail")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status for the Inquiry Validation.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class MABContainerHealthDetailsResponse(dict):
    """
    MAB workload-specific Health Details.
    """
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 message: Optional[str] = None,
                 recommendations: Optional[Sequence[str]] = None,
                 title: Optional[str] = None):
        """
        MAB workload-specific Health Details.
        :param int code: Health Code
        :param str message: Health Message
        :param Sequence[str] recommendations: Health Recommended Actions
        :param str title: Health Title
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if recommendations is not None:
            pulumi.set(__self__, "recommendations", recommendations)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        Health Code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Health Message
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendations(self) -> Optional[Sequence[str]]:
        """
        Health Recommended Actions
        """
        return pulumi.get(self, "recommendations")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Health Title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class MabContainerExtendedInfoResponse(dict):
    """
    Additional information of the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupItemType":
            suggest = "backup_item_type"
        elif key == "backupItems":
            suggest = "backup_items"
        elif key == "lastBackupStatus":
            suggest = "last_backup_status"
        elif key == "lastRefreshedAt":
            suggest = "last_refreshed_at"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabContainerExtendedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabContainerExtendedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabContainerExtendedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_item_type: Optional[str] = None,
                 backup_items: Optional[Sequence[str]] = None,
                 last_backup_status: Optional[str] = None,
                 last_refreshed_at: Optional[str] = None,
                 policy_name: Optional[str] = None):
        """
        Additional information of the container.
        :param str backup_item_type: Type of backup items associated with this container.
        :param Sequence[str] backup_items: List of backup items associated with this container.
        :param str last_backup_status: Latest backup status of this container.
        :param str last_refreshed_at: Time stamp when this container was refreshed.
        :param str policy_name: Backup policy associated with this container.
        """
        if backup_item_type is not None:
            pulumi.set(__self__, "backup_item_type", backup_item_type)
        if backup_items is not None:
            pulumi.set(__self__, "backup_items", backup_items)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="backupItemType")
    def backup_item_type(self) -> Optional[str]:
        """
        Type of backup items associated with this container.
        """
        return pulumi.get(self, "backup_item_type")

    @property
    @pulumi.getter(name="backupItems")
    def backup_items(self) -> Optional[Sequence[str]]:
        """
        List of backup items associated with this container.
        """
        return pulumi.get(self, "backup_items")

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[str]:
        """
        Latest backup status of this container.
        """
        return pulumi.get(self, "last_backup_status")

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[str]:
        """
        Time stamp when this container was refreshed.
        """
        return pulumi.get(self, "last_refreshed_at")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Backup policy associated with this container.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class MabContainerResponse(dict):
    """
    Container with items backed up using MAB backup engine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentVersion":
            suggest = "agent_version"
        elif key == "backupManagementType":
            suggest = "backup_management_type"
        elif key == "canReRegister":
            suggest = "can_re_register"
        elif key == "containerHealthState":
            suggest = "container_health_state"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "containerType":
            suggest = "container_type"
        elif key == "extendedInfo":
            suggest = "extended_info"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "healthStatus":
            suggest = "health_status"
        elif key == "mabContainerHealthDetails":
            suggest = "mab_container_health_details"
        elif key == "protectedItemCount":
            suggest = "protected_item_count"
        elif key == "registrationStatus":
            suggest = "registration_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MabContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MabContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MabContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_version: Optional[str] = None,
                 backup_management_type: Optional[str] = None,
                 can_re_register: Optional[bool] = None,
                 container_health_state: Optional[str] = None,
                 container_id: Optional[float] = None,
                 container_type: Optional[str] = None,
                 extended_info: Optional['outputs.MabContainerExtendedInfoResponse'] = None,
                 friendly_name: Optional[str] = None,
                 health_status: Optional[str] = None,
                 mab_container_health_details: Optional[Sequence['outputs.MABContainerHealthDetailsResponse']] = None,
                 protected_item_count: Optional[float] = None,
                 registration_status: Optional[str] = None):
        """
        Container with items backed up using MAB backup engine.
        :param str agent_version: Agent version of this container.
        :param str backup_management_type: Type of backup management for the container.
        :param bool can_re_register: Can the container be registered one more time.
        :param str container_health_state: Health state of mab container.
        :param float container_id: ContainerID represents the container.
        :param str container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Windows'.
        :param 'MabContainerExtendedInfoResponse' extended_info: Additional information for this container
        :param str friendly_name: Friendly name of the container.
        :param str health_status: Status of health of the container.
        :param Sequence['MABContainerHealthDetailsResponse'] mab_container_health_details: Health details on this mab container.
        :param float protected_item_count: Number of items backed up in this container.
        :param str registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_health_state is not None:
            pulumi.set(__self__, "container_health_state", container_health_state)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'Windows')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if mab_container_health_details is not None:
            pulumi.set(__self__, "mab_container_health_details", mab_container_health_details)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[str]:
        """
        Agent version of this container.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[str]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[bool]:
        """
        Can the container be registered one more time.
        """
        return pulumi.get(self, "can_re_register")

    @property
    @pulumi.getter(name="containerHealthState")
    def container_health_state(self) -> Optional[str]:
        """
        Health state of mab container.
        """
        return pulumi.get(self, "container_health_state")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[float]:
        """
        ContainerID represents the container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional['outputs.MabContainerExtendedInfoResponse']:
        """
        Additional information for this container
        """
        return pulumi.get(self, "extended_info")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter(name="mabContainerHealthDetails")
    def mab_container_health_details(self) -> Optional[Sequence['outputs.MABContainerHealthDetailsResponse']]:
        """
        Health details on this mab container.
        """
        return pulumi.get(self, "mab_container_health_details")

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[float]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[str]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")


@pulumi.output_type
class WorkloadInquiryDetailsResponse(dict):
    """
    Details of an inquired protectable item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inquiryValidation":
            suggest = "inquiry_validation"
        elif key == "itemCount":
            suggest = "item_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadInquiryDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadInquiryDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadInquiryDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inquiry_validation: Optional['outputs.InquiryValidationResponse'] = None,
                 item_count: Optional[float] = None,
                 type: Optional[str] = None):
        """
        Details of an inquired protectable item.
        :param 'InquiryValidationResponse' inquiry_validation: Inquiry validation such as permissions and other backup validations.
        :param float item_count: Contains the protectable item Count inside this Container.
        :param str type: Type of the Workload such as SQL, Oracle etc.
        """
        if inquiry_validation is not None:
            pulumi.set(__self__, "inquiry_validation", inquiry_validation)
        if item_count is not None:
            pulumi.set(__self__, "item_count", item_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inquiryValidation")
    def inquiry_validation(self) -> Optional['outputs.InquiryValidationResponse']:
        """
        Inquiry validation such as permissions and other backup validations.
        """
        return pulumi.get(self, "inquiry_validation")

    @property
    @pulumi.getter(name="itemCount")
    def item_count(self) -> Optional[float]:
        """
        Contains the protectable item Count inside this Container.
        """
        return pulumi.get(self, "item_count")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the Workload such as SQL, Oracle etc.
        """
        return pulumi.get(self, "type")


