# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AccountEncryptionArgs',
    'ActiveDirectoryArgs',
    'DailyScheduleArgs',
    'ExportPolicyRuleArgs',
    'HourlyScheduleArgs',
    'LdapSearchScopeOptArgs',
    'MonthlyScheduleArgs',
    'PlacementKeyValuePairsArgs',
    'ReplicationObjectArgs',
    'VolumeBackupPropertiesArgs',
    'VolumeGroupMetaDataArgs',
    'VolumeGroupVolumePropertiesArgs',
    'VolumePropertiesDataProtectionArgs',
    'VolumePropertiesExportPolicyArgs',
    'VolumeSnapshotPropertiesArgs',
    'WeeklyScheduleArgs',
]

@pulumi.input_type
class AccountEncryptionArgs:
    def __init__(__self__, *,
                 key_source: Optional[pulumi.Input[str]] = None):
        """
        Encryption settings
        :param pulumi.Input[str] key_source: Encryption Key Source. Possible values are: 'Microsoft.NetApp'.
        """
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption Key Source. Possible values are: 'Microsoft.NetApp'.
        """
        return pulumi.get(self, "key_source")

    @key_source.setter
    def key_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_source", value)


@pulumi.input_type
class ActiveDirectoryArgs:
    def __init__(__self__, *,
                 active_directory_id: Optional[pulumi.Input[str]] = None,
                 ad_name: Optional[pulumi.Input[str]] = None,
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aes_encryption: Optional[pulumi.Input[bool]] = None,
                 allow_local_nfs_users_with_ldap: Optional[pulumi.Input[bool]] = None,
                 backup_operators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 encrypt_dc_connections: Optional[pulumi.Input[bool]] = None,
                 kdc_ip: Optional[pulumi.Input[str]] = None,
                 ldap_over_tls: Optional[pulumi.Input[bool]] = None,
                 ldap_search_scope: Optional[pulumi.Input['LdapSearchScopeOptArgs']] = None,
                 ldap_signing: Optional[pulumi.Input[bool]] = None,
                 organizational_unit: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 security_operators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_root_ca_certificate: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 smb_server_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Active Directory
        :param pulumi.Input[str] active_directory_id: Id of the Active Directory
        :param pulumi.Input[str] ad_name: Name of the active directory machine. This optional parameter is used only while creating kerberos volume
        :param pulumi.Input[Sequence[pulumi.Input[str]]] administrators: Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
        :param pulumi.Input[bool] aes_encryption: If enabled, AES encryption will be enabled for SMB communication.
        :param pulumi.Input[bool] allow_local_nfs_users_with_ldap:  If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_operators: Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
        :param pulumi.Input[str] dns: Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
        :param pulumi.Input[str] domain: Name of the Active Directory domain
        :param pulumi.Input[bool] encrypt_dc_connections: If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted.
        :param pulumi.Input[str] kdc_ip: kdc server IP addresses for the active directory machine. This optional parameter is used only while creating kerberos volume.
        :param pulumi.Input[bool] ldap_over_tls: Specifies whether or not the LDAP traffic needs to be secured via TLS.
        :param pulumi.Input['LdapSearchScopeOptArgs'] ldap_search_scope: LDAP Search scope options
        :param pulumi.Input[bool] ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
        :param pulumi.Input[str] organizational_unit: The Organizational Unit (OU) within the Windows Active Directory
        :param pulumi.Input[str] password: Plain text password of Active Directory domain administrator, value is masked in the response
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_operators: Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames without domain specifier
        :param pulumi.Input[str] server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active Directory Certificate Service's self-signed root CA certificate, this optional parameter is used only for dual protocol with LDAP user-mapping volumes.
        :param pulumi.Input[str] site: The Active Directory site the service will limit Domain Controller discovery to
        :param pulumi.Input[str] smb_server_name: NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
        :param pulumi.Input[str] username: Username of Active Directory domain administrator
        """
        if active_directory_id is not None:
            pulumi.set(__self__, "active_directory_id", active_directory_id)
        if ad_name is not None:
            pulumi.set(__self__, "ad_name", ad_name)
        if administrators is not None:
            pulumi.set(__self__, "administrators", administrators)
        if aes_encryption is not None:
            pulumi.set(__self__, "aes_encryption", aes_encryption)
        if allow_local_nfs_users_with_ldap is not None:
            pulumi.set(__self__, "allow_local_nfs_users_with_ldap", allow_local_nfs_users_with_ldap)
        if backup_operators is not None:
            pulumi.set(__self__, "backup_operators", backup_operators)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if encrypt_dc_connections is not None:
            pulumi.set(__self__, "encrypt_dc_connections", encrypt_dc_connections)
        if kdc_ip is not None:
            pulumi.set(__self__, "kdc_ip", kdc_ip)
        if ldap_over_tls is not None:
            pulumi.set(__self__, "ldap_over_tls", ldap_over_tls)
        if ldap_search_scope is not None:
            pulumi.set(__self__, "ldap_search_scope", ldap_search_scope)
        if ldap_signing is not None:
            pulumi.set(__self__, "ldap_signing", ldap_signing)
        if organizational_unit is None:
            organizational_unit = 'CN=Computers'
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if security_operators is not None:
            pulumi.set(__self__, "security_operators", security_operators)
        if server_root_ca_certificate is not None:
            pulumi.set(__self__, "server_root_ca_certificate", server_root_ca_certificate)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if smb_server_name is not None:
            pulumi.set(__self__, "smb_server_name", smb_server_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="activeDirectoryId")
    def active_directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the Active Directory
        """
        return pulumi.get(self, "active_directory_id")

    @active_directory_id.setter
    def active_directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory_id", value)

    @property
    @pulumi.getter(name="adName")
    def ad_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the active directory machine. This optional parameter is used only while creating kerberos volume
        """
        return pulumi.get(self, "ad_name")

    @ad_name.setter
    def ad_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_name", value)

    @property
    @pulumi.getter
    def administrators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
        """
        return pulumi.get(self, "administrators")

    @administrators.setter
    def administrators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "administrators", value)

    @property
    @pulumi.getter(name="aesEncryption")
    def aes_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, AES encryption will be enabled for SMB communication.
        """
        return pulumi.get(self, "aes_encryption")

    @aes_encryption.setter
    def aes_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aes_encryption", value)

    @property
    @pulumi.getter(name="allowLocalNfsUsersWithLdap")
    def allow_local_nfs_users_with_ldap(self) -> Optional[pulumi.Input[bool]]:
        """
         If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes.
        """
        return pulumi.get(self, "allow_local_nfs_users_with_ldap")

    @allow_local_nfs_users_with_ldap.setter
    def allow_local_nfs_users_with_ldap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_local_nfs_users_with_ldap", value)

    @property
    @pulumi.getter(name="backupOperators")
    def backup_operators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
        """
        return pulumi.get(self, "backup_operators")

    @backup_operators.setter
    def backup_operators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_operators", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input[str]]:
        """
        Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Active Directory domain
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="encryptDCConnections")
    def encrypt_dc_connections(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted.
        """
        return pulumi.get(self, "encrypt_dc_connections")

    @encrypt_dc_connections.setter
    def encrypt_dc_connections(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_dc_connections", value)

    @property
    @pulumi.getter(name="kdcIP")
    def kdc_ip(self) -> Optional[pulumi.Input[str]]:
        """
        kdc server IP addresses for the active directory machine. This optional parameter is used only while creating kerberos volume.
        """
        return pulumi.get(self, "kdc_ip")

    @kdc_ip.setter
    def kdc_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kdc_ip", value)

    @property
    @pulumi.getter(name="ldapOverTLS")
    def ldap_over_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the LDAP traffic needs to be secured via TLS.
        """
        return pulumi.get(self, "ldap_over_tls")

    @ldap_over_tls.setter
    def ldap_over_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ldap_over_tls", value)

    @property
    @pulumi.getter(name="ldapSearchScope")
    def ldap_search_scope(self) -> Optional[pulumi.Input['LdapSearchScopeOptArgs']]:
        """
        LDAP Search scope options
        """
        return pulumi.get(self, "ldap_search_scope")

    @ldap_search_scope.setter
    def ldap_search_scope(self, value: Optional[pulumi.Input['LdapSearchScopeOptArgs']]):
        pulumi.set(self, "ldap_search_scope", value)

    @property
    @pulumi.getter(name="ldapSigning")
    def ldap_signing(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the LDAP traffic needs to be signed.
        """
        return pulumi.get(self, "ldap_signing")

    @ldap_signing.setter
    def ldap_signing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ldap_signing", value)

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The Organizational Unit (OU) within the Windows Active Directory
        """
        return pulumi.get(self, "organizational_unit")

    @organizational_unit.setter
    def organizational_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Plain text password of Active Directory domain administrator, value is masked in the response
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="securityOperators")
    def security_operators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames without domain specifier
        """
        return pulumi.get(self, "security_operators")

    @security_operators.setter
    def security_operators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_operators", value)

    @property
    @pulumi.getter(name="serverRootCACertificate")
    def server_root_ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active Directory Certificate Service's self-signed root CA certificate, this optional parameter is used only for dual protocol with LDAP user-mapping volumes.
        """
        return pulumi.get(self, "server_root_ca_certificate")

    @server_root_ca_certificate.setter
    def server_root_ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_root_ca_certificate", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The Active Directory site the service will limit Domain Controller discovery to
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="smbServerName")
    def smb_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
        """
        return pulumi.get(self, "smb_server_name")

    @smb_server_name.setter
    def smb_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smb_server_name", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of Active Directory domain administrator
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class DailyScheduleArgs:
    def __init__(__self__, *,
                 hour: Optional[pulumi.Input[int]] = None,
                 minute: Optional[pulumi.Input[int]] = None,
                 snapshots_to_keep: Optional[pulumi.Input[int]] = None,
                 used_bytes: Optional[pulumi.Input[float]] = None):
        """
        Daily Schedule properties
        :param pulumi.Input[int] hour: Indicates which hour in UTC timezone a snapshot should be taken
        :param pulumi.Input[int] minute: Indicates which minute snapshot should be taken
        :param pulumi.Input[int] snapshots_to_keep: Daily snapshot count to keep
        :param pulumi.Input[float] used_bytes: Resource size in bytes, current storage usage for the volume in bytes
        """
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)
        if snapshots_to_keep is not None:
            pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if used_bytes is not None:
            pulumi.set(__self__, "used_bytes", used_bytes)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates which hour in UTC timezone a snapshot should be taken
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates which minute snapshot should be taken
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> Optional[pulumi.Input[int]]:
        """
        Daily snapshot count to keep
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter(name="usedBytes")
    def used_bytes(self) -> Optional[pulumi.Input[float]]:
        """
        Resource size in bytes, current storage usage for the volume in bytes
        """
        return pulumi.get(self, "used_bytes")

    @used_bytes.setter
    def used_bytes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "used_bytes", value)


@pulumi.input_type
class ExportPolicyRuleArgs:
    def __init__(__self__, *,
                 allowed_clients: Optional[pulumi.Input[str]] = None,
                 chown_mode: Optional[pulumi.Input[Union[str, 'ChownMode']]] = None,
                 cifs: Optional[pulumi.Input[bool]] = None,
                 has_root_access: Optional[pulumi.Input[bool]] = None,
                 kerberos5_read_only: Optional[pulumi.Input[bool]] = None,
                 kerberos5_read_write: Optional[pulumi.Input[bool]] = None,
                 kerberos5i_read_only: Optional[pulumi.Input[bool]] = None,
                 kerberos5i_read_write: Optional[pulumi.Input[bool]] = None,
                 kerberos5p_read_only: Optional[pulumi.Input[bool]] = None,
                 kerberos5p_read_write: Optional[pulumi.Input[bool]] = None,
                 nfsv3: Optional[pulumi.Input[bool]] = None,
                 nfsv41: Optional[pulumi.Input[bool]] = None,
                 rule_index: Optional[pulumi.Input[int]] = None,
                 unix_read_only: Optional[pulumi.Input[bool]] = None,
                 unix_read_write: Optional[pulumi.Input[bool]] = None):
        """
        Volume Export Policy Rule
        :param pulumi.Input[str] allowed_clients: Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
        :param pulumi.Input[Union[str, 'ChownMode']] chown_mode: This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
        :param pulumi.Input[bool] cifs: Allows CIFS protocol
        :param pulumi.Input[bool] has_root_access: Has root access to volume
        :param pulumi.Input[bool] kerberos5_read_only: Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
        :param pulumi.Input[bool] kerberos5_read_write: Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
        :param pulumi.Input[bool] kerberos5i_read_only: Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
        :param pulumi.Input[bool] kerberos5i_read_write: Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
        :param pulumi.Input[bool] kerberos5p_read_only: Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
        :param pulumi.Input[bool] kerberos5p_read_write: Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
        :param pulumi.Input[bool] nfsv3: Allows NFSv3 protocol. Enable only for NFSv3 type volumes
        :param pulumi.Input[bool] nfsv41: Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
        :param pulumi.Input[int] rule_index: Order index
        :param pulumi.Input[bool] unix_read_only: Read only access
        :param pulumi.Input[bool] unix_read_write: Read and write access
        """
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if chown_mode is None:
            chown_mode = 'Restricted'
        if chown_mode is not None:
            pulumi.set(__self__, "chown_mode", chown_mode)
        if cifs is not None:
            pulumi.set(__self__, "cifs", cifs)
        if has_root_access is None:
            has_root_access = True
        if has_root_access is not None:
            pulumi.set(__self__, "has_root_access", has_root_access)
        if kerberos5_read_only is None:
            kerberos5_read_only = False
        if kerberos5_read_only is not None:
            pulumi.set(__self__, "kerberos5_read_only", kerberos5_read_only)
        if kerberos5_read_write is None:
            kerberos5_read_write = False
        if kerberos5_read_write is not None:
            pulumi.set(__self__, "kerberos5_read_write", kerberos5_read_write)
        if kerberos5i_read_only is None:
            kerberos5i_read_only = False
        if kerberos5i_read_only is not None:
            pulumi.set(__self__, "kerberos5i_read_only", kerberos5i_read_only)
        if kerberos5i_read_write is None:
            kerberos5i_read_write = False
        if kerberos5i_read_write is not None:
            pulumi.set(__self__, "kerberos5i_read_write", kerberos5i_read_write)
        if kerberos5p_read_only is None:
            kerberos5p_read_only = False
        if kerberos5p_read_only is not None:
            pulumi.set(__self__, "kerberos5p_read_only", kerberos5p_read_only)
        if kerberos5p_read_write is None:
            kerberos5p_read_write = False
        if kerberos5p_read_write is not None:
            pulumi.set(__self__, "kerberos5p_read_write", kerberos5p_read_write)
        if nfsv3 is not None:
            pulumi.set(__self__, "nfsv3", nfsv3)
        if nfsv41 is not None:
            pulumi.set(__self__, "nfsv41", nfsv41)
        if rule_index is not None:
            pulumi.set(__self__, "rule_index", rule_index)
        if unix_read_only is not None:
            pulumi.set(__self__, "unix_read_only", unix_read_only)
        if unix_read_write is not None:
            pulumi.set(__self__, "unix_read_write", unix_read_write)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[str]]:
        """
        Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter(name="chownMode")
    def chown_mode(self) -> Optional[pulumi.Input[Union[str, 'ChownMode']]]:
        """
        This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
        """
        return pulumi.get(self, "chown_mode")

    @chown_mode.setter
    def chown_mode(self, value: Optional[pulumi.Input[Union[str, 'ChownMode']]]):
        pulumi.set(self, "chown_mode", value)

    @property
    @pulumi.getter
    def cifs(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows CIFS protocol
        """
        return pulumi.get(self, "cifs")

    @cifs.setter
    def cifs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cifs", value)

    @property
    @pulumi.getter(name="hasRootAccess")
    def has_root_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Has root access to volume
        """
        return pulumi.get(self, "has_root_access")

    @has_root_access.setter
    def has_root_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_root_access", value)

    @property
    @pulumi.getter(name="kerberos5ReadOnly")
    def kerberos5_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
        """
        return pulumi.get(self, "kerberos5_read_only")

    @kerberos5_read_only.setter
    def kerberos5_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5_read_only", value)

    @property
    @pulumi.getter(name="kerberos5ReadWrite")
    def kerberos5_read_write(self) -> Optional[pulumi.Input[bool]]:
        """
        Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
        """
        return pulumi.get(self, "kerberos5_read_write")

    @kerberos5_read_write.setter
    def kerberos5_read_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5_read_write", value)

    @property
    @pulumi.getter(name="kerberos5iReadOnly")
    def kerberos5i_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
        """
        return pulumi.get(self, "kerberos5i_read_only")

    @kerberos5i_read_only.setter
    def kerberos5i_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5i_read_only", value)

    @property
    @pulumi.getter(name="kerberos5iReadWrite")
    def kerberos5i_read_write(self) -> Optional[pulumi.Input[bool]]:
        """
        Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
        """
        return pulumi.get(self, "kerberos5i_read_write")

    @kerberos5i_read_write.setter
    def kerberos5i_read_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5i_read_write", value)

    @property
    @pulumi.getter(name="kerberos5pReadOnly")
    def kerberos5p_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
        """
        return pulumi.get(self, "kerberos5p_read_only")

    @kerberos5p_read_only.setter
    def kerberos5p_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5p_read_only", value)

    @property
    @pulumi.getter(name="kerberos5pReadWrite")
    def kerberos5p_read_write(self) -> Optional[pulumi.Input[bool]]:
        """
        Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
        """
        return pulumi.get(self, "kerberos5p_read_write")

    @kerberos5p_read_write.setter
    def kerberos5p_read_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos5p_read_write", value)

    @property
    @pulumi.getter
    def nfsv3(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows NFSv3 protocol. Enable only for NFSv3 type volumes
        """
        return pulumi.get(self, "nfsv3")

    @nfsv3.setter
    def nfsv3(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfsv3", value)

    @property
    @pulumi.getter
    def nfsv41(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
        """
        return pulumi.get(self, "nfsv41")

    @nfsv41.setter
    def nfsv41(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfsv41", value)

    @property
    @pulumi.getter(name="ruleIndex")
    def rule_index(self) -> Optional[pulumi.Input[int]]:
        """
        Order index
        """
        return pulumi.get(self, "rule_index")

    @rule_index.setter
    def rule_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rule_index", value)

    @property
    @pulumi.getter(name="unixReadOnly")
    def unix_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Read only access
        """
        return pulumi.get(self, "unix_read_only")

    @unix_read_only.setter
    def unix_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unix_read_only", value)

    @property
    @pulumi.getter(name="unixReadWrite")
    def unix_read_write(self) -> Optional[pulumi.Input[bool]]:
        """
        Read and write access
        """
        return pulumi.get(self, "unix_read_write")

    @unix_read_write.setter
    def unix_read_write(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unix_read_write", value)


@pulumi.input_type
class HourlyScheduleArgs:
    def __init__(__self__, *,
                 minute: Optional[pulumi.Input[int]] = None,
                 snapshots_to_keep: Optional[pulumi.Input[int]] = None,
                 used_bytes: Optional[pulumi.Input[float]] = None):
        """
        Hourly Schedule properties
        :param pulumi.Input[int] minute: Indicates which minute snapshot should be taken
        :param pulumi.Input[int] snapshots_to_keep: Hourly snapshot count to keep
        :param pulumi.Input[float] used_bytes: Resource size in bytes, current storage usage for the volume in bytes
        """
        if minute is not None:
            pulumi.set(__self__, "minute", minute)
        if snapshots_to_keep is not None:
            pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if used_bytes is not None:
            pulumi.set(__self__, "used_bytes", used_bytes)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates which minute snapshot should be taken
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> Optional[pulumi.Input[int]]:
        """
        Hourly snapshot count to keep
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter(name="usedBytes")
    def used_bytes(self) -> Optional[pulumi.Input[float]]:
        """
        Resource size in bytes, current storage usage for the volume in bytes
        """
        return pulumi.get(self, "used_bytes")

    @used_bytes.setter
    def used_bytes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "used_bytes", value)


@pulumi.input_type
class LdapSearchScopeOptArgs:
    def __init__(__self__, *,
                 group_dn: Optional[pulumi.Input[str]] = None,
                 group_membership_filter: Optional[pulumi.Input[str]] = None,
                 user_dn: Optional[pulumi.Input[str]] = None):
        """
        LDAP search scope 
        :param pulumi.Input[str] group_dn: This specifies the group DN, which overrides the base DN for group lookups.
        :param pulumi.Input[str] group_membership_filter: This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
        :param pulumi.Input[str] user_dn: This specifies the user DN, which overrides the base DN for user lookups.
        """
        if group_dn is not None:
            pulumi.set(__self__, "group_dn", group_dn)
        if group_membership_filter is not None:
            pulumi.set(__self__, "group_membership_filter", group_membership_filter)
        if user_dn is not None:
            pulumi.set(__self__, "user_dn", user_dn)

    @property
    @pulumi.getter(name="groupDN")
    def group_dn(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies the group DN, which overrides the base DN for group lookups.
        """
        return pulumi.get(self, "group_dn")

    @group_dn.setter
    def group_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_dn", value)

    @property
    @pulumi.getter(name="groupMembershipFilter")
    def group_membership_filter(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
        """
        return pulumi.get(self, "group_membership_filter")

    @group_membership_filter.setter
    def group_membership_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_membership_filter", value)

    @property
    @pulumi.getter(name="userDN")
    def user_dn(self) -> Optional[pulumi.Input[str]]:
        """
        This specifies the user DN, which overrides the base DN for user lookups.
        """
        return pulumi.get(self, "user_dn")

    @user_dn.setter
    def user_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_dn", value)


@pulumi.input_type
class MonthlyScheduleArgs:
    def __init__(__self__, *,
                 days_of_month: Optional[pulumi.Input[str]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 minute: Optional[pulumi.Input[int]] = None,
                 snapshots_to_keep: Optional[pulumi.Input[int]] = None,
                 used_bytes: Optional[pulumi.Input[float]] = None):
        """
        Monthly Schedule properties
        :param pulumi.Input[str] days_of_month: Indicates which days of the month snapshot should be taken. A comma delimited string.
        :param pulumi.Input[int] hour: Indicates which hour in UTC timezone a snapshot should be taken
        :param pulumi.Input[int] minute: Indicates which minute snapshot should be taken
        :param pulumi.Input[int] snapshots_to_keep: Monthly snapshot count to keep
        :param pulumi.Input[float] used_bytes: Resource size in bytes, current storage usage for the volume in bytes
        """
        if days_of_month is not None:
            pulumi.set(__self__, "days_of_month", days_of_month)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)
        if snapshots_to_keep is not None:
            pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if used_bytes is not None:
            pulumi.set(__self__, "used_bytes", used_bytes)

    @property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates which days of the month snapshot should be taken. A comma delimited string.
        """
        return pulumi.get(self, "days_of_month")

    @days_of_month.setter
    def days_of_month(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "days_of_month", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates which hour in UTC timezone a snapshot should be taken
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates which minute snapshot should be taken
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> Optional[pulumi.Input[int]]:
        """
        Monthly snapshot count to keep
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter(name="usedBytes")
    def used_bytes(self) -> Optional[pulumi.Input[float]]:
        """
        Resource size in bytes, current storage usage for the volume in bytes
        """
        return pulumi.get(self, "used_bytes")

    @used_bytes.setter
    def used_bytes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "used_bytes", value)


@pulumi.input_type
class PlacementKeyValuePairsArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Application specific parameters for the placement of volumes in the volume group
        :param pulumi.Input[str] key: Key for an application specific parameter for the placement of volumes in the volume group
        :param pulumi.Input[str] value: Value for an application specific parameter for the placement of volumes in the volume group
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key for an application specific parameter for the placement of volumes in the volume group
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value for an application specific parameter for the placement of volumes in the volume group
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ReplicationObjectArgs:
    def __init__(__self__, *,
                 remote_volume_resource_id: pulumi.Input[str],
                 endpoint_type: Optional[pulumi.Input[Union[str, 'EndpointType']]] = None,
                 remote_volume_region: Optional[pulumi.Input[str]] = None,
                 replication_id: Optional[pulumi.Input[str]] = None,
                 replication_schedule: Optional[pulumi.Input[Union[str, 'ReplicationSchedule']]] = None):
        """
        Replication properties
        :param pulumi.Input[str] remote_volume_resource_id: The resource ID of the remote volume.
        :param pulumi.Input[Union[str, 'EndpointType']] endpoint_type: Indicates whether the local volume is the source or destination for the Volume Replication
        :param pulumi.Input[str] remote_volume_region: The remote region for the other end of the Volume Replication.
        :param pulumi.Input[str] replication_id: Id
        :param pulumi.Input[Union[str, 'ReplicationSchedule']] replication_schedule: Schedule
        """
        pulumi.set(__self__, "remote_volume_resource_id", remote_volume_resource_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if remote_volume_region is not None:
            pulumi.set(__self__, "remote_volume_region", remote_volume_region)
        if replication_id is not None:
            pulumi.set(__self__, "replication_id", replication_id)
        if replication_schedule is not None:
            pulumi.set(__self__, "replication_schedule", replication_schedule)

    @property
    @pulumi.getter(name="remoteVolumeResourceId")
    def remote_volume_resource_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the remote volume.
        """
        return pulumi.get(self, "remote_volume_resource_id")

    @remote_volume_resource_id.setter
    def remote_volume_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_volume_resource_id", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[Union[str, 'EndpointType']]]:
        """
        Indicates whether the local volume is the source or destination for the Volume Replication
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[Union[str, 'EndpointType']]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="remoteVolumeRegion")
    def remote_volume_region(self) -> Optional[pulumi.Input[str]]:
        """
        The remote region for the other end of the Volume Replication.
        """
        return pulumi.get(self, "remote_volume_region")

    @remote_volume_region.setter
    def remote_volume_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_volume_region", value)

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id
        """
        return pulumi.get(self, "replication_id")

    @replication_id.setter
    def replication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_id", value)

    @property
    @pulumi.getter(name="replicationSchedule")
    def replication_schedule(self) -> Optional[pulumi.Input[Union[str, 'ReplicationSchedule']]]:
        """
        Schedule
        """
        return pulumi.get(self, "replication_schedule")

    @replication_schedule.setter
    def replication_schedule(self, value: Optional[pulumi.Input[Union[str, 'ReplicationSchedule']]]):
        pulumi.set(self, "replication_schedule", value)


@pulumi.input_type
class VolumeBackupPropertiesArgs:
    def __init__(__self__, *,
                 backup_enabled: Optional[pulumi.Input[bool]] = None,
                 backup_policy_id: Optional[pulumi.Input[str]] = None,
                 policy_enforced: Optional[pulumi.Input[bool]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None):
        """
        Volume Backup Properties
        :param pulumi.Input[bool] backup_enabled: Backup Enabled
        :param pulumi.Input[str] backup_policy_id: Backup Policy Resource ID
        :param pulumi.Input[bool] policy_enforced: Policy Enforced
        :param pulumi.Input[str] vault_id: Vault Resource ID
        """
        if backup_enabled is not None:
            pulumi.set(__self__, "backup_enabled", backup_enabled)
        if backup_policy_id is not None:
            pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        if policy_enforced is not None:
            pulumi.set(__self__, "policy_enforced", policy_enforced)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupEnabled")
    def backup_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Backup Enabled
        """
        return pulumi.get(self, "backup_enabled")

    @backup_enabled.setter
    def backup_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_enabled", value)

    @property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Backup Policy Resource ID
        """
        return pulumi.get(self, "backup_policy_id")

    @backup_policy_id.setter
    def backup_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_policy_id", value)

    @property
    @pulumi.getter(name="policyEnforced")
    def policy_enforced(self) -> Optional[pulumi.Input[bool]]:
        """
        Policy Enforced
        """
        return pulumi.get(self, "policy_enforced")

    @policy_enforced.setter
    def policy_enforced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "policy_enforced", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        Vault Resource ID
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.input_type
class VolumeGroupMetaDataArgs:
    def __init__(__self__, *,
                 application_identifier: Optional[pulumi.Input[str]] = None,
                 application_type: Optional[pulumi.Input[Union[str, 'ApplicationType']]] = None,
                 deployment_spec_id: Optional[pulumi.Input[str]] = None,
                 global_placement_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]]] = None,
                 group_description: Optional[pulumi.Input[str]] = None):
        """
        Volume group properties
        :param pulumi.Input[str] application_identifier: Application specific identifier
        :param pulumi.Input[Union[str, 'ApplicationType']] application_type: Application Type
        :param pulumi.Input[str] deployment_spec_id: Application specific identifier of deployment rules for the volume group
        :param pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]] global_placement_rules: Application specific placement rules for the volume group
        :param pulumi.Input[str] group_description: Group Description
        """
        if application_identifier is not None:
            pulumi.set(__self__, "application_identifier", application_identifier)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if deployment_spec_id is not None:
            pulumi.set(__self__, "deployment_spec_id", deployment_spec_id)
        if global_placement_rules is not None:
            pulumi.set(__self__, "global_placement_rules", global_placement_rules)
        if group_description is not None:
            pulumi.set(__self__, "group_description", group_description)

    @property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Application specific identifier
        """
        return pulumi.get(self, "application_identifier")

    @application_identifier.setter
    def application_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_identifier", value)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[Union[str, 'ApplicationType']]]:
        """
        Application Type
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[Union[str, 'ApplicationType']]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="deploymentSpecId")
    def deployment_spec_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application specific identifier of deployment rules for the volume group
        """
        return pulumi.get(self, "deployment_spec_id")

    @deployment_spec_id.setter
    def deployment_spec_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_spec_id", value)

    @property
    @pulumi.getter(name="globalPlacementRules")
    def global_placement_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]]]:
        """
        Application specific placement rules for the volume group
        """
        return pulumi.get(self, "global_placement_rules")

    @global_placement_rules.setter
    def global_placement_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]]]):
        pulumi.set(self, "global_placement_rules", value)

    @property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> Optional[pulumi.Input[str]]:
        """
        Group Description
        """
        return pulumi.get(self, "group_description")

    @group_description.setter
    def group_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_description", value)


@pulumi.input_type
class VolumeGroupVolumePropertiesArgs:
    def __init__(__self__, *,
                 creation_token: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 usage_threshold: pulumi.Input[float],
                 avs_data_store: Optional[pulumi.Input[Union[str, 'AvsDataStore']]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 capacity_pool_resource_id: Optional[pulumi.Input[str]] = None,
                 cool_access: Optional[pulumi.Input[bool]] = None,
                 coolness_period: Optional[pulumi.Input[int]] = None,
                 data_protection: Optional[pulumi.Input['VolumePropertiesDataProtectionArgs']] = None,
                 default_group_quota_in_ki_bs: Optional[pulumi.Input[float]] = None,
                 default_user_quota_in_ki_bs: Optional[pulumi.Input[float]] = None,
                 enable_subvolumes: Optional[pulumi.Input[Union[str, 'EnableSubvolumes']]] = None,
                 encryption_key_source: Optional[pulumi.Input[Union[str, 'EncryptionKeySource']]] = None,
                 export_policy: Optional[pulumi.Input['VolumePropertiesExportPolicyArgs']] = None,
                 is_default_quota_enabled: Optional[pulumi.Input[bool]] = None,
                 is_restoring: Optional[pulumi.Input[bool]] = None,
                 kerberos_enabled: Optional[pulumi.Input[bool]] = None,
                 ldap_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_features: Optional[pulumi.Input[Union[str, 'NetworkFeatures']]] = None,
                 placement_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]]] = None,
                 protocol_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 proximity_placement_group: Optional[pulumi.Input[str]] = None,
                 security_style: Optional[pulumi.Input[Union[str, 'SecurityStyle']]] = None,
                 service_level: Optional[pulumi.Input[Union[str, 'ServiceLevel']]] = None,
                 smb_continuously_available: Optional[pulumi.Input[bool]] = None,
                 smb_encryption: Optional[pulumi.Input[bool]] = None,
                 snapshot_directory_visible: Optional[pulumi.Input[bool]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_mibps: Optional[pulumi.Input[float]] = None,
                 unix_permissions: Optional[pulumi.Input[str]] = None,
                 volume_spec_name: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        Volume resource
        :param pulumi.Input[str] creation_token: A unique file path for the volume. Used when creating mount targets
        :param pulumi.Input[str] subnet_id: The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
        :param pulumi.Input[float] usage_threshold: Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 500 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
        :param pulumi.Input[Union[str, 'AvsDataStore']] avs_data_store: Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
        :param pulumi.Input[str] backup_id: UUID v4 or resource identifier used to identify the Backup.
        :param pulumi.Input[str] capacity_pool_resource_id: Pool Resource Id used in case of creating a volume through volume group
        :param pulumi.Input[bool] cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
        :param pulumi.Input[int] coolness_period: Specifies the number of days after which data that is not accessed by clients will be tiered.
        :param pulumi.Input['VolumePropertiesDataProtectionArgs'] data_protection: DataProtection type volumes include an object containing details of the replication
        :param pulumi.Input[float] default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
        :param pulumi.Input[float] default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
        :param pulumi.Input[Union[str, 'EnableSubvolumes']] enable_subvolumes: Flag indicating whether subvolume operations are enabled on the volume
        :param pulumi.Input[Union[str, 'EncryptionKeySource']] encryption_key_source: Source of key used to encrypt data in volume. Possible values (case-insensitive) are: 'Microsoft.NetApp'
        :param pulumi.Input['VolumePropertiesExportPolicyArgs'] export_policy: Set of export policy rules
        :param pulumi.Input[bool] is_default_quota_enabled: Specifies if default quota is enabled for the volume.
        :param pulumi.Input[bool] is_restoring: Restoring
        :param pulumi.Input[bool] kerberos_enabled: Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
        :param pulumi.Input[bool] ldap_enabled: Specifies whether LDAP is enabled or not for a given NFS volume.
        :param pulumi.Input[str] name: Resource name
        :param pulumi.Input[Union[str, 'NetworkFeatures']] network_features: Basic network, or Standard features available to the volume.
        :param pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]] placement_rules: Application specific placement rules for the particular volume
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol
        :param pulumi.Input[str] proximity_placement_group: Proximity placement group associated with the volume
        :param pulumi.Input[Union[str, 'SecurityStyle']] security_style: The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
        :param pulumi.Input[Union[str, 'ServiceLevel']] service_level: The service level of the file system
        :param pulumi.Input[bool] smb_continuously_available: Enables continuously available share property for smb volume. Only applicable for SMB volume
        :param pulumi.Input[bool] smb_encryption: Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
        :param pulumi.Input[bool] snapshot_directory_visible: If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (default to true).
        :param pulumi.Input[str] snapshot_id: UUID v4 or resource identifier used to identify the Snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[str] unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
        :param pulumi.Input[str] volume_spec_name: Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
        :param pulumi.Input[str] volume_type: What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
        """
        pulumi.set(__self__, "creation_token", creation_token)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if usage_threshold is None:
            usage_threshold = 107374182400
        pulumi.set(__self__, "usage_threshold", usage_threshold)
        if avs_data_store is None:
            avs_data_store = 'Disabled'
        if avs_data_store is not None:
            pulumi.set(__self__, "avs_data_store", avs_data_store)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if capacity_pool_resource_id is not None:
            pulumi.set(__self__, "capacity_pool_resource_id", capacity_pool_resource_id)
        if cool_access is None:
            cool_access = False
        if cool_access is not None:
            pulumi.set(__self__, "cool_access", cool_access)
        if coolness_period is not None:
            pulumi.set(__self__, "coolness_period", coolness_period)
        if data_protection is not None:
            pulumi.set(__self__, "data_protection", data_protection)
        if default_group_quota_in_ki_bs is None:
            default_group_quota_in_ki_bs = 0
        if default_group_quota_in_ki_bs is not None:
            pulumi.set(__self__, "default_group_quota_in_ki_bs", default_group_quota_in_ki_bs)
        if default_user_quota_in_ki_bs is None:
            default_user_quota_in_ki_bs = 0
        if default_user_quota_in_ki_bs is not None:
            pulumi.set(__self__, "default_user_quota_in_ki_bs", default_user_quota_in_ki_bs)
        if enable_subvolumes is None:
            enable_subvolumes = 'Disabled'
        if enable_subvolumes is not None:
            pulumi.set(__self__, "enable_subvolumes", enable_subvolumes)
        if encryption_key_source is None:
            encryption_key_source = 'Microsoft.NetApp'
        if encryption_key_source is not None:
            pulumi.set(__self__, "encryption_key_source", encryption_key_source)
        if export_policy is not None:
            pulumi.set(__self__, "export_policy", export_policy)
        if is_default_quota_enabled is None:
            is_default_quota_enabled = False
        if is_default_quota_enabled is not None:
            pulumi.set(__self__, "is_default_quota_enabled", is_default_quota_enabled)
        if is_restoring is not None:
            pulumi.set(__self__, "is_restoring", is_restoring)
        if kerberos_enabled is None:
            kerberos_enabled = False
        if kerberos_enabled is not None:
            pulumi.set(__self__, "kerberos_enabled", kerberos_enabled)
        if ldap_enabled is None:
            ldap_enabled = False
        if ldap_enabled is not None:
            pulumi.set(__self__, "ldap_enabled", ldap_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_features is None:
            network_features = 'Basic'
        if network_features is not None:
            pulumi.set(__self__, "network_features", network_features)
        if placement_rules is not None:
            pulumi.set(__self__, "placement_rules", placement_rules)
        if protocol_types is not None:
            pulumi.set(__self__, "protocol_types", protocol_types)
        if proximity_placement_group is not None:
            pulumi.set(__self__, "proximity_placement_group", proximity_placement_group)
        if security_style is None:
            security_style = 'unix'
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if service_level is not None:
            pulumi.set(__self__, "service_level", service_level)
        if smb_continuously_available is None:
            smb_continuously_available = False
        if smb_continuously_available is not None:
            pulumi.set(__self__, "smb_continuously_available", smb_continuously_available)
        if smb_encryption is None:
            smb_encryption = False
        if smb_encryption is not None:
            pulumi.set(__self__, "smb_encryption", smb_encryption)
        if snapshot_directory_visible is None:
            snapshot_directory_visible = True
        if snapshot_directory_visible is not None:
            pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput_mibps is not None:
            pulumi.set(__self__, "throughput_mibps", throughput_mibps)
        if unix_permissions is None:
            unix_permissions = '0770'
        if unix_permissions is not None:
            pulumi.set(__self__, "unix_permissions", unix_permissions)
        if volume_spec_name is not None:
            pulumi.set(__self__, "volume_spec_name", volume_spec_name)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="creationToken")
    def creation_token(self) -> pulumi.Input[str]:
        """
        A unique file path for the volume. Used when creating mount targets
        """
        return pulumi.get(self, "creation_token")

    @creation_token.setter
    def creation_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "creation_token", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="usageThreshold")
    def usage_threshold(self) -> pulumi.Input[float]:
        """
        Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 500 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
        """
        return pulumi.get(self, "usage_threshold")

    @usage_threshold.setter
    def usage_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "usage_threshold", value)

    @property
    @pulumi.getter(name="avsDataStore")
    def avs_data_store(self) -> Optional[pulumi.Input[Union[str, 'AvsDataStore']]]:
        """
        Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
        """
        return pulumi.get(self, "avs_data_store")

    @avs_data_store.setter
    def avs_data_store(self, value: Optional[pulumi.Input[Union[str, 'AvsDataStore']]]):
        pulumi.set(self, "avs_data_store", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID v4 or resource identifier used to identify the Backup.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="capacityPoolResourceId")
    def capacity_pool_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Pool Resource Id used in case of creating a volume through volume group
        """
        return pulumi.get(self, "capacity_pool_resource_id")

    @capacity_pool_resource_id.setter
    def capacity_pool_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_pool_resource_id", value)

    @property
    @pulumi.getter(name="coolAccess")
    def cool_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Cool Access(tiering) is enabled for the volume.
        """
        return pulumi.get(self, "cool_access")

    @cool_access.setter
    def cool_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cool_access", value)

    @property
    @pulumi.getter(name="coolnessPeriod")
    def coolness_period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after which data that is not accessed by clients will be tiered.
        """
        return pulumi.get(self, "coolness_period")

    @coolness_period.setter
    def coolness_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "coolness_period", value)

    @property
    @pulumi.getter(name="dataProtection")
    def data_protection(self) -> Optional[pulumi.Input['VolumePropertiesDataProtectionArgs']]:
        """
        DataProtection type volumes include an object containing details of the replication
        """
        return pulumi.get(self, "data_protection")

    @data_protection.setter
    def data_protection(self, value: Optional[pulumi.Input['VolumePropertiesDataProtectionArgs']]):
        pulumi.set(self, "data_protection", value)

    @property
    @pulumi.getter(name="defaultGroupQuotaInKiBs")
    def default_group_quota_in_ki_bs(self) -> Optional[pulumi.Input[float]]:
        """
        Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
        """
        return pulumi.get(self, "default_group_quota_in_ki_bs")

    @default_group_quota_in_ki_bs.setter
    def default_group_quota_in_ki_bs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "default_group_quota_in_ki_bs", value)

    @property
    @pulumi.getter(name="defaultUserQuotaInKiBs")
    def default_user_quota_in_ki_bs(self) -> Optional[pulumi.Input[float]]:
        """
        Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
        """
        return pulumi.get(self, "default_user_quota_in_ki_bs")

    @default_user_quota_in_ki_bs.setter
    def default_user_quota_in_ki_bs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "default_user_quota_in_ki_bs", value)

    @property
    @pulumi.getter(name="enableSubvolumes")
    def enable_subvolumes(self) -> Optional[pulumi.Input[Union[str, 'EnableSubvolumes']]]:
        """
        Flag indicating whether subvolume operations are enabled on the volume
        """
        return pulumi.get(self, "enable_subvolumes")

    @enable_subvolumes.setter
    def enable_subvolumes(self, value: Optional[pulumi.Input[Union[str, 'EnableSubvolumes']]]):
        pulumi.set(self, "enable_subvolumes", value)

    @property
    @pulumi.getter(name="encryptionKeySource")
    def encryption_key_source(self) -> Optional[pulumi.Input[Union[str, 'EncryptionKeySource']]]:
        """
        Source of key used to encrypt data in volume. Possible values (case-insensitive) are: 'Microsoft.NetApp'
        """
        return pulumi.get(self, "encryption_key_source")

    @encryption_key_source.setter
    def encryption_key_source(self, value: Optional[pulumi.Input[Union[str, 'EncryptionKeySource']]]):
        pulumi.set(self, "encryption_key_source", value)

    @property
    @pulumi.getter(name="exportPolicy")
    def export_policy(self) -> Optional[pulumi.Input['VolumePropertiesExportPolicyArgs']]:
        """
        Set of export policy rules
        """
        return pulumi.get(self, "export_policy")

    @export_policy.setter
    def export_policy(self, value: Optional[pulumi.Input['VolumePropertiesExportPolicyArgs']]):
        pulumi.set(self, "export_policy", value)

    @property
    @pulumi.getter(name="isDefaultQuotaEnabled")
    def is_default_quota_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if default quota is enabled for the volume.
        """
        return pulumi.get(self, "is_default_quota_enabled")

    @is_default_quota_enabled.setter
    def is_default_quota_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_quota_enabled", value)

    @property
    @pulumi.getter(name="isRestoring")
    def is_restoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Restoring
        """
        return pulumi.get(self, "is_restoring")

    @is_restoring.setter
    def is_restoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_restoring", value)

    @property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
        """
        return pulumi.get(self, "kerberos_enabled")

    @kerberos_enabled.setter
    def kerberos_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "kerberos_enabled", value)

    @property
    @pulumi.getter(name="ldapEnabled")
    def ldap_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether LDAP is enabled or not for a given NFS volume.
        """
        return pulumi.get(self, "ldap_enabled")

    @ldap_enabled.setter
    def ldap_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ldap_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFeatures")
    def network_features(self) -> Optional[pulumi.Input[Union[str, 'NetworkFeatures']]]:
        """
        Basic network, or Standard features available to the volume.
        """
        return pulumi.get(self, "network_features")

    @network_features.setter
    def network_features(self, value: Optional[pulumi.Input[Union[str, 'NetworkFeatures']]]):
        pulumi.set(self, "network_features", value)

    @property
    @pulumi.getter(name="placementRules")
    def placement_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]]]:
        """
        Application specific placement rules for the particular volume
        """
        return pulumi.get(self, "placement_rules")

    @placement_rules.setter
    def placement_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlacementKeyValuePairsArgs']]]]):
        pulumi.set(self, "placement_rules", value)

    @property
    @pulumi.getter(name="protocolTypes")
    def protocol_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of protocol types, default NFSv3, CIFS for SMB protocol
        """
        return pulumi.get(self, "protocol_types")

    @protocol_types.setter
    def protocol_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocol_types", value)

    @property
    @pulumi.getter(name="proximityPlacementGroup")
    def proximity_placement_group(self) -> Optional[pulumi.Input[str]]:
        """
        Proximity placement group associated with the volume
        """
        return pulumi.get(self, "proximity_placement_group")

    @proximity_placement_group.setter
    def proximity_placement_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proximity_placement_group", value)

    @property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[Union[str, 'SecurityStyle']]]:
        """
        The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[Union[str, 'SecurityStyle']]]):
        pulumi.set(self, "security_style", value)

    @property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> Optional[pulumi.Input[Union[str, 'ServiceLevel']]]:
        """
        The service level of the file system
        """
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: Optional[pulumi.Input[Union[str, 'ServiceLevel']]]):
        pulumi.set(self, "service_level", value)

    @property
    @pulumi.getter(name="smbContinuouslyAvailable")
    def smb_continuously_available(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables continuously available share property for smb volume. Only applicable for SMB volume
        """
        return pulumi.get(self, "smb_continuously_available")

    @smb_continuously_available.setter
    def smb_continuously_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smb_continuously_available", value)

    @property
    @pulumi.getter(name="smbEncryption")
    def smb_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
        """
        return pulumi.get(self, "smb_encryption")

    @smb_encryption.setter
    def smb_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smb_encryption", value)

    @property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> Optional[pulumi.Input[bool]]:
        """
        If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (default to true).
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @snapshot_directory_visible.setter
    def snapshot_directory_visible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snapshot_directory_visible", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        UUID v4 or resource identifier used to identify the Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="throughputMibps")
    def throughput_mibps(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "throughput_mibps")

    @throughput_mibps.setter
    def throughput_mibps(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "throughput_mibps", value)

    @property
    @pulumi.getter(name="unixPermissions")
    def unix_permissions(self) -> Optional[pulumi.Input[str]]:
        """
        UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
        """
        return pulumi.get(self, "unix_permissions")

    @unix_permissions.setter
    def unix_permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unix_permissions", value)

    @property
    @pulumi.getter(name="volumeSpecName")
    def volume_spec_name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
        """
        return pulumi.get(self, "volume_spec_name")

    @volume_spec_name.setter
    def volume_spec_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_spec_name", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class VolumePropertiesDataProtectionArgs:
    def __init__(__self__, *,
                 backup: Optional[pulumi.Input['VolumeBackupPropertiesArgs']] = None,
                 replication: Optional[pulumi.Input['ReplicationObjectArgs']] = None,
                 snapshot: Optional[pulumi.Input['VolumeSnapshotPropertiesArgs']] = None):
        """
        DataProtection type volumes include an object containing details of the replication
        :param pulumi.Input['VolumeBackupPropertiesArgs'] backup: Backup Properties
        :param pulumi.Input['ReplicationObjectArgs'] replication: Replication properties
        :param pulumi.Input['VolumeSnapshotPropertiesArgs'] snapshot: Snapshot properties.
        """
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if replication is not None:
            pulumi.set(__self__, "replication", replication)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['VolumeBackupPropertiesArgs']]:
        """
        Backup Properties
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['VolumeBackupPropertiesArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter
    def replication(self) -> Optional[pulumi.Input['ReplicationObjectArgs']]:
        """
        Replication properties
        """
        return pulumi.get(self, "replication")

    @replication.setter
    def replication(self, value: Optional[pulumi.Input['ReplicationObjectArgs']]):
        pulumi.set(self, "replication", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['VolumeSnapshotPropertiesArgs']]:
        """
        Snapshot properties.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['VolumeSnapshotPropertiesArgs']]):
        pulumi.set(self, "snapshot", value)


@pulumi.input_type
class VolumePropertiesExportPolicyArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ExportPolicyRuleArgs']]]] = None):
        """
        Set of export policy rules
        :param pulumi.Input[Sequence[pulumi.Input['ExportPolicyRuleArgs']]] rules: Export policy rule
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportPolicyRuleArgs']]]]:
        """
        Export policy rule
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportPolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class VolumeSnapshotPropertiesArgs:
    def __init__(__self__, *,
                 snapshot_policy_id: Optional[pulumi.Input[str]] = None):
        """
        Volume Snapshot Properties
        :param pulumi.Input[str] snapshot_policy_id: Snapshot Policy ResourceId
        """
        if snapshot_policy_id is not None:
            pulumi.set(__self__, "snapshot_policy_id", snapshot_policy_id)

    @property
    @pulumi.getter(name="snapshotPolicyId")
    def snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Snapshot Policy ResourceId
        """
        return pulumi.get(self, "snapshot_policy_id")

    @snapshot_policy_id.setter
    def snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_policy_id", value)


@pulumi.input_type
class WeeklyScheduleArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[str]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 minute: Optional[pulumi.Input[int]] = None,
                 snapshots_to_keep: Optional[pulumi.Input[int]] = None,
                 used_bytes: Optional[pulumi.Input[float]] = None):
        """
        Weekly Schedule properties, make a snapshot every week at a specific day or days
        :param pulumi.Input[str] day: Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
        :param pulumi.Input[int] hour: Indicates which hour in UTC timezone a snapshot should be taken
        :param pulumi.Input[int] minute: Indicates which minute snapshot should be taken
        :param pulumi.Input[int] snapshots_to_keep: Weekly snapshot count to keep
        :param pulumi.Input[float] used_bytes: Resource size in bytes, current storage usage for the volume in bytes
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if minute is not None:
            pulumi.set(__self__, "minute", minute)
        if snapshots_to_keep is not None:
            pulumi.set(__self__, "snapshots_to_keep", snapshots_to_keep)
        if used_bytes is not None:
            pulumi.set(__self__, "used_bytes", used_bytes)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates which hour in UTC timezone a snapshot should be taken
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def minute(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates which minute snapshot should be taken
        """
        return pulumi.get(self, "minute")

    @minute.setter
    def minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minute", value)

    @property
    @pulumi.getter(name="snapshotsToKeep")
    def snapshots_to_keep(self) -> Optional[pulumi.Input[int]]:
        """
        Weekly snapshot count to keep
        """
        return pulumi.get(self, "snapshots_to_keep")

    @snapshots_to_keep.setter
    def snapshots_to_keep(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshots_to_keep", value)

    @property
    @pulumi.getter(name="usedBytes")
    def used_bytes(self) -> Optional[pulumi.Input[float]]:
        """
        Resource size in bytes, current storage usage for the volume in bytes
        """
        return pulumi.get(self, "used_bytes")

    @used_bytes.setter
    def used_bytes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "used_bytes", value)


