# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AccessKeyInfoBaseArgs',
    'AzureKeyVaultPropertiesArgs',
    'AzureResourceArgs',
    'ConfigurationInfoArgs',
    'ConfluentBootstrapServerArgs',
    'ConfluentSchemaRegistryArgs',
    'CreateOrUpdateDryrunParametersArgs',
    'FirewallRulesArgs',
    'KeyVaultSecretReferenceSecretInfoArgs',
    'KeyVaultSecretUriSecretInfoArgs',
    'PublicNetworkSolutionArgs',
    'SecretAuthInfoArgs',
    'SecretStoreArgs',
    'SelfHostedServerArgs',
    'ServicePrincipalCertificateAuthInfoArgs',
    'ServicePrincipalSecretAuthInfoArgs',
    'SystemAssignedIdentityAuthInfoArgs',
    'UserAccountAuthInfoArgs',
    'UserAssignedIdentityAuthInfoArgs',
    'VNetSolutionArgs',
    'ValueSecretInfoArgs',
]

@pulumi.input_type
class AccessKeyInfoBaseArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AccessKeyPermissions']]]]] = None):
        """
        The access key directly from target resource properties, which target service is Azure Resource, such as Microsoft.Storage
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'accessKey'.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'AccessKeyPermissions']]]] permissions: Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
        """
        pulumi.set(__self__, "auth_type", 'accessKey')
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'accessKey'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AccessKeyPermissions']]]]]:
        """
        Permissions of the accessKey. `Read` and `Write` are for Azure Cosmos DB and Azure App Configuration, `Listen`, `Send` and `Manage` are for Azure Event Hub and Azure Service Bus.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AccessKeyPermissions']]]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class AzureKeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 connect_as_kubernetes_csi_driver: Optional[pulumi.Input[bool]] = None):
        """
        The resource properties when type is Azure Key Vault
        :param pulumi.Input[str] type: The azure resource type.
               Expected value is 'KeyVault'.
        :param pulumi.Input[bool] connect_as_kubernetes_csi_driver: True if connect via Kubernetes CSI Driver.
        """
        pulumi.set(__self__, "type", 'KeyVault')
        if connect_as_kubernetes_csi_driver is not None:
            pulumi.set(__self__, "connect_as_kubernetes_csi_driver", connect_as_kubernetes_csi_driver)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The azure resource type.
        Expected value is 'KeyVault'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="connectAsKubernetesCsiDriver")
    def connect_as_kubernetes_csi_driver(self) -> Optional[pulumi.Input[bool]]:
        """
        True if connect via Kubernetes CSI Driver.
        """
        return pulumi.get(self, "connect_as_kubernetes_csi_driver")

    @connect_as_kubernetes_csi_driver.setter
    def connect_as_kubernetes_csi_driver(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "connect_as_kubernetes_csi_driver", value)


@pulumi.input_type
class AzureResourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 resource_properties: Optional[pulumi.Input['AzureKeyVaultPropertiesArgs']] = None):
        """
        The azure resource info when target service type is AzureResource
        :param pulumi.Input[str] type: The target service type.
               Expected value is 'AzureResource'.
        :param pulumi.Input[str] id: The Id of azure resource.
        :param pulumi.Input['AzureKeyVaultPropertiesArgs'] resource_properties: The azure resource connection related properties.
        """
        pulumi.set(__self__, "type", 'AzureResource')
        if id is not None:
            pulumi.set(__self__, "id", id)
        if resource_properties is not None:
            pulumi.set(__self__, "resource_properties", resource_properties)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The target service type.
        Expected value is 'AzureResource'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of azure resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> Optional[pulumi.Input['AzureKeyVaultPropertiesArgs']]:
        """
        The azure resource connection related properties.
        """
        return pulumi.get(self, "resource_properties")

    @resource_properties.setter
    def resource_properties(self, value: Optional[pulumi.Input['AzureKeyVaultPropertiesArgs']]):
        pulumi.set(self, "resource_properties", value)


@pulumi.input_type
class ConfigurationInfoArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[Union[str, 'ActionType']]] = None,
                 additional_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 customized_keys: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None):
        """
        The configuration information, used to generate configurations or save to applications
        :param pulumi.Input[Union[str, 'ActionType']] action: Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_configurations: A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this property is to full fill more customized configurations
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] customized_keys: Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be used for generate configurations
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if additional_configurations is not None:
            pulumi.set(__self__, "additional_configurations", additional_configurations)
        if customized_keys is not None:
            pulumi.set(__self__, "customized_keys", customized_keys)
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'ActionType']]]:
        """
        Optional, indicate whether to apply configurations on source application. If enable, generate configurations and applied to the source application. Default is enable. If optOut, no configuration change will be made on source.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'ActionType']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="additionalConfigurations")
    def additional_configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A dictionary of additional configurations to be added. Service will auto generate a set of basic configurations and this property is to full fill more customized configurations
        """
        return pulumi.get(self, "additional_configurations")

    @additional_configurations.setter
    def additional_configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_configurations", value)

    @property
    @pulumi.getter(name="customizedKeys")
    def customized_keys(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. A dictionary of default key name and customized key name mapping. If not specified, default key name will be used for generate configurations
        """
        return pulumi.get(self, "customized_keys")

    @customized_keys.setter
    def customized_keys(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "customized_keys", value)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)


@pulumi.input_type
class ConfluentBootstrapServerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 endpoint: Optional[pulumi.Input[str]] = None):
        """
        The service properties when target service type is ConfluentBootstrapServer
        :param pulumi.Input[str] type: The target service type.
               Expected value is 'ConfluentBootstrapServer'.
        :param pulumi.Input[str] endpoint: The endpoint of service.
        """
        pulumi.set(__self__, "type", 'ConfluentBootstrapServer')
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The target service type.
        Expected value is 'ConfluentBootstrapServer'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of service.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)


@pulumi.input_type
class ConfluentSchemaRegistryArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 endpoint: Optional[pulumi.Input[str]] = None):
        """
        The service properties when target service type is ConfluentSchemaRegistry
        :param pulumi.Input[str] type: The target service type.
               Expected value is 'ConfluentSchemaRegistry'.
        :param pulumi.Input[str] endpoint: The endpoint of service.
        """
        pulumi.set(__self__, "type", 'ConfluentSchemaRegistry')
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The target service type.
        Expected value is 'ConfluentSchemaRegistry'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of service.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)


@pulumi.input_type
class CreateOrUpdateDryrunParametersArgs:
    def __init__(__self__, *,
                 action_name: pulumi.Input[str],
                 auth_info: Optional[pulumi.Input[Union['AccessKeyInfoBaseArgs', 'SecretAuthInfoArgs', 'ServicePrincipalCertificateAuthInfoArgs', 'ServicePrincipalSecretAuthInfoArgs', 'SystemAssignedIdentityAuthInfoArgs', 'UserAccountAuthInfoArgs', 'UserAssignedIdentityAuthInfoArgs']]] = None,
                 client_type: Optional[pulumi.Input[Union[str, 'ClientType']]] = None,
                 configuration_info: Optional[pulumi.Input['ConfigurationInfoArgs']] = None,
                 public_network_solution: Optional[pulumi.Input['PublicNetworkSolutionArgs']] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 secret_store: Optional[pulumi.Input['SecretStoreArgs']] = None,
                 target_service: Optional[pulumi.Input[Union['AzureResourceArgs', 'ConfluentBootstrapServerArgs', 'ConfluentSchemaRegistryArgs', 'SelfHostedServerArgs']]] = None,
                 v_net_solution: Optional[pulumi.Input['VNetSolutionArgs']] = None):
        """
        The dryrun parameters for creation or update a linker
        :param pulumi.Input[str] action_name: The name of action for you dryrun job.
               Expected value is 'createOrUpdate'.
        :param pulumi.Input[Union['AccessKeyInfoBaseArgs', 'SecretAuthInfoArgs', 'ServicePrincipalCertificateAuthInfoArgs', 'ServicePrincipalSecretAuthInfoArgs', 'SystemAssignedIdentityAuthInfoArgs', 'UserAccountAuthInfoArgs', 'UserAssignedIdentityAuthInfoArgs']] auth_info: The authentication type.
        :param pulumi.Input[Union[str, 'ClientType']] client_type: The application client type
        :param pulumi.Input['ConfigurationInfoArgs'] configuration_info: The connection information consumed by applications, including secrets, connection strings.
        :param pulumi.Input['PublicNetworkSolutionArgs'] public_network_solution: The network solution.
        :param pulumi.Input[str] scope: connection scope in source service.
        :param pulumi.Input['SecretStoreArgs'] secret_store: An option to store secret value in secure place
        :param pulumi.Input[Union['AzureResourceArgs', 'ConfluentBootstrapServerArgs', 'ConfluentSchemaRegistryArgs', 'SelfHostedServerArgs']] target_service: The target service properties
        :param pulumi.Input['VNetSolutionArgs'] v_net_solution: The VNet solution.
        """
        pulumi.set(__self__, "action_name", 'createOrUpdate')
        if auth_info is not None:
            pulumi.set(__self__, "auth_info", auth_info)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if configuration_info is not None:
            pulumi.set(__self__, "configuration_info", configuration_info)
        if public_network_solution is not None:
            pulumi.set(__self__, "public_network_solution", public_network_solution)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)
        if target_service is not None:
            pulumi.set(__self__, "target_service", target_service)
        if v_net_solution is not None:
            pulumi.set(__self__, "v_net_solution", v_net_solution)

    @property
    @pulumi.getter(name="actionName")
    def action_name(self) -> pulumi.Input[str]:
        """
        The name of action for you dryrun job.
        Expected value is 'createOrUpdate'.
        """
        return pulumi.get(self, "action_name")

    @action_name.setter
    def action_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_name", value)

    @property
    @pulumi.getter(name="authInfo")
    def auth_info(self) -> Optional[pulumi.Input[Union['AccessKeyInfoBaseArgs', 'SecretAuthInfoArgs', 'ServicePrincipalCertificateAuthInfoArgs', 'ServicePrincipalSecretAuthInfoArgs', 'SystemAssignedIdentityAuthInfoArgs', 'UserAccountAuthInfoArgs', 'UserAssignedIdentityAuthInfoArgs']]]:
        """
        The authentication type.
        """
        return pulumi.get(self, "auth_info")

    @auth_info.setter
    def auth_info(self, value: Optional[pulumi.Input[Union['AccessKeyInfoBaseArgs', 'SecretAuthInfoArgs', 'ServicePrincipalCertificateAuthInfoArgs', 'ServicePrincipalSecretAuthInfoArgs', 'SystemAssignedIdentityAuthInfoArgs', 'UserAccountAuthInfoArgs', 'UserAssignedIdentityAuthInfoArgs']]]):
        pulumi.set(self, "auth_info", value)

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[Union[str, 'ClientType']]]:
        """
        The application client type
        """
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[Union[str, 'ClientType']]]):
        pulumi.set(self, "client_type", value)

    @property
    @pulumi.getter(name="configurationInfo")
    def configuration_info(self) -> Optional[pulumi.Input['ConfigurationInfoArgs']]:
        """
        The connection information consumed by applications, including secrets, connection strings.
        """
        return pulumi.get(self, "configuration_info")

    @configuration_info.setter
    def configuration_info(self, value: Optional[pulumi.Input['ConfigurationInfoArgs']]):
        pulumi.set(self, "configuration_info", value)

    @property
    @pulumi.getter(name="publicNetworkSolution")
    def public_network_solution(self) -> Optional[pulumi.Input['PublicNetworkSolutionArgs']]:
        """
        The network solution.
        """
        return pulumi.get(self, "public_network_solution")

    @public_network_solution.setter
    def public_network_solution(self, value: Optional[pulumi.Input['PublicNetworkSolutionArgs']]):
        pulumi.set(self, "public_network_solution", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        connection scope in source service.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[pulumi.Input['SecretStoreArgs']]:
        """
        An option to store secret value in secure place
        """
        return pulumi.get(self, "secret_store")

    @secret_store.setter
    def secret_store(self, value: Optional[pulumi.Input['SecretStoreArgs']]):
        pulumi.set(self, "secret_store", value)

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> Optional[pulumi.Input[Union['AzureResourceArgs', 'ConfluentBootstrapServerArgs', 'ConfluentSchemaRegistryArgs', 'SelfHostedServerArgs']]]:
        """
        The target service properties
        """
        return pulumi.get(self, "target_service")

    @target_service.setter
    def target_service(self, value: Optional[pulumi.Input[Union['AzureResourceArgs', 'ConfluentBootstrapServerArgs', 'ConfluentSchemaRegistryArgs', 'SelfHostedServerArgs']]]):
        pulumi.set(self, "target_service", value)

    @property
    @pulumi.getter(name="vNetSolution")
    def v_net_solution(self) -> Optional[pulumi.Input['VNetSolutionArgs']]:
        """
        The VNet solution.
        """
        return pulumi.get(self, "v_net_solution")

    @v_net_solution.setter
    def v_net_solution(self, value: Optional[pulumi.Input['VNetSolutionArgs']]):
        pulumi.set(self, "v_net_solution", value)


@pulumi.input_type
class FirewallRulesArgs:
    def __init__(__self__, *,
                 azure_services: Optional[pulumi.Input[Union[str, 'AllowType']]] = None,
                 caller_client_ip: Optional[pulumi.Input[Union[str, 'AllowType']]] = None,
                 ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Target service's firewall rules. to allow connections from source service.
        :param pulumi.Input[Union[str, 'AllowType']] azure_services: Allow Azure services to access the target service if true.
        :param pulumi.Input[Union[str, 'AllowType']] caller_client_ip: Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_ranges: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
        """
        if azure_services is not None:
            pulumi.set(__self__, "azure_services", azure_services)
        if caller_client_ip is not None:
            pulumi.set(__self__, "caller_client_ip", caller_client_ip)
        if ip_ranges is not None:
            pulumi.set(__self__, "ip_ranges", ip_ranges)

    @property
    @pulumi.getter(name="azureServices")
    def azure_services(self) -> Optional[pulumi.Input[Union[str, 'AllowType']]]:
        """
        Allow Azure services to access the target service if true.
        """
        return pulumi.get(self, "azure_services")

    @azure_services.setter
    def azure_services(self, value: Optional[pulumi.Input[Union[str, 'AllowType']]]):
        pulumi.set(self, "azure_services", value)

    @property
    @pulumi.getter(name="callerClientIP")
    def caller_client_ip(self) -> Optional[pulumi.Input[Union[str, 'AllowType']]]:
        """
        Allow caller client IP to access the target service if true. the property is used when connecting local application to target service.
        """
        return pulumi.get(self, "caller_client_ip")

    @caller_client_ip.setter
    def caller_client_ip(self, value: Optional[pulumi.Input[Union[str, 'AllowType']]]):
        pulumi.set(self, "caller_client_ip", value)

    @property
    @pulumi.getter(name="ipRanges")
    def ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account.
        """
        return pulumi.get(self, "ip_ranges")

    @ip_ranges.setter
    def ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_ranges", value)


@pulumi.input_type
class KeyVaultSecretReferenceSecretInfoArgs:
    def __init__(__self__, *,
                 secret_type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The secret info when type is keyVaultSecretReference. It's for scenario that user provides a secret stored in user's keyvault and source is Azure Kubernetes. The key Vault's resource id is linked to secretStore.keyVaultId.
        :param pulumi.Input[str] secret_type: The secret type.
               Expected value is 'keyVaultSecretReference'.
        :param pulumi.Input[str] name: Name of the Key Vault secret.
        :param pulumi.Input[str] version: Version of the Key Vault secret.
        """
        pulumi.set(__self__, "secret_type", 'keyVaultSecretReference')
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Input[str]:
        """
        The secret type.
        Expected value is 'keyVaultSecretReference'.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Key Vault secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the Key Vault secret.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class KeyVaultSecretUriSecretInfoArgs:
    def __init__(__self__, *,
                 secret_type: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        The secret info when type is keyVaultSecretUri. It's for scenario that user provides a secret stored in user's keyvault and source is Web App, Spring Cloud or Container App.
        :param pulumi.Input[str] secret_type: The secret type.
               Expected value is 'keyVaultSecretUri'.
        :param pulumi.Input[str] value: URI to the keyvault secret
        """
        pulumi.set(__self__, "secret_type", 'keyVaultSecretUri')
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Input[str]:
        """
        The secret type.
        Expected value is 'keyVaultSecretUri'.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        URI to the keyvault secret
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PublicNetworkSolutionArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[Union[str, 'ActionType']]] = None,
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None,
                 firewall_rules: Optional[pulumi.Input['FirewallRulesArgs']] = None):
        """
        Indicates public network solution, include firewall rules
        :param pulumi.Input[Union[str, 'ActionType']] action: Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
        :param pulumi.Input['FirewallRulesArgs'] firewall_rules: Describe firewall rules of target service to make sure source application could connect to the target.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)
        if firewall_rules is not None:
            pulumi.set(__self__, "firewall_rules", firewall_rules)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'ActionType']]]:
        """
        Optional. Indicates public network solution. If enable, enable public network access of target service with best try. Default is enable. If optOut, opt out public network access configuration.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'ActionType']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation(such as firewall rules) when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)

    @property
    @pulumi.getter(name="firewallRules")
    def firewall_rules(self) -> Optional[pulumi.Input['FirewallRulesArgs']]:
        """
        Describe firewall rules of target service to make sure source application could connect to the target.
        """
        return pulumi.get(self, "firewall_rules")

    @firewall_rules.setter
    def firewall_rules(self, value: Optional[pulumi.Input['FirewallRulesArgs']]):
        pulumi.set(self, "firewall_rules", value)


@pulumi.input_type
class SecretAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 secret_info: Optional[pulumi.Input[Union['KeyVaultSecretReferenceSecretInfoArgs', 'KeyVaultSecretUriSecretInfoArgs', 'ValueSecretInfoArgs']]] = None):
        """
        The authentication info when authType is secret
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'secret'.
        :param pulumi.Input[str] name: Username or account name for secret auth.
        :param pulumi.Input[Union['KeyVaultSecretReferenceSecretInfoArgs', 'KeyVaultSecretUriSecretInfoArgs', 'ValueSecretInfoArgs']] secret_info: Password or key vault secret for secret auth.
        """
        pulumi.set(__self__, "auth_type", 'secret')
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_info is not None:
            pulumi.set(__self__, "secret_info", secret_info)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'secret'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Username or account name for secret auth.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretInfo")
    def secret_info(self) -> Optional[pulumi.Input[Union['KeyVaultSecretReferenceSecretInfoArgs', 'KeyVaultSecretUriSecretInfoArgs', 'ValueSecretInfoArgs']]]:
        """
        Password or key vault secret for secret auth.
        """
        return pulumi.get(self, "secret_info")

    @secret_info.setter
    def secret_info(self, value: Optional[pulumi.Input[Union['KeyVaultSecretReferenceSecretInfoArgs', 'KeyVaultSecretUriSecretInfoArgs', 'ValueSecretInfoArgs']]]):
        pulumi.set(self, "secret_info", value)


@pulumi.input_type
class SecretStoreArgs:
    def __init__(__self__, *,
                 key_vault_id: Optional[pulumi.Input[str]] = None,
                 key_vault_secret_name: Optional[pulumi.Input[str]] = None):
        """
        An option to store secret value in secure place
        :param pulumi.Input[str] key_vault_id: The key vault id to store secret
        :param pulumi.Input[str] key_vault_secret_name: The key vault secret name to store secret, only valid when storing one secret
        """
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_vault_secret_name is not None:
            pulumi.set(__self__, "key_vault_secret_name", key_vault_secret_name)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The key vault id to store secret
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter(name="keyVaultSecretName")
    def key_vault_secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        The key vault secret name to store secret, only valid when storing one secret
        """
        return pulumi.get(self, "key_vault_secret_name")

    @key_vault_secret_name.setter
    def key_vault_secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_secret_name", value)


@pulumi.input_type
class SelfHostedServerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 endpoint: Optional[pulumi.Input[str]] = None):
        """
        The service properties when target service type is SelfHostedServer
        :param pulumi.Input[str] type: The target service type.
               Expected value is 'SelfHostedServer'.
        :param pulumi.Input[str] endpoint: The endpoint of service.
        """
        pulumi.set(__self__, "type", 'SelfHostedServer')
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The target service type.
        Expected value is 'SelfHostedServer'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of service.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)


@pulumi.input_type
class ServicePrincipalCertificateAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 certificate: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 principal_id: pulumi.Input[str],
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The authentication info when authType is servicePrincipal certificate
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'servicePrincipalCertificate'.
        :param pulumi.Input[str] certificate: ServicePrincipal certificate for servicePrincipal auth.
        :param pulumi.Input[str] client_id: Application clientId for servicePrincipal auth.
        :param pulumi.Input[str] principal_id: Principal Id for servicePrincipal auth.
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation when Linker is updating or deleting
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Optional, this value specifies the Azure roles to be assigned. Automatically 
        """
        pulumi.set(__self__, "auth_type", 'servicePrincipalCertificate')
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'servicePrincipalCertificate'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        ServicePrincipal certificate for servicePrincipal auth.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        Application clientId for servicePrincipal auth.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        Principal Id for servicePrincipal auth.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional, this value specifies the Azure roles to be assigned. Automatically 
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class ServicePrincipalSecretAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 client_id: pulumi.Input[str],
                 principal_id: pulumi.Input[str],
                 secret: pulumi.Input[str],
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        The authentication info when authType is servicePrincipal secret
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'servicePrincipalSecret'.
        :param pulumi.Input[str] client_id: ServicePrincipal application clientId for servicePrincipal auth.
        :param pulumi.Input[str] principal_id: Principal Id for servicePrincipal auth.
        :param pulumi.Input[str] secret: Secret for servicePrincipal auth.
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation when Linker is updating or deleting
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Optional, this value specifies the Azure roles to be assigned. Automatically 
        :param pulumi.Input[str] user_name: Username created in the database which is mapped to a user in AAD.
        """
        pulumi.set(__self__, "auth_type", 'servicePrincipalSecret')
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "secret", secret)
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'servicePrincipalSecret'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        ServicePrincipal application clientId for servicePrincipal auth.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        Principal Id for servicePrincipal auth.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Secret for servicePrincipal auth.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional, this value specifies the Azure roles to be assigned. Automatically 
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username created in the database which is mapped to a user in AAD.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class SystemAssignedIdentityAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        The authentication info when authType is systemAssignedIdentity
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'systemAssignedIdentity'.
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation when Linker is updating or deleting
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Optional, this value specifies the Azure role to be assigned
        :param pulumi.Input[str] user_name: Username created in the database which is mapped to a user in AAD.
        """
        pulumi.set(__self__, "auth_type", 'systemAssignedIdentity')
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'systemAssignedIdentity'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional, this value specifies the Azure role to be assigned
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username created in the database which is mapped to a user in AAD.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class UserAccountAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        The authentication info when authType is user account
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'userAccount'.
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation when Linker is updating or deleting
        :param pulumi.Input[str] principal_id: Principal Id for user account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Optional, this value specifies the Azure roles to be assigned. Automatically 
        :param pulumi.Input[str] user_name: Username created in the database which is mapped to a user in AAD.
        """
        pulumi.set(__self__, "auth_type", 'userAccount')
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'userAccount'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Principal Id for user account.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional, this value specifies the Azure roles to be assigned. Automatically 
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username created in the database which is mapped to a user in AAD.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class UserAssignedIdentityAuthInfoArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 client_id: Optional[pulumi.Input[str]] = None,
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        The authentication info when authType is userAssignedIdentity
        :param pulumi.Input[str] auth_type: The authentication type.
               Expected value is 'userAssignedIdentity'.
        :param pulumi.Input[str] client_id: Client Id for userAssignedIdentity.
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation when Linker is updating or deleting
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Optional, this value specifies the Azure role to be assigned
        :param pulumi.Input[str] subscription_id: Subscription id for userAssignedIdentity.
        :param pulumi.Input[str] user_name: Username created in the database which is mapped to a user in AAD.
        """
        pulumi.set(__self__, "auth_type", 'userAssignedIdentity')
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        The authentication type.
        Expected value is 'userAssignedIdentity'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client Id for userAssignedIdentity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional, this value specifies the Azure role to be assigned
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription id for userAssignedIdentity.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username created in the database which is mapped to a user in AAD.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class VNetSolutionArgs:
    def __init__(__self__, *,
                 delete_or_update_behavior: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]] = None,
                 type: Optional[pulumi.Input[Union[str, 'VNetSolutionType']]] = None):
        """
        The VNet solution for linker
        :param pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']] delete_or_update_behavior: Indicates whether to clean up previous operation when Linker is updating or deleting
        :param pulumi.Input[Union[str, 'VNetSolutionType']] type: Type of VNet solution.
        """
        if delete_or_update_behavior is not None:
            pulumi.set(__self__, "delete_or_update_behavior", delete_or_update_behavior)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="deleteOrUpdateBehavior")
    def delete_or_update_behavior(self) -> Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]:
        """
        Indicates whether to clean up previous operation when Linker is updating or deleting
        """
        return pulumi.get(self, "delete_or_update_behavior")

    @delete_or_update_behavior.setter
    def delete_or_update_behavior(self, value: Optional[pulumi.Input[Union[str, 'DeleteOrUpdateBehavior']]]):
        pulumi.set(self, "delete_or_update_behavior", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'VNetSolutionType']]]:
        """
        Type of VNet solution.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'VNetSolutionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ValueSecretInfoArgs:
    def __init__(__self__, *,
                 secret_type: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        The secret info when type is rawValue. It's for scenarios that user input the secret.
        :param pulumi.Input[str] secret_type: The secret type.
               Expected value is 'rawValue'.
        :param pulumi.Input[str] value: The actual value of the secret.
        """
        pulumi.set(__self__, "secret_type", 'rawValue')
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Input[str]:
        """
        The secret type.
        Expected value is 'rawValue'.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The actual value of the secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


