# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetIntegrationServiceEnvironmentManagedApiResult',
    'AwaitableGetIntegrationServiceEnvironmentManagedApiResult',
    'get_integration_service_environment_managed_api',
    'get_integration_service_environment_managed_api_output',
]

@pulumi.output_type
class GetIntegrationServiceEnvironmentManagedApiResult:
    """
    The integration service environment managed api.
    """
    def __init__(__self__, api_definition_url=None, api_definitions=None, backend_service=None, capabilities=None, category=None, connection_parameters=None, deployment_parameters=None, general_information=None, id=None, integration_service_environment=None, location=None, metadata=None, name=None, policies=None, provisioning_state=None, runtime_urls=None, tags=None, type=None):
        if api_definition_url and not isinstance(api_definition_url, str):
            raise TypeError("Expected argument 'api_definition_url' to be a str")
        pulumi.set(__self__, "api_definition_url", api_definition_url)
        if api_definitions and not isinstance(api_definitions, dict):
            raise TypeError("Expected argument 'api_definitions' to be a dict")
        pulumi.set(__self__, "api_definitions", api_definitions)
        if backend_service and not isinstance(backend_service, dict):
            raise TypeError("Expected argument 'backend_service' to be a dict")
        pulumi.set(__self__, "backend_service", backend_service)
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if connection_parameters and not isinstance(connection_parameters, dict):
            raise TypeError("Expected argument 'connection_parameters' to be a dict")
        pulumi.set(__self__, "connection_parameters", connection_parameters)
        if deployment_parameters and not isinstance(deployment_parameters, dict):
            raise TypeError("Expected argument 'deployment_parameters' to be a dict")
        pulumi.set(__self__, "deployment_parameters", deployment_parameters)
        if general_information and not isinstance(general_information, dict):
            raise TypeError("Expected argument 'general_information' to be a dict")
        pulumi.set(__self__, "general_information", general_information)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integration_service_environment and not isinstance(integration_service_environment, dict):
            raise TypeError("Expected argument 'integration_service_environment' to be a dict")
        pulumi.set(__self__, "integration_service_environment", integration_service_environment)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policies and not isinstance(policies, dict):
            raise TypeError("Expected argument 'policies' to be a dict")
        pulumi.set(__self__, "policies", policies)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if runtime_urls and not isinstance(runtime_urls, list):
            raise TypeError("Expected argument 'runtime_urls' to be a list")
        pulumi.set(__self__, "runtime_urls", runtime_urls)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="apiDefinitionUrl")
    def api_definition_url(self) -> str:
        """
        The API definition.
        """
        return pulumi.get(self, "api_definition_url")

    @property
    @pulumi.getter(name="apiDefinitions")
    def api_definitions(self) -> 'outputs.ApiResourceDefinitionsResponse':
        """
        The api definitions.
        """
        return pulumi.get(self, "api_definitions")

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> 'outputs.ApiResourceBackendServiceResponse':
        """
        The backend service.
        """
        return pulumi.get(self, "backend_service")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence[str]:
        """
        The capabilities.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="connectionParameters")
    def connection_parameters(self) -> Mapping[str, Any]:
        """
        The connection parameters.
        """
        return pulumi.get(self, "connection_parameters")

    @property
    @pulumi.getter(name="deploymentParameters")
    def deployment_parameters(self) -> Optional['outputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersResponse']:
        """
        The integration service environment managed api deployment parameters.
        """
        return pulumi.get(self, "deployment_parameters")

    @property
    @pulumi.getter(name="generalInformation")
    def general_information(self) -> 'outputs.ApiResourceGeneralInformationResponse':
        """
        The api general information.
        """
        return pulumi.get(self, "general_information")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integrationServiceEnvironment")
    def integration_service_environment(self) -> Optional['outputs.ResourceReferenceResponse']:
        """
        The integration service environment reference.
        """
        return pulumi.get(self, "integration_service_environment")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.ApiResourceMetadataResponse':
        """
        The metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets the resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policies(self) -> 'outputs.ApiResourcePoliciesResponse':
        """
        The policies for the API.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="runtimeUrls")
    def runtime_urls(self) -> Sequence[str]:
        """
        The runtime urls.
        """
        return pulumi.get(self, "runtime_urls")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Gets the resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetIntegrationServiceEnvironmentManagedApiResult(GetIntegrationServiceEnvironmentManagedApiResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIntegrationServiceEnvironmentManagedApiResult(
            api_definition_url=self.api_definition_url,
            api_definitions=self.api_definitions,
            backend_service=self.backend_service,
            capabilities=self.capabilities,
            category=self.category,
            connection_parameters=self.connection_parameters,
            deployment_parameters=self.deployment_parameters,
            general_information=self.general_information,
            id=self.id,
            integration_service_environment=self.integration_service_environment,
            location=self.location,
            metadata=self.metadata,
            name=self.name,
            policies=self.policies,
            provisioning_state=self.provisioning_state,
            runtime_urls=self.runtime_urls,
            tags=self.tags,
            type=self.type)


def get_integration_service_environment_managed_api(api_name: Optional[str] = None,
                                                    integration_service_environment_name: Optional[str] = None,
                                                    resource_group: Optional[str] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIntegrationServiceEnvironmentManagedApiResult:
    """
    The integration service environment managed api.


    :param str api_name: The api name.
    :param str integration_service_environment_name: The integration service environment name.
    :param str resource_group: The resource group name.
    """
    __args__ = dict()
    __args__['apiName'] = api_name
    __args__['integrationServiceEnvironmentName'] = integration_service_environment_name
    __args__['resourceGroup'] = resource_group
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:logic/v20190501:getIntegrationServiceEnvironmentManagedApi', __args__, opts=opts, typ=GetIntegrationServiceEnvironmentManagedApiResult).value

    return AwaitableGetIntegrationServiceEnvironmentManagedApiResult(
        api_definition_url=__ret__.api_definition_url,
        api_definitions=__ret__.api_definitions,
        backend_service=__ret__.backend_service,
        capabilities=__ret__.capabilities,
        category=__ret__.category,
        connection_parameters=__ret__.connection_parameters,
        deployment_parameters=__ret__.deployment_parameters,
        general_information=__ret__.general_information,
        id=__ret__.id,
        integration_service_environment=__ret__.integration_service_environment,
        location=__ret__.location,
        metadata=__ret__.metadata,
        name=__ret__.name,
        policies=__ret__.policies,
        provisioning_state=__ret__.provisioning_state,
        runtime_urls=__ret__.runtime_urls,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_integration_service_environment_managed_api)
def get_integration_service_environment_managed_api_output(api_name: Optional[pulumi.Input[str]] = None,
                                                           integration_service_environment_name: Optional[pulumi.Input[str]] = None,
                                                           resource_group: Optional[pulumi.Input[str]] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIntegrationServiceEnvironmentManagedApiResult]:
    """
    The integration service environment managed api.


    :param str api_name: The api name.
    :param str integration_service_environment_name: The integration service environment name.
    :param str resource_group: The resource group name.
    """
    ...
