# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AddonArcPropertiesArgs',
    'AddonHcxPropertiesArgs',
    'AddonSrmPropertiesArgs',
    'AddonVrPropertiesArgs',
    'AvailabilityPropertiesArgs',
    'DiskPoolVolumeArgs',
    'EncryptionKeyVaultPropertiesArgs',
    'EncryptionArgs',
    'IdentitySourceArgs',
    'ManagementClusterArgs',
    'NetAppVolumeArgs',
    'PSCredentialExecutionParameterArgs',
    'PrivateCloudIdentityArgs',
    'ScriptSecureStringExecutionParameterArgs',
    'ScriptStringExecutionParameterArgs',
    'SkuArgs',
    'VmHostPlacementPolicyPropertiesArgs',
    'VmVmPlacementPolicyPropertiesArgs',
    'WorkloadNetworkDhcpRelayArgs',
    'WorkloadNetworkDhcpServerArgs',
    'WorkloadNetworkSegmentSubnetArgs',
]

@pulumi.input_type
class AddonArcPropertiesArgs:
    def __init__(__self__, *,
                 addon_type: pulumi.Input[str],
                 v_center: Optional[pulumi.Input[str]] = None):
        """
        The properties of an Arc addon
        :param pulumi.Input[str] addon_type: The type of private cloud addon
               Expected value is 'Arc'.
        :param pulumi.Input[str] v_center: The VMware vCenter resource ID
        """
        pulumi.set(__self__, "addon_type", 'Arc')
        if v_center is not None:
            pulumi.set(__self__, "v_center", v_center)

    @property
    @pulumi.getter(name="addonType")
    def addon_type(self) -> pulumi.Input[str]:
        """
        The type of private cloud addon
        Expected value is 'Arc'.
        """
        return pulumi.get(self, "addon_type")

    @addon_type.setter
    def addon_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_type", value)

    @property
    @pulumi.getter(name="vCenter")
    def v_center(self) -> Optional[pulumi.Input[str]]:
        """
        The VMware vCenter resource ID
        """
        return pulumi.get(self, "v_center")

    @v_center.setter
    def v_center(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_center", value)


@pulumi.input_type
class AddonHcxPropertiesArgs:
    def __init__(__self__, *,
                 addon_type: pulumi.Input[str],
                 offer: pulumi.Input[str]):
        """
        The properties of an HCX addon
        :param pulumi.Input[str] addon_type: The type of private cloud addon
               Expected value is 'HCX'.
        :param pulumi.Input[str] offer: The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
        """
        pulumi.set(__self__, "addon_type", 'HCX')
        pulumi.set(__self__, "offer", offer)

    @property
    @pulumi.getter(name="addonType")
    def addon_type(self) -> pulumi.Input[str]:
        """
        The type of private cloud addon
        Expected value is 'HCX'.
        """
        return pulumi.get(self, "addon_type")

    @addon_type.setter
    def addon_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_type", value)

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Input[str]:
        """
        The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[str]):
        pulumi.set(self, "offer", value)


@pulumi.input_type
class AddonSrmPropertiesArgs:
    def __init__(__self__, *,
                 addon_type: pulumi.Input[str],
                 license_key: Optional[pulumi.Input[str]] = None):
        """
        The properties of a Site Recovery Manager (SRM) addon
        :param pulumi.Input[str] addon_type: The type of private cloud addon
               Expected value is 'SRM'.
        :param pulumi.Input[str] license_key: The Site Recovery Manager (SRM) license
        """
        pulumi.set(__self__, "addon_type", 'SRM')
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)

    @property
    @pulumi.getter(name="addonType")
    def addon_type(self) -> pulumi.Input[str]:
        """
        The type of private cloud addon
        Expected value is 'SRM'.
        """
        return pulumi.get(self, "addon_type")

    @addon_type.setter
    def addon_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_type", value)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Site Recovery Manager (SRM) license
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_key", value)


@pulumi.input_type
class AddonVrPropertiesArgs:
    def __init__(__self__, *,
                 addon_type: pulumi.Input[str],
                 vrs_count: pulumi.Input[int]):
        """
        The properties of a vSphere Replication (VR) addon
        :param pulumi.Input[str] addon_type: The type of private cloud addon
               Expected value is 'VR'.
        :param pulumi.Input[int] vrs_count: The vSphere Replication Server (VRS) count
        """
        pulumi.set(__self__, "addon_type", 'VR')
        pulumi.set(__self__, "vrs_count", vrs_count)

    @property
    @pulumi.getter(name="addonType")
    def addon_type(self) -> pulumi.Input[str]:
        """
        The type of private cloud addon
        Expected value is 'VR'.
        """
        return pulumi.get(self, "addon_type")

    @addon_type.setter
    def addon_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "addon_type", value)

    @property
    @pulumi.getter(name="vrsCount")
    def vrs_count(self) -> pulumi.Input[int]:
        """
        The vSphere Replication Server (VRS) count
        """
        return pulumi.get(self, "vrs_count")

    @vrs_count.setter
    def vrs_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "vrs_count", value)


@pulumi.input_type
class AvailabilityPropertiesArgs:
    def __init__(__self__, *,
                 secondary_zone: Optional[pulumi.Input[int]] = None,
                 strategy: Optional[pulumi.Input[Union[str, 'AvailabilityStrategy']]] = None,
                 zone: Optional[pulumi.Input[int]] = None):
        """
        The properties describing private cloud availability zone distribution
        :param pulumi.Input[int] secondary_zone: The secondary availability zone for the private cloud
        :param pulumi.Input[Union[str, 'AvailabilityStrategy']] strategy: The availability strategy for the private cloud
        :param pulumi.Input[int] zone: The primary availability zone for the private cloud
        """
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[pulumi.Input[int]]:
        """
        The secondary availability zone for the private cloud
        """
        return pulumi.get(self, "secondary_zone")

    @secondary_zone.setter
    def secondary_zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "secondary_zone", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[Union[str, 'AvailabilityStrategy']]]:
        """
        The availability strategy for the private cloud
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[Union[str, 'AvailabilityStrategy']]]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[int]]:
        """
        The primary availability zone for the private cloud
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class DiskPoolVolumeArgs:
    def __init__(__self__, *,
                 lun_name: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 mount_option: Optional[pulumi.Input[Union[str, 'MountOptionEnum']]] = None):
        """
        An iSCSI volume from Microsoft.StoragePool provider
        :param pulumi.Input[str] lun_name: Name of the LUN to be used for datastore
        :param pulumi.Input[str] target_id: Azure resource ID of the iSCSI target
        :param pulumi.Input[Union[str, 'MountOptionEnum']] mount_option: Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
        """
        pulumi.set(__self__, "lun_name", lun_name)
        pulumi.set(__self__, "target_id", target_id)
        if mount_option is None:
            mount_option = 'MOUNT'
        if mount_option is not None:
            pulumi.set(__self__, "mount_option", mount_option)

    @property
    @pulumi.getter(name="lunName")
    def lun_name(self) -> pulumi.Input[str]:
        """
        Name of the LUN to be used for datastore
        """
        return pulumi.get(self, "lun_name")

    @lun_name.setter
    def lun_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "lun_name", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        Azure resource ID of the iSCSI target
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="mountOption")
    def mount_option(self) -> Optional[pulumi.Input[Union[str, 'MountOptionEnum']]]:
        """
        Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
        """
        return pulumi.get(self, "mount_option")

    @mount_option.setter
    def mount_option(self, value: Optional[pulumi.Input[Union[str, 'MountOptionEnum']]]):
        pulumi.set(self, "mount_option", value)


@pulumi.input_type
class EncryptionKeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_vault_url: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None):
        """
        An Encryption Key
        :param pulumi.Input[str] key_name: The name of the key.
        :param pulumi.Input[str] key_vault_url: The URL of the vault.
        :param pulumi.Input[str] key_version: The version of the key.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_url is not None:
            pulumi.set(__self__, "key_vault_url", key_vault_url)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVaultUrl")
    def key_vault_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the vault.
        """
        return pulumi.get(self, "key_vault_url")

    @key_vault_url.setter
    def key_vault_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_url", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the key.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)


@pulumi.input_type
class EncryptionArgs:
    def __init__(__self__, *,
                 key_vault_properties: Optional[pulumi.Input['EncryptionKeyVaultPropertiesArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'EncryptionState']]] = None):
        """
        The properties of customer managed encryption key
        :param pulumi.Input['EncryptionKeyVaultPropertiesArgs'] key_vault_properties: The key vault where the encryption key is stored
        :param pulumi.Input[Union[str, 'EncryptionState']] status: Status of customer managed encryption key
        """
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['EncryptionKeyVaultPropertiesArgs']]:
        """
        The key vault where the encryption key is stored
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['EncryptionKeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'EncryptionState']]]:
        """
        Status of customer managed encryption key
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'EncryptionState']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class IdentitySourceArgs:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 base_group_dn: Optional[pulumi.Input[str]] = None,
                 base_user_dn: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 primary_server: Optional[pulumi.Input[str]] = None,
                 secondary_server: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[Union[str, 'SslEnum']]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        vCenter Single Sign On Identity Source
        :param pulumi.Input[str] alias: The domain's NetBIOS name
        :param pulumi.Input[str] base_group_dn: The base distinguished name for groups
        :param pulumi.Input[str] base_user_dn: The base distinguished name for users
        :param pulumi.Input[str] domain: The domain's dns name
        :param pulumi.Input[str] name: The name of the identity source
        :param pulumi.Input[str] password: The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
        :param pulumi.Input[str] primary_server: Primary server URL
        :param pulumi.Input[str] secondary_server: Secondary server URL
        :param pulumi.Input[Union[str, 'SslEnum']] ssl: Protect LDAP communication using SSL certificate (LDAPS)
        :param pulumi.Input[str] username: The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if base_group_dn is not None:
            pulumi.set(__self__, "base_group_dn", base_group_dn)
        if base_user_dn is not None:
            pulumi.set(__self__, "base_user_dn", base_user_dn)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if primary_server is not None:
            pulumi.set(__self__, "primary_server", primary_server)
        if secondary_server is not None:
            pulumi.set(__self__, "secondary_server", secondary_server)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        The domain's NetBIOS name
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="baseGroupDN")
    def base_group_dn(self) -> Optional[pulumi.Input[str]]:
        """
        The base distinguished name for groups
        """
        return pulumi.get(self, "base_group_dn")

    @base_group_dn.setter
    def base_group_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_group_dn", value)

    @property
    @pulumi.getter(name="baseUserDN")
    def base_user_dn(self) -> Optional[pulumi.Input[str]]:
        """
        The base distinguished name for users
        """
        return pulumi.get(self, "base_user_dn")

    @base_user_dn.setter
    def base_user_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_user_dn", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain's dns name
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the identity source
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="primaryServer")
    def primary_server(self) -> Optional[pulumi.Input[str]]:
        """
        Primary server URL
        """
        return pulumi.get(self, "primary_server")

    @primary_server.setter
    def primary_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_server", value)

    @property
    @pulumi.getter(name="secondaryServer")
    def secondary_server(self) -> Optional[pulumi.Input[str]]:
        """
        Secondary server URL
        """
        return pulumi.get(self, "secondary_server")

    @secondary_server.setter
    def secondary_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_server", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[Union[str, 'SslEnum']]]:
        """
        Protect LDAP communication using SSL certificate (LDAPS)
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[Union[str, 'SslEnum']]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ManagementClusterArgs:
    def __init__(__self__, *,
                 cluster_size: pulumi.Input[int],
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The properties of a management cluster
        :param pulumi.Input[int] cluster_size: The cluster size
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: The hosts
        """
        pulumi.set(__self__, "cluster_size", cluster_size)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Input[int]:
        """
        The cluster size
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The hosts
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosts", value)


@pulumi.input_type
class NetAppVolumeArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        An Azure NetApp Files volume from Microsoft.NetApp provider
        :param pulumi.Input[str] id: Azure resource ID of the NetApp volume
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Azure resource ID of the NetApp volume
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PSCredentialExecutionParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        a powershell credential object
        :param pulumi.Input[str] name: The parameter name
        :param pulumi.Input[str] type: The type of execution parameter
               Expected value is 'Credential'.
        :param pulumi.Input[str] password: password for login
        :param pulumi.Input[str] username: username for login
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Credential')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of execution parameter
        Expected value is 'Credential'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        password for login
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        username for login
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class PrivateCloudIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]] = None):
        """
        Identity for the virtual machine.
        :param pulumi.Input[Union[str, 'ResourceIdentityType']] type: The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]:
        """
        The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The type 'None' will remove any identities from the Private Cloud.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ScriptSecureStringExecutionParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 secure_value: Optional[pulumi.Input[str]] = None):
        """
        a plain text value execution parameter
        :param pulumi.Input[str] name: The parameter name
        :param pulumi.Input[str] type: The type of execution parameter
               Expected value is 'SecureValue'.
        :param pulumi.Input[str] secure_value: A secure value for the passed parameter, not to be stored in logs
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'SecureValue')
        if secure_value is not None:
            pulumi.set(__self__, "secure_value", secure_value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of execution parameter
        Expected value is 'SecureValue'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="secureValue")
    def secure_value(self) -> Optional[pulumi.Input[str]]:
        """
        A secure value for the passed parameter, not to be stored in logs
        """
        return pulumi.get(self, "secure_value")

    @secure_value.setter
    def secure_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secure_value", value)


@pulumi.input_type
class ScriptStringExecutionParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        a plain text value execution parameter
        :param pulumi.Input[str] name: The parameter name
        :param pulumi.Input[str] type: The type of execution parameter
               Expected value is 'Value'.
        :param pulumi.Input[str] value: The value for the passed parameter
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'Value')
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The parameter name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of execution parameter
        Expected value is 'Value'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value for the passed parameter
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        The resource model definition representing SKU
        :param pulumi.Input[str] name: The name of the SKU.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VmHostPlacementPolicyPropertiesArgs:
    def __init__(__self__, *,
                 affinity_type: pulumi.Input[Union[str, 'AffinityType']],
                 host_members: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 vm_members: pulumi.Input[Sequence[pulumi.Input[str]]],
                 affinity_strength: Optional[pulumi.Input[Union[str, 'AffinityStrength']]] = None,
                 azure_hybrid_benefit_type: Optional[pulumi.Input[Union[str, 'AzureHybridBenefitType']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]] = None):
        """
        VM-Host placement policy properties
        :param pulumi.Input[Union[str, 'AffinityType']] affinity_type: placement policy affinity type
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_members: Host members list
        :param pulumi.Input[str] type: placement policy type
               Expected value is 'VmHost'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vm_members: Virtual machine members list
        :param pulumi.Input[Union[str, 'AffinityStrength']] affinity_strength: vm-host placement policy affinity strength (should/must)
        :param pulumi.Input[Union[str, 'AzureHybridBenefitType']] azure_hybrid_benefit_type: placement policy azure hybrid benefit opt-in type
        :param pulumi.Input[str] display_name: Display name of the placement policy
        :param pulumi.Input[Union[str, 'PlacementPolicyState']] state: Whether the placement policy is enabled or disabled
        """
        pulumi.set(__self__, "affinity_type", affinity_type)
        pulumi.set(__self__, "host_members", host_members)
        pulumi.set(__self__, "type", 'VmHost')
        pulumi.set(__self__, "vm_members", vm_members)
        if affinity_strength is not None:
            pulumi.set(__self__, "affinity_strength", affinity_strength)
        if azure_hybrid_benefit_type is not None:
            pulumi.set(__self__, "azure_hybrid_benefit_type", azure_hybrid_benefit_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="affinityType")
    def affinity_type(self) -> pulumi.Input[Union[str, 'AffinityType']]:
        """
        placement policy affinity type
        """
        return pulumi.get(self, "affinity_type")

    @affinity_type.setter
    def affinity_type(self, value: pulumi.Input[Union[str, 'AffinityType']]):
        pulumi.set(self, "affinity_type", value)

    @property
    @pulumi.getter(name="hostMembers")
    def host_members(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Host members list
        """
        return pulumi.get(self, "host_members")

    @host_members.setter
    def host_members(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "host_members", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        placement policy type
        Expected value is 'VmHost'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vmMembers")
    def vm_members(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Virtual machine members list
        """
        return pulumi.get(self, "vm_members")

    @vm_members.setter
    def vm_members(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vm_members", value)

    @property
    @pulumi.getter(name="affinityStrength")
    def affinity_strength(self) -> Optional[pulumi.Input[Union[str, 'AffinityStrength']]]:
        """
        vm-host placement policy affinity strength (should/must)
        """
        return pulumi.get(self, "affinity_strength")

    @affinity_strength.setter
    def affinity_strength(self, value: Optional[pulumi.Input[Union[str, 'AffinityStrength']]]):
        pulumi.set(self, "affinity_strength", value)

    @property
    @pulumi.getter(name="azureHybridBenefitType")
    def azure_hybrid_benefit_type(self) -> Optional[pulumi.Input[Union[str, 'AzureHybridBenefitType']]]:
        """
        placement policy azure hybrid benefit opt-in type
        """
        return pulumi.get(self, "azure_hybrid_benefit_type")

    @azure_hybrid_benefit_type.setter
    def azure_hybrid_benefit_type(self, value: Optional[pulumi.Input[Union[str, 'AzureHybridBenefitType']]]):
        pulumi.set(self, "azure_hybrid_benefit_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the placement policy
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]:
        """
        Whether the placement policy is enabled or disabled
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class VmVmPlacementPolicyPropertiesArgs:
    def __init__(__self__, *,
                 affinity_type: pulumi.Input[Union[str, 'AffinityType']],
                 type: pulumi.Input[str],
                 vm_members: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]] = None):
        """
        VM-VM placement policy properties
        :param pulumi.Input[Union[str, 'AffinityType']] affinity_type: placement policy affinity type
        :param pulumi.Input[str] type: placement policy type
               Expected value is 'VmVm'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vm_members: Virtual machine members list
        :param pulumi.Input[str] display_name: Display name of the placement policy
        :param pulumi.Input[Union[str, 'PlacementPolicyState']] state: Whether the placement policy is enabled or disabled
        """
        pulumi.set(__self__, "affinity_type", affinity_type)
        pulumi.set(__self__, "type", 'VmVm')
        pulumi.set(__self__, "vm_members", vm_members)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="affinityType")
    def affinity_type(self) -> pulumi.Input[Union[str, 'AffinityType']]:
        """
        placement policy affinity type
        """
        return pulumi.get(self, "affinity_type")

    @affinity_type.setter
    def affinity_type(self, value: pulumi.Input[Union[str, 'AffinityType']]):
        pulumi.set(self, "affinity_type", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        placement policy type
        Expected value is 'VmVm'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vmMembers")
    def vm_members(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Virtual machine members list
        """
        return pulumi.get(self, "vm_members")

    @vm_members.setter
    def vm_members(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vm_members", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the placement policy
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]:
        """
        Whether the placement policy is enabled or disabled
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'PlacementPolicyState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class WorkloadNetworkDhcpRelayArgs:
    def __init__(__self__, *,
                 dhcp_type: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[float]] = None,
                 server_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        NSX DHCP Relay
        :param pulumi.Input[str] dhcp_type: Type of DHCP: SERVER or RELAY.
               Expected value is 'RELAY'.
        :param pulumi.Input[str] display_name: Display name of the DHCP entity.
        :param pulumi.Input[float] revision: NSX revision number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_addresses: DHCP Relay Addresses. Max 3.
        """
        pulumi.set(__self__, "dhcp_type", 'RELAY')
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if server_addresses is not None:
            pulumi.set(__self__, "server_addresses", server_addresses)

    @property
    @pulumi.getter(name="dhcpType")
    def dhcp_type(self) -> pulumi.Input[str]:
        """
        Type of DHCP: SERVER or RELAY.
        Expected value is 'RELAY'.
        """
        return pulumi.get(self, "dhcp_type")

    @dhcp_type.setter
    def dhcp_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dhcp_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the DHCP entity.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[float]]:
        """
        NSX revision number.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="serverAddresses")
    def server_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DHCP Relay Addresses. Max 3.
        """
        return pulumi.get(self, "server_addresses")

    @server_addresses.setter
    def server_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_addresses", value)


@pulumi.input_type
class WorkloadNetworkDhcpServerArgs:
    def __init__(__self__, *,
                 dhcp_type: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 lease_time: Optional[pulumi.Input[float]] = None,
                 revision: Optional[pulumi.Input[float]] = None,
                 server_address: Optional[pulumi.Input[str]] = None):
        """
        NSX DHCP Server
        :param pulumi.Input[str] dhcp_type: Type of DHCP: SERVER or RELAY.
               Expected value is 'SERVER'.
        :param pulumi.Input[str] display_name: Display name of the DHCP entity.
        :param pulumi.Input[float] lease_time: DHCP Server Lease Time.
        :param pulumi.Input[float] revision: NSX revision number.
        :param pulumi.Input[str] server_address: DHCP Server Address.
        """
        pulumi.set(__self__, "dhcp_type", 'SERVER')
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if lease_time is not None:
            pulumi.set(__self__, "lease_time", lease_time)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if server_address is not None:
            pulumi.set(__self__, "server_address", server_address)

    @property
    @pulumi.getter(name="dhcpType")
    def dhcp_type(self) -> pulumi.Input[str]:
        """
        Type of DHCP: SERVER or RELAY.
        Expected value is 'SERVER'.
        """
        return pulumi.get(self, "dhcp_type")

    @dhcp_type.setter
    def dhcp_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dhcp_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the DHCP entity.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> Optional[pulumi.Input[float]]:
        """
        DHCP Server Lease Time.
        """
        return pulumi.get(self, "lease_time")

    @lease_time.setter
    def lease_time(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "lease_time", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[float]]:
        """
        NSX revision number.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> Optional[pulumi.Input[str]]:
        """
        DHCP Server Address.
        """
        return pulumi.get(self, "server_address")

    @server_address.setter
    def server_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_address", value)


@pulumi.input_type
class WorkloadNetworkSegmentSubnetArgs:
    def __init__(__self__, *,
                 dhcp_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_address: Optional[pulumi.Input[str]] = None):
        """
        Subnet configuration for segment
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_ranges: DHCP Range assigned for subnet.
        :param pulumi.Input[str] gateway_address: Gateway address.
        """
        if dhcp_ranges is not None:
            pulumi.set(__self__, "dhcp_ranges", dhcp_ranges)
        if gateway_address is not None:
            pulumi.set(__self__, "gateway_address", gateway_address)

    @property
    @pulumi.getter(name="dhcpRanges")
    def dhcp_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DHCP Range assigned for subnet.
        """
        return pulumi.get(self, "dhcp_ranges")

    @dhcp_ranges.setter
    def dhcp_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dhcp_ranges", value)

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway address.
        """
        return pulumi.get(self, "gateway_address")

    @gateway_address.setter
    def gateway_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_address", value)


