# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CloudEndpointChangeEnumerationActivityResponse',
    'CloudEndpointChangeEnumerationStatusResponse',
    'CloudEndpointLastChangeEnumerationStatusResponse',
    'CloudTieringCachePerformanceResponse',
    'CloudTieringDatePolicyStatusResponse',
    'CloudTieringFilesNotTieringResponse',
    'CloudTieringLowDiskModeResponse',
    'CloudTieringSpaceSavingsResponse',
    'CloudTieringVolumeFreeSpacePolicyStatusResponse',
    'FilesNotTieringErrorResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ServerEndpointBackgroundDataDownloadActivityResponse',
    'ServerEndpointCloudTieringStatusResponse',
    'ServerEndpointFilesNotSyncingErrorResponse',
    'ServerEndpointRecallErrorResponse',
    'ServerEndpointRecallStatusResponse',
    'ServerEndpointSyncActivityStatusResponse',
    'ServerEndpointSyncSessionStatusResponse',
    'ServerEndpointSyncStatusResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class CloudEndpointChangeEnumerationActivityResponse(dict):
    """
    Cloud endpoint change enumeration activity object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deletesProgressPercent":
            suggest = "deletes_progress_percent"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "minutesRemaining":
            suggest = "minutes_remaining"
        elif key == "operationState":
            suggest = "operation_state"
        elif key == "processedDirectoriesCount":
            suggest = "processed_directories_count"
        elif key == "processedFilesCount":
            suggest = "processed_files_count"
        elif key == "progressPercent":
            suggest = "progress_percent"
        elif key == "startedTimestamp":
            suggest = "started_timestamp"
        elif key == "statusCode":
            suggest = "status_code"
        elif key == "totalCountsState":
            suggest = "total_counts_state"
        elif key == "totalDirectoriesCount":
            suggest = "total_directories_count"
        elif key == "totalFilesCount":
            suggest = "total_files_count"
        elif key == "totalSizeBytes":
            suggest = "total_size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudEndpointChangeEnumerationActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudEndpointChangeEnumerationActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudEndpointChangeEnumerationActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deletes_progress_percent: int,
                 last_updated_timestamp: str,
                 minutes_remaining: int,
                 operation_state: str,
                 processed_directories_count: float,
                 processed_files_count: float,
                 progress_percent: int,
                 started_timestamp: str,
                 status_code: int,
                 total_counts_state: str,
                 total_directories_count: float,
                 total_files_count: float,
                 total_size_bytes: float):
        """
        Cloud endpoint change enumeration activity object
        :param int deletes_progress_percent: Progress percentage for processing deletes. This is done separately from the rest of the enumeration run
        :param str last_updated_timestamp: Last updated timestamp
        :param int minutes_remaining: Estimate of time remaining for the enumeration run
        :param str operation_state: Change enumeration operation state
        :param float processed_directories_count: Count of directories processed
        :param float processed_files_count: Count of files processed
        :param int progress_percent: Progress percentage for change enumeration run, excluding processing of deletes
        :param str started_timestamp: Timestamp when change enumeration started
        :param int status_code: When non-zero, indicates an issue that is delaying change enumeration
        :param str total_counts_state: Change enumeration total counts state
        :param float total_directories_count: Total count of directories enumerated
        :param float total_files_count: Total count of files enumerated
        :param float total_size_bytes: Total enumerated size in bytes
        """
        pulumi.set(__self__, "deletes_progress_percent", deletes_progress_percent)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "minutes_remaining", minutes_remaining)
        pulumi.set(__self__, "operation_state", operation_state)
        pulumi.set(__self__, "processed_directories_count", processed_directories_count)
        pulumi.set(__self__, "processed_files_count", processed_files_count)
        pulumi.set(__self__, "progress_percent", progress_percent)
        pulumi.set(__self__, "started_timestamp", started_timestamp)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "total_counts_state", total_counts_state)
        pulumi.set(__self__, "total_directories_count", total_directories_count)
        pulumi.set(__self__, "total_files_count", total_files_count)
        pulumi.set(__self__, "total_size_bytes", total_size_bytes)

    @property
    @pulumi.getter(name="deletesProgressPercent")
    def deletes_progress_percent(self) -> int:
        """
        Progress percentage for processing deletes. This is done separately from the rest of the enumeration run
        """
        return pulumi.get(self, "deletes_progress_percent")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="minutesRemaining")
    def minutes_remaining(self) -> int:
        """
        Estimate of time remaining for the enumeration run
        """
        return pulumi.get(self, "minutes_remaining")

    @property
    @pulumi.getter(name="operationState")
    def operation_state(self) -> str:
        """
        Change enumeration operation state
        """
        return pulumi.get(self, "operation_state")

    @property
    @pulumi.getter(name="processedDirectoriesCount")
    def processed_directories_count(self) -> float:
        """
        Count of directories processed
        """
        return pulumi.get(self, "processed_directories_count")

    @property
    @pulumi.getter(name="processedFilesCount")
    def processed_files_count(self) -> float:
        """
        Count of files processed
        """
        return pulumi.get(self, "processed_files_count")

    @property
    @pulumi.getter(name="progressPercent")
    def progress_percent(self) -> int:
        """
        Progress percentage for change enumeration run, excluding processing of deletes
        """
        return pulumi.get(self, "progress_percent")

    @property
    @pulumi.getter(name="startedTimestamp")
    def started_timestamp(self) -> str:
        """
        Timestamp when change enumeration started
        """
        return pulumi.get(self, "started_timestamp")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> int:
        """
        When non-zero, indicates an issue that is delaying change enumeration
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter(name="totalCountsState")
    def total_counts_state(self) -> str:
        """
        Change enumeration total counts state
        """
        return pulumi.get(self, "total_counts_state")

    @property
    @pulumi.getter(name="totalDirectoriesCount")
    def total_directories_count(self) -> float:
        """
        Total count of directories enumerated
        """
        return pulumi.get(self, "total_directories_count")

    @property
    @pulumi.getter(name="totalFilesCount")
    def total_files_count(self) -> float:
        """
        Total count of files enumerated
        """
        return pulumi.get(self, "total_files_count")

    @property
    @pulumi.getter(name="totalSizeBytes")
    def total_size_bytes(self) -> float:
        """
        Total enumerated size in bytes
        """
        return pulumi.get(self, "total_size_bytes")


@pulumi.output_type
class CloudEndpointChangeEnumerationStatusResponse(dict):
    """
    Cloud endpoint change enumeration status object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastEnumerationStatus":
            suggest = "last_enumeration_status"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudEndpointChangeEnumerationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudEndpointChangeEnumerationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudEndpointChangeEnumerationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activity: 'outputs.CloudEndpointChangeEnumerationActivityResponse',
                 last_enumeration_status: 'outputs.CloudEndpointLastChangeEnumerationStatusResponse',
                 last_updated_timestamp: str):
        """
        Cloud endpoint change enumeration status object
        :param 'CloudEndpointChangeEnumerationActivityResponse' activity: Change enumeration activity
        :param 'CloudEndpointLastChangeEnumerationStatusResponse' last_enumeration_status: Status of last completed change enumeration
        :param str last_updated_timestamp: Last updated timestamp
        """
        pulumi.set(__self__, "activity", activity)
        pulumi.set(__self__, "last_enumeration_status", last_enumeration_status)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)

    @property
    @pulumi.getter
    def activity(self) -> 'outputs.CloudEndpointChangeEnumerationActivityResponse':
        """
        Change enumeration activity
        """
        return pulumi.get(self, "activity")

    @property
    @pulumi.getter(name="lastEnumerationStatus")
    def last_enumeration_status(self) -> 'outputs.CloudEndpointLastChangeEnumerationStatusResponse':
        """
        Status of last completed change enumeration
        """
        return pulumi.get(self, "last_enumeration_status")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")


@pulumi.output_type
class CloudEndpointLastChangeEnumerationStatusResponse(dict):
    """
    Cloud endpoint change enumeration status object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completedTimestamp":
            suggest = "completed_timestamp"
        elif key == "namespaceDirectoriesCount":
            suggest = "namespace_directories_count"
        elif key == "namespaceFilesCount":
            suggest = "namespace_files_count"
        elif key == "namespaceSizeBytes":
            suggest = "namespace_size_bytes"
        elif key == "nextRunTimestamp":
            suggest = "next_run_timestamp"
        elif key == "startedTimestamp":
            suggest = "started_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudEndpointLastChangeEnumerationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudEndpointLastChangeEnumerationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudEndpointLastChangeEnumerationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completed_timestamp: str,
                 namespace_directories_count: float,
                 namespace_files_count: float,
                 namespace_size_bytes: float,
                 next_run_timestamp: str,
                 started_timestamp: str):
        """
        Cloud endpoint change enumeration status object
        :param str completed_timestamp: Timestamp when change enumeration completed
        :param float namespace_directories_count: Count of directories in the namespace
        :param float namespace_files_count: Count of files in the namespace
        :param float namespace_size_bytes: Namespace size in bytes
        :param str next_run_timestamp: Timestamp of when change enumeration is expected to run again
        :param str started_timestamp: Timestamp when change enumeration started
        """
        pulumi.set(__self__, "completed_timestamp", completed_timestamp)
        pulumi.set(__self__, "namespace_directories_count", namespace_directories_count)
        pulumi.set(__self__, "namespace_files_count", namespace_files_count)
        pulumi.set(__self__, "namespace_size_bytes", namespace_size_bytes)
        pulumi.set(__self__, "next_run_timestamp", next_run_timestamp)
        pulumi.set(__self__, "started_timestamp", started_timestamp)

    @property
    @pulumi.getter(name="completedTimestamp")
    def completed_timestamp(self) -> str:
        """
        Timestamp when change enumeration completed
        """
        return pulumi.get(self, "completed_timestamp")

    @property
    @pulumi.getter(name="namespaceDirectoriesCount")
    def namespace_directories_count(self) -> float:
        """
        Count of directories in the namespace
        """
        return pulumi.get(self, "namespace_directories_count")

    @property
    @pulumi.getter(name="namespaceFilesCount")
    def namespace_files_count(self) -> float:
        """
        Count of files in the namespace
        """
        return pulumi.get(self, "namespace_files_count")

    @property
    @pulumi.getter(name="namespaceSizeBytes")
    def namespace_size_bytes(self) -> float:
        """
        Namespace size in bytes
        """
        return pulumi.get(self, "namespace_size_bytes")

    @property
    @pulumi.getter(name="nextRunTimestamp")
    def next_run_timestamp(self) -> str:
        """
        Timestamp of when change enumeration is expected to run again
        """
        return pulumi.get(self, "next_run_timestamp")

    @property
    @pulumi.getter(name="startedTimestamp")
    def started_timestamp(self) -> str:
        """
        Timestamp when change enumeration started
        """
        return pulumi.get(self, "started_timestamp")


@pulumi.output_type
class CloudTieringCachePerformanceResponse(dict):
    """
    Server endpoint cloud tiering status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheHitBytes":
            suggest = "cache_hit_bytes"
        elif key == "cacheHitBytesPercent":
            suggest = "cache_hit_bytes_percent"
        elif key == "cacheMissBytes":
            suggest = "cache_miss_bytes"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudTieringCachePerformanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudTieringCachePerformanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudTieringCachePerformanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_hit_bytes: float,
                 cache_hit_bytes_percent: int,
                 cache_miss_bytes: float,
                 last_updated_timestamp: str):
        """
        Server endpoint cloud tiering status object.
        :param float cache_hit_bytes: Count of bytes that were served from the local server
        :param int cache_hit_bytes_percent: Percentage of total bytes (hit + miss) that were served from the local server
        :param float cache_miss_bytes: Count of bytes that were served from the cloud
        :param str last_updated_timestamp: Last updated timestamp
        """
        pulumi.set(__self__, "cache_hit_bytes", cache_hit_bytes)
        pulumi.set(__self__, "cache_hit_bytes_percent", cache_hit_bytes_percent)
        pulumi.set(__self__, "cache_miss_bytes", cache_miss_bytes)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)

    @property
    @pulumi.getter(name="cacheHitBytes")
    def cache_hit_bytes(self) -> float:
        """
        Count of bytes that were served from the local server
        """
        return pulumi.get(self, "cache_hit_bytes")

    @property
    @pulumi.getter(name="cacheHitBytesPercent")
    def cache_hit_bytes_percent(self) -> int:
        """
        Percentage of total bytes (hit + miss) that were served from the local server
        """
        return pulumi.get(self, "cache_hit_bytes_percent")

    @property
    @pulumi.getter(name="cacheMissBytes")
    def cache_miss_bytes(self) -> float:
        """
        Count of bytes that were served from the cloud
        """
        return pulumi.get(self, "cache_miss_bytes")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")


@pulumi.output_type
class CloudTieringDatePolicyStatusResponse(dict):
    """
    Status of the date policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "tieredFilesMostRecentAccessTimestamp":
            suggest = "tiered_files_most_recent_access_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudTieringDatePolicyStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudTieringDatePolicyStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudTieringDatePolicyStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated_timestamp: str,
                 tiered_files_most_recent_access_timestamp: str):
        """
        Status of the date policy
        :param str last_updated_timestamp: Last updated timestamp
        :param str tiered_files_most_recent_access_timestamp: Most recent access time of tiered files
        """
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "tiered_files_most_recent_access_timestamp", tiered_files_most_recent_access_timestamp)

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="tieredFilesMostRecentAccessTimestamp")
    def tiered_files_most_recent_access_timestamp(self) -> str:
        """
        Most recent access time of tiered files
        """
        return pulumi.get(self, "tiered_files_most_recent_access_timestamp")


@pulumi.output_type
class CloudTieringFilesNotTieringResponse(dict):
    """
    Server endpoint cloud tiering status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "totalFileCount":
            suggest = "total_file_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudTieringFilesNotTieringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudTieringFilesNotTieringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudTieringFilesNotTieringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Sequence['outputs.FilesNotTieringErrorResponse'],
                 last_updated_timestamp: str,
                 total_file_count: float):
        """
        Server endpoint cloud tiering status object.
        :param Sequence['FilesNotTieringErrorResponse'] errors: Array of tiering errors
        :param str last_updated_timestamp: Last updated timestamp
        :param float total_file_count: Last cloud tiering result (HResult)
        """
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "total_file_count", total_file_count)

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.FilesNotTieringErrorResponse']:
        """
        Array of tiering errors
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="totalFileCount")
    def total_file_count(self) -> float:
        """
        Last cloud tiering result (HResult)
        """
        return pulumi.get(self, "total_file_count")


@pulumi.output_type
class CloudTieringLowDiskModeResponse(dict):
    """
    Information regarding the low disk mode state
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudTieringLowDiskModeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudTieringLowDiskModeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudTieringLowDiskModeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated_timestamp: str,
                 state: str):
        """
        Information regarding the low disk mode state
        :param str last_updated_timestamp: Last updated timestamp
        :param str state: Low disk mode state
        """
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Low disk mode state
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class CloudTieringSpaceSavingsResponse(dict):
    """
    Server endpoint cloud tiering status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachedSizeBytes":
            suggest = "cached_size_bytes"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "spaceSavingsBytes":
            suggest = "space_savings_bytes"
        elif key == "spaceSavingsPercent":
            suggest = "space_savings_percent"
        elif key == "totalSizeCloudBytes":
            suggest = "total_size_cloud_bytes"
        elif key == "volumeSizeBytes":
            suggest = "volume_size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudTieringSpaceSavingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudTieringSpaceSavingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudTieringSpaceSavingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cached_size_bytes: float,
                 last_updated_timestamp: str,
                 space_savings_bytes: float,
                 space_savings_percent: int,
                 total_size_cloud_bytes: float,
                 volume_size_bytes: float):
        """
        Server endpoint cloud tiering status object.
        :param float cached_size_bytes: Cached content size on the server
        :param str last_updated_timestamp: Last updated timestamp
        :param float space_savings_bytes: Count of bytes saved on the server
        :param int space_savings_percent: Percentage of cached size over total size
        :param float total_size_cloud_bytes: Total size of content in the azure file share
        :param float volume_size_bytes: Volume size
        """
        pulumi.set(__self__, "cached_size_bytes", cached_size_bytes)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "space_savings_bytes", space_savings_bytes)
        pulumi.set(__self__, "space_savings_percent", space_savings_percent)
        pulumi.set(__self__, "total_size_cloud_bytes", total_size_cloud_bytes)
        pulumi.set(__self__, "volume_size_bytes", volume_size_bytes)

    @property
    @pulumi.getter(name="cachedSizeBytes")
    def cached_size_bytes(self) -> float:
        """
        Cached content size on the server
        """
        return pulumi.get(self, "cached_size_bytes")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="spaceSavingsBytes")
    def space_savings_bytes(self) -> float:
        """
        Count of bytes saved on the server
        """
        return pulumi.get(self, "space_savings_bytes")

    @property
    @pulumi.getter(name="spaceSavingsPercent")
    def space_savings_percent(self) -> int:
        """
        Percentage of cached size over total size
        """
        return pulumi.get(self, "space_savings_percent")

    @property
    @pulumi.getter(name="totalSizeCloudBytes")
    def total_size_cloud_bytes(self) -> float:
        """
        Total size of content in the azure file share
        """
        return pulumi.get(self, "total_size_cloud_bytes")

    @property
    @pulumi.getter(name="volumeSizeBytes")
    def volume_size_bytes(self) -> float:
        """
        Volume size
        """
        return pulumi.get(self, "volume_size_bytes")


@pulumi.output_type
class CloudTieringVolumeFreeSpacePolicyStatusResponse(dict):
    """
    Status of the volume free space policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentVolumeFreeSpacePercent":
            suggest = "current_volume_free_space_percent"
        elif key == "effectiveVolumeFreeSpacePolicy":
            suggest = "effective_volume_free_space_policy"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudTieringVolumeFreeSpacePolicyStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudTieringVolumeFreeSpacePolicyStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudTieringVolumeFreeSpacePolicyStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_volume_free_space_percent: int,
                 effective_volume_free_space_policy: int,
                 last_updated_timestamp: str):
        """
        Status of the volume free space policy
        :param int current_volume_free_space_percent: Current volume free space percentage.
        :param int effective_volume_free_space_policy: In the case where multiple server endpoints are present in a volume, an effective free space policy is applied.
        :param str last_updated_timestamp: Last updated timestamp
        """
        pulumi.set(__self__, "current_volume_free_space_percent", current_volume_free_space_percent)
        pulumi.set(__self__, "effective_volume_free_space_policy", effective_volume_free_space_policy)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)

    @property
    @pulumi.getter(name="currentVolumeFreeSpacePercent")
    def current_volume_free_space_percent(self) -> int:
        """
        Current volume free space percentage.
        """
        return pulumi.get(self, "current_volume_free_space_percent")

    @property
    @pulumi.getter(name="effectiveVolumeFreeSpacePolicy")
    def effective_volume_free_space_policy(self) -> int:
        """
        In the case where multiple server endpoints are present in a volume, an effective free space policy is applied.
        """
        return pulumi.get(self, "effective_volume_free_space_policy")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")


@pulumi.output_type
class FilesNotTieringErrorResponse(dict):
    """
    Files not tiering error object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "fileCount":
            suggest = "file_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilesNotTieringErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilesNotTieringErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilesNotTieringErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: int,
                 file_count: float):
        """
        Files not tiering error object
        :param int error_code: Error code (HResult)
        :param float file_count: Count of files with this error
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "file_count", file_count)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        Error code (HResult)
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="fileCount")
    def file_count(self) -> float:
        """
        Count of files with this error
        """
        return pulumi.get(self, "file_count")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Azure Resource Manager metadata containing createdBy and modifiedBy information.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServerEndpointBackgroundDataDownloadActivityResponse(dict):
    """
    Background data download activity object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadedBytes":
            suggest = "downloaded_bytes"
        elif key == "percentProgress":
            suggest = "percent_progress"
        elif key == "startedTimestamp":
            suggest = "started_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointBackgroundDataDownloadActivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointBackgroundDataDownloadActivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointBackgroundDataDownloadActivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 downloaded_bytes: float,
                 percent_progress: int,
                 started_timestamp: str,
                 timestamp: str):
        """
        Background data download activity object
        :param float downloaded_bytes: Running count of bytes downloaded
        :param int percent_progress: Progress percentage
        :param str started_timestamp: Timestamp when the operation started
        :param str timestamp: Timestamp when properties were updated
        """
        pulumi.set(__self__, "downloaded_bytes", downloaded_bytes)
        pulumi.set(__self__, "percent_progress", percent_progress)
        pulumi.set(__self__, "started_timestamp", started_timestamp)
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter(name="downloadedBytes")
    def downloaded_bytes(self) -> float:
        """
        Running count of bytes downloaded
        """
        return pulumi.get(self, "downloaded_bytes")

    @property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> int:
        """
        Progress percentage
        """
        return pulumi.get(self, "percent_progress")

    @property
    @pulumi.getter(name="startedTimestamp")
    def started_timestamp(self) -> str:
        """
        Timestamp when the operation started
        """
        return pulumi.get(self, "started_timestamp")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Timestamp when properties were updated
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class ServerEndpointCloudTieringStatusResponse(dict):
    """
    Server endpoint cloud tiering status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachePerformance":
            suggest = "cache_performance"
        elif key == "datePolicyStatus":
            suggest = "date_policy_status"
        elif key == "filesNotTiering":
            suggest = "files_not_tiering"
        elif key == "healthLastUpdatedTimestamp":
            suggest = "health_last_updated_timestamp"
        elif key == "lastCloudTieringResult":
            suggest = "last_cloud_tiering_result"
        elif key == "lastSuccessTimestamp":
            suggest = "last_success_timestamp"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "lowDiskMode":
            suggest = "low_disk_mode"
        elif key == "spaceSavings":
            suggest = "space_savings"
        elif key == "volumeFreeSpacePolicyStatus":
            suggest = "volume_free_space_policy_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointCloudTieringStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointCloudTieringStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointCloudTieringStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_performance: 'outputs.CloudTieringCachePerformanceResponse',
                 date_policy_status: 'outputs.CloudTieringDatePolicyStatusResponse',
                 files_not_tiering: 'outputs.CloudTieringFilesNotTieringResponse',
                 health: str,
                 health_last_updated_timestamp: str,
                 last_cloud_tiering_result: int,
                 last_success_timestamp: str,
                 last_updated_timestamp: str,
                 low_disk_mode: 'outputs.CloudTieringLowDiskModeResponse',
                 space_savings: 'outputs.CloudTieringSpaceSavingsResponse',
                 volume_free_space_policy_status: 'outputs.CloudTieringVolumeFreeSpacePolicyStatusResponse'):
        """
        Server endpoint cloud tiering status object.
        :param 'CloudTieringCachePerformanceResponse' cache_performance: Information regarding how well the local cache on the server is performing.
        :param 'CloudTieringDatePolicyStatusResponse' date_policy_status: Status of the date policy
        :param 'CloudTieringFilesNotTieringResponse' files_not_tiering: Information regarding files that failed to be tiered
        :param str health: Cloud tiering health state.
        :param str health_last_updated_timestamp: The last updated timestamp of health state
        :param int last_cloud_tiering_result: Last cloud tiering result (HResult)
        :param str last_success_timestamp: Last cloud tiering success timestamp
        :param str last_updated_timestamp: Last updated timestamp
        :param 'CloudTieringLowDiskModeResponse' low_disk_mode: Information regarding the low disk mode state
        :param 'CloudTieringSpaceSavingsResponse' space_savings: Information regarding how much local space cloud tiering is saving.
        :param 'CloudTieringVolumeFreeSpacePolicyStatusResponse' volume_free_space_policy_status: Status of the volume free space policy
        """
        pulumi.set(__self__, "cache_performance", cache_performance)
        pulumi.set(__self__, "date_policy_status", date_policy_status)
        pulumi.set(__self__, "files_not_tiering", files_not_tiering)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "health_last_updated_timestamp", health_last_updated_timestamp)
        pulumi.set(__self__, "last_cloud_tiering_result", last_cloud_tiering_result)
        pulumi.set(__self__, "last_success_timestamp", last_success_timestamp)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "low_disk_mode", low_disk_mode)
        pulumi.set(__self__, "space_savings", space_savings)
        pulumi.set(__self__, "volume_free_space_policy_status", volume_free_space_policy_status)

    @property
    @pulumi.getter(name="cachePerformance")
    def cache_performance(self) -> 'outputs.CloudTieringCachePerformanceResponse':
        """
        Information regarding how well the local cache on the server is performing.
        """
        return pulumi.get(self, "cache_performance")

    @property
    @pulumi.getter(name="datePolicyStatus")
    def date_policy_status(self) -> 'outputs.CloudTieringDatePolicyStatusResponse':
        """
        Status of the date policy
        """
        return pulumi.get(self, "date_policy_status")

    @property
    @pulumi.getter(name="filesNotTiering")
    def files_not_tiering(self) -> 'outputs.CloudTieringFilesNotTieringResponse':
        """
        Information regarding files that failed to be tiered
        """
        return pulumi.get(self, "files_not_tiering")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Cloud tiering health state.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthLastUpdatedTimestamp")
    def health_last_updated_timestamp(self) -> str:
        """
        The last updated timestamp of health state
        """
        return pulumi.get(self, "health_last_updated_timestamp")

    @property
    @pulumi.getter(name="lastCloudTieringResult")
    def last_cloud_tiering_result(self) -> int:
        """
        Last cloud tiering result (HResult)
        """
        return pulumi.get(self, "last_cloud_tiering_result")

    @property
    @pulumi.getter(name="lastSuccessTimestamp")
    def last_success_timestamp(self) -> str:
        """
        Last cloud tiering success timestamp
        """
        return pulumi.get(self, "last_success_timestamp")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="lowDiskMode")
    def low_disk_mode(self) -> 'outputs.CloudTieringLowDiskModeResponse':
        """
        Information regarding the low disk mode state
        """
        return pulumi.get(self, "low_disk_mode")

    @property
    @pulumi.getter(name="spaceSavings")
    def space_savings(self) -> 'outputs.CloudTieringSpaceSavingsResponse':
        """
        Information regarding how much local space cloud tiering is saving.
        """
        return pulumi.get(self, "space_savings")

    @property
    @pulumi.getter(name="volumeFreeSpacePolicyStatus")
    def volume_free_space_policy_status(self) -> 'outputs.CloudTieringVolumeFreeSpacePolicyStatusResponse':
        """
        Status of the volume free space policy
        """
        return pulumi.get(self, "volume_free_space_policy_status")


@pulumi.output_type
class ServerEndpointFilesNotSyncingErrorResponse(dict):
    """
    Files not syncing error object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "persistentCount":
            suggest = "persistent_count"
        elif key == "transientCount":
            suggest = "transient_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointFilesNotSyncingErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointFilesNotSyncingErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointFilesNotSyncingErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: int,
                 persistent_count: float,
                 transient_count: float):
        """
        Files not syncing error object
        :param int error_code: Error code (HResult)
        :param float persistent_count: Count of persistent files not syncing with the specified error code
        :param float transient_count: Count of transient files not syncing with the specified error code
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "persistent_count", persistent_count)
        pulumi.set(__self__, "transient_count", transient_count)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        Error code (HResult)
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="persistentCount")
    def persistent_count(self) -> float:
        """
        Count of persistent files not syncing with the specified error code
        """
        return pulumi.get(self, "persistent_count")

    @property
    @pulumi.getter(name="transientCount")
    def transient_count(self) -> float:
        """
        Count of transient files not syncing with the specified error code
        """
        return pulumi.get(self, "transient_count")


@pulumi.output_type
class ServerEndpointRecallErrorResponse(dict):
    """
    Server endpoint recall error object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointRecallErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointRecallErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointRecallErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: float,
                 error_code: int):
        """
        Server endpoint recall error object
        :param float count: Count of occurences of the error
        :param int error_code: Error code (HResult)
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "error_code", error_code)

    @property
    @pulumi.getter
    def count(self) -> float:
        """
        Count of occurences of the error
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        Error code (HResult)
        """
        return pulumi.get(self, "error_code")


@pulumi.output_type
class ServerEndpointRecallStatusResponse(dict):
    """
    Server endpoint recall status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "recallErrors":
            suggest = "recall_errors"
        elif key == "totalRecallErrorsCount":
            suggest = "total_recall_errors_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointRecallStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointRecallStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointRecallStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated_timestamp: str,
                 recall_errors: Sequence['outputs.ServerEndpointRecallErrorResponse'],
                 total_recall_errors_count: float):
        """
        Server endpoint recall status object.
        :param str last_updated_timestamp: Last updated timestamp
        :param Sequence['ServerEndpointRecallErrorResponse'] recall_errors: Array of recall errors
        :param float total_recall_errors_count: Total count of recall errors.
        """
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "recall_errors", recall_errors)
        pulumi.set(__self__, "total_recall_errors_count", total_recall_errors_count)

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last updated timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="recallErrors")
    def recall_errors(self) -> Sequence['outputs.ServerEndpointRecallErrorResponse']:
        """
        Array of recall errors
        """
        return pulumi.get(self, "recall_errors")

    @property
    @pulumi.getter(name="totalRecallErrorsCount")
    def total_recall_errors_count(self) -> float:
        """
        Total count of recall errors.
        """
        return pulumi.get(self, "total_recall_errors_count")


@pulumi.output_type
class ServerEndpointSyncActivityStatusResponse(dict):
    """
    Sync Session status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedBytes":
            suggest = "applied_bytes"
        elif key == "appliedItemCount":
            suggest = "applied_item_count"
        elif key == "perItemErrorCount":
            suggest = "per_item_error_count"
        elif key == "sessionMinutesRemaining":
            suggest = "session_minutes_remaining"
        elif key == "syncMode":
            suggest = "sync_mode"
        elif key == "totalBytes":
            suggest = "total_bytes"
        elif key == "totalItemCount":
            suggest = "total_item_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointSyncActivityStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointSyncActivityStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointSyncActivityStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_bytes: float,
                 applied_item_count: float,
                 per_item_error_count: float,
                 session_minutes_remaining: int,
                 sync_mode: str,
                 timestamp: str,
                 total_bytes: float,
                 total_item_count: float):
        """
        Sync Session status object.
        :param float applied_bytes: Applied bytes
        :param float applied_item_count: Applied item count.
        :param float per_item_error_count: Per item error count
        :param int session_minutes_remaining: Session minutes remaining (if available)
        :param str sync_mode: Sync mode
        :param str timestamp: Timestamp when properties were updated
        :param float total_bytes: Total bytes (if available)
        :param float total_item_count: Total item count (if available)
        """
        pulumi.set(__self__, "applied_bytes", applied_bytes)
        pulumi.set(__self__, "applied_item_count", applied_item_count)
        pulumi.set(__self__, "per_item_error_count", per_item_error_count)
        pulumi.set(__self__, "session_minutes_remaining", session_minutes_remaining)
        pulumi.set(__self__, "sync_mode", sync_mode)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "total_bytes", total_bytes)
        pulumi.set(__self__, "total_item_count", total_item_count)

    @property
    @pulumi.getter(name="appliedBytes")
    def applied_bytes(self) -> float:
        """
        Applied bytes
        """
        return pulumi.get(self, "applied_bytes")

    @property
    @pulumi.getter(name="appliedItemCount")
    def applied_item_count(self) -> float:
        """
        Applied item count.
        """
        return pulumi.get(self, "applied_item_count")

    @property
    @pulumi.getter(name="perItemErrorCount")
    def per_item_error_count(self) -> float:
        """
        Per item error count
        """
        return pulumi.get(self, "per_item_error_count")

    @property
    @pulumi.getter(name="sessionMinutesRemaining")
    def session_minutes_remaining(self) -> int:
        """
        Session minutes remaining (if available)
        """
        return pulumi.get(self, "session_minutes_remaining")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> str:
        """
        Sync mode
        """
        return pulumi.get(self, "sync_mode")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Timestamp when properties were updated
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter(name="totalBytes")
    def total_bytes(self) -> float:
        """
        Total bytes (if available)
        """
        return pulumi.get(self, "total_bytes")

    @property
    @pulumi.getter(name="totalItemCount")
    def total_item_count(self) -> float:
        """
        Total item count (if available)
        """
        return pulumi.get(self, "total_item_count")


@pulumi.output_type
class ServerEndpointSyncSessionStatusResponse(dict):
    """
    Sync Session status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesNotSyncingErrors":
            suggest = "files_not_syncing_errors"
        elif key == "lastSyncMode":
            suggest = "last_sync_mode"
        elif key == "lastSyncPerItemErrorCount":
            suggest = "last_sync_per_item_error_count"
        elif key == "lastSyncResult":
            suggest = "last_sync_result"
        elif key == "lastSyncSuccessTimestamp":
            suggest = "last_sync_success_timestamp"
        elif key == "lastSyncTimestamp":
            suggest = "last_sync_timestamp"
        elif key == "persistentFilesNotSyncingCount":
            suggest = "persistent_files_not_syncing_count"
        elif key == "transientFilesNotSyncingCount":
            suggest = "transient_files_not_syncing_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointSyncSessionStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointSyncSessionStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointSyncSessionStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 files_not_syncing_errors: Sequence['outputs.ServerEndpointFilesNotSyncingErrorResponse'],
                 last_sync_mode: str,
                 last_sync_per_item_error_count: float,
                 last_sync_result: int,
                 last_sync_success_timestamp: str,
                 last_sync_timestamp: str,
                 persistent_files_not_syncing_count: float,
                 transient_files_not_syncing_count: float):
        """
        Sync Session status object.
        :param Sequence['ServerEndpointFilesNotSyncingErrorResponse'] files_not_syncing_errors: Array of per-item errors coming from the last sync session.
        :param str last_sync_mode: Sync mode
        :param float last_sync_per_item_error_count: Last sync per item error count.
        :param int last_sync_result: Last sync result (HResult)
        :param str last_sync_success_timestamp: Last sync success timestamp
        :param str last_sync_timestamp: Last sync timestamp
        :param float persistent_files_not_syncing_count: Count of persistent files not syncing.
        :param float transient_files_not_syncing_count: Count of transient files not syncing.
        """
        pulumi.set(__self__, "files_not_syncing_errors", files_not_syncing_errors)
        pulumi.set(__self__, "last_sync_mode", last_sync_mode)
        pulumi.set(__self__, "last_sync_per_item_error_count", last_sync_per_item_error_count)
        pulumi.set(__self__, "last_sync_result", last_sync_result)
        pulumi.set(__self__, "last_sync_success_timestamp", last_sync_success_timestamp)
        pulumi.set(__self__, "last_sync_timestamp", last_sync_timestamp)
        pulumi.set(__self__, "persistent_files_not_syncing_count", persistent_files_not_syncing_count)
        pulumi.set(__self__, "transient_files_not_syncing_count", transient_files_not_syncing_count)

    @property
    @pulumi.getter(name="filesNotSyncingErrors")
    def files_not_syncing_errors(self) -> Sequence['outputs.ServerEndpointFilesNotSyncingErrorResponse']:
        """
        Array of per-item errors coming from the last sync session.
        """
        return pulumi.get(self, "files_not_syncing_errors")

    @property
    @pulumi.getter(name="lastSyncMode")
    def last_sync_mode(self) -> str:
        """
        Sync mode
        """
        return pulumi.get(self, "last_sync_mode")

    @property
    @pulumi.getter(name="lastSyncPerItemErrorCount")
    def last_sync_per_item_error_count(self) -> float:
        """
        Last sync per item error count.
        """
        return pulumi.get(self, "last_sync_per_item_error_count")

    @property
    @pulumi.getter(name="lastSyncResult")
    def last_sync_result(self) -> int:
        """
        Last sync result (HResult)
        """
        return pulumi.get(self, "last_sync_result")

    @property
    @pulumi.getter(name="lastSyncSuccessTimestamp")
    def last_sync_success_timestamp(self) -> str:
        """
        Last sync success timestamp
        """
        return pulumi.get(self, "last_sync_success_timestamp")

    @property
    @pulumi.getter(name="lastSyncTimestamp")
    def last_sync_timestamp(self) -> str:
        """
        Last sync timestamp
        """
        return pulumi.get(self, "last_sync_timestamp")

    @property
    @pulumi.getter(name="persistentFilesNotSyncingCount")
    def persistent_files_not_syncing_count(self) -> float:
        """
        Count of persistent files not syncing.
        """
        return pulumi.get(self, "persistent_files_not_syncing_count")

    @property
    @pulumi.getter(name="transientFilesNotSyncingCount")
    def transient_files_not_syncing_count(self) -> float:
        """
        Count of transient files not syncing.
        """
        return pulumi.get(self, "transient_files_not_syncing_count")


@pulumi.output_type
class ServerEndpointSyncStatusResponse(dict):
    """
    Server Endpoint sync status
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backgroundDataDownloadActivity":
            suggest = "background_data_download_activity"
        elif key == "combinedHealth":
            suggest = "combined_health"
        elif key == "downloadActivity":
            suggest = "download_activity"
        elif key == "downloadHealth":
            suggest = "download_health"
        elif key == "downloadStatus":
            suggest = "download_status"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "offlineDataTransferStatus":
            suggest = "offline_data_transfer_status"
        elif key == "syncActivity":
            suggest = "sync_activity"
        elif key == "totalPersistentFilesNotSyncingCount":
            suggest = "total_persistent_files_not_syncing_count"
        elif key == "uploadActivity":
            suggest = "upload_activity"
        elif key == "uploadHealth":
            suggest = "upload_health"
        elif key == "uploadStatus":
            suggest = "upload_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointSyncStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointSyncStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointSyncStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 background_data_download_activity: 'outputs.ServerEndpointBackgroundDataDownloadActivityResponse',
                 combined_health: str,
                 download_activity: 'outputs.ServerEndpointSyncActivityStatusResponse',
                 download_health: str,
                 download_status: 'outputs.ServerEndpointSyncSessionStatusResponse',
                 last_updated_timestamp: str,
                 offline_data_transfer_status: str,
                 sync_activity: str,
                 total_persistent_files_not_syncing_count: float,
                 upload_activity: 'outputs.ServerEndpointSyncActivityStatusResponse',
                 upload_health: str,
                 upload_status: 'outputs.ServerEndpointSyncSessionStatusResponse'):
        """
        Server Endpoint sync status
        :param 'ServerEndpointBackgroundDataDownloadActivityResponse' background_data_download_activity: Background data download activity
        :param str combined_health: Combined Health Status.
        :param 'ServerEndpointSyncActivityStatusResponse' download_activity: Download sync activity
        :param str download_health: Download Health Status.
        :param 'ServerEndpointSyncSessionStatusResponse' download_status: Download Status
        :param str last_updated_timestamp: Last Updated Timestamp
        :param str offline_data_transfer_status: Offline Data Transfer State
        :param str sync_activity: Sync activity
        :param float total_persistent_files_not_syncing_count: Total count of persistent files not syncing (combined upload + download).
        :param 'ServerEndpointSyncActivityStatusResponse' upload_activity: Upload sync activity
        :param str upload_health: Upload Health Status.
        :param 'ServerEndpointSyncSessionStatusResponse' upload_status: Upload Status
        """
        pulumi.set(__self__, "background_data_download_activity", background_data_download_activity)
        pulumi.set(__self__, "combined_health", combined_health)
        pulumi.set(__self__, "download_activity", download_activity)
        pulumi.set(__self__, "download_health", download_health)
        pulumi.set(__self__, "download_status", download_status)
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        pulumi.set(__self__, "offline_data_transfer_status", offline_data_transfer_status)
        pulumi.set(__self__, "sync_activity", sync_activity)
        pulumi.set(__self__, "total_persistent_files_not_syncing_count", total_persistent_files_not_syncing_count)
        pulumi.set(__self__, "upload_activity", upload_activity)
        pulumi.set(__self__, "upload_health", upload_health)
        pulumi.set(__self__, "upload_status", upload_status)

    @property
    @pulumi.getter(name="backgroundDataDownloadActivity")
    def background_data_download_activity(self) -> 'outputs.ServerEndpointBackgroundDataDownloadActivityResponse':
        """
        Background data download activity
        """
        return pulumi.get(self, "background_data_download_activity")

    @property
    @pulumi.getter(name="combinedHealth")
    def combined_health(self) -> str:
        """
        Combined Health Status.
        """
        return pulumi.get(self, "combined_health")

    @property
    @pulumi.getter(name="downloadActivity")
    def download_activity(self) -> 'outputs.ServerEndpointSyncActivityStatusResponse':
        """
        Download sync activity
        """
        return pulumi.get(self, "download_activity")

    @property
    @pulumi.getter(name="downloadHealth")
    def download_health(self) -> str:
        """
        Download Health Status.
        """
        return pulumi.get(self, "download_health")

    @property
    @pulumi.getter(name="downloadStatus")
    def download_status(self) -> 'outputs.ServerEndpointSyncSessionStatusResponse':
        """
        Download Status
        """
        return pulumi.get(self, "download_status")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        Last Updated Timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="offlineDataTransferStatus")
    def offline_data_transfer_status(self) -> str:
        """
        Offline Data Transfer State
        """
        return pulumi.get(self, "offline_data_transfer_status")

    @property
    @pulumi.getter(name="syncActivity")
    def sync_activity(self) -> str:
        """
        Sync activity
        """
        return pulumi.get(self, "sync_activity")

    @property
    @pulumi.getter(name="totalPersistentFilesNotSyncingCount")
    def total_persistent_files_not_syncing_count(self) -> float:
        """
        Total count of persistent files not syncing (combined upload + download).
        """
        return pulumi.get(self, "total_persistent_files_not_syncing_count")

    @property
    @pulumi.getter(name="uploadActivity")
    def upload_activity(self) -> 'outputs.ServerEndpointSyncActivityStatusResponse':
        """
        Upload sync activity
        """
        return pulumi.get(self, "upload_activity")

    @property
    @pulumi.getter(name="uploadHealth")
    def upload_health(self) -> str:
        """
        Upload Health Status.
        """
        return pulumi.get(self, "upload_health")

    @property
    @pulumi.getter(name="uploadStatus")
    def upload_status(self) -> 'outputs.ServerEndpointSyncSessionStatusResponse':
        """
        Upload Status
        """
        return pulumi.get(self, "upload_status")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


