# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ControllerDetailsResponse',
    'OrchestratorIdentityResponse',
    'SubnetDetailsResponse',
]

@pulumi.output_type
class ControllerDetailsResponse(dict):
    """
    controller details
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        controller details
        :param str id: controller arm resource id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        controller arm resource id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class OrchestratorIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratorIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratorIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratorIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        :param str principal_id: The principal id of the system assigned identity which is used by orchestrator.
        :param str tenant_id: The tenant id of the system assigned identity which is used by orchestrator.
        :param str type: The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the system assigned identity which is used by orchestrator.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the system assigned identity which is used by orchestrator.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SubnetDetailsResponse(dict):
    """
    Properties of orchestrator
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Properties of orchestrator
        :param str id: subnet arm resource id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        subnet arm resource id
        """
        return pulumi.get(self, "id")


