# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetClusterGatewaySettingsResult',
    'AwaitableGetClusterGatewaySettingsResult',
    'get_cluster_gateway_settings',
    'get_cluster_gateway_settings_output',
]

@pulumi.output_type
class GetClusterGatewaySettingsResult:
    """
    Gateway settings.
    """
    def __init__(__self__, is_credential_enabled=None, password=None, user_name=None):
        if is_credential_enabled and not isinstance(is_credential_enabled, str):
            raise TypeError("Expected argument 'is_credential_enabled' to be a str")
        pulumi.set(__self__, "is_credential_enabled", is_credential_enabled)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="isCredentialEnabled")
    def is_credential_enabled(self) -> str:
        """
        Indicates whether or not the gateway settings based authorization is enabled.
        """
        return pulumi.get(self, "is_credential_enabled")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The gateway settings user password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The gateway settings user name.
        """
        return pulumi.get(self, "user_name")


class AwaitableGetClusterGatewaySettingsResult(GetClusterGatewaySettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterGatewaySettingsResult(
            is_credential_enabled=self.is_credential_enabled,
            password=self.password,
            user_name=self.user_name)


def get_cluster_gateway_settings(cluster_name: Optional[str] = None,
                                 resource_group_name: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterGatewaySettingsResult:
    """
    Gateway settings.


    :param str cluster_name: The name of the cluster.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:hdinsight/v20180601preview:getClusterGatewaySettings', __args__, opts=opts, typ=GetClusterGatewaySettingsResult).value

    return AwaitableGetClusterGatewaySettingsResult(
        is_credential_enabled=__ret__.is_credential_enabled,
        password=__ret__.password,
        user_name=__ret__.user_name)


@_utilities.lift_output_func(get_cluster_gateway_settings)
def get_cluster_gateway_settings_output(cluster_name: Optional[pulumi.Input[str]] = None,
                                        resource_group_name: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterGatewaySettingsResult]:
    """
    Gateway settings.


    :param str cluster_name: The name of the cluster.
    :param str resource_group_name: The name of the resource group.
    """
    ...
