# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetVariableValueAtManagementGroupResult',
    'AwaitableGetVariableValueAtManagementGroupResult',
    'get_variable_value_at_management_group',
    'get_variable_value_at_management_group_output',
]

@pulumi.output_type
class GetVariableValueAtManagementGroupResult:
    """
    The variable value.
    """
    def __init__(__self__, id=None, name=None, system_data=None, type=None, values=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if values and not isinstance(values, list):
            raise TypeError("Expected argument 'values' to be a list")
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the variable.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource (Microsoft.Authorization/variables/values).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.PolicyVariableValueColumnValueResponse']:
        """
        Variable value column value array.
        """
        return pulumi.get(self, "values")


class AwaitableGetVariableValueAtManagementGroupResult(GetVariableValueAtManagementGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVariableValueAtManagementGroupResult(
            id=self.id,
            name=self.name,
            system_data=self.system_data,
            type=self.type,
            values=self.values)


def get_variable_value_at_management_group(management_group_id: Optional[str] = None,
                                           variable_name: Optional[str] = None,
                                           variable_value_name: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVariableValueAtManagementGroupResult:
    """
    The variable value.


    :param str management_group_id: The ID of the management group.
    :param str variable_name: The name of the variable to operate on.
    :param str variable_value_name: The name of the variable value to operate on.
    """
    __args__ = dict()
    __args__['managementGroupId'] = management_group_id
    __args__['variableName'] = variable_name
    __args__['variableValueName'] = variable_value_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:authorization/v20220801preview:getVariableValueAtManagementGroup', __args__, opts=opts, typ=GetVariableValueAtManagementGroupResult).value

    return AwaitableGetVariableValueAtManagementGroupResult(
        id=__ret__.id,
        name=__ret__.name,
        system_data=__ret__.system_data,
        type=__ret__.type,
        values=__ret__.values)


@_utilities.lift_output_func(get_variable_value_at_management_group)
def get_variable_value_at_management_group_output(management_group_id: Optional[pulumi.Input[str]] = None,
                                                  variable_name: Optional[pulumi.Input[str]] = None,
                                                  variable_value_name: Optional[pulumi.Input[str]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVariableValueAtManagementGroupResult]:
    """
    The variable value.


    :param str management_group_id: The ID of the management group.
    :param str variable_name: The name of the variable to operate on.
    :param str variable_value_name: The name of the variable value to operate on.
    """
    ...
