# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ListSiteAuthSettingsSlotResult',
    'AwaitableListSiteAuthSettingsSlotResult',
    'list_site_auth_settings_slot',
    'list_site_auth_settings_slot_output',
]

@pulumi.output_type
class ListSiteAuthSettingsSlotResult:
    """
    Configuration settings for the Azure App Service Authentication / Authorization feature.
    """
    def __init__(__self__, aad_client_id=None, additional_login_params=None, allowed_audiences=None, allowed_external_redirect_urls=None, client_id=None, client_secret=None, default_provider=None, enabled=None, facebook_app_id=None, facebook_app_secret=None, facebook_o_auth_scopes=None, google_client_id=None, google_client_secret=None, google_o_auth_scopes=None, http_api_prefix_path=None, issuer=None, microsoft_account_client_id=None, microsoft_account_client_secret=None, microsoft_account_o_auth_scopes=None, open_id_issuer=None, token_refresh_extension_hours=None, token_store_enabled=None, twitter_consumer_key=None, twitter_consumer_secret=None, unauthenticated_client_action=None):
        if aad_client_id and not isinstance(aad_client_id, str):
            raise TypeError("Expected argument 'aad_client_id' to be a str")
        pulumi.set(__self__, "aad_client_id", aad_client_id)
        if additional_login_params and not isinstance(additional_login_params, list):
            raise TypeError("Expected argument 'additional_login_params' to be a list")
        pulumi.set(__self__, "additional_login_params", additional_login_params)
        if allowed_audiences and not isinstance(allowed_audiences, list):
            raise TypeError("Expected argument 'allowed_audiences' to be a list")
        pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if allowed_external_redirect_urls and not isinstance(allowed_external_redirect_urls, list):
            raise TypeError("Expected argument 'allowed_external_redirect_urls' to be a list")
        pulumi.set(__self__, "allowed_external_redirect_urls", allowed_external_redirect_urls)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if client_secret and not isinstance(client_secret, str):
            raise TypeError("Expected argument 'client_secret' to be a str")
        pulumi.set(__self__, "client_secret", client_secret)
        if default_provider and not isinstance(default_provider, str):
            raise TypeError("Expected argument 'default_provider' to be a str")
        pulumi.set(__self__, "default_provider", default_provider)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if facebook_app_id and not isinstance(facebook_app_id, str):
            raise TypeError("Expected argument 'facebook_app_id' to be a str")
        pulumi.set(__self__, "facebook_app_id", facebook_app_id)
        if facebook_app_secret and not isinstance(facebook_app_secret, str):
            raise TypeError("Expected argument 'facebook_app_secret' to be a str")
        pulumi.set(__self__, "facebook_app_secret", facebook_app_secret)
        if facebook_o_auth_scopes and not isinstance(facebook_o_auth_scopes, list):
            raise TypeError("Expected argument 'facebook_o_auth_scopes' to be a list")
        pulumi.set(__self__, "facebook_o_auth_scopes", facebook_o_auth_scopes)
        if google_client_id and not isinstance(google_client_id, str):
            raise TypeError("Expected argument 'google_client_id' to be a str")
        pulumi.set(__self__, "google_client_id", google_client_id)
        if google_client_secret and not isinstance(google_client_secret, str):
            raise TypeError("Expected argument 'google_client_secret' to be a str")
        pulumi.set(__self__, "google_client_secret", google_client_secret)
        if google_o_auth_scopes and not isinstance(google_o_auth_scopes, list):
            raise TypeError("Expected argument 'google_o_auth_scopes' to be a list")
        pulumi.set(__self__, "google_o_auth_scopes", google_o_auth_scopes)
        if http_api_prefix_path and not isinstance(http_api_prefix_path, str):
            raise TypeError("Expected argument 'http_api_prefix_path' to be a str")
        pulumi.set(__self__, "http_api_prefix_path", http_api_prefix_path)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if microsoft_account_client_id and not isinstance(microsoft_account_client_id, str):
            raise TypeError("Expected argument 'microsoft_account_client_id' to be a str")
        pulumi.set(__self__, "microsoft_account_client_id", microsoft_account_client_id)
        if microsoft_account_client_secret and not isinstance(microsoft_account_client_secret, str):
            raise TypeError("Expected argument 'microsoft_account_client_secret' to be a str")
        pulumi.set(__self__, "microsoft_account_client_secret", microsoft_account_client_secret)
        if microsoft_account_o_auth_scopes and not isinstance(microsoft_account_o_auth_scopes, list):
            raise TypeError("Expected argument 'microsoft_account_o_auth_scopes' to be a list")
        pulumi.set(__self__, "microsoft_account_o_auth_scopes", microsoft_account_o_auth_scopes)
        if open_id_issuer and not isinstance(open_id_issuer, str):
            raise TypeError("Expected argument 'open_id_issuer' to be a str")
        pulumi.set(__self__, "open_id_issuer", open_id_issuer)
        if token_refresh_extension_hours and not isinstance(token_refresh_extension_hours, float):
            raise TypeError("Expected argument 'token_refresh_extension_hours' to be a float")
        pulumi.set(__self__, "token_refresh_extension_hours", token_refresh_extension_hours)
        if token_store_enabled and not isinstance(token_store_enabled, bool):
            raise TypeError("Expected argument 'token_store_enabled' to be a bool")
        pulumi.set(__self__, "token_store_enabled", token_store_enabled)
        if twitter_consumer_key and not isinstance(twitter_consumer_key, str):
            raise TypeError("Expected argument 'twitter_consumer_key' to be a str")
        pulumi.set(__self__, "twitter_consumer_key", twitter_consumer_key)
        if twitter_consumer_secret and not isinstance(twitter_consumer_secret, str):
            raise TypeError("Expected argument 'twitter_consumer_secret' to be a str")
        pulumi.set(__self__, "twitter_consumer_secret", twitter_consumer_secret)
        if unauthenticated_client_action and not isinstance(unauthenticated_client_action, str):
            raise TypeError("Expected argument 'unauthenticated_client_action' to be a str")
        pulumi.set(__self__, "unauthenticated_client_action", unauthenticated_client_action)

    @property
    @pulumi.getter(name="aadClientId")
    def aad_client_id(self) -> Optional[str]:
        return pulumi.get(self, "aad_client_id")

    @property
    @pulumi.getter(name="additionalLoginParams")
    def additional_login_params(self) -> Optional[Sequence[str]]:
        """
        Gets or sets a list of login parameters to send to the OpenID Connect authorization endpoint when
                    a user logs in. Each parameter must be in the form "key=value".
        """
        return pulumi.get(self, "additional_login_params")

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[Sequence[str]]:
        """
        Gets or sets a list of allowed audience values to consider when validating JWTs issued by 
                    Azure Active Directory. Note that the {Microsoft.Web.Hosting.Administration.SiteAuthSettings.ClientId} value is always considered an
                    allowed audience, regardless of this setting.
        """
        return pulumi.get(self, "allowed_audiences")

    @property
    @pulumi.getter(name="allowedExternalRedirectUrls")
    def allowed_external_redirect_urls(self) -> Optional[Sequence[str]]:
        """
        Gets or sets a collection of external URLs that can be redirected to as part of logging in
                    or logging out of the web app. Note that the query string part of the URL is ignored.
                    This is an advanced setting typically only needed by Windows Store application backends.
                    Note that URLs within the current domain are always implicitly allowed.
        """
        return pulumi.get(self, "allowed_external_redirect_urls")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Gets or sets the Client ID of this relying party application, known as the client_id.
                    This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
                    other 3rd party OpenID Connect providers.
                    More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        Gets or sets the Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
                    This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
                    Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
                    More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="defaultProvider")
    def default_provider(self) -> Optional[str]:
        """
        Gets or sets the default authentication provider to use when multiple providers are configured.
                    This setting is only needed if multiple providers are configured and the unauthenticated client
                    action is set to "RedirectToLoginPage".
        """
        return pulumi.get(self, "default_provider")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether the Authentication / Authorization feature is enabled for the current app.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="facebookAppId")
    def facebook_app_id(self) -> Optional[str]:
        """
        Gets or sets the App ID of the Facebook app used for login.
                    This setting is required for enabling Facebook Login.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_app_id")

    @property
    @pulumi.getter(name="facebookAppSecret")
    def facebook_app_secret(self) -> Optional[str]:
        """
        Gets or sets the App Secret of the Facebook app used for Facebook Login.
                    This setting is required for enabling Facebook Login.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_app_secret")

    @property
    @pulumi.getter(name="facebookOAuthScopes")
    def facebook_o_auth_scopes(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
                    This setting is optional.
                    Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
        """
        return pulumi.get(self, "facebook_o_auth_scopes")

    @property
    @pulumi.getter(name="googleClientId")
    def google_client_id(self) -> Optional[str]:
        """
        Gets or sets the OpenID Connect Client ID for the Google web application.
                    This setting is required for enabling Google Sign-In.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_client_id")

    @property
    @pulumi.getter(name="googleClientSecret")
    def google_client_secret(self) -> Optional[str]:
        """
        Gets or sets the client secret associated with the Google web application.
                    This setting is required for enabling Google Sign-In.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_client_secret")

    @property
    @pulumi.getter(name="googleOAuthScopes")
    def google_o_auth_scopes(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
                    This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
                    Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
        """
        return pulumi.get(self, "google_o_auth_scopes")

    @property
    @pulumi.getter(name="httpApiPrefixPath")
    def http_api_prefix_path(self) -> Optional[str]:
        """
        Gets or sets the relative path prefix used by platform HTTP APIs.
                    Changing this value is not recommended except for compatibility reasons.
        """
        return pulumi.get(self, "http_api_prefix_path")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        """
        Gets or sets the OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
                    When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
                    This URI is a case-sensitive identifier for the token issuer.
                    More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="microsoftAccountClientId")
    def microsoft_account_client_id(self) -> Optional[str]:
        """
        Gets or sets the OAuth 2.0 client ID that was created for the app used for authentication.
                    This setting is required for enabling Microsoft Account authentication.
                    Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        """
        return pulumi.get(self, "microsoft_account_client_id")

    @property
    @pulumi.getter(name="microsoftAccountClientSecret")
    def microsoft_account_client_secret(self) -> Optional[str]:
        """
        Gets or sets the OAuth 2.0 client secret that was created for the app used for authentication.
                    This setting is required for enabling Microsoft Account authentication.
                    Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
        """
        return pulumi.get(self, "microsoft_account_client_secret")

    @property
    @pulumi.getter(name="microsoftAccountOAuthScopes")
    def microsoft_account_o_auth_scopes(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
                    This setting is optional. If not specified, "wl.basic" is used as the default scope.
                    Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
        """
        return pulumi.get(self, "microsoft_account_o_auth_scopes")

    @property
    @pulumi.getter(name="openIdIssuer")
    def open_id_issuer(self) -> Optional[str]:
        return pulumi.get(self, "open_id_issuer")

    @property
    @pulumi.getter(name="tokenRefreshExtensionHours")
    def token_refresh_extension_hours(self) -> Optional[float]:
        """
        Gets or sets the number of hours after session token expiration that a session token can be used to
                    call the token refresh API. The default is 72 hours.
        """
        return pulumi.get(self, "token_refresh_extension_hours")

    @property
    @pulumi.getter(name="tokenStoreEnabled")
    def token_store_enabled(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether to durably store platform-specific security tokens
                    obtained during login flows. This capability is disabled by default.
        """
        return pulumi.get(self, "token_store_enabled")

    @property
    @pulumi.getter(name="twitterConsumerKey")
    def twitter_consumer_key(self) -> Optional[str]:
        """
        Gets or sets the OAuth 1.0a consumer key of the Twitter application used for sign-in.
                    This setting is required for enabling Twitter Sign-In.
                    Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "twitter_consumer_key")

    @property
    @pulumi.getter(name="twitterConsumerSecret")
    def twitter_consumer_secret(self) -> Optional[str]:
        """
        Gets or sets the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
                    This setting is required for enabling Twitter Sign-In.
                    Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "twitter_consumer_secret")

    @property
    @pulumi.getter(name="unauthenticatedClientAction")
    def unauthenticated_client_action(self) -> Optional[str]:
        """
        Gets or sets the action to take when an unauthenticated client attempts to access the app.
        """
        return pulumi.get(self, "unauthenticated_client_action")


class AwaitableListSiteAuthSettingsSlotResult(ListSiteAuthSettingsSlotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListSiteAuthSettingsSlotResult(
            aad_client_id=self.aad_client_id,
            additional_login_params=self.additional_login_params,
            allowed_audiences=self.allowed_audiences,
            allowed_external_redirect_urls=self.allowed_external_redirect_urls,
            client_id=self.client_id,
            client_secret=self.client_secret,
            default_provider=self.default_provider,
            enabled=self.enabled,
            facebook_app_id=self.facebook_app_id,
            facebook_app_secret=self.facebook_app_secret,
            facebook_o_auth_scopes=self.facebook_o_auth_scopes,
            google_client_id=self.google_client_id,
            google_client_secret=self.google_client_secret,
            google_o_auth_scopes=self.google_o_auth_scopes,
            http_api_prefix_path=self.http_api_prefix_path,
            issuer=self.issuer,
            microsoft_account_client_id=self.microsoft_account_client_id,
            microsoft_account_client_secret=self.microsoft_account_client_secret,
            microsoft_account_o_auth_scopes=self.microsoft_account_o_auth_scopes,
            open_id_issuer=self.open_id_issuer,
            token_refresh_extension_hours=self.token_refresh_extension_hours,
            token_store_enabled=self.token_store_enabled,
            twitter_consumer_key=self.twitter_consumer_key,
            twitter_consumer_secret=self.twitter_consumer_secret,
            unauthenticated_client_action=self.unauthenticated_client_action)


def list_site_auth_settings_slot(name: Optional[str] = None,
                                 resource_group_name: Optional[str] = None,
                                 slot: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListSiteAuthSettingsSlotResult:
    """
    Configuration settings for the Azure App Service Authentication / Authorization feature.


    :param str name: Name of web app
    :param str resource_group_name: Name of resource group
    :param str slot: Name of web app slot. If not specified then will default to production slot.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['slot'] = slot
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:web/v20150801:listSiteAuthSettingsSlot', __args__, opts=opts, typ=ListSiteAuthSettingsSlotResult).value

    return AwaitableListSiteAuthSettingsSlotResult(
        aad_client_id=__ret__.aad_client_id,
        additional_login_params=__ret__.additional_login_params,
        allowed_audiences=__ret__.allowed_audiences,
        allowed_external_redirect_urls=__ret__.allowed_external_redirect_urls,
        client_id=__ret__.client_id,
        client_secret=__ret__.client_secret,
        default_provider=__ret__.default_provider,
        enabled=__ret__.enabled,
        facebook_app_id=__ret__.facebook_app_id,
        facebook_app_secret=__ret__.facebook_app_secret,
        facebook_o_auth_scopes=__ret__.facebook_o_auth_scopes,
        google_client_id=__ret__.google_client_id,
        google_client_secret=__ret__.google_client_secret,
        google_o_auth_scopes=__ret__.google_o_auth_scopes,
        http_api_prefix_path=__ret__.http_api_prefix_path,
        issuer=__ret__.issuer,
        microsoft_account_client_id=__ret__.microsoft_account_client_id,
        microsoft_account_client_secret=__ret__.microsoft_account_client_secret,
        microsoft_account_o_auth_scopes=__ret__.microsoft_account_o_auth_scopes,
        open_id_issuer=__ret__.open_id_issuer,
        token_refresh_extension_hours=__ret__.token_refresh_extension_hours,
        token_store_enabled=__ret__.token_store_enabled,
        twitter_consumer_key=__ret__.twitter_consumer_key,
        twitter_consumer_secret=__ret__.twitter_consumer_secret,
        unauthenticated_client_action=__ret__.unauthenticated_client_action)


@_utilities.lift_output_func(list_site_auth_settings_slot)
def list_site_auth_settings_slot_output(name: Optional[pulumi.Input[str]] = None,
                                        resource_group_name: Optional[pulumi.Input[str]] = None,
                                        slot: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListSiteAuthSettingsSlotResult]:
    """
    Configuration settings for the Azure App Service Authentication / Authorization feature.


    :param str name: Name of web app
    :param str resource_group_name: Name of resource group
    :param str slot: Name of web app slot. If not specified then will default to production slot.
    """
    ...
