# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CacheActiveDirectorySettingsResponse',
    'CacheActiveDirectorySettingsResponseCredentials',
    'CacheDirectorySettingsResponse',
    'CacheEncryptionSettingsResponse',
    'CacheHealthResponse',
    'CacheIdentityResponse',
    'CacheNetworkSettingsResponse',
    'CacheResponseSku',
    'CacheSecuritySettingsResponse',
    'CacheUpgradeStatusResponse',
    'CacheUsernameDownloadSettingsResponse',
    'CacheUsernameDownloadSettingsResponseCredentials',
    'ClfsTargetResponse',
    'KeyVaultKeyReferenceResponse',
    'KeyVaultKeyReferenceResponseSourceVault',
    'NamespaceJunctionResponse',
    'Nfs3TargetResponse',
    'NfsAccessPolicyResponse',
    'NfsAccessRuleResponse',
    'SystemDataResponse',
    'UnknownTargetResponse',
]

@pulumi.output_type
class CacheActiveDirectorySettingsResponse(dict):
    """
    Active Directory settings used to join a cache to a domain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheNetBiosName":
            suggest = "cache_net_bios_name"
        elif key == "domainJoined":
            suggest = "domain_joined"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "domainNetBiosName":
            suggest = "domain_net_bios_name"
        elif key == "primaryDnsIpAddress":
            suggest = "primary_dns_ip_address"
        elif key == "secondaryDnsIpAddress":
            suggest = "secondary_dns_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheActiveDirectorySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheActiveDirectorySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheActiveDirectorySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_net_bios_name: str,
                 domain_joined: str,
                 domain_name: str,
                 domain_net_bios_name: str,
                 primary_dns_ip_address: str,
                 credentials: Optional['outputs.CacheActiveDirectorySettingsResponseCredentials'] = None,
                 secondary_dns_ip_address: Optional[str] = None):
        """
        Active Directory settings used to join a cache to a domain.
        :param str cache_net_bios_name: The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
        :param str domain_joined: True if the HPC Cache is joined to the Active Directory domain.
        :param str domain_name: The fully qualified domain name of the Active Directory domain controller.
        :param str domain_net_bios_name: The Active Directory domain's NetBIOS name.
        :param str primary_dns_ip_address: Primary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
        :param 'CacheActiveDirectorySettingsResponseCredentials' credentials: Active Directory admin credentials used to join the HPC Cache to a domain.
        :param str secondary_dns_ip_address: Secondary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
        """
        pulumi.set(__self__, "cache_net_bios_name", cache_net_bios_name)
        pulumi.set(__self__, "domain_joined", domain_joined)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_net_bios_name", domain_net_bios_name)
        pulumi.set(__self__, "primary_dns_ip_address", primary_dns_ip_address)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if secondary_dns_ip_address is not None:
            pulumi.set(__self__, "secondary_dns_ip_address", secondary_dns_ip_address)

    @property
    @pulumi.getter(name="cacheNetBiosName")
    def cache_net_bios_name(self) -> str:
        """
        The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
        """
        return pulumi.get(self, "cache_net_bios_name")

    @property
    @pulumi.getter(name="domainJoined")
    def domain_joined(self) -> str:
        """
        True if the HPC Cache is joined to the Active Directory domain.
        """
        return pulumi.get(self, "domain_joined")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The fully qualified domain name of the Active Directory domain controller.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainNetBiosName")
    def domain_net_bios_name(self) -> str:
        """
        The Active Directory domain's NetBIOS name.
        """
        return pulumi.get(self, "domain_net_bios_name")

    @property
    @pulumi.getter(name="primaryDnsIpAddress")
    def primary_dns_ip_address(self) -> str:
        """
        Primary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
        """
        return pulumi.get(self, "primary_dns_ip_address")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.CacheActiveDirectorySettingsResponseCredentials']:
        """
        Active Directory admin credentials used to join the HPC Cache to a domain.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="secondaryDnsIpAddress")
    def secondary_dns_ip_address(self) -> Optional[str]:
        """
        Secondary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
        """
        return pulumi.get(self, "secondary_dns_ip_address")


@pulumi.output_type
class CacheActiveDirectorySettingsResponseCredentials(dict):
    """
    Active Directory admin credentials used to join the HPC Cache to a domain.
    """
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        Active Directory admin credentials used to join the HPC Cache to a domain.
        :param str password: Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
        :param str username: Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class CacheDirectorySettingsResponse(dict):
    """
    Cache Directory Services settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectory":
            suggest = "active_directory"
        elif key == "usernameDownload":
            suggest = "username_download"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheDirectorySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheDirectorySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheDirectorySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory: Optional['outputs.CacheActiveDirectorySettingsResponse'] = None,
                 username_download: Optional['outputs.CacheUsernameDownloadSettingsResponse'] = None):
        """
        Cache Directory Services settings.
        :param 'CacheActiveDirectorySettingsResponse' active_directory: Specifies settings for joining the HPC Cache to an Active Directory domain.
        :param 'CacheUsernameDownloadSettingsResponse' username_download: Specifies settings for Extended Groups. Extended Groups allows users to be members of more than 16 groups.
        """
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if username_download is not None:
            pulumi.set(__self__, "username_download", username_download)

    @property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional['outputs.CacheActiveDirectorySettingsResponse']:
        """
        Specifies settings for joining the HPC Cache to an Active Directory domain.
        """
        return pulumi.get(self, "active_directory")

    @property
    @pulumi.getter(name="usernameDownload")
    def username_download(self) -> Optional['outputs.CacheUsernameDownloadSettingsResponse']:
        """
        Specifies settings for Extended Groups. Extended Groups allows users to be members of more than 16 groups.
        """
        return pulumi.get(self, "username_download")


@pulumi.output_type
class CacheEncryptionSettingsResponse(dict):
    """
    Cache encryption settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheEncryptionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheEncryptionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheEncryptionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_encryption_key: Optional['outputs.KeyVaultKeyReferenceResponse'] = None):
        """
        Cache encryption settings.
        :param 'KeyVaultKeyReferenceResponse' key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        """
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.KeyVaultKeyReferenceResponse']:
        """
        Specifies the location of the key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class CacheHealthResponse(dict):
    """
    An indication of Cache health. Gives more information about health than just that related to provisioning.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusDescription":
            suggest = "status_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheHealthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheHealthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheHealthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: Optional[str] = None,
                 status_description: Optional[str] = None):
        """
        An indication of Cache health. Gives more information about health than just that related to provisioning.
        :param str state: List of Cache health states.
        :param str status_description: Describes explanation of state.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status_description is not None:
            pulumi.set(__self__, "status_description", status_description)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        List of Cache health states.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> Optional[str]:
        """
        Describes explanation of state.
        """
        return pulumi.get(self, "status_description")


@pulumi.output_type
class CacheIdentityResponse(dict):
    """
    Cache identity properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Cache identity properties.
        :param str principal_id: The principal id of the cache.
        :param str tenant_id: The tenant id associated with the cache.
        :param str type: The type of identity used for the cache
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the cache.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the cache.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the cache
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CacheNetworkSettingsResponse(dict):
    """
    Cache network settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "utilityAddresses":
            suggest = "utility_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheNetworkSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheNetworkSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheNetworkSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 utility_addresses: Sequence[str],
                 mtu: Optional[int] = None):
        """
        Cache network settings.
        :param Sequence[str] utility_addresses: Array of additional IP addresses used by this Cache.
        :param int mtu: The IPv4 maximum transmission unit configured for the subnet.
        """
        pulumi.set(__self__, "utility_addresses", utility_addresses)
        if mtu is None:
            mtu = 1500
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)

    @property
    @pulumi.getter(name="utilityAddresses")
    def utility_addresses(self) -> Sequence[str]:
        """
        Array of additional IP addresses used by this Cache.
        """
        return pulumi.get(self, "utility_addresses")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[int]:
        """
        The IPv4 maximum transmission unit configured for the subnet.
        """
        return pulumi.get(self, "mtu")


@pulumi.output_type
class CacheResponseSku(dict):
    """
    SKU for the Cache.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU for the Cache.
        :param str name: SKU name for this Cache.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        SKU name for this Cache.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CacheSecuritySettingsResponse(dict):
    """
    Cache security settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPolicies":
            suggest = "access_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheSecuritySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheSecuritySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheSecuritySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_policies: Optional[Sequence['outputs.NfsAccessPolicyResponse']] = None):
        """
        Cache security settings.
        :param Sequence['NfsAccessPolicyResponse'] access_policies: NFS access policies defined for this cache.
        """
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[Sequence['outputs.NfsAccessPolicyResponse']]:
        """
        NFS access policies defined for this cache.
        """
        return pulumi.get(self, "access_policies")


@pulumi.output_type
class CacheUpgradeStatusResponse(dict):
    """
    Properties describing the software upgrade state of the Cache.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentFirmwareVersion":
            suggest = "current_firmware_version"
        elif key == "firmwareUpdateDeadline":
            suggest = "firmware_update_deadline"
        elif key == "firmwareUpdateStatus":
            suggest = "firmware_update_status"
        elif key == "lastFirmwareUpdate":
            suggest = "last_firmware_update"
        elif key == "pendingFirmwareVersion":
            suggest = "pending_firmware_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheUpgradeStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheUpgradeStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheUpgradeStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_firmware_version: str,
                 firmware_update_deadline: str,
                 firmware_update_status: str,
                 last_firmware_update: str,
                 pending_firmware_version: str):
        """
        Properties describing the software upgrade state of the Cache.
        :param str current_firmware_version: Version string of the firmware currently installed on this Cache.
        :param str firmware_update_deadline: Time at which the pending firmware update will automatically be installed on the Cache.
        :param str firmware_update_status: True if there is a firmware update ready to install on this Cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
        :param str last_firmware_update: Time of the last successful firmware update.
        :param str pending_firmware_version: When firmwareUpdateAvailable is true, this field holds the version string for the update.
        """
        pulumi.set(__self__, "current_firmware_version", current_firmware_version)
        pulumi.set(__self__, "firmware_update_deadline", firmware_update_deadline)
        pulumi.set(__self__, "firmware_update_status", firmware_update_status)
        pulumi.set(__self__, "last_firmware_update", last_firmware_update)
        pulumi.set(__self__, "pending_firmware_version", pending_firmware_version)

    @property
    @pulumi.getter(name="currentFirmwareVersion")
    def current_firmware_version(self) -> str:
        """
        Version string of the firmware currently installed on this Cache.
        """
        return pulumi.get(self, "current_firmware_version")

    @property
    @pulumi.getter(name="firmwareUpdateDeadline")
    def firmware_update_deadline(self) -> str:
        """
        Time at which the pending firmware update will automatically be installed on the Cache.
        """
        return pulumi.get(self, "firmware_update_deadline")

    @property
    @pulumi.getter(name="firmwareUpdateStatus")
    def firmware_update_status(self) -> str:
        """
        True if there is a firmware update ready to install on this Cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
        """
        return pulumi.get(self, "firmware_update_status")

    @property
    @pulumi.getter(name="lastFirmwareUpdate")
    def last_firmware_update(self) -> str:
        """
        Time of the last successful firmware update.
        """
        return pulumi.get(self, "last_firmware_update")

    @property
    @pulumi.getter(name="pendingFirmwareVersion")
    def pending_firmware_version(self) -> str:
        """
        When firmwareUpdateAvailable is true, this field holds the version string for the update.
        """
        return pulumi.get(self, "pending_firmware_version")


@pulumi.output_type
class CacheUsernameDownloadSettingsResponse(dict):
    """
    Settings for Extended Groups username and group download.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usernameDownloaded":
            suggest = "username_downloaded"
        elif key == "autoDownloadCertificate":
            suggest = "auto_download_certificate"
        elif key == "caCertificateURI":
            suggest = "ca_certificate_uri"
        elif key == "encryptLdapConnection":
            suggest = "encrypt_ldap_connection"
        elif key == "extendedGroups":
            suggest = "extended_groups"
        elif key == "groupFileURI":
            suggest = "group_file_uri"
        elif key == "ldapBaseDN":
            suggest = "ldap_base_dn"
        elif key == "ldapServer":
            suggest = "ldap_server"
        elif key == "requireValidCertificate":
            suggest = "require_valid_certificate"
        elif key == "userFileURI":
            suggest = "user_file_uri"
        elif key == "usernameSource":
            suggest = "username_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheUsernameDownloadSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheUsernameDownloadSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheUsernameDownloadSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 username_downloaded: str,
                 auto_download_certificate: Optional[bool] = None,
                 ca_certificate_uri: Optional[str] = None,
                 credentials: Optional['outputs.CacheUsernameDownloadSettingsResponseCredentials'] = None,
                 encrypt_ldap_connection: Optional[bool] = None,
                 extended_groups: Optional[bool] = None,
                 group_file_uri: Optional[str] = None,
                 ldap_base_dn: Optional[str] = None,
                 ldap_server: Optional[str] = None,
                 require_valid_certificate: Optional[bool] = None,
                 user_file_uri: Optional[str] = None,
                 username_source: Optional[str] = None):
        """
        Settings for Extended Groups username and group download.
        :param str username_downloaded: Indicates whether or not the HPC Cache has performed the username download successfully.
        :param bool auto_download_certificate: Determines if the certificate should be automatically downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
        :param str ca_certificate_uri: The URI of the CA certificate to validate the LDAP secure connection. This field must be populated when 'requireValidCertificate' is set to true.
        :param 'CacheUsernameDownloadSettingsResponseCredentials' credentials: When present, these are the credentials for the secure LDAP connection.
        :param bool encrypt_ldap_connection: Whether or not the LDAP connection should be encrypted.
        :param bool extended_groups: Whether or not Extended Groups is enabled.
        :param str group_file_uri: The URI of the file containing group information (in /etc/group file format). This field must be populated when 'usernameSource' is set to 'File'.
        :param str ldap_base_dn: The base distinguished name for the LDAP domain.
        :param str ldap_server: The fully qualified domain name or IP address of the LDAP server to use.
        :param bool require_valid_certificate: Determines if the certificates must be validated by a certificate authority. When true, caCertificateURI must be provided.
        :param str user_file_uri: The URI of the file containing user information (in /etc/passwd file format). This field must be populated when 'usernameSource' is set to 'File'.
        :param str username_source: This setting determines how the cache gets username and group names for clients.
        """
        pulumi.set(__self__, "username_downloaded", username_downloaded)
        if auto_download_certificate is not None:
            pulumi.set(__self__, "auto_download_certificate", auto_download_certificate)
        if ca_certificate_uri is not None:
            pulumi.set(__self__, "ca_certificate_uri", ca_certificate_uri)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if encrypt_ldap_connection is not None:
            pulumi.set(__self__, "encrypt_ldap_connection", encrypt_ldap_connection)
        if extended_groups is not None:
            pulumi.set(__self__, "extended_groups", extended_groups)
        if group_file_uri is not None:
            pulumi.set(__self__, "group_file_uri", group_file_uri)
        if ldap_base_dn is not None:
            pulumi.set(__self__, "ldap_base_dn", ldap_base_dn)
        if ldap_server is not None:
            pulumi.set(__self__, "ldap_server", ldap_server)
        if require_valid_certificate is not None:
            pulumi.set(__self__, "require_valid_certificate", require_valid_certificate)
        if user_file_uri is not None:
            pulumi.set(__self__, "user_file_uri", user_file_uri)
        if username_source is None:
            username_source = 'None'
        if username_source is not None:
            pulumi.set(__self__, "username_source", username_source)

    @property
    @pulumi.getter(name="usernameDownloaded")
    def username_downloaded(self) -> str:
        """
        Indicates whether or not the HPC Cache has performed the username download successfully.
        """
        return pulumi.get(self, "username_downloaded")

    @property
    @pulumi.getter(name="autoDownloadCertificate")
    def auto_download_certificate(self) -> Optional[bool]:
        """
        Determines if the certificate should be automatically downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true.
        """
        return pulumi.get(self, "auto_download_certificate")

    @property
    @pulumi.getter(name="caCertificateURI")
    def ca_certificate_uri(self) -> Optional[str]:
        """
        The URI of the CA certificate to validate the LDAP secure connection. This field must be populated when 'requireValidCertificate' is set to true.
        """
        return pulumi.get(self, "ca_certificate_uri")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.CacheUsernameDownloadSettingsResponseCredentials']:
        """
        When present, these are the credentials for the secure LDAP connection.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="encryptLdapConnection")
    def encrypt_ldap_connection(self) -> Optional[bool]:
        """
        Whether or not the LDAP connection should be encrypted.
        """
        return pulumi.get(self, "encrypt_ldap_connection")

    @property
    @pulumi.getter(name="extendedGroups")
    def extended_groups(self) -> Optional[bool]:
        """
        Whether or not Extended Groups is enabled.
        """
        return pulumi.get(self, "extended_groups")

    @property
    @pulumi.getter(name="groupFileURI")
    def group_file_uri(self) -> Optional[str]:
        """
        The URI of the file containing group information (in /etc/group file format). This field must be populated when 'usernameSource' is set to 'File'.
        """
        return pulumi.get(self, "group_file_uri")

    @property
    @pulumi.getter(name="ldapBaseDN")
    def ldap_base_dn(self) -> Optional[str]:
        """
        The base distinguished name for the LDAP domain.
        """
        return pulumi.get(self, "ldap_base_dn")

    @property
    @pulumi.getter(name="ldapServer")
    def ldap_server(self) -> Optional[str]:
        """
        The fully qualified domain name or IP address of the LDAP server to use.
        """
        return pulumi.get(self, "ldap_server")

    @property
    @pulumi.getter(name="requireValidCertificate")
    def require_valid_certificate(self) -> Optional[bool]:
        """
        Determines if the certificates must be validated by a certificate authority. When true, caCertificateURI must be provided.
        """
        return pulumi.get(self, "require_valid_certificate")

    @property
    @pulumi.getter(name="userFileURI")
    def user_file_uri(self) -> Optional[str]:
        """
        The URI of the file containing user information (in /etc/passwd file format). This field must be populated when 'usernameSource' is set to 'File'.
        """
        return pulumi.get(self, "user_file_uri")

    @property
    @pulumi.getter(name="usernameSource")
    def username_source(self) -> Optional[str]:
        """
        This setting determines how the cache gets username and group names for clients.
        """
        return pulumi.get(self, "username_source")


@pulumi.output_type
class CacheUsernameDownloadSettingsResponseCredentials(dict):
    """
    When present, these are the credentials for the secure LDAP connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindDn":
            suggest = "bind_dn"
        elif key == "bindPassword":
            suggest = "bind_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheUsernameDownloadSettingsResponseCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheUsernameDownloadSettingsResponseCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheUsernameDownloadSettingsResponseCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bind_dn: Optional[str] = None,
                 bind_password: Optional[str] = None):
        """
        When present, these are the credentials for the secure LDAP connection.
        :param str bind_dn: The Bind Distinguished Name identity to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
        :param str bind_password: The Bind password to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
        """
        if bind_dn is not None:
            pulumi.set(__self__, "bind_dn", bind_dn)
        if bind_password is not None:
            pulumi.set(__self__, "bind_password", bind_password)

    @property
    @pulumi.getter(name="bindDn")
    def bind_dn(self) -> Optional[str]:
        """
        The Bind Distinguished Name identity to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
        """
        return pulumi.get(self, "bind_dn")

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> Optional[str]:
        """
        The Bind password to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
        """
        return pulumi.get(self, "bind_password")


@pulumi.output_type
class ClfsTargetResponse(dict):
    """
    Properties pertaining to the ClfsTarget
    """
    def __init__(__self__, *,
                 target: Optional[str] = None):
        """
        Properties pertaining to the ClfsTarget
        :param str target: Resource ID of storage container.
        """
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Resource ID of storage container.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class KeyVaultKeyReferenceResponse(dict):
    """
    Describes a reference to Key Vault Key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: 'outputs.KeyVaultKeyReferenceResponseSourceVault'):
        """
        Describes a reference to Key Vault Key.
        :param str key_url: The URL referencing a key encryption key in Key Vault.
        :param 'KeyVaultKeyReferenceResponseSourceVault' source_vault: Describes a resource Id to source Key Vault.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        The URL referencing a key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.KeyVaultKeyReferenceResponseSourceVault':
        """
        Describes a resource Id to source Key Vault.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultKeyReferenceResponseSourceVault(dict):
    """
    Describes a resource Id to source Key Vault.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Describes a resource Id to source Key Vault.
        :param str id: Resource Id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class NamespaceJunctionResponse(dict):
    """
    A namespace junction.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacePath":
            suggest = "namespace_path"
        elif key == "nfsAccessPolicy":
            suggest = "nfs_access_policy"
        elif key == "nfsExport":
            suggest = "nfs_export"
        elif key == "targetPath":
            suggest = "target_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceJunctionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceJunctionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceJunctionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace_path: Optional[str] = None,
                 nfs_access_policy: Optional[str] = None,
                 nfs_export: Optional[str] = None,
                 target_path: Optional[str] = None):
        """
        A namespace junction.
        :param str namespace_path: Namespace path on a Cache for a Storage Target.
        :param str nfs_access_policy: Name of the access policy applied to this junction.
        :param str nfs_export: NFS export where targetPath exists.
        :param str target_path: Path in Storage Target to which namespacePath points.
        """
        if namespace_path is not None:
            pulumi.set(__self__, "namespace_path", namespace_path)
        if nfs_access_policy is not None:
            pulumi.set(__self__, "nfs_access_policy", nfs_access_policy)
        if nfs_export is not None:
            pulumi.set(__self__, "nfs_export", nfs_export)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)

    @property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> Optional[str]:
        """
        Namespace path on a Cache for a Storage Target.
        """
        return pulumi.get(self, "namespace_path")

    @property
    @pulumi.getter(name="nfsAccessPolicy")
    def nfs_access_policy(self) -> Optional[str]:
        """
        Name of the access policy applied to this junction.
        """
        return pulumi.get(self, "nfs_access_policy")

    @property
    @pulumi.getter(name="nfsExport")
    def nfs_export(self) -> Optional[str]:
        """
        NFS export where targetPath exists.
        """
        return pulumi.get(self, "nfs_export")

    @property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[str]:
        """
        Path in Storage Target to which namespacePath points.
        """
        return pulumi.get(self, "target_path")


@pulumi.output_type
class Nfs3TargetResponse(dict):
    """
    Properties pertaining to the Nfs3Target
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usageModel":
            suggest = "usage_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Nfs3TargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Nfs3TargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Nfs3TargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target: Optional[str] = None,
                 usage_model: Optional[str] = None):
        """
        Properties pertaining to the Nfs3Target
        :param str target: IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
        :param str usage_model: Identifies the usage model to be used for this Storage Target. Get choices from .../usageModels
        """
        if target is not None:
            pulumi.set(__self__, "target", target)
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> Optional[str]:
        """
        Identifies the usage model to be used for this Storage Target. Get choices from .../usageModels
        """
        return pulumi.get(self, "usage_model")


@pulumi.output_type
class NfsAccessPolicyResponse(dict):
    """
    A set of rules describing access policies applied to NFSv3 clients of the cache.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessRules":
            suggest = "access_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NfsAccessPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NfsAccessPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NfsAccessPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_rules: Sequence['outputs.NfsAccessRuleResponse'],
                 name: str):
        """
        A set of rules describing access policies applied to NFSv3 clients of the cache.
        :param Sequence['NfsAccessRuleResponse'] access_rules: The set of rules describing client accesses allowed under this policy.
        :param str name: Name identifying this policy. Access Policy names are not case sensitive.
        """
        pulumi.set(__self__, "access_rules", access_rules)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accessRules")
    def access_rules(self) -> Sequence['outputs.NfsAccessRuleResponse']:
        """
        The set of rules describing client accesses allowed under this policy.
        """
        return pulumi.get(self, "access_rules")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name identifying this policy. Access Policy names are not case sensitive.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NfsAccessRuleResponse(dict):
    """
    Rule to place restrictions on portions of the cache namespace being presented to clients.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anonymousGID":
            suggest = "anonymous_gid"
        elif key == "anonymousUID":
            suggest = "anonymous_uid"
        elif key == "rootSquash":
            suggest = "root_squash"
        elif key == "submountAccess":
            suggest = "submount_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NfsAccessRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NfsAccessRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NfsAccessRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 scope: str,
                 anonymous_gid: Optional[str] = None,
                 anonymous_uid: Optional[str] = None,
                 filter: Optional[str] = None,
                 root_squash: Optional[bool] = None,
                 submount_access: Optional[bool] = None,
                 suid: Optional[bool] = None):
        """
        Rule to place restrictions on portions of the cache namespace being presented to clients.
        :param str access: Access allowed by this rule.
        :param str scope: Scope for this rule. The scope and filter determine which clients match the rule.
        :param str anonymous_gid: GID value that replaces 0 when rootSquash is true.
        :param str anonymous_uid: UID value that replaces 0 when rootSquash is true.
        :param str filter: Filter applied to the scope for this rule. The filter's format depends on its scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully qualified domain name as filter. If a client does not match any filter rule and there is no default rule, access is denied.
        :param bool root_squash: Map root accesses to anonymousUID and anonymousGID.
        :param bool submount_access: For the default policy, allow access to subdirectories under the root export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can mount a deeper path, like '/a/b'.
        :param bool suid: Allow SUID semantics.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "scope", scope)
        if anonymous_gid is None:
            anonymous_gid = '-2'
        if anonymous_gid is not None:
            pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        if anonymous_uid is None:
            anonymous_uid = '-2'
        if anonymous_uid is not None:
            pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if root_squash is not None:
            pulumi.set(__self__, "root_squash", root_squash)
        if submount_access is not None:
            pulumi.set(__self__, "submount_access", submount_access)
        if suid is not None:
            pulumi.set(__self__, "suid", suid)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        Access allowed by this rule.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Scope for this rule. The scope and filter determine which clients match the rule.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="anonymousGID")
    def anonymous_gid(self) -> Optional[str]:
        """
        GID value that replaces 0 when rootSquash is true.
        """
        return pulumi.get(self, "anonymous_gid")

    @property
    @pulumi.getter(name="anonymousUID")
    def anonymous_uid(self) -> Optional[str]:
        """
        UID value that replaces 0 when rootSquash is true.
        """
        return pulumi.get(self, "anonymous_uid")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        Filter applied to the scope for this rule. The filter's format depends on its scope. 'default' scope matches all clients and has no filter value. 'network' scope takes a filter in CIDR format (for example, 10.99.1.0/24). 'host' takes an IP address or fully qualified domain name as filter. If a client does not match any filter rule and there is no default rule, access is denied.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="rootSquash")
    def root_squash(self) -> Optional[bool]:
        """
        Map root accesses to anonymousUID and anonymousGID.
        """
        return pulumi.get(self, "root_squash")

    @property
    @pulumi.getter(name="submountAccess")
    def submount_access(self) -> Optional[bool]:
        """
        For the default policy, allow access to subdirectories under the root export. If this is set to no, clients can only mount the path '/'. If set to yes, clients can mount a deeper path, like '/a/b'.
        """
        return pulumi.get(self, "submount_access")

    @property
    @pulumi.getter
    def suid(self) -> Optional[bool]:
        """
        Allow SUID semantics.
        """
        return pulumi.get(self, "suid")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UnknownTargetResponse(dict):
    """
    Properties pertaining to the UnknownTarget
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unknownMap":
            suggest = "unknown_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UnknownTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UnknownTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UnknownTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unknown_map: Optional[Mapping[str, str]] = None):
        """
        Properties pertaining to the UnknownTarget
        :param Mapping[str, str] unknown_map: Dictionary of string->string pairs containing information about the Storage Target.
        """
        if unknown_map is not None:
            pulumi.set(__self__, "unknown_map", unknown_map)

    @property
    @pulumi.getter(name="unknownMap")
    def unknown_map(self) -> Optional[Mapping[str, str]]:
        """
        Dictionary of string->string pairs containing information about the Storage Target.
        """
        return pulumi.get(self, "unknown_map")


