# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['DatabaseAccountArgs', 'DatabaseAccount']

@pulumi.input_type
class DatabaseAccountArgs:
    def __init__(__self__, *,
                 database_account_offer_type: pulumi.Input['DatabaseAccountOfferType'],
                 locations: pulumi.Input[Sequence[pulumi.Input['LocationArgs']]],
                 resource_group_name: pulumi.Input[str],
                 account_name: Optional[pulumi.Input[str]] = None,
                 analytical_storage_configuration: Optional[pulumi.Input['AnalyticalStorageConfigurationArgs']] = None,
                 api_properties: Optional[pulumi.Input['ApiPropertiesArgs']] = None,
                 backup_policy: Optional[pulumi.Input[Union['ContinuousModeBackupPolicyArgs', 'PeriodicModeBackupPolicyArgs']]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]]] = None,
                 capacity: Optional[pulumi.Input['CapacityArgs']] = None,
                 connector_offer: Optional[pulumi.Input[Union[str, 'ConnectorOffer']]] = None,
                 consistency_policy: Optional[pulumi.Input['ConsistencyPolicyArgs']] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input['CorsPolicyArgs']]]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 default_identity: Optional[pulumi.Input[str]] = None,
                 diagnostic_log_settings: Optional[pulumi.Input['DiagnosticLogSettingsArgs']] = None,
                 disable_key_based_metadata_write_access: Optional[pulumi.Input[bool]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 enable_analytical_storage: Optional[pulumi.Input[bool]] = None,
                 enable_automatic_failover: Optional[pulumi.Input[bool]] = None,
                 enable_cassandra_connector: Optional[pulumi.Input[bool]] = None,
                 enable_free_tier: Optional[pulumi.Input[bool]] = None,
                 enable_multiple_write_locations: Optional[pulumi.Input[bool]] = None,
                 identity: Optional[pulumi.Input['ManagedServiceIdentityArgs']] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressOrRangeArgs']]]] = None,
                 is_virtual_network_filter_enabled: Optional[pulumi.Input[bool]] = None,
                 key_vault_key_uri: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'DatabaseAccountKind']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network_acl_bypass: Optional[pulumi.Input['NetworkAclBypass']] = None,
                 network_acl_bypass_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]] = None,
                 restore_parameters: Optional[pulumi.Input['RestoreParametersArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]] = None):
        """
        The set of arguments for constructing a DatabaseAccount resource.
        :param pulumi.Input['DatabaseAccountOfferType'] database_account_offer_type: The offer type for the database
        :param pulumi.Input[Sequence[pulumi.Input['LocationArgs']]] locations: An array that contains the georeplication locations enabled for the Cosmos DB account.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] account_name: Cosmos DB database account name.
        :param pulumi.Input['AnalyticalStorageConfigurationArgs'] analytical_storage_configuration: Analytical storage specific properties.
        :param pulumi.Input['ApiPropertiesArgs'] api_properties: API specific properties. Currently, supported only for MongoDB API.
        :param pulumi.Input[Union['ContinuousModeBackupPolicyArgs', 'PeriodicModeBackupPolicyArgs']] backup_policy: The object representing the policy for taking backups on an account.
        :param pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]] capabilities: List of Cosmos DB capabilities for the account
        :param pulumi.Input['CapacityArgs'] capacity: The object that represents all properties related to capacity enforcement on an account.
        :param pulumi.Input[Union[str, 'ConnectorOffer']] connector_offer: The cassandra connector offer type for the Cosmos DB database C* account.
        :param pulumi.Input['ConsistencyPolicyArgs'] consistency_policy: The consistency policy for the Cosmos DB account.
        :param pulumi.Input[Sequence[pulumi.Input['CorsPolicyArgs']]] cors: The CORS policy for the Cosmos DB database account.
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Enum to indicate the mode of account creation.
        :param pulumi.Input[str] default_identity: The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
        :param pulumi.Input['DiagnosticLogSettingsArgs'] diagnostic_log_settings: The Object representing the different Diagnostic log settings for the Cosmos DB Account.
        :param pulumi.Input[bool] disable_key_based_metadata_write_access: Disable write operations on metadata resources (databases, containers, throughput) via account keys
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        :param pulumi.Input[bool] enable_analytical_storage: Flag to indicate whether to enable storage analytics.
        :param pulumi.Input[bool] enable_automatic_failover: Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
        :param pulumi.Input[bool] enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C* account
        :param pulumi.Input[bool] enable_free_tier: Flag to indicate whether Free Tier is enabled.
        :param pulumi.Input[bool] enable_multiple_write_locations: Enables the account to write in multiple locations
        :param pulumi.Input['ManagedServiceIdentityArgs'] identity: Identity for the resource.
        :param pulumi.Input[Sequence[pulumi.Input['IpAddressOrRangeArgs']]] ip_rules: List of IpRules.
        :param pulumi.Input[bool] is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual Network ACL rules.
        :param pulumi.Input[str] key_vault_key_uri: The URI of the key vault
        :param pulumi.Input[Union[str, 'DatabaseAccountKind']] kind: Indicates the type of database account. This can only be set at database account creation.
        :param pulumi.Input[str] location: The location of the resource group to which the resource belongs.
        :param pulumi.Input['NetworkAclBypass'] network_acl_bypass: Indicates what services are allowed to bypass firewall checks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
        :param pulumi.Input[Union[str, 'PublicNetworkAccess']] public_network_access: Whether requests from Public Network are allowed
        :param pulumi.Input['RestoreParametersArgs'] restore_parameters: Parameters to indicate the information about the restore.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]] virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB account.
        """
        pulumi.set(__self__, "database_account_offer_type", database_account_offer_type)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if analytical_storage_configuration is not None:
            pulumi.set(__self__, "analytical_storage_configuration", analytical_storage_configuration)
        if api_properties is not None:
            pulumi.set(__self__, "api_properties", api_properties)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if connector_offer is not None:
            pulumi.set(__self__, "connector_offer", connector_offer)
        if consistency_policy is not None:
            pulumi.set(__self__, "consistency_policy", consistency_policy)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if create_mode is None:
            create_mode = 'Default'
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if default_identity is not None:
            pulumi.set(__self__, "default_identity", default_identity)
        if diagnostic_log_settings is not None:
            pulumi.set(__self__, "diagnostic_log_settings", diagnostic_log_settings)
        if disable_key_based_metadata_write_access is not None:
            pulumi.set(__self__, "disable_key_based_metadata_write_access", disable_key_based_metadata_write_access)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if enable_analytical_storage is not None:
            pulumi.set(__self__, "enable_analytical_storage", enable_analytical_storage)
        if enable_automatic_failover is not None:
            pulumi.set(__self__, "enable_automatic_failover", enable_automatic_failover)
        if enable_cassandra_connector is not None:
            pulumi.set(__self__, "enable_cassandra_connector", enable_cassandra_connector)
        if enable_free_tier is not None:
            pulumi.set(__self__, "enable_free_tier", enable_free_tier)
        if enable_multiple_write_locations is not None:
            pulumi.set(__self__, "enable_multiple_write_locations", enable_multiple_write_locations)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if is_virtual_network_filter_enabled is not None:
            pulumi.set(__self__, "is_virtual_network_filter_enabled", is_virtual_network_filter_enabled)
        if key_vault_key_uri is not None:
            pulumi.set(__self__, "key_vault_key_uri", key_vault_key_uri)
        if kind is None:
            kind = 'GlobalDocumentDB'
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if network_acl_bypass is not None:
            pulumi.set(__self__, "network_acl_bypass", network_acl_bypass)
        if network_acl_bypass_resource_ids is not None:
            pulumi.set(__self__, "network_acl_bypass_resource_ids", network_acl_bypass_resource_ids)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if restore_parameters is not None:
            pulumi.set(__self__, "restore_parameters", restore_parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="databaseAccountOfferType")
    def database_account_offer_type(self) -> pulumi.Input['DatabaseAccountOfferType']:
        """
        The offer type for the database
        """
        return pulumi.get(self, "database_account_offer_type")

    @database_account_offer_type.setter
    def database_account_offer_type(self, value: pulumi.Input['DatabaseAccountOfferType']):
        pulumi.set(self, "database_account_offer_type", value)

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]:
        """
        An array that contains the georeplication locations enabled for the Cosmos DB account.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cosmos DB database account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="analyticalStorageConfiguration")
    def analytical_storage_configuration(self) -> Optional[pulumi.Input['AnalyticalStorageConfigurationArgs']]:
        """
        Analytical storage specific properties.
        """
        return pulumi.get(self, "analytical_storage_configuration")

    @analytical_storage_configuration.setter
    def analytical_storage_configuration(self, value: Optional[pulumi.Input['AnalyticalStorageConfigurationArgs']]):
        pulumi.set(self, "analytical_storage_configuration", value)

    @property
    @pulumi.getter(name="apiProperties")
    def api_properties(self) -> Optional[pulumi.Input['ApiPropertiesArgs']]:
        """
        API specific properties. Currently, supported only for MongoDB API.
        """
        return pulumi.get(self, "api_properties")

    @api_properties.setter
    def api_properties(self, value: Optional[pulumi.Input['ApiPropertiesArgs']]):
        pulumi.set(self, "api_properties", value)

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input[Union['ContinuousModeBackupPolicyArgs', 'PeriodicModeBackupPolicyArgs']]]:
        """
        The object representing the policy for taking backups on an account.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input[Union['ContinuousModeBackupPolicyArgs', 'PeriodicModeBackupPolicyArgs']]]):
        pulumi.set(self, "backup_policy", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]]]:
        """
        List of Cosmos DB capabilities for the account
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['CapacityArgs']]:
        """
        The object that represents all properties related to capacity enforcement on an account.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['CapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="connectorOffer")
    def connector_offer(self) -> Optional[pulumi.Input[Union[str, 'ConnectorOffer']]]:
        """
        The cassandra connector offer type for the Cosmos DB database C* account.
        """
        return pulumi.get(self, "connector_offer")

    @connector_offer.setter
    def connector_offer(self, value: Optional[pulumi.Input[Union[str, 'ConnectorOffer']]]):
        pulumi.set(self, "connector_offer", value)

    @property
    @pulumi.getter(name="consistencyPolicy")
    def consistency_policy(self) -> Optional[pulumi.Input['ConsistencyPolicyArgs']]:
        """
        The consistency policy for the Cosmos DB account.
        """
        return pulumi.get(self, "consistency_policy")

    @consistency_policy.setter
    def consistency_policy(self, value: Optional[pulumi.Input['ConsistencyPolicyArgs']]):
        pulumi.set(self, "consistency_policy", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CorsPolicyArgs']]]]:
        """
        The CORS policy for the Cosmos DB database account.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CorsPolicyArgs']]]]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Enum to indicate the mode of account creation.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="defaultIdentity")
    def default_identity(self) -> Optional[pulumi.Input[str]]:
        """
        The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
        """
        return pulumi.get(self, "default_identity")

    @default_identity.setter
    def default_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_identity", value)

    @property
    @pulumi.getter(name="diagnosticLogSettings")
    def diagnostic_log_settings(self) -> Optional[pulumi.Input['DiagnosticLogSettingsArgs']]:
        """
        The Object representing the different Diagnostic log settings for the Cosmos DB Account.
        """
        return pulumi.get(self, "diagnostic_log_settings")

    @diagnostic_log_settings.setter
    def diagnostic_log_settings(self, value: Optional[pulumi.Input['DiagnosticLogSettingsArgs']]):
        pulumi.set(self, "diagnostic_log_settings", value)

    @property
    @pulumi.getter(name="disableKeyBasedMetadataWriteAccess")
    def disable_key_based_metadata_write_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable write operations on metadata resources (databases, containers, throughput) via account keys
        """
        return pulumi.get(self, "disable_key_based_metadata_write_access")

    @disable_key_based_metadata_write_access.setter
    def disable_key_based_metadata_write_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_key_based_metadata_write_access", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter(name="enableAnalyticalStorage")
    def enable_analytical_storage(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether to enable storage analytics.
        """
        return pulumi.get(self, "enable_analytical_storage")

    @enable_analytical_storage.setter
    def enable_analytical_storage(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_analytical_storage", value)

    @property
    @pulumi.getter(name="enableAutomaticFailover")
    def enable_automatic_failover(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
        """
        return pulumi.get(self, "enable_automatic_failover")

    @enable_automatic_failover.setter
    def enable_automatic_failover(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_failover", value)

    @property
    @pulumi.getter(name="enableCassandraConnector")
    def enable_cassandra_connector(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the cassandra connector on the Cosmos DB C* account
        """
        return pulumi.get(self, "enable_cassandra_connector")

    @enable_cassandra_connector.setter
    def enable_cassandra_connector(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cassandra_connector", value)

    @property
    @pulumi.getter(name="enableFreeTier")
    def enable_free_tier(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether Free Tier is enabled.
        """
        return pulumi.get(self, "enable_free_tier")

    @enable_free_tier.setter
    def enable_free_tier(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_free_tier", value)

    @property
    @pulumi.getter(name="enableMultipleWriteLocations")
    def enable_multiple_write_locations(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the account to write in multiple locations
        """
        return pulumi.get(self, "enable_multiple_write_locations")

    @enable_multiple_write_locations.setter
    def enable_multiple_write_locations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_multiple_write_locations", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ManagedServiceIdentityArgs']]:
        """
        Identity for the resource.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ManagedServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressOrRangeArgs']]]]:
        """
        List of IpRules.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressOrRangeArgs']]]]):
        pulumi.set(self, "ip_rules", value)

    @property
    @pulumi.getter(name="isVirtualNetworkFilterEnabled")
    def is_virtual_network_filter_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether to enable/disable Virtual Network ACL rules.
        """
        return pulumi.get(self, "is_virtual_network_filter_enabled")

    @is_virtual_network_filter_enabled.setter
    def is_virtual_network_filter_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_virtual_network_filter_enabled", value)

    @property
    @pulumi.getter(name="keyVaultKeyUri")
    def key_vault_key_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the key vault
        """
        return pulumi.get(self, "key_vault_key_uri")

    @key_vault_key_uri.setter
    def key_vault_key_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_key_uri", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[Union[str, 'DatabaseAccountKind']]]:
        """
        Indicates the type of database account. This can only be set at database account creation.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[Union[str, 'DatabaseAccountKind']]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the resource group to which the resource belongs.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="networkAclBypass")
    def network_acl_bypass(self) -> Optional[pulumi.Input['NetworkAclBypass']]:
        """
        Indicates what services are allowed to bypass firewall checks.
        """
        return pulumi.get(self, "network_acl_bypass")

    @network_acl_bypass.setter
    def network_acl_bypass(self, value: Optional[pulumi.Input['NetworkAclBypass']]):
        pulumi.set(self, "network_acl_bypass", value)

    @property
    @pulumi.getter(name="networkAclBypassResourceIds")
    def network_acl_bypass_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
        """
        return pulumi.get(self, "network_acl_bypass_resource_ids")

    @network_acl_bypass_resource_ids.setter
    def network_acl_bypass_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_acl_bypass_resource_ids", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]]:
        """
        Whether requests from Public Network are allowed
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter(name="restoreParameters")
    def restore_parameters(self) -> Optional[pulumi.Input['RestoreParametersArgs']]:
        """
        Parameters to indicate the information about the restore.
        """
        return pulumi.get(self, "restore_parameters")

    @restore_parameters.setter
    def restore_parameters(self, value: Optional[pulumi.Input['RestoreParametersArgs']]):
        pulumi.set(self, "restore_parameters", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]:
        """
        List of Virtual Network ACL rules configured for the Cosmos DB account.
        """
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


class DatabaseAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 analytical_storage_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticalStorageConfigurationArgs']]] = None,
                 api_properties: Optional[pulumi.Input[pulumi.InputType['ApiPropertiesArgs']]] = None,
                 backup_policy: Optional[pulumi.Input[Union[pulumi.InputType['ContinuousModeBackupPolicyArgs'], pulumi.InputType['PeriodicModeBackupPolicyArgs']]]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CapabilityArgs']]]]] = None,
                 capacity: Optional[pulumi.Input[pulumi.InputType['CapacityArgs']]] = None,
                 connector_offer: Optional[pulumi.Input[Union[str, 'ConnectorOffer']]] = None,
                 consistency_policy: Optional[pulumi.Input[pulumi.InputType['ConsistencyPolicyArgs']]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CorsPolicyArgs']]]]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 database_account_offer_type: Optional[pulumi.Input['DatabaseAccountOfferType']] = None,
                 default_identity: Optional[pulumi.Input[str]] = None,
                 diagnostic_log_settings: Optional[pulumi.Input[pulumi.InputType['DiagnosticLogSettingsArgs']]] = None,
                 disable_key_based_metadata_write_access: Optional[pulumi.Input[bool]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 enable_analytical_storage: Optional[pulumi.Input[bool]] = None,
                 enable_automatic_failover: Optional[pulumi.Input[bool]] = None,
                 enable_cassandra_connector: Optional[pulumi.Input[bool]] = None,
                 enable_free_tier: Optional[pulumi.Input[bool]] = None,
                 enable_multiple_write_locations: Optional[pulumi.Input[bool]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ManagedServiceIdentityArgs']]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpAddressOrRangeArgs']]]]] = None,
                 is_virtual_network_filter_enabled: Optional[pulumi.Input[bool]] = None,
                 key_vault_key_uri: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'DatabaseAccountKind']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocationArgs']]]]] = None,
                 network_acl_bypass: Optional[pulumi.Input['NetworkAclBypass']] = None,
                 network_acl_bypass_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 restore_parameters: Optional[pulumi.Input[pulumi.InputType['RestoreParametersArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNetworkRuleArgs']]]]] = None,
                 __props__=None):
        """
        An Azure Cosmos DB database account.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Cosmos DB database account name.
        :param pulumi.Input[pulumi.InputType['AnalyticalStorageConfigurationArgs']] analytical_storage_configuration: Analytical storage specific properties.
        :param pulumi.Input[pulumi.InputType['ApiPropertiesArgs']] api_properties: API specific properties. Currently, supported only for MongoDB API.
        :param pulumi.Input[Union[pulumi.InputType['ContinuousModeBackupPolicyArgs'], pulumi.InputType['PeriodicModeBackupPolicyArgs']]] backup_policy: The object representing the policy for taking backups on an account.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CapabilityArgs']]]] capabilities: List of Cosmos DB capabilities for the account
        :param pulumi.Input[pulumi.InputType['CapacityArgs']] capacity: The object that represents all properties related to capacity enforcement on an account.
        :param pulumi.Input[Union[str, 'ConnectorOffer']] connector_offer: The cassandra connector offer type for the Cosmos DB database C* account.
        :param pulumi.Input[pulumi.InputType['ConsistencyPolicyArgs']] consistency_policy: The consistency policy for the Cosmos DB account.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CorsPolicyArgs']]]] cors: The CORS policy for the Cosmos DB database account.
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Enum to indicate the mode of account creation.
        :param pulumi.Input['DatabaseAccountOfferType'] database_account_offer_type: The offer type for the database
        :param pulumi.Input[str] default_identity: The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
        :param pulumi.Input[pulumi.InputType['DiagnosticLogSettingsArgs']] diagnostic_log_settings: The Object representing the different Diagnostic log settings for the Cosmos DB Account.
        :param pulumi.Input[bool] disable_key_based_metadata_write_access: Disable write operations on metadata resources (databases, containers, throughput) via account keys
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        :param pulumi.Input[bool] enable_analytical_storage: Flag to indicate whether to enable storage analytics.
        :param pulumi.Input[bool] enable_automatic_failover: Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
        :param pulumi.Input[bool] enable_cassandra_connector: Enables the cassandra connector on the Cosmos DB C* account
        :param pulumi.Input[bool] enable_free_tier: Flag to indicate whether Free Tier is enabled.
        :param pulumi.Input[bool] enable_multiple_write_locations: Enables the account to write in multiple locations
        :param pulumi.Input[pulumi.InputType['ManagedServiceIdentityArgs']] identity: Identity for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpAddressOrRangeArgs']]]] ip_rules: List of IpRules.
        :param pulumi.Input[bool] is_virtual_network_filter_enabled: Flag to indicate whether to enable/disable Virtual Network ACL rules.
        :param pulumi.Input[str] key_vault_key_uri: The URI of the key vault
        :param pulumi.Input[Union[str, 'DatabaseAccountKind']] kind: Indicates the type of database account. This can only be set at database account creation.
        :param pulumi.Input[str] location: The location of the resource group to which the resource belongs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocationArgs']]]] locations: An array that contains the georeplication locations enabled for the Cosmos DB account.
        :param pulumi.Input['NetworkAclBypass'] network_acl_bypass: Indicates what services are allowed to bypass firewall checks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_acl_bypass_resource_ids: An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
        :param pulumi.Input[Union[str, 'PublicNetworkAccess']] public_network_access: Whether requests from Public Network are allowed
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[pulumi.InputType['RestoreParametersArgs']] restore_parameters: Parameters to indicate the information about the restore.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNetworkRuleArgs']]]] virtual_network_rules: List of Virtual Network ACL rules configured for the Cosmos DB account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Azure Cosmos DB database account.

        :param str resource_name: The name of the resource.
        :param DatabaseAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 analytical_storage_configuration: Optional[pulumi.Input[pulumi.InputType['AnalyticalStorageConfigurationArgs']]] = None,
                 api_properties: Optional[pulumi.Input[pulumi.InputType['ApiPropertiesArgs']]] = None,
                 backup_policy: Optional[pulumi.Input[Union[pulumi.InputType['ContinuousModeBackupPolicyArgs'], pulumi.InputType['PeriodicModeBackupPolicyArgs']]]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CapabilityArgs']]]]] = None,
                 capacity: Optional[pulumi.Input[pulumi.InputType['CapacityArgs']]] = None,
                 connector_offer: Optional[pulumi.Input[Union[str, 'ConnectorOffer']]] = None,
                 consistency_policy: Optional[pulumi.Input[pulumi.InputType['ConsistencyPolicyArgs']]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CorsPolicyArgs']]]]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 database_account_offer_type: Optional[pulumi.Input['DatabaseAccountOfferType']] = None,
                 default_identity: Optional[pulumi.Input[str]] = None,
                 diagnostic_log_settings: Optional[pulumi.Input[pulumi.InputType['DiagnosticLogSettingsArgs']]] = None,
                 disable_key_based_metadata_write_access: Optional[pulumi.Input[bool]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 enable_analytical_storage: Optional[pulumi.Input[bool]] = None,
                 enable_automatic_failover: Optional[pulumi.Input[bool]] = None,
                 enable_cassandra_connector: Optional[pulumi.Input[bool]] = None,
                 enable_free_tier: Optional[pulumi.Input[bool]] = None,
                 enable_multiple_write_locations: Optional[pulumi.Input[bool]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['ManagedServiceIdentityArgs']]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpAddressOrRangeArgs']]]]] = None,
                 is_virtual_network_filter_enabled: Optional[pulumi.Input[bool]] = None,
                 key_vault_key_uri: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'DatabaseAccountKind']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocationArgs']]]]] = None,
                 network_acl_bypass: Optional[pulumi.Input['NetworkAclBypass']] = None,
                 network_acl_bypass_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 restore_parameters: Optional[pulumi.Input[pulumi.InputType['RestoreParametersArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualNetworkRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseAccountArgs.__new__(DatabaseAccountArgs)

            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["analytical_storage_configuration"] = analytical_storage_configuration
            __props__.__dict__["api_properties"] = api_properties
            __props__.__dict__["backup_policy"] = backup_policy
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["connector_offer"] = connector_offer
            __props__.__dict__["consistency_policy"] = consistency_policy
            __props__.__dict__["cors"] = cors
            if create_mode is None:
                create_mode = 'Default'
            __props__.__dict__["create_mode"] = create_mode
            if database_account_offer_type is None and not opts.urn:
                raise TypeError("Missing required property 'database_account_offer_type'")
            __props__.__dict__["database_account_offer_type"] = database_account_offer_type
            __props__.__dict__["default_identity"] = default_identity
            __props__.__dict__["diagnostic_log_settings"] = diagnostic_log_settings
            __props__.__dict__["disable_key_based_metadata_write_access"] = disable_key_based_metadata_write_access
            __props__.__dict__["disable_local_auth"] = disable_local_auth
            __props__.__dict__["enable_analytical_storage"] = enable_analytical_storage
            __props__.__dict__["enable_automatic_failover"] = enable_automatic_failover
            __props__.__dict__["enable_cassandra_connector"] = enable_cassandra_connector
            __props__.__dict__["enable_free_tier"] = enable_free_tier
            __props__.__dict__["enable_multiple_write_locations"] = enable_multiple_write_locations
            __props__.__dict__["identity"] = identity
            __props__.__dict__["ip_rules"] = ip_rules
            __props__.__dict__["is_virtual_network_filter_enabled"] = is_virtual_network_filter_enabled
            __props__.__dict__["key_vault_key_uri"] = key_vault_key_uri
            if kind is None:
                kind = 'GlobalDocumentDB'
            __props__.__dict__["kind"] = kind
            __props__.__dict__["location"] = location
            if locations is None and not opts.urn:
                raise TypeError("Missing required property 'locations'")
            __props__.__dict__["locations"] = locations
            __props__.__dict__["network_acl_bypass"] = network_acl_bypass
            __props__.__dict__["network_acl_bypass_resource_ids"] = network_acl_bypass_resource_ids
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["restore_parameters"] = restore_parameters
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_rules"] = virtual_network_rules
            __props__.__dict__["document_endpoint"] = None
            __props__.__dict__["failover_policies"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["private_endpoint_connections"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["read_locations"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["write_locations"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:documentdb:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20150401:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20150408:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20151106:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20160319:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20160331:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20190801:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20191212:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20200301:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20200401:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20200601preview:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20200901:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210115:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210301preview:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210315:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210401preview:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210415:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210515:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210615:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20210701preview:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20211015:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20211115preview:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20220215preview:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20220515:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20220515preview:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20220815:DatabaseAccount"), pulumi.Alias(type_="azure-native:documentdb/v20220815preview:DatabaseAccount")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(DatabaseAccount, __self__).__init__(
            'azure-native:documentdb/v20211015preview:DatabaseAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DatabaseAccount':
        """
        Get an existing DatabaseAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DatabaseAccountArgs.__new__(DatabaseAccountArgs)

        __props__.__dict__["analytical_storage_configuration"] = None
        __props__.__dict__["api_properties"] = None
        __props__.__dict__["backup_policy"] = None
        __props__.__dict__["capabilities"] = None
        __props__.__dict__["capacity"] = None
        __props__.__dict__["connector_offer"] = None
        __props__.__dict__["consistency_policy"] = None
        __props__.__dict__["cors"] = None
        __props__.__dict__["create_mode"] = None
        __props__.__dict__["database_account_offer_type"] = None
        __props__.__dict__["default_identity"] = None
        __props__.__dict__["diagnostic_log_settings"] = None
        __props__.__dict__["disable_key_based_metadata_write_access"] = None
        __props__.__dict__["disable_local_auth"] = None
        __props__.__dict__["document_endpoint"] = None
        __props__.__dict__["enable_analytical_storage"] = None
        __props__.__dict__["enable_automatic_failover"] = None
        __props__.__dict__["enable_cassandra_connector"] = None
        __props__.__dict__["enable_free_tier"] = None
        __props__.__dict__["enable_multiple_write_locations"] = None
        __props__.__dict__["failover_policies"] = None
        __props__.__dict__["identity"] = None
        __props__.__dict__["instance_id"] = None
        __props__.__dict__["ip_rules"] = None
        __props__.__dict__["is_virtual_network_filter_enabled"] = None
        __props__.__dict__["key_vault_key_uri"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["locations"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network_acl_bypass"] = None
        __props__.__dict__["network_acl_bypass_resource_ids"] = None
        __props__.__dict__["private_endpoint_connections"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["public_network_access"] = None
        __props__.__dict__["read_locations"] = None
        __props__.__dict__["restore_parameters"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["virtual_network_rules"] = None
        __props__.__dict__["write_locations"] = None
        return DatabaseAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analyticalStorageConfiguration")
    def analytical_storage_configuration(self) -> pulumi.Output[Optional['outputs.AnalyticalStorageConfigurationResponse']]:
        """
        Analytical storage specific properties.
        """
        return pulumi.get(self, "analytical_storage_configuration")

    @property
    @pulumi.getter(name="apiProperties")
    def api_properties(self) -> pulumi.Output[Optional['outputs.ApiPropertiesResponse']]:
        """
        API specific properties.
        """
        return pulumi.get(self, "api_properties")

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The object representing the policy for taking backups on an account.
        """
        return pulumi.get(self, "backup_policy")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence['outputs.CapabilityResponse']]]:
        """
        List of Cosmos DB capabilities for the account
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional['outputs.CapacityResponse']]:
        """
        The object that represents all properties related to capacity enforcement on an account.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="connectorOffer")
    def connector_offer(self) -> pulumi.Output[Optional[str]]:
        """
        The cassandra connector offer type for the Cosmos DB database C* account.
        """
        return pulumi.get(self, "connector_offer")

    @property
    @pulumi.getter(name="consistencyPolicy")
    def consistency_policy(self) -> pulumi.Output[Optional['outputs.ConsistencyPolicyResponse']]:
        """
        The consistency policy for the Cosmos DB database account.
        """
        return pulumi.get(self, "consistency_policy")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional[Sequence['outputs.CorsPolicyResponse']]]:
        """
        The CORS policy for the Cosmos DB database account.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Enum to indicate the mode of account creation.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="databaseAccountOfferType")
    def database_account_offer_type(self) -> pulumi.Output[str]:
        """
        The offer type for the Cosmos DB database account. Default value: Standard.
        """
        return pulumi.get(self, "database_account_offer_type")

    @property
    @pulumi.getter(name="defaultIdentity")
    def default_identity(self) -> pulumi.Output[Optional[str]]:
        """
        The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
        """
        return pulumi.get(self, "default_identity")

    @property
    @pulumi.getter(name="diagnosticLogSettings")
    def diagnostic_log_settings(self) -> pulumi.Output[Optional['outputs.DiagnosticLogSettingsResponse']]:
        """
        The Object representing the different Diagnostic log settings for the Cosmos DB Account.
        """
        return pulumi.get(self, "diagnostic_log_settings")

    @property
    @pulumi.getter(name="disableKeyBasedMetadataWriteAccess")
    def disable_key_based_metadata_write_access(self) -> pulumi.Output[Optional[bool]]:
        """
        Disable write operations on metadata resources (databases, containers, throughput) via account keys
        """
        return pulumi.get(self, "disable_key_based_metadata_write_access")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> pulumi.Output[Optional[bool]]:
        """
        Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter(name="documentEndpoint")
    def document_endpoint(self) -> pulumi.Output[str]:
        """
        The connection endpoint for the Cosmos DB database account.
        """
        return pulumi.get(self, "document_endpoint")

    @property
    @pulumi.getter(name="enableAnalyticalStorage")
    def enable_analytical_storage(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to indicate whether to enable storage analytics.
        """
        return pulumi.get(self, "enable_analytical_storage")

    @property
    @pulumi.getter(name="enableAutomaticFailover")
    def enable_automatic_failover(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
        """
        return pulumi.get(self, "enable_automatic_failover")

    @property
    @pulumi.getter(name="enableCassandraConnector")
    def enable_cassandra_connector(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables the cassandra connector on the Cosmos DB C* account
        """
        return pulumi.get(self, "enable_cassandra_connector")

    @property
    @pulumi.getter(name="enableFreeTier")
    def enable_free_tier(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to indicate whether Free Tier is enabled.
        """
        return pulumi.get(self, "enable_free_tier")

    @property
    @pulumi.getter(name="enableMultipleWriteLocations")
    def enable_multiple_write_locations(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables the account to write in multiple locations
        """
        return pulumi.get(self, "enable_multiple_write_locations")

    @property
    @pulumi.getter(name="failoverPolicies")
    def failover_policies(self) -> pulumi.Output[Sequence['outputs.FailoverPolicyResponse']]:
        """
        An array that contains the regions ordered by their failover priorities.
        """
        return pulumi.get(self, "failover_policies")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ManagedServiceIdentityResponse']]:
        """
        Identity for the resource.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        A unique identifier assigned to the database account
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> pulumi.Output[Optional[Sequence['outputs.IpAddressOrRangeResponse']]]:
        """
        List of IpRules.
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="isVirtualNetworkFilterEnabled")
    def is_virtual_network_filter_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to indicate whether to enable/disable Virtual Network ACL rules.
        """
        return pulumi.get(self, "is_virtual_network_filter_enabled")

    @property
    @pulumi.getter(name="keyVaultKeyUri")
    def key_vault_key_uri(self) -> pulumi.Output[Optional[str]]:
        """
        The URI of the key vault
        """
        return pulumi.get(self, "key_vault_key_uri")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates the type of database account. This can only be set at database account creation.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of the resource group to which the resource belongs.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence['outputs.LocationResponse']]:
        """
        An array that contains all of the locations enabled for the Cosmos DB account.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ARM resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAclBypass")
    def network_acl_bypass(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates what services are allowed to bypass firewall checks.
        """
        return pulumi.get(self, "network_acl_bypass")

    @property
    @pulumi.getter(name="networkAclBypassResourceIds")
    def network_acl_bypass_resource_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
        """
        return pulumi.get(self, "network_acl_bypass_resource_ids")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> pulumi.Output[Sequence['outputs.PrivateEndpointConnectionResponse']]:
        """
        List of Private Endpoint Connections configured for the Cosmos DB account.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[str]]:
        """
        Whether requests from Public Network are allowed
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="readLocations")
    def read_locations(self) -> pulumi.Output[Sequence['outputs.LocationResponse']]:
        """
        An array that contains of the read locations enabled for the Cosmos DB account.
        """
        return pulumi.get(self, "read_locations")

    @property
    @pulumi.getter(name="restoreParameters")
    def restore_parameters(self) -> pulumi.Output[Optional['outputs.RestoreParametersResponse']]:
        """
        Parameters to indicate the information about the restore.
        """
        return pulumi.get(self, "restore_parameters")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        The system meta data relating to this resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of Azure resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualNetworkRuleResponse']]]:
        """
        List of Virtual Network ACL rules configured for the Cosmos DB account.
        """
        return pulumi.get(self, "virtual_network_rules")

    @property
    @pulumi.getter(name="writeLocations")
    def write_locations(self) -> pulumi.Output[Sequence['outputs.LocationResponse']]:
        """
        An array that contains the write location for the Cosmos DB account.
        """
        return pulumi.get(self, "write_locations")

