# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ClusterDesiredPropertiesResponse',
    'ClusterNodeResponse',
    'ClusterReportedPropertiesResponse',
    'ErrorAdditionalInfoResponse',
    'ErrorDetailResponse',
    'ExtendedLocationResponse',
    'GalleryImageIdentifierResponse',
    'GalleryImageStatusResponse',
    'GalleryImageStatusResponseDownloadStatus',
    'GalleryImageStatusResponseProvisioningStatus',
    'GalleryImageVersionResponse',
    'GalleryImageVersionStorageProfileResponse',
    'GalleryOSDiskImageResponse',
    'GuestAgentProfileResponse',
    'GuestCredentialResponse',
    'HttpProxyConfigurationResponse',
    'IPPoolInfoResponse',
    'IPPoolResponse',
    'IdentityResponse',
    'InterfaceDNSSettingsResponse',
    'IpConfigurationResponse',
    'IpConfigurationResponseProperties',
    'IpConfigurationResponseSubnet',
    'MachineExtensionInstanceViewResponseStatus',
    'MachineExtensionPropertiesResponseInstanceView',
    'MarketplaceGalleryImageStatusResponse',
    'MarketplaceGalleryImageStatusResponseDownloadStatus',
    'MarketplaceGalleryImageStatusResponseProvisioningStatus',
    'NetworkInterfaceStatusResponse',
    'NetworkInterfaceStatusResponseProvisioningStatus',
    'PerNodeExtensionStateResponse',
    'PerNodeStateResponse',
    'StorageContainerStatusResponse',
    'StorageContainerStatusResponseProvisioningStatus',
    'StoragecontainersResponseExtendedLocation',
    'SystemDataResponse',
    'VirtualHardDiskStatusResponse',
    'VirtualHardDiskStatusResponseProvisioningStatus',
    'VirtualMachineStatusResponse',
    'VirtualMachineStatusResponseProvisioningStatus',
    'VirtualNetworkStatusResponse',
    'VirtualNetworkStatusResponseProvisioningStatus',
    'VirtualmachinesPropertiesResponseDataDisks',
    'VirtualmachinesPropertiesResponseDynamicMemoryConfig',
    'VirtualmachinesPropertiesResponseHardwareProfile',
    'VirtualmachinesPropertiesResponseImageReference',
    'VirtualmachinesPropertiesResponseLinuxConfiguration',
    'VirtualmachinesPropertiesResponseNetworkInterfaces',
    'VirtualmachinesPropertiesResponseNetworkProfile',
    'VirtualmachinesPropertiesResponseOsDisk',
    'VirtualmachinesPropertiesResponseOsProfile',
    'VirtualmachinesPropertiesResponsePublicKeys',
    'VirtualmachinesPropertiesResponsePublicKeysPublicKeys',
    'VirtualmachinesPropertiesResponseSecurityProfile',
    'VirtualmachinesPropertiesResponseSsh',
    'VirtualmachinesPropertiesResponseSshSsh',
    'VirtualmachinesPropertiesResponseStorageProfile',
    'VirtualmachinesPropertiesResponseUefiSettings',
    'VirtualmachinesPropertiesResponseWindowsConfiguration',
    'VirtualnetworksPropertiesResponseIpConfigurationReferences',
    'VirtualnetworksPropertiesResponseRouteTable',
    'VirtualnetworksPropertiesResponseRoutes',
    'VirtualnetworksPropertiesResponseSubnets',
]

@pulumi.output_type
class ClusterDesiredPropertiesResponse(dict):
    """
    Desired properties of the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diagnosticLevel":
            suggest = "diagnostic_level"
        elif key == "windowsServerSubscription":
            suggest = "windows_server_subscription"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDesiredPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDesiredPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDesiredPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 diagnostic_level: Optional[str] = None,
                 windows_server_subscription: Optional[str] = None):
        """
        Desired properties of the cluster.
        :param str diagnostic_level: Desired level of diagnostic data emitted by the cluster.
        :param str windows_server_subscription: Desired state of Windows Server Subscription.
        """
        if diagnostic_level is not None:
            pulumi.set(__self__, "diagnostic_level", diagnostic_level)
        if windows_server_subscription is not None:
            pulumi.set(__self__, "windows_server_subscription", windows_server_subscription)

    @property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> Optional[str]:
        """
        Desired level of diagnostic data emitted by the cluster.
        """
        return pulumi.get(self, "diagnostic_level")

    @property
    @pulumi.getter(name="windowsServerSubscription")
    def windows_server_subscription(self) -> Optional[str]:
        """
        Desired state of Windows Server Subscription.
        """
        return pulumi.get(self, "windows_server_subscription")


@pulumi.output_type
class ClusterNodeResponse(dict):
    """
    Cluster node details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"
        elif key == "memoryInGiB":
            suggest = "memory_in_gi_b"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "windowsServerSubscription":
            suggest = "windows_server_subscription"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: float,
                 id: float,
                 manufacturer: str,
                 memory_in_gi_b: float,
                 model: str,
                 name: str,
                 os_name: str,
                 os_version: str,
                 serial_number: str,
                 windows_server_subscription: str):
        """
        Cluster node details.
        :param float core_count: Number of physical cores on the cluster node.
        :param float id: Id of the node in the cluster.
        :param str manufacturer: Manufacturer of the cluster node hardware.
        :param float memory_in_gi_b: Total available memory on the cluster node (in GiB).
        :param str model: Model name of the cluster node hardware.
        :param str name: Name of the cluster node.
        :param str os_name: Operating system running on the cluster node.
        :param str os_version: Version of the operating system running on the cluster node.
        :param str serial_number: Immutable id of the cluster node.
        :param str windows_server_subscription: State of Windows Server Subscription.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "manufacturer", manufacturer)
        pulumi.set(__self__, "memory_in_gi_b", memory_in_gi_b)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "windows_server_subscription", windows_server_subscription)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> float:
        """
        Number of physical cores on the cluster node.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        Id of the node in the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def manufacturer(self) -> str:
        """
        Manufacturer of the cluster node hardware.
        """
        return pulumi.get(self, "manufacturer")

    @property
    @pulumi.getter(name="memoryInGiB")
    def memory_in_gi_b(self) -> float:
        """
        Total available memory on the cluster node (in GiB).
        """
        return pulumi.get(self, "memory_in_gi_b")

    @property
    @pulumi.getter
    def model(self) -> str:
        """
        Model name of the cluster node hardware.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the cluster node.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        Operating system running on the cluster node.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        Version of the operating system running on the cluster node.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        Immutable id of the cluster node.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="windowsServerSubscription")
    def windows_server_subscription(self) -> str:
        """
        State of Windows Server Subscription.
        """
        return pulumi.get(self, "windows_server_subscription")


@pulumi.output_type
class ClusterReportedPropertiesResponse(dict):
    """
    Properties reported by cluster agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "clusterVersion":
            suggest = "cluster_version"
        elif key == "imdsAttestation":
            suggest = "imds_attestation"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "diagnosticLevel":
            suggest = "diagnostic_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterReportedPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterReportedPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterReportedPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 cluster_name: str,
                 cluster_version: str,
                 imds_attestation: str,
                 last_updated: str,
                 nodes: Sequence['outputs.ClusterNodeResponse'],
                 diagnostic_level: Optional[str] = None):
        """
        Properties reported by cluster agent.
        :param str cluster_id: Unique id generated by the on-prem cluster.
        :param str cluster_name: Name of the on-prem cluster connected to this resource.
        :param str cluster_version: Version of the cluster software.
        :param str imds_attestation: IMDS attestation status of the cluster.
        :param str last_updated: Last time the cluster reported the data.
        :param Sequence['ClusterNodeResponse'] nodes: List of nodes reported by the cluster.
        :param str diagnostic_level: Level of diagnostic data emitted by the cluster.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "imds_attestation", imds_attestation)
        pulumi.set(__self__, "last_updated", last_updated)
        pulumi.set(__self__, "nodes", nodes)
        if diagnostic_level is not None:
            pulumi.set(__self__, "diagnostic_level", diagnostic_level)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        Unique id generated by the on-prem cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Name of the on-prem cluster connected to this resource.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> str:
        """
        Version of the cluster software.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="imdsAttestation")
    def imds_attestation(self) -> str:
        """
        IMDS attestation status of the cluster.
        """
        return pulumi.get(self, "imds_attestation")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> str:
        """
        Last time the cluster reported the data.
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.ClusterNodeResponse']:
        """
        List of nodes reported by the cluster.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> Optional[str]:
        """
        Level of diagnostic data emitted by the cluster.
        """
        return pulumi.get(self, "diagnostic_level")


@pulumi.output_type
class ErrorAdditionalInfoResponse(dict):
    """
    The resource management error additional info.
    """
    def __init__(__self__, *,
                 info: Any,
                 type: str):
        """
        The resource management error additional info.
        :param Any info: The additional info.
        :param str type: The additional info type.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def info(self) -> Any:
        """
        The additional info.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The additional info type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    The error detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInfo":
            suggest = "additional_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_info: Sequence['outputs.ErrorAdditionalInfoResponse'],
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str,
                 target: str):
        """
        The error detail.
        :param Sequence['ErrorAdditionalInfoResponse'] additional_info: The error additional info.
        :param str code: The error code.
        :param Sequence['ErrorDetailResponse'] details: The error details.
        :param str message: The error message.
        :param str target: The error target.
        """
        pulumi.set(__self__, "additional_info", additional_info)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Sequence['outputs.ErrorAdditionalInfoResponse']:
        """
        The error additional info.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        The error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The error target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GalleryImageIdentifierResponse(dict):
    """
    This is the gallery image definition identifier.
    """
    def __init__(__self__, *,
                 offer: str,
                 publisher: str,
                 sku: str):
        """
        This is the gallery image definition identifier.
        :param str offer: The name of the gallery image definition offer.
        :param str publisher: The name of the gallery image definition publisher.
        :param str sku: The name of the gallery image definition SKU.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def offer(self) -> str:
        """
        The name of the gallery image definition offer.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The name of the gallery image definition publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        The name of the gallery image definition SKU.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class GalleryImageStatusResponse(dict):
    """
    GalleryImageStatus defines the observed state of galleryimages
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadStatus":
            suggest = "download_status"
        elif key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "progressPercentage":
            suggest = "progress_percentage"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_status: Optional['outputs.GalleryImageStatusResponseDownloadStatus'] = None,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 progress_percentage: Optional[float] = None,
                 provisioning_status: Optional['outputs.GalleryImageStatusResponseProvisioningStatus'] = None):
        """
        GalleryImageStatus defines the observed state of galleryimages
        :param 'GalleryImageStatusResponseDownloadStatus' download_status: The download status of the gallery image
        :param str error_code: Gallery image provisioning error code
        :param str error_message: Descriptive error message
        :param float progress_percentage: The progress of the operation in percentage
        :param 'GalleryImageStatusResponseProvisioningStatus' provisioning_status: The provisioning status of the gallery image
        """
        if download_status is not None:
            pulumi.set(__self__, "download_status", download_status)
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if progress_percentage is not None:
            pulumi.set(__self__, "progress_percentage", progress_percentage)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="downloadStatus")
    def download_status(self) -> Optional['outputs.GalleryImageStatusResponseDownloadStatus']:
        """
        The download status of the gallery image
        """
        return pulumi.get(self, "download_status")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        Gallery image provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="progressPercentage")
    def progress_percentage(self) -> Optional[float]:
        """
        The progress of the operation in percentage
        """
        return pulumi.get(self, "progress_percentage")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional['outputs.GalleryImageStatusResponseProvisioningStatus']:
        """
        The provisioning status of the gallery image
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class GalleryImageStatusResponseDownloadStatus(dict):
    """
    The download status of the gallery image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadSizeInMB":
            suggest = "download_size_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageStatusResponseDownloadStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageStatusResponseDownloadStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageStatusResponseDownloadStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_size_in_mb: Optional[float] = None):
        """
        The download status of the gallery image
        :param float download_size_in_mb: The downloaded sized of the image in MB
        """
        if download_size_in_mb is not None:
            pulumi.set(__self__, "download_size_in_mb", download_size_in_mb)

    @property
    @pulumi.getter(name="downloadSizeInMB")
    def download_size_in_mb(self) -> Optional[float]:
        """
        The downloaded sized of the image in MB
        """
        return pulumi.get(self, "download_size_in_mb")


@pulumi.output_type
class GalleryImageStatusResponseProvisioningStatus(dict):
    """
    The provisioning status of the gallery image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageStatusResponseProvisioningStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageStatusResponseProvisioningStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageStatusResponseProvisioningStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The provisioning status of the gallery image
        :param str operation_id: The ID of the operation performed on the gallery image
        :param str status: The status of the operation performed on the gallery image [Succeeded, Failed, InProgress]
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        The ID of the operation performed on the gallery image
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation performed on the gallery image [Succeeded, Failed, InProgress]
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GalleryImageVersionResponse(dict):
    """
    Specifies information about the gallery image version that you want to create or update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageProfile":
            suggest = "storage_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_profile: 'outputs.GalleryImageVersionStorageProfileResponse',
                 name: Optional[str] = None):
        """
        Specifies information about the gallery image version that you want to create or update.
        :param 'GalleryImageVersionStorageProfileResponse' storage_profile: This is the storage profile of a Gallery Image Version.
        :param str name: This is the version of the gallery image.
        """
        pulumi.set(__self__, "storage_profile", storage_profile)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> 'outputs.GalleryImageVersionStorageProfileResponse':
        """
        This is the storage profile of a Gallery Image Version.
        """
        return pulumi.get(self, "storage_profile")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        This is the version of the gallery image.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GalleryImageVersionStorageProfileResponse(dict):
    """
    This is the storage profile of a Gallery Image Version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osDiskImage":
            suggest = "os_disk_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageVersionStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageVersionStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageVersionStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_disk_image: Optional['outputs.GalleryOSDiskImageResponse'] = None):
        """
        This is the storage profile of a Gallery Image Version.
        :param 'GalleryOSDiskImageResponse' os_disk_image: This is the OS disk image.
        """
        if os_disk_image is not None:
            pulumi.set(__self__, "os_disk_image", os_disk_image)

    @property
    @pulumi.getter(name="osDiskImage")
    def os_disk_image(self) -> Optional['outputs.GalleryOSDiskImageResponse']:
        """
        This is the OS disk image.
        """
        return pulumi.get(self, "os_disk_image")


@pulumi.output_type
class GalleryOSDiskImageResponse(dict):
    """
    This is the OS disk image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInMB":
            suggest = "size_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryOSDiskImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryOSDiskImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryOSDiskImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_mb: float):
        """
        This is the OS disk image.
        :param float size_in_mb: This property indicates the size of the VHD to be created.
        """
        pulumi.set(__self__, "size_in_mb", size_in_mb)

    @property
    @pulumi.getter(name="sizeInMB")
    def size_in_mb(self) -> float:
        """
        This property indicates the size of the VHD to be created.
        """
        return pulumi.get(self, "size_in_mb")


@pulumi.output_type
class GuestAgentProfileResponse(dict):
    """
    Defines the resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentVersion":
            suggest = "agent_version"
        elif key == "errorDetails":
            suggest = "error_details"
        elif key == "lastStatusChange":
            suggest = "last_status_change"
        elif key == "vmUuid":
            suggest = "vm_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestAgentProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestAgentProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestAgentProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_version: str,
                 error_details: Sequence['outputs.ErrorDetailResponse'],
                 last_status_change: str,
                 status: str,
                 vm_uuid: str):
        """
        Defines the resource properties.
        :param str agent_version: The hybrid machine agent full version.
        :param Sequence['ErrorDetailResponse'] error_details: Details about the error state.
        :param str last_status_change: The time of the last status change.
        :param str status: The status of the hybrid machine agent.
        :param str vm_uuid: Specifies the VM's unique SMBIOS ID.
        """
        pulumi.set(__self__, "agent_version", agent_version)
        pulumi.set(__self__, "error_details", error_details)
        pulumi.set(__self__, "last_status_change", last_status_change)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vm_uuid", vm_uuid)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        The hybrid machine agent full version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="errorDetails")
    def error_details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        Details about the error state.
        """
        return pulumi.get(self, "error_details")

    @property
    @pulumi.getter(name="lastStatusChange")
    def last_status_change(self) -> str:
        """
        The time of the last status change.
        """
        return pulumi.get(self, "last_status_change")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the hybrid machine agent.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vmUuid")
    def vm_uuid(self) -> str:
        """
        Specifies the VM's unique SMBIOS ID.
        """
        return pulumi.get(self, "vm_uuid")


@pulumi.output_type
class GuestCredentialResponse(dict):
    """
    Username / Password Credentials to connect to guest.
    """
    def __init__(__self__, *,
                 username: Optional[str] = None):
        """
        Username / Password Credentials to connect to guest.
        :param str username: The username to connect with the guest.
        """
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username to connect with the guest.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class HttpProxyConfigurationResponse(dict):
    """
    HTTP Proxy configuration for the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpsProxy":
            suggest = "https_proxy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpProxyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpProxyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpProxyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 https_proxy: Optional[str] = None):
        """
        HTTP Proxy configuration for the VM.
        :param str https_proxy: The httpsProxy url.
        """
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)

    @property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[str]:
        """
        The httpsProxy url.
        """
        return pulumi.get(self, "https_proxy")


@pulumi.output_type
class IPPoolInfoResponse(dict):
    def __init__(__self__, *,
                 available: str,
                 used: str):
        """
        :param str available: no. of ip addresses available in the ip pool
        :param str used: no. of ip addresses allocated from the ip pool
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "used", used)

    @property
    @pulumi.getter
    def available(self) -> str:
        """
        no. of ip addresses available in the ip pool
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def used(self) -> str:
        """
        no. of ip addresses allocated from the ip pool
        """
        return pulumi.get(self, "used")


@pulumi.output_type
class IPPoolResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipPoolType":
            suggest = "ip_pool_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: Optional[str] = None,
                 info: Optional['outputs.IPPoolInfoResponse'] = None,
                 ip_pool_type: Optional[str] = None,
                 start: Optional[str] = None):
        """
        :param str end: end of the ip address pool
        :param str ip_pool_type: ip pool type
        :param str start: start of the ip address pool
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if info is not None:
            pulumi.set(__self__, "info", info)
        if ip_pool_type is not None:
            pulumi.set(__self__, "ip_pool_type", ip_pool_type)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        end of the ip address pool
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def info(self) -> Optional['outputs.IPPoolInfoResponse']:
        return pulumi.get(self, "info")

    @property
    @pulumi.getter(name="ipPoolType")
    def ip_pool_type(self) -> Optional[str]:
        """
        ip pool type
        """
        return pulumi.get(self, "ip_pool_type")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        start of the ip address pool
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InterfaceDNSSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InterfaceDNSSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InterfaceDNSSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InterfaceDNSSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] dns_servers: List of DNS server IP Addresses for the interface
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of DNS server IP Addresses for the interface
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class IpConfigurationResponse(dict):
    """
    InterfaceIPConfiguration iPConfiguration in a network interface.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 properties: Optional['outputs.IpConfigurationResponseProperties'] = None):
        """
        InterfaceIPConfiguration iPConfiguration in a network interface.
        :param str name: Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'IpConfigurationResponseProperties' properties: InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.IpConfigurationResponseProperties']:
        """
        InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class IpConfigurationResponseProperties(dict):
    """
    InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixLength":
            suggest = "prefix_length"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpConfigurationResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpConfigurationResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpConfigurationResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix_length: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 subnet: Optional['outputs.IpConfigurationResponseSubnet'] = None):
        """
        InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        :param str prefix_length: prefixLength for network interface
        :param str private_ip_address: PrivateIPAddress - Private IP address of the IP configuration.
        :param str private_ip_allocation_method: PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
        :param 'IpConfigurationResponseSubnet' subnet: Subnet - Name of Subnet bound to the IP configuration.
        """
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[str]:
        """
        prefixLength for network interface
        """
        return pulumi.get(self, "prefix_length")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        PrivateIPAddress - Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.IpConfigurationResponseSubnet']:
        """
        Subnet - Name of Subnet bound to the IP configuration.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class IpConfigurationResponseSubnet(dict):
    """
    Subnet - Name of Subnet bound to the IP configuration.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Subnet - Name of Subnet bound to the IP configuration.
        :param str id: ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class MachineExtensionInstanceViewResponseStatus(dict):
    """
    Instance view status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionInstanceViewResponseStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 display_status: str,
                 level: str,
                 message: str,
                 time: str):
        """
        Instance view status.
        :param str code: The status code.
        :param str display_status: The short localizable label for the status.
        :param str level: The level code.
        :param str message: The detailed status message, including for alerts and error messages.
        :param str time: The time of the status.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "display_status", display_status)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> str:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class MachineExtensionPropertiesResponseInstanceView(dict):
    """
    The machine extension instance view.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionPropertiesResponseInstanceView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionPropertiesResponseInstanceView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionPropertiesResponseInstanceView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 type_handler_version: str,
                 status: Optional['outputs.MachineExtensionInstanceViewResponseStatus'] = None):
        """
        The machine extension instance view.
        :param str name: The machine extension name.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        :param 'MachineExtensionInstanceViewResponseStatus' status: Instance view status.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The machine extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> str:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.MachineExtensionInstanceViewResponseStatus']:
        """
        Instance view status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class MarketplaceGalleryImageStatusResponse(dict):
    """
    MarketplaceGalleryImageStatus defines the observed state of marketplacegalleryimages
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadStatus":
            suggest = "download_status"
        elif key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "progressPercentage":
            suggest = "progress_percentage"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarketplaceGalleryImageStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarketplaceGalleryImageStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarketplaceGalleryImageStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_status: Optional['outputs.MarketplaceGalleryImageStatusResponseDownloadStatus'] = None,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 progress_percentage: Optional[float] = None,
                 provisioning_status: Optional['outputs.MarketplaceGalleryImageStatusResponseProvisioningStatus'] = None):
        """
        MarketplaceGalleryImageStatus defines the observed state of marketplacegalleryimages
        :param 'MarketplaceGalleryImageStatusResponseDownloadStatus' download_status: The download status of the marketplace gallery image
        :param str error_code: Marketplace gallery image provisioning error code
        :param str error_message: Descriptive error message
        :param float progress_percentage: The progress of the operation in percentage
        :param 'MarketplaceGalleryImageStatusResponseProvisioningStatus' provisioning_status: The provisioning status of the marketplace gallery image
        """
        if download_status is not None:
            pulumi.set(__self__, "download_status", download_status)
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if progress_percentage is not None:
            pulumi.set(__self__, "progress_percentage", progress_percentage)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="downloadStatus")
    def download_status(self) -> Optional['outputs.MarketplaceGalleryImageStatusResponseDownloadStatus']:
        """
        The download status of the marketplace gallery image
        """
        return pulumi.get(self, "download_status")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        Marketplace gallery image provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="progressPercentage")
    def progress_percentage(self) -> Optional[float]:
        """
        The progress of the operation in percentage
        """
        return pulumi.get(self, "progress_percentage")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional['outputs.MarketplaceGalleryImageStatusResponseProvisioningStatus']:
        """
        The provisioning status of the marketplace gallery image
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class MarketplaceGalleryImageStatusResponseDownloadStatus(dict):
    """
    The download status of the marketplace gallery image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "downloadSizeInMB":
            suggest = "download_size_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarketplaceGalleryImageStatusResponseDownloadStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarketplaceGalleryImageStatusResponseDownloadStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarketplaceGalleryImageStatusResponseDownloadStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 download_size_in_mb: Optional[float] = None):
        """
        The download status of the marketplace gallery image
        :param float download_size_in_mb: The downloaded sized of the image in MB
        """
        if download_size_in_mb is not None:
            pulumi.set(__self__, "download_size_in_mb", download_size_in_mb)

    @property
    @pulumi.getter(name="downloadSizeInMB")
    def download_size_in_mb(self) -> Optional[float]:
        """
        The downloaded sized of the image in MB
        """
        return pulumi.get(self, "download_size_in_mb")


@pulumi.output_type
class MarketplaceGalleryImageStatusResponseProvisioningStatus(dict):
    """
    The provisioning status of the marketplace gallery image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarketplaceGalleryImageStatusResponseProvisioningStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarketplaceGalleryImageStatusResponseProvisioningStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarketplaceGalleryImageStatusResponseProvisioningStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The provisioning status of the marketplace gallery image
        :param str operation_id: The ID of the operation performed on the marketplace gallery image
        :param str status: The status of the operation performed on the marketplace gallery image [Succeeded, Failed, InProgress]
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        The ID of the operation performed on the marketplace gallery image
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation performed on the marketplace gallery image [Succeeded, Failed, InProgress]
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkInterfaceStatusResponse(dict):
    """
    NetworkInterfaceStatus defines the observed state of network interfaces
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 provisioning_status: Optional['outputs.NetworkInterfaceStatusResponseProvisioningStatus'] = None):
        """
        NetworkInterfaceStatus defines the observed state of network interfaces
        :param str error_code: NetworkInterface provisioning error code
        :param str error_message: Descriptive error message
        :param 'NetworkInterfaceStatusResponseProvisioningStatus' provisioning_status: The provisioning status of the network interface
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        NetworkInterface provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional['outputs.NetworkInterfaceStatusResponseProvisioningStatus']:
        """
        The provisioning status of the network interface
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class NetworkInterfaceStatusResponseProvisioningStatus(dict):
    """
    The provisioning status of the network interface
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceStatusResponseProvisioningStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceStatusResponseProvisioningStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceStatusResponseProvisioningStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The provisioning status of the network interface
        :param str operation_id: The ID of the operation performed on the network interface
        :param str status: The status of the operation performed on the network interface [Succeeded, Failed, InProgress]
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        The ID of the operation performed on the network interface
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation performed on the network interface [Succeeded, Failed, InProgress]
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PerNodeExtensionStateResponse(dict):
    """
    Status of Arc Extension for a particular node in HCI Cluster.
    """
    def __init__(__self__, *,
                 extension: str,
                 name: str,
                 state: str):
        """
        Status of Arc Extension for a particular node in HCI Cluster.
        :param str extension: Fully qualified resource ID for the particular Arc Extension on this node.
        :param str name: Name of the node in HCI Cluster.
        :param str state: State of Arc Extension in this node.
        """
        pulumi.set(__self__, "extension", extension)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def extension(self) -> str:
        """
        Fully qualified resource ID for the particular Arc Extension on this node.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the node in HCI Cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of Arc Extension in this node.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PerNodeStateResponse(dict):
    """
    Status of Arc agent for a particular node in HCI Cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arcInstance":
            suggest = "arc_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerNodeStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerNodeStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerNodeStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arc_instance: str,
                 name: str,
                 state: str):
        """
        Status of Arc agent for a particular node in HCI Cluster.
        :param str arc_instance: Fully qualified resource ID for the Arc agent of this node.
        :param str name: Name of the Node in HCI Cluster
        :param str state: State of Arc agent in this node.
        """
        pulumi.set(__self__, "arc_instance", arc_instance)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="arcInstance")
    def arc_instance(self) -> str:
        """
        Fully qualified resource ID for the Arc agent of this node.
        """
        return pulumi.get(self, "arc_instance")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Node in HCI Cluster
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of Arc agent in this node.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class StorageContainerStatusResponse(dict):
    """
    storageContainerStatus defines the observed state of storagecontainers
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableSizeMB":
            suggest = "available_size_mb"
        elif key == "containerSizeMB":
            suggest = "container_size_mb"
        elif key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageContainerStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageContainerStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageContainerStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_size_mb: Optional[float] = None,
                 container_size_mb: Optional[float] = None,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 provisioning_status: Optional['outputs.StorageContainerStatusResponseProvisioningStatus'] = None):
        """
        storageContainerStatus defines the observed state of storagecontainers
        :param float available_size_mb: Amount of space available on the disk in MB
        :param float container_size_mb: Total size of the disk in MB
        :param str error_code: StorageContainer provisioning error code
        :param str error_message: Descriptive error message
        :param 'StorageContainerStatusResponseProvisioningStatus' provisioning_status: The provisioning status of the storage container
        """
        if available_size_mb is not None:
            pulumi.set(__self__, "available_size_mb", available_size_mb)
        if container_size_mb is not None:
            pulumi.set(__self__, "container_size_mb", container_size_mb)
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="availableSizeMB")
    def available_size_mb(self) -> Optional[float]:
        """
        Amount of space available on the disk in MB
        """
        return pulumi.get(self, "available_size_mb")

    @property
    @pulumi.getter(name="containerSizeMB")
    def container_size_mb(self) -> Optional[float]:
        """
        Total size of the disk in MB
        """
        return pulumi.get(self, "container_size_mb")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        StorageContainer provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional['outputs.StorageContainerStatusResponseProvisioningStatus']:
        """
        The provisioning status of the storage container
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class StorageContainerStatusResponseProvisioningStatus(dict):
    """
    The provisioning status of the storage container
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageContainerStatusResponseProvisioningStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageContainerStatusResponseProvisioningStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageContainerStatusResponseProvisioningStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The provisioning status of the storage container
        :param str operation_id: The ID of the operation performed on the storage container
        :param str status: The status of the operation performed on the storage container [Succeeded, Failed, InProgress]
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        The ID of the operation performed on the storage container
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation performed on the storage container [Succeeded, Failed, InProgress]
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StoragecontainersResponseExtendedLocation(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: The extended location name.
        :param str type: The extended location type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The extended location name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The extended location type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class VirtualHardDiskStatusResponse(dict):
    """
    VirtualHardDiskStatus defines the observed state of virtualharddisks
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualHardDiskStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualHardDiskStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualHardDiskStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 provisioning_status: Optional['outputs.VirtualHardDiskStatusResponseProvisioningStatus'] = None):
        """
        VirtualHardDiskStatus defines the observed state of virtualharddisks
        :param str error_code: VirtualHardDisk provisioning error code
        :param str error_message: Descriptive error message
        :param 'VirtualHardDiskStatusResponseProvisioningStatus' provisioning_status: The provisioning status of the virtual hard disk
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        VirtualHardDisk provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional['outputs.VirtualHardDiskStatusResponseProvisioningStatus']:
        """
        The provisioning status of the virtual hard disk
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class VirtualHardDiskStatusResponseProvisioningStatus(dict):
    """
    The provisioning status of the virtual hard disk
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualHardDiskStatusResponseProvisioningStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualHardDiskStatusResponseProvisioningStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualHardDiskStatusResponseProvisioningStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The provisioning status of the virtual hard disk
        :param str operation_id: The ID of the operation performed on the virtual hard disk
        :param str status: The status of the operation performed on the virtual hard disk [Succeeded, Failed, InProgress]
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        The ID of the operation performed on the virtual hard disk
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation performed on the virtual hard disk [Succeeded, Failed, InProgress]
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VirtualMachineStatusResponse(dict):
    """
    VirtualMachineStatus defines the observed state of virtualmachines
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "powerState":
            suggest = "power_state"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 power_state: Optional[str] = None,
                 provisioning_status: Optional['outputs.VirtualMachineStatusResponseProvisioningStatus'] = None):
        """
        VirtualMachineStatus defines the observed state of virtualmachines
        :param str error_code: VirtualMachine provisioning error code
        :param str error_message: Descriptive error message
        :param str power_state: The power state of the virtual machine
        :param 'VirtualMachineStatusResponseProvisioningStatus' provisioning_status: The provisioning status of the virtual machine
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        VirtualMachine provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[str]:
        """
        The power state of the virtual machine
        """
        return pulumi.get(self, "power_state")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional['outputs.VirtualMachineStatusResponseProvisioningStatus']:
        """
        The provisioning status of the virtual machine
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class VirtualMachineStatusResponseProvisioningStatus(dict):
    """
    The provisioning status of the virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStatusResponseProvisioningStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStatusResponseProvisioningStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStatusResponseProvisioningStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The provisioning status of the virtual machine
        :param str operation_id: The ID of the operation performed on the virtual machine
        :param str status: The status of the operation performed on the virtual machine [Succeeded, Failed, InProgress]
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        The ID of the operation performed on the virtual machine
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation performed on the virtual machine [Succeeded, Failed, InProgress]
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VirtualNetworkStatusResponse(dict):
    """
    VirtualNetworkStatus defines the observed state of virtual networks
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 provisioning_status: Optional['outputs.VirtualNetworkStatusResponseProvisioningStatus'] = None):
        """
        VirtualNetworkStatus defines the observed state of virtual networks
        :param str error_code: VirtualNetwork provisioning error code
        :param str error_message: Descriptive error message
        :param 'VirtualNetworkStatusResponseProvisioningStatus' provisioning_status: The provisioning status of the virtual network
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        VirtualNetwork provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional['outputs.VirtualNetworkStatusResponseProvisioningStatus']:
        """
        The provisioning status of the virtual network
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class VirtualNetworkStatusResponseProvisioningStatus(dict):
    """
    The provisioning status of the virtual network
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationId":
            suggest = "operation_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkStatusResponseProvisioningStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkStatusResponseProvisioningStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkStatusResponseProvisioningStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_id: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The provisioning status of the virtual network
        :param str operation_id: The ID of the operation performed on the virtual network
        :param str status: The status of the operation performed on the virtual network [Succeeded, Failed, InProgress]
        """
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        The ID of the operation performed on the virtual network
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the operation performed on the virtual network [Succeeded, Failed, InProgress]
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VirtualmachinesPropertiesResponseDataDisks(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class VirtualmachinesPropertiesResponseDynamicMemoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumMemoryGB":
            suggest = "maximum_memory_gb"
        elif key == "minimumMemoryGB":
            suggest = "minimum_memory_gb"
        elif key == "targetMemoryBuffer":
            suggest = "target_memory_buffer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseDynamicMemoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseDynamicMemoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseDynamicMemoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_memory_gb: Optional[float] = None,
                 minimum_memory_gb: Optional[float] = None,
                 target_memory_buffer: Optional[int] = None):
        if maximum_memory_gb is not None:
            pulumi.set(__self__, "maximum_memory_gb", maximum_memory_gb)
        if minimum_memory_gb is not None:
            pulumi.set(__self__, "minimum_memory_gb", minimum_memory_gb)
        if target_memory_buffer is not None:
            pulumi.set(__self__, "target_memory_buffer", target_memory_buffer)

    @property
    @pulumi.getter(name="maximumMemoryGB")
    def maximum_memory_gb(self) -> Optional[float]:
        return pulumi.get(self, "maximum_memory_gb")

    @property
    @pulumi.getter(name="minimumMemoryGB")
    def minimum_memory_gb(self) -> Optional[float]:
        return pulumi.get(self, "minimum_memory_gb")

    @property
    @pulumi.getter(name="targetMemoryBuffer")
    def target_memory_buffer(self) -> Optional[int]:
        return pulumi.get(self, "target_memory_buffer")


@pulumi.output_type
class VirtualmachinesPropertiesResponseHardwareProfile(dict):
    """
    HardwareProfile - Specifies the hardware settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamicMemoryConfig":
            suggest = "dynamic_memory_config"
        elif key == "memoryGB":
            suggest = "memory_gb"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseHardwareProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseHardwareProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseHardwareProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dynamic_memory_config: Optional['outputs.VirtualmachinesPropertiesResponseDynamicMemoryConfig'] = None,
                 memory_gb: Optional[int] = None,
                 processors: Optional[int] = None,
                 vm_size: Optional[str] = None):
        """
        HardwareProfile - Specifies the hardware settings for the virtual machine.
        :param int memory_gb: RAM in gb for the virtual machine
        :param int processors: number of processors for the virtual machine
        """
        if dynamic_memory_config is not None:
            pulumi.set(__self__, "dynamic_memory_config", dynamic_memory_config)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if processors is not None:
            pulumi.set(__self__, "processors", processors)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="dynamicMemoryConfig")
    def dynamic_memory_config(self) -> Optional['outputs.VirtualmachinesPropertiesResponseDynamicMemoryConfig']:
        return pulumi.get(self, "dynamic_memory_config")

    @property
    @pulumi.getter(name="memoryGB")
    def memory_gb(self) -> Optional[int]:
        """
        RAM in gb for the virtual machine
        """
        return pulumi.get(self, "memory_gb")

    @property
    @pulumi.getter
    def processors(self) -> Optional[int]:
        """
        number of processors for the virtual machine
        """
        return pulumi.get(self, "processors")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class VirtualmachinesPropertiesResponseImageReference(dict):
    """
    Which Image to use for the virtual machine
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Which Image to use for the virtual machine
        :param str name: Name - Name of the image
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - Name of the image
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VirtualmachinesPropertiesResponseLinuxConfiguration(dict):
    """
    LinuxConfiguration - linux specific configuration values for the virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"
        elif key == "provisionVMAgent":
            suggest = "provision_vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseLinuxConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseLinuxConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseLinuxConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_password_authentication: Optional[bool] = None,
                 provision_vm_agent: Optional[bool] = None,
                 ssh: Optional['outputs.VirtualmachinesPropertiesResponseSsh'] = None):
        """
        LinuxConfiguration - linux specific configuration values for the virtual machine
        :param bool disable_password_authentication: DisablePasswordAuthentication - whether password authentication should be disabled
        :param bool provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
        :param 'VirtualmachinesPropertiesResponseSsh' ssh: SSH - contains settings related to ssh configuration
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[bool]:
        """
        DisablePasswordAuthentication - whether password authentication should be disabled
        """
        return pulumi.get(self, "disable_password_authentication")

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[bool]:
        """
        Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
        """
        return pulumi.get(self, "provision_vm_agent")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.VirtualmachinesPropertiesResponseSsh']:
        """
        SSH - contains settings related to ssh configuration
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class VirtualmachinesPropertiesResponseNetworkInterfaces(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: ID - Resource Id of the network interface
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID - Resource Id of the network interface
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualmachinesPropertiesResponseNetworkProfile(dict):
    """
    NetworkProfile - describes the network configuration the virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseNetworkProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseNetworkProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseNetworkProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Optional[Sequence['outputs.VirtualmachinesPropertiesResponseNetworkInterfaces']] = None):
        """
        NetworkProfile - describes the network configuration the virtual machine
        :param Sequence['VirtualmachinesPropertiesResponseNetworkInterfaces'] network_interfaces: NetworkInterfaces - list of network interfaces to be attached to the virtual machine
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponseNetworkInterfaces']]:
        """
        NetworkInterfaces - list of network interfaces to be attached to the virtual machine
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class VirtualmachinesPropertiesResponseOsDisk(dict):
    """
    VHD to attach as OS disk
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        VHD to attach as OS disk
        :param str id: Specifies the virtual hard disk's ID
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Specifies the virtual hard disk's ID
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualmachinesPropertiesResponseOsProfile(dict):
    """
    OsProfile - describes the configuration of the operating system and sets login data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "osType":
            suggest = "os_type"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseOsProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseOsProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseOsProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_username: Optional[str] = None,
                 computer_name: Optional[str] = None,
                 linux_configuration: Optional['outputs.VirtualmachinesPropertiesResponseLinuxConfiguration'] = None,
                 os_type: Optional[str] = None,
                 windows_configuration: Optional['outputs.VirtualmachinesPropertiesResponseWindowsConfiguration'] = None):
        """
        OsProfile - describes the configuration of the operating system and sets login data
        :param str admin_username: AdminUsername - admin username
        :param str computer_name: ComputerName - name of the compute
        :param 'VirtualmachinesPropertiesResponseLinuxConfiguration' linux_configuration: LinuxConfiguration - linux specific configuration values for the virtual machine
        :param str os_type: OsType - string specifying whether the OS is Linux or Windows
        :param 'VirtualmachinesPropertiesResponseWindowsConfiguration' windows_configuration: Windows Configuration for the virtual machine 
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        AdminUsername - admin username
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        ComputerName - name of the compute
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.VirtualmachinesPropertiesResponseLinuxConfiguration']:
        """
        LinuxConfiguration - linux specific configuration values for the virtual machine
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        OsType - string specifying whether the OS is Linux or Windows
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.VirtualmachinesPropertiesResponseWindowsConfiguration']:
        """
        Windows Configuration for the virtual machine 
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class VirtualmachinesPropertiesResponsePublicKeys(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponsePublicKeys. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponsePublicKeys.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponsePublicKeys.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str key_data: KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param str path: Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class VirtualmachinesPropertiesResponsePublicKeysPublicKeys(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponsePublicKeysPublicKeys. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponsePublicKeysPublicKeys.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponsePublicKeysPublicKeys.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str key_data: KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param str path: Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class VirtualmachinesPropertiesResponseSecurityProfile(dict):
    """
    SecurityProfile - Specifies the security settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableTPM":
            suggest = "enable_tpm"
        elif key == "uefiSettings":
            suggest = "uefi_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseSecurityProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseSecurityProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseSecurityProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_tpm: Optional[bool] = None,
                 uefi_settings: Optional['outputs.VirtualmachinesPropertiesResponseUefiSettings'] = None):
        """
        SecurityProfile - Specifies the security settings for the virtual machine.
        """
        if enable_tpm is not None:
            pulumi.set(__self__, "enable_tpm", enable_tpm)
        if uefi_settings is not None:
            pulumi.set(__self__, "uefi_settings", uefi_settings)

    @property
    @pulumi.getter(name="enableTPM")
    def enable_tpm(self) -> Optional[bool]:
        return pulumi.get(self, "enable_tpm")

    @property
    @pulumi.getter(name="uefiSettings")
    def uefi_settings(self) -> Optional['outputs.VirtualmachinesPropertiesResponseUefiSettings']:
        return pulumi.get(self, "uefi_settings")


@pulumi.output_type
class VirtualmachinesPropertiesResponseSsh(dict):
    """
    SSH - contains settings related to ssh configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeys']] = None):
        """
        SSH - contains settings related to ssh configuration
        :param Sequence['VirtualmachinesPropertiesResponsePublicKeys'] public_keys: PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeys']]:
        """
        PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class VirtualmachinesPropertiesResponseSshSsh(dict):
    """
    SSH Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseSshSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseSshSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseSshSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeysPublicKeys']] = None):
        """
        SSH Configuration
        :param Sequence['VirtualmachinesPropertiesResponsePublicKeysPublicKeys'] public_keys: PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeysPublicKeys']]:
        """
        PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class VirtualmachinesPropertiesResponseStorageProfile(dict):
    """
    StorageProfile - contains information about the disks and storage information for the virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "osDisk":
            suggest = "os_disk"
        elif key == "vmConfigContainerName":
            suggest = "vm_config_container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseStorageProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseStorageProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseStorageProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.VirtualmachinesPropertiesResponseDataDisks']] = None,
                 image_reference: Optional['outputs.VirtualmachinesPropertiesResponseImageReference'] = None,
                 os_disk: Optional['outputs.VirtualmachinesPropertiesResponseOsDisk'] = None,
                 vm_config_container_name: Optional[str] = None):
        """
        StorageProfile - contains information about the disks and storage information for the virtual machine
        :param Sequence['VirtualmachinesPropertiesResponseDataDisks'] data_disks: adds data disks to the virtual machine
        :param 'VirtualmachinesPropertiesResponseImageReference' image_reference: Which Image to use for the virtual machine
        :param 'VirtualmachinesPropertiesResponseOsDisk' os_disk: VHD to attach as OS disk
        :param str vm_config_container_name: Name of the storage container that hosts the VM configuration file
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)
        if vm_config_container_name is not None:
            pulumi.set(__self__, "vm_config_container_name", vm_config_container_name)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponseDataDisks']]:
        """
        adds data disks to the virtual machine
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.VirtualmachinesPropertiesResponseImageReference']:
        """
        Which Image to use for the virtual machine
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.VirtualmachinesPropertiesResponseOsDisk']:
        """
        VHD to attach as OS disk
        """
        return pulumi.get(self, "os_disk")

    @property
    @pulumi.getter(name="vmConfigContainerName")
    def vm_config_container_name(self) -> Optional[str]:
        """
        Name of the storage container that hosts the VM configuration file
        """
        return pulumi.get(self, "vm_config_container_name")


@pulumi.output_type
class VirtualmachinesPropertiesResponseUefiSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secureBootEnabled":
            suggest = "secure_boot_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseUefiSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseUefiSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseUefiSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secure_boot_enabled: Optional[bool] = None):
        """
        :param bool secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual machine.
        """
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)

    @property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[bool]:
        """
        Specifies whether secure boot should be enabled on the virtual machine.
        """
        return pulumi.get(self, "secure_boot_enabled")


@pulumi.output_type
class VirtualmachinesPropertiesResponseWindowsConfiguration(dict):
    """
    Windows Configuration for the virtual machine 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"
        elif key == "provisionVMAgent":
            suggest = "provision_vm_agent"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseWindowsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseWindowsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseWindowsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_automatic_updates: Optional[bool] = None,
                 provision_vm_agent: Optional[bool] = None,
                 ssh: Optional['outputs.VirtualmachinesPropertiesResponseSshSsh'] = None,
                 time_zone: Optional[str] = None):
        """
        Windows Configuration for the virtual machine 
        :param bool enable_automatic_updates: Whether to EnableAutomaticUpdates on the machine
        :param bool provision_vm_agent: Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
        :param 'VirtualmachinesPropertiesResponseSshSsh' ssh: SSH Configuration
        :param str time_zone: TimeZone for the virtual machine
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[bool]:
        """
        Whether to EnableAutomaticUpdates on the machine
        """
        return pulumi.get(self, "enable_automatic_updates")

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[bool]:
        """
        Used to indicate whether Arc for Servers agent onboarding should be triggered during the virtual machine creation process.
        """
        return pulumi.get(self, "provision_vm_agent")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.VirtualmachinesPropertiesResponseSshSsh']:
        """
        SSH Configuration
        """
        return pulumi.get(self, "ssh")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        TimeZone for the virtual machine
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class VirtualnetworksPropertiesResponseIpConfigurationReferences(dict):
    """
    IPConfigurationReference - Describes a IPConfiguration under the virtual network
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        IPConfigurationReference - Describes a IPConfiguration under the virtual network
        :param str id: IPConfigurationID
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        IPConfigurationID
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualnetworksPropertiesResponseRouteTable(dict):
    """
    RouteTable for the subnet
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 routes: Optional[Sequence['outputs.VirtualnetworksPropertiesResponseRoutes']] = None,
                 type: Optional[str] = None):
        """
        RouteTable for the subnet
        :param str id: Etag - Gets a unique read-only string that changes whenever the resource is updated.
        :param str name: Name - READ-ONLY; Resource name.
        :param Sequence['VirtualnetworksPropertiesResponseRoutes'] routes: Routes - Collection of routes contained within a route table.
        :param str type: Type - READ-ONLY; Resource type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Etag - Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - READ-ONLY; Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.VirtualnetworksPropertiesResponseRoutes']]:
        """
        Routes - Collection of routes contained within a route table.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type - READ-ONLY; Resource type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VirtualnetworksPropertiesResponseRoutes(dict):
    """
    Route is associated with a subnet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualnetworksPropertiesResponseRoutes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualnetworksPropertiesResponseRoutes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualnetworksPropertiesResponseRoutes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: Optional[str] = None,
                 name: Optional[str] = None,
                 next_hop_ip_address: Optional[str] = None):
        """
        Route is associated with a subnet.
        :param str address_prefix: AddressPrefix - The destination CIDR to which the route applies.
        :param str name: Name - name of the subnet
        :param str next_hop_ip_address: NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        AddressPrefix - The destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - name of the subnet
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")


@pulumi.output_type
class VirtualnetworksPropertiesResponseSubnets(dict):
    """
    Subnet subnet in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "addressPrefixes":
            suggest = "address_prefixes"
        elif key == "ipAllocationMethod":
            suggest = "ip_allocation_method"
        elif key == "ipConfigurationReferences":
            suggest = "ip_configuration_references"
        elif key == "ipPools":
            suggest = "ip_pools"
        elif key == "routeTable":
            suggest = "route_table"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualnetworksPropertiesResponseSubnets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualnetworksPropertiesResponseSubnets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualnetworksPropertiesResponseSubnets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: Optional[str] = None,
                 address_prefixes: Optional[Sequence[str]] = None,
                 ip_allocation_method: Optional[str] = None,
                 ip_configuration_references: Optional[Sequence['outputs.VirtualnetworksPropertiesResponseIpConfigurationReferences']] = None,
                 ip_pools: Optional[Sequence['outputs.IPPoolResponse']] = None,
                 name: Optional[str] = None,
                 route_table: Optional['outputs.VirtualnetworksPropertiesResponseRouteTable'] = None,
                 vlan: Optional[int] = None):
        """
        Subnet subnet in a virtual network resource.
        :param str address_prefix: Cidr for this subnet - IPv4, IPv6
        :param Sequence[str] address_prefixes: AddressPrefixes - List of address prefixes for the subnet.
        :param str ip_allocation_method: IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
        :param Sequence['VirtualnetworksPropertiesResponseIpConfigurationReferences'] ip_configuration_references: IPConfigurationReferences - list of IPConfigurationReferences
        :param Sequence['IPPoolResponse'] ip_pools: network associated pool of IP Addresses
        :param str name: Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'VirtualnetworksPropertiesResponseRouteTable' route_table: RouteTable for the subnet
        :param int vlan: Vlan to use for the subnet
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if ip_allocation_method is not None:
            pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        if ip_configuration_references is not None:
            pulumi.set(__self__, "ip_configuration_references", ip_configuration_references)
        if ip_pools is not None:
            pulumi.set(__self__, "ip_pools", ip_pools)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        Cidr for this subnet - IPv4, IPv6
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        AddressPrefixes - List of address prefixes for the subnet.
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> Optional[str]:
        """
        IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
        """
        return pulumi.get(self, "ip_allocation_method")

    @property
    @pulumi.getter(name="ipConfigurationReferences")
    def ip_configuration_references(self) -> Optional[Sequence['outputs.VirtualnetworksPropertiesResponseIpConfigurationReferences']]:
        """
        IPConfigurationReferences - list of IPConfigurationReferences
        """
        return pulumi.get(self, "ip_configuration_references")

    @property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[Sequence['outputs.IPPoolResponse']]:
        """
        network associated pool of IP Addresses
        """
        return pulumi.get(self, "ip_pools")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional['outputs.VirtualnetworksPropertiesResponseRouteTable']:
        """
        RouteTable for the subnet
        """
        return pulumi.get(self, "route_table")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[int]:
        """
        Vlan to use for the subnet
        """
        return pulumi.get(self, "vlan")


