# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointPropertyResponse',
    'PrivateLinkServiceConnectionStatePropertyResponse',
    'ResourceIdentityResponse',
    'ServerPrivateEndpointConnectionResponse',
    'SkuResponse',
    'SyncGroupSchemaResponse',
    'SyncGroupSchemaTableColumnResponse',
    'SyncGroupSchemaTableResponse',
]

@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    Properties of a private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 private_endpoint: Optional['outputs.PrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse'] = None):
        """
        Properties of a private endpoint connection.
        :param str provisioning_state: State of the private endpoint connection.
        :param 'PrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointPropertyResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStatePropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        :param str actions_required: The actions required for private link service connection.
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        The actions required for private link service connection.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    Azure Active Directory identity configuration for a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Azure Active Directory identity configuration for a resource.
        :param str principal_id: The Azure Active Directory principal id.
        :param str tenant_id: The Azure Active Directory tenant id.
        :param str type: The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The Azure Active Directory principal id.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Azure Active Directory tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerPrivateEndpointConnectionResponse(dict):
    """
    A private endpoint connection under a server
    """
    def __init__(__self__, *,
                 id: str,
                 properties: 'outputs.PrivateEndpointConnectionPropertiesResponse'):
        """
        A private endpoint connection under a server
        :param str id: Resource ID.
        :param 'PrivateEndpointConnectionPropertiesResponse' properties: Private endpoint connection properties
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.PrivateEndpointConnectionPropertiesResponse':
        """
        Private endpoint connection properties
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SkuResponse(dict):
    """
    An ARM Resource SKU.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        An ARM Resource SKU.
        :param str name: The name of the SKU, typically, a letter + Number code, e.g. P3.
        :param int capacity: Capacity of the particular SKU.
        :param str family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param str size: Size of the particular SKU
        :param str tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU, typically, a letter + Number code, e.g. P3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity of the particular SKU.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Size of the particular SKU
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier or edition of the particular SKU, e.g. Basic, Premium.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SyncGroupSchemaResponse(dict):
    """
    Properties of sync group schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterSyncMemberName":
            suggest = "master_sync_member_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncGroupSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncGroupSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncGroupSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_sync_member_name: Optional[str] = None,
                 tables: Optional[Sequence['outputs.SyncGroupSchemaTableResponse']] = None):
        """
        Properties of sync group schema.
        :param str master_sync_member_name: Name of master sync member where the schema is from.
        :param Sequence['SyncGroupSchemaTableResponse'] tables: List of tables in sync group schema.
        """
        if master_sync_member_name is not None:
            pulumi.set(__self__, "master_sync_member_name", master_sync_member_name)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="masterSyncMemberName")
    def master_sync_member_name(self) -> Optional[str]:
        """
        Name of master sync member where the schema is from.
        """
        return pulumi.get(self, "master_sync_member_name")

    @property
    @pulumi.getter
    def tables(self) -> Optional[Sequence['outputs.SyncGroupSchemaTableResponse']]:
        """
        List of tables in sync group schema.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class SyncGroupSchemaTableColumnResponse(dict):
    """
    Properties of column in sync group table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSize":
            suggest = "data_size"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "quotedName":
            suggest = "quoted_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncGroupSchemaTableColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncGroupSchemaTableColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncGroupSchemaTableColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_size: Optional[str] = None,
                 data_type: Optional[str] = None,
                 quoted_name: Optional[str] = None):
        """
        Properties of column in sync group table.
        :param str data_size: Data size of the column.
        :param str data_type: Data type of the column.
        :param str quoted_name: Quoted name of sync group table column.
        """
        if data_size is not None:
            pulumi.set(__self__, "data_size", data_size)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if quoted_name is not None:
            pulumi.set(__self__, "quoted_name", quoted_name)

    @property
    @pulumi.getter(name="dataSize")
    def data_size(self) -> Optional[str]:
        """
        Data size of the column.
        """
        return pulumi.get(self, "data_size")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        Data type of the column.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="quotedName")
    def quoted_name(self) -> Optional[str]:
        """
        Quoted name of sync group table column.
        """
        return pulumi.get(self, "quoted_name")


@pulumi.output_type
class SyncGroupSchemaTableResponse(dict):
    """
    Properties of table in sync group schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "quotedName":
            suggest = "quoted_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncGroupSchemaTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncGroupSchemaTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncGroupSchemaTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.SyncGroupSchemaTableColumnResponse']] = None,
                 quoted_name: Optional[str] = None):
        """
        Properties of table in sync group schema.
        :param Sequence['SyncGroupSchemaTableColumnResponse'] columns: List of columns in sync group schema.
        :param str quoted_name: Quoted name of sync group schema table.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if quoted_name is not None:
            pulumi.set(__self__, "quoted_name", quoted_name)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.SyncGroupSchemaTableColumnResponse']]:
        """
        List of columns in sync group schema.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="quotedName")
    def quoted_name(self) -> Optional[str]:
        """
        Quoted name of sync group schema table.
        """
        return pulumi.get(self, "quoted_name")


