# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ContactParametersContactProfile',
    'ContactProfileLinkChannelArgs',
    'ContactProfileLinkArgs',
    'ContactProfilesPropertiesNetworkConfigurationArgs',
    'ContactsPropertiesContactProfileArgs',
    'EndPointArgs',
    'SpacecraftLinkArgs',
]

@pulumi.input_type
class ContactParametersContactProfile:
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The reference to the contact profile resource.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ContactProfileLinkChannelArgs:
    def __init__(__self__, *,
                 bandwidth_m_hz: pulumi.Input[float],
                 center_frequency_m_hz: pulumi.Input[float],
                 end_point: pulumi.Input['EndPointArgs'],
                 name: pulumi.Input[str],
                 decoding_configuration: Optional[pulumi.Input[str]] = None,
                 demodulation_configuration: Optional[pulumi.Input[str]] = None,
                 encoding_configuration: Optional[pulumi.Input[str]] = None,
                 modulation_configuration: Optional[pulumi.Input[str]] = None):
        """
        Contact Profile Link Channel.
        :param pulumi.Input[float] bandwidth_m_hz: Bandwidth in MHz.
        :param pulumi.Input[float] center_frequency_m_hz: Center Frequency in MHz.
        :param pulumi.Input['EndPointArgs'] end_point: Customer End point to store/retrieve data during a contact.
        :param pulumi.Input[str] name: Channel name.
        :param pulumi.Input[str] decoding_configuration: Currently unused.
        :param pulumi.Input[str] demodulation_configuration: Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
        :param pulumi.Input[str] encoding_configuration: Currently unused.
        :param pulumi.Input[str] modulation_configuration: Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
        """
        pulumi.set(__self__, "bandwidth_m_hz", bandwidth_m_hz)
        pulumi.set(__self__, "center_frequency_m_hz", center_frequency_m_hz)
        pulumi.set(__self__, "end_point", end_point)
        pulumi.set(__self__, "name", name)
        if decoding_configuration is not None:
            pulumi.set(__self__, "decoding_configuration", decoding_configuration)
        if demodulation_configuration is not None:
            pulumi.set(__self__, "demodulation_configuration", demodulation_configuration)
        if encoding_configuration is not None:
            pulumi.set(__self__, "encoding_configuration", encoding_configuration)
        if modulation_configuration is not None:
            pulumi.set(__self__, "modulation_configuration", modulation_configuration)

    @property
    @pulumi.getter(name="bandwidthMHz")
    def bandwidth_m_hz(self) -> pulumi.Input[float]:
        """
        Bandwidth in MHz.
        """
        return pulumi.get(self, "bandwidth_m_hz")

    @bandwidth_m_hz.setter
    def bandwidth_m_hz(self, value: pulumi.Input[float]):
        pulumi.set(self, "bandwidth_m_hz", value)

    @property
    @pulumi.getter(name="centerFrequencyMHz")
    def center_frequency_m_hz(self) -> pulumi.Input[float]:
        """
        Center Frequency in MHz.
        """
        return pulumi.get(self, "center_frequency_m_hz")

    @center_frequency_m_hz.setter
    def center_frequency_m_hz(self, value: pulumi.Input[float]):
        pulumi.set(self, "center_frequency_m_hz", value)

    @property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> pulumi.Input['EndPointArgs']:
        """
        Customer End point to store/retrieve data during a contact.
        """
        return pulumi.get(self, "end_point")

    @end_point.setter
    def end_point(self, value: pulumi.Input['EndPointArgs']):
        pulumi.set(self, "end_point", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Channel name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="decodingConfiguration")
    def decoding_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Currently unused.
        """
        return pulumi.get(self, "decoding_configuration")

    @decoding_configuration.setter
    def decoding_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "decoding_configuration", value)

    @property
    @pulumi.getter(name="demodulationConfiguration")
    def demodulation_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
        """
        return pulumi.get(self, "demodulation_configuration")

    @demodulation_configuration.setter
    def demodulation_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "demodulation_configuration", value)

    @property
    @pulumi.getter(name="encodingConfiguration")
    def encoding_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Currently unused.
        """
        return pulumi.get(self, "encoding_configuration")

    @encoding_configuration.setter
    def encoding_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding_configuration", value)

    @property
    @pulumi.getter(name="modulationConfiguration")
    def modulation_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
        """
        return pulumi.get(self, "modulation_configuration")

    @modulation_configuration.setter
    def modulation_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modulation_configuration", value)


@pulumi.input_type
class ContactProfileLinkArgs:
    def __init__(__self__, *,
                 channels: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]],
                 direction: pulumi.Input[Union[str, 'Direction']],
                 name: pulumi.Input[str],
                 polarization: pulumi.Input[Union[str, 'Polarization']],
                 eirpd_bw: Optional[pulumi.Input[float]] = None,
                 gain_over_temperature: Optional[pulumi.Input[float]] = None):
        """
        Contact Profile Link.
        :param pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]] channels: Contact Profile Link Channel.
        :param pulumi.Input[Union[str, 'Direction']] direction: Direction (uplink or downlink).
        :param pulumi.Input[str] name: Link name.
        :param pulumi.Input[Union[str, 'Polarization']] polarization: Polarization. e.g. (RHCP, LHCP).
        :param pulumi.Input[float] eirpd_bw: Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet.
        :param pulumi.Input[float] gain_over_temperature: Gain To Noise Temperature in db/K. It is the required G/T by the customer. Not used yet.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "polarization", polarization)
        if eirpd_bw is not None:
            pulumi.set(__self__, "eirpd_bw", eirpd_bw)
        if gain_over_temperature is not None:
            pulumi.set(__self__, "gain_over_temperature", gain_over_temperature)

    @property
    @pulumi.getter
    def channels(self) -> pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]]:
        """
        Contact Profile Link Channel.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: pulumi.Input[Sequence[pulumi.Input['ContactProfileLinkChannelArgs']]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[Union[str, 'Direction']]:
        """
        Direction (uplink or downlink).
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[Union[str, 'Direction']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Link name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def polarization(self) -> pulumi.Input[Union[str, 'Polarization']]:
        """
        Polarization. e.g. (RHCP, LHCP).
        """
        return pulumi.get(self, "polarization")

    @polarization.setter
    def polarization(self, value: pulumi.Input[Union[str, 'Polarization']]):
        pulumi.set(self, "polarization", value)

    @property
    @pulumi.getter(name="eirpdBW")
    def eirpd_bw(self) -> Optional[pulumi.Input[float]]:
        """
        Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet.
        """
        return pulumi.get(self, "eirpd_bw")

    @eirpd_bw.setter
    def eirpd_bw(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "eirpd_bw", value)

    @property
    @pulumi.getter(name="gainOverTemperature")
    def gain_over_temperature(self) -> Optional[pulumi.Input[float]]:
        """
        Gain To Noise Temperature in db/K. It is the required G/T by the customer. Not used yet.
        """
        return pulumi.get(self, "gain_over_temperature")

    @gain_over_temperature.setter
    def gain_over_temperature(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "gain_over_temperature", value)


@pulumi.input_type
class ContactProfilesPropertiesNetworkConfigurationArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str]):
        """
        Network configuration of customer virtual network.
        :param pulumi.Input[str] subnet_id: ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class ContactsPropertiesContactProfileArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The reference to the contact profile resource.
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class EndPointArgs:
    def __init__(__self__, *,
                 end_point_name: pulumi.Input[str],
                 ip_address: pulumi.Input[str],
                 port: pulumi.Input[str],
                 protocol: pulumi.Input[Union[str, 'Protocol']]):
        """
        Customer End point to store/retrieve data during a contact.
        :param pulumi.Input[str] end_point_name: Name of an end point.
        :param pulumi.Input[str] ip_address: IP Address.
        :param pulumi.Input[str] port: TCP port to listen on to receive data.
        :param pulumi.Input[Union[str, 'Protocol']] protocol: Protocol either UDP or TCP.
        """
        pulumi.set(__self__, "end_point_name", end_point_name)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="endPointName")
    def end_point_name(self) -> pulumi.Input[str]:
        """
        Name of an end point.
        """
        return pulumi.get(self, "end_point_name")

    @end_point_name.setter
    def end_point_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_point_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        TCP port to listen on to receive data.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'Protocol']]:
        """
        Protocol either UDP or TCP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'Protocol']]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class SpacecraftLinkArgs:
    def __init__(__self__, *,
                 bandwidth_m_hz: pulumi.Input[float],
                 center_frequency_m_hz: pulumi.Input[float],
                 direction: pulumi.Input[Union[str, 'Direction']],
                 name: pulumi.Input[str],
                 polarization: pulumi.Input[Union[str, 'Polarization']]):
        """
        List of authorized spacecraft links per ground station and the expiration date of the authorization.
        :param pulumi.Input[float] bandwidth_m_hz: Bandwidth in MHz.
        :param pulumi.Input[float] center_frequency_m_hz: Center Frequency in MHz.
        :param pulumi.Input[Union[str, 'Direction']] direction: Direction (uplink or downlink).
        :param pulumi.Input[str] name: Link name.
        :param pulumi.Input[Union[str, 'Polarization']] polarization: Polarization. e.g. (RHCP, LHCP).
        """
        pulumi.set(__self__, "bandwidth_m_hz", bandwidth_m_hz)
        pulumi.set(__self__, "center_frequency_m_hz", center_frequency_m_hz)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "polarization", polarization)

    @property
    @pulumi.getter(name="bandwidthMHz")
    def bandwidth_m_hz(self) -> pulumi.Input[float]:
        """
        Bandwidth in MHz.
        """
        return pulumi.get(self, "bandwidth_m_hz")

    @bandwidth_m_hz.setter
    def bandwidth_m_hz(self, value: pulumi.Input[float]):
        pulumi.set(self, "bandwidth_m_hz", value)

    @property
    @pulumi.getter(name="centerFrequencyMHz")
    def center_frequency_m_hz(self) -> pulumi.Input[float]:
        """
        Center Frequency in MHz.
        """
        return pulumi.get(self, "center_frequency_m_hz")

    @center_frequency_m_hz.setter
    def center_frequency_m_hz(self, value: pulumi.Input[float]):
        pulumi.set(self, "center_frequency_m_hz", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[Union[str, 'Direction']]:
        """
        Direction (uplink or downlink).
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[Union[str, 'Direction']]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Link name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def polarization(self) -> pulumi.Input[Union[str, 'Polarization']]:
        """
        Polarization. e.g. (RHCP, LHCP).
        """
        return pulumi.get(self, "polarization")

    @polarization.setter
    def polarization(self, value: pulumi.Input[Union[str, 'Polarization']]):
        pulumi.set(self, "polarization", value)


