# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'MonitoringAccountResponseDefaultIngestionSettings',
    'MonitoringAccountResponseMetrics',
    'SystemDataResponse',
]

@pulumi.output_type
class MonitoringAccountResponseDefaultIngestionSettings(dict):
    """
    The Data Collection Rule and Endpoint used for ingestion by default.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCollectionEndpointResourceId":
            suggest = "data_collection_endpoint_resource_id"
        elif key == "dataCollectionRuleResourceId":
            suggest = "data_collection_rule_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringAccountResponseDefaultIngestionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringAccountResponseDefaultIngestionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringAccountResponseDefaultIngestionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_collection_endpoint_resource_id: str,
                 data_collection_rule_resource_id: str):
        """
        The Data Collection Rule and Endpoint used for ingestion by default.
        :param str data_collection_endpoint_resource_id: The Azure resource Id of the default data collection endpoint for this monitoring account.
        :param str data_collection_rule_resource_id: The Azure resource Id of the default data collection rule for this monitoring account.
        """
        pulumi.set(__self__, "data_collection_endpoint_resource_id", data_collection_endpoint_resource_id)
        pulumi.set(__self__, "data_collection_rule_resource_id", data_collection_rule_resource_id)

    @property
    @pulumi.getter(name="dataCollectionEndpointResourceId")
    def data_collection_endpoint_resource_id(self) -> str:
        """
        The Azure resource Id of the default data collection endpoint for this monitoring account.
        """
        return pulumi.get(self, "data_collection_endpoint_resource_id")

    @property
    @pulumi.getter(name="dataCollectionRuleResourceId")
    def data_collection_rule_resource_id(self) -> str:
        """
        The Azure resource Id of the default data collection rule for this monitoring account.
        """
        return pulumi.get(self, "data_collection_rule_resource_id")


@pulumi.output_type
class MonitoringAccountResponseMetrics(dict):
    """
    Information about metrics for the monitoring account
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalId":
            suggest = "internal_id"
        elif key == "prometheusQueryEndpoint":
            suggest = "prometheus_query_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringAccountResponseMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringAccountResponseMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringAccountResponseMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 internal_id: str,
                 prometheus_query_endpoint: str):
        """
        Information about metrics for the monitoring account
        :param str internal_id: An internal identifier for the metrics container. Only to be used by the system
        :param str prometheus_query_endpoint: The Prometheus query endpoint for the monitoring account
        """
        pulumi.set(__self__, "internal_id", internal_id)
        pulumi.set(__self__, "prometheus_query_endpoint", prometheus_query_endpoint)

    @property
    @pulumi.getter(name="internalId")
    def internal_id(self) -> str:
        """
        An internal identifier for the metrics container. Only to be used by the system
        """
        return pulumi.get(self, "internal_id")

    @property
    @pulumi.getter(name="prometheusQueryEndpoint")
    def prometheus_query_endpoint(self) -> str:
        """
        The Prometheus query endpoint for the monitoring account
        """
        return pulumi.get(self, "prometheus_query_endpoint")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


