# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetManagerEncryptionKeyResult',
    'AwaitableGetManagerEncryptionKeyResult',
    'get_manager_encryption_key',
    'get_manager_encryption_key_output',
]

@pulumi.output_type
class GetManagerEncryptionKeyResult:
    """
    This class can be used as the Type for any secret entity represented as Value, ValueCertificateThumbprint, EncryptionAlgorithm. In this case, "Value" is a secret and the "valueThumbprint" represents the certificate thumbprint of the value. The algorithm field is mainly for future usage to potentially allow different entities encrypted using different algorithms.
    """
    def __init__(__self__, encryption_algorithm=None, value=None, value_certificate_thumbprint=None):
        if encryption_algorithm and not isinstance(encryption_algorithm, str):
            raise TypeError("Expected argument 'encryption_algorithm' to be a str")
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if value_certificate_thumbprint and not isinstance(value_certificate_thumbprint, str):
            raise TypeError("Expected argument 'value_certificate_thumbprint' to be a str")
        pulumi.set(__self__, "value_certificate_thumbprint", value_certificate_thumbprint)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> str:
        """
        Algorithm used to encrypt "Value"
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the secret itself. If the secret is in plaintext or null then EncryptionAlgorithm will be none
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueCertificateThumbprint")
    def value_certificate_thumbprint(self) -> Optional[str]:
        """
        Thumbprint cert that was used to encrypt "Value"
        """
        return pulumi.get(self, "value_certificate_thumbprint")


class AwaitableGetManagerEncryptionKeyResult(GetManagerEncryptionKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagerEncryptionKeyResult(
            encryption_algorithm=self.encryption_algorithm,
            value=self.value,
            value_certificate_thumbprint=self.value_certificate_thumbprint)


def get_manager_encryption_key(manager_name: Optional[str] = None,
                               resource_group_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagerEncryptionKeyResult:
    """
    This class can be used as the Type for any secret entity represented as Value, ValueCertificateThumbprint, EncryptionAlgorithm. In this case, "Value" is a secret and the "valueThumbprint" represents the certificate thumbprint of the value. The algorithm field is mainly for future usage to potentially allow different entities encrypted using different algorithms.


    :param str manager_name: The manager name
    :param str resource_group_name: The resource group name
    """
    __args__ = dict()
    __args__['managerName'] = manager_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:storsimple/v20161001:getManagerEncryptionKey', __args__, opts=opts, typ=GetManagerEncryptionKeyResult).value

    return AwaitableGetManagerEncryptionKeyResult(
        encryption_algorithm=__ret__.encryption_algorithm,
        value=__ret__.value,
        value_certificate_thumbprint=__ret__.value_certificate_thumbprint)


@_utilities.lift_output_func(get_manager_encryption_key)
def get_manager_encryption_key_output(manager_name: Optional[pulumi.Input[str]] = None,
                                      resource_group_name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagerEncryptionKeyResult]:
    """
    This class can be used as the Type for any secret entity represented as Value, ValueCertificateThumbprint, EncryptionAlgorithm. In this case, "Value" is a secret and the "valueThumbprint" represents the certificate thumbprint of the value. The algorithm field is mainly for future usage to potentially allow different entities encrypted using different algorithms.


    :param str manager_name: The manager name
    :param str resource_group_name: The resource group name
    """
    ...
