# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['StorageAccountCredentialArgs', 'StorageAccountCredential']

@pulumi.input_type
class StorageAccountCredentialArgs:
    def __init__(__self__, *,
                 end_point: pulumi.Input[str],
                 manager_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 ssl_status: pulumi.Input['SslStatus'],
                 access_key: Optional[pulumi.Input['AsymmetricEncryptedSecretArgs']] = None,
                 kind: Optional[pulumi.Input['Kind']] = None,
                 storage_account_credential_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a StorageAccountCredential resource.
        :param pulumi.Input[str] end_point: The storage endpoint
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input[str] resource_group_name: The resource group name
        :param pulumi.Input['SslStatus'] ssl_status: Signifies whether SSL needs to be enabled or not.
        :param pulumi.Input['AsymmetricEncryptedSecretArgs'] access_key: The details of the storage account password.
        :param pulumi.Input['Kind'] kind: The Kind of the object. Currently only Series8000 is supported
        :param pulumi.Input[str] storage_account_credential_name: The storage account credential name.
        """
        pulumi.set(__self__, "end_point", end_point)
        pulumi.set(__self__, "manager_name", manager_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "ssl_status", ssl_status)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if storage_account_credential_name is not None:
            pulumi.set(__self__, "storage_account_credential_name", storage_account_credential_name)

    @property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> pulumi.Input[str]:
        """
        The storage endpoint
        """
        return pulumi.get(self, "end_point")

    @end_point.setter
    def end_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_point", value)

    @property
    @pulumi.getter(name="managerName")
    def manager_name(self) -> pulumi.Input[str]:
        """
        The manager name
        """
        return pulumi.get(self, "manager_name")

    @manager_name.setter
    def manager_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "manager_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="sslStatus")
    def ssl_status(self) -> pulumi.Input['SslStatus']:
        """
        Signifies whether SSL needs to be enabled or not.
        """
        return pulumi.get(self, "ssl_status")

    @ssl_status.setter
    def ssl_status(self, value: pulumi.Input['SslStatus']):
        pulumi.set(self, "ssl_status", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input['AsymmetricEncryptedSecretArgs']]:
        """
        The details of the storage account password.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input['AsymmetricEncryptedSecretArgs']]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input['Kind']]:
        """
        The Kind of the object. Currently only Series8000 is supported
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input['Kind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="storageAccountCredentialName")
    def storage_account_credential_name(self) -> Optional[pulumi.Input[str]]:
        """
        The storage account credential name.
        """
        return pulumi.get(self, "storage_account_credential_name")

    @storage_account_credential_name.setter
    def storage_account_credential_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_credential_name", value)


class StorageAccountCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[pulumi.InputType['AsymmetricEncryptedSecretArgs']]] = None,
                 end_point: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input['Kind']] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 ssl_status: Optional[pulumi.Input['SslStatus']] = None,
                 storage_account_credential_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The storage account credential.
        API Version: 2017-06-01.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AsymmetricEncryptedSecretArgs']] access_key: The details of the storage account password.
        :param pulumi.Input[str] end_point: The storage endpoint
        :param pulumi.Input['Kind'] kind: The Kind of the object. Currently only Series8000 is supported
        :param pulumi.Input[str] manager_name: The manager name
        :param pulumi.Input[str] resource_group_name: The resource group name
        :param pulumi.Input['SslStatus'] ssl_status: Signifies whether SSL needs to be enabled or not.
        :param pulumi.Input[str] storage_account_credential_name: The storage account credential name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageAccountCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The storage account credential.
        API Version: 2017-06-01.

        :param str resource_name: The name of the resource.
        :param StorageAccountCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageAccountCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[pulumi.InputType['AsymmetricEncryptedSecretArgs']]] = None,
                 end_point: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input['Kind']] = None,
                 manager_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 ssl_status: Optional[pulumi.Input['SslStatus']] = None,
                 storage_account_credential_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageAccountCredentialArgs.__new__(StorageAccountCredentialArgs)

            __props__.__dict__["access_key"] = access_key
            if end_point is None and not opts.urn:
                raise TypeError("Missing required property 'end_point'")
            __props__.__dict__["end_point"] = end_point
            __props__.__dict__["kind"] = kind
            if manager_name is None and not opts.urn:
                raise TypeError("Missing required property 'manager_name'")
            __props__.__dict__["manager_name"] = manager_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if ssl_status is None and not opts.urn:
                raise TypeError("Missing required property 'ssl_status'")
            __props__.__dict__["ssl_status"] = ssl_status
            __props__.__dict__["storage_account_credential_name"] = storage_account_credential_name
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["volumes_count"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:storsimple/v20161001:StorageAccountCredential"), pulumi.Alias(type_="azure-native:storsimple/v20170601:StorageAccountCredential")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(StorageAccountCredential, __self__).__init__(
            'azure-native:storsimple:StorageAccountCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StorageAccountCredential':
        """
        Get an existing StorageAccountCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StorageAccountCredentialArgs.__new__(StorageAccountCredentialArgs)

        __props__.__dict__["access_key"] = None
        __props__.__dict__["end_point"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["ssl_status"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["volumes_count"] = None
        return StorageAccountCredential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional['outputs.AsymmetricEncryptedSecretResponse']]:
        """
        The details of the storage account password.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> pulumi.Output[str]:
        """
        The storage endpoint
        """
        return pulumi.get(self, "end_point")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[str]]:
        """
        The Kind of the object. Currently only Series8000 is supported
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sslStatus")
    def ssl_status(self) -> pulumi.Output[str]:
        """
        Signifies whether SSL needs to be enabled or not.
        """
        return pulumi.get(self, "ssl_status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The hierarchical type of the object.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumesCount")
    def volumes_count(self) -> pulumi.Output[int]:
        """
        The count of volumes using this storage account credential.
        """
        return pulumi.get(self, "volumes_count")

