# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActionsResponse',
    'ConditionResponse',
    'ConditionResponseFailingPeriods',
    'DimensionResponse',
    'HeaderFieldResponse',
    'ScheduledQueryRuleCriteriaResponse',
    'SystemDataResponse',
    'WebTestGeolocationResponse',
    'WebTestPropertiesResponseConfiguration',
    'WebTestPropertiesResponseContentValidation',
    'WebTestPropertiesResponseRequest',
    'WebTestPropertiesResponseValidationRules',
]

@pulumi.output_type
class ActionsResponse(dict):
    """
    Actions to invoke when the alert fires.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroups":
            suggest = "action_groups"
        elif key == "customProperties":
            suggest = "custom_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_groups: Optional[Sequence[str]] = None,
                 custom_properties: Optional[Mapping[str, str]] = None):
        """
        Actions to invoke when the alert fires.
        :param Sequence[str] action_groups: Action Group resource Ids to invoke when the alert fires.
        :param Mapping[str, str] custom_properties: The properties of an alert payload.
        """
        if action_groups is not None:
            pulumi.set(__self__, "action_groups", action_groups)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Optional[Sequence[str]]:
        """
        Action Group resource Ids to invoke when the alert fires.
        """
        return pulumi.get(self, "action_groups")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[Mapping[str, str]]:
        """
        The properties of an alert payload.
        """
        return pulumi.get(self, "custom_properties")


@pulumi.output_type
class ConditionResponse(dict):
    """
    A condition of the scheduled query rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failingPeriods":
            suggest = "failing_periods"
        elif key == "metricMeasureColumn":
            suggest = "metric_measure_column"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "resourceIdColumn":
            suggest = "resource_id_column"
        elif key == "timeAggregation":
            suggest = "time_aggregation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.DimensionResponse']] = None,
                 failing_periods: Optional['outputs.ConditionResponseFailingPeriods'] = None,
                 metric_measure_column: Optional[str] = None,
                 metric_name: Optional[str] = None,
                 operator: Optional[str] = None,
                 query: Optional[str] = None,
                 resource_id_column: Optional[str] = None,
                 threshold: Optional[float] = None,
                 time_aggregation: Optional[str] = None):
        """
        A condition of the scheduled query rule.
        :param Sequence['DimensionResponse'] dimensions: List of Dimensions conditions
        :param 'ConditionResponseFailingPeriods' failing_periods: The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
        :param str metric_measure_column: The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
        :param str metric_name: The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
        :param str operator: The criteria operator. Relevant and required only for rules of the kind LogAlert.
        :param str query: Log query alert
        :param str resource_id_column: The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
        :param float threshold: the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
        :param str time_aggregation: Aggregation type. Relevant and required only for rules of the kind LogAlert.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if failing_periods is not None:
            pulumi.set(__self__, "failing_periods", failing_periods)
        if metric_measure_column is not None:
            pulumi.set(__self__, "metric_measure_column", metric_measure_column)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if resource_id_column is not None:
            pulumi.set(__self__, "resource_id_column", resource_id_column)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if time_aggregation is not None:
            pulumi.set(__self__, "time_aggregation", time_aggregation)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.DimensionResponse']]:
        """
        List of Dimensions conditions
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="failingPeriods")
    def failing_periods(self) -> Optional['outputs.ConditionResponseFailingPeriods']:
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
        """
        return pulumi.get(self, "failing_periods")

    @property
    @pulumi.getter(name="metricMeasureColumn")
    def metric_measure_column(self) -> Optional[str]:
        """
        The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
        """
        return pulumi.get(self, "metric_measure_column")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The criteria operator. Relevant and required only for rules of the kind LogAlert.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        Log query alert
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="resourceIdColumn")
    def resource_id_column(self) -> Optional[str]:
        """
        The column containing the resource id. The content of the column must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
        """
        return pulumi.get(self, "resource_id_column")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        the criteria threshold value that activates the alert. Relevant and required only for rules of the kind LogAlert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> Optional[str]:
        """
        Aggregation type. Relevant and required only for rules of the kind LogAlert.
        """
        return pulumi.get(self, "time_aggregation")


@pulumi.output_type
class ConditionResponseFailingPeriods(dict):
    """
    The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minFailingPeriodsToAlert":
            suggest = "min_failing_periods_to_alert"
        elif key == "numberOfEvaluationPeriods":
            suggest = "number_of_evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConditionResponseFailingPeriods. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConditionResponseFailingPeriods.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConditionResponseFailingPeriods.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_failing_periods_to_alert: Optional[float] = None,
                 number_of_evaluation_periods: Optional[float] = None):
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
        :param float min_failing_periods_to_alert: The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is 1
        :param float number_of_evaluation_periods: The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points. Default value is 1
        """
        if min_failing_periods_to_alert is None:
            min_failing_periods_to_alert = 1
        if min_failing_periods_to_alert is not None:
            pulumi.set(__self__, "min_failing_periods_to_alert", min_failing_periods_to_alert)
        if number_of_evaluation_periods is None:
            number_of_evaluation_periods = 1
        if number_of_evaluation_periods is not None:
            pulumi.set(__self__, "number_of_evaluation_periods", number_of_evaluation_periods)

    @property
    @pulumi.getter(name="minFailingPeriodsToAlert")
    def min_failing_periods_to_alert(self) -> Optional[float]:
        """
        The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default value is 1
        """
        return pulumi.get(self, "min_failing_periods_to_alert")

    @property
    @pulumi.getter(name="numberOfEvaluationPeriods")
    def number_of_evaluation_periods(self) -> Optional[float]:
        """
        The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points. Default value is 1
        """
        return pulumi.get(self, "number_of_evaluation_periods")


@pulumi.output_type
class DimensionResponse(dict):
    """
    Dimension splitting and filtering definition
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        Dimension splitting and filtering definition
        :param str name: Name of the dimension
        :param str operator: Operator for dimension values
        :param Sequence[str] values: List of dimension values
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the dimension
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Operator for dimension values
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of dimension values
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class HeaderFieldResponse(dict):
    """
    A header to add to the WebTest.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerFieldName":
            suggest = "header_field_name"
        elif key == "headerFieldValue":
            suggest = "header_field_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeaderFieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeaderFieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeaderFieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_field_name: Optional[str] = None,
                 header_field_value: Optional[str] = None):
        """
        A header to add to the WebTest.
        :param str header_field_name: The name of the header.
        :param str header_field_value: The value of the header.
        """
        if header_field_name is not None:
            pulumi.set(__self__, "header_field_name", header_field_name)
        if header_field_value is not None:
            pulumi.set(__self__, "header_field_value", header_field_value)

    @property
    @pulumi.getter(name="headerFieldName")
    def header_field_name(self) -> Optional[str]:
        """
        The name of the header.
        """
        return pulumi.get(self, "header_field_name")

    @property
    @pulumi.getter(name="headerFieldValue")
    def header_field_value(self) -> Optional[str]:
        """
        The value of the header.
        """
        return pulumi.get(self, "header_field_value")


@pulumi.output_type
class ScheduledQueryRuleCriteriaResponse(dict):
    """
    The rule criteria that defines the conditions of the scheduled query rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allOf":
            suggest = "all_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryRuleCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryRuleCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryRuleCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_of: Optional[Sequence['outputs.ConditionResponse']] = None):
        """
        The rule criteria that defines the conditions of the scheduled query rule.
        :param Sequence['ConditionResponse'] all_of: A list of conditions to evaluate against the specified scopes
        """
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence['outputs.ConditionResponse']]:
        """
        A list of conditions to evaluate against the specified scopes
        """
        return pulumi.get(self, "all_of")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class WebTestGeolocationResponse(dict):
    """
    Geo-physical location to run a WebTest from. You must specify one or more locations for the test to run from.
    """
    def __init__(__self__, *,
                 location: Optional[str] = None):
        """
        Geo-physical location to run a WebTest from. You must specify one or more locations for the test to run from.
        :param str location: Location ID for the WebTest to run from.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location ID for the WebTest to run from.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class WebTestPropertiesResponseConfiguration(dict):
    """
    An XML configuration specification for a WebTest.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webTest":
            suggest = "web_test"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebTestPropertiesResponseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebTestPropertiesResponseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebTestPropertiesResponseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 web_test: Optional[str] = None):
        """
        An XML configuration specification for a WebTest.
        :param str web_test: The XML specification of a WebTest to run against an application.
        """
        if web_test is not None:
            pulumi.set(__self__, "web_test", web_test)

    @property
    @pulumi.getter(name="webTest")
    def web_test(self) -> Optional[str]:
        """
        The XML specification of a WebTest to run against an application.
        """
        return pulumi.get(self, "web_test")


@pulumi.output_type
class WebTestPropertiesResponseContentValidation(dict):
    """
    The collection of content validation properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentMatch":
            suggest = "content_match"
        elif key == "ignoreCase":
            suggest = "ignore_case"
        elif key == "passIfTextFound":
            suggest = "pass_if_text_found"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebTestPropertiesResponseContentValidation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebTestPropertiesResponseContentValidation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebTestPropertiesResponseContentValidation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_match: Optional[str] = None,
                 ignore_case: Optional[bool] = None,
                 pass_if_text_found: Optional[bool] = None):
        """
        The collection of content validation properties
        :param str content_match: Content to look for in the return of the WebTest.  Must not be null or empty.
        :param bool ignore_case: When set, this value makes the ContentMatch validation case insensitive.
        :param bool pass_if_text_found: When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
        """
        if content_match is not None:
            pulumi.set(__self__, "content_match", content_match)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if pass_if_text_found is not None:
            pulumi.set(__self__, "pass_if_text_found", pass_if_text_found)

    @property
    @pulumi.getter(name="contentMatch")
    def content_match(self) -> Optional[str]:
        """
        Content to look for in the return of the WebTest.  Must not be null or empty.
        """
        return pulumi.get(self, "content_match")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[bool]:
        """
        When set, this value makes the ContentMatch validation case insensitive.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter(name="passIfTextFound")
    def pass_if_text_found(self) -> Optional[bool]:
        """
        When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
        """
        return pulumi.get(self, "pass_if_text_found")


@pulumi.output_type
class WebTestPropertiesResponseRequest(dict):
    """
    The collection of request properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followRedirects":
            suggest = "follow_redirects"
        elif key == "httpVerb":
            suggest = "http_verb"
        elif key == "parseDependentRequests":
            suggest = "parse_dependent_requests"
        elif key == "requestBody":
            suggest = "request_body"
        elif key == "requestUrl":
            suggest = "request_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebTestPropertiesResponseRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebTestPropertiesResponseRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebTestPropertiesResponseRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 follow_redirects: Optional[bool] = None,
                 headers: Optional[Sequence['outputs.HeaderFieldResponse']] = None,
                 http_verb: Optional[str] = None,
                 parse_dependent_requests: Optional[bool] = None,
                 request_body: Optional[str] = None,
                 request_url: Optional[str] = None):
        """
        The collection of request properties
        :param bool follow_redirects: Follow redirects for this web test.
        :param Sequence['HeaderFieldResponse'] headers: List of headers and their values to add to the WebTest call.
        :param str http_verb: Http verb to use for this web test.
        :param bool parse_dependent_requests: Parse Dependent request for this WebTest.
        :param str request_body: Base64 encoded string body to send with this web test.
        :param str request_url: Url location to test.
        """
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_verb is not None:
            pulumi.set(__self__, "http_verb", http_verb)
        if parse_dependent_requests is not None:
            pulumi.set(__self__, "parse_dependent_requests", parse_dependent_requests)
        if request_body is not None:
            pulumi.set(__self__, "request_body", request_body)
        if request_url is not None:
            pulumi.set(__self__, "request_url", request_url)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[bool]:
        """
        Follow redirects for this web test.
        """
        return pulumi.get(self, "follow_redirects")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.HeaderFieldResponse']]:
        """
        List of headers and their values to add to the WebTest call.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpVerb")
    def http_verb(self) -> Optional[str]:
        """
        Http verb to use for this web test.
        """
        return pulumi.get(self, "http_verb")

    @property
    @pulumi.getter(name="parseDependentRequests")
    def parse_dependent_requests(self) -> Optional[bool]:
        """
        Parse Dependent request for this WebTest.
        """
        return pulumi.get(self, "parse_dependent_requests")

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[str]:
        """
        Base64 encoded string body to send with this web test.
        """
        return pulumi.get(self, "request_body")

    @property
    @pulumi.getter(name="requestUrl")
    def request_url(self) -> Optional[str]:
        """
        Url location to test.
        """
        return pulumi.get(self, "request_url")


@pulumi.output_type
class WebTestPropertiesResponseValidationRules(dict):
    """
    The collection of validation rule properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentValidation":
            suggest = "content_validation"
        elif key == "expectedHttpStatusCode":
            suggest = "expected_http_status_code"
        elif key == "ignoreHttpsStatusCode":
            suggest = "ignore_https_status_code"
        elif key == "sSLCertRemainingLifetimeCheck":
            suggest = "s_sl_cert_remaining_lifetime_check"
        elif key == "sSLCheck":
            suggest = "s_sl_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebTestPropertiesResponseValidationRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebTestPropertiesResponseValidationRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebTestPropertiesResponseValidationRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_validation: Optional['outputs.WebTestPropertiesResponseContentValidation'] = None,
                 expected_http_status_code: Optional[int] = None,
                 ignore_https_status_code: Optional[bool] = None,
                 s_sl_cert_remaining_lifetime_check: Optional[int] = None,
                 s_sl_check: Optional[bool] = None):
        """
        The collection of validation rule properties
        :param 'WebTestPropertiesResponseContentValidation' content_validation: The collection of content validation properties
        :param int expected_http_status_code: Validate that the WebTest returns the http status code provided.
        :param bool ignore_https_status_code: When set, validation will ignore the status code.
        :param int s_sl_cert_remaining_lifetime_check: A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
        :param bool s_sl_check: Checks to see if the SSL cert is still valid.
        """
        if content_validation is not None:
            pulumi.set(__self__, "content_validation", content_validation)
        if expected_http_status_code is not None:
            pulumi.set(__self__, "expected_http_status_code", expected_http_status_code)
        if ignore_https_status_code is not None:
            pulumi.set(__self__, "ignore_https_status_code", ignore_https_status_code)
        if s_sl_cert_remaining_lifetime_check is not None:
            pulumi.set(__self__, "s_sl_cert_remaining_lifetime_check", s_sl_cert_remaining_lifetime_check)
        if s_sl_check is not None:
            pulumi.set(__self__, "s_sl_check", s_sl_check)

    @property
    @pulumi.getter(name="contentValidation")
    def content_validation(self) -> Optional['outputs.WebTestPropertiesResponseContentValidation']:
        """
        The collection of content validation properties
        """
        return pulumi.get(self, "content_validation")

    @property
    @pulumi.getter(name="expectedHttpStatusCode")
    def expected_http_status_code(self) -> Optional[int]:
        """
        Validate that the WebTest returns the http status code provided.
        """
        return pulumi.get(self, "expected_http_status_code")

    @property
    @pulumi.getter(name="ignoreHttpsStatusCode")
    def ignore_https_status_code(self) -> Optional[bool]:
        """
        When set, validation will ignore the status code.
        """
        return pulumi.get(self, "ignore_https_status_code")

    @property
    @pulumi.getter(name="sSLCertRemainingLifetimeCheck")
    def s_sl_cert_remaining_lifetime_check(self) -> Optional[int]:
        """
        A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
        """
        return pulumi.get(self, "s_sl_cert_remaining_lifetime_check")

    @property
    @pulumi.getter(name="sSLCheck")
    def s_sl_check(self) -> Optional[bool]:
        """
        Checks to see if the SSL cert is still valid.
        """
        return pulumi.get(self, "s_sl_check")


