# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActivityEntityQueriesPropertiesResponseQueryDefinitions',
    'AlertDetailsOverrideResponse',
    'AlertsDataTypeOfDataConnectorResponse',
    'AvailabilityResponse',
    'AwsCloudTrailDataConnectorDataTypesResponse',
    'AwsCloudTrailDataConnectorDataTypesResponseLogs',
    'ClientInfoResponse',
    'CodelessUiConnectorConfigPropertiesResponse',
    'CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria',
    'CodelessUiConnectorConfigPropertiesResponseDataTypes',
    'CodelessUiConnectorConfigPropertiesResponseGraphQueries',
    'CodelessUiConnectorConfigPropertiesResponseInstructionSteps',
    'CodelessUiConnectorConfigPropertiesResponseSampleQueries',
    'ContentPathMapResponse',
    'DataConnectorDataTypeCommonResponse',
    'Dynamics365DataConnectorDataTypesResponse',
    'Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities',
    'EntityMappingResponse',
    'EventGroupingSettingsResponse',
    'FieldMappingResponse',
    'GroupingConfigurationResponse',
    'IncidentAdditionalDataResponse',
    'IncidentConfigurationResponse',
    'IncidentLabelResponse',
    'IncidentOwnerInfoResponse',
    'InstructionStepsResponseInstructions',
    'MCASDataConnectorDataTypesResponse',
    'MSTIDataConnectorDataTypesResponse',
    'MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL',
    'MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed',
    'MTPDataConnectorDataTypesResponse',
    'MTPDataConnectorDataTypesResponseIncidents',
    'MetadataAuthorResponse',
    'MetadataCategoriesResponse',
    'MetadataDependenciesResponse',
    'MetadataSourceResponse',
    'MetadataSupportResponse',
    'OfficeDataConnectorDataTypesResponse',
    'OfficeDataConnectorDataTypesResponseExchange',
    'OfficeDataConnectorDataTypesResponseSharePoint',
    'OfficeDataConnectorDataTypesResponseTeams',
    'PermissionsResponse',
    'PermissionsResponseCustoms',
    'PermissionsResponseResourceProvider',
    'RepoResponse',
    'RepositoryResponse',
    'RequiredPermissionsResponse',
    'SystemDataResponse',
    'TIDataConnectorDataTypesResponse',
    'TIDataConnectorDataTypesResponseIndicators',
    'TeamInformationResponse',
    'TiTaxiiDataConnectorDataTypesResponse',
    'TiTaxiiDataConnectorDataTypesResponseTaxiiClient',
    'WatchlistUserInfoResponse',
]

@pulumi.output_type
class ActivityEntityQueriesPropertiesResponseQueryDefinitions(dict):
    """
    The Activity query definitions
    """
    def __init__(__self__, *,
                 query: Optional[str] = None):
        """
        The Activity query definitions
        :param str query: The Activity query to run on a given entity
        """
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        The Activity query to run on a given entity
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class AlertDetailsOverrideResponse(dict):
    """
    Settings for how to dynamically override alert static details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertDescriptionFormat":
            suggest = "alert_description_format"
        elif key == "alertDisplayNameFormat":
            suggest = "alert_display_name_format"
        elif key == "alertSeverityColumnName":
            suggest = "alert_severity_column_name"
        elif key == "alertTacticsColumnName":
            suggest = "alert_tactics_column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertDetailsOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertDetailsOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertDetailsOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_description_format: Optional[str] = None,
                 alert_display_name_format: Optional[str] = None,
                 alert_severity_column_name: Optional[str] = None,
                 alert_tactics_column_name: Optional[str] = None):
        """
        Settings for how to dynamically override alert static details
        :param str alert_description_format: the format containing columns name(s) to override the alert description
        :param str alert_display_name_format: the format containing columns name(s) to override the alert name
        :param str alert_severity_column_name: the column name to take the alert severity from
        :param str alert_tactics_column_name: the column name to take the alert tactics from
        """
        if alert_description_format is not None:
            pulumi.set(__self__, "alert_description_format", alert_description_format)
        if alert_display_name_format is not None:
            pulumi.set(__self__, "alert_display_name_format", alert_display_name_format)
        if alert_severity_column_name is not None:
            pulumi.set(__self__, "alert_severity_column_name", alert_severity_column_name)
        if alert_tactics_column_name is not None:
            pulumi.set(__self__, "alert_tactics_column_name", alert_tactics_column_name)

    @property
    @pulumi.getter(name="alertDescriptionFormat")
    def alert_description_format(self) -> Optional[str]:
        """
        the format containing columns name(s) to override the alert description
        """
        return pulumi.get(self, "alert_description_format")

    @property
    @pulumi.getter(name="alertDisplayNameFormat")
    def alert_display_name_format(self) -> Optional[str]:
        """
        the format containing columns name(s) to override the alert name
        """
        return pulumi.get(self, "alert_display_name_format")

    @property
    @pulumi.getter(name="alertSeverityColumnName")
    def alert_severity_column_name(self) -> Optional[str]:
        """
        the column name to take the alert severity from
        """
        return pulumi.get(self, "alert_severity_column_name")

    @property
    @pulumi.getter(name="alertTacticsColumnName")
    def alert_tactics_column_name(self) -> Optional[str]:
        """
        the column name to take the alert tactics from
        """
        return pulumi.get(self, "alert_tactics_column_name")


@pulumi.output_type
class AlertsDataTypeOfDataConnectorResponse(dict):
    """
    Alerts data type for data connectors.
    """
    def __init__(__self__, *,
                 alerts: 'outputs.DataConnectorDataTypeCommonResponse'):
        """
        Alerts data type for data connectors.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        """
        pulumi.set(__self__, "alerts", alerts)

    @property
    @pulumi.getter
    def alerts(self) -> 'outputs.DataConnectorDataTypeCommonResponse':
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")


@pulumi.output_type
class AvailabilityResponse(dict):
    """
    Connector Availability Status
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPreview":
            suggest = "is_preview"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AvailabilityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AvailabilityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AvailabilityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_preview: Optional[bool] = None,
                 status: Optional[int] = None):
        """
        Connector Availability Status
        :param bool is_preview: Set connector as preview
        :param int status: The connector Availability Status
        """
        if is_preview is not None:
            pulumi.set(__self__, "is_preview", is_preview)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="isPreview")
    def is_preview(self) -> Optional[bool]:
        """
        Set connector as preview
        """
        return pulumi.get(self, "is_preview")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        """
        The connector Availability Status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponse(dict):
    """
    The available data types for Amazon Web Services CloudTrail data connector.
    """
    def __init__(__self__, *,
                 logs: 'outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs'):
        """
        The available data types for Amazon Web Services CloudTrail data connector.
        :param 'AwsCloudTrailDataConnectorDataTypesResponseLogs' logs: Logs data type.
        """
        pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> 'outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs':
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponseLogs(dict):
    """
    Logs data type.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Logs data type.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ClientInfoResponse(dict):
    """
    Information on the client (user or application) that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: Optional[str] = None,
                 name: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the client (user or application) that made some action
        :param str email: The email of the client.
        :param str name: The name of the client.
        :param str object_id: The object id of the client.
        :param str user_principal_name: The user principal name of the client.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the client.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the client.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the client.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponse(dict):
    """
    Config to describe the instructions blade
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectivityCriteria":
            suggest = "connectivity_criteria"
        elif key == "dataTypes":
            suggest = "data_types"
        elif key == "descriptionMarkdown":
            suggest = "description_markdown"
        elif key == "graphQueries":
            suggest = "graph_queries"
        elif key == "graphQueriesTableName":
            suggest = "graph_queries_table_name"
        elif key == "instructionSteps":
            suggest = "instruction_steps"
        elif key == "sampleQueries":
            suggest = "sample_queries"
        elif key == "customImage":
            suggest = "custom_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessUiConnectorConfigPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessUiConnectorConfigPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessUiConnectorConfigPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability: 'outputs.AvailabilityResponse',
                 connectivity_criteria: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria'],
                 data_types: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseDataTypes'],
                 description_markdown: str,
                 graph_queries: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseGraphQueries'],
                 graph_queries_table_name: str,
                 instruction_steps: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseInstructionSteps'],
                 permissions: 'outputs.PermissionsResponse',
                 publisher: str,
                 sample_queries: Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseSampleQueries'],
                 title: str,
                 custom_image: Optional[str] = None):
        """
        Config to describe the instructions blade
        :param 'AvailabilityResponse' availability: Connector Availability Status
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria'] connectivity_criteria: Define the way the connector check connectivity
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseDataTypes'] data_types: Data types to check for last data received
        :param str description_markdown: Connector description
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseGraphQueries'] graph_queries: The graph query to show the current data status
        :param str graph_queries_table_name: Name of the table the connector will insert the data to
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseInstructionSteps'] instruction_steps: Instruction steps to enable the connector
        :param 'PermissionsResponse' permissions: Permissions required for the connector
        :param str publisher: Connector publisher name
        :param Sequence['CodelessUiConnectorConfigPropertiesResponseSampleQueries'] sample_queries: The sample queries for the connector
        :param str title: Connector blade title
        :param str custom_image: An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery
        """
        pulumi.set(__self__, "availability", availability)
        pulumi.set(__self__, "connectivity_criteria", connectivity_criteria)
        pulumi.set(__self__, "data_types", data_types)
        pulumi.set(__self__, "description_markdown", description_markdown)
        pulumi.set(__self__, "graph_queries", graph_queries)
        pulumi.set(__self__, "graph_queries_table_name", graph_queries_table_name)
        pulumi.set(__self__, "instruction_steps", instruction_steps)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sample_queries", sample_queries)
        pulumi.set(__self__, "title", title)
        if custom_image is not None:
            pulumi.set(__self__, "custom_image", custom_image)

    @property
    @pulumi.getter
    def availability(self) -> 'outputs.AvailabilityResponse':
        """
        Connector Availability Status
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter(name="connectivityCriteria")
    def connectivity_criteria(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria']:
        """
        Define the way the connector check connectivity
        """
        return pulumi.get(self, "connectivity_criteria")

    @property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseDataTypes']:
        """
        Data types to check for last data received
        """
        return pulumi.get(self, "data_types")

    @property
    @pulumi.getter(name="descriptionMarkdown")
    def description_markdown(self) -> str:
        """
        Connector description
        """
        return pulumi.get(self, "description_markdown")

    @property
    @pulumi.getter(name="graphQueries")
    def graph_queries(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseGraphQueries']:
        """
        The graph query to show the current data status
        """
        return pulumi.get(self, "graph_queries")

    @property
    @pulumi.getter(name="graphQueriesTableName")
    def graph_queries_table_name(self) -> str:
        """
        Name of the table the connector will insert the data to
        """
        return pulumi.get(self, "graph_queries_table_name")

    @property
    @pulumi.getter(name="instructionSteps")
    def instruction_steps(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseInstructionSteps']:
        """
        Instruction steps to enable the connector
        """
        return pulumi.get(self, "instruction_steps")

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.PermissionsResponse':
        """
        Permissions required for the connector
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        Connector publisher name
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter(name="sampleQueries")
    def sample_queries(self) -> Sequence['outputs.CodelessUiConnectorConfigPropertiesResponseSampleQueries']:
        """
        The sample queries for the connector
        """
        return pulumi.get(self, "sample_queries")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Connector blade title
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="customImage")
    def custom_image(self) -> Optional[str]:
        """
        An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery
        """
        return pulumi.get(self, "custom_image")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseConnectivityCriteria(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[Sequence[str]] = None):
        """
        :param str type: type of connectivity
        :param Sequence[str] value: Queries for checking connectivity
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        type of connectivity
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[Sequence[str]]:
        """
        Queries for checking connectivity
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseDataTypes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastDataReceivedQuery":
            suggest = "last_data_received_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessUiConnectorConfigPropertiesResponseDataTypes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessUiConnectorConfigPropertiesResponseDataTypes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessUiConnectorConfigPropertiesResponseDataTypes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_data_received_query: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str last_data_received_query: Query for indicate last data received
        :param str name: Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder
        """
        if last_data_received_query is not None:
            pulumi.set(__self__, "last_data_received_query", last_data_received_query)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="lastDataReceivedQuery")
    def last_data_received_query(self) -> Optional[str]:
        """
        Query for indicate last data received
        """
        return pulumi.get(self, "last_data_received_query")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseGraphQueries(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseQuery":
            suggest = "base_query"
        elif key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodelessUiConnectorConfigPropertiesResponseGraphQueries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodelessUiConnectorConfigPropertiesResponseGraphQueries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodelessUiConnectorConfigPropertiesResponseGraphQueries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_query: Optional[str] = None,
                 legend: Optional[str] = None,
                 metric_name: Optional[str] = None):
        """
        :param str base_query: The base query for the graph
        :param str legend: The legend for the graph
        :param str metric_name: the metric that the query is checking
        """
        if base_query is not None:
            pulumi.set(__self__, "base_query", base_query)
        if legend is not None:
            pulumi.set(__self__, "legend", legend)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)

    @property
    @pulumi.getter(name="baseQuery")
    def base_query(self) -> Optional[str]:
        """
        The base query for the graph
        """
        return pulumi.get(self, "base_query")

    @property
    @pulumi.getter
    def legend(self) -> Optional[str]:
        """
        The legend for the graph
        """
        return pulumi.get(self, "legend")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        the metric that the query is checking
        """
        return pulumi.get(self, "metric_name")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseInstructionSteps(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 instructions: Optional[Sequence['outputs.InstructionStepsResponseInstructions']] = None,
                 title: Optional[str] = None):
        """
        :param str description: Instruction step description
        :param Sequence['InstructionStepsResponseInstructions'] instructions: Instruction step details
        :param str title: Instruction step title
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instructions is not None:
            pulumi.set(__self__, "instructions", instructions)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Instruction step description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def instructions(self) -> Optional[Sequence['outputs.InstructionStepsResponseInstructions']]:
        """
        Instruction step details
        """
        return pulumi.get(self, "instructions")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        Instruction step title
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CodelessUiConnectorConfigPropertiesResponseSampleQueries(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 query: Optional[str] = None):
        """
        :param str description: The sample query description
        :param str query: the sample query
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The sample query description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        the sample query
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ContentPathMapResponse(dict):
    """
    The mapping of content type to a repo path.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentPathMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentPathMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentPathMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional[str] = None,
                 path: Optional[str] = None):
        """
        The mapping of content type to a repo path.
        :param str content_type: Content type.
        :param str path: The path to the content.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the content.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DataConnectorDataTypeCommonResponse(dict):
    """
    Common field for data type in data connectors.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Common field for data type in data connectors.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class Dynamics365DataConnectorDataTypesResponse(dict):
    """
    The available data types for Dynamics365 data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamics365CdsActivities":
            suggest = "dynamics365_cds_activities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Dynamics365DataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Dynamics365DataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Dynamics365DataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dynamics365_cds_activities: 'outputs.Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities'):
        """
        The available data types for Dynamics365 data connector.
        :param 'Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities' dynamics365_cds_activities: Common Data Service data type connection.
        """
        pulumi.set(__self__, "dynamics365_cds_activities", dynamics365_cds_activities)

    @property
    @pulumi.getter(name="dynamics365CdsActivities")
    def dynamics365_cds_activities(self) -> 'outputs.Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities':
        """
        Common Data Service data type connection.
        """
        return pulumi.get(self, "dynamics365_cds_activities")


@pulumi.output_type
class Dynamics365DataConnectorDataTypesResponseDynamics365CdsActivities(dict):
    """
    Common Data Service data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Common Data Service data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EntityMappingResponse(dict):
    """
    Single entity mapping for the alert rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityType":
            suggest = "entity_type"
        elif key == "fieldMappings":
            suggest = "field_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EntityMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EntityMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EntityMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_type: Optional[str] = None,
                 field_mappings: Optional[Sequence['outputs.FieldMappingResponse']] = None):
        """
        Single entity mapping for the alert rule
        :param str entity_type: The V3 type of the mapped entity
        :param Sequence['FieldMappingResponse'] field_mappings: array of field mappings for the given entity mapping
        """
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if field_mappings is not None:
            pulumi.set(__self__, "field_mappings", field_mappings)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[str]:
        """
        The V3 type of the mapped entity
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="fieldMappings")
    def field_mappings(self) -> Optional[Sequence['outputs.FieldMappingResponse']]:
        """
        array of field mappings for the given entity mapping
        """
        return pulumi.get(self, "field_mappings")


@pulumi.output_type
class EventGroupingSettingsResponse(dict):
    """
    Event grouping settings property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregationKind":
            suggest = "aggregation_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGroupingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGroupingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGroupingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation_kind: Optional[str] = None):
        """
        Event grouping settings property bag.
        :param str aggregation_kind: The event grouping aggregation kinds
        """
        if aggregation_kind is not None:
            pulumi.set(__self__, "aggregation_kind", aggregation_kind)

    @property
    @pulumi.getter(name="aggregationKind")
    def aggregation_kind(self) -> Optional[str]:
        """
        The event grouping aggregation kinds
        """
        return pulumi.get(self, "aggregation_kind")


@pulumi.output_type
class FieldMappingResponse(dict):
    """
    A single field mapping of the mapped entity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FieldMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FieldMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FieldMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_name: Optional[str] = None,
                 identifier: Optional[str] = None):
        """
        A single field mapping of the mapped entity
        :param str column_name: the column name to be mapped to the identifier
        :param str identifier: the V3 identifier of the entity
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        the column name to be mapped to the identifier
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        the V3 identifier of the entity
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class GroupingConfigurationResponse(dict):
    """
    Grouping configuration property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lookbackDuration":
            suggest = "lookback_duration"
        elif key == "matchingMethod":
            suggest = "matching_method"
        elif key == "reopenClosedIncident":
            suggest = "reopen_closed_incident"
        elif key == "groupByAlertDetails":
            suggest = "group_by_alert_details"
        elif key == "groupByCustomDetails":
            suggest = "group_by_custom_details"
        elif key == "groupByEntities":
            suggest = "group_by_entities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 lookback_duration: str,
                 matching_method: str,
                 reopen_closed_incident: bool,
                 group_by_alert_details: Optional[Sequence[str]] = None,
                 group_by_custom_details: Optional[Sequence[str]] = None,
                 group_by_entities: Optional[Sequence[str]] = None):
        """
        Grouping configuration property bag.
        :param bool enabled: Grouping enabled
        :param str lookback_duration: Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        :param str matching_method: Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        :param bool reopen_closed_incident: Re-open closed matching incidents
        :param Sequence[str] group_by_alert_details: A list of alert details to group by (when matchingMethod is Selected)
        :param Sequence[str] group_by_custom_details: A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        :param Sequence[str] group_by_entities: A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "lookback_duration", lookback_duration)
        pulumi.set(__self__, "matching_method", matching_method)
        pulumi.set(__self__, "reopen_closed_incident", reopen_closed_incident)
        if group_by_alert_details is not None:
            pulumi.set(__self__, "group_by_alert_details", group_by_alert_details)
        if group_by_custom_details is not None:
            pulumi.set(__self__, "group_by_custom_details", group_by_custom_details)
        if group_by_entities is not None:
            pulumi.set(__self__, "group_by_entities", group_by_entities)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Grouping enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="lookbackDuration")
    def lookback_duration(self) -> str:
        """
        Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        """
        return pulumi.get(self, "lookback_duration")

    @property
    @pulumi.getter(name="matchingMethod")
    def matching_method(self) -> str:
        """
        Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        """
        return pulumi.get(self, "matching_method")

    @property
    @pulumi.getter(name="reopenClosedIncident")
    def reopen_closed_incident(self) -> bool:
        """
        Re-open closed matching incidents
        """
        return pulumi.get(self, "reopen_closed_incident")

    @property
    @pulumi.getter(name="groupByAlertDetails")
    def group_by_alert_details(self) -> Optional[Sequence[str]]:
        """
        A list of alert details to group by (when matchingMethod is Selected)
        """
        return pulumi.get(self, "group_by_alert_details")

    @property
    @pulumi.getter(name="groupByCustomDetails")
    def group_by_custom_details(self) -> Optional[Sequence[str]]:
        """
        A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_custom_details")

    @property
    @pulumi.getter(name="groupByEntities")
    def group_by_entities(self) -> Optional[Sequence[str]]:
        """
        A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_entities")


@pulumi.output_type
class IncidentAdditionalDataResponse(dict):
    """
    Incident additional data property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertProductNames":
            suggest = "alert_product_names"
        elif key == "alertsCount":
            suggest = "alerts_count"
        elif key == "bookmarksCount":
            suggest = "bookmarks_count"
        elif key == "commentsCount":
            suggest = "comments_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentAdditionalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_product_names: Sequence[str],
                 alerts_count: int,
                 bookmarks_count: int,
                 comments_count: int,
                 tactics: Sequence[str]):
        """
        Incident additional data property bag.
        :param Sequence[str] alert_product_names: List of product names of alerts in the incident
        :param int alerts_count: The number of alerts in the incident
        :param int bookmarks_count: The number of bookmarks in the incident
        :param int comments_count: The number of comments in the incident
        :param Sequence[str] tactics: The tactics associated with incident
        """
        pulumi.set(__self__, "alert_product_names", alert_product_names)
        pulumi.set(__self__, "alerts_count", alerts_count)
        pulumi.set(__self__, "bookmarks_count", bookmarks_count)
        pulumi.set(__self__, "comments_count", comments_count)
        pulumi.set(__self__, "tactics", tactics)

    @property
    @pulumi.getter(name="alertProductNames")
    def alert_product_names(self) -> Sequence[str]:
        """
        List of product names of alerts in the incident
        """
        return pulumi.get(self, "alert_product_names")

    @property
    @pulumi.getter(name="alertsCount")
    def alerts_count(self) -> int:
        """
        The number of alerts in the incident
        """
        return pulumi.get(self, "alerts_count")

    @property
    @pulumi.getter(name="bookmarksCount")
    def bookmarks_count(self) -> int:
        """
        The number of bookmarks in the incident
        """
        return pulumi.get(self, "bookmarks_count")

    @property
    @pulumi.getter(name="commentsCount")
    def comments_count(self) -> int:
        """
        The number of comments in the incident
        """
        return pulumi.get(self, "comments_count")

    @property
    @pulumi.getter
    def tactics(self) -> Sequence[str]:
        """
        The tactics associated with incident
        """
        return pulumi.get(self, "tactics")


@pulumi.output_type
class IncidentConfigurationResponse(dict):
    """
    Incident Configuration property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createIncident":
            suggest = "create_incident"
        elif key == "groupingConfiguration":
            suggest = "grouping_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_incident: bool,
                 grouping_configuration: Optional['outputs.GroupingConfigurationResponse'] = None):
        """
        Incident Configuration property bag.
        :param bool create_incident: Create incidents from alerts triggered by this analytics rule
        :param 'GroupingConfigurationResponse' grouping_configuration: Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        pulumi.set(__self__, "create_incident", create_incident)
        if grouping_configuration is not None:
            pulumi.set(__self__, "grouping_configuration", grouping_configuration)

    @property
    @pulumi.getter(name="createIncident")
    def create_incident(self) -> bool:
        """
        Create incidents from alerts triggered by this analytics rule
        """
        return pulumi.get(self, "create_incident")

    @property
    @pulumi.getter(name="groupingConfiguration")
    def grouping_configuration(self) -> Optional['outputs.GroupingConfigurationResponse']:
        """
        Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        return pulumi.get(self, "grouping_configuration")


@pulumi.output_type
class IncidentLabelResponse(dict):
    """
    Represents an incident label
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelName":
            suggest = "label_name"
        elif key == "labelType":
            suggest = "label_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentLabelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_name: str,
                 label_type: str):
        """
        Represents an incident label
        :param str label_name: The name of the label
        :param str label_type: The type of the label
        """
        pulumi.set(__self__, "label_name", label_name)
        pulumi.set(__self__, "label_type", label_type)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> str:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @property
    @pulumi.getter(name="labelType")
    def label_type(self) -> str:
        """
        The type of the label
        """
        return pulumi.get(self, "label_type")


@pulumi.output_type
class IncidentOwnerInfoResponse(dict):
    """
    Information on the user an incident is assigned to
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerType":
            suggest = "owner_type"
        elif key == "assignedTo":
            suggest = "assigned_to"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentOwnerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_type: str,
                 assigned_to: Optional[str] = None,
                 email: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the user an incident is assigned to
        :param str owner_type: The type of the owner the incident is assigned to.
        :param str assigned_to: The name of the user the incident is assigned to.
        :param str email: The email of the user the incident is assigned to.
        :param str object_id: The object id of the user the incident is assigned to.
        :param str user_principal_name: The user principal name of the user the incident is assigned to.
        """
        pulumi.set(__self__, "owner_type", owner_type)
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="ownerType")
    def owner_type(self) -> str:
        """
        The type of the owner the incident is assigned to.
        """
        return pulumi.get(self, "owner_type")

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[str]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class InstructionStepsResponseInstructions(dict):
    def __init__(__self__, *,
                 type: str,
                 parameters: Optional[Any] = None):
        """
        :param str type: The kind of the setting
        :param Any parameters: The parameters for the setting
        """
        pulumi.set(__self__, "type", type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The kind of the setting
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        The parameters for the setting
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class MCASDataConnectorDataTypesResponse(dict):
    """
    The available data types for MCAS (Microsoft Cloud App Security) data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discoveryLogs":
            suggest = "discovery_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MCASDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts: 'outputs.DataConnectorDataTypeCommonResponse',
                 discovery_logs: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None):
        """
        The available data types for MCAS (Microsoft Cloud App Security) data connector.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        :param 'DataConnectorDataTypeCommonResponse' discovery_logs: Discovery log data type connection.
        """
        pulumi.set(__self__, "alerts", alerts)
        if discovery_logs is not None:
            pulumi.set(__self__, "discovery_logs", discovery_logs)

    @property
    @pulumi.getter
    def alerts(self) -> 'outputs.DataConnectorDataTypeCommonResponse':
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="discoveryLogs")
    def discovery_logs(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Discovery log data type connection.
        """
        return pulumi.get(self, "discovery_logs")


@pulumi.output_type
class MSTIDataConnectorDataTypesResponse(dict):
    """
    The available data types for Microsoft Threat Intelligence Platforms data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bingSafetyPhishingURL":
            suggest = "bing_safety_phishing_url"
        elif key == "microsoftEmergingThreatFeed":
            suggest = "microsoft_emerging_threat_feed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MSTIDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MSTIDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MSTIDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bing_safety_phishing_url: 'outputs.MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL',
                 microsoft_emerging_threat_feed: 'outputs.MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed'):
        """
        The available data types for Microsoft Threat Intelligence Platforms data connector.
        :param 'MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL' bing_safety_phishing_url: Data type for Microsoft Threat Intelligence Platforms data connector.
        :param 'MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed' microsoft_emerging_threat_feed: Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        pulumi.set(__self__, "bing_safety_phishing_url", bing_safety_phishing_url)
        pulumi.set(__self__, "microsoft_emerging_threat_feed", microsoft_emerging_threat_feed)

    @property
    @pulumi.getter(name="bingSafetyPhishingURL")
    def bing_safety_phishing_url(self) -> 'outputs.MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL':
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        return pulumi.get(self, "bing_safety_phishing_url")

    @property
    @pulumi.getter(name="microsoftEmergingThreatFeed")
    def microsoft_emerging_threat_feed(self) -> 'outputs.MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed':
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        """
        return pulumi.get(self, "microsoft_emerging_threat_feed")


@pulumi.output_type
class MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL(dict):
    """
    Data type for Microsoft Threat Intelligence Platforms data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lookbackPeriod":
            suggest = "lookback_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MSTIDataConnectorDataTypesResponseBingSafetyPhishingURL.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lookback_period: str,
                 state: str):
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        :param str lookback_period: lookback period
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "lookback_period", lookback_period)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> str:
        """
        lookback period
        """
        return pulumi.get(self, "lookback_period")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed(dict):
    """
    Data type for Microsoft Threat Intelligence Platforms data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lookbackPeriod":
            suggest = "lookback_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MSTIDataConnectorDataTypesResponseMicrosoftEmergingThreatFeed.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lookback_period: str,
                 state: str):
        """
        Data type for Microsoft Threat Intelligence Platforms data connector.
        :param str lookback_period: lookback period
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "lookback_period", lookback_period)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> str:
        """
        lookback period
        """
        return pulumi.get(self, "lookback_period")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MTPDataConnectorDataTypesResponse(dict):
    """
    The available data types for Microsoft Threat Protection Platforms data connector.
    """
    def __init__(__self__, *,
                 incidents: 'outputs.MTPDataConnectorDataTypesResponseIncidents'):
        """
        The available data types for Microsoft Threat Protection Platforms data connector.
        :param 'MTPDataConnectorDataTypesResponseIncidents' incidents: Data type for Microsoft Threat Protection Platforms data connector.
        """
        pulumi.set(__self__, "incidents", incidents)

    @property
    @pulumi.getter
    def incidents(self) -> 'outputs.MTPDataConnectorDataTypesResponseIncidents':
        """
        Data type for Microsoft Threat Protection Platforms data connector.
        """
        return pulumi.get(self, "incidents")


@pulumi.output_type
class MTPDataConnectorDataTypesResponseIncidents(dict):
    """
    Data type for Microsoft Threat Protection Platforms data connector.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Data type for Microsoft Threat Protection Platforms data connector.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MetadataAuthorResponse(dict):
    """
    Publisher or creator of the content item.
    """
    def __init__(__self__, *,
                 email: Optional[str] = None,
                 link: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Publisher or creator of the content item.
        :param str email: Email of author contact
        :param str link: Link for author/vendor page
        :param str name: Name of the author. Company or person.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of author contact
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link for author/vendor page
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the author. Company or person.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MetadataCategoriesResponse(dict):
    """
    ies for the solution content item
    """
    def __init__(__self__, *,
                 domains: Optional[Sequence[str]] = None,
                 verticals: Optional[Sequence[str]] = None):
        """
        ies for the solution content item
        :param Sequence[str] domains: domain for the solution content item
        :param Sequence[str] verticals: Industry verticals for the solution content item
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if verticals is not None:
            pulumi.set(__self__, "verticals", verticals)

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[str]]:
        """
        domain for the solution content item
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def verticals(self) -> Optional[Sequence[str]]:
        """
        Industry verticals for the solution content item
        """
        return pulumi.get(self, "verticals")


@pulumi.output_type
class MetadataDependenciesResponse(dict):
    """
    Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentId":
            suggest = "content_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataDependenciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataDependenciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataDependenciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_id: Optional[str] = None,
                 criteria: Optional[Sequence['outputs.MetadataDependenciesResponse']] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 operator: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
        :param str content_id: Id of the content item we depend on
        :param Sequence['MetadataDependenciesResponse'] criteria: This is the list of dependencies we must fulfill, according to the AND/OR operator
        :param str kind: Type of the content item we depend on
        :param str name: Name of the content item
        :param str operator: Operator used for list of dependencies in criteria array.
        :param str version: Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        if content_id is not None:
            pulumi.set(__self__, "content_id", content_id)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> Optional[str]:
        """
        Id of the content item we depend on
        """
        return pulumi.get(self, "content_id")

    @property
    @pulumi.getter
    def criteria(self) -> Optional[Sequence['outputs.MetadataDependenciesResponse']]:
        """
        This is the list of dependencies we must fulfill, according to the AND/OR operator
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Type of the content item we depend on
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the content item
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        Operator used for list of dependencies in criteria array.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MetadataSourceResponse(dict):
    """
    The original source of the content item, where it comes from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceId":
            suggest = "source_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: Optional[str] = None,
                 source_id: Optional[str] = None):
        """
        The original source of the content item, where it comes from.
        :param str kind: Source type of the content
        :param str name: Name of the content source.  The repo name, solution name, LA workspace name etc.
        :param str source_id: ID of the content source.  The solution ID, workspace ID, etc
        """
        pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Source type of the content
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the content source.  The repo name, solution name, LA workspace name etc.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[str]:
        """
        ID of the content source.  The solution ID, workspace ID, etc
        """
        return pulumi.get(self, "source_id")


@pulumi.output_type
class MetadataSupportResponse(dict):
    """
    Support information for the content item.
    """
    def __init__(__self__, *,
                 tier: str,
                 email: Optional[str] = None,
                 link: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Support information for the content item.
        :param str tier: Type of support for content item
        :param str email: Email of support contact
        :param str link: Link for support help, like to support page to open a ticket etc.
        :param str name: Name of the support contact. Company or person.
        """
        pulumi.set(__self__, "tier", tier)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Type of support for content item
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of support contact
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link for support help, like to support page to open a ticket etc.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the support contact. Company or person.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponse(dict):
    """
    The available data types for office data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharePoint":
            suggest = "share_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfficeDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exchange: 'outputs.OfficeDataConnectorDataTypesResponseExchange',
                 share_point: 'outputs.OfficeDataConnectorDataTypesResponseSharePoint',
                 teams: 'outputs.OfficeDataConnectorDataTypesResponseTeams'):
        """
        The available data types for office data connector.
        :param 'OfficeDataConnectorDataTypesResponseExchange' exchange: Exchange data type connection.
        :param 'OfficeDataConnectorDataTypesResponseSharePoint' share_point: SharePoint data type connection.
        :param 'OfficeDataConnectorDataTypesResponseTeams' teams: Teams data type connection.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "share_point", share_point)
        pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def exchange(self) -> 'outputs.OfficeDataConnectorDataTypesResponseExchange':
        """
        Exchange data type connection.
        """
        return pulumi.get(self, "exchange")

    @property
    @pulumi.getter(name="sharePoint")
    def share_point(self) -> 'outputs.OfficeDataConnectorDataTypesResponseSharePoint':
        """
        SharePoint data type connection.
        """
        return pulumi.get(self, "share_point")

    @property
    @pulumi.getter
    def teams(self) -> 'outputs.OfficeDataConnectorDataTypesResponseTeams':
        """
        Teams data type connection.
        """
        return pulumi.get(self, "teams")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseExchange(dict):
    """
    Exchange data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Exchange data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseSharePoint(dict):
    """
    SharePoint data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        SharePoint data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseTeams(dict):
    """
    Teams data type connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Teams data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PermissionsResponse(dict):
    """
    Permissions required for the connector
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceProvider":
            suggest = "resource_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customs: Optional[Sequence['outputs.PermissionsResponseCustoms']] = None,
                 resource_provider: Optional[Sequence['outputs.PermissionsResponseResourceProvider']] = None):
        """
        Permissions required for the connector
        :param Sequence['PermissionsResponseCustoms'] customs: Customs permissions required for the connector
        :param Sequence['PermissionsResponseResourceProvider'] resource_provider: Resource provider permissions required for the connector
        """
        if customs is not None:
            pulumi.set(__self__, "customs", customs)
        if resource_provider is not None:
            pulumi.set(__self__, "resource_provider", resource_provider)

    @property
    @pulumi.getter
    def customs(self) -> Optional[Sequence['outputs.PermissionsResponseCustoms']]:
        """
        Customs permissions required for the connector
        """
        return pulumi.get(self, "customs")

    @property
    @pulumi.getter(name="resourceProvider")
    def resource_provider(self) -> Optional[Sequence['outputs.PermissionsResponseResourceProvider']]:
        """
        Resource provider permissions required for the connector
        """
        return pulumi.get(self, "resource_provider")


@pulumi.output_type
class PermissionsResponseCustoms(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str description: Customs permissions description
        :param str name: Customs permissions name
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Customs permissions description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Customs permissions name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PermissionsResponseResourceProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionsDisplayText":
            suggest = "permissions_display_text"
        elif key == "providerDisplayName":
            suggest = "provider_display_name"
        elif key == "requiredPermissions":
            suggest = "required_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsResponseResourceProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsResponseResourceProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsResponseResourceProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permissions_display_text: Optional[str] = None,
                 provider: Optional[str] = None,
                 provider_display_name: Optional[str] = None,
                 required_permissions: Optional['outputs.RequiredPermissionsResponse'] = None,
                 scope: Optional[str] = None):
        """
        :param str permissions_display_text: Permission description text
        :param str provider: Provider name
        :param str provider_display_name: Permission provider display name
        :param 'RequiredPermissionsResponse' required_permissions: Required permissions for the connector
        :param str scope: Permission provider scope
        """
        if permissions_display_text is not None:
            pulumi.set(__self__, "permissions_display_text", permissions_display_text)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if provider_display_name is not None:
            pulumi.set(__self__, "provider_display_name", provider_display_name)
        if required_permissions is not None:
            pulumi.set(__self__, "required_permissions", required_permissions)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="permissionsDisplayText")
    def permissions_display_text(self) -> Optional[str]:
        """
        Permission description text
        """
        return pulumi.get(self, "permissions_display_text")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Provider name
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="providerDisplayName")
    def provider_display_name(self) -> Optional[str]:
        """
        Permission provider display name
        """
        return pulumi.get(self, "provider_display_name")

    @property
    @pulumi.getter(name="requiredPermissions")
    def required_permissions(self) -> Optional['outputs.RequiredPermissionsResponse']:
        """
        Required permissions for the connector
        """
        return pulumi.get(self, "required_permissions")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        Permission provider scope
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class RepoResponse(dict):
    """
    Represents a repository.
    """
    def __init__(__self__, *,
                 branches: Optional[Sequence[str]] = None,
                 full_name: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Represents a repository.
        :param Sequence[str] branches: Array of branches.
        :param str full_name: The name of the repository.
        :param str url: The url to access the repository.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def branches(self) -> Optional[Sequence[str]]:
        """
        Array of branches.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The url to access the repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RepositoryResponse(dict):
    """
    metadata of a repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentLogsUrl":
            suggest = "deployment_logs_url"
        elif key == "displayUrl":
            suggest = "display_url"
        elif key == "pathMapping":
            suggest = "path_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deployment_logs_url: Optional[str] = None,
                 display_url: Optional[str] = None,
                 path_mapping: Optional[Sequence['outputs.ContentPathMapResponse']] = None,
                 url: Optional[str] = None):
        """
        metadata of a repository.
        :param str branch: Branch name of repository.
        :param str deployment_logs_url: Url to access repository action logs.
        :param str display_url: Display url of repository.
        :param Sequence['ContentPathMapResponse'] path_mapping: Dictionary of source control content type and path mapping.
        :param str url: Url of repository.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deployment_logs_url is not None:
            pulumi.set(__self__, "deployment_logs_url", deployment_logs_url)
        if display_url is not None:
            pulumi.set(__self__, "display_url", display_url)
        if path_mapping is not None:
            pulumi.set(__self__, "path_mapping", path_mapping)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        Branch name of repository.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deploymentLogsUrl")
    def deployment_logs_url(self) -> Optional[str]:
        """
        Url to access repository action logs.
        """
        return pulumi.get(self, "deployment_logs_url")

    @property
    @pulumi.getter(name="displayUrl")
    def display_url(self) -> Optional[str]:
        """
        Display url of repository.
        """
        return pulumi.get(self, "display_url")

    @property
    @pulumi.getter(name="pathMapping")
    def path_mapping(self) -> Optional[Sequence['outputs.ContentPathMapResponse']]:
        """
        Dictionary of source control content type and path mapping.
        """
        return pulumi.get(self, "path_mapping")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Url of repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RequiredPermissionsResponse(dict):
    """
    Required permissions for the connector
    """
    def __init__(__self__, *,
                 action: Optional[bool] = None,
                 delete: Optional[bool] = None,
                 read: Optional[bool] = None,
                 write: Optional[bool] = None):
        """
        Required permissions for the connector
        :param bool action: action permission
        :param bool delete: delete permission
        :param bool read: read permission
        :param bool write: write permission
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if read is not None:
            pulumi.set(__self__, "read", read)
        if write is not None:
            pulumi.set(__self__, "write", write)

    @property
    @pulumi.getter
    def action(self) -> Optional[bool]:
        """
        action permission
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def delete(self) -> Optional[bool]:
        """
        delete permission
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def read(self) -> Optional[bool]:
        """
        read permission
        """
        return pulumi.get(self, "read")

    @property
    @pulumi.getter
    def write(self) -> Optional[bool]:
        """
        write permission
        """
        return pulumi.get(self, "write")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TIDataConnectorDataTypesResponse(dict):
    """
    The available data types for TI (Threat Intelligence) data connector.
    """
    def __init__(__self__, *,
                 indicators: 'outputs.TIDataConnectorDataTypesResponseIndicators'):
        """
        The available data types for TI (Threat Intelligence) data connector.
        :param 'TIDataConnectorDataTypesResponseIndicators' indicators: Data type for indicators connection.
        """
        pulumi.set(__self__, "indicators", indicators)

    @property
    @pulumi.getter
    def indicators(self) -> 'outputs.TIDataConnectorDataTypesResponseIndicators':
        """
        Data type for indicators connection.
        """
        return pulumi.get(self, "indicators")


@pulumi.output_type
class TIDataConnectorDataTypesResponseIndicators(dict):
    """
    Data type for indicators connection.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Data type for indicators connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class TeamInformationResponse(dict):
    """
    Describes team information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryChannelUrl":
            suggest = "primary_channel_url"
        elif key == "teamCreationTimeUtc":
            suggest = "team_creation_time_utc"
        elif key == "teamId":
            suggest = "team_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 name: str,
                 primary_channel_url: str,
                 team_creation_time_utc: str,
                 team_id: str):
        """
        Describes team information
        :param str description: The description of the team
        :param str name: The name of the team
        :param str primary_channel_url: The primary channel URL of the team
        :param str team_creation_time_utc: The time the team was created
        :param str team_id: Team ID
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_channel_url", primary_channel_url)
        pulumi.set(__self__, "team_creation_time_utc", team_creation_time_utc)
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the team
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the team
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryChannelUrl")
    def primary_channel_url(self) -> str:
        """
        The primary channel URL of the team
        """
        return pulumi.get(self, "primary_channel_url")

    @property
    @pulumi.getter(name="teamCreationTimeUtc")
    def team_creation_time_utc(self) -> str:
        """
        The time the team was created
        """
        return pulumi.get(self, "team_creation_time_utc")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        Team ID
        """
        return pulumi.get(self, "team_id")


@pulumi.output_type
class TiTaxiiDataConnectorDataTypesResponse(dict):
    """
    The available data types for Threat Intelligence TAXII data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taxiiClient":
            suggest = "taxii_client"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TiTaxiiDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TiTaxiiDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TiTaxiiDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 taxii_client: 'outputs.TiTaxiiDataConnectorDataTypesResponseTaxiiClient'):
        """
        The available data types for Threat Intelligence TAXII data connector.
        :param 'TiTaxiiDataConnectorDataTypesResponseTaxiiClient' taxii_client: Data type for TAXII connector.
        """
        pulumi.set(__self__, "taxii_client", taxii_client)

    @property
    @pulumi.getter(name="taxiiClient")
    def taxii_client(self) -> 'outputs.TiTaxiiDataConnectorDataTypesResponseTaxiiClient':
        """
        Data type for TAXII connector.
        """
        return pulumi.get(self, "taxii_client")


@pulumi.output_type
class TiTaxiiDataConnectorDataTypesResponseTaxiiClient(dict):
    """
    Data type for TAXII connector.
    """
    def __init__(__self__, *,
                 state: str):
        """
        Data type for TAXII connector.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class WatchlistUserInfoResponse(dict):
    """
    User information that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WatchlistUserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 name: str,
                 object_id: Optional[str] = None):
        """
        User information that made some action
        :param str email: The email of the user.
        :param str name: The name of the user.
        :param str object_id: The object id of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")


