# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AuthorizationArgs',
    'EligibleApproverArgs',
    'EligibleAuthorizationArgs',
    'JustInTimeAccessPolicyArgs',
    'PlanArgs',
    'RegistrationAssignmentPropertiesArgs',
    'RegistrationDefinitionPropertiesArgs',
]

@pulumi.input_type
class AuthorizationArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[str],
                 role_definition_id: pulumi.Input[str],
                 delegated_role_definition_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 principal_id_display_name: Optional[pulumi.Input[str]] = None):
        """
        The Azure Active Directory principal identifier and Azure built-in role that describes the access the principal will receive on the delegated resource in the managed tenant.
        :param pulumi.Input[str] principal_id: The identifier of the Azure Active Directory principal.
        :param pulumi.Input[str] role_definition_id: The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegated_role_definition_ids: The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
        :param pulumi.Input[str] principal_id_display_name: The display name of the Azure Active Directory principal.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if delegated_role_definition_ids is not None:
            pulumi.set(__self__, "delegated_role_definition_ids", delegated_role_definition_ids)
        if principal_id_display_name is not None:
            pulumi.set(__self__, "principal_id_display_name", principal_id_display_name)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        The identifier of the Azure Active Directory principal.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Input[str]:
        """
        The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_definition_id", value)

    @property
    @pulumi.getter(name="delegatedRoleDefinitionIds")
    def delegated_role_definition_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
        """
        return pulumi.get(self, "delegated_role_definition_ids")

    @delegated_role_definition_ids.setter
    def delegated_role_definition_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegated_role_definition_ids", value)

    @property
    @pulumi.getter(name="principalIdDisplayName")
    def principal_id_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the Azure Active Directory principal.
        """
        return pulumi.get(self, "principal_id_display_name")

    @principal_id_display_name.setter
    def principal_id_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id_display_name", value)


@pulumi.input_type
class EligibleApproverArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[str],
                 principal_id_display_name: Optional[pulumi.Input[str]] = None):
        """
        Defines the Azure Active Directory principal that can approve any just-in-time access requests by the principal defined in the EligibleAuthorization.
        :param pulumi.Input[str] principal_id: The identifier of the Azure Active Directory principal.
        :param pulumi.Input[str] principal_id_display_name: The display name of the Azure Active Directory principal.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        if principal_id_display_name is not None:
            pulumi.set(__self__, "principal_id_display_name", principal_id_display_name)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        The identifier of the Azure Active Directory principal.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalIdDisplayName")
    def principal_id_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the Azure Active Directory principal.
        """
        return pulumi.get(self, "principal_id_display_name")

    @principal_id_display_name.setter
    def principal_id_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id_display_name", value)


@pulumi.input_type
class EligibleAuthorizationArgs:
    def __init__(__self__, *,
                 principal_id: pulumi.Input[str],
                 role_definition_id: pulumi.Input[str],
                 just_in_time_access_policy: Optional[pulumi.Input['JustInTimeAccessPolicyArgs']] = None,
                 principal_id_display_name: Optional[pulumi.Input[str]] = None):
        """
        The Azure Active Directory principal identifier, Azure built-in role, and just-in-time access policy that describes the just-in-time access the principal will receive on the delegated resource in the managed tenant.
        :param pulumi.Input[str] principal_id: The identifier of the Azure Active Directory principal.
        :param pulumi.Input[str] role_definition_id: The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
        :param pulumi.Input['JustInTimeAccessPolicyArgs'] just_in_time_access_policy: The just-in-time access policy setting.
        :param pulumi.Input[str] principal_id_display_name: The display name of the Azure Active Directory principal.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if just_in_time_access_policy is not None:
            pulumi.set(__self__, "just_in_time_access_policy", just_in_time_access_policy)
        if principal_id_display_name is not None:
            pulumi.set(__self__, "principal_id_display_name", principal_id_display_name)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        The identifier of the Azure Active Directory principal.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Input[str]:
        """
        The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_definition_id", value)

    @property
    @pulumi.getter(name="justInTimeAccessPolicy")
    def just_in_time_access_policy(self) -> Optional[pulumi.Input['JustInTimeAccessPolicyArgs']]:
        """
        The just-in-time access policy setting.
        """
        return pulumi.get(self, "just_in_time_access_policy")

    @just_in_time_access_policy.setter
    def just_in_time_access_policy(self, value: Optional[pulumi.Input['JustInTimeAccessPolicyArgs']]):
        pulumi.set(self, "just_in_time_access_policy", value)

    @property
    @pulumi.getter(name="principalIdDisplayName")
    def principal_id_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the Azure Active Directory principal.
        """
        return pulumi.get(self, "principal_id_display_name")

    @principal_id_display_name.setter
    def principal_id_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id_display_name", value)


@pulumi.input_type
class JustInTimeAccessPolicyArgs:
    def __init__(__self__, *,
                 multi_factor_auth_provider: pulumi.Input[Union[str, 'MultiFactorAuthProvider']],
                 managed_by_tenant_approvers: Optional[pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]]] = None,
                 maximum_activation_duration: Optional[pulumi.Input[str]] = None):
        """
        Just-in-time access policy setting.
        :param pulumi.Input[Union[str, 'MultiFactorAuthProvider']] multi_factor_auth_provider: The multi-factor authorization provider to be used for just-in-time access requests.
        :param pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]] managed_by_tenant_approvers: The list of managedByTenant approvers for the eligible authorization.
        :param pulumi.Input[str] maximum_activation_duration: The maximum access duration in ISO 8601 format for just-in-time access requests.
        """
        if multi_factor_auth_provider is None:
            multi_factor_auth_provider = 'None'
        pulumi.set(__self__, "multi_factor_auth_provider", multi_factor_auth_provider)
        if managed_by_tenant_approvers is not None:
            pulumi.set(__self__, "managed_by_tenant_approvers", managed_by_tenant_approvers)
        if maximum_activation_duration is None:
            maximum_activation_duration = 'PT8H'
        if maximum_activation_duration is not None:
            pulumi.set(__self__, "maximum_activation_duration", maximum_activation_duration)

    @property
    @pulumi.getter(name="multiFactorAuthProvider")
    def multi_factor_auth_provider(self) -> pulumi.Input[Union[str, 'MultiFactorAuthProvider']]:
        """
        The multi-factor authorization provider to be used for just-in-time access requests.
        """
        return pulumi.get(self, "multi_factor_auth_provider")

    @multi_factor_auth_provider.setter
    def multi_factor_auth_provider(self, value: pulumi.Input[Union[str, 'MultiFactorAuthProvider']]):
        pulumi.set(self, "multi_factor_auth_provider", value)

    @property
    @pulumi.getter(name="managedByTenantApprovers")
    def managed_by_tenant_approvers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]]]:
        """
        The list of managedByTenant approvers for the eligible authorization.
        """
        return pulumi.get(self, "managed_by_tenant_approvers")

    @managed_by_tenant_approvers.setter
    def managed_by_tenant_approvers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EligibleApproverArgs']]]]):
        pulumi.set(self, "managed_by_tenant_approvers", value)

    @property
    @pulumi.getter(name="maximumActivationDuration")
    def maximum_activation_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum access duration in ISO 8601 format for just-in-time access requests.
        """
        return pulumi.get(self, "maximum_activation_duration")

    @maximum_activation_duration.setter
    def maximum_activation_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_activation_duration", value)


@pulumi.input_type
class PlanArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 product: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 version: pulumi.Input[str]):
        """
        The details for the Managed Services offer’s plan in Azure Marketplace.
        :param pulumi.Input[str] name: Azure Marketplace plan name.
        :param pulumi.Input[str] product: Azure Marketplace product code.
        :param pulumi.Input[str] publisher: Azure Marketplace publisher ID.
        :param pulumi.Input[str] version: Azure Marketplace plan's version.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Azure Marketplace plan name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> pulumi.Input[str]:
        """
        Azure Marketplace product code.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[str]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        Azure Marketplace publisher ID.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Azure Marketplace plan's version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class RegistrationAssignmentPropertiesArgs:
    def __init__(__self__, *,
                 registration_definition_id: pulumi.Input[str]):
        """
        The properties of the registration assignment.
        :param pulumi.Input[str] registration_definition_id: The fully qualified path of the registration definition.
        """
        pulumi.set(__self__, "registration_definition_id", registration_definition_id)

    @property
    @pulumi.getter(name="registrationDefinitionId")
    def registration_definition_id(self) -> pulumi.Input[str]:
        """
        The fully qualified path of the registration definition.
        """
        return pulumi.get(self, "registration_definition_id")

    @registration_definition_id.setter
    def registration_definition_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "registration_definition_id", value)


@pulumi.input_type
class RegistrationDefinitionPropertiesArgs:
    def __init__(__self__, *,
                 authorizations: pulumi.Input[Sequence[pulumi.Input['AuthorizationArgs']]],
                 managed_by_tenant_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 eligible_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input['EligibleAuthorizationArgs']]]] = None,
                 registration_definition_name: Optional[pulumi.Input[str]] = None):
        """
        The properties of a registration definition.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationArgs']]] authorizations: The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
        :param pulumi.Input[str] managed_by_tenant_id: The identifier of the managedBy tenant.
        :param pulumi.Input[str] description: The description of the registration definition.
        :param pulumi.Input[Sequence[pulumi.Input['EligibleAuthorizationArgs']]] eligible_authorizations: The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
        :param pulumi.Input[str] registration_definition_name: The name of the registration definition.
        """
        pulumi.set(__self__, "authorizations", authorizations)
        pulumi.set(__self__, "managed_by_tenant_id", managed_by_tenant_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eligible_authorizations is not None:
            pulumi.set(__self__, "eligible_authorizations", eligible_authorizations)
        if registration_definition_name is not None:
            pulumi.set(__self__, "registration_definition_name", registration_definition_name)

    @property
    @pulumi.getter
    def authorizations(self) -> pulumi.Input[Sequence[pulumi.Input['AuthorizationArgs']]]:
        """
        The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
        """
        return pulumi.get(self, "authorizations")

    @authorizations.setter
    def authorizations(self, value: pulumi.Input[Sequence[pulumi.Input['AuthorizationArgs']]]):
        pulumi.set(self, "authorizations", value)

    @property
    @pulumi.getter(name="managedByTenantId")
    def managed_by_tenant_id(self) -> pulumi.Input[str]:
        """
        The identifier of the managedBy tenant.
        """
        return pulumi.get(self, "managed_by_tenant_id")

    @managed_by_tenant_id.setter
    def managed_by_tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_by_tenant_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the registration definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eligibleAuthorizations")
    def eligible_authorizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EligibleAuthorizationArgs']]]]:
        """
        The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
        """
        return pulumi.get(self, "eligible_authorizations")

    @eligible_authorizations.setter
    def eligible_authorizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EligibleAuthorizationArgs']]]]):
        pulumi.set(self, "eligible_authorizations", value)

    @property
    @pulumi.getter(name="registrationDefinitionName")
    def registration_definition_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the registration definition.
        """
        return pulumi.get(self, "registration_definition_name")

    @registration_definition_name.setter
    def registration_definition_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_definition_name", value)


