# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetStudentResult',
    'AwaitableGetStudentResult',
    'get_student',
    'get_student_output',
]

@pulumi.output_type
class GetStudentResult:
    """
    Student details.
    """
    def __init__(__self__, budget=None, effective_date=None, email=None, expiration_date=None, first_name=None, id=None, last_name=None, name=None, role=None, status=None, subscription_alias=None, subscription_id=None, subscription_invite_last_sent_date=None, system_data=None, type=None):
        if budget and not isinstance(budget, dict):
            raise TypeError("Expected argument 'budget' to be a dict")
        pulumi.set(__self__, "budget", budget)
        if effective_date and not isinstance(effective_date, str):
            raise TypeError("Expected argument 'effective_date' to be a str")
        pulumi.set(__self__, "effective_date", effective_date)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subscription_alias and not isinstance(subscription_alias, str):
            raise TypeError("Expected argument 'subscription_alias' to be a str")
        pulumi.set(__self__, "subscription_alias", subscription_alias)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if subscription_invite_last_sent_date and not isinstance(subscription_invite_last_sent_date, str):
            raise TypeError("Expected argument 'subscription_invite_last_sent_date' to be a str")
        pulumi.set(__self__, "subscription_invite_last_sent_date", subscription_invite_last_sent_date)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def budget(self) -> 'outputs.AmountResponse':
        """
        Student Budget
        """
        return pulumi.get(self, "budget")

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> str:
        """
        Date student was added to the lab
        """
        return pulumi.get(self, "effective_date")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Student Email
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> str:
        """
        Date this student is set to expire from the lab.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        First Name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        Last Name
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Student Role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Student Lab Status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionAlias")
    def subscription_alias(self) -> Optional[str]:
        """
        Subscription alias
        """
        return pulumi.get(self, "subscription_alias")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        Subscription Id
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="subscriptionInviteLastSentDate")
    def subscription_invite_last_sent_date(self) -> Optional[str]:
        """
        subscription invite last sent date
        """
        return pulumi.get(self, "subscription_invite_last_sent_date")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetStudentResult(GetStudentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStudentResult(
            budget=self.budget,
            effective_date=self.effective_date,
            email=self.email,
            expiration_date=self.expiration_date,
            first_name=self.first_name,
            id=self.id,
            last_name=self.last_name,
            name=self.name,
            role=self.role,
            status=self.status,
            subscription_alias=self.subscription_alias,
            subscription_id=self.subscription_id,
            subscription_invite_last_sent_date=self.subscription_invite_last_sent_date,
            system_data=self.system_data,
            type=self.type)


def get_student(billing_account_name: Optional[str] = None,
                billing_profile_name: Optional[str] = None,
                invoice_section_name: Optional[str] = None,
                student_alias: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStudentResult:
    """
    Student details.
    API Version: 2021-12-01-preview.


    :param str billing_account_name: Billing account name.
    :param str billing_profile_name: Billing profile name.
    :param str invoice_section_name: Invoice section name.
    :param str student_alias: Student alias.
    """
    __args__ = dict()
    __args__['billingAccountName'] = billing_account_name
    __args__['billingProfileName'] = billing_profile_name
    __args__['invoiceSectionName'] = invoice_section_name
    __args__['studentAlias'] = student_alias
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:education:getStudent', __args__, opts=opts, typ=GetStudentResult).value

    return AwaitableGetStudentResult(
        budget=__ret__.budget,
        effective_date=__ret__.effective_date,
        email=__ret__.email,
        expiration_date=__ret__.expiration_date,
        first_name=__ret__.first_name,
        id=__ret__.id,
        last_name=__ret__.last_name,
        name=__ret__.name,
        role=__ret__.role,
        status=__ret__.status,
        subscription_alias=__ret__.subscription_alias,
        subscription_id=__ret__.subscription_id,
        subscription_invite_last_sent_date=__ret__.subscription_invite_last_sent_date,
        system_data=__ret__.system_data,
        type=__ret__.type)


@_utilities.lift_output_func(get_student)
def get_student_output(billing_account_name: Optional[pulumi.Input[str]] = None,
                       billing_profile_name: Optional[pulumi.Input[str]] = None,
                       invoice_section_name: Optional[pulumi.Input[str]] = None,
                       student_alias: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStudentResult]:
    """
    Student details.
    API Version: 2021-12-01-preview.


    :param str billing_account_name: Billing account name.
    :param str billing_profile_name: Billing profile name.
    :param str invoice_section_name: Invoice section name.
    :param str student_alias: Student alias.
    """
    ...
