# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AutoPausePropertiesArgs',
    'AutoScalePropertiesArgs',
    'CmdkeySetupArgs',
    'ComponentSetupArgs',
    'CspWorkspaceAdminPropertiesArgs',
    'CustomerManagedKeyDetailsArgs',
    'DataLakeStorageAccountDetailsArgs',
    'DynamicExecutorAllocationArgs',
    'EncryptionDetailsArgs',
    'EntityReferenceArgs',
    'EnvironmentVariableSetupArgs',
    'IntegrationRuntimeComputePropertiesArgs',
    'IntegrationRuntimeCustomSetupScriptPropertiesArgs',
    'IntegrationRuntimeCustomerVirtualNetworkArgs',
    'IntegrationRuntimeDataFlowPropertiesArgs',
    'IntegrationRuntimeDataProxyPropertiesArgs',
    'IntegrationRuntimeSsisCatalogInfoArgs',
    'IntegrationRuntimeSsisPropertiesArgs',
    'IntegrationRuntimeVNetPropertiesArgs',
    'KekIdentityPropertiesArgs',
    'LibraryInfoArgs',
    'LibraryRequirementsArgs',
    'LinkedIntegrationRuntimeKeyAuthorizationArgs',
    'LinkedIntegrationRuntimeRbacAuthorizationArgs',
    'ManagedIdentityArgs',
    'ManagedIntegrationRuntimeArgs',
    'ManagedVirtualNetworkSettingsArgs',
    'PrivateEndpointConnectionArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'PurviewConfigurationArgs',
    'SecureStringArgs',
    'SelfHostedIntegrationRuntimeArgs',
    'SkuArgs',
    'SparkConfigPropertiesArgs',
    'SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs',
    'VirtualNetworkProfileArgs',
    'VulnerabilityAssessmentRecurringScansPropertiesArgs',
    'WorkspaceKeyDetailsArgs',
    'WorkspaceRepositoryConfigurationArgs',
]

@pulumi.input_type
class AutoPausePropertiesArgs:
    def __init__(__self__, *,
                 delay_in_minutes: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Auto-pausing properties of a Big Data pool powered by Apache Spark
        :param pulumi.Input[int] delay_in_minutes: Number of minutes of idle time before the Big Data pool is automatically paused.
        :param pulumi.Input[bool] enabled: Whether auto-pausing is enabled for the Big Data pool.
        """
        if delay_in_minutes is not None:
            pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of minutes of idle time before the Big Data pool is automatically paused.
        """
        return pulumi.get(self, "delay_in_minutes")

    @delay_in_minutes.setter
    def delay_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_in_minutes", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether auto-pausing is enabled for the Big Data pool.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class AutoScalePropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None):
        """
        Auto-scaling properties of a Big Data pool powered by Apache Spark
        :param pulumi.Input[bool] enabled: Whether automatic scaling is enabled for the Big Data pool.
        :param pulumi.Input[int] max_node_count: The maximum number of nodes the Big Data pool can support.
        :param pulumi.Input[int] min_node_count: The minimum number of nodes the Big Data pool can support.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether automatic scaling is enabled for the Big Data pool.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes the Big Data pool can support.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes the Big Data pool can support.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)


@pulumi.input_type
class CmdkeySetupArgs:
    def __init__(__self__, *,
                 password: pulumi.Input['SecureStringArgs'],
                 target_name: Any,
                 type: pulumi.Input[str],
                 user_name: Any):
        """
        The custom setup of running cmdkey commands.
        :param pulumi.Input['SecureStringArgs'] password: The password of data source access.
        :param Any target_name: The server name of data source access.
        :param pulumi.Input[str] type: The type of custom setup.
               Expected value is 'CmdkeySetup'.
        :param Any user_name: The user name of data source access.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "type", 'CmdkeySetup')
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input['SecureStringArgs']:
        """
        The password of data source access.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input['SecureStringArgs']):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Any:
        """
        The server name of data source access.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Any):
        pulumi.set(self, "target_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of custom setup.
        Expected value is 'CmdkeySetup'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Any:
        """
        The user name of data source access.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Any):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class ComponentSetupArgs:
    def __init__(__self__, *,
                 component_name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 license_key: Optional[pulumi.Input['SecureStringArgs']] = None):
        """
        The custom setup of installing 3rd party components.
        :param pulumi.Input[str] component_name: The name of the 3rd party component.
        :param pulumi.Input[str] type: The type of custom setup.
               Expected value is 'ComponentSetup'.
        :param pulumi.Input['SecureStringArgs'] license_key: The license key to activate the component.
        """
        pulumi.set(__self__, "component_name", component_name)
        pulumi.set(__self__, "type", 'ComponentSetup')
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> pulumi.Input[str]:
        """
        The name of the 3rd party component.
        """
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of custom setup.
        Expected value is 'ComponentSetup'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input['SecureStringArgs']]:
        """
        The license key to activate the component.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input['SecureStringArgs']]):
        pulumi.set(self, "license_key", value)


@pulumi.input_type
class CspWorkspaceAdminPropertiesArgs:
    def __init__(__self__, *,
                 initial_workspace_admin_object_id: Optional[pulumi.Input[str]] = None):
        """
        Initial workspace AAD admin properties for a CSP subscription
        :param pulumi.Input[str] initial_workspace_admin_object_id: AAD object ID of initial workspace admin
        """
        if initial_workspace_admin_object_id is not None:
            pulumi.set(__self__, "initial_workspace_admin_object_id", initial_workspace_admin_object_id)

    @property
    @pulumi.getter(name="initialWorkspaceAdminObjectId")
    def initial_workspace_admin_object_id(self) -> Optional[pulumi.Input[str]]:
        """
        AAD object ID of initial workspace admin
        """
        return pulumi.get(self, "initial_workspace_admin_object_id")

    @initial_workspace_admin_object_id.setter
    def initial_workspace_admin_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_workspace_admin_object_id", value)


@pulumi.input_type
class CustomerManagedKeyDetailsArgs:
    def __init__(__self__, *,
                 kek_identity: Optional[pulumi.Input['KekIdentityPropertiesArgs']] = None,
                 key: Optional[pulumi.Input['WorkspaceKeyDetailsArgs']] = None):
        """
        Details of the customer managed key associated with the workspace
        :param pulumi.Input['KekIdentityPropertiesArgs'] kek_identity: Key encryption key
        :param pulumi.Input['WorkspaceKeyDetailsArgs'] key: The key object of the workspace
        """
        if kek_identity is not None:
            pulumi.set(__self__, "kek_identity", kek_identity)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="kekIdentity")
    def kek_identity(self) -> Optional[pulumi.Input['KekIdentityPropertiesArgs']]:
        """
        Key encryption key
        """
        return pulumi.get(self, "kek_identity")

    @kek_identity.setter
    def kek_identity(self, value: Optional[pulumi.Input['KekIdentityPropertiesArgs']]):
        pulumi.set(self, "kek_identity", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input['WorkspaceKeyDetailsArgs']]:
        """
        The key object of the workspace
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input['WorkspaceKeyDetailsArgs']]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class DataLakeStorageAccountDetailsArgs:
    def __init__(__self__, *,
                 account_url: Optional[pulumi.Input[str]] = None,
                 create_managed_private_endpoint: Optional[pulumi.Input[bool]] = None,
                 filesystem: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Details of the data lake storage account associated with the workspace
        :param pulumi.Input[str] account_url: Account URL
        :param pulumi.Input[bool] create_managed_private_endpoint: Create managed private endpoint to this storage account or not
        :param pulumi.Input[str] filesystem: Filesystem name
        :param pulumi.Input[str] resource_id: ARM resource Id of this storage account
        """
        if account_url is not None:
            pulumi.set(__self__, "account_url", account_url)
        if create_managed_private_endpoint is not None:
            pulumi.set(__self__, "create_managed_private_endpoint", create_managed_private_endpoint)
        if filesystem is not None:
            pulumi.set(__self__, "filesystem", filesystem)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="accountUrl")
    def account_url(self) -> Optional[pulumi.Input[str]]:
        """
        Account URL
        """
        return pulumi.get(self, "account_url")

    @account_url.setter
    def account_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_url", value)

    @property
    @pulumi.getter(name="createManagedPrivateEndpoint")
    def create_managed_private_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Create managed private endpoint to this storage account or not
        """
        return pulumi.get(self, "create_managed_private_endpoint")

    @create_managed_private_endpoint.setter
    def create_managed_private_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_managed_private_endpoint", value)

    @property
    @pulumi.getter
    def filesystem(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem name
        """
        return pulumi.get(self, "filesystem")

    @filesystem.setter
    def filesystem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filesystem", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource Id of this storage account
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DynamicExecutorAllocationArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_executors: Optional[pulumi.Input[int]] = None,
                 min_executors: Optional[pulumi.Input[int]] = None):
        """
        Dynamic Executor Allocation Properties
        :param pulumi.Input[bool] enabled: Indicates whether Dynamic Executor Allocation is enabled or not.
        :param pulumi.Input[int] max_executors: The maximum number of executors alloted
        :param pulumi.Input[int] min_executors: The minimum number of executors alloted
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_executors is not None:
            pulumi.set(__self__, "max_executors", max_executors)
        if min_executors is not None:
            pulumi.set(__self__, "min_executors", min_executors)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Dynamic Executor Allocation is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxExecutors")
    def max_executors(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of executors alloted
        """
        return pulumi.get(self, "max_executors")

    @max_executors.setter
    def max_executors(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_executors", value)

    @property
    @pulumi.getter(name="minExecutors")
    def min_executors(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of executors alloted
        """
        return pulumi.get(self, "min_executors")

    @min_executors.setter
    def min_executors(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_executors", value)


@pulumi.input_type
class EncryptionDetailsArgs:
    def __init__(__self__, *,
                 cmk: Optional[pulumi.Input['CustomerManagedKeyDetailsArgs']] = None):
        """
        Details of the encryption associated with the workspace
        :param pulumi.Input['CustomerManagedKeyDetailsArgs'] cmk: Customer Managed Key Details
        """
        if cmk is not None:
            pulumi.set(__self__, "cmk", cmk)

    @property
    @pulumi.getter
    def cmk(self) -> Optional[pulumi.Input['CustomerManagedKeyDetailsArgs']]:
        """
        Customer Managed Key Details
        """
        return pulumi.get(self, "cmk")

    @cmk.setter
    def cmk(self, value: Optional[pulumi.Input['CustomerManagedKeyDetailsArgs']]):
        pulumi.set(self, "cmk", value)


@pulumi.input_type
class EntityReferenceArgs:
    def __init__(__self__, *,
                 reference_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']]] = None):
        """
        The entity reference.
        :param pulumi.Input[str] reference_name: The name of this referenced entity.
        :param pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']] type: The type of this referenced entity.
        """
        if reference_name is not None:
            pulumi.set(__self__, "reference_name", reference_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this referenced entity.
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']]]:
        """
        The type of this referenced entity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEntityReferenceType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EnvironmentVariableSetupArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 variable_name: pulumi.Input[str],
                 variable_value: pulumi.Input[str]):
        """
        The custom setup of setting environment variable.
        :param pulumi.Input[str] type: The type of custom setup.
               Expected value is 'EnvironmentVariableSetup'.
        :param pulumi.Input[str] variable_name: The name of the environment variable.
        :param pulumi.Input[str] variable_value: The value of the environment variable.
        """
        pulumi.set(__self__, "type", 'EnvironmentVariableSetup')
        pulumi.set(__self__, "variable_name", variable_name)
        pulumi.set(__self__, "variable_value", variable_value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of custom setup.
        Expected value is 'EnvironmentVariableSetup'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Input[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "variable_name", value)

    @property
    @pulumi.getter(name="variableValue")
    def variable_value(self) -> pulumi.Input[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "variable_value")

    @variable_value.setter
    def variable_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "variable_value", value)


@pulumi.input_type
class IntegrationRuntimeComputePropertiesArgs:
    def __init__(__self__, *,
                 data_flow_properties: Optional[pulumi.Input['IntegrationRuntimeDataFlowPropertiesArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 max_parallel_executions_per_node: Optional[pulumi.Input[int]] = None,
                 node_size: Optional[pulumi.Input[str]] = None,
                 number_of_nodes: Optional[pulumi.Input[int]] = None,
                 v_net_properties: Optional[pulumi.Input['IntegrationRuntimeVNetPropertiesArgs']] = None):
        """
        The compute resource properties for managed integration runtime.
        :param pulumi.Input['IntegrationRuntimeDataFlowPropertiesArgs'] data_flow_properties: Data flow properties for managed integration runtime.
        :param pulumi.Input[str] location: The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        :param pulumi.Input[int] max_parallel_executions_per_node: Maximum parallel executions count per node for managed integration runtime.
        :param pulumi.Input[str] node_size: The node size requirement to managed integration runtime.
        :param pulumi.Input[int] number_of_nodes: The required number of nodes for managed integration runtime.
        :param pulumi.Input['IntegrationRuntimeVNetPropertiesArgs'] v_net_properties: VNet properties for managed integration runtime.
        """
        if data_flow_properties is not None:
            pulumi.set(__self__, "data_flow_properties", data_flow_properties)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_parallel_executions_per_node is not None:
            pulumi.set(__self__, "max_parallel_executions_per_node", max_parallel_executions_per_node)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if v_net_properties is not None:
            pulumi.set(__self__, "v_net_properties", v_net_properties)

    @property
    @pulumi.getter(name="dataFlowProperties")
    def data_flow_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeDataFlowPropertiesArgs']]:
        """
        Data flow properties for managed integration runtime.
        """
        return pulumi.get(self, "data_flow_properties")

    @data_flow_properties.setter
    def data_flow_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeDataFlowPropertiesArgs']]):
        pulumi.set(self, "data_flow_properties", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxParallelExecutionsPerNode")
    def max_parallel_executions_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum parallel executions count per node for managed integration runtime.
        """
        return pulumi.get(self, "max_parallel_executions_per_node")

    @max_parallel_executions_per_node.setter
    def max_parallel_executions_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_parallel_executions_per_node", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[str]]:
        """
        The node size requirement to managed integration runtime.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The required number of nodes for managed integration runtime.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_nodes", value)

    @property
    @pulumi.getter(name="vNetProperties")
    def v_net_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeVNetPropertiesArgs']]:
        """
        VNet properties for managed integration runtime.
        """
        return pulumi.get(self, "v_net_properties")

    @v_net_properties.setter
    def v_net_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeVNetPropertiesArgs']]):
        pulumi.set(self, "v_net_properties", value)


@pulumi.input_type
class IntegrationRuntimeCustomSetupScriptPropertiesArgs:
    def __init__(__self__, *,
                 blob_container_uri: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input['SecureStringArgs']] = None):
        """
        Custom setup script properties for a managed dedicated integration runtime.
        :param pulumi.Input[str] blob_container_uri: The URI of the Azure blob container that contains the custom setup script.
        :param pulumi.Input['SecureStringArgs'] sas_token: The SAS token of the Azure blob container.
        """
        if blob_container_uri is not None:
            pulumi.set(__self__, "blob_container_uri", blob_container_uri)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="blobContainerUri")
    def blob_container_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the Azure blob container that contains the custom setup script.
        """
        return pulumi.get(self, "blob_container_uri")

    @blob_container_uri.setter
    def blob_container_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_container_uri", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input['SecureStringArgs']]:
        """
        The SAS token of the Azure blob container.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input['SecureStringArgs']]):
        pulumi.set(self, "sas_token", value)


@pulumi.input_type
class IntegrationRuntimeCustomerVirtualNetworkArgs:
    def __init__(__self__, *,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        The definition and properties of virtual network to which Azure-SSIS integration runtime will join.
        :param pulumi.Input[str] subnet_id: The ID of subnet to which Azure-SSIS integration runtime will join.
        """
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of subnet to which Azure-SSIS integration runtime will join.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class IntegrationRuntimeDataFlowPropertiesArgs:
    def __init__(__self__, *,
                 compute_type: Optional[pulumi.Input[Union[str, 'DataFlowComputeType']]] = None,
                 core_count: Optional[pulumi.Input[int]] = None,
                 time_to_live: Optional[pulumi.Input[int]] = None):
        """
        Data flow properties for managed integration runtime.
        :param pulumi.Input[Union[str, 'DataFlowComputeType']] compute_type: Compute type of the cluster which will execute data flow job.
        :param pulumi.Input[int] core_count: Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
        :param pulumi.Input[int] time_to_live: Time to live (in minutes) setting of the cluster which will execute data flow job.
        """
        if compute_type is not None:
            pulumi.set(__self__, "compute_type", compute_type)
        if core_count is not None:
            pulumi.set(__self__, "core_count", core_count)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> Optional[pulumi.Input[Union[str, 'DataFlowComputeType']]]:
        """
        Compute type of the cluster which will execute data flow job.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: Optional[pulumi.Input[Union[str, 'DataFlowComputeType']]]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> Optional[pulumi.Input[int]]:
        """
        Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
        """
        return pulumi.get(self, "core_count")

    @core_count.setter
    def core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "core_count", value)

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[pulumi.Input[int]]:
        """
        Time to live (in minutes) setting of the cluster which will execute data flow job.
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_to_live", value)


@pulumi.input_type
class IntegrationRuntimeDataProxyPropertiesArgs:
    def __init__(__self__, *,
                 connect_via: Optional[pulumi.Input['EntityReferenceArgs']] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 staging_linked_service: Optional[pulumi.Input['EntityReferenceArgs']] = None):
        """
        Data proxy properties for a managed dedicated integration runtime.
        :param pulumi.Input['EntityReferenceArgs'] connect_via: The self-hosted integration runtime reference.
        :param pulumi.Input[str] path: The path to contain the staged data in the Blob storage.
        :param pulumi.Input['EntityReferenceArgs'] staging_linked_service: The staging linked service reference.
        """
        if connect_via is not None:
            pulumi.set(__self__, "connect_via", connect_via)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if staging_linked_service is not None:
            pulumi.set(__self__, "staging_linked_service", staging_linked_service)

    @property
    @pulumi.getter(name="connectVia")
    def connect_via(self) -> Optional[pulumi.Input['EntityReferenceArgs']]:
        """
        The self-hosted integration runtime reference.
        """
        return pulumi.get(self, "connect_via")

    @connect_via.setter
    def connect_via(self, value: Optional[pulumi.Input['EntityReferenceArgs']]):
        pulumi.set(self, "connect_via", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to contain the staged data in the Blob storage.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="stagingLinkedService")
    def staging_linked_service(self) -> Optional[pulumi.Input['EntityReferenceArgs']]:
        """
        The staging linked service reference.
        """
        return pulumi.get(self, "staging_linked_service")

    @staging_linked_service.setter
    def staging_linked_service(self, value: Optional[pulumi.Input['EntityReferenceArgs']]):
        pulumi.set(self, "staging_linked_service", value)


@pulumi.input_type
class IntegrationRuntimeSsisCatalogInfoArgs:
    def __init__(__self__, *,
                 catalog_admin_password: Optional[pulumi.Input['SecureStringArgs']] = None,
                 catalog_admin_user_name: Optional[pulumi.Input[str]] = None,
                 catalog_pricing_tier: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeSsisCatalogPricingTier']]] = None,
                 catalog_server_endpoint: Optional[pulumi.Input[str]] = None):
        """
        Catalog information for managed dedicated integration runtime.
        :param pulumi.Input['SecureStringArgs'] catalog_admin_password: The password of the administrator user account of the catalog database.
        :param pulumi.Input[str] catalog_admin_user_name: The administrator user name of catalog database.
        :param pulumi.Input[Union[str, 'IntegrationRuntimeSsisCatalogPricingTier']] catalog_pricing_tier: The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        :param pulumi.Input[str] catalog_server_endpoint: The catalog database server URL.
        """
        if catalog_admin_password is not None:
            pulumi.set(__self__, "catalog_admin_password", catalog_admin_password)
        if catalog_admin_user_name is not None:
            pulumi.set(__self__, "catalog_admin_user_name", catalog_admin_user_name)
        if catalog_pricing_tier is not None:
            pulumi.set(__self__, "catalog_pricing_tier", catalog_pricing_tier)
        if catalog_server_endpoint is not None:
            pulumi.set(__self__, "catalog_server_endpoint", catalog_server_endpoint)

    @property
    @pulumi.getter(name="catalogAdminPassword")
    def catalog_admin_password(self) -> Optional[pulumi.Input['SecureStringArgs']]:
        """
        The password of the administrator user account of the catalog database.
        """
        return pulumi.get(self, "catalog_admin_password")

    @catalog_admin_password.setter
    def catalog_admin_password(self, value: Optional[pulumi.Input['SecureStringArgs']]):
        pulumi.set(self, "catalog_admin_password", value)

    @property
    @pulumi.getter(name="catalogAdminUserName")
    def catalog_admin_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The administrator user name of catalog database.
        """
        return pulumi.get(self, "catalog_admin_user_name")

    @catalog_admin_user_name.setter
    def catalog_admin_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_admin_user_name", value)

    @property
    @pulumi.getter(name="catalogPricingTier")
    def catalog_pricing_tier(self) -> Optional[pulumi.Input[Union[str, 'IntegrationRuntimeSsisCatalogPricingTier']]]:
        """
        The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
        """
        return pulumi.get(self, "catalog_pricing_tier")

    @catalog_pricing_tier.setter
    def catalog_pricing_tier(self, value: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeSsisCatalogPricingTier']]]):
        pulumi.set(self, "catalog_pricing_tier", value)

    @property
    @pulumi.getter(name="catalogServerEndpoint")
    def catalog_server_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The catalog database server URL.
        """
        return pulumi.get(self, "catalog_server_endpoint")

    @catalog_server_endpoint.setter
    def catalog_server_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_server_endpoint", value)


@pulumi.input_type
class IntegrationRuntimeSsisPropertiesArgs:
    def __init__(__self__, *,
                 catalog_info: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']] = None,
                 custom_setup_script_properties: Optional[pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs']] = None,
                 data_proxy_properties: Optional[pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs']] = None,
                 edition: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEdition']]] = None,
                 express_custom_setup_properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CmdkeySetupArgs', 'ComponentSetupArgs', 'EnvironmentVariableSetupArgs']]]]] = None,
                 license_type: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']]] = None):
        """
        SSIS properties for managed integration runtime.
        :param pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs'] catalog_info: Catalog information for managed dedicated integration runtime.
        :param pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs'] custom_setup_script_properties: Custom setup script properties for a managed dedicated integration runtime.
        :param pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs'] data_proxy_properties: Data proxy properties for a managed dedicated integration runtime.
        :param pulumi.Input[Union[str, 'IntegrationRuntimeEdition']] edition: The edition for the SSIS Integration Runtime
        :param pulumi.Input[Sequence[pulumi.Input[Union['CmdkeySetupArgs', 'ComponentSetupArgs', 'EnvironmentVariableSetupArgs']]]] express_custom_setup_properties: Custom setup without script properties for a SSIS integration runtime.
        :param pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']] license_type: License type for bringing your own license scenario.
        """
        if catalog_info is not None:
            pulumi.set(__self__, "catalog_info", catalog_info)
        if custom_setup_script_properties is not None:
            pulumi.set(__self__, "custom_setup_script_properties", custom_setup_script_properties)
        if data_proxy_properties is not None:
            pulumi.set(__self__, "data_proxy_properties", data_proxy_properties)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if express_custom_setup_properties is not None:
            pulumi.set(__self__, "express_custom_setup_properties", express_custom_setup_properties)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]:
        """
        Catalog information for managed dedicated integration runtime.
        """
        return pulumi.get(self, "catalog_info")

    @catalog_info.setter
    def catalog_info(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]):
        pulumi.set(self, "catalog_info", value)

    @property
    @pulumi.getter(name="customSetupScriptProperties")
    def custom_setup_script_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs']]:
        """
        Custom setup script properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "custom_setup_script_properties")

    @custom_setup_script_properties.setter
    def custom_setup_script_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeCustomSetupScriptPropertiesArgs']]):
        pulumi.set(self, "custom_setup_script_properties", value)

    @property
    @pulumi.getter(name="dataProxyProperties")
    def data_proxy_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs']]:
        """
        Data proxy properties for a managed dedicated integration runtime.
        """
        return pulumi.get(self, "data_proxy_properties")

    @data_proxy_properties.setter
    def data_proxy_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeDataProxyPropertiesArgs']]):
        pulumi.set(self, "data_proxy_properties", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEdition']]]:
        """
        The edition for the SSIS Integration Runtime
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeEdition']]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="expressCustomSetupProperties")
    def express_custom_setup_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['CmdkeySetupArgs', 'ComponentSetupArgs', 'EnvironmentVariableSetupArgs']]]]]:
        """
        Custom setup without script properties for a SSIS integration runtime.
        """
        return pulumi.get(self, "express_custom_setup_properties")

    @express_custom_setup_properties.setter
    def express_custom_setup_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CmdkeySetupArgs', 'ComponentSetupArgs', 'EnvironmentVariableSetupArgs']]]]]):
        pulumi.set(self, "express_custom_setup_properties", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']]]:
        """
        License type for bringing your own license scenario.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'IntegrationRuntimeLicenseType']]]):
        pulumi.set(self, "license_type", value)


@pulumi.input_type
class IntegrationRuntimeVNetPropertiesArgs:
    def __init__(__self__, *,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 v_net_id: Optional[pulumi.Input[str]] = None):
        """
        VNet properties for managed integration runtime.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ips: Resource IDs of the public IP addresses that this integration runtime will use.
        :param pulumi.Input[str] subnet: The name of the subnet this integration runtime will join.
        :param pulumi.Input[str] subnet_id: The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
        :param pulumi.Input[str] v_net_id: The ID of the VNet that this integration runtime will join.
        """
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if v_net_id is not None:
            pulumi.set(__self__, "v_net_id", v_net_id)

    @property
    @pulumi.getter(name="publicIPs")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource IDs of the public IP addresses that this integration runtime will use.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_ips", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet this integration runtime will join.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vNetId")
    def v_net_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VNet that this integration runtime will join.
        """
        return pulumi.get(self, "v_net_id")

    @v_net_id.setter
    def v_net_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_net_id", value)


@pulumi.input_type
class KekIdentityPropertiesArgs:
    def __init__(__self__, *,
                 use_system_assigned_identity: Optional[Any] = None,
                 user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        Key encryption key properties
        :param Any use_system_assigned_identity: Boolean specifying whether to use system assigned identity or not
        :param pulumi.Input[str] user_assigned_identity: User assigned identity resource Id
        """
        if use_system_assigned_identity is not None:
            pulumi.set(__self__, "use_system_assigned_identity", use_system_assigned_identity)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="useSystemAssignedIdentity")
    def use_system_assigned_identity(self) -> Optional[Any]:
        """
        Boolean specifying whether to use system assigned identity or not
        """
        return pulumi.get(self, "use_system_assigned_identity")

    @use_system_assigned_identity.setter
    def use_system_assigned_identity(self, value: Optional[Any]):
        pulumi.set(self, "use_system_assigned_identity", value)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        User assigned identity resource Id
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class LibraryInfoArgs:
    def __init__(__self__, *,
                 container_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uploaded_timestamp: Optional[pulumi.Input[str]] = None):
        """
        Library/package information of a Big Data pool powered by Apache Spark
        :param pulumi.Input[str] container_name: Storage blob container name.
        :param pulumi.Input[str] name: Name of the library.
        :param pulumi.Input[str] path: Storage blob path of library.
        :param pulumi.Input[str] type: Type of the library.
        :param pulumi.Input[str] uploaded_timestamp: The last update time of the library.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uploaded_timestamp is not None:
            pulumi.set(__self__, "uploaded_timestamp", uploaded_timestamp)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage blob container name.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the library.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Storage blob path of library.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the library.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="uploadedTimestamp")
    def uploaded_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The last update time of the library.
        """
        return pulumi.get(self, "uploaded_timestamp")

    @uploaded_timestamp.setter
    def uploaded_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uploaded_timestamp", value)


@pulumi.input_type
class LibraryRequirementsArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[str]] = None):
        """
        Library requirements for a Big Data pool powered by Apache Spark
        :param pulumi.Input[str] content: The library requirements.
        :param pulumi.Input[str] filename: The filename of the library requirements file.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The library requirements.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        The filename of the library requirements file.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)


@pulumi.input_type
class LinkedIntegrationRuntimeKeyAuthorizationArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[str],
                 key: pulumi.Input['SecureStringArgs']):
        """
        The key authorization type integration runtime.
        :param pulumi.Input[str] authorization_type: The authorization type for integration runtime sharing.
               Expected value is 'Key'.
        :param pulumi.Input['SecureStringArgs'] key: The key used for authorization.
        """
        pulumi.set(__self__, "authorization_type", 'Key')
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[str]:
        """
        The authorization type for integration runtime sharing.
        Expected value is 'Key'.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input['SecureStringArgs']:
        """
        The key used for authorization.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input['SecureStringArgs']):
        pulumi.set(self, "key", value)


@pulumi.input_type
class LinkedIntegrationRuntimeRbacAuthorizationArgs:
    def __init__(__self__, *,
                 authorization_type: pulumi.Input[str],
                 resource_id: pulumi.Input[str]):
        """
        The role based access control (RBAC) authorization type integration runtime.
        :param pulumi.Input[str] authorization_type: The authorization type for integration runtime sharing.
               Expected value is 'RBAC'.
        :param pulumi.Input[str] resource_id: The resource identifier of the integration runtime to be shared.
        """
        pulumi.set(__self__, "authorization_type", 'RBAC')
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Input[str]:
        """
        The authorization type for integration runtime sharing.
        Expected value is 'RBAC'.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The resource identifier of the integration runtime to be shared.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ManagedIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The workspace managed identity
        :param pulumi.Input['ResourceIdentityType'] type: The type of managed identity for the workspace
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The user assigned managed identities.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The type of managed identity for the workspace
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The user assigned managed identities.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ManagedIntegrationRuntimeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 compute_properties: Optional[pulumi.Input['IntegrationRuntimeComputePropertiesArgs']] = None,
                 customer_virtual_network: Optional[pulumi.Input['IntegrationRuntimeCustomerVirtualNetworkArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 reference_name: Optional[pulumi.Input[str]] = None,
                 ssis_properties: Optional[pulumi.Input['IntegrationRuntimeSsisPropertiesArgs']] = None):
        """
        Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
        :param pulumi.Input[str] type: The type of integration runtime.
               Expected value is 'Managed'.
        :param pulumi.Input['IntegrationRuntimeComputePropertiesArgs'] compute_properties: The compute resource for managed integration runtime.
        :param pulumi.Input['IntegrationRuntimeCustomerVirtualNetworkArgs'] customer_virtual_network: The name of virtual network to which Azure-SSIS integration runtime will join
        :param pulumi.Input[str] description: Integration runtime description.
        :param pulumi.Input[str] id: The id of the managed virtual network.
        :param pulumi.Input[str] reference_name: The reference name of the managed virtual network
        :param pulumi.Input['IntegrationRuntimeSsisPropertiesArgs'] ssis_properties: SSIS properties for managed integration runtime.
        """
        pulumi.set(__self__, "type", 'Managed')
        if compute_properties is not None:
            pulumi.set(__self__, "compute_properties", compute_properties)
        if customer_virtual_network is not None:
            pulumi.set(__self__, "customer_virtual_network", customer_virtual_network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reference_name is not None:
            pulumi.set(__self__, "reference_name", reference_name)
        if ssis_properties is not None:
            pulumi.set(__self__, "ssis_properties", ssis_properties)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of integration runtime.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="computeProperties")
    def compute_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeComputePropertiesArgs']]:
        """
        The compute resource for managed integration runtime.
        """
        return pulumi.get(self, "compute_properties")

    @compute_properties.setter
    def compute_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeComputePropertiesArgs']]):
        pulumi.set(self, "compute_properties", value)

    @property
    @pulumi.getter(name="customerVirtualNetwork")
    def customer_virtual_network(self) -> Optional[pulumi.Input['IntegrationRuntimeCustomerVirtualNetworkArgs']]:
        """
        The name of virtual network to which Azure-SSIS integration runtime will join
        """
        return pulumi.get(self, "customer_virtual_network")

    @customer_virtual_network.setter
    def customer_virtual_network(self, value: Optional[pulumi.Input['IntegrationRuntimeCustomerVirtualNetworkArgs']]):
        pulumi.set(self, "customer_virtual_network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the managed virtual network.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> Optional[pulumi.Input[str]]:
        """
        The reference name of the managed virtual network
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter(name="ssisProperties")
    def ssis_properties(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisPropertiesArgs']]:
        """
        SSIS properties for managed integration runtime.
        """
        return pulumi.get(self, "ssis_properties")

    @ssis_properties.setter
    def ssis_properties(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisPropertiesArgs']]):
        pulumi.set(self, "ssis_properties", value)


@pulumi.input_type
class ManagedVirtualNetworkSettingsArgs:
    def __init__(__self__, *,
                 allowed_aad_tenant_ids_for_linking: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 linked_access_check_on_target_resource: Optional[pulumi.Input[bool]] = None,
                 prevent_data_exfiltration: Optional[pulumi.Input[bool]] = None):
        """
        Managed Virtual Network Settings
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_aad_tenant_ids_for_linking: Allowed Aad Tenant Ids For Linking
        :param pulumi.Input[bool] linked_access_check_on_target_resource: Linked Access Check On Target Resource
        :param pulumi.Input[bool] prevent_data_exfiltration: Prevent Data Exfiltration
        """
        if allowed_aad_tenant_ids_for_linking is not None:
            pulumi.set(__self__, "allowed_aad_tenant_ids_for_linking", allowed_aad_tenant_ids_for_linking)
        if linked_access_check_on_target_resource is not None:
            pulumi.set(__self__, "linked_access_check_on_target_resource", linked_access_check_on_target_resource)
        if prevent_data_exfiltration is not None:
            pulumi.set(__self__, "prevent_data_exfiltration", prevent_data_exfiltration)

    @property
    @pulumi.getter(name="allowedAadTenantIdsForLinking")
    def allowed_aad_tenant_ids_for_linking(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed Aad Tenant Ids For Linking
        """
        return pulumi.get(self, "allowed_aad_tenant_ids_for_linking")

    @allowed_aad_tenant_ids_for_linking.setter
    def allowed_aad_tenant_ids_for_linking(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_aad_tenant_ids_for_linking", value)

    @property
    @pulumi.getter(name="linkedAccessCheckOnTargetResource")
    def linked_access_check_on_target_resource(self) -> Optional[pulumi.Input[bool]]:
        """
        Linked Access Check On Target Resource
        """
        return pulumi.get(self, "linked_access_check_on_target_resource")

    @linked_access_check_on_target_resource.setter
    def linked_access_check_on_target_resource(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "linked_access_check_on_target_resource", value)

    @property
    @pulumi.getter(name="preventDataExfiltration")
    def prevent_data_exfiltration(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent Data Exfiltration
        """
        return pulumi.get(self, "prevent_data_exfiltration")

    @prevent_data_exfiltration.setter
    def prevent_data_exfiltration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_data_exfiltration", value)


@pulumi.input_type
class PrivateEndpointConnectionArgs:
    def __init__(__self__, *,
                 private_link_service_connection_state: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']] = None):
        """
        A private endpoint connection
        :param pulumi.Input['PrivateLinkServiceConnectionStateArgs'] private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @private_link_service_connection_state.setter
    def private_link_service_connection_state(self, value: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]):
        pulumi.set(self, "private_link_service_connection_state", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Connection state details of the private endpoint
        :param pulumi.Input[str] description: The private link service connection description.
        :param pulumi.Input[str] status: The private link service connection status.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PurviewConfigurationArgs:
    def __init__(__self__, *,
                 purview_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Purview Configuration
        :param pulumi.Input[str] purview_resource_id: Purview Resource ID
        """
        if purview_resource_id is not None:
            pulumi.set(__self__, "purview_resource_id", purview_resource_id)

    @property
    @pulumi.getter(name="purviewResourceId")
    def purview_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Purview Resource ID
        """
        return pulumi.get(self, "purview_resource_id")

    @purview_resource_id.setter
    def purview_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purview_resource_id", value)


@pulumi.input_type
class SecureStringArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls.
        :param pulumi.Input[str] type: Type of the secret.
               Expected value is 'SecureString'.
        :param pulumi.Input[str] value: Value of secure string.
        """
        pulumi.set(__self__, "type", 'SecureString')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the secret.
        Expected value is 'SecureString'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of secure string.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SelfHostedIntegrationRuntimeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 linked_info: Optional[pulumi.Input[Union['LinkedIntegrationRuntimeKeyAuthorizationArgs', 'LinkedIntegrationRuntimeRbacAuthorizationArgs']]] = None):
        """
        Self-hosted integration runtime.
        :param pulumi.Input[str] type: The type of integration runtime.
               Expected value is 'SelfHosted'.
        :param pulumi.Input[str] description: Integration runtime description.
        :param pulumi.Input[Union['LinkedIntegrationRuntimeKeyAuthorizationArgs', 'LinkedIntegrationRuntimeRbacAuthorizationArgs']] linked_info: Linked integration runtime type from data factory
        """
        pulumi.set(__self__, "type", 'SelfHosted')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if linked_info is not None:
            pulumi.set(__self__, "linked_info", linked_info)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of integration runtime.
        Expected value is 'SelfHosted'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="linkedInfo")
    def linked_info(self) -> Optional[pulumi.Input[Union['LinkedIntegrationRuntimeKeyAuthorizationArgs', 'LinkedIntegrationRuntimeRbacAuthorizationArgs']]]:
        """
        Linked integration runtime type from data factory
        """
        return pulumi.get(self, "linked_info")

    @linked_info.setter
    def linked_info(self, value: Optional[pulumi.Input[Union['LinkedIntegrationRuntimeKeyAuthorizationArgs', 'LinkedIntegrationRuntimeRbacAuthorizationArgs']]]):
        pulumi.set(self, "linked_info", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        SQL pool SKU
        :param pulumi.Input[int] capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param pulumi.Input[str] name: The SKU name
        :param pulumi.Input[str] tier: The service tier
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The service tier
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SparkConfigPropertiesArgs:
    def __init__(__self__, *,
                 configuration_type: Optional[pulumi.Input[Union[str, 'ConfigurationType']]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[str]] = None):
        """
        SparkConfig Properties for a Big Data pool powered by Apache Spark
        :param pulumi.Input[Union[str, 'ConfigurationType']] configuration_type: The type of the spark config properties file.
        :param pulumi.Input[str] content: The spark config properties.
        :param pulumi.Input[str] filename: The filename of the spark config properties file.
        """
        if configuration_type is not None:
            pulumi.set(__self__, "configuration_type", configuration_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> Optional[pulumi.Input[Union[str, 'ConfigurationType']]]:
        """
        The type of the spark config properties file.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: Optional[pulumi.Input[Union[str, 'ConfigurationType']]]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The spark config properties.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        The filename of the spark config properties file.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)


@pulumi.input_type
class SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs:
    def __init__(__self__, *,
                 result: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Properties for an Sql pool vulnerability assessment rule baseline's result.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] result: The rule baseline result
        """
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter
    def result(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "result", value)


@pulumi.input_type
class VirtualNetworkProfileArgs:
    def __init__(__self__, *,
                 compute_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Virtual Network Profile
        :param pulumi.Input[str] compute_subnet_id: Subnet ID used for computes in workspace
        """
        if compute_subnet_id is not None:
            pulumi.set(__self__, "compute_subnet_id", compute_subnet_id)

    @property
    @pulumi.getter(name="computeSubnetId")
    def compute_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet ID used for computes in workspace
        """
        return pulumi.get(self, "compute_subnet_id")

    @compute_subnet_id.setter
    def compute_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_subnet_id", value)


@pulumi.input_type
class VulnerabilityAssessmentRecurringScansPropertiesArgs:
    def __init__(__self__, *,
                 email_subscription_admins: Optional[pulumi.Input[bool]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Properties of a Vulnerability Assessment recurring scans.
        :param pulumi.Input[bool] email_subscription_admins: Specifies that the schedule scan notification will be is sent to the subscription administrators.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] emails: Specifies an array of e-mail addresses to which the scan notification is sent.
        :param pulumi.Input[bool] is_enabled: Recurring scans state.
        """
        if email_subscription_admins is None:
            email_subscription_admins = True
        if email_subscription_admins is not None:
            pulumi.set(__self__, "email_subscription_admins", email_subscription_admins)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="emailSubscriptionAdmins")
    def email_subscription_admins(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the schedule scan notification will be is sent to the subscription administrators.
        """
        return pulumi.get(self, "email_subscription_admins")

    @email_subscription_admins.setter
    def email_subscription_admins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_subscription_admins", value)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of e-mail addresses to which the scan notification is sent.
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Recurring scans state.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


@pulumi.input_type
class WorkspaceKeyDetailsArgs:
    def __init__(__self__, *,
                 key_vault_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Details of the customer managed key associated with the workspace
        :param pulumi.Input[str] key_vault_url: Workspace Key sub-resource key vault url
        :param pulumi.Input[str] name: Workspace Key sub-resource name
        """
        if key_vault_url is not None:
            pulumi.set(__self__, "key_vault_url", key_vault_url)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="keyVaultUrl")
    def key_vault_url(self) -> Optional[pulumi.Input[str]]:
        """
        Workspace Key sub-resource key vault url
        """
        return pulumi.get(self, "key_vault_url")

    @key_vault_url.setter
    def key_vault_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Workspace Key sub-resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class WorkspaceRepositoryConfigurationArgs:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 collaboration_branch: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 last_commit_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 root_folder: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Git integration settings
        :param pulumi.Input[str] account_name: Account name
        :param pulumi.Input[str] collaboration_branch: Collaboration branch
        :param pulumi.Input[str] host_name: GitHub Enterprise host name. For example: https://github.mydomain.com
        :param pulumi.Input[str] last_commit_id: The last commit ID
        :param pulumi.Input[str] project_name: VSTS project name
        :param pulumi.Input[str] repository_name: Repository name
        :param pulumi.Input[str] root_folder: Root folder to use in the repository
        :param pulumi.Input[str] tenant_id: The VSTS tenant ID
        :param pulumi.Input[str] type: Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if collaboration_branch is not None:
            pulumi.set(__self__, "collaboration_branch", collaboration_branch)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if last_commit_id is not None:
            pulumi.set(__self__, "last_commit_id", last_commit_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if root_folder is not None:
            pulumi.set(__self__, "root_folder", root_folder)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Account name
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="collaborationBranch")
    def collaboration_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Collaboration branch
        """
        return pulumi.get(self, "collaboration_branch")

    @collaboration_branch.setter
    def collaboration_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collaboration_branch", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        GitHub Enterprise host name. For example: https://github.mydomain.com
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="lastCommitId")
    def last_commit_id(self) -> Optional[pulumi.Input[str]]:
        """
        The last commit ID
        """
        return pulumi.get(self, "last_commit_id")

    @last_commit_id.setter
    def last_commit_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_commit_id", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        VSTS project name
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        Repository name
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter(name="rootFolder")
    def root_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Root folder to use in the repository
        """
        return pulumi.get(self, "root_folder")

    @root_folder.setter
    def root_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_folder", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VSTS tenant ID
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


