# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ServerEndpointHealthResponse',
    'SyncProgressStatusResponse',
    'SyncSessionStatusResponse',
]

@pulumi.output_type
class ServerEndpointHealthResponse(dict):
    """
    ServerEndpoint Health object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "combinedHealth":
            suggest = "combined_health"
        elif key == "currentProgress":
            suggest = "current_progress"
        elif key == "downloadHealth":
            suggest = "download_health"
        elif key == "downloadStatus":
            suggest = "download_status"
        elif key == "lastUpdatedTimestamp":
            suggest = "last_updated_timestamp"
        elif key == "offlineDataTransferStatus":
            suggest = "offline_data_transfer_status"
        elif key == "uploadHealth":
            suggest = "upload_health"
        elif key == "uploadStatus":
            suggest = "upload_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointHealthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointHealthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointHealthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 combined_health: Optional[str] = None,
                 current_progress: Optional['outputs.SyncProgressStatusResponse'] = None,
                 download_health: Optional[str] = None,
                 download_status: Optional['outputs.SyncSessionStatusResponse'] = None,
                 last_updated_timestamp: Optional[str] = None,
                 offline_data_transfer_status: Optional[str] = None,
                 upload_health: Optional[str] = None,
                 upload_status: Optional['outputs.SyncSessionStatusResponse'] = None):
        """
        ServerEndpoint Health object.
        :param str combined_health: Combined Health Status.
        :param 'SyncProgressStatusResponse' current_progress: Current progress
        :param str download_health: Download Health Status.
        :param 'SyncSessionStatusResponse' download_status: Download Status
        :param str last_updated_timestamp: Last Updated Timestamp
        :param str offline_data_transfer_status: Offline Data Transfer State
        :param str upload_health: Upload Health Status.
        :param 'SyncSessionStatusResponse' upload_status: Upload Status
        """
        if combined_health is not None:
            pulumi.set(__self__, "combined_health", combined_health)
        if current_progress is not None:
            pulumi.set(__self__, "current_progress", current_progress)
        if download_health is not None:
            pulumi.set(__self__, "download_health", download_health)
        if download_status is not None:
            pulumi.set(__self__, "download_status", download_status)
        if last_updated_timestamp is not None:
            pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        if offline_data_transfer_status is not None:
            pulumi.set(__self__, "offline_data_transfer_status", offline_data_transfer_status)
        if upload_health is not None:
            pulumi.set(__self__, "upload_health", upload_health)
        if upload_status is not None:
            pulumi.set(__self__, "upload_status", upload_status)

    @property
    @pulumi.getter(name="combinedHealth")
    def combined_health(self) -> Optional[str]:
        """
        Combined Health Status.
        """
        return pulumi.get(self, "combined_health")

    @property
    @pulumi.getter(name="currentProgress")
    def current_progress(self) -> Optional['outputs.SyncProgressStatusResponse']:
        """
        Current progress
        """
        return pulumi.get(self, "current_progress")

    @property
    @pulumi.getter(name="downloadHealth")
    def download_health(self) -> Optional[str]:
        """
        Download Health Status.
        """
        return pulumi.get(self, "download_health")

    @property
    @pulumi.getter(name="downloadStatus")
    def download_status(self) -> Optional['outputs.SyncSessionStatusResponse']:
        """
        Download Status
        """
        return pulumi.get(self, "download_status")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> Optional[str]:
        """
        Last Updated Timestamp
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter(name="offlineDataTransferStatus")
    def offline_data_transfer_status(self) -> Optional[str]:
        """
        Offline Data Transfer State
        """
        return pulumi.get(self, "offline_data_transfer_status")

    @property
    @pulumi.getter(name="uploadHealth")
    def upload_health(self) -> Optional[str]:
        """
        Upload Health Status.
        """
        return pulumi.get(self, "upload_health")

    @property
    @pulumi.getter(name="uploadStatus")
    def upload_status(self) -> Optional['outputs.SyncSessionStatusResponse']:
        """
        Upload Status
        """
        return pulumi.get(self, "upload_status")


@pulumi.output_type
class SyncProgressStatusResponse(dict):
    """
    Sync Session status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedBytes":
            suggest = "applied_bytes"
        elif key == "appliedItemCount":
            suggest = "applied_item_count"
        elif key == "perItemErrorCount":
            suggest = "per_item_error_count"
        elif key == "progressTimestamp":
            suggest = "progress_timestamp"
        elif key == "syncDirection":
            suggest = "sync_direction"
        elif key == "totalBytes":
            suggest = "total_bytes"
        elif key == "totalItemCount":
            suggest = "total_item_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncProgressStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncProgressStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncProgressStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_bytes: Optional[int] = None,
                 applied_item_count: Optional[int] = None,
                 per_item_error_count: Optional[int] = None,
                 progress_timestamp: Optional[str] = None,
                 sync_direction: Optional[str] = None,
                 total_bytes: Optional[int] = None,
                 total_item_count: Optional[int] = None):
        """
        Sync Session status object.
        :param int applied_bytes: Applied bytes
        :param int applied_item_count: Applied item count.
        :param int per_item_error_count: Per item error count
        :param str progress_timestamp: Progress timestamp
        :param str sync_direction: Sync direction.
        :param int total_bytes: Total bytes
        :param int total_item_count: Total item count
        """
        if applied_bytes is not None:
            pulumi.set(__self__, "applied_bytes", applied_bytes)
        if applied_item_count is not None:
            pulumi.set(__self__, "applied_item_count", applied_item_count)
        if per_item_error_count is not None:
            pulumi.set(__self__, "per_item_error_count", per_item_error_count)
        if progress_timestamp is not None:
            pulumi.set(__self__, "progress_timestamp", progress_timestamp)
        if sync_direction is not None:
            pulumi.set(__self__, "sync_direction", sync_direction)
        if total_bytes is not None:
            pulumi.set(__self__, "total_bytes", total_bytes)
        if total_item_count is not None:
            pulumi.set(__self__, "total_item_count", total_item_count)

    @property
    @pulumi.getter(name="appliedBytes")
    def applied_bytes(self) -> Optional[int]:
        """
        Applied bytes
        """
        return pulumi.get(self, "applied_bytes")

    @property
    @pulumi.getter(name="appliedItemCount")
    def applied_item_count(self) -> Optional[int]:
        """
        Applied item count.
        """
        return pulumi.get(self, "applied_item_count")

    @property
    @pulumi.getter(name="perItemErrorCount")
    def per_item_error_count(self) -> Optional[int]:
        """
        Per item error count
        """
        return pulumi.get(self, "per_item_error_count")

    @property
    @pulumi.getter(name="progressTimestamp")
    def progress_timestamp(self) -> Optional[str]:
        """
        Progress timestamp
        """
        return pulumi.get(self, "progress_timestamp")

    @property
    @pulumi.getter(name="syncDirection")
    def sync_direction(self) -> Optional[str]:
        """
        Sync direction.
        """
        return pulumi.get(self, "sync_direction")

    @property
    @pulumi.getter(name="totalBytes")
    def total_bytes(self) -> Optional[int]:
        """
        Total bytes
        """
        return pulumi.get(self, "total_bytes")

    @property
    @pulumi.getter(name="totalItemCount")
    def total_item_count(self) -> Optional[int]:
        """
        Total item count
        """
        return pulumi.get(self, "total_item_count")


@pulumi.output_type
class SyncSessionStatusResponse(dict):
    """
    Sync Session status object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastSyncPerItemErrorCount":
            suggest = "last_sync_per_item_error_count"
        elif key == "lastSyncResult":
            suggest = "last_sync_result"
        elif key == "lastSyncSuccessTimestamp":
            suggest = "last_sync_success_timestamp"
        elif key == "lastSyncTimestamp":
            suggest = "last_sync_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyncSessionStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyncSessionStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyncSessionStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_sync_per_item_error_count: Optional[int] = None,
                 last_sync_result: Optional[int] = None,
                 last_sync_success_timestamp: Optional[str] = None,
                 last_sync_timestamp: Optional[str] = None):
        """
        Sync Session status object.
        :param int last_sync_per_item_error_count: Last sync per item error count.
        :param int last_sync_result: Last sync status
        :param str last_sync_success_timestamp: Last sync success timestamp
        :param str last_sync_timestamp: Last sync timestamp
        """
        if last_sync_per_item_error_count is not None:
            pulumi.set(__self__, "last_sync_per_item_error_count", last_sync_per_item_error_count)
        if last_sync_result is not None:
            pulumi.set(__self__, "last_sync_result", last_sync_result)
        if last_sync_success_timestamp is not None:
            pulumi.set(__self__, "last_sync_success_timestamp", last_sync_success_timestamp)
        if last_sync_timestamp is not None:
            pulumi.set(__self__, "last_sync_timestamp", last_sync_timestamp)

    @property
    @pulumi.getter(name="lastSyncPerItemErrorCount")
    def last_sync_per_item_error_count(self) -> Optional[int]:
        """
        Last sync per item error count.
        """
        return pulumi.get(self, "last_sync_per_item_error_count")

    @property
    @pulumi.getter(name="lastSyncResult")
    def last_sync_result(self) -> Optional[int]:
        """
        Last sync status
        """
        return pulumi.get(self, "last_sync_result")

    @property
    @pulumi.getter(name="lastSyncSuccessTimestamp")
    def last_sync_success_timestamp(self) -> Optional[str]:
        """
        Last sync success timestamp
        """
        return pulumi.get(self, "last_sync_success_timestamp")

    @property
    @pulumi.getter(name="lastSyncTimestamp")
    def last_sync_timestamp(self) -> Optional[str]:
        """
        Last sync timestamp
        """
        return pulumi.get(self, "last_sync_timestamp")


