# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AddressSpaceResponse',
    'ApplicationGatewayAuthenticationCertificateResponse',
    'ApplicationGatewayBackendAddressPoolResponse',
    'ApplicationGatewayBackendAddressResponse',
    'ApplicationGatewayBackendHttpSettingsResponse',
    'ApplicationGatewayConnectionDrainingResponse',
    'ApplicationGatewayFrontendIPConfigurationResponse',
    'ApplicationGatewayFrontendPortResponse',
    'ApplicationGatewayHttpListenerResponse',
    'ApplicationGatewayIPConfigurationResponse',
    'ApplicationGatewayPathRuleResponse',
    'ApplicationGatewayProbeResponse',
    'ApplicationGatewayRequestRoutingRuleResponse',
    'ApplicationGatewaySkuResponse',
    'ApplicationGatewaySslCertificateResponse',
    'ApplicationGatewaySslPolicyResponse',
    'ApplicationGatewayUrlPathMapResponse',
    'ApplicationGatewayWebApplicationFirewallConfigurationResponse',
    'BackendAddressPoolResponse',
    'BgpPeerStatusResponse',
    'BgpSettingsResponse',
    'DhcpOptionsResponse',
    'ExpressRouteCircuitAuthorizationResponse',
    'ExpressRouteCircuitPeeringConfigResponse',
    'ExpressRouteCircuitPeeringResponse',
    'ExpressRouteCircuitServiceProviderPropertiesResponse',
    'ExpressRouteCircuitSkuResponse',
    'ExpressRouteCircuitStatsResponse',
    'FrontendIPConfigurationResponse',
    'GatewayRouteResponse',
    'IPConfigurationResponse',
    'InboundNatPoolResponse',
    'InboundNatRuleResponse',
    'LoadBalancingRuleResponse',
    'LocalNetworkGatewayResponse',
    'NetworkInterfaceDnsSettingsResponse',
    'NetworkInterfaceIPConfigurationResponse',
    'NetworkInterfaceResponse',
    'NetworkSecurityGroupResponse',
    'OutboundNatRuleResponse',
    'PacketCaptureFilterResponse',
    'PacketCaptureStorageLocationResponse',
    'ProbeResponse',
    'PublicIPAddressDnsSettingsResponse',
    'PublicIPAddressResponse',
    'ResourceNavigationLinkResponse',
    'RouteFilterResponse',
    'RouteFilterRuleResponse',
    'RouteResponse',
    'RouteTableResponse',
    'SecurityRuleResponse',
    'SubResourceResponse',
    'SubnetResponse',
    'TunnelConnectionHealthResponse',
    'VirtualNetworkGatewayIPConfigurationResponse',
    'VirtualNetworkGatewayResponse',
    'VirtualNetworkGatewaySkuResponse',
    'VirtualNetworkPeeringResponse',
    'VpnClientConfigurationResponse',
    'VpnClientRevokedCertificateResponse',
    'VpnClientRootCertificateResponse',
]

@pulumi.output_type
class AddressSpaceResponse(dict):
    """
    AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefixes":
            suggest = "address_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressSpaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefixes: Optional[Sequence[str]] = None):
        """
        AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
        :param Sequence[str] address_prefixes: A list of address blocks reserved for this virtual network in CIDR notation.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        A list of address blocks reserved for this virtual network in CIDR notation.
        """
        return pulumi.get(self, "address_prefixes")


@pulumi.output_type
class ApplicationGatewayAuthenticationCertificateResponse(dict):
    """
    Authentication certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayAuthenticationCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayAuthenticationCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayAuthenticationCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Authentication certificates of an application gateway.
        :param str data: Certificate public data.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Certificate public data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayBackendAddressPoolResponse(dict):
    """
    Backend Address Pool of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddresses":
            suggest = "backend_addresses"
        elif key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_addresses: Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']] = None,
                 backend_ip_configurations: Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Backend Address Pool of an application gateway.
        :param Sequence['ApplicationGatewayBackendAddressResponse'] backend_addresses: Backend addresses
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] backend_ip_configurations: Collection of references to IPs defined in network interfaces.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        if backend_addresses is not None:
            pulumi.set(__self__, "backend_addresses", backend_addresses)
        if backend_ip_configurations is not None:
            pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendAddresses")
    def backend_addresses(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']]:
        """
        Backend addresses
        """
        return pulumi.get(self, "backend_addresses")

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']]:
        """
        Collection of references to IPs defined in network interfaces.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayBackendAddressResponse(dict):
    """
    Backend address of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 ip_address: Optional[str] = None):
        """
        Backend address of an application gateway.
        :param str fqdn: Fully qualified domain name (FQDN).
        :param str ip_address: IP address
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fully qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP address
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class ApplicationGatewayBackendHttpSettingsResponse(dict):
    """
    Backend address pool settings of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationCertificates":
            suggest = "authentication_certificates"
        elif key == "connectionDraining":
            suggest = "connection_draining"
        elif key == "cookieBasedAffinity":
            suggest = "cookie_based_affinity"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "requestTimeout":
            suggest = "request_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendHttpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_certificates: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 connection_draining: Optional['outputs.ApplicationGatewayConnectionDrainingResponse'] = None,
                 cookie_based_affinity: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 probe: Optional['outputs.SubResourceResponse'] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 request_timeout: Optional[int] = None):
        """
        Backend address pool settings of an application gateway.
        :param Sequence['SubResourceResponse'] authentication_certificates: Array of references to application gateway authentication certificates.
        :param 'ApplicationGatewayConnectionDrainingResponse' connection_draining: Connection draining of the backend http settings resource.
        :param str cookie_based_affinity: Cookie based affinity. Possible values are: 'Enabled' and 'Disabled'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int port: Port
        :param 'SubResourceResponse' probe: Probe resource of an application gateway.
        :param str protocol: Protocol. Possible values are: 'Http' and 'Https'.
        :param str provisioning_state: Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param int request_timeout: Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        """
        if authentication_certificates is not None:
            pulumi.set(__self__, "authentication_certificates", authentication_certificates)
        if connection_draining is not None:
            pulumi.set(__self__, "connection_draining", connection_draining)
        if cookie_based_affinity is not None:
            pulumi.set(__self__, "cookie_based_affinity", cookie_based_affinity)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)

    @property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Array of references to application gateway authentication certificates.
        """
        return pulumi.get(self, "authentication_certificates")

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> Optional['outputs.ApplicationGatewayConnectionDrainingResponse']:
        """
        Connection draining of the backend http settings resource.
        """
        return pulumi.get(self, "connection_draining")

    @property
    @pulumi.getter(name="cookieBasedAffinity")
    def cookie_based_affinity(self) -> Optional[str]:
        """
        Cookie based affinity. Possible values are: 'Enabled' and 'Disabled'.
        """
        return pulumi.get(self, "cookie_based_affinity")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.SubResourceResponse']:
        """
        Probe resource of an application gateway.
        """
        return pulumi.get(self, "probe")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol. Possible values are: 'Http' and 'Https'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[int]:
        """
        Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "request_timeout")


@pulumi.output_type
class ApplicationGatewayConnectionDrainingResponse(dict):
    """
    Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drainTimeoutInSec":
            suggest = "drain_timeout_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayConnectionDrainingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayConnectionDrainingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayConnectionDrainingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drain_timeout_in_sec: int,
                 enabled: bool):
        """
        Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
        :param int drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        :param bool enabled: Whether connection draining is enabled or not.
        """
        pulumi.set(__self__, "drain_timeout_in_sec", drain_timeout_in_sec)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="drainTimeoutInSec")
    def drain_timeout_in_sec(self) -> int:
        """
        The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        """
        return pulumi.get(self, "drain_timeout_in_sec")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether connection draining is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ApplicationGatewayFrontendIPConfigurationResponse(dict):
    """
    Frontend IP configuration of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        Frontend IP configuration of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :param str private_ip_allocation_method: PrivateIP allocation method. Possible values are: 'Static' and 'Dynamic'.
        :param str provisioning_state: Provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'SubResourceResponse' public_ip_address: Reference of the PublicIP resource.
        :param 'SubResourceResponse' subnet: Reference of the subnet resource.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        PrivateIPAddress of the network interface IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        PrivateIP allocation method. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the PublicIP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ApplicationGatewayFrontendPortResponse(dict):
    """
    Frontend port of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 provisioning_state: Optional[str] = None):
        """
        Frontend port of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int port: Frontend port
        :param str provisioning_state: Provisioning state of the frontend port resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Frontend port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the frontend port resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayHttpListenerResponse(dict):
    """
    Http listener of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "requireServerNameIndication":
            suggest = "require_server_name_indication"
        elif key == "sslCertificate":
            suggest = "ssl_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayHttpListenerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 frontend_port: Optional['outputs.SubResourceResponse'] = None,
                 host_name: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 require_server_name_indication: Optional[bool] = None,
                 ssl_certificate: Optional['outputs.SubResourceResponse'] = None):
        """
        Http listener of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
        :param 'SubResourceResponse' frontend_port: Frontend port resource of an application gateway.
        :param str host_name: Host name of HTTP listener.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str protocol: Protocol. Possible values are: 'Http' and 'Https'.
        :param str provisioning_state: Provisioning state of the HTTP listener resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param bool require_server_name_indication: Applicable only if protocol is https. Enables SNI for multi-hosting.
        :param 'SubResourceResponse' ssl_certificate: SSL certificate resource of an application gateway.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if require_server_name_indication is not None:
            pulumi.set(__self__, "require_server_name_indication", require_server_name_indication)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Frontend IP configuration resource of an application gateway.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional['outputs.SubResourceResponse']:
        """
        Frontend port resource of an application gateway.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Host name of HTTP listener.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol. Possible values are: 'Http' and 'Https'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the HTTP listener resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="requireServerNameIndication")
    def require_server_name_indication(self) -> Optional[bool]:
        """
        Applicable only if protocol is https. Enables SNI for multi-hosting.
        """
        return pulumi.get(self, "require_server_name_indication")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional['outputs.SubResourceResponse']:
        """
        SSL certificate resource of an application gateway.
        """
        return pulumi.get(self, "ssl_certificate")


@pulumi.output_type
class ApplicationGatewayIPConfigurationResponse(dict):
    """
    IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Provisioning state of the application gateway subnet resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'SubResourceResponse' subnet: Reference of the subnet resource. A subnet from where application gateway gets its private address.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the application gateway subnet resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the subnet resource. A subnet from where application gateway gets its private address.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ApplicationGatewayPathRuleResponse(dict):
    """
    Path rule of URL path map of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendHttpSettings":
            suggest = "backend_http_settings"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayPathRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayPathRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayPathRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 paths: Optional[Sequence[str]] = None,
                 provisioning_state: Optional[str] = None):
        """
        Path rule of URL path map of an application gateway.
        :param 'SubResourceResponse' backend_address_pool: Backend address pool resource of URL path map.
        :param 'SubResourceResponse' backend_http_settings: Backend http settings resource of URL path map.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param Sequence[str] paths: Path rules of URL path map.
        :param str provisioning_state: Path rule of URL path map resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend address pool resource of URL path map.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend http settings resource of URL path map.
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        Path rules of URL path map.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Path rule of URL path map resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayProbeResponse(dict):
    """
    Probe of the application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 host: Optional[str] = None,
                 id: Optional[str] = None,
                 interval: Optional[int] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 timeout: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        Probe of the application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str host: Host name to send the probe to.
        :param str id: Resource ID.
        :param int interval: The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str path: Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>
        :param str protocol: Protocol. Possible values are: 'Http' and 'Https'.
        :param str provisioning_state: Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param int timeout: the probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :param int unhealthy_threshold: The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Host name to send the probe to.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol. Possible values are: 'Http' and 'Https'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        the probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ApplicationGatewayRequestRoutingRuleResponse(dict):
    """
    Request routing rule of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendHttpSettings":
            suggest = "backend_http_settings"
        elif key == "httpListener":
            suggest = "http_listener"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "ruleType":
            suggest = "rule_type"
        elif key == "urlPathMap":
            suggest = "url_path_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRequestRoutingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 etag: Optional[str] = None,
                 http_listener: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 rule_type: Optional[str] = None,
                 url_path_map: Optional['outputs.SubResourceResponse'] = None):
        """
        Request routing rule of an application gateway.
        :param 'SubResourceResponse' backend_address_pool: Backend address pool resource of the application gateway. 
        :param 'SubResourceResponse' backend_http_settings: Frontend port resource of the application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' http_listener: Http listener resource of the application gateway. 
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Provisioning state of the request routing rule resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str rule_type: Rule type. Possible values are: 'Basic' and 'PathBasedRouting'.
        :param 'SubResourceResponse' url_path_map: URL path map resource of the application gateway.
        """
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if http_listener is not None:
            pulumi.set(__self__, "http_listener", http_listener)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if url_path_map is not None:
            pulumi.set(__self__, "url_path_map", url_path_map)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend address pool resource of the application gateway. 
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Frontend port resource of the application gateway.
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="httpListener")
    def http_listener(self) -> Optional['outputs.SubResourceResponse']:
        """
        Http listener resource of the application gateway. 
        """
        return pulumi.get(self, "http_listener")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the request routing rule resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[str]:
        """
        Rule type. Possible values are: 'Basic' and 'PathBasedRouting'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="urlPathMap")
    def url_path_map(self) -> Optional['outputs.SubResourceResponse']:
        """
        URL path map resource of the application gateway.
        """
        return pulumi.get(self, "url_path_map")


@pulumi.output_type
class ApplicationGatewaySkuResponse(dict):
    """
    SKU of an application gateway
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        SKU of an application gateway
        :param int capacity: Capacity (instance count) of an application gateway.
        :param str name: Name of an application gateway SKU. Possible values are: 'Standard_Small', 'Standard_Medium', 'Standard_Large', 'WAF_Medium', and 'WAF_Large'.
        :param str tier: Tier of an application gateway. Possible values are: 'Standard' and 'WAF'.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity (instance count) of an application gateway.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of an application gateway SKU. Possible values are: 'Standard_Small', 'Standard_Medium', 'Standard_Large', 'WAF_Medium', and 'WAF_Large'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Tier of an application gateway. Possible values are: 'Standard' and 'WAF'.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ApplicationGatewaySslCertificateResponse(dict):
    """
    SSL certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewaySslCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 password: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_cert_data: Optional[str] = None):
        """
        SSL certificates of an application gateway.
        :param str data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str password: Password for the pfx file specified in data. Only applicable in PUT request.
        :param str provisioning_state: Provisioning state of the SSL certificate resource Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_cert_data is not None:
            pulumi.set(__self__, "public_cert_data", public_cert_data)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Base-64 encoded pfx certificate. Only applicable in PUT Request.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for the pfx file specified in data. Only applicable in PUT request.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the SSL certificate resource Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> Optional[str]:
        """
        Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
        """
        return pulumi.get(self, "public_cert_data")


@pulumi.output_type
class ApplicationGatewaySslPolicyResponse(dict):
    """
    Application gateway SSL policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledSslProtocols":
            suggest = "disabled_ssl_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewaySslPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewaySslPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewaySslPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_ssl_protocols: Optional[Sequence[str]] = None):
        """
        Application gateway SSL policy.
        :param Sequence[str] disabled_ssl_protocols: SSL protocols to be disabled on application gateway. Possible values are: 'TLSv1_0', 'TLSv1_1', and 'TLSv1_2'.
        """
        if disabled_ssl_protocols is not None:
            pulumi.set(__self__, "disabled_ssl_protocols", disabled_ssl_protocols)

    @property
    @pulumi.getter(name="disabledSslProtocols")
    def disabled_ssl_protocols(self) -> Optional[Sequence[str]]:
        """
        SSL protocols to be disabled on application gateway. Possible values are: 'TLSv1_0', 'TLSv1_1', and 'TLSv1_2'.
        """
        return pulumi.get(self, "disabled_ssl_protocols")


@pulumi.output_type
class ApplicationGatewayUrlPathMapResponse(dict):
    """
    UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBackendAddressPool":
            suggest = "default_backend_address_pool"
        elif key == "defaultBackendHttpSettings":
            suggest = "default_backend_http_settings"
        elif key == "pathRules":
            suggest = "path_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayUrlPathMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayUrlPathMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayUrlPathMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 default_backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 path_rules: Optional[Sequence['outputs.ApplicationGatewayPathRuleResponse']] = None,
                 provisioning_state: Optional[str] = None):
        """
        UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
        :param 'SubResourceResponse' default_backend_address_pool: Default backend address pool resource of URL path map.
        :param 'SubResourceResponse' default_backend_http_settings: Default backend http settings resource of URL path map.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param Sequence['ApplicationGatewayPathRuleResponse'] path_rules: Path rule of URL path map resource.
        :param str provisioning_state: Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        if default_backend_address_pool is not None:
            pulumi.set(__self__, "default_backend_address_pool", default_backend_address_pool)
        if default_backend_http_settings is not None:
            pulumi.set(__self__, "default_backend_http_settings", default_backend_http_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="defaultBackendAddressPool")
    def default_backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default backend address pool resource of URL path map.
        """
        return pulumi.get(self, "default_backend_address_pool")

    @property
    @pulumi.getter(name="defaultBackendHttpSettings")
    def default_backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default backend http settings resource of URL path map.
        """
        return pulumi.get(self, "default_backend_http_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[Sequence['outputs.ApplicationGatewayPathRuleResponse']]:
        """
        Path rule of URL path map resource.
        """
        return pulumi.get(self, "path_rules")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ApplicationGatewayWebApplicationFirewallConfigurationResponse(dict):
    """
    Application gateway web application firewall configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firewallMode":
            suggest = "firewall_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayWebApplicationFirewallConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayWebApplicationFirewallConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayWebApplicationFirewallConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 firewall_mode: Optional[str] = None):
        """
        Application gateway web application firewall configuration.
        :param bool enabled: Whether the web application firewall is enabled or not.
        :param str firewall_mode: Web application firewall mode. Possible values are: 'Detection' and 'Prevention'.
        """
        pulumi.set(__self__, "enabled", enabled)
        if firewall_mode is not None:
            pulumi.set(__self__, "firewall_mode", firewall_mode)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the web application firewall is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="firewallMode")
    def firewall_mode(self) -> Optional[str]:
        """
        Web application firewall mode. Possible values are: 'Detection' and 'Prevention'.
        """
        return pulumi.get(self, "firewall_mode")


@pulumi.output_type
class BackendAddressPoolResponse(dict):
    """
    Pool of backend IP addresses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundNatRule":
            suggest = "outbound_nat_rule"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configurations: Sequence['outputs.NetworkInterfaceIPConfigurationResponse'],
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 outbound_nat_rule: 'outputs.SubResourceResponse',
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Pool of backend IP addresses.
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] backend_ip_configurations: Gets collection of references to IP addresses defined in network interfaces.
        :param Sequence['SubResourceResponse'] load_balancing_rules: Gets load balancing rules that use this backend address pool.
        :param 'SubResourceResponse' outbound_nat_rule: Gets outbound rules that use this backend address pool.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "outbound_nat_rule", outbound_nat_rule)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Sequence['outputs.NetworkInterfaceIPConfigurationResponse']:
        """
        Gets collection of references to IP addresses defined in network interfaces.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Gets load balancing rules that use this backend address pool.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter(name="outboundNatRule")
    def outbound_nat_rule(self) -> 'outputs.SubResourceResponse':
        """
        Gets outbound rules that use this backend address pool.
        """
        return pulumi.get(self, "outbound_nat_rule")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class BgpPeerStatusResponse(dict):
    def __init__(__self__, *,
                 asn: int,
                 connected_duration: str,
                 local_address: str,
                 messages_received: float,
                 messages_sent: float,
                 neighbor: str,
                 routes_received: float,
                 state: str):
        """
        :param int asn: The autonomous system number of the remote BGP peer
        :param str connected_duration: For how long the peering has been up
        :param str local_address: The virtual network gateway's local address
        :param float messages_received: The number of BGP messages received
        :param float messages_sent: The number of BGP messages sent
        :param str neighbor: The remote BGP peer
        :param float routes_received: The number of routes learned from this peer
        :param str state: The BGP peer state
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "connected_duration", connected_duration)
        pulumi.set(__self__, "local_address", local_address)
        pulumi.set(__self__, "messages_received", messages_received)
        pulumi.set(__self__, "messages_sent", messages_sent)
        pulumi.set(__self__, "neighbor", neighbor)
        pulumi.set(__self__, "routes_received", routes_received)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        The autonomous system number of the remote BGP peer
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="connectedDuration")
    def connected_duration(self) -> str:
        """
        For how long the peering has been up
        """
        return pulumi.get(self, "connected_duration")

    @property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> str:
        """
        The virtual network gateway's local address
        """
        return pulumi.get(self, "local_address")

    @property
    @pulumi.getter(name="messagesReceived")
    def messages_received(self) -> float:
        """
        The number of BGP messages received
        """
        return pulumi.get(self, "messages_received")

    @property
    @pulumi.getter(name="messagesSent")
    def messages_sent(self) -> float:
        """
        The number of BGP messages sent
        """
        return pulumi.get(self, "messages_sent")

    @property
    @pulumi.getter
    def neighbor(self) -> str:
        """
        The remote BGP peer
        """
        return pulumi.get(self, "neighbor")

    @property
    @pulumi.getter(name="routesReceived")
    def routes_received(self) -> float:
        """
        The number of routes learned from this peer
        """
        return pulumi.get(self, "routes_received")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The BGP peer state
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BgpSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpPeeringAddress":
            suggest = "bgp_peering_address"
        elif key == "peerWeight":
            suggest = "peer_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asn: Optional[float] = None,
                 bgp_peering_address: Optional[str] = None,
                 peer_weight: Optional[int] = None):
        """
        :param float asn: The BGP speaker's ASN.
        :param str bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :param int peer_weight: The weight added to routes learned from this BGP speaker.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if bgp_peering_address is not None:
            pulumi.set(__self__, "bgp_peering_address", bgp_peering_address)
        if peer_weight is not None:
            pulumi.set(__self__, "peer_weight", peer_weight)

    @property
    @pulumi.getter
    def asn(self) -> Optional[float]:
        """
        The BGP speaker's ASN.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="bgpPeeringAddress")
    def bgp_peering_address(self) -> Optional[str]:
        """
        The BGP peering address and BGP identifier of this BGP speaker.
        """
        return pulumi.get(self, "bgp_peering_address")

    @property
    @pulumi.getter(name="peerWeight")
    def peer_weight(self) -> Optional[int]:
        """
        The weight added to routes learned from this BGP speaker.
        """
        return pulumi.get(self, "peer_weight")


@pulumi.output_type
class DhcpOptionsResponse(dict):
    """
    DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DhcpOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
        :param Sequence[str] dns_servers: The list of DNS servers IP addresses.
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        The list of DNS servers IP addresses.
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class ExpressRouteCircuitAuthorizationResponse(dict):
    """
    Authorization in an ExpressRouteCircuit resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "authorizationUseStatus":
            suggest = "authorization_use_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 authorization_key: Optional[str] = None,
                 authorization_use_status: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Authorization in an ExpressRouteCircuit resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str authorization_key: The authorization key.
        :param str authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'.
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "etag", etag)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if authorization_use_status is not None:
            pulumi.set(__self__, "authorization_use_status", authorization_use_status)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        The authorization key.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="authorizationUseStatus")
    def authorization_use_status(self) -> Optional[str]:
        """
        AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'.
        """
        return pulumi.get(self, "authorization_use_status")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ExpressRouteCircuitPeeringConfigResponse(dict):
    """
    Specifies the peering configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertisedPublicPrefixes":
            suggest = "advertised_public_prefixes"
        elif key == "advertisedPublicPrefixesState":
            suggest = "advertised_public_prefixes_state"
        elif key == "customerASN":
            suggest = "customer_asn"
        elif key == "routingRegistryName":
            suggest = "routing_registry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advertised_public_prefixes: Optional[Sequence[str]] = None,
                 advertised_public_prefixes_state: Optional[str] = None,
                 customer_asn: Optional[int] = None,
                 routing_registry_name: Optional[str] = None):
        """
        Specifies the peering configuration.
        :param Sequence[str] advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
        :param str advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'.
        :param int customer_asn: The CustomerASN of the peering.
        :param str routing_registry_name: The RoutingRegistryName of the configuration.
        """
        if advertised_public_prefixes is not None:
            pulumi.set(__self__, "advertised_public_prefixes", advertised_public_prefixes)
        if advertised_public_prefixes_state is not None:
            pulumi.set(__self__, "advertised_public_prefixes_state", advertised_public_prefixes_state)
        if customer_asn is not None:
            pulumi.set(__self__, "customer_asn", customer_asn)
        if routing_registry_name is not None:
            pulumi.set(__self__, "routing_registry_name", routing_registry_name)

    @property
    @pulumi.getter(name="advertisedPublicPrefixes")
    def advertised_public_prefixes(self) -> Optional[Sequence[str]]:
        """
        The reference of AdvertisedPublicPrefixes.
        """
        return pulumi.get(self, "advertised_public_prefixes")

    @property
    @pulumi.getter(name="advertisedPublicPrefixesState")
    def advertised_public_prefixes_state(self) -> Optional[str]:
        """
        AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'.
        """
        return pulumi.get(self, "advertised_public_prefixes_state")

    @property
    @pulumi.getter(name="customerASN")
    def customer_asn(self) -> Optional[int]:
        """
        The CustomerASN of the peering.
        """
        return pulumi.get(self, "customer_asn")

    @property
    @pulumi.getter(name="routingRegistryName")
    def routing_registry_name(self) -> Optional[str]:
        """
        The RoutingRegistryName of the configuration.
        """
        return pulumi.get(self, "routing_registry_name")


@pulumi.output_type
class ExpressRouteCircuitPeeringResponse(dict):
    """
    Peering in an ExpressRouteCircuit resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureASN":
            suggest = "azure_asn"
        elif key == "gatewayManagerEtag":
            suggest = "gateway_manager_etag"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "microsoftPeeringConfig":
            suggest = "microsoft_peering_config"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "peeringType":
            suggest = "peering_type"
        elif key == "primaryAzurePort":
            suggest = "primary_azure_port"
        elif key == "primaryPeerAddressPrefix":
            suggest = "primary_peer_address_prefix"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "routeFilter":
            suggest = "route_filter"
        elif key == "secondaryAzurePort":
            suggest = "secondary_azure_port"
        elif key == "secondaryPeerAddressPrefix":
            suggest = "secondary_peer_address_prefix"
        elif key == "sharedKey":
            suggest = "shared_key"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 azure_asn: Optional[int] = None,
                 gateway_manager_etag: Optional[str] = None,
                 id: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 microsoft_peering_config: Optional['outputs.ExpressRouteCircuitPeeringConfigResponse'] = None,
                 name: Optional[str] = None,
                 peer_asn: Optional[int] = None,
                 peering_type: Optional[str] = None,
                 primary_azure_port: Optional[str] = None,
                 primary_peer_address_prefix: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 route_filter: Optional['outputs.RouteFilterResponse'] = None,
                 secondary_azure_port: Optional[str] = None,
                 secondary_peer_address_prefix: Optional[str] = None,
                 shared_key: Optional[str] = None,
                 state: Optional[str] = None,
                 stats: Optional['outputs.ExpressRouteCircuitStatsResponse'] = None,
                 vlan_id: Optional[int] = None):
        """
        Peering in an ExpressRouteCircuit resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param int azure_asn: The Azure ASN.
        :param str gateway_manager_etag: The GatewayManager Etag.
        :param str id: Resource ID.
        :param str last_modified_by: Gets whether the provider or the customer last modified the peering.
        :param 'ExpressRouteCircuitPeeringConfigResponse' microsoft_peering_config: The Microsoft peering configuration.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int peer_asn: The peer ASN.
        :param str peering_type: The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'.
        :param str primary_azure_port: The primary port.
        :param str primary_peer_address_prefix: The primary address prefix.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'RouteFilterResponse' route_filter: The reference of the RouteFilter resource.
        :param str secondary_azure_port: The secondary port.
        :param str secondary_peer_address_prefix: The secondary address prefix.
        :param str shared_key: The shared key.
        :param str state: The state of peering. Possible values are: 'Disabled' and 'Enabled'
        :param 'ExpressRouteCircuitStatsResponse' stats: Gets peering stats.
        :param int vlan_id: The VLAN ID.
        """
        pulumi.set(__self__, "etag", etag)
        if azure_asn is not None:
            pulumi.set(__self__, "azure_asn", azure_asn)
        if gateway_manager_etag is not None:
            pulumi.set(__self__, "gateway_manager_etag", gateway_manager_etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peering_type is not None:
            pulumi.set(__self__, "peering_type", peering_type)
        if primary_azure_port is not None:
            pulumi.set(__self__, "primary_azure_port", primary_azure_port)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if route_filter is not None:
            pulumi.set(__self__, "route_filter", route_filter)
        if secondary_azure_port is not None:
            pulumi.set(__self__, "secondary_azure_port", secondary_azure_port)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stats is not None:
            pulumi.set(__self__, "stats", stats)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="azureASN")
    def azure_asn(self) -> Optional[int]:
        """
        The Azure ASN.
        """
        return pulumi.get(self, "azure_asn")

    @property
    @pulumi.getter(name="gatewayManagerEtag")
    def gateway_manager_etag(self) -> Optional[str]:
        """
        The GatewayManager Etag.
        """
        return pulumi.get(self, "gateway_manager_etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        Gets whether the provider or the customer last modified the peering.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional['outputs.ExpressRouteCircuitPeeringConfigResponse']:
        """
        The Microsoft peering configuration.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[int]:
        """
        The peer ASN.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> Optional[str]:
        """
        The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'.
        """
        return pulumi.get(self, "peering_type")

    @property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> Optional[str]:
        """
        The primary port.
        """
        return pulumi.get(self, "primary_azure_port")

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[str]:
        """
        The primary address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="routeFilter")
    def route_filter(self) -> Optional['outputs.RouteFilterResponse']:
        """
        The reference of the RouteFilter resource.
        """
        return pulumi.get(self, "route_filter")

    @property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> Optional[str]:
        """
        The secondary port.
        """
        return pulumi.get(self, "secondary_azure_port")

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[str]:
        """
        The secondary address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[str]:
        """
        The shared key.
        """
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of peering. Possible values are: 'Disabled' and 'Enabled'
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> Optional['outputs.ExpressRouteCircuitStatsResponse']:
        """
        Gets peering stats.
        """
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[int]:
        """
        The VLAN ID.
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class ExpressRouteCircuitServiceProviderPropertiesResponse(dict):
    """
    Contains ServiceProviderProperties in an ExpressRouteCircuit.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthInMbps":
            suggest = "bandwidth_in_mbps"
        elif key == "peeringLocation":
            suggest = "peering_location"
        elif key == "serviceProviderName":
            suggest = "service_provider_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitServiceProviderPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_in_mbps: Optional[int] = None,
                 peering_location: Optional[str] = None,
                 service_provider_name: Optional[str] = None):
        """
        Contains ServiceProviderProperties in an ExpressRouteCircuit.
        :param int bandwidth_in_mbps: The BandwidthInMbps.
        :param str peering_location: The peering location.
        :param str service_provider_name: The serviceProviderName.
        """
        if bandwidth_in_mbps is not None:
            pulumi.set(__self__, "bandwidth_in_mbps", bandwidth_in_mbps)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> Optional[int]:
        """
        The BandwidthInMbps.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[str]:
        """
        The peering location.
        """
        return pulumi.get(self, "peering_location")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[str]:
        """
        The serviceProviderName.
        """
        return pulumi.get(self, "service_provider_name")


@pulumi.output_type
class ExpressRouteCircuitSkuResponse(dict):
    """
    Contains SKU in an ExpressRouteCircuit.
    """
    def __init__(__self__, *,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Contains SKU in an ExpressRouteCircuit.
        :param str family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
        :param str name: The name of the SKU.
        :param str tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'.
        """
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier of the SKU. Possible values are 'Standard' and 'Premium'.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ExpressRouteCircuitStatsResponse(dict):
    """
    Contains stats associated with the peering.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarybytesIn":
            suggest = "primarybytes_in"
        elif key == "primarybytesOut":
            suggest = "primarybytes_out"
        elif key == "secondarybytesIn":
            suggest = "secondarybytes_in"
        elif key == "secondarybytesOut":
            suggest = "secondarybytes_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primarybytes_in: Optional[float] = None,
                 primarybytes_out: Optional[float] = None,
                 secondarybytes_in: Optional[float] = None,
                 secondarybytes_out: Optional[float] = None):
        """
        Contains stats associated with the peering.
        :param float primarybytes_in: Gets BytesIn of the peering.
        :param float primarybytes_out: Gets BytesOut of the peering.
        :param float secondarybytes_in: Gets BytesIn of the peering.
        :param float secondarybytes_out: Gets BytesOut of the peering.
        """
        if primarybytes_in is not None:
            pulumi.set(__self__, "primarybytes_in", primarybytes_in)
        if primarybytes_out is not None:
            pulumi.set(__self__, "primarybytes_out", primarybytes_out)
        if secondarybytes_in is not None:
            pulumi.set(__self__, "secondarybytes_in", secondarybytes_in)
        if secondarybytes_out is not None:
            pulumi.set(__self__, "secondarybytes_out", secondarybytes_out)

    @property
    @pulumi.getter(name="primarybytesIn")
    def primarybytes_in(self) -> Optional[float]:
        """
        Gets BytesIn of the peering.
        """
        return pulumi.get(self, "primarybytes_in")

    @property
    @pulumi.getter(name="primarybytesOut")
    def primarybytes_out(self) -> Optional[float]:
        """
        Gets BytesOut of the peering.
        """
        return pulumi.get(self, "primarybytes_out")

    @property
    @pulumi.getter(name="secondarybytesIn")
    def secondarybytes_in(self) -> Optional[float]:
        """
        Gets BytesIn of the peering.
        """
        return pulumi.get(self, "secondarybytes_in")

    @property
    @pulumi.getter(name="secondarybytesOut")
    def secondarybytes_out(self) -> Optional[float]:
        """
        Gets BytesOut of the peering.
        """
        return pulumi.get(self, "secondarybytes_out")


@pulumi.output_type
class FrontendIPConfigurationResponse(dict):
    """
    Frontend IP address of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundNatPools":
            suggest = "inbound_nat_pools"
        elif key == "inboundNatRules":
            suggest = "inbound_nat_rules"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundNatRules":
            suggest = "outbound_nat_rules"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_nat_pools: Sequence['outputs.SubResourceResponse'],
                 inbound_nat_rules: Sequence['outputs.SubResourceResponse'],
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 outbound_nat_rules: Sequence['outputs.SubResourceResponse'],
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        Frontend IP address of the load balancer.
        :param Sequence['SubResourceResponse'] inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
        :param Sequence['SubResourceResponse'] inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
        :param Sequence['SubResourceResponse'] load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
        :param Sequence['SubResourceResponse'] outbound_nat_rules: Read only. Outbound rules URIs that use this frontend IP.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_allocation_method: The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'PublicIPAddressResponse' public_ip_address: The reference of the Public IP resource.
        :param 'SubnetResponse' subnet: The reference of the subnet resource.
        """
        pulumi.set(__self__, "inbound_nat_pools", inbound_nat_pools)
        pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "outbound_nat_rules", outbound_nat_rules)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="inboundNatPools")
    def inbound_nat_pools(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Read only. Inbound pools URIs that use this frontend IP.
        """
        return pulumi.get(self, "inbound_nat_pools")

    @property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Read only. Inbound rules URIs that use this frontend IP.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Gets load balancing rules URIs that use this frontend IP.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter(name="outboundNatRules")
    def outbound_nat_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Read only. Outbound rules URIs that use this frontend IP.
        """
        return pulumi.get(self, "outbound_nat_rules")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        The reference of the Public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class GatewayRouteResponse(dict):
    def __init__(__self__, *,
                 as_path: str,
                 local_address: str,
                 network: str,
                 next_hop: str,
                 origin: str,
                 source_peer: str,
                 weight: int):
        """
        :param str as_path: The route's AS path sequence
        :param str local_address: The gateway's local address
        :param str network: The route's network prefix
        :param str next_hop: The route's next hop
        :param str origin: The source this route was learned from
        :param str source_peer: The peer this route was learned from
        :param int weight: The route's weight
        """
        pulumi.set(__self__, "as_path", as_path)
        pulumi.set(__self__, "local_address", local_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "source_peer", source_peer)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="asPath")
    def as_path(self) -> str:
        """
        The route's AS path sequence
        """
        return pulumi.get(self, "as_path")

    @property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> str:
        """
        The gateway's local address
        """
        return pulumi.get(self, "local_address")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The route's network prefix
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The route's next hop
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        The source this route was learned from
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="sourcePeer")
    def source_peer(self) -> str:
        """
        The peer this route was learned from
        """
        return pulumi.get(self, "source_peer")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The route's weight
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class IPConfigurationResponse(dict):
    """
    IPConfiguration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        IPConfiguration
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_allocation_method: The private IP allocation method. Possible values are 'Static' and 'Dynamic'.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'PublicIPAddressResponse' public_ip_address: The reference of the public IP resource.
        :param 'SubnetResponse' subnet: The reference of the subnet resource.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP allocation method. Possible values are 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        The reference of the public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class InboundNatPoolResponse(dict):
    """
    Inbound NAT pool of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPortRangeEnd":
            suggest = "frontend_port_range_end"
        elif key == "frontendPortRangeStart":
            suggest = "frontend_port_range_start"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 frontend_port_range_end: int,
                 frontend_port_range_start: int,
                 protocol: str,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Inbound NAT pool of the load balancer.
        :param int backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        :param int frontend_port_range_end: The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        :param int frontend_port_range_start: The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        :param str protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "protocol", protocol)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> int:
        """
        The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        """
        return pulumi.get(self, "frontend_port_range_end")

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> int:
        """
        The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port_range_start")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class InboundNatRuleResponse(dict):
    """
    Inbound NAT rule of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfiguration":
            suggest = "backend_ip_configuration"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configuration: 'outputs.NetworkInterfaceIPConfigurationResponse',
                 backend_port: Optional[int] = None,
                 enable_floating_ip: Optional[bool] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 frontend_port: Optional[int] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Inbound NAT rule of the load balancer.
        :param 'NetworkInterfaceIPConfigurationResponse' backend_ip_configuration: A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backed IP.
        :param int backend_port: The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param int frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_ip_configuration", backend_ip_configuration)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendIPConfiguration")
    def backend_ip_configuration(self) -> 'outputs.NetworkInterfaceIPConfigurationResponse':
        """
        A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backed IP.
        """
        return pulumi.get(self, "backend_ip_configuration")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[int]:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class LoadBalancingRuleResponse(dict):
    """
    A load balancing rule for a load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frontendPort":
            suggest = "frontend_port"
        elif key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "loadDistribution":
            suggest = "load_distribution"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frontend_port: int,
                 protocol: str,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_port: Optional[int] = None,
                 enable_floating_ip: Optional[bool] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 load_distribution: Optional[str] = None,
                 name: Optional[str] = None,
                 probe: Optional['outputs.SubResourceResponse'] = None,
                 provisioning_state: Optional[str] = None):
        """
        A load balancing rule for a load balancer.
        :param int frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        :param str protocol: The transport protocol for the external endpoint. Possible values are 'Udp' or 'Tcp'
        :param 'SubResourceResponse' backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        :param int backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535. 
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str load_distribution: The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' probe: The reference of the load balancer probe used by the load balancing rule.
        :param str provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "protocol", protocol)
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution is not None:
            pulumi.set(__self__, "load_distribution", load_distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The transport protocol for the external endpoint. Possible values are 'Udp' or 'Tcp'
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535. 
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> Optional[str]:
        """
        The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'.
        """
        return pulumi.get(self, "load_distribution")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the load balancer probe used by the load balancing rule.
        """
        return pulumi.get(self, "probe")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class LocalNetworkGatewayResponse(dict):
    """
    A common class for general resource information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "bgpSettings":
            suggest = "bgp_settings"
        elif key == "gatewayIpAddress":
            suggest = "gateway_ip_address"
        elif key == "localNetworkAddressSpace":
            suggest = "local_network_address_space"
        elif key == "resourceGuid":
            suggest = "resource_guid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalNetworkGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalNetworkGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalNetworkGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 bgp_settings: Optional['outputs.BgpSettingsResponse'] = None,
                 etag: Optional[str] = None,
                 gateway_ip_address: Optional[str] = None,
                 id: Optional[str] = None,
                 local_network_address_space: Optional['outputs.AddressSpaceResponse'] = None,
                 location: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        A common class for general resource information
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Resource type.
        :param 'BgpSettingsResponse' bgp_settings: Local network gateway's BGP speaker settings.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str gateway_ip_address: IP address of local network gateway.
        :param str id: Resource ID.
        :param 'AddressSpaceResponse' local_network_address_space: Local network site address space.
        :param str location: Resource location.
        :param str resource_guid: The resource GUID property of the LocalNetworkGateway resource.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if gateway_ip_address is not None:
            pulumi.set(__self__, "gateway_ip_address", gateway_ip_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if local_network_address_space is not None:
            pulumi.set(__self__, "local_network_address_space", local_network_address_space)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional['outputs.BgpSettingsResponse']:
        """
        Local network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="gatewayIpAddress")
    def gateway_ip_address(self) -> Optional[str]:
        """
        IP address of local network gateway.
        """
        return pulumi.get(self, "gateway_ip_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localNetworkAddressSpace")
    def local_network_address_space(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        Local network site address space.
        """
        return pulumi.get(self, "local_network_address_space")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the LocalNetworkGateway resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class NetworkInterfaceDnsSettingsResponse(dict):
    """
    DNS settings of a network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedDnsServers":
            suggest = "applied_dns_servers"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "internalDnsNameLabel":
            suggest = "internal_dns_name_label"
        elif key == "internalDomainNameSuffix":
            suggest = "internal_domain_name_suffix"
        elif key == "internalFqdn":
            suggest = "internal_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_dns_servers: Optional[Sequence[str]] = None,
                 dns_servers: Optional[Sequence[str]] = None,
                 internal_dns_name_label: Optional[str] = None,
                 internal_domain_name_suffix: Optional[str] = None,
                 internal_fqdn: Optional[str] = None):
        """
        DNS settings of a network interface.
        :param Sequence[str] applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
        :param Sequence[str] dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        :param str internal_dns_name_label: Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        :param str internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
        :param str internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
        """
        if applied_dns_servers is not None:
            pulumi.set(__self__, "applied_dns_servers", applied_dns_servers)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if internal_dns_name_label is not None:
            pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)
        if internal_domain_name_suffix is not None:
            pulumi.set(__self__, "internal_domain_name_suffix", internal_domain_name_suffix)
        if internal_fqdn is not None:
            pulumi.set(__self__, "internal_fqdn", internal_fqdn)

    @property
    @pulumi.getter(name="appliedDnsServers")
    def applied_dns_servers(self) -> Optional[Sequence[str]]:
        """
        If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
        """
        return pulumi.get(self, "applied_dns_servers")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> Optional[str]:
        """
        Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        """
        return pulumi.get(self, "internal_dns_name_label")

    @property
    @pulumi.getter(name="internalDomainNameSuffix")
    def internal_domain_name_suffix(self) -> Optional[str]:
        """
        Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
        """
        return pulumi.get(self, "internal_domain_name_suffix")

    @property
    @pulumi.getter(name="internalFqdn")
    def internal_fqdn(self) -> Optional[str]:
        """
        Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
        """
        return pulumi.get(self, "internal_fqdn")


@pulumi.output_type
class NetworkInterfaceIPConfigurationResponse(dict):
    """
    IPConfiguration in a network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPools":
            suggest = "application_gateway_backend_address_pools"
        elif key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerInboundNatRules":
            suggest = "load_balancer_inbound_nat_rules"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_gateway_backend_address_pools: Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.BackendAddressPoolResponse']] = None,
                 load_balancer_inbound_nat_rules: Optional[Sequence['outputs.InboundNatRuleResponse']] = None,
                 name: Optional[str] = None,
                 primary: Optional[bool] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_address_version: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        IPConfiguration in a network interface.
        :param Sequence['ApplicationGatewayBackendAddressPoolResponse'] application_gateway_backend_address_pools: The reference of ApplicationGatewayBackendAddressPool resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param Sequence['BackendAddressPoolResponse'] load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool resource.
        :param Sequence['InboundNatRuleResponse'] load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param bool primary: Gets whether this is a primary customer address on the network interface.
        :param str private_ip_address_version: Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        :param str private_ip_allocation_method: Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'.
        :param 'PublicIPAddressResponse' public_ip_address: Public IP address resource.
        :param 'SubnetResponse' subnet: Subnet in a virtual network resource.
        """
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules", load_balancer_inbound_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']]:
        """
        The reference of ApplicationGatewayBackendAddressPool resource.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.BackendAddressPoolResponse']]:
        """
        The reference of LoadBalancerBackendAddressPool resource.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerInboundNatRules")
    def load_balancer_inbound_nat_rules(self) -> Optional[Sequence['outputs.InboundNatRuleResponse']]:
        """
        A list of references of LoadBalancerInboundNatRules.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Gets whether this is a primary customer address on the network interface.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[str]:
        """
        Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        Public IP address resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        Subnet in a virtual network resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class NetworkInterfaceResponse(dict):
    """
    A network interface in a resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableIPForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "virtualMachine":
            suggest = "virtual_machine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 dns_settings: Optional['outputs.NetworkInterfaceDnsSettingsResponse'] = None,
                 enable_accelerated_networking: Optional[bool] = None,
                 enable_ip_forwarding: Optional[bool] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']] = None,
                 location: Optional[str] = None,
                 mac_address: Optional[str] = None,
                 network_security_group: Optional['outputs.NetworkSecurityGroupResponse'] = None,
                 primary: Optional[bool] = None,
                 provisioning_state: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 virtual_machine: Optional['outputs.SubResourceResponse'] = None):
        """
        A network interface in a resource group.
        :param str name: Resource name.
        :param str type: Resource type.
        :param 'NetworkInterfaceDnsSettingsResponse' dns_settings: The DNS settings in network interface.
        :param bool enable_accelerated_networking: If the network interface is accelerated networking enabled.
        :param bool enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network interface.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] ip_configurations: A list of IPConfigurations of the network interface.
        :param str location: Resource location.
        :param str mac_address: The MAC address of the network interface.
        :param 'NetworkSecurityGroupResponse' network_security_group: The reference of the NetworkSecurityGroup resource.
        :param bool primary: Gets whether this is a primary network interface on a virtual machine.
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str resource_guid: The resource GUID property of the network interface resource.
        :param Mapping[str, str] tags: Resource tags.
        :param 'SubResourceResponse' virtual_machine: The reference of a virtual machine.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_machine is not None:
            pulumi.set(__self__, "virtual_machine", virtual_machine)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.NetworkInterfaceDnsSettingsResponse']:
        """
        The DNS settings in network interface.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[bool]:
        """
        If the network interface is accelerated networking enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @property
    @pulumi.getter(name="enableIPForwarding")
    def enable_ip_forwarding(self) -> Optional[bool]:
        """
        Indicates whether IP forwarding is enabled on this network interface.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']]:
        """
        A list of IPConfigurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        """
        The MAC address of the network interface.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.NetworkSecurityGroupResponse']:
        """
        The reference of the NetworkSecurityGroup resource.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Gets whether this is a primary network interface on a virtual machine.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the network interface resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of a virtual machine.
        """
        return pulumi.get(self, "virtual_machine")


@pulumi.output_type
class NetworkSecurityGroupResponse(dict):
    """
    NetworkSecurityGroup resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "defaultSecurityRules":
            suggest = "default_security_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "securityRules":
            suggest = "security_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSecurityGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSecurityGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSecurityGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 default_security_rules: Optional[Sequence['outputs.SecurityRuleResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 security_rules: Optional[Sequence['outputs.SecurityRuleResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        NetworkSecurityGroup resource.
        :param str name: Resource name.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: A collection of references to network interfaces.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param Sequence['SecurityRuleResponse'] default_security_rules: The default security rules of network security group.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str resource_guid: The resource GUID property of the network security group resource.
        :param Sequence['SecurityRuleResponse'] security_rules: A collection of security rules of the network security group.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if default_security_rules is not None:
            pulumi.set(__self__, "default_security_rules", default_security_rules)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        A collection of references to network interfaces.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultSecurityRules")
    def default_security_rules(self) -> Optional[Sequence['outputs.SecurityRuleResponse']]:
        """
        The default security rules of network security group.
        """
        return pulumi.get(self, "default_security_rules")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the network security group resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[Sequence['outputs.SecurityRuleResponse']]:
        """
        A collection of security rules of the network security group.
        """
        return pulumi.get(self, "security_rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class OutboundNatRuleResponse(dict):
    """
    Outbound NAT pool of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "allocatedOutboundPorts":
            suggest = "allocated_outbound_ports"
        elif key == "frontendIPConfigurations":
            suggest = "frontend_ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: 'outputs.SubResourceResponse',
                 allocated_outbound_ports: Optional[int] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configurations: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Outbound NAT pool of the load balancer.
        :param 'SubResourceResponse' backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param int allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['SubResourceResponse'] frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> 'outputs.SubResourceResponse':
        """
        A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[int]:
        """
        The number of outbound ports to be used for NAT.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        The Frontend IP addresses of the load balancer.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class PacketCaptureFilterResponse(dict):
    """
    Filter that is applied to packet capture request. Multiple filters can be applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localIPAddress":
            suggest = "local_ip_address"
        elif key == "localPort":
            suggest = "local_port"
        elif key == "remoteIPAddress":
            suggest = "remote_ip_address"
        elif key == "remotePort":
            suggest = "remote_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_ip_address: Optional[str] = None,
                 local_port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 remote_ip_address: Optional[str] = None,
                 remote_port: Optional[str] = None):
        """
        Filter that is applied to packet capture request. Multiple filters can be applied.
        :param str local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str protocol: Protocol to be filtered on.
        :param str remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        if local_ip_address is not None:
            pulumi.set(__self__, "local_ip_address", local_ip_address)
        if local_port is not None:
            pulumi.set(__self__, "local_port", local_port)
        if protocol is None:
            protocol = 'Any'
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_ip_address is not None:
            pulumi.set(__self__, "remote_ip_address", remote_ip_address)
        if remote_port is not None:
            pulumi.set(__self__, "remote_port", remote_port)

    @property
    @pulumi.getter(name="localIPAddress")
    def local_ip_address(self) -> Optional[str]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_ip_address")

    @property
    @pulumi.getter(name="localPort")
    def local_port(self) -> Optional[str]:
        """
        Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol to be filtered on.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteIPAddress")
    def remote_ip_address(self) -> Optional[str]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_ip_address")

    @property
    @pulumi.getter(name="remotePort")
    def remote_port(self) -> Optional[str]:
        """
        Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_port")


@pulumi.output_type
class PacketCaptureStorageLocationResponse(dict):
    """
    Describes the storage location for a packet capture session.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "storageId":
            suggest = "storage_id"
        elif key == "storagePath":
            suggest = "storage_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureStorageLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureStorageLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureStorageLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: Optional[str] = None,
                 storage_id: Optional[str] = None,
                 storage_path: Optional[str] = None):
        """
        Describes the storage location for a packet capture session.
        :param str file_path: A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        :param str storage_id: The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        :param str storage_path: The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if storage_id is not None:
            pulumi.set(__self__, "storage_id", storage_id)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="storageId")
    def storage_id(self) -> Optional[str]:
        """
        The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        """
        return pulumi.get(self, "storage_id")

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[str]:
        """
        The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        return pulumi.get(self, "storage_path")


@pulumi.output_type
class ProbeResponse(dict):
    """
    A load balancer probe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "numberOfProbes":
            suggest = "number_of_probes"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "requestPath":
            suggest = "request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 port: int,
                 protocol: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 interval_in_seconds: Optional[int] = None,
                 name: Optional[str] = None,
                 number_of_probes: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 request_path: Optional[str] = None):
        """
        A load balancer probe.
        :param Sequence['SubResourceResponse'] load_balancing_rules: The load balancer rules that use this probe.
        :param int port: The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        :param str protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param int interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int number_of_probes: The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str request_path: The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_probes is not None:
            pulumi.set(__self__, "number_of_probes", number_of_probes)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        The load balancer rules that use this probe.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> Optional[int]:
        """
        The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        """
        return pulumi.get(self, "number_of_probes")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[str]:
        """
        The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        return pulumi.get(self, "request_path")


@pulumi.output_type
class PublicIPAddressDnsSettingsResponse(dict):
    """
    Contains FQDN of the DNS record associated with the public IP address
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "reverseFqdn":
            suggest = "reverse_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name_label: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 reverse_fqdn: Optional[str] = None):
        """
        Contains FQDN of the DNS record associated with the public IP address
        :param str domain_name_label: Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param str fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :param str reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. 
        """
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if reverse_fqdn is not None:
            pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[str]:
        """
        Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> Optional[str]:
        """
        Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. 
        """
        return pulumi.get(self, "reverse_fqdn")


@pulumi.output_type
class PublicIPAddressResponse(dict):
    """
    Public IP address resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddressVersion":
            suggest = "public_ip_address_version"
        elif key == "publicIPAllocationMethod":
            suggest = "public_ip_allocation_method"
        elif key == "resourceGuid":
            suggest = "resource_guid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configuration: 'outputs.IPConfigurationResponse',
                 name: str,
                 type: str,
                 dns_settings: Optional['outputs.PublicIPAddressDnsSettingsResponse'] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 ip_address: Optional[str] = None,
                 location: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address_version: Optional[str] = None,
                 public_ip_allocation_method: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Public IP address resource.
        :param 'IPConfigurationResponse' ip_configuration: IPConfiguration
        :param str name: Resource name.
        :param str type: Resource type.
        :param 'PublicIPAddressDnsSettingsResponse' dns_settings: The FQDN of the DNS record associated with the public IP address.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The idle timeout of the public IP address.
        :param str location: Resource location.
        :param str provisioning_state: The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_ip_address_version: The public IP address version. Possible values are: 'IPv4' and 'IPv6'.
        :param str public_ip_allocation_method: The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        :param str resource_guid: The resource GUID property of the public IP resource.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "ip_configuration", ip_configuration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address_version is not None:
            pulumi.set(__self__, "public_ip_address_version", public_ip_address_version)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> 'outputs.IPConfigurationResponse':
        """
        IPConfiguration
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.PublicIPAddressDnsSettingsResponse']:
        """
        The FQDN of the DNS record associated with the public IP address.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddressVersion")
    def public_ip_address_version(self) -> Optional[str]:
        """
        The public IP address version. Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "public_ip_address_version")

    @property
    @pulumi.getter(name="publicIPAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[str]:
        """
        The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the public IP resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ResourceNavigationLinkResponse(dict):
    """
    ResourceNavigationLink resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "linkedResourceType":
            suggest = "linked_resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceNavigationLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceNavigationLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceNavigationLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 link: Optional[str] = None,
                 linked_resource_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        ResourceNavigationLink resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: Provisioning state of the ResourceNavigationLink resource.
        :param str id: Resource ID.
        :param str link: Link to the external resource
        :param str linked_resource_type: Resource type of the linked resource.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if linked_resource_type is not None:
            pulumi.set(__self__, "linked_resource_type", linked_resource_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the ResourceNavigationLink resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link to the external resource
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter(name="linkedResourceType")
    def linked_resource_type(self) -> Optional[str]:
        """
        Resource type of the linked resource.
        """
        return pulumi.get(self, "linked_resource_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RouteFilterResponse(dict):
    """
    Route Filter Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 location: str,
                 name: str,
                 peerings: Sequence['outputs.ExpressRouteCircuitPeeringResponse'],
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 rules: Optional[Sequence['outputs.RouteFilterRuleResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Route Filter Resource.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str location: Resource location.
        :param str name: Resource name.
        :param Sequence['ExpressRouteCircuitPeeringResponse'] peerings: A collection of references to express route circuit peerings.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        :param str type: Resource type.
        :param str id: Resource ID.
        :param Sequence['RouteFilterRuleResponse'] rules: Collection of RouteFilterRules contained within a route filter.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "peerings", peerings)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def peerings(self) -> Sequence['outputs.ExpressRouteCircuitPeeringResponse']:
        """
        A collection of references to express route circuit peerings.
        """
        return pulumi.get(self, "peerings")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RouteFilterRuleResponse']]:
        """
        Collection of RouteFilterRules contained within a route filter.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class RouteFilterRuleResponse(dict):
    """
    Route Filter Rule Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "routeFilterRuleType":
            suggest = "route_filter_rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteFilterRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteFilterRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteFilterRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 communities: Sequence[str],
                 etag: str,
                 name: str,
                 provisioning_state: str,
                 route_filter_rule_type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Route Filter Rule Resource
        :param str access: The access type of the rule. Valid values are: 'Allow', 'Deny'
        :param Sequence[str] communities: The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        :param str route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "communities", communities)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "route_filter_rule_type", route_filter_rule_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        The access type of the rule. Valid values are: 'Allow', 'Deny'
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def communities(self) -> Sequence[str]:
        """
        The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="routeFilterRuleType")
    def route_filter_rule_type(self) -> str:
        """
        The rule type of the rule. Valid value is: 'Community'
        """
        return pulumi.get(self, "route_filter_rule_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class RouteResponse(dict):
    """
    Route resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHopType":
            suggest = "next_hop_type"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_hop_type: str,
                 address_prefix: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 next_hop_ip_address: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Route resource
        :param str next_hop_type: The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'
        :param str address_prefix: The destination CIDR to which the route applies.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        The destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class RouteTableResponse(dict):
    """
    Route table resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 routes: Optional[Sequence['outputs.RouteResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Route table resource.
        :param str name: Resource name.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param Sequence['RouteResponse'] routes: Collection of routes contained within a route table.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.RouteResponse']]:
        """
        Collection of routes contained within a route table.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class SecurityRuleResponse(dict):
    """
    Network security rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddressPrefix":
            suggest = "destination_address_prefix"
        elif key == "sourceAddressPrefix":
            suggest = "source_address_prefix"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sourcePortRange":
            suggest = "source_port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 destination_address_prefix: str,
                 direction: str,
                 protocol: str,
                 source_address_prefix: str,
                 description: Optional[str] = None,
                 destination_port_range: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 source_port_range: Optional[str] = None):
        """
        Network security rule.
        :param str access: The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
        :param str destination_address_prefix: The destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :param str direction: The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.
        :param str protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.
        :param str source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. 
        :param str description: A description for this rule. Restricted to 140 chars.
        :param str destination_port_range: The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int priority: The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str source_port_range: The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> str:
        """
        The destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        """
        return pulumi.get(self, "destination_address_prefix")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> str:
        """
        The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. 
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[str]:
        """
        The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[str]:
        """
        The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")


@pulumi.output_type
class SubResourceResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SubnetResponse(dict):
    """
    Subnet in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceNavigationLinks":
            suggest = "resource_navigation_links"
        elif key == "routeTable":
            suggest = "route_table"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.IPConfigurationResponse'],
                 address_prefix: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 network_security_group: Optional['outputs.NetworkSecurityGroupResponse'] = None,
                 provisioning_state: Optional[str] = None,
                 resource_navigation_links: Optional[Sequence['outputs.ResourceNavigationLinkResponse']] = None,
                 route_table: Optional['outputs.RouteTableResponse'] = None):
        """
        Subnet in a virtual network resource.
        :param Sequence['IPConfigurationResponse'] ip_configurations: Gets an array of references to the network interface IP configurations using subnet.
        :param str address_prefix: The address prefix for the subnet.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'NetworkSecurityGroupResponse' network_security_group: The reference of the NetworkSecurityGroup resource.
        :param str provisioning_state: The provisioning state of the resource.
        :param Sequence['ResourceNavigationLinkResponse'] resource_navigation_links: Gets an array of references to the external resources using subnet.
        :param 'RouteTableResponse' route_table: The reference of the RouteTable resource.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_navigation_links is not None:
            pulumi.set(__self__, "resource_navigation_links", resource_navigation_links)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.IPConfigurationResponse']:
        """
        Gets an array of references to the network interface IP configurations using subnet.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        The address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.NetworkSecurityGroupResponse']:
        """
        The reference of the NetworkSecurityGroup resource.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceNavigationLinks")
    def resource_navigation_links(self) -> Optional[Sequence['outputs.ResourceNavigationLinkResponse']]:
        """
        Gets an array of references to the external resources using subnet.
        """
        return pulumi.get(self, "resource_navigation_links")

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional['outputs.RouteTableResponse']:
        """
        The reference of the RouteTable resource.
        """
        return pulumi.get(self, "route_table")


@pulumi.output_type
class TunnelConnectionHealthResponse(dict):
    """
    VirtualNetworkGatewayConnection properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionStatus":
            suggest = "connection_status"
        elif key == "egressBytesTransferred":
            suggest = "egress_bytes_transferred"
        elif key == "ingressBytesTransferred":
            suggest = "ingress_bytes_transferred"
        elif key == "lastConnectionEstablishedUtcTime":
            suggest = "last_connection_established_utc_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TunnelConnectionHealthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TunnelConnectionHealthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TunnelConnectionHealthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_status: str,
                 egress_bytes_transferred: float,
                 ingress_bytes_transferred: float,
                 last_connection_established_utc_time: str,
                 tunnel: str):
        """
        VirtualNetworkGatewayConnection properties
        :param str connection_status: Virtual network Gateway connection status
        :param float egress_bytes_transferred: The Egress Bytes Transferred in this connection
        :param float ingress_bytes_transferred: The Ingress Bytes Transferred in this connection
        :param str last_connection_established_utc_time: The time at which connection was established in Utc format.
        :param str tunnel: Tunnel name.
        """
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "egress_bytes_transferred", egress_bytes_transferred)
        pulumi.set(__self__, "ingress_bytes_transferred", ingress_bytes_transferred)
        pulumi.set(__self__, "last_connection_established_utc_time", last_connection_established_utc_time)
        pulumi.set(__self__, "tunnel", tunnel)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> str:
        """
        Virtual network Gateway connection status
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="egressBytesTransferred")
    def egress_bytes_transferred(self) -> float:
        """
        The Egress Bytes Transferred in this connection
        """
        return pulumi.get(self, "egress_bytes_transferred")

    @property
    @pulumi.getter(name="ingressBytesTransferred")
    def ingress_bytes_transferred(self) -> float:
        """
        The Ingress Bytes Transferred in this connection
        """
        return pulumi.get(self, "ingress_bytes_transferred")

    @property
    @pulumi.getter(name="lastConnectionEstablishedUtcTime")
    def last_connection_established_utc_time(self) -> str:
        """
        The time at which connection was established in Utc format.
        """
        return pulumi.get(self, "last_connection_established_utc_time")

    @property
    @pulumi.getter
    def tunnel(self) -> str:
        """
        Tunnel name.
        """
        return pulumi.get(self, "tunnel")


@pulumi.output_type
class VirtualNetworkGatewayIPConfigurationResponse(dict):
    """
    IP configuration for virtual network gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkGatewayIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkGatewayIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkGatewayIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration for virtual network gateway
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_allocation_method: The private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        :param 'SubResourceResponse' public_ip_address: The reference of the public IP resource.
        :param 'SubResourceResponse' subnet: The reference of the subnet resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class VirtualNetworkGatewayResponse(dict):
    """
    A common class for general resource information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "activeActive":
            suggest = "active_active"
        elif key == "bgpSettings":
            suggest = "bgp_settings"
        elif key == "enableBgp":
            suggest = "enable_bgp"
        elif key == "gatewayDefaultSite":
            suggest = "gateway_default_site"
        elif key == "gatewayType":
            suggest = "gateway_type"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "vpnClientConfiguration":
            suggest = "vpn_client_configuration"
        elif key == "vpnType":
            suggest = "vpn_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 active_active: Optional[bool] = None,
                 bgp_settings: Optional['outputs.BgpSettingsResponse'] = None,
                 enable_bgp: Optional[bool] = None,
                 etag: Optional[str] = None,
                 gateway_default_site: Optional['outputs.SubResourceResponse'] = None,
                 gateway_type: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.VirtualNetworkGatewayIPConfigurationResponse']] = None,
                 location: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 sku: Optional['outputs.VirtualNetworkGatewaySkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 vpn_client_configuration: Optional['outputs.VpnClientConfigurationResponse'] = None,
                 vpn_type: Optional[str] = None):
        """
        A common class for general resource information
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Resource type.
        :param bool active_active: ActiveActive flag
        :param 'BgpSettingsResponse' bgp_settings: Virtual network gateway's BGP speaker settings.
        :param bool enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' gateway_default_site: The reference of the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        :param str gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'.
        :param str id: Resource ID.
        :param Sequence['VirtualNetworkGatewayIPConfigurationResponse'] ip_configurations: IP configurations for virtual network gateway.
        :param str location: Resource location.
        :param str resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
        :param 'VirtualNetworkGatewaySkuResponse' sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        :param Mapping[str, str] tags: Resource tags.
        :param 'VpnClientConfigurationResponse' vpn_client_configuration: The reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        :param str vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if active_active is not None:
            pulumi.set(__self__, "active_active", active_active)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if gateway_default_site is not None:
            pulumi.set(__self__, "gateway_default_site", gateway_default_site)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_client_configuration is not None:
            pulumi.set(__self__, "vpn_client_configuration", vpn_client_configuration)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> Optional[bool]:
        """
        ActiveActive flag
        """
        return pulumi.get(self, "active_active")

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional['outputs.BgpSettingsResponse']:
        """
        Virtual network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[bool]:
        """
        Whether BGP is enabled for this virtual network gateway or not.
        """
        return pulumi.get(self, "enable_bgp")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="gatewayDefaultSite")
    def gateway_default_site(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        """
        return pulumi.get(self, "gateway_default_site")

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[str]:
        """
        The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'.
        """
        return pulumi.get(self, "gateway_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.VirtualNetworkGatewayIPConfigurationResponse']]:
        """
        IP configurations for virtual network gateway.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the VirtualNetworkGateway resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.VirtualNetworkGatewaySkuResponse']:
        """
        The reference of the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpnClientConfiguration")
    def vpn_client_configuration(self) -> Optional['outputs.VpnClientConfigurationResponse']:
        """
        The reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        """
        return pulumi.get(self, "vpn_client_configuration")

    @property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[str]:
        """
        The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'.
        """
        return pulumi.get(self, "vpn_type")


@pulumi.output_type
class VirtualNetworkGatewaySkuResponse(dict):
    """
    VirtualNetworkGatewaySku details
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        VirtualNetworkGatewaySku details
        :param int capacity: The capacity.
        :param str name: Gateway SKU name. Possible values are: 'Basic', 'HighPerformance','Standard', and 'UltraPerformance'.
        :param str tier: Gateway SKU tier. Possible values are: 'Basic', 'HighPerformance','Standard', and 'UltraPerformance'.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The capacity.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gateway SKU name. Possible values are: 'Basic', 'HighPerformance','Standard', and 'UltraPerformance'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Gateway SKU tier. Possible values are: 'Basic', 'HighPerformance','Standard', and 'UltraPerformance'.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class VirtualNetworkPeeringResponse(dict):
    """
    Peerings in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowForwardedTraffic":
            suggest = "allow_forwarded_traffic"
        elif key == "allowGatewayTransit":
            suggest = "allow_gateway_transit"
        elif key == "allowVirtualNetworkAccess":
            suggest = "allow_virtual_network_access"
        elif key == "peeringState":
            suggest = "peering_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "remoteVirtualNetwork":
            suggest = "remote_virtual_network"
        elif key == "useRemoteGateways":
            suggest = "use_remote_gateways"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_forwarded_traffic: Optional[bool] = None,
                 allow_gateway_transit: Optional[bool] = None,
                 allow_virtual_network_access: Optional[bool] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 peering_state: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 remote_virtual_network: Optional['outputs.SubResourceResponse'] = None,
                 use_remote_gateways: Optional[bool] = None):
        """
        Peerings in a virtual network resource.
        :param bool allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed.
        :param bool allow_gateway_transit: If gateway links can be used in remote virtual networking to link to this virtual network.
        :param bool allow_virtual_network_access: Whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str peering_state: The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'.
        :param str provisioning_state: The provisioning state of the resource.
        :param 'SubResourceResponse' remote_virtual_network: The reference of the remote virtual network.
        :param bool use_remote_gateways: If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        if allow_forwarded_traffic is not None:
            pulumi.set(__self__, "allow_forwarded_traffic", allow_forwarded_traffic)
        if allow_gateway_transit is not None:
            pulumi.set(__self__, "allow_gateway_transit", allow_gateway_transit)
        if allow_virtual_network_access is not None:
            pulumi.set(__self__, "allow_virtual_network_access", allow_virtual_network_access)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_state is not None:
            pulumi.set(__self__, "peering_state", peering_state)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if remote_virtual_network is not None:
            pulumi.set(__self__, "remote_virtual_network", remote_virtual_network)
        if use_remote_gateways is not None:
            pulumi.set(__self__, "use_remote_gateways", use_remote_gateways)

    @property
    @pulumi.getter(name="allowForwardedTraffic")
    def allow_forwarded_traffic(self) -> Optional[bool]:
        """
        Whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed.
        """
        return pulumi.get(self, "allow_forwarded_traffic")

    @property
    @pulumi.getter(name="allowGatewayTransit")
    def allow_gateway_transit(self) -> Optional[bool]:
        """
        If gateway links can be used in remote virtual networking to link to this virtual network.
        """
        return pulumi.get(self, "allow_gateway_transit")

    @property
    @pulumi.getter(name="allowVirtualNetworkAccess")
    def allow_virtual_network_access(self) -> Optional[bool]:
        """
        Whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space.
        """
        return pulumi.get(self, "allow_virtual_network_access")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeringState")
    def peering_state(self) -> Optional[str]:
        """
        The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'.
        """
        return pulumi.get(self, "peering_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="remoteVirtualNetwork")
    def remote_virtual_network(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the remote virtual network.
        """
        return pulumi.get(self, "remote_virtual_network")

    @property
    @pulumi.getter(name="useRemoteGateways")
    def use_remote_gateways(self) -> Optional[bool]:
        """
        If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        return pulumi.get(self, "use_remote_gateways")


@pulumi.output_type
class VpnClientConfigurationResponse(dict):
    """
    VpnClientConfiguration for P2S client.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpnClientAddressPool":
            suggest = "vpn_client_address_pool"
        elif key == "vpnClientRevokedCertificates":
            suggest = "vpn_client_revoked_certificates"
        elif key == "vpnClientRootCertificates":
            suggest = "vpn_client_root_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpn_client_address_pool: Optional['outputs.AddressSpaceResponse'] = None,
                 vpn_client_revoked_certificates: Optional[Sequence['outputs.VpnClientRevokedCertificateResponse']] = None,
                 vpn_client_root_certificates: Optional[Sequence['outputs.VpnClientRootCertificateResponse']] = None):
        """
        VpnClientConfiguration for P2S client.
        :param 'AddressSpaceResponse' vpn_client_address_pool: The reference of the address space resource which represents Address space for P2S VpnClient.
        :param Sequence['VpnClientRevokedCertificateResponse'] vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
        :param Sequence['VpnClientRootCertificateResponse'] vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
        """
        if vpn_client_address_pool is not None:
            pulumi.set(__self__, "vpn_client_address_pool", vpn_client_address_pool)
        if vpn_client_revoked_certificates is not None:
            pulumi.set(__self__, "vpn_client_revoked_certificates", vpn_client_revoked_certificates)
        if vpn_client_root_certificates is not None:
            pulumi.set(__self__, "vpn_client_root_certificates", vpn_client_root_certificates)

    @property
    @pulumi.getter(name="vpnClientAddressPool")
    def vpn_client_address_pool(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        The reference of the address space resource which represents Address space for P2S VpnClient.
        """
        return pulumi.get(self, "vpn_client_address_pool")

    @property
    @pulumi.getter(name="vpnClientRevokedCertificates")
    def vpn_client_revoked_certificates(self) -> Optional[Sequence['outputs.VpnClientRevokedCertificateResponse']]:
        """
        VpnClientRevokedCertificate for Virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_revoked_certificates")

    @property
    @pulumi.getter(name="vpnClientRootCertificates")
    def vpn_client_root_certificates(self) -> Optional[Sequence['outputs.VpnClientRootCertificateResponse']]:
        """
        VpnClientRootCertificate for virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_root_certificates")


@pulumi.output_type
class VpnClientRevokedCertificateResponse(dict):
    """
    VPN client revoked certificate of virtual network gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientRevokedCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientRevokedCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientRevokedCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        VPN client revoked certificate of virtual network gateway.
        :param str provisioning_state: The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str thumbprint: The revoked VPN client certificate thumbprint.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The revoked VPN client certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class VpnClientRootCertificateResponse(dict):
    """
    VPN client root certificate of virtual network gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 public_cert_data: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        VPN client root certificate of virtual network gateway
        :param str provisioning_state: The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_cert_data: The certificate public data.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_cert_data", public_cert_data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> str:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


