# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetMonitoringAccountResult',
    'AwaitableGetMonitoringAccountResult',
    'get_monitoring_account',
    'get_monitoring_account_output',
]

@pulumi.output_type
class GetMonitoringAccountResult:
    """
    A Monitoring Account definition
    """
    def __init__(__self__, account_id=None, default_ingestion_settings=None, etag=None, id=None, location=None, metrics=None, name=None, provisioning_state=None, system_data=None, tags=None, type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if default_ingestion_settings and not isinstance(default_ingestion_settings, dict):
            raise TypeError("Expected argument 'default_ingestion_settings' to be a dict")
        pulumi.set(__self__, "default_ingestion_settings", default_ingestion_settings)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if metrics and not isinstance(metrics, dict):
            raise TypeError("Expected argument 'metrics' to be a dict")
        pulumi.set(__self__, "metrics", metrics)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The immutable ID of the monitoring account. This property is read-only.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="defaultIngestionSettings")
    def default_ingestion_settings(self) -> 'outputs.MonitoringAccountResponseDefaultIngestionSettings':
        """
        The Data Collection Rule and Endpoint used for ingestion by default.
        """
        return pulumi.get(self, "default_ingestion_settings")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Resource entity tag (ETag)
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metrics(self) -> 'outputs.MonitoringAccountResponseMetrics':
        """
        Information about metrics for the monitoring account
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the monitoring account. Set to Succeeded if everything is healthy.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetMonitoringAccountResult(GetMonitoringAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoringAccountResult(
            account_id=self.account_id,
            default_ingestion_settings=self.default_ingestion_settings,
            etag=self.etag,
            id=self.id,
            location=self.location,
            metrics=self.metrics,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_monitoring_account(monitoring_account_name: Optional[str] = None,
                           resource_group_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoringAccountResult:
    """
    A Monitoring Account definition


    :param str monitoring_account_name: The name of the monitoring account.  The name is case insensitive
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['monitoringAccountName'] = monitoring_account_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:monitor/v20210603preview:getMonitoringAccount', __args__, opts=opts, typ=GetMonitoringAccountResult).value

    return AwaitableGetMonitoringAccountResult(
        account_id=__ret__.account_id,
        default_ingestion_settings=__ret__.default_ingestion_settings,
        etag=__ret__.etag,
        id=__ret__.id,
        location=__ret__.location,
        metrics=__ret__.metrics,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_monitoring_account)
def get_monitoring_account_output(monitoring_account_name: Optional[pulumi.Input[str]] = None,
                                  resource_group_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitoringAccountResult]:
    """
    A Monitoring Account definition


    :param str monitoring_account_name: The name of the monitoring account.  The name is case insensitive
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
