# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ErrorDetailResponse',
    'ExtendedLocationResponse',
    'GuestAgentProfileResponse',
    'GuestCredentialResponse',
    'HardwareProfileResponse',
    'HttpProxyConfigurationResponse',
    'IdentityResponse',
    'MachineExtensionInstanceViewResponseStatus',
    'MachineExtensionPropertiesResponseInstanceView',
    'NetworkInterfaceResponse',
    'NetworkProfileResponse',
    'NicIPAddressSettingsResponse',
    'NicIPSettingsResponse',
    'OsProfileResponse',
    'PlacementProfileResponse',
    'ResourceStatusResponse',
    'StorageProfileResponse',
    'SystemDataResponse',
    'VICredentialResponse',
    'VirtualDiskResponse',
    'VirtualSCSIControllerResponse',
]

@pulumi.output_type
class ErrorDetailResponse(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.ErrorDetailResponse']] = None,
                 target: Optional[str] = None):
        """
        :param str code: The error's code.
        :param str message: A human readable error message.
        :param Sequence['ErrorDetailResponse'] details: Additional error details.
        :param str target: Indicates which property in the request is responsible for the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error's code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human readable error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ErrorDetailResponse']]:
        """
        Additional error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Indicates which property in the request is responsible for the error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The extended location.
        :param str name: The extended location name.
        :param str type: The extended location type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The extended location name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The extended location type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GuestAgentProfileResponse(dict):
    """
    Defines the resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentVersion":
            suggest = "agent_version"
        elif key == "errorDetails":
            suggest = "error_details"
        elif key == "lastStatusChange":
            suggest = "last_status_change"
        elif key == "vmUuid":
            suggest = "vm_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestAgentProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestAgentProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestAgentProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_version: str,
                 error_details: Sequence['outputs.ErrorDetailResponse'],
                 last_status_change: str,
                 status: str,
                 vm_uuid: str):
        """
        Defines the resource properties.
        :param str agent_version: The hybrid machine agent full version.
        :param Sequence['ErrorDetailResponse'] error_details: Details about the error state.
        :param str last_status_change: The time of the last status change.
        :param str status: The status of the hybrid machine agent.
        :param str vm_uuid: Specifies the VM's unique SMBIOS ID.
        """
        pulumi.set(__self__, "agent_version", agent_version)
        pulumi.set(__self__, "error_details", error_details)
        pulumi.set(__self__, "last_status_change", last_status_change)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vm_uuid", vm_uuid)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        The hybrid machine agent full version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="errorDetails")
    def error_details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        Details about the error state.
        """
        return pulumi.get(self, "error_details")

    @property
    @pulumi.getter(name="lastStatusChange")
    def last_status_change(self) -> str:
        """
        The time of the last status change.
        """
        return pulumi.get(self, "last_status_change")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the hybrid machine agent.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vmUuid")
    def vm_uuid(self) -> str:
        """
        Specifies the VM's unique SMBIOS ID.
        """
        return pulumi.get(self, "vm_uuid")


@pulumi.output_type
class GuestCredentialResponse(dict):
    """
    Username / Password Credentials to connect to guest.
    """
    def __init__(__self__, *,
                 username: Optional[str] = None):
        """
        Username / Password Credentials to connect to guest.
        :param str username: Gets or sets username to connect with the guest.
        """
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Gets or sets username to connect with the guest.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class HardwareProfileResponse(dict):
    """
    Defines the resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuHotAddEnabled":
            suggest = "cpu_hot_add_enabled"
        elif key == "cpuHotRemoveEnabled":
            suggest = "cpu_hot_remove_enabled"
        elif key == "memoryHotAddEnabled":
            suggest = "memory_hot_add_enabled"
        elif key == "memorySizeMB":
            suggest = "memory_size_mb"
        elif key == "numCPUs":
            suggest = "num_cpus"
        elif key == "numCoresPerSocket":
            suggest = "num_cores_per_socket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_hot_add_enabled: bool,
                 cpu_hot_remove_enabled: bool,
                 memory_hot_add_enabled: bool,
                 memory_size_mb: Optional[int] = None,
                 num_cpus: Optional[int] = None,
                 num_cores_per_socket: Optional[int] = None):
        """
        Defines the resource properties.
        :param bool cpu_hot_add_enabled: Gets or sets a value indicating whether virtual processors can be added while this virtual machine is running.
        :param bool cpu_hot_remove_enabled: Gets or sets a value indicating whether virtual processors can be removed while this virtual machine is running.
        :param bool memory_hot_add_enabled: Gets or sets a value indicating whether memory can be added while this virtual machine is running.
        :param int memory_size_mb: Gets or sets memory size in MBs for the vm.
        :param int num_cpus: Gets or sets the number of vCPUs for the vm.
        :param int num_cores_per_socket: Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
        """
        pulumi.set(__self__, "cpu_hot_add_enabled", cpu_hot_add_enabled)
        pulumi.set(__self__, "cpu_hot_remove_enabled", cpu_hot_remove_enabled)
        pulumi.set(__self__, "memory_hot_add_enabled", memory_hot_add_enabled)
        if memory_size_mb is not None:
            pulumi.set(__self__, "memory_size_mb", memory_size_mb)
        if num_cpus is not None:
            pulumi.set(__self__, "num_cpus", num_cpus)
        if num_cores_per_socket is not None:
            pulumi.set(__self__, "num_cores_per_socket", num_cores_per_socket)

    @property
    @pulumi.getter(name="cpuHotAddEnabled")
    def cpu_hot_add_enabled(self) -> bool:
        """
        Gets or sets a value indicating whether virtual processors can be added while this virtual machine is running.
        """
        return pulumi.get(self, "cpu_hot_add_enabled")

    @property
    @pulumi.getter(name="cpuHotRemoveEnabled")
    def cpu_hot_remove_enabled(self) -> bool:
        """
        Gets or sets a value indicating whether virtual processors can be removed while this virtual machine is running.
        """
        return pulumi.get(self, "cpu_hot_remove_enabled")

    @property
    @pulumi.getter(name="memoryHotAddEnabled")
    def memory_hot_add_enabled(self) -> bool:
        """
        Gets or sets a value indicating whether memory can be added while this virtual machine is running.
        """
        return pulumi.get(self, "memory_hot_add_enabled")

    @property
    @pulumi.getter(name="memorySizeMB")
    def memory_size_mb(self) -> Optional[int]:
        """
        Gets or sets memory size in MBs for the vm.
        """
        return pulumi.get(self, "memory_size_mb")

    @property
    @pulumi.getter(name="numCPUs")
    def num_cpus(self) -> Optional[int]:
        """
        Gets or sets the number of vCPUs for the vm.
        """
        return pulumi.get(self, "num_cpus")

    @property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> Optional[int]:
        """
        Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
        """
        return pulumi.get(self, "num_cores_per_socket")


@pulumi.output_type
class HttpProxyConfigurationResponse(dict):
    """
    HTTP Proxy configuration for the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpsProxy":
            suggest = "https_proxy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpProxyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpProxyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpProxyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 https_proxy: Optional[str] = None):
        """
        HTTP Proxy configuration for the VM.
        :param str https_proxy: Gets or sets httpsProxy url.
        """
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)

    @property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[str]:
        """
        Gets or sets httpsProxy url.
        """
        return pulumi.get(self, "https_proxy")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Managed service identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str):
        """
        Managed service identity.
        :param str principal_id: The principal id of managed service identity.
        :param str tenant_id: The tenant of managed service identity.
        :param str type: The type of managed service identity.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of managed service identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant of managed service identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of managed service identity.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MachineExtensionInstanceViewResponseStatus(dict):
    """
    Instance view status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionInstanceViewResponseStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 display_status: str,
                 level: str,
                 message: str,
                 time: str):
        """
        Instance view status.
        :param str code: The status code.
        :param str display_status: The short localizable label for the status.
        :param str level: The level code.
        :param str message: The detailed status message, including for alerts and error messages.
        :param str time: The time of the status.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "display_status", display_status)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> str:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class MachineExtensionPropertiesResponseInstanceView(dict):
    """
    The machine extension instance view.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionPropertiesResponseInstanceView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionPropertiesResponseInstanceView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionPropertiesResponseInstanceView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 type_handler_version: str,
                 status: Optional['outputs.MachineExtensionInstanceViewResponseStatus'] = None):
        """
        The machine extension instance view.
        :param str name: The machine extension name.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        :param 'MachineExtensionInstanceViewResponseStatus' status: Instance view status.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The machine extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> str:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.MachineExtensionInstanceViewResponseStatus']:
        """
        Instance view status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkInterfaceResponse(dict):
    """
    Network Interface model
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "networkMoName":
            suggest = "network_mo_name"
        elif key == "networkMoRefId":
            suggest = "network_mo_ref_id"
        elif key == "deviceKey":
            suggest = "device_key"
        elif key == "ipSettings":
            suggest = "ip_settings"
        elif key == "networkId":
            suggest = "network_id"
        elif key == "nicType":
            suggest = "nic_type"
        elif key == "powerOnBoot":
            suggest = "power_on_boot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_addresses: Sequence[str],
                 label: str,
                 mac_address: str,
                 network_mo_name: str,
                 network_mo_ref_id: str,
                 device_key: Optional[int] = None,
                 ip_settings: Optional['outputs.NicIPSettingsResponse'] = None,
                 name: Optional[str] = None,
                 network_id: Optional[str] = None,
                 nic_type: Optional[str] = None,
                 power_on_boot: Optional[str] = None):
        """
        Network Interface model
        :param Sequence[str] ip_addresses: Gets or sets the nic ip addresses.
        :param str label: Gets or sets the label of the virtual network in vCenter that the nic is connected to.
        :param str mac_address: Gets or sets the NIC MAC address.
        :param str network_mo_name: Gets or sets the name of the virtual network in vCenter that the nic is connected to.
        :param str network_mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID of the virtual network
               that the nic is connected to.
        :param int device_key: Gets or sets the device key value.
        :param 'NicIPSettingsResponse' ip_settings: Gets or sets the ipsettings.
        :param str name: Gets or sets the name of the network interface.
        :param str network_id: Gets or sets the ARM Id of the network resource to connect the virtual machine.
        :param str nic_type: NIC type
        :param str power_on_boot: Gets or sets the power on boot.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "network_mo_name", network_mo_name)
        pulumi.set(__self__, "network_mo_ref_id", network_mo_ref_id)
        if device_key is not None:
            pulumi.set(__self__, "device_key", device_key)
        if ip_settings is not None:
            pulumi.set(__self__, "ip_settings", ip_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if nic_type is not None:
            pulumi.set(__self__, "nic_type", nic_type)
        if power_on_boot is not None:
            pulumi.set(__self__, "power_on_boot", power_on_boot)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        Gets or sets the nic ip addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Gets or sets the label of the virtual network in vCenter that the nic is connected to.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        Gets or sets the NIC MAC address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="networkMoName")
    def network_mo_name(self) -> str:
        """
        Gets or sets the name of the virtual network in vCenter that the nic is connected to.
        """
        return pulumi.get(self, "network_mo_name")

    @property
    @pulumi.getter(name="networkMoRefId")
    def network_mo_ref_id(self) -> str:
        """
        Gets or sets the vCenter MoRef (Managed Object Reference) ID of the virtual network
        that the nic is connected to.
        """
        return pulumi.get(self, "network_mo_ref_id")

    @property
    @pulumi.getter(name="deviceKey")
    def device_key(self) -> Optional[int]:
        """
        Gets or sets the device key value.
        """
        return pulumi.get(self, "device_key")

    @property
    @pulumi.getter(name="ipSettings")
    def ip_settings(self) -> Optional['outputs.NicIPSettingsResponse']:
        """
        Gets or sets the ipsettings.
        """
        return pulumi.get(self, "ip_settings")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the network interface.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[str]:
        """
        Gets or sets the ARM Id of the network resource to connect the virtual machine.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> Optional[str]:
        """
        NIC type
        """
        return pulumi.get(self, "nic_type")

    @property
    @pulumi.getter(name="powerOnBoot")
    def power_on_boot(self) -> Optional[str]:
        """
        Gets or sets the power on boot.
        """
        return pulumi.get(self, "power_on_boot")


@pulumi.output_type
class NetworkProfileResponse(dict):
    """
    Defines the resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Optional[Sequence['outputs.NetworkInterfaceResponse']] = None):
        """
        Defines the resource properties.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: Gets or sets the list of network interfaces associated with the virtual machine.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.NetworkInterfaceResponse']]:
        """
        Gets or sets the list of network interfaces associated with the virtual machine.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class NicIPAddressSettingsResponse(dict):
    """
    IP address information for a virtual network adapter reported by the fabric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationMethod":
            suggest = "allocation_method"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "subnetMask":
            suggest = "subnet_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NicIPAddressSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NicIPAddressSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NicIPAddressSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_method: str,
                 ip_address: str,
                 subnet_mask: str):
        """
        IP address information for a virtual network adapter reported by the fabric.
        :param str allocation_method: Gets the ip address allocation method.
        :param str ip_address: Gets the ip address for the nic.
        :param str subnet_mask: Gets the mask.
        """
        pulumi.set(__self__, "allocation_method", allocation_method)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "subnet_mask", subnet_mask)

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> str:
        """
        Gets the ip address allocation method.
        """
        return pulumi.get(self, "allocation_method")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Gets the ip address for the nic.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> str:
        """
        Gets the mask.
        """
        return pulumi.get(self, "subnet_mask")


@pulumi.output_type
class NicIPSettingsResponse(dict):
    """
    Defines the network interface ip settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressInfo":
            suggest = "ip_address_info"
        elif key == "primaryWinsServer":
            suggest = "primary_wins_server"
        elif key == "secondaryWinsServer":
            suggest = "secondary_wins_server"
        elif key == "allocationMethod":
            suggest = "allocation_method"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "subnetMask":
            suggest = "subnet_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NicIPSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NicIPSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NicIPSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address_info: Sequence['outputs.NicIPAddressSettingsResponse'],
                 primary_wins_server: str,
                 secondary_wins_server: str,
                 allocation_method: Optional[str] = None,
                 dns_servers: Optional[Sequence[str]] = None,
                 gateway: Optional[Sequence[str]] = None,
                 ip_address: Optional[str] = None,
                 subnet_mask: Optional[str] = None):
        """
        Defines the network interface ip settings.
        :param Sequence['NicIPAddressSettingsResponse'] ip_address_info: Gets or sets the IP address information being reported for this NIC. This contains the same IPv4 information above plus IPV6 information.
        :param str primary_wins_server: Gets or sets the primary server.
        :param str secondary_wins_server: Gets or sets the secondary server.
        :param str allocation_method: Gets or sets the nic allocation method.
        :param Sequence[str] dns_servers: Gets or sets the dns servers.
        :param Sequence[str] gateway: Gets or sets the gateway.
        :param str ip_address: Gets or sets the ip address for the nic.
        :param str subnet_mask: Gets or sets the mask.
        """
        pulumi.set(__self__, "ip_address_info", ip_address_info)
        pulumi.set(__self__, "primary_wins_server", primary_wins_server)
        pulumi.set(__self__, "secondary_wins_server", secondary_wins_server)
        if allocation_method is not None:
            pulumi.set(__self__, "allocation_method", allocation_method)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)

    @property
    @pulumi.getter(name="ipAddressInfo")
    def ip_address_info(self) -> Sequence['outputs.NicIPAddressSettingsResponse']:
        """
        Gets or sets the IP address information being reported for this NIC. This contains the same IPv4 information above plus IPV6 information.
        """
        return pulumi.get(self, "ip_address_info")

    @property
    @pulumi.getter(name="primaryWinsServer")
    def primary_wins_server(self) -> str:
        """
        Gets or sets the primary server.
        """
        return pulumi.get(self, "primary_wins_server")

    @property
    @pulumi.getter(name="secondaryWinsServer")
    def secondary_wins_server(self) -> str:
        """
        Gets or sets the secondary server.
        """
        return pulumi.get(self, "secondary_wins_server")

    @property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> Optional[str]:
        """
        Gets or sets the nic allocation method.
        """
        return pulumi.get(self, "allocation_method")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the dns servers.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the gateway.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Gets or sets the ip address for the nic.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[str]:
        """
        Gets or sets the mask.
        """
        return pulumi.get(self, "subnet_mask")


@pulumi.output_type
class OsProfileResponse(dict):
    """
    Defines the resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osName":
            suggest = "os_name"
        elif key == "toolsRunningStatus":
            suggest = "tools_running_status"
        elif key == "toolsVersion":
            suggest = "tools_version"
        elif key == "toolsVersionStatus":
            suggest = "tools_version_status"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_name: str,
                 tools_running_status: str,
                 tools_version: str,
                 tools_version_status: str,
                 admin_username: Optional[str] = None,
                 computer_name: Optional[str] = None,
                 os_type: Optional[str] = None):
        """
        Defines the resource properties.
        :param str os_name: Gets or sets os name.
        :param str tools_running_status: Gets or sets the current running status of VMware Tools running in the guest operating system.
        :param str tools_version: Gets or sets the current version of VMware Tools.
        :param str tools_version_status: Gets or sets the current version status of VMware Tools installed in the guest operating system.
        :param str admin_username: Gets or sets administrator username.
        :param str computer_name: Gets or sets computer name.
        :param str os_type: Gets or sets the type of the os.
        """
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "tools_running_status", tools_running_status)
        pulumi.set(__self__, "tools_version", tools_version)
        pulumi.set(__self__, "tools_version_status", tools_version_status)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        Gets or sets os name.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="toolsRunningStatus")
    def tools_running_status(self) -> str:
        """
        Gets or sets the current running status of VMware Tools running in the guest operating system.
        """
        return pulumi.get(self, "tools_running_status")

    @property
    @pulumi.getter(name="toolsVersion")
    def tools_version(self) -> str:
        """
        Gets or sets the current version of VMware Tools.
        """
        return pulumi.get(self, "tools_version")

    @property
    @pulumi.getter(name="toolsVersionStatus")
    def tools_version_status(self) -> str:
        """
        Gets or sets the current version status of VMware Tools installed in the guest operating system.
        """
        return pulumi.get(self, "tools_version_status")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Gets or sets administrator username.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        Gets or sets computer name.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        Gets or sets the type of the os.
        """
        return pulumi.get(self, "os_type")


@pulumi.output_type
class PlacementProfileResponse(dict):
    """
    Defines the resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "datastoreId":
            suggest = "datastore_id"
        elif key == "hostId":
            suggest = "host_id"
        elif key == "resourcePoolId":
            suggest = "resource_pool_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlacementProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlacementProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlacementProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: Optional[str] = None,
                 datastore_id: Optional[str] = None,
                 host_id: Optional[str] = None,
                 resource_pool_id: Optional[str] = None):
        """
        Defines the resource properties.
        :param str cluster_id: Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
        :param str datastore_id: Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
        :param str host_id: Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
        :param str resource_pool_id: Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if resource_pool_id is not None:
            pulumi.set(__self__, "resource_pool_id", resource_pool_id)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[str]:
        """
        Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="resourcePoolId")
    def resource_pool_id(self) -> Optional[str]:
        """
        Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
        """
        return pulumi.get(self, "resource_pool_id")


@pulumi.output_type
class ResourceStatusResponse(dict):
    """
    The resource status information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedAt":
            suggest = "last_updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated_at: str,
                 message: str,
                 reason: str,
                 severity: str,
                 status: str,
                 type: str):
        """
        The resource status information.
        :param str last_updated_at: The last update time for this condition.
        :param str message: A human readable message indicating details about the status.
        :param str reason: The reason for the condition's status.
        :param str severity: Severity with which to treat failures of this type of condition.
        :param str status: Status of the condition.
        :param str type: The type of the condition.
        """
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> str:
        """
        The last update time for this condition.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human readable message indicating details about the status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        The reason for the condition's status.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Severity with which to treat failures of this type of condition.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StorageProfileResponse(dict):
    """
    Defines the resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scsiControllers":
            suggest = "scsi_controllers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scsi_controllers: Sequence['outputs.VirtualSCSIControllerResponse'],
                 disks: Optional[Sequence['outputs.VirtualDiskResponse']] = None):
        """
        Defines the resource properties.
        :param Sequence['VirtualSCSIControllerResponse'] scsi_controllers: Gets or sets the list of virtual SCSI controllers associated with the virtual machine.
        :param Sequence['VirtualDiskResponse'] disks: Gets or sets the list of virtual disks associated with the virtual machine.
        """
        pulumi.set(__self__, "scsi_controllers", scsi_controllers)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)

    @property
    @pulumi.getter(name="scsiControllers")
    def scsi_controllers(self) -> Sequence['outputs.VirtualSCSIControllerResponse']:
        """
        Gets or sets the list of virtual SCSI controllers associated with the virtual machine.
        """
        return pulumi.get(self, "scsi_controllers")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.VirtualDiskResponse']]:
        """
        Gets or sets the list of virtual disks associated with the virtual machine.
        """
        return pulumi.get(self, "disks")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class VICredentialResponse(dict):
    """
    Username / Password Credentials to connect to vcenter.
    """
    def __init__(__self__, *,
                 username: Optional[str] = None):
        """
        Username / Password Credentials to connect to vcenter.
        :param str username: Gets or sets username to connect with the vCenter.
        """
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Gets or sets username to connect with the vCenter.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class VirtualDiskResponse(dict):
    """
    Virtual disk model
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskObjectId":
            suggest = "disk_object_id"
        elif key == "controllerKey":
            suggest = "controller_key"
        elif key == "deviceKey":
            suggest = "device_key"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "diskMode":
            suggest = "disk_mode"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "unitNumber":
            suggest = "unit_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_object_id: str,
                 label: str,
                 controller_key: Optional[int] = None,
                 device_key: Optional[int] = None,
                 device_name: Optional[str] = None,
                 disk_mode: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 disk_type: Optional[str] = None,
                 name: Optional[str] = None,
                 unit_number: Optional[int] = None):
        """
        Virtual disk model
        :param str disk_object_id: Gets or sets the disk object id.
        :param str label: Gets or sets the label of the virtual disk in vCenter.
        :param int controller_key: Gets or sets the controller id.
        :param int device_key: Gets or sets the device key value.
        :param str device_name: Gets or sets the device name.
        :param str disk_mode: Gets or sets the disk mode.
        :param int disk_size_gb: Gets or sets the disk total size.
        :param str disk_type: Gets or sets the disk backing type.
        :param str name: Gets or sets the name of the virtual disk.
        :param int unit_number: Gets or sets the unit number of the disk on the controller.
        """
        pulumi.set(__self__, "disk_object_id", disk_object_id)
        pulumi.set(__self__, "label", label)
        if controller_key is not None:
            pulumi.set(__self__, "controller_key", controller_key)
        if device_key is not None:
            pulumi.set(__self__, "device_key", device_key)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if disk_mode is not None:
            pulumi.set(__self__, "disk_mode", disk_mode)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unit_number is not None:
            pulumi.set(__self__, "unit_number", unit_number)

    @property
    @pulumi.getter(name="diskObjectId")
    def disk_object_id(self) -> str:
        """
        Gets or sets the disk object id.
        """
        return pulumi.get(self, "disk_object_id")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Gets or sets the label of the virtual disk in vCenter.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="controllerKey")
    def controller_key(self) -> Optional[int]:
        """
        Gets or sets the controller id.
        """
        return pulumi.get(self, "controller_key")

    @property
    @pulumi.getter(name="deviceKey")
    def device_key(self) -> Optional[int]:
        """
        Gets or sets the device key value.
        """
        return pulumi.get(self, "device_key")

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[str]:
        """
        Gets or sets the device name.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="diskMode")
    def disk_mode(self) -> Optional[str]:
        """
        Gets or sets the disk mode.
        """
        return pulumi.get(self, "disk_mode")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Gets or sets the disk total size.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        Gets or sets the disk backing type.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the virtual disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> Optional[int]:
        """
        Gets or sets the unit number of the disk on the controller.
        """
        return pulumi.get(self, "unit_number")


@pulumi.output_type
class VirtualSCSIControllerResponse(dict):
    """
    This data object type contains the properties of a SCSI controller device attached to a virtual machine that is reported by the controller.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "busNumber":
            suggest = "bus_number"
        elif key == "controllerKey":
            suggest = "controller_key"
        elif key == "scsiCtlrUnitNumber":
            suggest = "scsi_ctlr_unit_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualSCSIControllerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualSCSIControllerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualSCSIControllerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bus_number: Optional[int] = None,
                 controller_key: Optional[int] = None,
                 scsi_ctlr_unit_number: Optional[int] = None,
                 sharing: Optional[str] = None,
                 type: Optional[str] = None):
        """
        This data object type contains the properties of a SCSI controller device attached to a virtual machine that is reported by the controller.
        :param int bus_number: Gets or sets the bus number of the controller.
        :param int controller_key: Gets or sets the key of the controller.
        :param int scsi_ctlr_unit_number: Gets or sets the SCSI controller unit number.
        :param str sharing: Gets or sets the sharing mode.
        :param str type: Gets or sets the controller type.
        """
        if bus_number is not None:
            pulumi.set(__self__, "bus_number", bus_number)
        if controller_key is not None:
            pulumi.set(__self__, "controller_key", controller_key)
        if scsi_ctlr_unit_number is not None:
            pulumi.set(__self__, "scsi_ctlr_unit_number", scsi_ctlr_unit_number)
        if sharing is not None:
            pulumi.set(__self__, "sharing", sharing)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="busNumber")
    def bus_number(self) -> Optional[int]:
        """
        Gets or sets the bus number of the controller.
        """
        return pulumi.get(self, "bus_number")

    @property
    @pulumi.getter(name="controllerKey")
    def controller_key(self) -> Optional[int]:
        """
        Gets or sets the key of the controller.
        """
        return pulumi.get(self, "controller_key")

    @property
    @pulumi.getter(name="scsiCtlrUnitNumber")
    def scsi_ctlr_unit_number(self) -> Optional[int]:
        """
        Gets or sets the SCSI controller unit number.
        """
        return pulumi.get(self, "scsi_ctlr_unit_number")

    @property
    @pulumi.getter
    def sharing(self) -> Optional[str]:
        """
        Gets or sets the sharing mode.
        """
        return pulumi.get(self, "sharing")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the controller type.
        """
        return pulumi.get(self, "type")


