# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConfigurationParameterResponse',
    'ConfigurationSettingResponse',
    'GuestConfigurationAssignmentPropertiesResponse',
    'GuestConfigurationNavigationResponse',
    'VMSSVMInfoResponse',
]

@pulumi.output_type
class ConfigurationParameterResponse(dict):
    """
    Represents a configuration parameter.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Represents a configuration parameter.
        :param str name: Name of the configuration parameter.
        :param str value: Value of the configuration parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the configuration parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of the configuration parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConfigurationSettingResponse(dict):
    """
    Configuration setting of LCM (Local Configuration Manager).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionAfterReboot":
            suggest = "action_after_reboot"
        elif key == "allowModuleOverwrite":
            suggest = "allow_module_overwrite"
        elif key == "configurationMode":
            suggest = "configuration_mode"
        elif key == "configurationModeFrequencyMins":
            suggest = "configuration_mode_frequency_mins"
        elif key == "rebootIfNeeded":
            suggest = "reboot_if_needed"
        elif key == "refreshFrequencyMins":
            suggest = "refresh_frequency_mins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationSettingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationSettingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationSettingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_after_reboot: Optional[str] = None,
                 allow_module_overwrite: Optional[bool] = None,
                 configuration_mode: Optional[str] = None,
                 configuration_mode_frequency_mins: Optional[float] = None,
                 reboot_if_needed: Optional[bool] = None,
                 refresh_frequency_mins: Optional[float] = None):
        """
        Configuration setting of LCM (Local Configuration Manager).
        :param str action_after_reboot: Specifies what happens after a reboot during the application of a configuration. The possible values are ContinueConfiguration and StopConfiguration
        :param bool allow_module_overwrite: If true - new configurations downloaded from the pull service are allowed to overwrite the old ones on the target node. Otherwise, false
        :param str configuration_mode: Specifies how the LCM(Local Configuration Manager) actually applies the configuration to the target nodes. Possible values are ApplyOnly, ApplyAndMonitor, and ApplyAndAutoCorrect.
        :param float configuration_mode_frequency_mins: How often, in minutes, the current configuration is checked and applied. This property is ignored if the ConfigurationMode property is set to ApplyOnly. The default value is 15.
        :param bool reboot_if_needed: Set this to true to automatically reboot the node after a configuration that requires reboot is applied. Otherwise, you will have to manually reboot the node for any configuration that requires it. The default value is false. To use this setting when a reboot condition is enacted by something other than DSC (such as Windows Installer), combine this setting with the xPendingReboot module.
        :param float refresh_frequency_mins: The time interval, in minutes, at which the LCM checks a pull service to get updated configurations. This value is ignored if the LCM is not configured in pull mode. The default value is 30.
        """
        if action_after_reboot is not None:
            pulumi.set(__self__, "action_after_reboot", action_after_reboot)
        if allow_module_overwrite is not None:
            pulumi.set(__self__, "allow_module_overwrite", allow_module_overwrite)
        if configuration_mode is not None:
            pulumi.set(__self__, "configuration_mode", configuration_mode)
        if configuration_mode_frequency_mins is None:
            configuration_mode_frequency_mins = 15
        if configuration_mode_frequency_mins is not None:
            pulumi.set(__self__, "configuration_mode_frequency_mins", configuration_mode_frequency_mins)
        if reboot_if_needed is not None:
            pulumi.set(__self__, "reboot_if_needed", reboot_if_needed)
        if refresh_frequency_mins is None:
            refresh_frequency_mins = 30
        if refresh_frequency_mins is not None:
            pulumi.set(__self__, "refresh_frequency_mins", refresh_frequency_mins)

    @property
    @pulumi.getter(name="actionAfterReboot")
    def action_after_reboot(self) -> Optional[str]:
        """
        Specifies what happens after a reboot during the application of a configuration. The possible values are ContinueConfiguration and StopConfiguration
        """
        return pulumi.get(self, "action_after_reboot")

    @property
    @pulumi.getter(name="allowModuleOverwrite")
    def allow_module_overwrite(self) -> Optional[bool]:
        """
        If true - new configurations downloaded from the pull service are allowed to overwrite the old ones on the target node. Otherwise, false
        """
        return pulumi.get(self, "allow_module_overwrite")

    @property
    @pulumi.getter(name="configurationMode")
    def configuration_mode(self) -> Optional[str]:
        """
        Specifies how the LCM(Local Configuration Manager) actually applies the configuration to the target nodes. Possible values are ApplyOnly, ApplyAndMonitor, and ApplyAndAutoCorrect.
        """
        return pulumi.get(self, "configuration_mode")

    @property
    @pulumi.getter(name="configurationModeFrequencyMins")
    def configuration_mode_frequency_mins(self) -> Optional[float]:
        """
        How often, in minutes, the current configuration is checked and applied. This property is ignored if the ConfigurationMode property is set to ApplyOnly. The default value is 15.
        """
        return pulumi.get(self, "configuration_mode_frequency_mins")

    @property
    @pulumi.getter(name="rebootIfNeeded")
    def reboot_if_needed(self) -> Optional[bool]:
        """
        Set this to true to automatically reboot the node after a configuration that requires reboot is applied. Otherwise, you will have to manually reboot the node for any configuration that requires it. The default value is false. To use this setting when a reboot condition is enacted by something other than DSC (such as Windows Installer), combine this setting with the xPendingReboot module.
        """
        return pulumi.get(self, "reboot_if_needed")

    @property
    @pulumi.getter(name="refreshFrequencyMins")
    def refresh_frequency_mins(self) -> Optional[float]:
        """
        The time interval, in minutes, at which the LCM checks a pull service to get updated configurations. This value is ignored if the LCM is not configured in pull mode. The default value is 30.
        """
        return pulumi.get(self, "refresh_frequency_mins")


@pulumi.output_type
class GuestConfigurationAssignmentPropertiesResponse(dict):
    """
    Guest configuration assignment properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignmentHash":
            suggest = "assignment_hash"
        elif key == "complianceStatus":
            suggest = "compliance_status"
        elif key == "lastComplianceStatusChecked":
            suggest = "last_compliance_status_checked"
        elif key == "latestReportId":
            suggest = "latest_report_id"
        elif key == "parameterHash":
            suggest = "parameter_hash"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "guestConfiguration":
            suggest = "guest_configuration"
        elif key == "vmssVMList":
            suggest = "vmss_vm_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestConfigurationAssignmentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestConfigurationAssignmentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestConfigurationAssignmentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assignment_hash: str,
                 compliance_status: str,
                 last_compliance_status_checked: str,
                 latest_report_id: str,
                 parameter_hash: str,
                 provisioning_state: str,
                 resource_type: str,
                 context: Optional[str] = None,
                 guest_configuration: Optional['outputs.GuestConfigurationNavigationResponse'] = None,
                 vmss_vm_list: Optional[Sequence['outputs.VMSSVMInfoResponse']] = None):
        """
        Guest configuration assignment properties.
        :param str assignment_hash: Combined hash of the configuration package and parameters.
        :param str compliance_status: A value indicating compliance status of the machine for the assigned guest configuration.
        :param str last_compliance_status_checked: Date and time when last compliance status was checked.
        :param str latest_report_id: Id of the latest report for the guest configuration assignment. 
        :param str parameter_hash: parameter hash for the guest configuration assignment. 
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param str resource_type: Type of the resource - VMSS / VM
        :param str context: The source which initiated the guest configuration assignment. Ex: Azure Policy
        :param 'GuestConfigurationNavigationResponse' guest_configuration: The guest configuration to assign.
        :param Sequence['VMSSVMInfoResponse'] vmss_vm_list: The list of VM Compliance data for VMSS
        """
        pulumi.set(__self__, "assignment_hash", assignment_hash)
        pulumi.set(__self__, "compliance_status", compliance_status)
        pulumi.set(__self__, "last_compliance_status_checked", last_compliance_status_checked)
        pulumi.set(__self__, "latest_report_id", latest_report_id)
        pulumi.set(__self__, "parameter_hash", parameter_hash)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_type", resource_type)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if guest_configuration is not None:
            pulumi.set(__self__, "guest_configuration", guest_configuration)
        if vmss_vm_list is not None:
            pulumi.set(__self__, "vmss_vm_list", vmss_vm_list)

    @property
    @pulumi.getter(name="assignmentHash")
    def assignment_hash(self) -> str:
        """
        Combined hash of the configuration package and parameters.
        """
        return pulumi.get(self, "assignment_hash")

    @property
    @pulumi.getter(name="complianceStatus")
    def compliance_status(self) -> str:
        """
        A value indicating compliance status of the machine for the assigned guest configuration.
        """
        return pulumi.get(self, "compliance_status")

    @property
    @pulumi.getter(name="lastComplianceStatusChecked")
    def last_compliance_status_checked(self) -> str:
        """
        Date and time when last compliance status was checked.
        """
        return pulumi.get(self, "last_compliance_status_checked")

    @property
    @pulumi.getter(name="latestReportId")
    def latest_report_id(self) -> str:
        """
        Id of the latest report for the guest configuration assignment. 
        """
        return pulumi.get(self, "latest_report_id")

    @property
    @pulumi.getter(name="parameterHash")
    def parameter_hash(self) -> str:
        """
        parameter hash for the guest configuration assignment. 
        """
        return pulumi.get(self, "parameter_hash")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of the resource - VMSS / VM
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        The source which initiated the guest configuration assignment. Ex: Azure Policy
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="guestConfiguration")
    def guest_configuration(self) -> Optional['outputs.GuestConfigurationNavigationResponse']:
        """
        The guest configuration to assign.
        """
        return pulumi.get(self, "guest_configuration")

    @property
    @pulumi.getter(name="vmssVMList")
    def vmss_vm_list(self) -> Optional[Sequence['outputs.VMSSVMInfoResponse']]:
        """
        The list of VM Compliance data for VMSS
        """
        return pulumi.get(self, "vmss_vm_list")


@pulumi.output_type
class GuestConfigurationNavigationResponse(dict):
    """
    Guest configuration is an artifact that encapsulates DSC configuration and its dependencies. The artifact is a zip file containing DSC configuration (as MOF) and dependent resources and other dependencies like modules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "assignmentType":
            suggest = "assignment_type"
        elif key == "configurationParameter":
            suggest = "configuration_parameter"
        elif key == "configurationProtectedParameter":
            suggest = "configuration_protected_parameter"
        elif key == "configurationSetting":
            suggest = "configuration_setting"
        elif key == "contentHash":
            suggest = "content_hash"
        elif key == "contentUri":
            suggest = "content_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuestConfigurationNavigationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuestConfigurationNavigationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuestConfigurationNavigationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 assignment_type: Optional[str] = None,
                 configuration_parameter: Optional[Sequence['outputs.ConfigurationParameterResponse']] = None,
                 configuration_protected_parameter: Optional[Sequence['outputs.ConfigurationParameterResponse']] = None,
                 configuration_setting: Optional['outputs.ConfigurationSettingResponse'] = None,
                 content_hash: Optional[str] = None,
                 content_uri: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Guest configuration is an artifact that encapsulates DSC configuration and its dependencies. The artifact is a zip file containing DSC configuration (as MOF) and dependent resources and other dependencies like modules.
        :param str content_type: Specifies the content type of the configuration. Possible values could be Builtin or Custom.
        :param str assignment_type: Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
        :param Sequence['ConfigurationParameterResponse'] configuration_parameter: The configuration parameters for the guest configuration.
        :param Sequence['ConfigurationParameterResponse'] configuration_protected_parameter: The protected configuration parameters for the guest configuration.
        :param 'ConfigurationSettingResponse' configuration_setting: The configuration setting for the guest configuration.
        :param str content_hash: Combined hash of the guest configuration package and configuration parameters.
        :param str content_uri: Uri of the storage where guest configuration package is uploaded.
        :param str kind: Kind of the guest configuration. For example:DSC
        :param str name: Name of the guest configuration.
        :param str version: Version of the guest configuration.
        """
        pulumi.set(__self__, "content_type", content_type)
        if assignment_type is not None:
            pulumi.set(__self__, "assignment_type", assignment_type)
        if configuration_parameter is not None:
            pulumi.set(__self__, "configuration_parameter", configuration_parameter)
        if configuration_protected_parameter is not None:
            pulumi.set(__self__, "configuration_protected_parameter", configuration_protected_parameter)
        if configuration_setting is not None:
            pulumi.set(__self__, "configuration_setting", configuration_setting)
        if content_hash is not None:
            pulumi.set(__self__, "content_hash", content_hash)
        if content_uri is not None:
            pulumi.set(__self__, "content_uri", content_uri)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Specifies the content type of the configuration. Possible values could be Builtin or Custom.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="assignmentType")
    def assignment_type(self) -> Optional[str]:
        """
        Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
        """
        return pulumi.get(self, "assignment_type")

    @property
    @pulumi.getter(name="configurationParameter")
    def configuration_parameter(self) -> Optional[Sequence['outputs.ConfigurationParameterResponse']]:
        """
        The configuration parameters for the guest configuration.
        """
        return pulumi.get(self, "configuration_parameter")

    @property
    @pulumi.getter(name="configurationProtectedParameter")
    def configuration_protected_parameter(self) -> Optional[Sequence['outputs.ConfigurationParameterResponse']]:
        """
        The protected configuration parameters for the guest configuration.
        """
        return pulumi.get(self, "configuration_protected_parameter")

    @property
    @pulumi.getter(name="configurationSetting")
    def configuration_setting(self) -> Optional['outputs.ConfigurationSettingResponse']:
        """
        The configuration setting for the guest configuration.
        """
        return pulumi.get(self, "configuration_setting")

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> Optional[str]:
        """
        Combined hash of the guest configuration package and configuration parameters.
        """
        return pulumi.get(self, "content_hash")

    @property
    @pulumi.getter(name="contentUri")
    def content_uri(self) -> Optional[str]:
        """
        Uri of the storage where guest configuration package is uploaded.
        """
        return pulumi.get(self, "content_uri")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of the guest configuration. For example:DSC
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the guest configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the guest configuration.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VMSSVMInfoResponse(dict):
    """
    Information about VMSS VM
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "complianceStatus":
            suggest = "compliance_status"
        elif key == "lastComplianceChecked":
            suggest = "last_compliance_checked"
        elif key == "latestReportId":
            suggest = "latest_report_id"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "vmResourceId":
            suggest = "vm_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMSSVMInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMSSVMInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMSSVMInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compliance_status: str,
                 last_compliance_checked: str,
                 latest_report_id: str,
                 vm_id: str,
                 vm_resource_id: str):
        """
        Information about VMSS VM
        :param str compliance_status: A value indicating compliance status of the machine for the assigned guest configuration.
        :param str last_compliance_checked: Date and time when last compliance status was checked.
        :param str latest_report_id: Id of the latest report for the guest configuration assignment. 
        :param str vm_id: UUID of the VM.
        :param str vm_resource_id: Azure resource Id of the VM.
        """
        pulumi.set(__self__, "compliance_status", compliance_status)
        pulumi.set(__self__, "last_compliance_checked", last_compliance_checked)
        pulumi.set(__self__, "latest_report_id", latest_report_id)
        pulumi.set(__self__, "vm_id", vm_id)
        pulumi.set(__self__, "vm_resource_id", vm_resource_id)

    @property
    @pulumi.getter(name="complianceStatus")
    def compliance_status(self) -> str:
        """
        A value indicating compliance status of the machine for the assigned guest configuration.
        """
        return pulumi.get(self, "compliance_status")

    @property
    @pulumi.getter(name="lastComplianceChecked")
    def last_compliance_checked(self) -> str:
        """
        Date and time when last compliance status was checked.
        """
        return pulumi.get(self, "last_compliance_checked")

    @property
    @pulumi.getter(name="latestReportId")
    def latest_report_id(self) -> str:
        """
        Id of the latest report for the guest configuration assignment. 
        """
        return pulumi.get(self, "latest_report_id")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> str:
        """
        UUID of the VM.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmResourceId")
    def vm_resource_id(self) -> str:
        """
        Azure resource Id of the VM.
        """
        return pulumi.get(self, "vm_resource_id")


