# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AbsoluteDeleteOptionResponse',
    'AdhocBasedTaggingCriteriaResponse',
    'AdhocBasedTriggerContextResponse',
    'AzureBackupParamsResponse',
    'AzureBackupRuleResponse',
    'AzureMonitorAlertSettingsResponse',
    'AzureOperationalStoreParametersResponse',
    'AzureRetentionRuleResponse',
    'BackupInstanceResponse',
    'BackupPolicyResponse',
    'BackupScheduleResponse',
    'BackupVaultResponse',
    'CopyOnExpiryOptionResponse',
    'CustomCopyOptionResponse',
    'DataStoreInfoBaseResponse',
    'DatasourceResponse',
    'DatasourceSetResponse',
    'DayResponse',
    'DppIdentityDetailsResponse',
    'ImmediateCopyOptionResponse',
    'InnerErrorResponse',
    'MonitoringSettingsResponse',
    'PolicyInfoResponse',
    'PolicyParametersResponse',
    'ProtectionStatusDetailsResponse',
    'ResourceGuardOperationResponse',
    'ResourceGuardResponse',
    'ResourceMoveDetailsResponse',
    'RetentionTagResponse',
    'ScheduleBasedBackupCriteriaResponse',
    'ScheduleBasedTriggerContextResponse',
    'SecretStoreBasedAuthCredentialsResponse',
    'SecretStoreResourceResponse',
    'SourceLifeCycleResponse',
    'StorageSettingResponse',
    'SystemDataResponse',
    'TaggingCriteriaResponse',
    'TargetCopySettingResponse',
    'UserFacingErrorResponse',
]

@pulumi.output_type
class AbsoluteDeleteOptionResponse(dict):
    """
    Delete option with duration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AbsoluteDeleteOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AbsoluteDeleteOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AbsoluteDeleteOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 object_type: str):
        """
        Delete option with duration
        :param str duration: Duration of deletion after given timespan
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'AbsoluteDeleteOption'.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "object_type", 'AbsoluteDeleteOption')

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Duration of deletion after given timespan
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'AbsoluteDeleteOption'.
        """
        return pulumi.get(self, "object_type")


@pulumi.output_type
class AdhocBasedTaggingCriteriaResponse(dict):
    """
    Adhoc backup tagging criteria
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagInfo":
            suggest = "tag_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdhocBasedTaggingCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdhocBasedTaggingCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdhocBasedTaggingCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tag_info: Optional['outputs.RetentionTagResponse'] = None):
        """
        Adhoc backup tagging criteria
        :param 'RetentionTagResponse' tag_info: Retention tag information
        """
        if tag_info is not None:
            pulumi.set(__self__, "tag_info", tag_info)

    @property
    @pulumi.getter(name="tagInfo")
    def tag_info(self) -> Optional['outputs.RetentionTagResponse']:
        """
        Retention tag information
        """
        return pulumi.get(self, "tag_info")


@pulumi.output_type
class AdhocBasedTriggerContextResponse(dict):
    """
    Adhoc trigger context
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"
        elif key == "taggingCriteria":
            suggest = "tagging_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdhocBasedTriggerContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdhocBasedTriggerContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdhocBasedTriggerContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str,
                 tagging_criteria: 'outputs.AdhocBasedTaggingCriteriaResponse'):
        """
        Adhoc trigger context
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'AdhocBasedTriggerContext'.
        :param 'AdhocBasedTaggingCriteriaResponse' tagging_criteria: Tagging Criteria containing retention tag for adhoc backup.
        """
        pulumi.set(__self__, "object_type", 'AdhocBasedTriggerContext')
        pulumi.set(__self__, "tagging_criteria", tagging_criteria)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'AdhocBasedTriggerContext'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="taggingCriteria")
    def tagging_criteria(self) -> 'outputs.AdhocBasedTaggingCriteriaResponse':
        """
        Tagging Criteria containing retention tag for adhoc backup.
        """
        return pulumi.get(self, "tagging_criteria")


@pulumi.output_type
class AzureBackupParamsResponse(dict):
    """
    Azure backup parameters
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupType":
            suggest = "backup_type"
        elif key == "objectType":
            suggest = "object_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBackupParamsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBackupParamsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBackupParamsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_type: str,
                 object_type: str):
        """
        Azure backup parameters
        :param str backup_type: BackupType ; Full/Incremental etc
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'AzureBackupParams'.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "object_type", 'AzureBackupParams')

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> str:
        """
        BackupType ; Full/Incremental etc
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'AzureBackupParams'.
        """
        return pulumi.get(self, "object_type")


@pulumi.output_type
class AzureBackupRuleResponse(dict):
    """
    Azure backup rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStore":
            suggest = "data_store"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "backupParameters":
            suggest = "backup_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBackupRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBackupRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBackupRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store: 'outputs.DataStoreInfoBaseResponse',
                 name: str,
                 object_type: str,
                 trigger: Any,
                 backup_parameters: Optional['outputs.AzureBackupParamsResponse'] = None):
        """
        Azure backup rule
        :param 'DataStoreInfoBaseResponse' data_store: DataStoreInfo base
        :param str object_type: 
               Expected value is 'AzureBackupRule'.
        :param Union['AdhocBasedTriggerContextResponse', 'ScheduleBasedTriggerContextResponse'] trigger: Trigger context
        :param 'AzureBackupParamsResponse' backup_parameters: BackupParameters base
        """
        pulumi.set(__self__, "data_store", data_store)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "object_type", 'AzureBackupRule')
        pulumi.set(__self__, "trigger", trigger)
        if backup_parameters is not None:
            pulumi.set(__self__, "backup_parameters", backup_parameters)

    @property
    @pulumi.getter(name="dataStore")
    def data_store(self) -> 'outputs.DataStoreInfoBaseResponse':
        """
        DataStoreInfo base
        """
        return pulumi.get(self, "data_store")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """

        Expected value is 'AzureBackupRule'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter
    def trigger(self) -> Any:
        """
        Trigger context
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter(name="backupParameters")
    def backup_parameters(self) -> Optional['outputs.AzureBackupParamsResponse']:
        """
        BackupParameters base
        """
        return pulumi.get(self, "backup_parameters")


@pulumi.output_type
class AzureMonitorAlertSettingsResponse(dict):
    """
    Settings for Azure Monitor based alerts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertsForAllJobFailures":
            suggest = "alerts_for_all_job_failures"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMonitorAlertSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMonitorAlertSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMonitorAlertSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts_for_all_job_failures: Optional[str] = None):
        """
        Settings for Azure Monitor based alerts
        """
        if alerts_for_all_job_failures is not None:
            pulumi.set(__self__, "alerts_for_all_job_failures", alerts_for_all_job_failures)

    @property
    @pulumi.getter(name="alertsForAllJobFailures")
    def alerts_for_all_job_failures(self) -> Optional[str]:
        return pulumi.get(self, "alerts_for_all_job_failures")


@pulumi.output_type
class AzureOperationalStoreParametersResponse(dict):
    """
    Parameters for Operational-Tier DataStore
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "resourceGroupId":
            suggest = "resource_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureOperationalStoreParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureOperationalStoreParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureOperationalStoreParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: str,
                 object_type: str,
                 resource_group_id: Optional[str] = None):
        """
        Parameters for Operational-Tier DataStore
        :param str data_store_type: type of datastore; Operational/Vault/Archive
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'AzureOperationalStoreParameters'.
        :param str resource_group_id: Gets or sets the Snapshot Resource Group Uri.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "object_type", 'AzureOperationalStoreParameters')
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)

    @property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> str:
        """
        type of datastore; Operational/Vault/Archive
        """
        return pulumi.get(self, "data_store_type")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'AzureOperationalStoreParameters'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        """
        Gets or sets the Snapshot Resource Group Uri.
        """
        return pulumi.get(self, "resource_group_id")


@pulumi.output_type
class AzureRetentionRuleResponse(dict):
    """
    Azure retention rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"
        elif key == "isDefault":
            suggest = "is_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureRetentionRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureRetentionRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureRetentionRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lifecycles: Sequence['outputs.SourceLifeCycleResponse'],
                 name: str,
                 object_type: str,
                 is_default: Optional[bool] = None):
        """
        Azure retention rule
        :param str object_type: 
               Expected value is 'AzureRetentionRule'.
        """
        pulumi.set(__self__, "lifecycles", lifecycles)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "object_type", 'AzureRetentionRule')
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)

    @property
    @pulumi.getter
    def lifecycles(self) -> Sequence['outputs.SourceLifeCycleResponse']:
        return pulumi.get(self, "lifecycles")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """

        Expected value is 'AzureRetentionRule'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        return pulumi.get(self, "is_default")


@pulumi.output_type
class BackupInstanceResponse(dict):
    """
    Backup Instance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentProtectionState":
            suggest = "current_protection_state"
        elif key == "dataSourceInfo":
            suggest = "data_source_info"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "policyInfo":
            suggest = "policy_info"
        elif key == "protectionErrorDetails":
            suggest = "protection_error_details"
        elif key == "protectionStatus":
            suggest = "protection_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "dataSourceSetInfo":
            suggest = "data_source_set_info"
        elif key == "datasourceAuthCredentials":
            suggest = "datasource_auth_credentials"
        elif key == "friendlyName":
            suggest = "friendly_name"
        elif key == "validationType":
            suggest = "validation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_protection_state: str,
                 data_source_info: 'outputs.DatasourceResponse',
                 object_type: str,
                 policy_info: 'outputs.PolicyInfoResponse',
                 protection_error_details: 'outputs.UserFacingErrorResponse',
                 protection_status: 'outputs.ProtectionStatusDetailsResponse',
                 provisioning_state: str,
                 data_source_set_info: Optional['outputs.DatasourceSetResponse'] = None,
                 datasource_auth_credentials: Optional['outputs.SecretStoreBasedAuthCredentialsResponse'] = None,
                 friendly_name: Optional[str] = None,
                 validation_type: Optional[str] = None):
        """
        Backup Instance
        :param str current_protection_state: Specifies the current protection state of the resource
        :param 'DatasourceResponse' data_source_info: Gets or sets the data source information.
        :param 'PolicyInfoResponse' policy_info: Gets or sets the policy information.
        :param 'UserFacingErrorResponse' protection_error_details: Specifies the protection error of the resource
        :param 'ProtectionStatusDetailsResponse' protection_status: Specifies the protection status of the resource
        :param str provisioning_state: Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed
        :param 'DatasourceSetResponse' data_source_set_info: Gets or sets the data source set information.
        :param 'SecretStoreBasedAuthCredentialsResponse' datasource_auth_credentials: Credentials to use to authenticate with data source provider.
        :param str friendly_name: Gets or sets the Backup Instance friendly name.
        :param str validation_type: Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
        """
        pulumi.set(__self__, "current_protection_state", current_protection_state)
        pulumi.set(__self__, "data_source_info", data_source_info)
        pulumi.set(__self__, "object_type", object_type)
        pulumi.set(__self__, "policy_info", policy_info)
        pulumi.set(__self__, "protection_error_details", protection_error_details)
        pulumi.set(__self__, "protection_status", protection_status)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if data_source_set_info is not None:
            pulumi.set(__self__, "data_source_set_info", data_source_set_info)
        if datasource_auth_credentials is not None:
            pulumi.set(__self__, "datasource_auth_credentials", datasource_auth_credentials)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if validation_type is not None:
            pulumi.set(__self__, "validation_type", validation_type)

    @property
    @pulumi.getter(name="currentProtectionState")
    def current_protection_state(self) -> str:
        """
        Specifies the current protection state of the resource
        """
        return pulumi.get(self, "current_protection_state")

    @property
    @pulumi.getter(name="dataSourceInfo")
    def data_source_info(self) -> 'outputs.DatasourceResponse':
        """
        Gets or sets the data source information.
        """
        return pulumi.get(self, "data_source_info")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="policyInfo")
    def policy_info(self) -> 'outputs.PolicyInfoResponse':
        """
        Gets or sets the policy information.
        """
        return pulumi.get(self, "policy_info")

    @property
    @pulumi.getter(name="protectionErrorDetails")
    def protection_error_details(self) -> 'outputs.UserFacingErrorResponse':
        """
        Specifies the protection error of the resource
        """
        return pulumi.get(self, "protection_error_details")

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> 'outputs.ProtectionStatusDetailsResponse':
        """
        Specifies the protection status of the resource
        """
        return pulumi.get(self, "protection_status")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Specifies the provisioning state of the resource i.e. provisioning/updating/Succeeded/Failed
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="dataSourceSetInfo")
    def data_source_set_info(self) -> Optional['outputs.DatasourceSetResponse']:
        """
        Gets or sets the data source set information.
        """
        return pulumi.get(self, "data_source_set_info")

    @property
    @pulumi.getter(name="datasourceAuthCredentials")
    def datasource_auth_credentials(self) -> Optional['outputs.SecretStoreBasedAuthCredentialsResponse']:
        """
        Credentials to use to authenticate with data source provider.
        """
        return pulumi.get(self, "datasource_auth_credentials")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[str]:
        """
        Gets or sets the Backup Instance friendly name.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="validationType")
    def validation_type(self) -> Optional[str]:
        """
        Specifies the type of validation. In case of DeepValidation, all validations from /validateForBackup API will run again.
        """
        return pulumi.get(self, "validation_type")


@pulumi.output_type
class BackupPolicyResponse(dict):
    """
    Rule based backup policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasourceTypes":
            suggest = "datasource_types"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "policyRules":
            suggest = "policy_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datasource_types: Sequence[str],
                 object_type: str,
                 policy_rules: Sequence[Any]):
        """
        Rule based backup policy
        :param Sequence[str] datasource_types: Type of datasource for the backup management
        :param str object_type: 
               Expected value is 'BackupPolicy'.
        :param Sequence[Union['AzureBackupRuleResponse', 'AzureRetentionRuleResponse']] policy_rules: Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
        """
        pulumi.set(__self__, "datasource_types", datasource_types)
        pulumi.set(__self__, "object_type", 'BackupPolicy')
        pulumi.set(__self__, "policy_rules", policy_rules)

    @property
    @pulumi.getter(name="datasourceTypes")
    def datasource_types(self) -> Sequence[str]:
        """
        Type of datasource for the backup management
        """
        return pulumi.get(self, "datasource_types")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """

        Expected value is 'BackupPolicy'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="policyRules")
    def policy_rules(self) -> Sequence[Any]:
        """
        Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
        """
        return pulumi.get(self, "policy_rules")


@pulumi.output_type
class BackupScheduleResponse(dict):
    """
    Schedule for backup
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repeatingTimeIntervals":
            suggest = "repeating_time_intervals"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repeating_time_intervals: Sequence[str],
                 time_zone: Optional[str] = None):
        """
        Schedule for backup
        :param Sequence[str] repeating_time_intervals: ISO 8601 repeating time interval format
        :param str time_zone: Time zone for a schedule. Example: Pacific Standard Time
        """
        pulumi.set(__self__, "repeating_time_intervals", repeating_time_intervals)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="repeatingTimeIntervals")
    def repeating_time_intervals(self) -> Sequence[str]:
        """
        ISO 8601 repeating time interval format
        """
        return pulumi.get(self, "repeating_time_intervals")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Time zone for a schedule. Example: Pacific Standard Time
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class BackupVaultResponse(dict):
    """
    Backup Vault
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceMoveDetails":
            suggest = "resource_move_details"
        elif key == "resourceMoveState":
            suggest = "resource_move_state"
        elif key == "storageSettings":
            suggest = "storage_settings"
        elif key == "monitoringSettings":
            suggest = "monitoring_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupVaultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupVaultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupVaultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 resource_move_details: 'outputs.ResourceMoveDetailsResponse',
                 resource_move_state: str,
                 storage_settings: Sequence['outputs.StorageSettingResponse'],
                 monitoring_settings: Optional['outputs.MonitoringSettingsResponse'] = None):
        """
        Backup Vault
        :param str provisioning_state: Provisioning state of the BackupVault resource
        :param 'ResourceMoveDetailsResponse' resource_move_details: Resource move details for backup vault
        :param str resource_move_state: Resource move state for backup vault
        :param Sequence['StorageSettingResponse'] storage_settings: Storage Settings
        :param 'MonitoringSettingsResponse' monitoring_settings: Monitoring Settings
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_move_details", resource_move_details)
        pulumi.set(__self__, "resource_move_state", resource_move_state)
        pulumi.set(__self__, "storage_settings", storage_settings)
        if monitoring_settings is not None:
            pulumi.set(__self__, "monitoring_settings", monitoring_settings)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the BackupVault resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceMoveDetails")
    def resource_move_details(self) -> 'outputs.ResourceMoveDetailsResponse':
        """
        Resource move details for backup vault
        """
        return pulumi.get(self, "resource_move_details")

    @property
    @pulumi.getter(name="resourceMoveState")
    def resource_move_state(self) -> str:
        """
        Resource move state for backup vault
        """
        return pulumi.get(self, "resource_move_state")

    @property
    @pulumi.getter(name="storageSettings")
    def storage_settings(self) -> Sequence['outputs.StorageSettingResponse']:
        """
        Storage Settings
        """
        return pulumi.get(self, "storage_settings")

    @property
    @pulumi.getter(name="monitoringSettings")
    def monitoring_settings(self) -> Optional['outputs.MonitoringSettingsResponse']:
        """
        Monitoring Settings
        """
        return pulumi.get(self, "monitoring_settings")


@pulumi.output_type
class CopyOnExpiryOptionResponse(dict):
    """
    Copy on Expiry Option
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyOnExpiryOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyOnExpiryOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyOnExpiryOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str):
        """
        Copy on Expiry Option
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'CopyOnExpiryOption'.
        """
        pulumi.set(__self__, "object_type", 'CopyOnExpiryOption')

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'CopyOnExpiryOption'.
        """
        return pulumi.get(self, "object_type")


@pulumi.output_type
class CustomCopyOptionResponse(dict):
    """
    Duration based custom options to copy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomCopyOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomCopyOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomCopyOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str,
                 duration: Optional[str] = None):
        """
        Duration based custom options to copy
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'CustomCopyOption'.
        :param str duration: Data copied after given timespan
        """
        pulumi.set(__self__, "object_type", 'CustomCopyOption')
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'CustomCopyOption'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        Data copied after given timespan
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class DataStoreInfoBaseResponse(dict):
    """
    DataStoreInfo base
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"
        elif key == "objectType":
            suggest = "object_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataStoreInfoBaseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataStoreInfoBaseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataStoreInfoBaseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: str,
                 object_type: str):
        """
        DataStoreInfo base
        :param str data_store_type: type of datastore; Operational/Vault/Archive
        :param str object_type: Type of Datasource object, used to initialize the right inherited type
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> str:
        """
        type of datastore; Operational/Vault/Archive
        """
        return pulumi.get(self, "data_store_type")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of Datasource object, used to initialize the right inherited type
        """
        return pulumi.get(self, "object_type")


@pulumi.output_type
class DatasourceResponse(dict):
    """
    Datasource to be backed up
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceID":
            suggest = "resource_id"
        elif key == "datasourceType":
            suggest = "datasource_type"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "resourceLocation":
            suggest = "resource_location"
        elif key == "resourceName":
            suggest = "resource_name"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 datasource_type: Optional[str] = None,
                 object_type: Optional[str] = None,
                 resource_location: Optional[str] = None,
                 resource_name: Optional[str] = None,
                 resource_type: Optional[str] = None,
                 resource_uri: Optional[str] = None):
        """
        Datasource to be backed up
        :param str resource_id: Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
        :param str datasource_type: DatasourceType of the resource.
        :param str object_type: Type of Datasource object, used to initialize the right inherited type
        :param str resource_location: Location of datasource.
        :param str resource_name: Unique identifier of the resource in the context of parent.
        :param str resource_type: Resource Type of Datasource.
        :param str resource_uri: Uri of the resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if datasource_type is not None:
            pulumi.set(__self__, "datasource_type", datasource_type)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceID")
    def resource_id(self) -> str:
        """
        Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="datasourceType")
    def datasource_type(self) -> Optional[str]:
        """
        DatasourceType of the resource.
        """
        return pulumi.get(self, "datasource_type")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[str]:
        """
        Type of Datasource object, used to initialize the right inherited type
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[str]:
        """
        Location of datasource.
        """
        return pulumi.get(self, "resource_location")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[str]:
        """
        Unique identifier of the resource in the context of parent.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        Resource Type of Datasource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        Uri of the resource.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class DatasourceSetResponse(dict):
    """
    DatasourceSet details of datasource to be backed up
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceID":
            suggest = "resource_id"
        elif key == "datasourceType":
            suggest = "datasource_type"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "resourceLocation":
            suggest = "resource_location"
        elif key == "resourceName":
            suggest = "resource_name"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasourceSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasourceSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasourceSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 datasource_type: Optional[str] = None,
                 object_type: Optional[str] = None,
                 resource_location: Optional[str] = None,
                 resource_name: Optional[str] = None,
                 resource_type: Optional[str] = None,
                 resource_uri: Optional[str] = None):
        """
        DatasourceSet details of datasource to be backed up
        :param str resource_id: Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
        :param str datasource_type: DatasourceType of the resource.
        :param str object_type: Type of Datasource object, used to initialize the right inherited type
        :param str resource_location: Location of datasource.
        :param str resource_name: Unique identifier of the resource in the context of parent.
        :param str resource_type: Resource Type of Datasource.
        :param str resource_uri: Uri of the resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if datasource_type is not None:
            pulumi.set(__self__, "datasource_type", datasource_type)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceID")
    def resource_id(self) -> str:
        """
        Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="datasourceType")
    def datasource_type(self) -> Optional[str]:
        """
        DatasourceType of the resource.
        """
        return pulumi.get(self, "datasource_type")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[str]:
        """
        Type of Datasource object, used to initialize the right inherited type
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[str]:
        """
        Location of datasource.
        """
        return pulumi.get(self, "resource_location")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[str]:
        """
        Unique identifier of the resource in the context of parent.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        Resource Type of Datasource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        Uri of the resource.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class DayResponse(dict):
    """
    Day of the week
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isLast":
            suggest = "is_last"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[int] = None,
                 is_last: Optional[bool] = None):
        """
        Day of the week
        :param int date: Date of the month
        :param bool is_last: Whether Date is last date of month
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if is_last is not None:
            pulumi.set(__self__, "is_last", is_last)

    @property
    @pulumi.getter
    def date(self) -> Optional[int]:
        """
        Date of the month
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter(name="isLast")
    def is_last(self) -> Optional[bool]:
        """
        Whether Date is last date of month
        """
        return pulumi.get(self, "is_last")


@pulumi.output_type
class DppIdentityDetailsResponse(dict):
    """
    Identity details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DppIdentityDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DppIdentityDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DppIdentityDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity details
        :param str principal_id: The object ID of the service principal object for the managed identity that is used to grant role-based access to an Azure resource.
        :param str tenant_id: A Globally Unique Identifier (GUID) that represents the Azure AD tenant where the resource is now a member.
        :param str type: The identityType which can be either SystemAssigned or None
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The object ID of the service principal object for the managed identity that is used to grant role-based access to an Azure resource.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        A Globally Unique Identifier (GUID) that represents the Azure AD tenant where the resource is now a member.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identityType which can be either SystemAssigned or None
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ImmediateCopyOptionResponse(dict):
    """
    Immediate copy Option
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImmediateCopyOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImmediateCopyOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImmediateCopyOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str):
        """
        Immediate copy Option
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'ImmediateCopyOption'.
        """
        pulumi.set(__self__, "object_type", 'ImmediateCopyOption')

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'ImmediateCopyOption'.
        """
        return pulumi.get(self, "object_type")


@pulumi.output_type
class InnerErrorResponse(dict):
    """
    Inner Error
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInfo":
            suggest = "additional_info"
        elif key == "embeddedInnerError":
            suggest = "embedded_inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InnerErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InnerErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InnerErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_info: Optional[Mapping[str, str]] = None,
                 code: Optional[str] = None,
                 embedded_inner_error: Optional['outputs.InnerErrorResponse'] = None):
        """
        Inner Error
        :param Mapping[str, str] additional_info: Any Key value pairs that can be provided to the client for additional  verbose information.
        :param str code: Unique code for this error
        :param 'InnerErrorResponse' embedded_inner_error: Child Inner Error, to allow Nesting.
        """
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if embedded_inner_error is not None:
            pulumi.set(__self__, "embedded_inner_error", embedded_inner_error)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[Mapping[str, str]]:
        """
        Any Key value pairs that can be provided to the client for additional  verbose information.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Unique code for this error
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="embeddedInnerError")
    def embedded_inner_error(self) -> Optional['outputs.InnerErrorResponse']:
        """
        Child Inner Error, to allow Nesting.
        """
        return pulumi.get(self, "embedded_inner_error")


@pulumi.output_type
class MonitoringSettingsResponse(dict):
    """
    Monitoring Settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureMonitorAlertSettings":
            suggest = "azure_monitor_alert_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_monitor_alert_settings: Optional['outputs.AzureMonitorAlertSettingsResponse'] = None):
        """
        Monitoring Settings
        :param 'AzureMonitorAlertSettingsResponse' azure_monitor_alert_settings: Settings for Azure Monitor based alerts
        """
        if azure_monitor_alert_settings is not None:
            pulumi.set(__self__, "azure_monitor_alert_settings", azure_monitor_alert_settings)

    @property
    @pulumi.getter(name="azureMonitorAlertSettings")
    def azure_monitor_alert_settings(self) -> Optional['outputs.AzureMonitorAlertSettingsResponse']:
        """
        Settings for Azure Monitor based alerts
        """
        return pulumi.get(self, "azure_monitor_alert_settings")


@pulumi.output_type
class PolicyInfoResponse(dict):
    """
    Policy Info in backupInstance
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyId":
            suggest = "policy_id"
        elif key == "policyVersion":
            suggest = "policy_version"
        elif key == "policyParameters":
            suggest = "policy_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_id: str,
                 policy_version: str,
                 policy_parameters: Optional['outputs.PolicyParametersResponse'] = None):
        """
        Policy Info in backupInstance
        :param 'PolicyParametersResponse' policy_parameters: Policy parameters for the backup instance
        """
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "policy_version", policy_version)
        if policy_parameters is not None:
            pulumi.set(__self__, "policy_parameters", policy_parameters)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> str:
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> str:
        return pulumi.get(self, "policy_version")

    @property
    @pulumi.getter(name="policyParameters")
    def policy_parameters(self) -> Optional['outputs.PolicyParametersResponse']:
        """
        Policy parameters for the backup instance
        """
        return pulumi.get(self, "policy_parameters")


@pulumi.output_type
class PolicyParametersResponse(dict):
    """
    Parameters in Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreParametersList":
            suggest = "data_store_parameters_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_parameters_list: Optional[Sequence['outputs.AzureOperationalStoreParametersResponse']] = None):
        """
        Parameters in Policy
        :param Sequence['AzureOperationalStoreParametersResponse'] data_store_parameters_list: Gets or sets the DataStore Parameters
        """
        if data_store_parameters_list is not None:
            pulumi.set(__self__, "data_store_parameters_list", data_store_parameters_list)

    @property
    @pulumi.getter(name="dataStoreParametersList")
    def data_store_parameters_list(self) -> Optional[Sequence['outputs.AzureOperationalStoreParametersResponse']]:
        """
        Gets or sets the DataStore Parameters
        """
        return pulumi.get(self, "data_store_parameters_list")


@pulumi.output_type
class ProtectionStatusDetailsResponse(dict):
    """
    Protection status details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDetails":
            suggest = "error_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtectionStatusDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtectionStatusDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtectionStatusDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_details: Optional['outputs.UserFacingErrorResponse'] = None,
                 status: Optional[str] = None):
        """
        Protection status details
        :param 'UserFacingErrorResponse' error_details: Specifies the protection status error of the resource
        :param str status: Specifies the protection status of the resource
        """
        if error_details is not None:
            pulumi.set(__self__, "error_details", error_details)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="errorDetails")
    def error_details(self) -> Optional['outputs.UserFacingErrorResponse']:
        """
        Specifies the protection status error of the resource
        """
        return pulumi.get(self, "error_details")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Specifies the protection status of the resource
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceGuardOperationResponse(dict):
    """
    This class contains all the details about a critical operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestResourceType":
            suggest = "request_resource_type"
        elif key == "vaultCriticalOperation":
            suggest = "vault_critical_operation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGuardOperationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGuardOperationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGuardOperationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_resource_type: str,
                 vault_critical_operation: str):
        """
        This class contains all the details about a critical operation.
        :param str request_resource_type: Type of resource request.
        :param str vault_critical_operation: Name of the critical operation.
        """
        pulumi.set(__self__, "request_resource_type", request_resource_type)
        pulumi.set(__self__, "vault_critical_operation", vault_critical_operation)

    @property
    @pulumi.getter(name="requestResourceType")
    def request_resource_type(self) -> str:
        """
        Type of resource request.
        """
        return pulumi.get(self, "request_resource_type")

    @property
    @pulumi.getter(name="vaultCriticalOperation")
    def vault_critical_operation(self) -> str:
        """
        Name of the critical operation.
        """
        return pulumi.get(self, "vault_critical_operation")


@pulumi.output_type
class ResourceGuardResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowAutoApprovals":
            suggest = "allow_auto_approvals"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuardOperations":
            suggest = "resource_guard_operations"
        elif key == "vaultCriticalOperationExclusionList":
            suggest = "vault_critical_operation_exclusion_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceGuardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceGuardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceGuardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_auto_approvals: bool,
                 description: str,
                 provisioning_state: str,
                 resource_guard_operations: Sequence['outputs.ResourceGuardOperationResponse'],
                 vault_critical_operation_exclusion_list: Optional[Sequence[str]] = None):
        """
        :param bool allow_auto_approvals: This flag indicates whether auto approval is allowed or not.
        :param str description: Description about the pre-req steps to perform all the critical operations.
        :param str provisioning_state: Provisioning state of the BackupVault resource
        :param Sequence['ResourceGuardOperationResponse'] resource_guard_operations: {readonly} List of operation details those are protected by the ResourceGuard resource
        :param Sequence[str] vault_critical_operation_exclusion_list: List of critical operations which are not protected by this resourceGuard
        """
        pulumi.set(__self__, "allow_auto_approvals", allow_auto_approvals)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guard_operations", resource_guard_operations)
        if vault_critical_operation_exclusion_list is not None:
            pulumi.set(__self__, "vault_critical_operation_exclusion_list", vault_critical_operation_exclusion_list)

    @property
    @pulumi.getter(name="allowAutoApprovals")
    def allow_auto_approvals(self) -> bool:
        """
        This flag indicates whether auto approval is allowed or not.
        """
        return pulumi.get(self, "allow_auto_approvals")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description about the pre-req steps to perform all the critical operations.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the BackupVault resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuardOperations")
    def resource_guard_operations(self) -> Sequence['outputs.ResourceGuardOperationResponse']:
        """
        {readonly} List of operation details those are protected by the ResourceGuard resource
        """
        return pulumi.get(self, "resource_guard_operations")

    @property
    @pulumi.getter(name="vaultCriticalOperationExclusionList")
    def vault_critical_operation_exclusion_list(self) -> Optional[Sequence[str]]:
        """
        List of critical operations which are not protected by this resourceGuard
        """
        return pulumi.get(self, "vault_critical_operation_exclusion_list")


@pulumi.output_type
class ResourceMoveDetailsResponse(dict):
    """
    ResourceMoveDetails will be returned in response to GetResource call from ARM
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTimeUtc":
            suggest = "completion_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "sourceResourcePath":
            suggest = "source_resource_path"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "targetResourcePath":
            suggest = "target_resource_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceMoveDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceMoveDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceMoveDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time_utc: Optional[str] = None,
                 operation_id: Optional[str] = None,
                 source_resource_path: Optional[str] = None,
                 start_time_utc: Optional[str] = None,
                 target_resource_path: Optional[str] = None):
        """
        ResourceMoveDetails will be returned in response to GetResource call from ARM
        :param str completion_time_utc: Completion time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
        :param str operation_id: CorrelationId of latest ResourceMove operation attempted
        :param str source_resource_path: ARM resource path of source resource
        :param str start_time_utc: Start time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
        :param str target_resource_path: ARM resource path of target resource used in latest ResourceMove operation
        """
        if completion_time_utc is not None:
            pulumi.set(__self__, "completion_time_utc", completion_time_utc)
        if operation_id is not None:
            pulumi.set(__self__, "operation_id", operation_id)
        if source_resource_path is not None:
            pulumi.set(__self__, "source_resource_path", source_resource_path)
        if start_time_utc is not None:
            pulumi.set(__self__, "start_time_utc", start_time_utc)
        if target_resource_path is not None:
            pulumi.set(__self__, "target_resource_path", target_resource_path)

    @property
    @pulumi.getter(name="completionTimeUtc")
    def completion_time_utc(self) -> Optional[str]:
        """
        Completion time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
        """
        return pulumi.get(self, "completion_time_utc")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> Optional[str]:
        """
        CorrelationId of latest ResourceMove operation attempted
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="sourceResourcePath")
    def source_resource_path(self) -> Optional[str]:
        """
        ARM resource path of source resource
        """
        return pulumi.get(self, "source_resource_path")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> Optional[str]:
        """
        Start time in UTC of latest ResourceMove operation attempted. ISO 8601 format.
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="targetResourcePath")
    def target_resource_path(self) -> Optional[str]:
        """
        ARM resource path of target resource used in latest ResourceMove operation
        """
        return pulumi.get(self, "target_resource_path")


@pulumi.output_type
class RetentionTagResponse(dict):
    """
    Retention tag
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eTag":
            suggest = "e_tag"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionTagResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionTagResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionTagResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 e_tag: str,
                 id: str,
                 tag_name: str):
        """
        Retention tag
        :param str e_tag: Retention Tag version.
        :param str id: Retention Tag version.
        :param str tag_name: Retention Tag Name to relate it to retention rule.
        """
        pulumi.set(__self__, "e_tag", e_tag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> str:
        """
        Retention Tag version.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Retention Tag version.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> str:
        """
        Retention Tag Name to relate it to retention rule.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class ScheduleBasedBackupCriteriaResponse(dict):
    """
    Schedule based backup criteria
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"
        elif key == "absoluteCriteria":
            suggest = "absolute_criteria"
        elif key == "daysOfMonth":
            suggest = "days_of_month"
        elif key == "daysOfTheWeek":
            suggest = "days_of_the_week"
        elif key == "monthsOfYear":
            suggest = "months_of_year"
        elif key == "scheduleTimes":
            suggest = "schedule_times"
        elif key == "weeksOfTheMonth":
            suggest = "weeks_of_the_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleBasedBackupCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleBasedBackupCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleBasedBackupCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str,
                 absolute_criteria: Optional[Sequence[str]] = None,
                 days_of_month: Optional[Sequence['outputs.DayResponse']] = None,
                 days_of_the_week: Optional[Sequence[str]] = None,
                 months_of_year: Optional[Sequence[str]] = None,
                 schedule_times: Optional[Sequence[str]] = None,
                 weeks_of_the_month: Optional[Sequence[str]] = None):
        """
        Schedule based backup criteria
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'ScheduleBasedBackupCriteria'.
        :param Sequence[str] absolute_criteria: it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
               and should be part of AbsoluteMarker enum
        :param Sequence['DayResponse'] days_of_month: This is day of the month from 1 to 28 other wise last of month
        :param Sequence[str] days_of_the_week: It should be Sunday/Monday/T..../Saturday
        :param Sequence[str] months_of_year: It should be January/February/....../December
        :param Sequence[str] schedule_times: List of schedule times for backup
        :param Sequence[str] weeks_of_the_month: It should be First/Second/Third/Fourth/Last
        """
        pulumi.set(__self__, "object_type", 'ScheduleBasedBackupCriteria')
        if absolute_criteria is not None:
            pulumi.set(__self__, "absolute_criteria", absolute_criteria)
        if days_of_month is not None:
            pulumi.set(__self__, "days_of_month", days_of_month)
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if months_of_year is not None:
            pulumi.set(__self__, "months_of_year", months_of_year)
        if schedule_times is not None:
            pulumi.set(__self__, "schedule_times", schedule_times)
        if weeks_of_the_month is not None:
            pulumi.set(__self__, "weeks_of_the_month", weeks_of_the_month)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'ScheduleBasedBackupCriteria'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="absoluteCriteria")
    def absolute_criteria(self) -> Optional[Sequence[str]]:
        """
        it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
        and should be part of AbsoluteMarker enum
        """
        return pulumi.get(self, "absolute_criteria")

    @property
    @pulumi.getter(name="daysOfMonth")
    def days_of_month(self) -> Optional[Sequence['outputs.DayResponse']]:
        """
        This is day of the month from 1 to 28 other wise last of month
        """
        return pulumi.get(self, "days_of_month")

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[Sequence[str]]:
        """
        It should be Sunday/Monday/T..../Saturday
        """
        return pulumi.get(self, "days_of_the_week")

    @property
    @pulumi.getter(name="monthsOfYear")
    def months_of_year(self) -> Optional[Sequence[str]]:
        """
        It should be January/February/....../December
        """
        return pulumi.get(self, "months_of_year")

    @property
    @pulumi.getter(name="scheduleTimes")
    def schedule_times(self) -> Optional[Sequence[str]]:
        """
        List of schedule times for backup
        """
        return pulumi.get(self, "schedule_times")

    @property
    @pulumi.getter(name="weeksOfTheMonth")
    def weeks_of_the_month(self) -> Optional[Sequence[str]]:
        """
        It should be First/Second/Third/Fourth/Last
        """
        return pulumi.get(self, "weeks_of_the_month")


@pulumi.output_type
class ScheduleBasedTriggerContextResponse(dict):
    """
    Schedule based trigger context
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"
        elif key == "taggingCriteria":
            suggest = "tagging_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleBasedTriggerContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleBasedTriggerContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleBasedTriggerContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str,
                 schedule: 'outputs.BackupScheduleResponse',
                 tagging_criteria: Sequence['outputs.TaggingCriteriaResponse']):
        """
        Schedule based trigger context
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'ScheduleBasedTriggerContext'.
        :param 'BackupScheduleResponse' schedule: Schedule for this backup
        :param Sequence['TaggingCriteriaResponse'] tagging_criteria: List of tags that can be applicable for given schedule.
        """
        pulumi.set(__self__, "object_type", 'ScheduleBasedTriggerContext')
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "tagging_criteria", tagging_criteria)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'ScheduleBasedTriggerContext'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter
    def schedule(self) -> 'outputs.BackupScheduleResponse':
        """
        Schedule for this backup
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="taggingCriteria")
    def tagging_criteria(self) -> Sequence['outputs.TaggingCriteriaResponse']:
        """
        List of tags that can be applicable for given schedule.
        """
        return pulumi.get(self, "tagging_criteria")


@pulumi.output_type
class SecretStoreBasedAuthCredentialsResponse(dict):
    """
    Secret store based authentication credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"
        elif key == "secretStoreResource":
            suggest = "secret_store_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretStoreBasedAuthCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretStoreBasedAuthCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretStoreBasedAuthCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_type: str,
                 secret_store_resource: Optional['outputs.SecretStoreResourceResponse'] = None):
        """
        Secret store based authentication credentials.
        :param str object_type: Type of the specific object - used for deserializing
               Expected value is 'SecretStoreBasedAuthCredentials'.
        :param 'SecretStoreResourceResponse' secret_store_resource: Secret store resource
        """
        pulumi.set(__self__, "object_type", 'SecretStoreBasedAuthCredentials')
        if secret_store_resource is not None:
            pulumi.set(__self__, "secret_store_resource", secret_store_resource)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        Type of the specific object - used for deserializing
        Expected value is 'SecretStoreBasedAuthCredentials'.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="secretStoreResource")
    def secret_store_resource(self) -> Optional['outputs.SecretStoreResourceResponse']:
        """
        Secret store resource
        """
        return pulumi.get(self, "secret_store_resource")


@pulumi.output_type
class SecretStoreResourceResponse(dict):
    """
    Class representing a secret store resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretStoreType":
            suggest = "secret_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretStoreResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretStoreResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretStoreResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_store_type: str,
                 uri: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Class representing a secret store resource.
        :param str secret_store_type: Gets or sets the type of secret store
        :param str uri: Uri to get to the resource
        :param str value: Gets or sets value stored in secret store resource
        """
        pulumi.set(__self__, "secret_store_type", secret_store_type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="secretStoreType")
    def secret_store_type(self) -> str:
        """
        Gets or sets the type of secret store
        """
        return pulumi.get(self, "secret_store_type")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Uri to get to the resource
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Gets or sets value stored in secret store resource
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SourceLifeCycleResponse(dict):
    """
    Source LifeCycle
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteAfter":
            suggest = "delete_after"
        elif key == "sourceDataStore":
            suggest = "source_data_store"
        elif key == "targetDataStoreCopySettings":
            suggest = "target_data_store_copy_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceLifeCycleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceLifeCycleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceLifeCycleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_after: 'outputs.AbsoluteDeleteOptionResponse',
                 source_data_store: 'outputs.DataStoreInfoBaseResponse',
                 target_data_store_copy_settings: Optional[Sequence['outputs.TargetCopySettingResponse']] = None):
        """
        Source LifeCycle
        :param 'AbsoluteDeleteOptionResponse' delete_after: Delete Option
        :param 'DataStoreInfoBaseResponse' source_data_store: DataStoreInfo base
        """
        pulumi.set(__self__, "delete_after", delete_after)
        pulumi.set(__self__, "source_data_store", source_data_store)
        if target_data_store_copy_settings is not None:
            pulumi.set(__self__, "target_data_store_copy_settings", target_data_store_copy_settings)

    @property
    @pulumi.getter(name="deleteAfter")
    def delete_after(self) -> 'outputs.AbsoluteDeleteOptionResponse':
        """
        Delete Option
        """
        return pulumi.get(self, "delete_after")

    @property
    @pulumi.getter(name="sourceDataStore")
    def source_data_store(self) -> 'outputs.DataStoreInfoBaseResponse':
        """
        DataStoreInfo base
        """
        return pulumi.get(self, "source_data_store")

    @property
    @pulumi.getter(name="targetDataStoreCopySettings")
    def target_data_store_copy_settings(self) -> Optional[Sequence['outputs.TargetCopySettingResponse']]:
        return pulumi.get(self, "target_data_store_copy_settings")


@pulumi.output_type
class StorageSettingResponse(dict):
    """
    Storage setting
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreType":
            suggest = "datastore_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageSettingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageSettingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageSettingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datastore_type: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Storage setting
        :param str datastore_type: Gets or sets the type of the datastore.
        :param str type: Gets or sets the type.
        """
        if datastore_type is not None:
            pulumi.set(__self__, "datastore_type", datastore_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> Optional[str]:
        """
        Gets or sets the type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TaggingCriteriaResponse(dict):
    """
    Tagging criteria
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDefault":
            suggest = "is_default"
        elif key == "tagInfo":
            suggest = "tag_info"
        elif key == "taggingPriority":
            suggest = "tagging_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaggingCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaggingCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaggingCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_default: bool,
                 tag_info: 'outputs.RetentionTagResponse',
                 tagging_priority: float,
                 criteria: Optional[Sequence['outputs.ScheduleBasedBackupCriteriaResponse']] = None):
        """
        Tagging criteria
        :param bool is_default: Specifies if tag is default.
        :param 'RetentionTagResponse' tag_info: Retention tag information
        :param float tagging_priority: Retention Tag priority.
        :param Sequence['ScheduleBasedBackupCriteriaResponse'] criteria: Criteria which decides whether the tag can be applied to a triggered backup.
        """
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "tag_info", tag_info)
        pulumi.set(__self__, "tagging_priority", tagging_priority)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Specifies if tag is default.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="tagInfo")
    def tag_info(self) -> 'outputs.RetentionTagResponse':
        """
        Retention tag information
        """
        return pulumi.get(self, "tag_info")

    @property
    @pulumi.getter(name="taggingPriority")
    def tagging_priority(self) -> float:
        """
        Retention Tag priority.
        """
        return pulumi.get(self, "tagging_priority")

    @property
    @pulumi.getter
    def criteria(self) -> Optional[Sequence['outputs.ScheduleBasedBackupCriteriaResponse']]:
        """
        Criteria which decides whether the tag can be applied to a triggered backup.
        """
        return pulumi.get(self, "criteria")


@pulumi.output_type
class TargetCopySettingResponse(dict):
    """
    Target copy settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyAfter":
            suggest = "copy_after"
        elif key == "dataStore":
            suggest = "data_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetCopySettingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetCopySettingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetCopySettingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_after: Any,
                 data_store: 'outputs.DataStoreInfoBaseResponse'):
        """
        Target copy settings
        :param Union['CopyOnExpiryOptionResponse', 'CustomCopyOptionResponse', 'ImmediateCopyOptionResponse'] copy_after: It can be CustomCopyOption or ImmediateCopyOption.
        :param 'DataStoreInfoBaseResponse' data_store: Info of target datastore
        """
        pulumi.set(__self__, "copy_after", copy_after)
        pulumi.set(__self__, "data_store", data_store)

    @property
    @pulumi.getter(name="copyAfter")
    def copy_after(self) -> Any:
        """
        It can be CustomCopyOption or ImmediateCopyOption.
        """
        return pulumi.get(self, "copy_after")

    @property
    @pulumi.getter(name="dataStore")
    def data_store(self) -> 'outputs.DataStoreInfoBaseResponse':
        """
        Info of target datastore
        """
        return pulumi.get(self, "data_store")


@pulumi.output_type
class UserFacingErrorResponse(dict):
    """
    Error object used by layers that have access to localized content, and propagate that to user
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"
        elif key == "isRetryable":
            suggest = "is_retryable"
        elif key == "isUserError":
            suggest = "is_user_error"
        elif key == "recommendedAction":
            suggest = "recommended_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserFacingErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserFacingErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserFacingErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 details: Optional[Sequence['outputs.UserFacingErrorResponse']] = None,
                 inner_error: Optional['outputs.InnerErrorResponse'] = None,
                 is_retryable: Optional[bool] = None,
                 is_user_error: Optional[bool] = None,
                 message: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 recommended_action: Optional[Sequence[str]] = None,
                 target: Optional[str] = None):
        """
        Error object used by layers that have access to localized content, and propagate that to user
        :param str code: Unique code for this error
        :param Sequence['UserFacingErrorResponse'] details: Additional related Errors
        :param 'InnerErrorResponse' inner_error: Inner Error
        :param bool is_retryable: Whether the operation will be retryable or not
        :param bool is_user_error: Whether the operation is due to a user error or service error
        :param Mapping[str, str] properties: Any key value pairs that can be injected inside error object
        :param Sequence[str] recommended_action: RecommendedAction � localized.
        :param str target: Target of the error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if inner_error is not None:
            pulumi.set(__self__, "inner_error", inner_error)
        if is_retryable is not None:
            pulumi.set(__self__, "is_retryable", is_retryable)
        if is_user_error is not None:
            pulumi.set(__self__, "is_user_error", is_user_error)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if recommended_action is not None:
            pulumi.set(__self__, "recommended_action", recommended_action)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Unique code for this error
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.UserFacingErrorResponse']]:
        """
        Additional related Errors
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> Optional['outputs.InnerErrorResponse']:
        """
        Inner Error
        """
        return pulumi.get(self, "inner_error")

    @property
    @pulumi.getter(name="isRetryable")
    def is_retryable(self) -> Optional[bool]:
        """
        Whether the operation will be retryable or not
        """
        return pulumi.get(self, "is_retryable")

    @property
    @pulumi.getter(name="isUserError")
    def is_user_error(self) -> Optional[bool]:
        """
        Whether the operation is due to a user error or service error
        """
        return pulumi.get(self, "is_user_error")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Any key value pairs that can be injected inside error object
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="recommendedAction")
    def recommended_action(self) -> Optional[Sequence[str]]:
        """
        RecommendedAction � localized.
        """
        return pulumi.get(self, "recommended_action")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target of the error.
        """
        return pulumi.get(self, "target")


