# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetPrometheusRuleGroupResult',
    'AwaitableGetPrometheusRuleGroupResult',
    'get_prometheus_rule_group',
    'get_prometheus_rule_group_output',
]

@pulumi.output_type
class GetPrometheusRuleGroupResult:
    """
    The Prometheus rule group resource.
    """
    def __init__(__self__, cluster_name=None, description=None, enabled=None, id=None, interval=None, location=None, name=None, rules=None, scopes=None, system_data=None, tags=None, type=None):
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interval and not isinstance(interval, str):
            raise TypeError("Expected argument 'interval' to be a str")
        pulumi.set(__self__, "interval", interval)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        the cluster name of the rule group evaluation.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        the description of the Prometheus rule group that will be included in the alert email.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        the flag that indicates whether the Prometheus rule group is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> Optional[str]:
        """
        the interval in which to run the Prometheus rule group represented in ISO 8601 duration format. Should be between 1 and 15 minutes
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.PrometheusRuleResponse']:
        """
        defines the rules in the Prometheus rule group.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        the list of resource id's that this rule group is scoped to.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetPrometheusRuleGroupResult(GetPrometheusRuleGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrometheusRuleGroupResult(
            cluster_name=self.cluster_name,
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            interval=self.interval,
            location=self.location,
            name=self.name,
            rules=self.rules,
            scopes=self.scopes,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_prometheus_rule_group(resource_group_name: Optional[str] = None,
                              rule_group_name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrometheusRuleGroupResult:
    """
    The Prometheus rule group resource.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str rule_group_name: The name of the rule group.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['ruleGroupName'] = rule_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:alertsmanagement/v20210722preview:getPrometheusRuleGroup', __args__, opts=opts, typ=GetPrometheusRuleGroupResult).value

    return AwaitableGetPrometheusRuleGroupResult(
        cluster_name=__ret__.cluster_name,
        description=__ret__.description,
        enabled=__ret__.enabled,
        id=__ret__.id,
        interval=__ret__.interval,
        location=__ret__.location,
        name=__ret__.name,
        rules=__ret__.rules,
        scopes=__ret__.scopes,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_prometheus_rule_group)
def get_prometheus_rule_group_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                                     rule_group_name: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPrometheusRuleGroupResult]:
    """
    The Prometheus rule group resource.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str rule_group_name: The name of the rule group.
    """
    ...
