# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AdditionalFeaturesServerConfigurationsArgs',
    'AutoBackupSettingsArgs',
    'AutoPatchingSettingsArgs',
    'KeyVaultCredentialSettingsArgs',
    'LoadBalancerConfigurationArgs',
    'PrivateIPAddressArgs',
    'ResourceIdentityArgs',
    'SQLStorageSettingsArgs',
    'ServerConfigurationsManagementSettingsArgs',
    'SqlConnectivityUpdateSettingsArgs',
    'SqlStorageUpdateSettingsArgs',
    'SqlWorkloadTypeUpdateSettingsArgs',
    'StorageConfigurationSettingsArgs',
    'WsfcDomainCredentialsArgs',
    'WsfcDomainProfileArgs',
]

@pulumi.input_type
class AdditionalFeaturesServerConfigurationsArgs:
    def __init__(__self__, *,
                 is_r_services_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Additional SQL Server feature settings.
        :param pulumi.Input[bool] is_r_services_enabled: Enable or disable R services (SQL 2016 onwards).
        """
        if is_r_services_enabled is not None:
            pulumi.set(__self__, "is_r_services_enabled", is_r_services_enabled)

    @property
    @pulumi.getter(name="isRServicesEnabled")
    def is_r_services_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable R services (SQL 2016 onwards).
        """
        return pulumi.get(self, "is_r_services_enabled")

    @is_r_services_enabled.setter
    def is_r_services_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_r_services_enabled", value)


@pulumi.input_type
class AutoBackupSettingsArgs:
    def __init__(__self__, *,
                 backup_schedule_type: Optional[pulumi.Input[Union[str, 'BackupScheduleType']]] = None,
                 backup_system_dbs: Optional[pulumi.Input[bool]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 enable_encryption: Optional[pulumi.Input[bool]] = None,
                 full_backup_frequency: Optional[pulumi.Input[Union[str, 'FullBackupFrequencyType']]] = None,
                 full_backup_start_time: Optional[pulumi.Input[int]] = None,
                 full_backup_window_hours: Optional[pulumi.Input[int]] = None,
                 log_backup_frequency: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 retention_period: Optional[pulumi.Input[int]] = None,
                 storage_access_key: Optional[pulumi.Input[str]] = None,
                 storage_account_url: Optional[pulumi.Input[str]] = None):
        """
        Configure backups for databases in your SQL virtual machine.
        :param pulumi.Input[Union[str, 'BackupScheduleType']] backup_schedule_type: Backup schedule type.
        :param pulumi.Input[bool] backup_system_dbs: Include or exclude system databases from auto backup.
        :param pulumi.Input[bool] enable: Enable or disable autobackup on SQL virtual machine.
        :param pulumi.Input[bool] enable_encryption: Enable or disable encryption for backup on SQL virtual machine.
        :param pulumi.Input[Union[str, 'FullBackupFrequencyType']] full_backup_frequency: Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
        :param pulumi.Input[int] full_backup_start_time: Start time of a given day during which full backups can take place. 0-23 hours.
        :param pulumi.Input[int] full_backup_window_hours: Duration of the time window of a given day during which full backups can take place. 1-23 hours.
        :param pulumi.Input[int] log_backup_frequency: Frequency of log backups. 5-60 minutes.
        :param pulumi.Input[str] password: Password for encryption on backup.
        :param pulumi.Input[int] retention_period: Retention period of backup: 1-30 days.
        :param pulumi.Input[str] storage_access_key: Storage account key where backup will be taken to.
        :param pulumi.Input[str] storage_account_url: Storage account url where backup will be taken to.
        """
        if backup_schedule_type is not None:
            pulumi.set(__self__, "backup_schedule_type", backup_schedule_type)
        if backup_system_dbs is not None:
            pulumi.set(__self__, "backup_system_dbs", backup_system_dbs)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if enable_encryption is not None:
            pulumi.set(__self__, "enable_encryption", enable_encryption)
        if full_backup_frequency is not None:
            pulumi.set(__self__, "full_backup_frequency", full_backup_frequency)
        if full_backup_start_time is not None:
            pulumi.set(__self__, "full_backup_start_time", full_backup_start_time)
        if full_backup_window_hours is not None:
            pulumi.set(__self__, "full_backup_window_hours", full_backup_window_hours)
        if log_backup_frequency is not None:
            pulumi.set(__self__, "log_backup_frequency", log_backup_frequency)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if storage_access_key is not None:
            pulumi.set(__self__, "storage_access_key", storage_access_key)
        if storage_account_url is not None:
            pulumi.set(__self__, "storage_account_url", storage_account_url)

    @property
    @pulumi.getter(name="backupScheduleType")
    def backup_schedule_type(self) -> Optional[pulumi.Input[Union[str, 'BackupScheduleType']]]:
        """
        Backup schedule type.
        """
        return pulumi.get(self, "backup_schedule_type")

    @backup_schedule_type.setter
    def backup_schedule_type(self, value: Optional[pulumi.Input[Union[str, 'BackupScheduleType']]]):
        pulumi.set(self, "backup_schedule_type", value)

    @property
    @pulumi.getter(name="backupSystemDbs")
    def backup_system_dbs(self) -> Optional[pulumi.Input[bool]]:
        """
        Include or exclude system databases from auto backup.
        """
        return pulumi.get(self, "backup_system_dbs")

    @backup_system_dbs.setter
    def backup_system_dbs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_system_dbs", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable autobackup on SQL virtual machine.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="enableEncryption")
    def enable_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable encryption for backup on SQL virtual machine.
        """
        return pulumi.get(self, "enable_encryption")

    @enable_encryption.setter
    def enable_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encryption", value)

    @property
    @pulumi.getter(name="fullBackupFrequency")
    def full_backup_frequency(self) -> Optional[pulumi.Input[Union[str, 'FullBackupFrequencyType']]]:
        """
        Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
        """
        return pulumi.get(self, "full_backup_frequency")

    @full_backup_frequency.setter
    def full_backup_frequency(self, value: Optional[pulumi.Input[Union[str, 'FullBackupFrequencyType']]]):
        pulumi.set(self, "full_backup_frequency", value)

    @property
    @pulumi.getter(name="fullBackupStartTime")
    def full_backup_start_time(self) -> Optional[pulumi.Input[int]]:
        """
        Start time of a given day during which full backups can take place. 0-23 hours.
        """
        return pulumi.get(self, "full_backup_start_time")

    @full_backup_start_time.setter
    def full_backup_start_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "full_backup_start_time", value)

    @property
    @pulumi.getter(name="fullBackupWindowHours")
    def full_backup_window_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of the time window of a given day during which full backups can take place. 1-23 hours.
        """
        return pulumi.get(self, "full_backup_window_hours")

    @full_backup_window_hours.setter
    def full_backup_window_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "full_backup_window_hours", value)

    @property
    @pulumi.getter(name="logBackupFrequency")
    def log_backup_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency of log backups. 5-60 minutes.
        """
        return pulumi.get(self, "log_backup_frequency")

    @log_backup_frequency.setter
    def log_backup_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_backup_frequency", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for encryption on backup.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Retention period of backup: 1-30 days.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account key where backup will be taken to.
        """
        return pulumi.get(self, "storage_access_key")

    @storage_access_key.setter
    def storage_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_access_key", value)

    @property
    @pulumi.getter(name="storageAccountUrl")
    def storage_account_url(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account url where backup will be taken to.
        """
        return pulumi.get(self, "storage_account_url")

    @storage_account_url.setter
    def storage_account_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_url", value)


@pulumi.input_type
class AutoPatchingSettingsArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input['DayOfWeek']] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 maintenance_window_duration: Optional[pulumi.Input[int]] = None,
                 maintenance_window_starting_hour: Optional[pulumi.Input[int]] = None):
        """
        Set a patching window during which Windows and SQL patches will be applied.
        :param pulumi.Input['DayOfWeek'] day_of_week: Day of week to apply the patch on.
        :param pulumi.Input[bool] enable: Enable or disable autopatching on SQL virtual machine.
        :param pulumi.Input[int] maintenance_window_duration: Duration of patching.
        :param pulumi.Input[int] maintenance_window_starting_hour: Hour of the day when patching is initiated. Local VM time.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if maintenance_window_duration is not None:
            pulumi.set(__self__, "maintenance_window_duration", maintenance_window_duration)
        if maintenance_window_starting_hour is not None:
            pulumi.set(__self__, "maintenance_window_starting_hour", maintenance_window_starting_hour)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input['DayOfWeek']]:
        """
        Day of week to apply the patch on.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input['DayOfWeek']]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable autopatching on SQL virtual machine.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="maintenanceWindowDuration")
    def maintenance_window_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of patching.
        """
        return pulumi.get(self, "maintenance_window_duration")

    @maintenance_window_duration.setter
    def maintenance_window_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maintenance_window_duration", value)

    @property
    @pulumi.getter(name="maintenanceWindowStartingHour")
    def maintenance_window_starting_hour(self) -> Optional[pulumi.Input[int]]:
        """
        Hour of the day when patching is initiated. Local VM time.
        """
        return pulumi.get(self, "maintenance_window_starting_hour")

    @maintenance_window_starting_hour.setter
    def maintenance_window_starting_hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maintenance_window_starting_hour", value)


@pulumi.input_type
class KeyVaultCredentialSettingsArgs:
    def __init__(__self__, *,
                 azure_key_vault_url: Optional[pulumi.Input[str]] = None,
                 credential_name: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 service_principal_name: Optional[pulumi.Input[str]] = None,
                 service_principal_secret: Optional[pulumi.Input[str]] = None):
        """
        Configure your SQL virtual machine to be able to connect to the Azure Key Vault service.
        :param pulumi.Input[str] azure_key_vault_url: Azure Key Vault url.
        :param pulumi.Input[str] credential_name: Credential name.
        :param pulumi.Input[bool] enable: Enable or disable key vault credential setting.
        :param pulumi.Input[str] service_principal_name: Service principal name to access key vault.
        :param pulumi.Input[str] service_principal_secret: Service principal name secret to access key vault.
        """
        if azure_key_vault_url is not None:
            pulumi.set(__self__, "azure_key_vault_url", azure_key_vault_url)
        if credential_name is not None:
            pulumi.set(__self__, "credential_name", credential_name)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if service_principal_name is not None:
            pulumi.set(__self__, "service_principal_name", service_principal_name)
        if service_principal_secret is not None:
            pulumi.set(__self__, "service_principal_secret", service_principal_secret)

    @property
    @pulumi.getter(name="azureKeyVaultUrl")
    def azure_key_vault_url(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Key Vault url.
        """
        return pulumi.get(self, "azure_key_vault_url")

    @azure_key_vault_url.setter
    def azure_key_vault_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_key_vault_url", value)

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> Optional[pulumi.Input[str]]:
        """
        Credential name.
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_name", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable key vault credential setting.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="servicePrincipalName")
    def service_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        Service principal name to access key vault.
        """
        return pulumi.get(self, "service_principal_name")

    @service_principal_name.setter
    def service_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_principal_name", value)

    @property
    @pulumi.getter(name="servicePrincipalSecret")
    def service_principal_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Service principal name secret to access key vault.
        """
        return pulumi.get(self, "service_principal_secret")

    @service_principal_secret.setter
    def service_principal_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_principal_secret", value)


@pulumi.input_type
class LoadBalancerConfigurationArgs:
    def __init__(__self__, *,
                 load_balancer_resource_id: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input['PrivateIPAddressArgs']] = None,
                 probe_port: Optional[pulumi.Input[int]] = None,
                 public_ip_address_resource_id: Optional[pulumi.Input[str]] = None,
                 sql_virtual_machine_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A load balancer configuration for an availability group listener.
        :param pulumi.Input[str] load_balancer_resource_id: Resource id of the load balancer.
        :param pulumi.Input['PrivateIPAddressArgs'] private_ip_address: Private IP address.
        :param pulumi.Input[int] probe_port: Probe port.
        :param pulumi.Input[str] public_ip_address_resource_id: Resource id of the public IP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sql_virtual_machine_instances: List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
        """
        if load_balancer_resource_id is not None:
            pulumi.set(__self__, "load_balancer_resource_id", load_balancer_resource_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if probe_port is not None:
            pulumi.set(__self__, "probe_port", probe_port)
        if public_ip_address_resource_id is not None:
            pulumi.set(__self__, "public_ip_address_resource_id", public_ip_address_resource_id)
        if sql_virtual_machine_instances is not None:
            pulumi.set(__self__, "sql_virtual_machine_instances", sql_virtual_machine_instances)

    @property
    @pulumi.getter(name="loadBalancerResourceId")
    def load_balancer_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the load balancer.
        """
        return pulumi.get(self, "load_balancer_resource_id")

    @load_balancer_resource_id.setter
    def load_balancer_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_resource_id", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input['PrivateIPAddressArgs']]:
        """
        Private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input['PrivateIPAddressArgs']]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="probePort")
    def probe_port(self) -> Optional[pulumi.Input[int]]:
        """
        Probe port.
        """
        return pulumi.get(self, "probe_port")

    @probe_port.setter
    def probe_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "probe_port", value)

    @property
    @pulumi.getter(name="publicIpAddressResourceId")
    def public_ip_address_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the public IP.
        """
        return pulumi.get(self, "public_ip_address_resource_id")

    @public_ip_address_resource_id.setter
    def public_ip_address_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address_resource_id", value)

    @property
    @pulumi.getter(name="sqlVirtualMachineInstances")
    def sql_virtual_machine_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
        """
        return pulumi.get(self, "sql_virtual_machine_instances")

    @sql_virtual_machine_instances.setter
    def sql_virtual_machine_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sql_virtual_machine_instances", value)


@pulumi.input_type
class PrivateIPAddressArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 subnet_resource_id: Optional[pulumi.Input[str]] = None):
        """
        A private IP address bound to the availability group listener.
        :param pulumi.Input[str] ip_address: Private IP address bound to the availability group listener.
        :param pulumi.Input[str] subnet_resource_id: Subnet used to include private IP.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address bound to the availability group listener.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet used to include private IP.
        """
        return pulumi.get(self, "subnet_resource_id")

    @subnet_resource_id.setter
    def subnet_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_resource_id", value)


@pulumi.input_type
class ResourceIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'IdentityType']]] = None):
        """
        Azure Active Directory identity configuration for a resource.
        :param pulumi.Input[Union[str, 'IdentityType']] type: The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'IdentityType']]]:
        """
        The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'IdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SQLStorageSettingsArgs:
    def __init__(__self__, *,
                 default_file_path: Optional[pulumi.Input[str]] = None,
                 luns: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Set disk storage settings for SQL Server.
        :param pulumi.Input[str] default_file_path: SQL Server default file path
        :param pulumi.Input[Sequence[pulumi.Input[int]]] luns: Logical Unit Numbers for the disks.
        """
        if default_file_path is not None:
            pulumi.set(__self__, "default_file_path", default_file_path)
        if luns is not None:
            pulumi.set(__self__, "luns", luns)

    @property
    @pulumi.getter(name="defaultFilePath")
    def default_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server default file path
        """
        return pulumi.get(self, "default_file_path")

    @default_file_path.setter
    def default_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_file_path", value)

    @property
    @pulumi.getter
    def luns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Logical Unit Numbers for the disks.
        """
        return pulumi.get(self, "luns")

    @luns.setter
    def luns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "luns", value)


@pulumi.input_type
class ServerConfigurationsManagementSettingsArgs:
    def __init__(__self__, *,
                 additional_features_server_configurations: Optional[pulumi.Input['AdditionalFeaturesServerConfigurationsArgs']] = None,
                 sql_connectivity_update_settings: Optional[pulumi.Input['SqlConnectivityUpdateSettingsArgs']] = None,
                 sql_storage_update_settings: Optional[pulumi.Input['SqlStorageUpdateSettingsArgs']] = None,
                 sql_workload_type_update_settings: Optional[pulumi.Input['SqlWorkloadTypeUpdateSettingsArgs']] = None):
        """
        Set the connectivity, storage and workload settings.
        :param pulumi.Input['AdditionalFeaturesServerConfigurationsArgs'] additional_features_server_configurations: Additional SQL feature settings.
        :param pulumi.Input['SqlConnectivityUpdateSettingsArgs'] sql_connectivity_update_settings: SQL connectivity type settings.
        :param pulumi.Input['SqlStorageUpdateSettingsArgs'] sql_storage_update_settings: SQL storage update settings.
        :param pulumi.Input['SqlWorkloadTypeUpdateSettingsArgs'] sql_workload_type_update_settings: SQL workload type settings.
        """
        if additional_features_server_configurations is not None:
            pulumi.set(__self__, "additional_features_server_configurations", additional_features_server_configurations)
        if sql_connectivity_update_settings is not None:
            pulumi.set(__self__, "sql_connectivity_update_settings", sql_connectivity_update_settings)
        if sql_storage_update_settings is not None:
            pulumi.set(__self__, "sql_storage_update_settings", sql_storage_update_settings)
        if sql_workload_type_update_settings is not None:
            pulumi.set(__self__, "sql_workload_type_update_settings", sql_workload_type_update_settings)

    @property
    @pulumi.getter(name="additionalFeaturesServerConfigurations")
    def additional_features_server_configurations(self) -> Optional[pulumi.Input['AdditionalFeaturesServerConfigurationsArgs']]:
        """
        Additional SQL feature settings.
        """
        return pulumi.get(self, "additional_features_server_configurations")

    @additional_features_server_configurations.setter
    def additional_features_server_configurations(self, value: Optional[pulumi.Input['AdditionalFeaturesServerConfigurationsArgs']]):
        pulumi.set(self, "additional_features_server_configurations", value)

    @property
    @pulumi.getter(name="sqlConnectivityUpdateSettings")
    def sql_connectivity_update_settings(self) -> Optional[pulumi.Input['SqlConnectivityUpdateSettingsArgs']]:
        """
        SQL connectivity type settings.
        """
        return pulumi.get(self, "sql_connectivity_update_settings")

    @sql_connectivity_update_settings.setter
    def sql_connectivity_update_settings(self, value: Optional[pulumi.Input['SqlConnectivityUpdateSettingsArgs']]):
        pulumi.set(self, "sql_connectivity_update_settings", value)

    @property
    @pulumi.getter(name="sqlStorageUpdateSettings")
    def sql_storage_update_settings(self) -> Optional[pulumi.Input['SqlStorageUpdateSettingsArgs']]:
        """
        SQL storage update settings.
        """
        return pulumi.get(self, "sql_storage_update_settings")

    @sql_storage_update_settings.setter
    def sql_storage_update_settings(self, value: Optional[pulumi.Input['SqlStorageUpdateSettingsArgs']]):
        pulumi.set(self, "sql_storage_update_settings", value)

    @property
    @pulumi.getter(name="sqlWorkloadTypeUpdateSettings")
    def sql_workload_type_update_settings(self) -> Optional[pulumi.Input['SqlWorkloadTypeUpdateSettingsArgs']]:
        """
        SQL workload type settings.
        """
        return pulumi.get(self, "sql_workload_type_update_settings")

    @sql_workload_type_update_settings.setter
    def sql_workload_type_update_settings(self, value: Optional[pulumi.Input['SqlWorkloadTypeUpdateSettingsArgs']]):
        pulumi.set(self, "sql_workload_type_update_settings", value)


@pulumi.input_type
class SqlConnectivityUpdateSettingsArgs:
    def __init__(__self__, *,
                 connectivity_type: Optional[pulumi.Input[Union[str, 'ConnectivityType']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 sql_auth_update_password: Optional[pulumi.Input[str]] = None,
                 sql_auth_update_user_name: Optional[pulumi.Input[str]] = None):
        """
        Set the access level and network port settings for SQL Server.
        :param pulumi.Input[Union[str, 'ConnectivityType']] connectivity_type: SQL Server connectivity option.
        :param pulumi.Input[int] port: SQL Server port.
        :param pulumi.Input[str] sql_auth_update_password: SQL Server sysadmin login password.
        :param pulumi.Input[str] sql_auth_update_user_name: SQL Server sysadmin login to create.
        """
        if connectivity_type is not None:
            pulumi.set(__self__, "connectivity_type", connectivity_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if sql_auth_update_password is not None:
            pulumi.set(__self__, "sql_auth_update_password", sql_auth_update_password)
        if sql_auth_update_user_name is not None:
            pulumi.set(__self__, "sql_auth_update_user_name", sql_auth_update_user_name)

    @property
    @pulumi.getter(name="connectivityType")
    def connectivity_type(self) -> Optional[pulumi.Input[Union[str, 'ConnectivityType']]]:
        """
        SQL Server connectivity option.
        """
        return pulumi.get(self, "connectivity_type")

    @connectivity_type.setter
    def connectivity_type(self, value: Optional[pulumi.Input[Union[str, 'ConnectivityType']]]):
        pulumi.set(self, "connectivity_type", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        SQL Server port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sqlAuthUpdatePassword")
    def sql_auth_update_password(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server sysadmin login password.
        """
        return pulumi.get(self, "sql_auth_update_password")

    @sql_auth_update_password.setter
    def sql_auth_update_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_auth_update_password", value)

    @property
    @pulumi.getter(name="sqlAuthUpdateUserName")
    def sql_auth_update_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server sysadmin login to create.
        """
        return pulumi.get(self, "sql_auth_update_user_name")

    @sql_auth_update_user_name.setter
    def sql_auth_update_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_auth_update_user_name", value)


@pulumi.input_type
class SqlStorageUpdateSettingsArgs:
    def __init__(__self__, *,
                 disk_configuration_type: Optional[pulumi.Input[Union[str, 'DiskConfigurationType']]] = None,
                 disk_count: Optional[pulumi.Input[int]] = None,
                 starting_device_id: Optional[pulumi.Input[int]] = None):
        """
        Set disk storage settings for SQL Server.
        :param pulumi.Input[Union[str, 'DiskConfigurationType']] disk_configuration_type: Disk configuration to apply to SQL Server.
        :param pulumi.Input[int] disk_count: Virtual machine disk count.
        :param pulumi.Input[int] starting_device_id: Device id of the first disk to be updated.
        """
        if disk_configuration_type is not None:
            pulumi.set(__self__, "disk_configuration_type", disk_configuration_type)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if starting_device_id is not None:
            pulumi.set(__self__, "starting_device_id", starting_device_id)

    @property
    @pulumi.getter(name="diskConfigurationType")
    def disk_configuration_type(self) -> Optional[pulumi.Input[Union[str, 'DiskConfigurationType']]]:
        """
        Disk configuration to apply to SQL Server.
        """
        return pulumi.get(self, "disk_configuration_type")

    @disk_configuration_type.setter
    def disk_configuration_type(self, value: Optional[pulumi.Input[Union[str, 'DiskConfigurationType']]]):
        pulumi.set(self, "disk_configuration_type", value)

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[pulumi.Input[int]]:
        """
        Virtual machine disk count.
        """
        return pulumi.get(self, "disk_count")

    @disk_count.setter
    def disk_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_count", value)

    @property
    @pulumi.getter(name="startingDeviceId")
    def starting_device_id(self) -> Optional[pulumi.Input[int]]:
        """
        Device id of the first disk to be updated.
        """
        return pulumi.get(self, "starting_device_id")

    @starting_device_id.setter
    def starting_device_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "starting_device_id", value)


@pulumi.input_type
class SqlWorkloadTypeUpdateSettingsArgs:
    def __init__(__self__, *,
                 sql_workload_type: Optional[pulumi.Input[Union[str, 'SqlWorkloadType']]] = None):
        """
        Set workload type to optimize storage for SQL Server.
        :param pulumi.Input[Union[str, 'SqlWorkloadType']] sql_workload_type: SQL Server workload type.
        """
        if sql_workload_type is not None:
            pulumi.set(__self__, "sql_workload_type", sql_workload_type)

    @property
    @pulumi.getter(name="sqlWorkloadType")
    def sql_workload_type(self) -> Optional[pulumi.Input[Union[str, 'SqlWorkloadType']]]:
        """
        SQL Server workload type.
        """
        return pulumi.get(self, "sql_workload_type")

    @sql_workload_type.setter
    def sql_workload_type(self, value: Optional[pulumi.Input[Union[str, 'SqlWorkloadType']]]):
        pulumi.set(self, "sql_workload_type", value)


@pulumi.input_type
class StorageConfigurationSettingsArgs:
    def __init__(__self__, *,
                 disk_configuration_type: Optional[pulumi.Input[Union[str, 'DiskConfigurationType']]] = None,
                 sql_data_settings: Optional[pulumi.Input['SQLStorageSettingsArgs']] = None,
                 sql_log_settings: Optional[pulumi.Input['SQLStorageSettingsArgs']] = None,
                 sql_temp_db_settings: Optional[pulumi.Input['SQLStorageSettingsArgs']] = None,
                 storage_workload_type: Optional[pulumi.Input[Union[str, 'StorageWorkloadType']]] = None):
        """
        Storage Configurations for SQL Data, Log and TempDb.
        :param pulumi.Input[Union[str, 'DiskConfigurationType']] disk_configuration_type: Disk configuration to apply to SQL Server.
        :param pulumi.Input['SQLStorageSettingsArgs'] sql_data_settings: SQL Server Data Storage Settings.
        :param pulumi.Input['SQLStorageSettingsArgs'] sql_log_settings: SQL Server Log Storage Settings.
        :param pulumi.Input['SQLStorageSettingsArgs'] sql_temp_db_settings: SQL Server TempDb Storage Settings.
        :param pulumi.Input[Union[str, 'StorageWorkloadType']] storage_workload_type: Storage workload type.
        """
        if disk_configuration_type is not None:
            pulumi.set(__self__, "disk_configuration_type", disk_configuration_type)
        if sql_data_settings is not None:
            pulumi.set(__self__, "sql_data_settings", sql_data_settings)
        if sql_log_settings is not None:
            pulumi.set(__self__, "sql_log_settings", sql_log_settings)
        if sql_temp_db_settings is not None:
            pulumi.set(__self__, "sql_temp_db_settings", sql_temp_db_settings)
        if storage_workload_type is not None:
            pulumi.set(__self__, "storage_workload_type", storage_workload_type)

    @property
    @pulumi.getter(name="diskConfigurationType")
    def disk_configuration_type(self) -> Optional[pulumi.Input[Union[str, 'DiskConfigurationType']]]:
        """
        Disk configuration to apply to SQL Server.
        """
        return pulumi.get(self, "disk_configuration_type")

    @disk_configuration_type.setter
    def disk_configuration_type(self, value: Optional[pulumi.Input[Union[str, 'DiskConfigurationType']]]):
        pulumi.set(self, "disk_configuration_type", value)

    @property
    @pulumi.getter(name="sqlDataSettings")
    def sql_data_settings(self) -> Optional[pulumi.Input['SQLStorageSettingsArgs']]:
        """
        SQL Server Data Storage Settings.
        """
        return pulumi.get(self, "sql_data_settings")

    @sql_data_settings.setter
    def sql_data_settings(self, value: Optional[pulumi.Input['SQLStorageSettingsArgs']]):
        pulumi.set(self, "sql_data_settings", value)

    @property
    @pulumi.getter(name="sqlLogSettings")
    def sql_log_settings(self) -> Optional[pulumi.Input['SQLStorageSettingsArgs']]:
        """
        SQL Server Log Storage Settings.
        """
        return pulumi.get(self, "sql_log_settings")

    @sql_log_settings.setter
    def sql_log_settings(self, value: Optional[pulumi.Input['SQLStorageSettingsArgs']]):
        pulumi.set(self, "sql_log_settings", value)

    @property
    @pulumi.getter(name="sqlTempDbSettings")
    def sql_temp_db_settings(self) -> Optional[pulumi.Input['SQLStorageSettingsArgs']]:
        """
        SQL Server TempDb Storage Settings.
        """
        return pulumi.get(self, "sql_temp_db_settings")

    @sql_temp_db_settings.setter
    def sql_temp_db_settings(self, value: Optional[pulumi.Input['SQLStorageSettingsArgs']]):
        pulumi.set(self, "sql_temp_db_settings", value)

    @property
    @pulumi.getter(name="storageWorkloadType")
    def storage_workload_type(self) -> Optional[pulumi.Input[Union[str, 'StorageWorkloadType']]]:
        """
        Storage workload type.
        """
        return pulumi.get(self, "storage_workload_type")

    @storage_workload_type.setter
    def storage_workload_type(self, value: Optional[pulumi.Input[Union[str, 'StorageWorkloadType']]]):
        pulumi.set(self, "storage_workload_type", value)


@pulumi.input_type
class WsfcDomainCredentialsArgs:
    def __init__(__self__, *,
                 cluster_bootstrap_account_password: Optional[pulumi.Input[str]] = None,
                 cluster_operator_account_password: Optional[pulumi.Input[str]] = None,
                 sql_service_account_password: Optional[pulumi.Input[str]] = None):
        """
        Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
        :param pulumi.Input[str] cluster_bootstrap_account_password: Cluster bootstrap account password.
        :param pulumi.Input[str] cluster_operator_account_password: Cluster operator account password.
        :param pulumi.Input[str] sql_service_account_password: SQL service account password.
        """
        if cluster_bootstrap_account_password is not None:
            pulumi.set(__self__, "cluster_bootstrap_account_password", cluster_bootstrap_account_password)
        if cluster_operator_account_password is not None:
            pulumi.set(__self__, "cluster_operator_account_password", cluster_operator_account_password)
        if sql_service_account_password is not None:
            pulumi.set(__self__, "sql_service_account_password", sql_service_account_password)

    @property
    @pulumi.getter(name="clusterBootstrapAccountPassword")
    def cluster_bootstrap_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster bootstrap account password.
        """
        return pulumi.get(self, "cluster_bootstrap_account_password")

    @cluster_bootstrap_account_password.setter
    def cluster_bootstrap_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_bootstrap_account_password", value)

    @property
    @pulumi.getter(name="clusterOperatorAccountPassword")
    def cluster_operator_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster operator account password.
        """
        return pulumi.get(self, "cluster_operator_account_password")

    @cluster_operator_account_password.setter
    def cluster_operator_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_operator_account_password", value)

    @property
    @pulumi.getter(name="sqlServiceAccountPassword")
    def sql_service_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        SQL service account password.
        """
        return pulumi.get(self, "sql_service_account_password")

    @sql_service_account_password.setter
    def sql_service_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_service_account_password", value)


@pulumi.input_type
class WsfcDomainProfileArgs:
    def __init__(__self__, *,
                 cluster_bootstrap_account: Optional[pulumi.Input[str]] = None,
                 cluster_operator_account: Optional[pulumi.Input[str]] = None,
                 domain_fqdn: Optional[pulumi.Input[str]] = None,
                 file_share_witness_path: Optional[pulumi.Input[str]] = None,
                 ou_path: Optional[pulumi.Input[str]] = None,
                 sql_service_account: Optional[pulumi.Input[str]] = None,
                 storage_account_primary_key: Optional[pulumi.Input[str]] = None,
                 storage_account_url: Optional[pulumi.Input[str]] = None):
        """
        Active Directory account details to operate Windows Server Failover Cluster.
        :param pulumi.Input[str] cluster_bootstrap_account: Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
        :param pulumi.Input[str] cluster_operator_account: Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
        :param pulumi.Input[str] domain_fqdn: Fully qualified name of the domain.
        :param pulumi.Input[str] file_share_witness_path: Optional path for fileshare witness.
        :param pulumi.Input[str] ou_path: Organizational Unit path in which the nodes and cluster will be present.
        :param pulumi.Input[str] sql_service_account: Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
        :param pulumi.Input[str] storage_account_primary_key: Primary key of the witness storage account.
        :param pulumi.Input[str] storage_account_url: Fully qualified ARM resource id of the witness storage account.
        """
        if cluster_bootstrap_account is not None:
            pulumi.set(__self__, "cluster_bootstrap_account", cluster_bootstrap_account)
        if cluster_operator_account is not None:
            pulumi.set(__self__, "cluster_operator_account", cluster_operator_account)
        if domain_fqdn is not None:
            pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        if file_share_witness_path is not None:
            pulumi.set(__self__, "file_share_witness_path", file_share_witness_path)
        if ou_path is not None:
            pulumi.set(__self__, "ou_path", ou_path)
        if sql_service_account is not None:
            pulumi.set(__self__, "sql_service_account", sql_service_account)
        if storage_account_primary_key is not None:
            pulumi.set(__self__, "storage_account_primary_key", storage_account_primary_key)
        if storage_account_url is not None:
            pulumi.set(__self__, "storage_account_url", storage_account_url)

    @property
    @pulumi.getter(name="clusterBootstrapAccount")
    def cluster_bootstrap_account(self) -> Optional[pulumi.Input[str]]:
        """
        Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
        """
        return pulumi.get(self, "cluster_bootstrap_account")

    @cluster_bootstrap_account.setter
    def cluster_bootstrap_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_bootstrap_account", value)

    @property
    @pulumi.getter(name="clusterOperatorAccount")
    def cluster_operator_account(self) -> Optional[pulumi.Input[str]]:
        """
        Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
        """
        return pulumi.get(self, "cluster_operator_account")

    @cluster_operator_account.setter
    def cluster_operator_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_operator_account", value)

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified name of the domain.
        """
        return pulumi.get(self, "domain_fqdn")

    @domain_fqdn.setter
    def domain_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_fqdn", value)

    @property
    @pulumi.getter(name="fileShareWitnessPath")
    def file_share_witness_path(self) -> Optional[pulumi.Input[str]]:
        """
        Optional path for fileshare witness.
        """
        return pulumi.get(self, "file_share_witness_path")

    @file_share_witness_path.setter
    def file_share_witness_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_witness_path", value)

    @property
    @pulumi.getter(name="ouPath")
    def ou_path(self) -> Optional[pulumi.Input[str]]:
        """
        Organizational Unit path in which the nodes and cluster will be present.
        """
        return pulumi.get(self, "ou_path")

    @ou_path.setter
    def ou_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ou_path", value)

    @property
    @pulumi.getter(name="sqlServiceAccount")
    def sql_service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
        """
        return pulumi.get(self, "sql_service_account")

    @sql_service_account.setter
    def sql_service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_service_account", value)

    @property
    @pulumi.getter(name="storageAccountPrimaryKey")
    def storage_account_primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        Primary key of the witness storage account.
        """
        return pulumi.get(self, "storage_account_primary_key")

    @storage_account_primary_key.setter
    def storage_account_primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_primary_key", value)

    @property
    @pulumi.getter(name="storageAccountUrl")
    def storage_account_url(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM resource id of the witness storage account.
        """
        return pulumi.get(self, "storage_account_url")

    @storage_account_url.setter
    def storage_account_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_url", value)


