# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = ['SqlVulnerabilityAssessmentsSettingArgs', 'SqlVulnerabilityAssessmentsSetting']

@pulumi.input_type
class SqlVulnerabilityAssessmentsSettingArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 state: Optional[pulumi.Input['SqlVulnerabilityAssessmentState']] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SqlVulnerabilityAssessmentsSetting resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input['SqlVulnerabilityAssessmentState'] state: Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the SQL Vulnerability Assessment.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "server_name", server_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vulnerability_assessment_name is not None:
            pulumi.set(__self__, "vulnerability_assessment_name", vulnerability_assessment_name)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['SqlVulnerabilityAssessmentState']]:
        """
        Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['SqlVulnerabilityAssessmentState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="vulnerabilityAssessmentName")
    def vulnerability_assessment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL Vulnerability Assessment.
        """
        return pulumi.get(self, "vulnerability_assessment_name")

    @vulnerability_assessment_name.setter
    def vulnerability_assessment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vulnerability_assessment_name", value)


class SqlVulnerabilityAssessmentsSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['SqlVulnerabilityAssessmentState']] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A SQL Vulnerability Assessment.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
        :param pulumi.Input[str] server_name: The name of the server.
        :param pulumi.Input['SqlVulnerabilityAssessmentState'] state: Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the SQL Vulnerability Assessment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlVulnerabilityAssessmentsSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A SQL Vulnerability Assessment.

        :param str resource_name: The name of the resource.
        :param SqlVulnerabilityAssessmentsSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlVulnerabilityAssessmentsSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['SqlVulnerabilityAssessmentState']] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlVulnerabilityAssessmentsSettingArgs.__new__(SqlVulnerabilityAssessmentsSettingArgs)

            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if server_name is None and not opts.urn:
                raise TypeError("Missing required property 'server_name'")
            __props__.__dict__["server_name"] = server_name
            __props__.__dict__["state"] = state
            __props__.__dict__["vulnerability_assessment_name"] = vulnerability_assessment_name
            __props__.__dict__["name"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:sql/v20220201preview:SqlVulnerabilityAssessmentsSetting")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SqlVulnerabilityAssessmentsSetting, __self__).__init__(
            'azure-native:sql/v20220501preview:SqlVulnerabilityAssessmentsSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SqlVulnerabilityAssessmentsSetting':
        """
        Get an existing SqlVulnerabilityAssessmentsSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SqlVulnerabilityAssessmentsSettingArgs.__new__(SqlVulnerabilityAssessmentsSettingArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        return SqlVulnerabilityAssessmentsSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or disabled or a state has not been applied yet on the specific database or server.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        SystemData of SqlVulnerabilityAssessmentResource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

