# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'CustomProfileArgs',
    'DataDiskArgs',
    'ImageReferenceArgs',
    'LinuxConfigurationArgs',
    'NetworkFunctionRoleConfigurationArgs',
    'NetworkFunctionTemplateArgs',
    'NetworkFunctionUserConfigurationOsProfileArgs',
    'NetworkFunctionUserConfigurationArgs',
    'NetworkInterfaceIPConfigurationArgs',
    'NetworkInterfaceArgs',
    'OsDiskArgs',
    'OsProfileArgs',
    'SshConfigurationArgs',
    'SshPublicKeyArgs',
    'StorageProfileArgs',
    'SubResourceArgs',
    'VirtualHardDiskArgs',
]

@pulumi.input_type
class CustomProfileArgs:
    def __init__(__self__, *,
                 metadata_configuration_path: Optional[pulumi.Input[str]] = None):
        """
        Specifies the custom settings for the virtual machine.
        :param pulumi.Input[str] metadata_configuration_path: Path for metadata configuration.
        """
        if metadata_configuration_path is not None:
            pulumi.set(__self__, "metadata_configuration_path", metadata_configuration_path)

    @property
    @pulumi.getter(name="metadataConfigurationPath")
    def metadata_configuration_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path for metadata configuration.
        """
        return pulumi.get(self, "metadata_configuration_path")

    @metadata_configuration_path.setter
    def metadata_configuration_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata_configuration_path", value)


@pulumi.input_type
class DataDiskArgs:
    def __init__(__self__, *,
                 create_option: Optional[pulumi.Input[Union[str, 'DiskCreateOptionTypes']]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param pulumi.Input[Union[str, 'DiskCreateOptionTypes']] create_option: Specifies how the virtual machine should be created.
        :param pulumi.Input[int] disk_size_gb: Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image.
        :param pulumi.Input[str] name: The name of data disk.
        """
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[pulumi.Input[Union[str, 'DiskCreateOptionTypes']]]:
        """
        Specifies how the virtual machine should be created.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: Optional[pulumi.Input[Union[str, 'DiskCreateOptionTypes']]]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of an empty disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of data disk.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ImageReferenceArgs:
    def __init__(__self__, *,
                 exact_version: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The image reference properties.
        :param pulumi.Input[str] exact_version: Specifies in decimal numbers, the exact version of image used to create the virtual machine.
        :param pulumi.Input[str] offer: Specifies the offer of the image used to create the virtual machine.
        :param pulumi.Input[str] publisher: The image publisher.
        :param pulumi.Input[str] sku: The image SKU.
        :param pulumi.Input[str] version: Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        if exact_version is not None:
            pulumi.set(__self__, "exact_version", exact_version)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="exactVersion")
    def exact_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies in decimal numbers, the exact version of image used to create the virtual machine.
        """
        return pulumi.get(self, "exact_version")

    @exact_version.setter
    def exact_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact_version", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the offer of the image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LinuxConfigurationArgs:
    def __init__(__self__, *,
                 ssh: Optional[pulumi.Input['SshConfigurationArgs']] = None):
        """
        Specifies the Linux operating system settings on the virtual machine.
        :param pulumi.Input['SshConfigurationArgs'] ssh: Specifies the ssh key configuration for a Linux OS.
        """
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['SshConfigurationArgs']]:
        """
        Specifies the ssh key configuration for a Linux OS.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['SshConfigurationArgs']]):
        pulumi.set(self, "ssh", value)


@pulumi.input_type
class NetworkFunctionRoleConfigurationArgs:
    def __init__(__self__, *,
                 custom_profile: Optional[pulumi.Input['CustomProfileArgs']] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]] = None,
                 os_profile: Optional[pulumi.Input['OsProfileArgs']] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 role_type: Optional[pulumi.Input[Union[str, 'NetworkFunctionRoleConfigurationType']]] = None,
                 storage_profile: Optional[pulumi.Input['StorageProfileArgs']] = None,
                 user_data_parameters: Optional[Any] = None,
                 user_data_template: Optional[Any] = None,
                 virtual_machine_size: Optional[pulumi.Input[Union[str, 'VirtualMachineSizeTypes']]] = None):
        """
        Network function role configuration.
        :param pulumi.Input['CustomProfileArgs'] custom_profile: Specifies the custom settings for the virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]] network_interfaces: The network interface configurations.
        :param pulumi.Input['OsProfileArgs'] os_profile: Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
        :param pulumi.Input[str] role_name: The name of the network function role.
        :param pulumi.Input[Union[str, 'NetworkFunctionRoleConfigurationType']] role_type: Role type.
        :param pulumi.Input['StorageProfileArgs'] storage_profile: Specifies the storage settings for the virtual machine disks.
        :param Any user_data_parameters: The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
        :param Any user_data_template: The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
        :param pulumi.Input[Union[str, 'VirtualMachineSizeTypes']] virtual_machine_size: The size of the virtual machine.
        """
        if custom_profile is not None:
            pulumi.set(__self__, "custom_profile", custom_profile)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)
        if user_data_parameters is not None:
            pulumi.set(__self__, "user_data_parameters", user_data_parameters)
        if user_data_template is not None:
            pulumi.set(__self__, "user_data_template", user_data_template)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter(name="customProfile")
    def custom_profile(self) -> Optional[pulumi.Input['CustomProfileArgs']]:
        """
        Specifies the custom settings for the virtual machine.
        """
        return pulumi.get(self, "custom_profile")

    @custom_profile.setter
    def custom_profile(self, value: Optional[pulumi.Input['CustomProfileArgs']]):
        pulumi.set(self, "custom_profile", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]:
        """
        The network interface configurations.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['OsProfileArgs']]:
        """
        Specifies the operating system settings for the role instance. This value can be updated during the deployment of network function.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['OsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network function role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[Union[str, 'NetworkFunctionRoleConfigurationType']]]:
        """
        Role type.
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[Union[str, 'NetworkFunctionRoleConfigurationType']]]):
        pulumi.set(self, "role_type", value)

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional[pulumi.Input['StorageProfileArgs']]:
        """
        Specifies the storage settings for the virtual machine disks.
        """
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: Optional[pulumi.Input['StorageProfileArgs']]):
        pulumi.set(self, "storage_profile", value)

    @property
    @pulumi.getter(name="userDataParameters")
    def user_data_parameters(self) -> Optional[Any]:
        """
        The user parameters for customers. The format of user data parameters has to be matched with the provided user data template.
        """
        return pulumi.get(self, "user_data_parameters")

    @user_data_parameters.setter
    def user_data_parameters(self, value: Optional[Any]):
        pulumi.set(self, "user_data_parameters", value)

    @property
    @pulumi.getter(name="userDataTemplate")
    def user_data_template(self) -> Optional[Any]:
        """
        The user data template for customers. This is a json schema template describing the format and data type of user data parameters.
        """
        return pulumi.get(self, "user_data_template")

    @user_data_template.setter
    def user_data_template(self, value: Optional[Any]):
        pulumi.set(self, "user_data_template", value)

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[pulumi.Input[Union[str, 'VirtualMachineSizeTypes']]]:
        """
        The size of the virtual machine.
        """
        return pulumi.get(self, "virtual_machine_size")

    @virtual_machine_size.setter
    def virtual_machine_size(self, value: Optional[pulumi.Input[Union[str, 'VirtualMachineSizeTypes']]]):
        pulumi.set(self, "virtual_machine_size", value)


@pulumi.input_type
class NetworkFunctionTemplateArgs:
    def __init__(__self__, *,
                 network_function_role_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFunctionRoleConfigurationArgs']]]] = None):
        """
        The network function template.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkFunctionRoleConfigurationArgs']]] network_function_role_configurations: An array of network function role definitions.
        """
        if network_function_role_configurations is not None:
            pulumi.set(__self__, "network_function_role_configurations", network_function_role_configurations)

    @property
    @pulumi.getter(name="networkFunctionRoleConfigurations")
    def network_function_role_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFunctionRoleConfigurationArgs']]]]:
        """
        An array of network function role definitions.
        """
        return pulumi.get(self, "network_function_role_configurations")

    @network_function_role_configurations.setter
    def network_function_role_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkFunctionRoleConfigurationArgs']]]]):
        pulumi.set(self, "network_function_role_configurations", value)


@pulumi.input_type
class NetworkFunctionUserConfigurationOsProfileArgs:
    def __init__(__self__, *,
                 custom_data: Optional[pulumi.Input[str]] = None):
        """
        Specifies the operating system settings for the role instance.
        :param pulumi.Input[str] custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_data", value)


@pulumi.input_type
class NetworkFunctionUserConfigurationArgs:
    def __init__(__self__, *,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]] = None,
                 os_profile: Optional[pulumi.Input['NetworkFunctionUserConfigurationOsProfileArgs']] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 user_data_parameters: Optional[Any] = None):
        """
        The network function user configuration.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]] network_interfaces: The network interface configuration.
        :param pulumi.Input['NetworkFunctionUserConfigurationOsProfileArgs'] os_profile: Specifies the operating system settings for the role instance.
        :param pulumi.Input[str] role_name: The name of the network function role.
        :param Any user_data_parameters: The user data parameters from the customer.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if user_data_parameters is not None:
            pulumi.set(__self__, "user_data_parameters", user_data_parameters)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]:
        """
        The network interface configuration.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['NetworkFunctionUserConfigurationOsProfileArgs']]:
        """
        Specifies the operating system settings for the role instance.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['NetworkFunctionUserConfigurationOsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network function role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="userDataParameters")
    def user_data_parameters(self) -> Optional[Any]:
        """
        The user data parameters from the customer.
        """
        return pulumi.get(self, "user_data_parameters")

    @user_data_parameters.setter
    def user_data_parameters(self, value: Optional[Any]):
        pulumi.set(self, "user_data_parameters", value)


@pulumi.input_type
class NetworkInterfaceIPConfigurationArgs:
    def __init__(__self__, *,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_allocation_method: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]] = None,
                 ip_version: Optional[pulumi.Input[Union[str, 'IPVersion']]] = None,
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        Network interface IP configuration properties.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The list of DNS servers IP addresses.
        :param pulumi.Input[str] gateway: The value of the gateway.
        :param pulumi.Input[str] ip_address: The value of the IP address.
        :param pulumi.Input[Union[str, 'IPAllocationMethod']] ip_allocation_method: IP address allocation method.
        :param pulumi.Input[Union[str, 'IPVersion']] ip_version: IP address version.
        :param pulumi.Input[str] subnet: The value of the subnet.
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_allocation_method is not None:
            pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS servers IP addresses.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the gateway.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]:
        """
        IP address allocation method.
        """
        return pulumi.get(self, "ip_allocation_method")

    @ip_allocation_method.setter
    def ip_allocation_method(self, value: Optional[pulumi.Input[Union[str, 'IPAllocationMethod']]]):
        pulumi.set(self, "ip_allocation_method", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[Union[str, 'IPVersion']]]:
        """
        IP address version.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[Union[str, 'IPVersion']]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class NetworkInterfaceArgs:
    def __init__(__self__, *,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIPConfigurationArgs']]]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 network_interface_name: Optional[pulumi.Input[str]] = None,
                 vm_switch_type: Optional[pulumi.Input[Union[str, 'VMSwitchType']]] = None):
        """
        Network interface properties.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIPConfigurationArgs']]] ip_configurations: A list of IP configurations of the network interface.
        :param pulumi.Input[str] mac_address: The MAC address of the network interface.
        :param pulumi.Input[str] network_interface_name: The name of the network interface.
        :param pulumi.Input[Union[str, 'VMSwitchType']] vm_switch_type: The type of the VM switch.
        """
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if network_interface_name is not None:
            pulumi.set(__self__, "network_interface_name", network_interface_name)
        if vm_switch_type is not None:
            pulumi.set(__self__, "vm_switch_type", vm_switch_type)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIPConfigurationArgs']]]]:
        """
        A list of IP configurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceIPConfigurationArgs']]]]):
        pulumi.set(self, "ip_configurations", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address of the network interface.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network interface.
        """
        return pulumi.get(self, "network_interface_name")

    @network_interface_name.setter
    def network_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_interface_name", value)

    @property
    @pulumi.getter(name="vmSwitchType")
    def vm_switch_type(self) -> Optional[pulumi.Input[Union[str, 'VMSwitchType']]]:
        """
        The type of the VM switch.
        """
        return pulumi.get(self, "vm_switch_type")

    @vm_switch_type.setter
    def vm_switch_type(self, value: Optional[pulumi.Input[Union[str, 'VMSwitchType']]]):
        pulumi.set(self, "vm_switch_type", value)


@pulumi.input_type
class OsDiskArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OperatingSystemTypes']]] = None,
                 vhd: Optional[pulumi.Input['VirtualHardDiskArgs']] = None):
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param pulumi.Input[int] disk_size_gb: Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This disk size should be greater than the size of the VHD provided in vhdUri.
        :param pulumi.Input[str] name: The VHD name.
        :param pulumi.Input[Union[str, 'OperatingSystemTypes']] os_type: The OS type.
        :param pulumi.Input['VirtualHardDiskArgs'] vhd: The virtual hard disk.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd is not None:
            pulumi.set(__self__, "vhd", vhd)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This disk size should be greater than the size of the VHD provided in vhdUri.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The VHD name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OperatingSystemTypes']]]:
        """
        The OS type.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OperatingSystemTypes']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def vhd(self) -> Optional[pulumi.Input['VirtualHardDiskArgs']]:
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @vhd.setter
    def vhd(self, value: Optional[pulumi.Input['VirtualHardDiskArgs']]):
        pulumi.set(self, "vhd", value)


@pulumi.input_type
class OsProfileArgs:
    def __init__(__self__, *,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 custom_data: Optional[pulumi.Input[str]] = None,
                 custom_data_required: Optional[pulumi.Input[bool]] = None,
                 linux_configuration: Optional[pulumi.Input['LinuxConfigurationArgs']] = None):
        """
        Specifies the operating system settings for the role instance.
        :param pulumi.Input[str] admin_username: Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param pulumi.Input[str] custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param pulumi.Input[bool] custom_data_required: Indicates if custom data is required to deploy this role.
        :param pulumi.Input['LinuxConfigurationArgs'] linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if custom_data_required is None:
            custom_data_required = True
        if custom_data_required is not None:
            pulumi.set(__self__, "custom_data_required", custom_data_required)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the virtual machine. The maximum length of the binary array is 65535 bytes. <br><br> **Note: Do not pass any secrets or passwords in customData property** <br><br> This property cannot be updated after the VM is created. <br><br> customData is passed to the VM to be saved as a file. For more information see [Custom Data on Azure VMs](https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/) <br><br> For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "custom_data")

    @custom_data.setter
    def custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_data", value)

    @property
    @pulumi.getter(name="customDataRequired")
    def custom_data_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if custom data is required to deploy this role.
        """
        return pulumi.get(self, "custom_data_required")

    @custom_data_required.setter
    def custom_data_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_data_required", value)

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional[pulumi.Input['LinuxConfigurationArgs']]:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "linux_configuration")

    @linux_configuration.setter
    def linux_configuration(self, value: Optional[pulumi.Input['LinuxConfigurationArgs']]):
        pulumi.set(self, "linux_configuration", value)


@pulumi.input_type
class SshConfigurationArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class SshPublicKeyArgs:
    def __init__(__self__, *,
                 key_data: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param pulumi.Input[str] key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param pulumi.Input[str] path: Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_data", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class StorageProfileArgs:
    def __init__(__self__, *,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]] = None,
                 image_reference: Optional[pulumi.Input['ImageReferenceArgs']] = None,
                 os_disk: Optional[pulumi.Input['OsDiskArgs']] = None):
        """
        Specifies the storage settings for the virtual machine disks.
        :param pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine.
        :param pulumi.Input['ImageReferenceArgs'] image_reference: The image reference properties.
        :param pulumi.Input['OsDiskArgs'] os_disk: Specifies information about the operating system disk used by the virtual machine.
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional[pulumi.Input['ImageReferenceArgs']]:
        """
        The image reference properties.
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: Optional[pulumi.Input['ImageReferenceArgs']]):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional[pulumi.Input['OsDiskArgs']]:
        """
        Specifies information about the operating system disk used by the virtual machine.
        """
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: Optional[pulumi.Input['OsDiskArgs']]):
        pulumi.set(self, "os_disk", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Reference to another sub resource.
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualHardDiskArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Describes the uri of a disk.
        :param pulumi.Input[str] uri: Specifies the virtual hard disk's uri.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the virtual hard disk's uri.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


