# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['GovernanceRuleArgs', 'GovernanceRule']

@pulumi.input_type
class GovernanceRuleArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 owner_source: pulumi.Input['GovernanceRuleOwnerSourceArgs'],
                 rule_priority: pulumi.Input[int],
                 rule_type: pulumi.Input[Union[str, 'GovernanceRuleType']],
                 source_resource_type: pulumi.Input[Union[str, 'GovernanceRuleSourceResourceType']],
                 description: Optional[pulumi.Input[str]] = None,
                 governance_email_notification: Optional[pulumi.Input['GovernanceRuleEmailNotificationArgs']] = None,
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 is_grace_period: Optional[pulumi.Input[bool]] = None,
                 remediation_timeframe: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GovernanceRule resource.
        :param pulumi.Input[str] display_name: display name of the governanceRule
        :param pulumi.Input['GovernanceRuleOwnerSourceArgs'] owner_source: The Owner source for the governance rule - e.g. Manually by user@contoso.com - see example
        :param pulumi.Input[int] rule_priority: The governance rule priority, priority to the lower number. Rules with the same priority on the same subscription will not be allowed
        :param pulumi.Input[Union[str, 'GovernanceRuleType']] rule_type: The rule type of the governance rule, defines the source of the rule e.g. Integrated
        :param pulumi.Input[Union[str, 'GovernanceRuleSourceResourceType']] source_resource_type: The governance rule source, what the rule affects, e.g. Assessments
        :param pulumi.Input[str] description: description of the governanceRule
        :param pulumi.Input['GovernanceRuleEmailNotificationArgs'] governance_email_notification: The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
        :param pulumi.Input[bool] is_disabled: Defines whether the rule is active/inactive
        :param pulumi.Input[bool] is_grace_period: Defines whether there is a grace period on the governance rule
        :param pulumi.Input[str] remediation_timeframe: Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
        :param pulumi.Input[str] rule_id: The security GovernanceRule key - unique key for the standard GovernanceRule
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "owner_source", owner_source)
        pulumi.set(__self__, "rule_priority", rule_priority)
        pulumi.set(__self__, "rule_type", rule_type)
        pulumi.set(__self__, "source_resource_type", source_resource_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if governance_email_notification is not None:
            pulumi.set(__self__, "governance_email_notification", governance_email_notification)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if is_grace_period is not None:
            pulumi.set(__self__, "is_grace_period", is_grace_period)
        if remediation_timeframe is not None:
            pulumi.set(__self__, "remediation_timeframe", remediation_timeframe)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        display name of the governanceRule
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="ownerSource")
    def owner_source(self) -> pulumi.Input['GovernanceRuleOwnerSourceArgs']:
        """
        The Owner source for the governance rule - e.g. Manually by user@contoso.com - see example
        """
        return pulumi.get(self, "owner_source")

    @owner_source.setter
    def owner_source(self, value: pulumi.Input['GovernanceRuleOwnerSourceArgs']):
        pulumi.set(self, "owner_source", value)

    @property
    @pulumi.getter(name="rulePriority")
    def rule_priority(self) -> pulumi.Input[int]:
        """
        The governance rule priority, priority to the lower number. Rules with the same priority on the same subscription will not be allowed
        """
        return pulumi.get(self, "rule_priority")

    @rule_priority.setter
    def rule_priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "rule_priority", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[Union[str, 'GovernanceRuleType']]:
        """
        The rule type of the governance rule, defines the source of the rule e.g. Integrated
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[Union[str, 'GovernanceRuleType']]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="sourceResourceType")
    def source_resource_type(self) -> pulumi.Input[Union[str, 'GovernanceRuleSourceResourceType']]:
        """
        The governance rule source, what the rule affects, e.g. Assessments
        """
        return pulumi.get(self, "source_resource_type")

    @source_resource_type.setter
    def source_resource_type(self, value: pulumi.Input[Union[str, 'GovernanceRuleSourceResourceType']]):
        pulumi.set(self, "source_resource_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        description of the governanceRule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="governanceEmailNotification")
    def governance_email_notification(self) -> Optional[pulumi.Input['GovernanceRuleEmailNotificationArgs']]:
        """
        The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
        """
        return pulumi.get(self, "governance_email_notification")

    @governance_email_notification.setter
    def governance_email_notification(self, value: Optional[pulumi.Input['GovernanceRuleEmailNotificationArgs']]):
        pulumi.set(self, "governance_email_notification", value)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether the rule is active/inactive
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter(name="isGracePeriod")
    def is_grace_period(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether there is a grace period on the governance rule
        """
        return pulumi.get(self, "is_grace_period")

    @is_grace_period.setter
    def is_grace_period(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_grace_period", value)

    @property
    @pulumi.getter(name="remediationTimeframe")
    def remediation_timeframe(self) -> Optional[pulumi.Input[str]]:
        """
        Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
        """
        return pulumi.get(self, "remediation_timeframe")

    @remediation_timeframe.setter
    def remediation_timeframe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation_timeframe", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The security GovernanceRule key - unique key for the standard GovernanceRule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)


class GovernanceRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 governance_email_notification: Optional[pulumi.Input[pulumi.InputType['GovernanceRuleEmailNotificationArgs']]] = None,
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 is_grace_period: Optional[pulumi.Input[bool]] = None,
                 owner_source: Optional[pulumi.Input[pulumi.InputType['GovernanceRuleOwnerSourceArgs']]] = None,
                 remediation_timeframe: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 rule_priority: Optional[pulumi.Input[int]] = None,
                 rule_type: Optional[pulumi.Input[Union[str, 'GovernanceRuleType']]] = None,
                 source_resource_type: Optional[pulumi.Input[Union[str, 'GovernanceRuleSourceResourceType']]] = None,
                 __props__=None):
        """
        Security GovernanceRule over a given scope

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: description of the governanceRule
        :param pulumi.Input[str] display_name: display name of the governanceRule
        :param pulumi.Input[pulumi.InputType['GovernanceRuleEmailNotificationArgs']] governance_email_notification: The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
        :param pulumi.Input[bool] is_disabled: Defines whether the rule is active/inactive
        :param pulumi.Input[bool] is_grace_period: Defines whether there is a grace period on the governance rule
        :param pulumi.Input[pulumi.InputType['GovernanceRuleOwnerSourceArgs']] owner_source: The Owner source for the governance rule - e.g. Manually by user@contoso.com - see example
        :param pulumi.Input[str] remediation_timeframe: Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
        :param pulumi.Input[str] rule_id: The security GovernanceRule key - unique key for the standard GovernanceRule
        :param pulumi.Input[int] rule_priority: The governance rule priority, priority to the lower number. Rules with the same priority on the same subscription will not be allowed
        :param pulumi.Input[Union[str, 'GovernanceRuleType']] rule_type: The rule type of the governance rule, defines the source of the rule e.g. Integrated
        :param pulumi.Input[Union[str, 'GovernanceRuleSourceResourceType']] source_resource_type: The governance rule source, what the rule affects, e.g. Assessments
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GovernanceRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Security GovernanceRule over a given scope

        :param str resource_name: The name of the resource.
        :param GovernanceRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GovernanceRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 governance_email_notification: Optional[pulumi.Input[pulumi.InputType['GovernanceRuleEmailNotificationArgs']]] = None,
                 is_disabled: Optional[pulumi.Input[bool]] = None,
                 is_grace_period: Optional[pulumi.Input[bool]] = None,
                 owner_source: Optional[pulumi.Input[pulumi.InputType['GovernanceRuleOwnerSourceArgs']]] = None,
                 remediation_timeframe: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 rule_priority: Optional[pulumi.Input[int]] = None,
                 rule_type: Optional[pulumi.Input[Union[str, 'GovernanceRuleType']]] = None,
                 source_resource_type: Optional[pulumi.Input[Union[str, 'GovernanceRuleSourceResourceType']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GovernanceRuleArgs.__new__(GovernanceRuleArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["governance_email_notification"] = governance_email_notification
            __props__.__dict__["is_disabled"] = is_disabled
            __props__.__dict__["is_grace_period"] = is_grace_period
            if owner_source is None and not opts.urn:
                raise TypeError("Missing required property 'owner_source'")
            __props__.__dict__["owner_source"] = owner_source
            __props__.__dict__["remediation_timeframe"] = remediation_timeframe
            __props__.__dict__["rule_id"] = rule_id
            if rule_priority is None and not opts.urn:
                raise TypeError("Missing required property 'rule_priority'")
            __props__.__dict__["rule_priority"] = rule_priority
            if rule_type is None and not opts.urn:
                raise TypeError("Missing required property 'rule_type'")
            __props__.__dict__["rule_type"] = rule_type
            if source_resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_resource_type'")
            __props__.__dict__["source_resource_type"] = source_resource_type
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        super(GovernanceRule, __self__).__init__(
            'azure-native:security/v20220101preview:GovernanceRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GovernanceRule':
        """
        Get an existing GovernanceRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GovernanceRuleArgs.__new__(GovernanceRuleArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["governance_email_notification"] = None
        __props__.__dict__["is_disabled"] = None
        __props__.__dict__["is_grace_period"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["owner_source"] = None
        __props__.__dict__["remediation_timeframe"] = None
        __props__.__dict__["rule_priority"] = None
        __props__.__dict__["rule_type"] = None
        __props__.__dict__["source_resource_type"] = None
        __props__.__dict__["type"] = None
        return GovernanceRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        description of the governanceRule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        display name of the governanceRule
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="governanceEmailNotification")
    def governance_email_notification(self) -> pulumi.Output[Optional['outputs.GovernanceRuleEmailNotificationResponse']]:
        """
        The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
        """
        return pulumi.get(self, "governance_email_notification")

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether the rule is active/inactive
        """
        return pulumi.get(self, "is_disabled")

    @property
    @pulumi.getter(name="isGracePeriod")
    def is_grace_period(self) -> pulumi.Output[Optional[bool]]:
        """
        Defines whether there is a grace period on the governance rule
        """
        return pulumi.get(self, "is_grace_period")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerSource")
    def owner_source(self) -> pulumi.Output['outputs.GovernanceRuleOwnerSourceResponse']:
        """
        The Owner source for the governance rule - e.g. Manually by user@contoso.com - see example
        """
        return pulumi.get(self, "owner_source")

    @property
    @pulumi.getter(name="remediationTimeframe")
    def remediation_timeframe(self) -> pulumi.Output[Optional[str]]:
        """
        Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
        """
        return pulumi.get(self, "remediation_timeframe")

    @property
    @pulumi.getter(name="rulePriority")
    def rule_priority(self) -> pulumi.Output[int]:
        """
        The governance rule priority, priority to the lower number. Rules with the same priority on the same subscription will not be allowed
        """
        return pulumi.get(self, "rule_priority")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Output[str]:
        """
        The rule type of the governance rule, defines the source of the rule e.g. Integrated
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="sourceResourceType")
    def source_resource_type(self) -> pulumi.Output[str]:
        """
        The governance rule source, what the rule affects, e.g. Assessments
        """
        return pulumi.get(self, "source_resource_type")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

