# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ArmTemplateParameterResponse',
    'ManagementAssociationPropertiesResponse',
    'ManagementConfigurationPropertiesResponse',
    'SolutionPlanResponse',
    'SolutionPropertiesResponse',
]

@pulumi.output_type
class ArmTemplateParameterResponse(dict):
    """
    Parameter to pass to ARM template
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Parameter to pass to ARM template
        :param str name: name of the parameter.
        :param str value: value for the parameter. In Jtoken 
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name of the parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        value for the parameter. In Jtoken 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ManagementAssociationPropertiesResponse(dict):
    """
    ManagementAssociation properties supported by the OperationsManagement resource provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementAssociationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementAssociationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementAssociationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: str):
        """
        ManagementAssociation properties supported by the OperationsManagement resource provider.
        :param str application_id: The applicationId of the appliance for this association.
        """
        pulumi.set(__self__, "application_id", application_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        """
        The applicationId of the appliance for this association.
        """
        return pulumi.get(self, "application_id")


@pulumi.output_type
class ManagementConfigurationPropertiesResponse(dict):
    """
    ManagementConfiguration properties supported by the OperationsManagement resource provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parentResourceType":
            suggest = "parent_resource_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "applicationId":
            suggest = "application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementConfigurationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementConfigurationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementConfigurationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters: Sequence['outputs.ArmTemplateParameterResponse'],
                 parent_resource_type: str,
                 provisioning_state: str,
                 template: Any,
                 application_id: Optional[str] = None):
        """
        ManagementConfiguration properties supported by the OperationsManagement resource provider.
        :param Sequence['ArmTemplateParameterResponse'] parameters: Parameters to run the ARM template
        :param str parent_resource_type: The type of the parent resource.
        :param str provisioning_state: The provisioning state for the ManagementConfiguration.
        :param Any template: The Json object containing the ARM template to deploy
        :param str application_id: The applicationId of the appliance for this Management.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "parent_resource_type", parent_resource_type)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "template", template)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.ArmTemplateParameterResponse']:
        """
        Parameters to run the ARM template
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="parentResourceType")
    def parent_resource_type(self) -> str:
        """
        The type of the parent resource.
        """
        return pulumi.get(self, "parent_resource_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state for the ManagementConfiguration.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def template(self) -> Any:
        """
        The Json object containing the ARM template to deploy
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        The applicationId of the appliance for this Management.
        """
        return pulumi.get(self, "application_id")


@pulumi.output_type
class SolutionPlanResponse(dict):
    """
    Plan for solution object supported by the OperationsManagement resource provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionPlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionPlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionPlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 product: Optional[str] = None,
                 promotion_code: Optional[str] = None,
                 publisher: Optional[str] = None):
        """
        Plan for solution object supported by the OperationsManagement resource provider.
        :param str name: name of the solution to be created. For Microsoft published solution it should be in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third party solution, it can be anything.
        :param str product: name of the solution to enabled/add. For Microsoft published gallery solution it should be in the format of OMSGallery/<solutionType>. This is case sensitive
        :param str promotion_code: promotionCode, Not really used now, can you left as empty
        :param str publisher: Publisher name. For gallery solution, it is Microsoft.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name of the solution to be created. For Microsoft published solution it should be in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third party solution, it can be anything.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        name of the solution to enabled/add. For Microsoft published gallery solution it should be in the format of OMSGallery/<solutionType>. This is case sensitive
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        promotionCode, Not really used now, can you left as empty
        """
        return pulumi.get(self, "promotion_code")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        Publisher name. For gallery solution, it is Microsoft.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class SolutionPropertiesResponse(dict):
    """
    Solution properties supported by the OperationsManagement resource provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "workspaceResourceId":
            suggest = "workspace_resource_id"
        elif key == "containedResources":
            suggest = "contained_resources"
        elif key == "referencedResources":
            suggest = "referenced_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 workspace_resource_id: str,
                 contained_resources: Optional[Sequence[str]] = None,
                 referenced_resources: Optional[Sequence[str]] = None):
        """
        Solution properties supported by the OperationsManagement resource provider.
        :param str provisioning_state: The provisioning state for the solution.
        :param str workspace_resource_id: The azure resourceId for the workspace where the solution will be deployed/enabled.
        :param Sequence[str] contained_resources: The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
        :param Sequence[str] referenced_resources: The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)
        if contained_resources is not None:
            pulumi.set(__self__, "contained_resources", contained_resources)
        if referenced_resources is not None:
            pulumi.set(__self__, "referenced_resources", referenced_resources)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state for the solution.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> str:
        """
        The azure resourceId for the workspace where the solution will be deployed/enabled.
        """
        return pulumi.get(self, "workspace_resource_id")

    @property
    @pulumi.getter(name="containedResources")
    def contained_resources(self) -> Optional[Sequence[str]]:
        """
        The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
        """
        return pulumi.get(self, "contained_resources")

    @property
    @pulumi.getter(name="referencedResources")
    def referenced_resources(self) -> Optional[Sequence[str]]:
        """
        The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
        """
        return pulumi.get(self, "referenced_resources")


