# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 workspace_name: pulumi.Input[str],
                 plan: Optional[pulumi.Input[Union[str, 'TablePlanEnum']]] = None,
                 restored_logs: Optional[pulumi.Input['RestoredLogsArgs']] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 schema: Optional[pulumi.Input['SchemaArgs']] = None,
                 search_results: Optional[pulumi.Input['SearchResultsArgs']] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 total_retention_in_days: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] workspace_name: The name of the workspace.
        :param pulumi.Input[Union[str, 'TablePlanEnum']] plan: Instruct the system how to handle and charge the logs ingested to this table.
        :param pulumi.Input['RestoredLogsArgs'] restored_logs: Parameters of the restore operation that initiated this table.
        :param pulumi.Input[int] retention_in_days: The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
        :param pulumi.Input['SchemaArgs'] schema: Table schema.
        :param pulumi.Input['SearchResultsArgs'] search_results: Parameters of the search job that initiated this table.
        :param pulumi.Input[str] table_name: The name of the table.
        :param pulumi.Input[int] total_retention_in_days: The table total retention in days, between 4 and 2555. Setting this property to -1 will default to table retention.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "workspace_name", workspace_name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if restored_logs is not None:
            pulumi.set(__self__, "restored_logs", restored_logs)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if search_results is not None:
            pulumi.set(__self__, "search_results", search_results)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if total_retention_in_days is not None:
            pulumi.set(__self__, "total_retention_in_days", total_retention_in_days)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Input[str]:
        """
        The name of the workspace.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_name", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[Union[str, 'TablePlanEnum']]]:
        """
        Instruct the system how to handle and charge the logs ingested to this table.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[Union[str, 'TablePlanEnum']]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="restoredLogs")
    def restored_logs(self) -> Optional[pulumi.Input['RestoredLogsArgs']]:
        """
        Parameters of the restore operation that initiated this table.
        """
        return pulumi.get(self, "restored_logs")

    @restored_logs.setter
    def restored_logs(self, value: Optional[pulumi.Input['RestoredLogsArgs']]):
        pulumi.set(self, "restored_logs", value)

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_in_days", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['SchemaArgs']]:
        """
        Table schema.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['SchemaArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="searchResults")
    def search_results(self) -> Optional[pulumi.Input['SearchResultsArgs']]:
        """
        Parameters of the search job that initiated this table.
        """
        return pulumi.get(self, "search_results")

    @search_results.setter
    def search_results(self, value: Optional[pulumi.Input['SearchResultsArgs']]):
        pulumi.set(self, "search_results", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="totalRetentionInDays")
    def total_retention_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        The table total retention in days, between 4 and 2555. Setting this property to -1 will default to table retention.
        """
        return pulumi.get(self, "total_retention_in_days")

    @total_retention_in_days.setter
    def total_retention_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_retention_in_days", value)


class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 plan: Optional[pulumi.Input[Union[str, 'TablePlanEnum']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 restored_logs: Optional[pulumi.Input[pulumi.InputType['RestoredLogsArgs']]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['SchemaArgs']]] = None,
                 search_results: Optional[pulumi.Input[pulumi.InputType['SearchResultsArgs']]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 total_retention_in_days: Optional[pulumi.Input[int]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Workspace data table definition.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'TablePlanEnum']] plan: Instruct the system how to handle and charge the logs ingested to this table.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[pulumi.InputType['RestoredLogsArgs']] restored_logs: Parameters of the restore operation that initiated this table.
        :param pulumi.Input[int] retention_in_days: The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
        :param pulumi.Input[pulumi.InputType['SchemaArgs']] schema: Table schema.
        :param pulumi.Input[pulumi.InputType['SearchResultsArgs']] search_results: Parameters of the search job that initiated this table.
        :param pulumi.Input[str] table_name: The name of the table.
        :param pulumi.Input[int] total_retention_in_days: The table total retention in days, between 4 and 2555. Setting this property to -1 will default to table retention.
        :param pulumi.Input[str] workspace_name: The name of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Workspace data table definition.

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 plan: Optional[pulumi.Input[Union[str, 'TablePlanEnum']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 restored_logs: Optional[pulumi.Input[pulumi.InputType['RestoredLogsArgs']]] = None,
                 retention_in_days: Optional[pulumi.Input[int]] = None,
                 schema: Optional[pulumi.Input[pulumi.InputType['SchemaArgs']]] = None,
                 search_results: Optional[pulumi.Input[pulumi.InputType['SearchResultsArgs']]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 total_retention_in_days: Optional[pulumi.Input[int]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["plan"] = plan
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["restored_logs"] = restored_logs
            __props__.__dict__["retention_in_days"] = retention_in_days
            __props__.__dict__["schema"] = schema
            __props__.__dict__["search_results"] = search_results
            __props__.__dict__["table_name"] = table_name
            __props__.__dict__["total_retention_in_days"] = total_retention_in_days
            if workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_name'")
            __props__.__dict__["workspace_name"] = workspace_name
            __props__.__dict__["archive_retention_in_days"] = None
            __props__.__dict__["last_plan_modified_date"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["result_statistics"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:operationalinsights:Table"), pulumi.Alias(type_="azure-native:operationalinsights/v20221001:Table")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Table, __self__).__init__(
            'azure-native:operationalinsights/v20211201preview:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TableArgs.__new__(TableArgs)

        __props__.__dict__["archive_retention_in_days"] = None
        __props__.__dict__["last_plan_modified_date"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["plan"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["restored_logs"] = None
        __props__.__dict__["result_statistics"] = None
        __props__.__dict__["retention_in_days"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["search_results"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["total_retention_in_days"] = None
        __props__.__dict__["type"] = None
        return Table(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archiveRetentionInDays")
    def archive_retention_in_days(self) -> pulumi.Output[int]:
        """
        The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays)
        """
        return pulumi.get(self, "archive_retention_in_days")

    @property
    @pulumi.getter(name="lastPlanModifiedDate")
    def last_plan_modified_date(self) -> pulumi.Output[str]:
        """
        The timestamp that table plan was last modified (UTC).
        """
        return pulumi.get(self, "last_plan_modified_date")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        Instruct the system how to handle and charge the logs ingested to this table.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="restoredLogs")
    def restored_logs(self) -> pulumi.Output[Optional['outputs.RestoredLogsResponse']]:
        """
        Parameters of the restore operation that initiated this table.
        """
        return pulumi.get(self, "restored_logs")

    @property
    @pulumi.getter(name="resultStatistics")
    def result_statistics(self) -> pulumi.Output[Optional['outputs.ResultStatisticsResponse']]:
        """
        Search job execution statistics.
        """
        return pulumi.get(self, "result_statistics")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> pulumi.Output[Optional[int]]:
        """
        The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
        """
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional['outputs.SchemaResponse']]:
        """
        Table schema.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="searchResults")
    def search_results(self) -> pulumi.Output[Optional['outputs.SearchResultsResponse']]:
        """
        Parameters of the search job that initiated this table.
        """
        return pulumi.get(self, "search_results")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter(name="totalRetentionInDays")
    def total_retention_in_days(self) -> pulumi.Output[Optional[int]]:
        """
        The table total retention in days, between 4 and 2555. Setting this property to -1 will default to table retention.
        """
        return pulumi.get(self, "total_retention_in_days")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

