# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdditionalUnattendContentResponse',
    'ApiEntityReferenceResponse',
    'BootDiagnosticsInstanceViewResponse',
    'BootDiagnosticsResponse',
    'DataDiskResponse',
    'DiagnosticsProfileResponse',
    'DiskEncryptionSettingsResponse',
    'DiskInstanceViewResponse',
    'HardwareProfileResponse',
    'ImageReferenceResponse',
    'InstanceViewStatusResponse',
    'KeyVaultKeyReferenceResponse',
    'KeyVaultSecretReferenceResponse',
    'LinuxConfigurationResponse',
    'NetworkInterfaceReferenceResponse',
    'NetworkProfileResponse',
    'OSDiskResponse',
    'OSProfileResponse',
    'PlanResponse',
    'SkuResponse',
    'SshConfigurationResponse',
    'SshPublicKeyResponse',
    'StorageProfileResponse',
    'SubResourceResponse',
    'UpgradePolicyResponse',
    'VaultCertificateResponse',
    'VaultSecretGroupResponse',
    'VirtualHardDiskResponse',
    'VirtualMachineAgentInstanceViewResponse',
    'VirtualMachineExtensionHandlerInstanceViewResponse',
    'VirtualMachineExtensionInstanceViewResponse',
    'VirtualMachineExtensionResponse',
    'VirtualMachineIdentityResponse',
    'VirtualMachineInstanceViewResponse',
    'VirtualMachineScaleSetExtensionProfileResponse',
    'VirtualMachineScaleSetExtensionResponse',
    'VirtualMachineScaleSetIPConfigurationResponse',
    'VirtualMachineScaleSetIdentityResponse',
    'VirtualMachineScaleSetNetworkConfigurationResponse',
    'VirtualMachineScaleSetNetworkProfileResponse',
    'VirtualMachineScaleSetOSDiskResponse',
    'VirtualMachineScaleSetOSProfileResponse',
    'VirtualMachineScaleSetStorageProfileResponse',
    'VirtualMachineScaleSetVMProfileResponse',
    'WinRMConfigurationResponse',
    'WinRMListenerResponse',
    'WindowsConfigurationResponse',
]

@pulumi.output_type
class AdditionalUnattendContentResponse(dict):
    """
    Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentName":
            suggest = "component_name"
        elif key == "passName":
            suggest = "pass_name"
        elif key == "settingName":
            suggest = "setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdditionalUnattendContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdditionalUnattendContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdditionalUnattendContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_name: Optional[str] = None,
                 content: Optional[str] = None,
                 pass_name: Optional[str] = None,
                 setting_name: Optional[str] = None):
        """
        Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.
        :param str component_name: The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        :param str content: Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        :param str pass_name: The pass name. Currently, the only allowable value is OobeSystem.
        :param str setting_name: Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if pass_name is not None:
            pulumi.set(__self__, "pass_name", pass_name)
        if setting_name is not None:
            pulumi.set(__self__, "setting_name", setting_name)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[str]:
        """
        The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="passName")
    def pass_name(self) -> Optional[str]:
        """
        The pass name. Currently, the only allowable value is OobeSystem.
        """
        return pulumi.get(self, "pass_name")

    @property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> Optional[str]:
        """
        Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
        """
        return pulumi.get(self, "setting_name")


@pulumi.output_type
class ApiEntityReferenceResponse(dict):
    """
    The API entity reference.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The API entity reference.
        :param str id: The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class BootDiagnosticsInstanceViewResponse(dict):
    """
    The instance view of a virtual machine boot diagnostics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consoleScreenshotBlobUri":
            suggest = "console_screenshot_blob_uri"
        elif key == "serialConsoleLogBlobUri":
            suggest = "serial_console_log_blob_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BootDiagnosticsInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BootDiagnosticsInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BootDiagnosticsInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 console_screenshot_blob_uri: str,
                 serial_console_log_blob_uri: str):
        """
        The instance view of a virtual machine boot diagnostics.
        :param str console_screenshot_blob_uri: The console screenshot blob URI.
        :param str serial_console_log_blob_uri: The Linux serial console log blob Uri.
        """
        pulumi.set(__self__, "console_screenshot_blob_uri", console_screenshot_blob_uri)
        pulumi.set(__self__, "serial_console_log_blob_uri", serial_console_log_blob_uri)

    @property
    @pulumi.getter(name="consoleScreenshotBlobUri")
    def console_screenshot_blob_uri(self) -> str:
        """
        The console screenshot blob URI.
        """
        return pulumi.get(self, "console_screenshot_blob_uri")

    @property
    @pulumi.getter(name="serialConsoleLogBlobUri")
    def serial_console_log_blob_uri(self) -> str:
        """
        The Linux serial console log blob Uri.
        """
        return pulumi.get(self, "serial_console_log_blob_uri")


@pulumi.output_type
class BootDiagnosticsResponse(dict):
    """
    Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageUri":
            suggest = "storage_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BootDiagnosticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BootDiagnosticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BootDiagnosticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 storage_uri: Optional[str] = None):
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param bool enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :param str storage_uri: Uri of the storage account to use for placing the console output and screenshot.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if storage_uri is not None:
            pulumi.set(__self__, "storage_uri", storage_uri)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether boot diagnostics should be enabled on the Virtual Machine.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> Optional[str]:
        """
        Uri of the storage account to use for placing the console output and screenshot.
        """
        return pulumi.get(self, "storage_uri")


@pulumi.output_type
class DataDiskResponse(dict):
    """
    Describes a data disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 lun: int,
                 name: str,
                 vhd: 'outputs.VirtualHardDiskResponse',
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None):
        """
        Describes a data disk.
        :param str create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param int lun: Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        :param str name: The disk name.
        :param 'VirtualHardDiskResponse' vhd: The virtual hard disk.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'VirtualHardDiskResponse' image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vhd", vhd)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def lun(self) -> int:
        """
        Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def vhd(self) -> 'outputs.VirtualHardDiskResponse':
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class DiagnosticsProfileResponse(dict):
    """
    Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiagnostics":
            suggest = "boot_diagnostics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_diagnostics: Optional['outputs.BootDiagnosticsResponse'] = None):
        """
        Specifies the boot diagnostic settings state. <br><br>Minimum api-version: 2015-06-15.
        :param 'BootDiagnosticsResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")


@pulumi.output_type
class DiskEncryptionSettingsResponse(dict):
    """
    Describes a Encryption Settings for a Disk
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: Optional['outputs.KeyVaultSecretReferenceResponse'] = None,
                 enabled: Optional[bool] = None,
                 key_encryption_key: Optional['outputs.KeyVaultKeyReferenceResponse'] = None):
        """
        Describes a Encryption Settings for a Disk
        :param 'KeyVaultSecretReferenceResponse' disk_encryption_key: Specifies the location of the disk encryption key, which is a Key Vault Secret.
        :param bool enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :param 'KeyVaultKeyReferenceResponse' key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional['outputs.KeyVaultSecretReferenceResponse']:
        """
        Specifies the location of the disk encryption key, which is a Key Vault Secret.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Specifies whether disk encryption should be enabled on the virtual machine.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.KeyVaultKeyReferenceResponse']:
        """
        Specifies the location of the key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class DiskInstanceViewResponse(dict):
    """
    The instance view of the disk.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None):
        """
        The instance view of the disk.
        :param str name: The disk name.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class HardwareProfileResponse(dict):
    """
    Specifies the hardware settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_size: Optional[str] = None):
        """
        Specifies the hardware settings for the virtual machine.
        :param str vm_size: Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region](https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes)
        """
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Specifies the size of the virtual machine. For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json). <br><br> The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:  <br><br> [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes) <br><br> [List all available virtual machine sizes in a region](https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list) <br><br> [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes)
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class ImageReferenceResponse(dict):
    """
    Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
    """
    def __init__(__self__, *,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param str offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param str publisher: The image publisher.
        :param str sku: The image SKU.
        :param str version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InstanceViewStatusResponse(dict):
    """
    Instance view status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceViewStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceViewStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceViewStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 level: Optional[str] = None,
                 message: Optional[str] = None,
                 time: Optional[str] = None):
        """
        Instance view status.
        :param str code: The status code.
        :param str display_status: The short localizable label for the status.
        :param str level: The level code.
        :param str message: The detailed status message, including for alerts and error messages.
        :param str time: The time of the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class KeyVaultKeyReferenceResponse(dict):
    """
    Describes a reference to Key Vault Key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: 'outputs.SubResourceResponse'):
        """
        Describes a reference to Key Vault Key
        :param str key_url: The URL referencing a key encryption key in Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing the key.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        The URL referencing a key encryption key in Key Vault.
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SubResourceResponse':
        """
        The relative URL of the Key Vault containing the key.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultSecretReferenceResponse(dict):
    """
    Describes a reference to Key Vault Secret
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultSecretReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultSecretReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultSecretReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: str,
                 source_vault: 'outputs.SubResourceResponse'):
        """
        Describes a reference to Key Vault Secret
        :param str secret_url: The URL referencing a secret in a Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing the secret.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> str:
        """
        The URL referencing a secret in a Key Vault.
        """
        return pulumi.get(self, "secret_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SubResourceResponse':
        """
        The relative URL of the Key Vault containing the secret.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class LinuxConfigurationResponse(dict):
    """
    Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_password_authentication: Optional[bool] = None,
                 ssh: Optional['outputs.SshConfigurationResponse'] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param bool disable_password_authentication: Specifies whether password authentication should be disabled.
        :param 'SshConfigurationResponse' ssh: Specifies the ssh key configuration for a Linux OS.
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[bool]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.SshConfigurationResponse']:
        """
        Specifies the ssh key configuration for a Linux OS.
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class NetworkInterfaceReferenceResponse(dict):
    """
    Describes a network interface reference.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 primary: Optional[bool] = None):
        """
        Describes a network interface reference.
        :param str id: Resource Id
        :param bool primary: Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Specifies the primary network interface in case the virtual machine has more than 1 network interface.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class NetworkProfileResponse(dict):
    """
    Specifies the network interfaces of the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Optional[Sequence['outputs.NetworkInterfaceReferenceResponse']] = None):
        """
        Specifies the network interfaces of the virtual machine.
        :param Sequence['NetworkInterfaceReferenceResponse'] network_interfaces: Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.NetworkInterfaceReferenceResponse']]:
        """
        Specifies the list of resource Ids for the network interfaces associated with the virtual machine.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class OSDiskResponse(dict):
    """
    Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "encryptionSettings":
            suggest = "encryption_settings"
        elif key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 name: str,
                 vhd: 'outputs.VirtualHardDiskResponse',
                 caching: Optional[str] = None,
                 disk_size_gb: Optional[int] = None,
                 encryption_settings: Optional['outputs.DiskEncryptionSettingsResponse'] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 os_type: Optional[str] = None):
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param str create_option: Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param str name: The disk name.
        :param 'VirtualHardDiskResponse' vhd: The virtual hard disk.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param int disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        :param 'DiskEncryptionSettingsResponse' encryption_settings: Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        :param 'VirtualHardDiskResponse' image: The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vhd", vhd)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machine should be created.<br><br> Possible values are:<br><br> **Attach** \\u2013 This value is used when you are using a specialized disk to create the virtual machine.<br><br> **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def vhd(self) -> 'outputs.VirtualHardDiskResponse':
        """
        The virtual hard disk.
        """
        return pulumi.get(self, "vhd")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> Optional[int]:
        """
        Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. <br><br> This value cannot be larger than 1023 GB
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional['outputs.DiskEncryptionSettingsResponse']:
        """
        Specifies the encryption settings for the OS Disk. <br><br> Minimum api-version: 2015-06-15
        """
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")


@pulumi.output_type
class OSProfileResponse(dict):
    """
    Specifies the operating system settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "customData":
            suggest = "custom_data"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 computer_name: Optional[str] = None,
                 custom_data: Optional[str] = None,
                 linux_configuration: Optional['outputs.LinuxConfigurationResponse'] = None,
                 secrets: Optional[Sequence['outputs.VaultSecretGroupResponse']] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        Specifies the operating system settings for the virtual machine.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        :param str admin_username: Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param str computer_name: Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
        :param str custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param 'LinuxConfigurationResponse' linux_configuration: Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param Sequence['VaultSecretGroupResponse'] secrets: Specifies set of certificates that should be installed onto the virtual machine.
        :param 'WindowsConfigurationResponse' windows_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        Specifies the host OS name of the virtual machine. <br><br> This name cannot be updated after the VM is created. <br><br> **Max-length (Windows):** 15 characters <br><br> **Max-length (Linux):** 64 characters. <br><br> For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions).
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[str]:
        """
        Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. <br><br> For using cloud-init for your VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.LinuxConfigurationResponse']:
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json) <br><br> For running non-endorsed distributions, see [Information for Non-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.VaultSecretGroupResponse']]:
        """
        Specifies set of certificates that should be installed onto the virtual machine.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class PlanResponse(dict):
    """
    Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 product: Optional[str] = None,
                 promotion_code: Optional[str] = None,
                 publisher: Optional[str] = None):
        """
        Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        :param str name: The plan ID.
        :param str product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param str promotion_code: The promotion code.
        :param str publisher: The publisher ID.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The promotion code.
        """
        return pulumi.get(self, "promotion_code")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class SkuResponse(dict):
    """
    Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
    """
    def __init__(__self__, *,
                 capacity: Optional[float] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.
        :param float capacity: Specifies the number of virtual machines in the scale set.
        :param str name: The sku name.
        :param str tier: Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        Specifies the number of virtual machines in the scale set.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Specifies the tier of virtual machines in a scale set.<br /><br /> Possible Values:<br /><br /> **Standard**<br /><br /> **Basic**
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SshConfigurationResponse(dict):
    """
    SSH configuration for Linux based VMs running on Azure
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.SshPublicKeyResponse']] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param Sequence['SshPublicKeyResponse'] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.SshPublicKeyResponse']]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    """
    Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshPublicKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param str key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param str path: Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class StorageProfileResponse(dict):
    """
    Specifies the storage settings for the virtual machine disks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "osDisk":
            suggest = "os_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.DataDiskResponse']] = None,
                 image_reference: Optional['outputs.ImageReferenceResponse'] = None,
                 os_disk: Optional['outputs.OSDiskResponse'] = None):
        """
        Specifies the storage settings for the virtual machine disks.
        :param Sequence['DataDiskResponse'] data_disks: Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        :param 'ImageReferenceResponse' image_reference: Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        :param 'OSDiskResponse' os_disk: Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.DataDiskResponse']]:
        """
        Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageReferenceResponse']:
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.OSDiskResponse']:
        """
        Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
        """
        return pulumi.get(self, "os_disk")


@pulumi.output_type
class SubResourceResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class UpgradePolicyResponse(dict):
    """
    Describes an upgrade policy - automatic or manual.
    """
    def __init__(__self__, *,
                 mode: Optional[str] = None):
        """
        Describes an upgrade policy - automatic or manual.
        :param str mode: Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br /> **Automatic** - All virtual machines in the scale set are  automatically updated at the same time.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class VaultCertificateResponse(dict):
    """
    Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateStore":
            suggest = "certificate_store"
        elif key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_store: Optional[str] = None,
                 certificate_url: Optional[str] = None):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.
        :param str certificate_store: For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        :param str certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        if certificate_store is not None:
            pulumi.set(__self__, "certificate_store", certificate_store)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> Optional[str]:
        """
        For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. <br><br>For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.
        """
        return pulumi.get(self, "certificate_store")

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class VaultSecretGroupResponse(dict):
    """
    Describes a set of certificates which are all in the same Key Vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceVault":
            suggest = "source_vault"
        elif key == "vaultCertificates":
            suggest = "vault_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultSecretGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultSecretGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_vault: Optional['outputs.SubResourceResponse'] = None,
                 vault_certificates: Optional[Sequence['outputs.VaultCertificateResponse']] = None):
        """
        Describes a set of certificates which are all in the same Key Vault.
        :param 'SubResourceResponse' source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param Sequence['VaultCertificateResponse'] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional['outputs.SubResourceResponse']:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[Sequence['outputs.VaultCertificateResponse']]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")


@pulumi.output_type
class VirtualHardDiskResponse(dict):
    """
    Describes the uri of a disk.
    """
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        Describes the uri of a disk.
        :param str uri: Specifies the virtual hard disk's uri.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specifies the virtual hard disk's uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class VirtualMachineAgentInstanceViewResponse(dict):
    """
    The instance view of the VM Agent running on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionHandlers":
            suggest = "extension_handlers"
        elif key == "vmAgentVersion":
            suggest = "vm_agent_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAgentInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAgentInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAgentInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_handlers: Optional[Sequence['outputs.VirtualMachineExtensionHandlerInstanceViewResponse']] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent_version: Optional[str] = None):
        """
        The instance view of the VM Agent running on the virtual machine.
        :param Sequence['VirtualMachineExtensionHandlerInstanceViewResponse'] extension_handlers: The virtual machine extension handler instance view.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param str vm_agent_version: The VM Agent full version.
        """
        if extension_handlers is not None:
            pulumi.set(__self__, "extension_handlers", extension_handlers)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent_version is not None:
            pulumi.set(__self__, "vm_agent_version", vm_agent_version)

    @property
    @pulumi.getter(name="extensionHandlers")
    def extension_handlers(self) -> Optional[Sequence['outputs.VirtualMachineExtensionHandlerInstanceViewResponse']]:
        """
        The virtual machine extension handler instance view.
        """
        return pulumi.get(self, "extension_handlers")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgentVersion")
    def vm_agent_version(self) -> Optional[str]:
        """
        The VM Agent full version.
        """
        return pulumi.get(self, "vm_agent_version")


@pulumi.output_type
class VirtualMachineExtensionHandlerInstanceViewResponse(dict):
    """
    The instance view of a virtual machine extension handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionHandlerInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionHandlerInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionHandlerInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: Optional['outputs.InstanceViewStatusResponse'] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        The instance view of a virtual machine extension handler.
        :param 'InstanceViewStatusResponse' status: The extension handler status.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.InstanceViewStatusResponse']:
        """
        The extension handler status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineExtensionInstanceViewResponse(dict):
    """
    The instance view of a virtual machine extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 substatuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        The instance view of a virtual machine extension.
        :param str name: The virtual machine extension name.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param Sequence['InstanceViewStatusResponse'] substatuses: The resource status information.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if substatuses is not None:
            pulumi.set(__self__, "substatuses", substatuses)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The virtual machine extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def substatuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "substatuses")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineExtensionResponse(dict):
    """
    Describes a Virtual Machine Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "instanceView":
            suggest = "instance_view"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 instance_view: Optional['outputs.VirtualMachineExtensionInstanceViewResponse'] = None,
                 protected_settings: Optional[Any] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes a Virtual Machine Extension.
        :param str id: Resource Id
        :param str location: Resource location
        :param str name: Resource name
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param str type: Resource type
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param str force_update_tag: How the extension handler should be forced to update even if the extension configuration has not changed.
        :param 'VirtualMachineExtensionInstanceViewResponse' instance_view: The virtual machine extension instance view.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param Mapping[str, str] tags: Resource tags
        :param str type_handler_version: Specifies the version of the script handler.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if instance_view is not None:
            pulumi.set(__self__, "instance_view", instance_view)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        How the extension handler should be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter(name="instanceView")
    def instance_view(self) -> Optional['outputs.VirtualMachineExtensionInstanceViewResponse']:
        """
        The virtual machine extension instance view.
        """
        return pulumi.get(self, "instance_view")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineIdentityResponse(dict):
    """
    Identity for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the virtual machine.
        :param str principal_id: The principal id of virtual machine identity.
        :param str tenant_id: The tenant id associated with the virtual machine.
        :param str type: The type of identity used for the virtual machine. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of virtual machine identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the virtual machine.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the virtual machine. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VirtualMachineInstanceViewResponse(dict):
    """
    The instance view of a virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiagnostics":
            suggest = "boot_diagnostics"
        elif key == "platformFaultDomain":
            suggest = "platform_fault_domain"
        elif key == "platformUpdateDomain":
            suggest = "platform_update_domain"
        elif key == "rdpThumbPrint":
            suggest = "rdp_thumb_print"
        elif key == "vmAgent":
            suggest = "vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_diagnostics: Optional['outputs.BootDiagnosticsInstanceViewResponse'] = None,
                 disks: Optional[Sequence['outputs.DiskInstanceViewResponse']] = None,
                 extensions: Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']] = None,
                 platform_fault_domain: Optional[int] = None,
                 platform_update_domain: Optional[int] = None,
                 rdp_thumb_print: Optional[str] = None,
                 statuses: Optional[Sequence['outputs.InstanceViewStatusResponse']] = None,
                 vm_agent: Optional['outputs.VirtualMachineAgentInstanceViewResponse'] = None):
        """
        The instance view of a virtual machine.
        :param 'BootDiagnosticsInstanceViewResponse' boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        :param Sequence['DiskInstanceViewResponse'] disks: The virtual machine disk information.
        :param Sequence['VirtualMachineExtensionInstanceViewResponse'] extensions: The extensions information.
        :param int platform_fault_domain: Specifies the fault domain of the virtual machine.
        :param int platform_update_domain: Specifies the update domain of the virtual machine.
        :param str rdp_thumb_print: The Remote desktop certificate thumbprint.
        :param Sequence['InstanceViewStatusResponse'] statuses: The resource status information.
        :param 'VirtualMachineAgentInstanceViewResponse' vm_agent: The VM Agent running on the virtual machine.
        """
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if platform_fault_domain is not None:
            pulumi.set(__self__, "platform_fault_domain", platform_fault_domain)
        if platform_update_domain is not None:
            pulumi.set(__self__, "platform_update_domain", platform_update_domain)
        if rdp_thumb_print is not None:
            pulumi.set(__self__, "rdp_thumb_print", rdp_thumb_print)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if vm_agent is not None:
            pulumi.set(__self__, "vm_agent", vm_agent)

    @property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional['outputs.BootDiagnosticsInstanceViewResponse']:
        """
        Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. <br><br> You can easily view the output of your console log. <br><br> Azure also enables you to see a screenshot of the VM from the hypervisor.
        """
        return pulumi.get(self, "boot_diagnostics")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.DiskInstanceViewResponse']]:
        """
        The virtual machine disk information.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineExtensionInstanceViewResponse']]:
        """
        The extensions information.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="platformFaultDomain")
    def platform_fault_domain(self) -> Optional[int]:
        """
        Specifies the fault domain of the virtual machine.
        """
        return pulumi.get(self, "platform_fault_domain")

    @property
    @pulumi.getter(name="platformUpdateDomain")
    def platform_update_domain(self) -> Optional[int]:
        """
        Specifies the update domain of the virtual machine.
        """
        return pulumi.get(self, "platform_update_domain")

    @property
    @pulumi.getter(name="rdpThumbPrint")
    def rdp_thumb_print(self) -> Optional[str]:
        """
        The Remote desktop certificate thumbprint.
        """
        return pulumi.get(self, "rdp_thumb_print")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.InstanceViewStatusResponse']]:
        """
        The resource status information.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="vmAgent")
    def vm_agent(self) -> Optional['outputs.VirtualMachineAgentInstanceViewResponse']:
        """
        The VM Agent running on the virtual machine.
        """
        return pulumi.get(self, "vm_agent")


@pulumi.output_type
class VirtualMachineScaleSetExtensionProfileResponse(dict):
    """
    Describes a virtual machine scale set extension profile.
    """
    def __init__(__self__, *,
                 extensions: Optional[Sequence['outputs.VirtualMachineScaleSetExtensionResponse']] = None):
        """
        Describes a virtual machine scale set extension profile.
        :param Sequence['VirtualMachineScaleSetExtensionResponse'] extensions: The virtual machine scale set child extension resources.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetExtensionResponse']]:
        """
        The virtual machine scale set child extension resources.
        """
        return pulumi.get(self, "extensions")


@pulumi.output_type
class VirtualMachineScaleSetExtensionResponse(dict):
    """
    Describes a Virtual Machine Scale Set Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 protected_settings: Optional[Any] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes a Virtual Machine Scale Set Extension.
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param bool auto_upgrade_minor_version: Whether the extension handler should be automatically upgraded across minor versions.
        :param str id: Resource Id
        :param str name: The name of the extension.
        :param Any protected_settings: Json formatted protected settings for the extension.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param str type: The type of the extension handler.
        :param str type_handler_version: The type version of the extension handler.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Whether the extension handler should be automatically upgraded across minor versions.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        Json formatted protected settings for the extension.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extension handler.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        The type version of the extension handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class VirtualMachineScaleSetIPConfigurationResponse(dict):
    """
    Describes a virtual machine scale set network profile's IP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPools":
            suggest = "application_gateway_backend_address_pools"
        elif key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerInboundNatPools":
            suggest = "load_balancer_inbound_nat_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 subnet: 'outputs.ApiEntityReferenceResponse',
                 application_gateway_backend_address_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 load_balancer_inbound_nat_pools: Optional[Sequence['outputs.SubResourceResponse']] = None):
        """
        Describes a virtual machine scale set network profile's IP configuration.
        :param str name: The IP configuration name.
        :param 'ApiEntityReferenceResponse' subnet: The subnet.
        :param Sequence['SubResourceResponse'] application_gateway_backend_address_pools: The application gateway backend address pools.
        :param str id: Resource Id
        :param Sequence['SubResourceResponse'] load_balancer_backend_address_pools: The load balancer backend address pools.
        :param Sequence['SubResourceResponse'] load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subnet", subnet)
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_pools is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_pools", load_balancer_inbound_nat_pools)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The IP configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subnet(self) -> 'outputs.ApiEntityReferenceResponse':
        """
        The subnet.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        The application gateway backend address pools.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        The load balancer backend address pools.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerInboundNatPools")
    def load_balancer_inbound_nat_pools(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        The load balancer inbound nat pools.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_pools")


@pulumi.output_type
class VirtualMachineScaleSetIdentityResponse(dict):
    """
    Identity for the virtual machine scale set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the virtual machine scale set.
        :param str principal_id: The principal id of virtual machine scale set identity.
        :param str tenant_id: The tenant id associated with the virtual machine scale set.
        :param str type: The type of identity used for the virtual machine scale set. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of virtual machine scale set identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id associated with the virtual machine scale set.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the virtual machine scale set. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VirtualMachineScaleSetNetworkConfigurationResponse(dict):
    """
    Describes a virtual machine scale set network profile's network configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.VirtualMachineScaleSetIPConfigurationResponse'],
                 name: str,
                 id: Optional[str] = None,
                 primary: Optional[bool] = None):
        """
        Describes a virtual machine scale set network profile's network configurations.
        :param Sequence['VirtualMachineScaleSetIPConfigurationResponse'] ip_configurations: The virtual machine scale set IP Configuration.
        :param str name: The network configuration name.
        :param str id: Resource Id
        :param bool primary: Whether this is a primary NIC on a virtual machine.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.VirtualMachineScaleSetIPConfigurationResponse']:
        """
        The virtual machine scale set IP Configuration.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The network configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Whether this is a primary NIC on a virtual machine.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class VirtualMachineScaleSetNetworkProfileResponse(dict):
    """
    Describes a virtual machine scale set network profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaceConfigurations":
            suggest = "network_interface_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetNetworkProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetNetworkProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetNetworkProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interface_configurations: Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']] = None):
        """
        Describes a virtual machine scale set network profile.
        :param Sequence['VirtualMachineScaleSetNetworkConfigurationResponse'] network_interface_configurations: The list of network configurations.
        """
        if network_interface_configurations is not None:
            pulumi.set(__self__, "network_interface_configurations", network_interface_configurations)

    @property
    @pulumi.getter(name="networkInterfaceConfigurations")
    def network_interface_configurations(self) -> Optional[Sequence['outputs.VirtualMachineScaleSetNetworkConfigurationResponse']]:
        """
        The list of network configurations.
        """
        return pulumi.get(self, "network_interface_configurations")


@pulumi.output_type
class VirtualMachineScaleSetOSDiskResponse(dict):
    """
    Describes a virtual machine scale set operating system disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "osType":
            suggest = "os_type"
        elif key == "vhdContainers":
            suggest = "vhd_containers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetOSDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetOSDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetOSDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 name: str,
                 caching: Optional[str] = None,
                 image: Optional['outputs.VirtualHardDiskResponse'] = None,
                 os_type: Optional[str] = None,
                 vhd_containers: Optional[Sequence[str]] = None):
        """
        Describes a virtual machine scale set operating system disk.
        :param str create_option: Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        :param str name: The disk name.
        :param str caching: Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        :param 'VirtualHardDiskResponse' image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before using it to attach to the Virtual Machine. If SourceImage is provided, the destination VirtualHardDisk should not exist.
        :param str os_type: This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        :param Sequence[str] vhd_containers: The list of virtual hard disk container uris.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "name", name)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd_containers is not None:
            pulumi.set(__self__, "vhd_containers", vhd_containers)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        Specifies how the virtual machines in the scale set should be created.<br><br> The only allowed value is: **FromImage** \\u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def caching(self) -> Optional[str]:
        """
        Specifies the caching requirements. <br><br> Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br> **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly for Premium storage**
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.VirtualHardDiskResponse']:
        """
        The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before using it to attach to the Virtual Machine. If SourceImage is provided, the destination VirtualHardDisk should not exist.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. <br><br> Possible values are: <br><br> **Windows** <br><br> **Linux**
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="vhdContainers")
    def vhd_containers(self) -> Optional[Sequence[str]]:
        """
        The list of virtual hard disk container uris.
        """
        return pulumi.get(self, "vhd_containers")


@pulumi.output_type
class VirtualMachineScaleSetOSProfileResponse(dict):
    """
    Describes a virtual machine scale set OS profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerNamePrefix":
            suggest = "computer_name_prefix"
        elif key == "customData":
            suggest = "custom_data"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetOSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetOSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetOSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 computer_name_prefix: Optional[str] = None,
                 custom_data: Optional[str] = None,
                 linux_configuration: Optional['outputs.LinuxConfigurationResponse'] = None,
                 secrets: Optional[Sequence['outputs.VaultSecretGroupResponse']] = None,
                 windows_configuration: Optional['outputs.WindowsConfigurationResponse'] = None):
        """
        Describes a virtual machine scale set OS profile.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        :param str admin_username: Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        :param str computer_name_prefix: Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :param str custom_data: A base-64 encoded string of custom data.
        :param 'LinuxConfigurationResponse' linux_configuration: The Linux Configuration of the OS profile.
        :param Sequence['VaultSecretGroupResponse'] secrets: The List of certificates for addition to the VM.
        :param 'WindowsConfigurationResponse' windows_configuration: The Windows Configuration of the OS profile.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#reset-root-password)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters  <br><br><li> For root access to the Linux VM, see [Using root privileges on Linux virtual machines in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)<br><li> For a list of built-in system users on Linux that should not be used in this field, see [Selecting User Names for Linux on Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json)
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[str]:
        """
        Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        """
        return pulumi.get(self, "computer_name_prefix")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[str]:
        """
        A base-64 encoded string of custom data.
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.LinuxConfigurationResponse']:
        """
        The Linux Configuration of the OS profile.
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.VaultSecretGroupResponse']]:
        """
        The List of certificates for addition to the VM.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.WindowsConfigurationResponse']:
        """
        The Windows Configuration of the OS profile.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class VirtualMachineScaleSetStorageProfileResponse(dict):
    """
    Describes a virtual machine scale set storage profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageReference":
            suggest = "image_reference"
        elif key == "osDisk":
            suggest = "os_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_reference: Optional['outputs.ImageReferenceResponse'] = None,
                 os_disk: Optional['outputs.VirtualMachineScaleSetOSDiskResponse'] = None):
        """
        Describes a virtual machine scale set storage profile.
        :param 'ImageReferenceResponse' image_reference: The image reference.
        :param 'VirtualMachineScaleSetOSDiskResponse' os_disk: The OS disk.
        """
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if os_disk is not None:
            pulumi.set(__self__, "os_disk", os_disk)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageReferenceResponse']:
        """
        The image reference.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> Optional['outputs.VirtualMachineScaleSetOSDiskResponse']:
        """
        The OS disk.
        """
        return pulumi.get(self, "os_disk")


@pulumi.output_type
class VirtualMachineScaleSetVMProfileResponse(dict):
    """
    Describes a virtual machine scale set virtual machine profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionProfile":
            suggest = "extension_profile"
        elif key == "networkProfile":
            suggest = "network_profile"
        elif key == "osProfile":
            suggest = "os_profile"
        elif key == "storageProfile":
            suggest = "storage_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetVMProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetVMProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetVMProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_profile: Optional['outputs.VirtualMachineScaleSetExtensionProfileResponse'] = None,
                 network_profile: Optional['outputs.VirtualMachineScaleSetNetworkProfileResponse'] = None,
                 os_profile: Optional['outputs.VirtualMachineScaleSetOSProfileResponse'] = None,
                 storage_profile: Optional['outputs.VirtualMachineScaleSetStorageProfileResponse'] = None):
        """
        Describes a virtual machine scale set virtual machine profile.
        :param 'VirtualMachineScaleSetExtensionProfileResponse' extension_profile: The virtual machine scale set extension profile.
        :param 'VirtualMachineScaleSetNetworkProfileResponse' network_profile: The virtual machine scale set network profile.
        :param 'VirtualMachineScaleSetOSProfileResponse' os_profile: The virtual machine scale set OS profile.
        :param 'VirtualMachineScaleSetStorageProfileResponse' storage_profile: The virtual machine scale set storage profile.
        """
        if extension_profile is not None:
            pulumi.set(__self__, "extension_profile", extension_profile)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)

    @property
    @pulumi.getter(name="extensionProfile")
    def extension_profile(self) -> Optional['outputs.VirtualMachineScaleSetExtensionProfileResponse']:
        """
        The virtual machine scale set extension profile.
        """
        return pulumi.get(self, "extension_profile")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional['outputs.VirtualMachineScaleSetNetworkProfileResponse']:
        """
        The virtual machine scale set network profile.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional['outputs.VirtualMachineScaleSetOSProfileResponse']:
        """
        The virtual machine scale set OS profile.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional['outputs.VirtualMachineScaleSetStorageProfileResponse']:
        """
        The virtual machine scale set storage profile.
        """
        return pulumi.get(self, "storage_profile")


@pulumi.output_type
class WinRMConfigurationResponse(dict):
    """
    Describes Windows Remote Management configuration of the VM
    """
    def __init__(__self__, *,
                 listeners: Optional[Sequence['outputs.WinRMListenerResponse']] = None):
        """
        Describes Windows Remote Management configuration of the VM
        :param Sequence['WinRMListenerResponse'] listeners: The list of Windows Remote Management listeners
        """
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[Sequence['outputs.WinRMListenerResponse']]:
        """
        The list of Windows Remote Management listeners
        """
        return pulumi.get(self, "listeners")


@pulumi.output_type
class WinRMListenerResponse(dict):
    """
    Describes Protocol and thumbprint of Windows Remote Management listener
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WinRMListenerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WinRMListenerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WinRMListenerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_url: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        Describes Protocol and thumbprint of Windows Remote Management listener
        :param str certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        :param str protocol: Specifies the protocol of listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[str]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  "data":"<Base64-encoded-certificate>",<br>  "dataType":"pfx",<br>  "password":"<pfx-file-password>"<br>}
        """
        return pulumi.get(self, "certificate_url")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Specifies the protocol of listener. <br><br> Possible values are: <br>**http** <br><br> **https**
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class WindowsConfigurationResponse(dict):
    """
    Specifies Windows operating system settings on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalUnattendContent":
            suggest = "additional_unattend_content"
        elif key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"
        elif key == "provisionVMAgent":
            suggest = "provision_vm_agent"
        elif key == "timeZone":
            suggest = "time_zone"
        elif key == "winRM":
            suggest = "win_rm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_unattend_content: Optional[Sequence['outputs.AdditionalUnattendContentResponse']] = None,
                 enable_automatic_updates: Optional[bool] = None,
                 provision_vm_agent: Optional[bool] = None,
                 time_zone: Optional[str] = None,
                 win_rm: Optional['outputs.WinRMConfigurationResponse'] = None):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param Sequence['AdditionalUnattendContentResponse'] additional_unattend_content: Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :param bool enable_automatic_updates: Indicates whether virtual machine is enabled for automatic updates.
        :param bool provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        :param str time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time"
        :param 'WinRMConfigurationResponse' win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        if additional_unattend_content is not None:
            pulumi.set(__self__, "additional_unattend_content", additional_unattend_content)
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if win_rm is not None:
            pulumi.set(__self__, "win_rm", win_rm)

    @property
    @pulumi.getter(name="additionalUnattendContent")
    def additional_unattend_content(self) -> Optional[Sequence['outputs.AdditionalUnattendContentResponse']]:
        """
        Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.
        """
        return pulumi.get(self, "additional_unattend_content")

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[bool]:
        """
        Indicates whether virtual machine is enabled for automatic updates.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @property
    @pulumi.getter(name="provisionVMAgent")
    def provision_vm_agent(self) -> Optional[bool]:
        """
        Indicates whether virtual machine agent should be provisioned on the virtual machine. <br><br> When this property is not specified in the request body, default behavior is to set it to true.  This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.
        """
        return pulumi.get(self, "provision_vm_agent")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time"
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="winRM")
    def win_rm(self) -> Optional['outputs.WinRMConfigurationResponse']:
        """
        Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.
        """
        return pulumi.get(self, "win_rm")


